<?php

namespace App\Http\Integrations\GetOnlinetrader\Requests\Membership;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class DeleteCategoryRequest extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::DELETE;

    public function __construct(
        protected readonly string $id,
    ) {
    }
    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/delete-cat/{$this->id}";
    }
}
