<?php

namespace App\Http\Integrations\GetOnlinetrader\Requests\Membership;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class UserCourses extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    public function __construct(
        protected readonly string $userId,
    ) {
    }

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return '/user-courses';
    }

    protected function defaultQuery(): array
    {
        return [
            'userId' => $this->userId,
        ];
    }
}
