<?php

namespace App\Livewire\Admin\Membership;

use App\Models\Category;
use App\Models\Lesson;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.admin')]
class LessonsWithoutCourses extends Component
{
    public $lessons;
    public $categories;

    public function mount(): void
    {
        $this->categories = Category::all();
    }

    public function render()
    {
        $this->lessons = Lesson::whereNull('course_id')->get();

        return view('livewire.admin.membership.lessons-without-courses');
    }
}
