<?php

namespace App\Http\Livewire;

namespace App\Http\Livewire;

use App\Models\Message;
use App\Models\User;
use Livewire\Component;

class FloatingChat extends Component
{
    public $users;
    public $messages = [];
    public $selectedUser = null;
    public $messageText = '';
    public $isOpen = false;
    public $showUserList = true;
    
    protected $listeners = ['echo:chat,NewMessage' => 'refreshMessages'];

    public function mount()
    {
        $this->users = User::where('id', '!=', auth()->id())->get();
    }

    public function toggleChat()
    {
        $this->isOpen = !$this->isOpen;
    }

    public function selectUser($userId)
    {
        $this->selectedUser = $userId;
        $this->showUserList = false;
        $this->loadMessages();
    }

    public function backToUserList()
    {
        $this->selectedUser = null;
        $this->showUserList = true;
        $this->messages = [];
    }

    public function loadMessages()
    {
        if (!$this->selectedUser) {
            return;
        }

        $this->messages = Message::where(function($query) {
            $query->where('from_user', auth()->id())
                  ->where('to_user', $this->selectedUser);
        })->orWhere(function($query) {
            $query->where('from_user', $this->selectedUser)
                  ->where('to_user', auth()->id());
        })->with('fromUser')
          ->orderBy('created_at', 'ASC')
          ->get();

        Message::where('to_user', auth()->id())
              ->where('from_user', $this->selectedUser)
              ->where('read', false)
              ->update(['read' => true]);
    }

    public function sendMessage()
    {
        if (empty($this->messageText)) {
            return;
        }

        $message = Message::create([
            'from_user' => auth()->id(),
            'to_user' => $this->selectedUser,
            'message' => $this->messageText,
        ]);

        $this->messageText = '';
        $this->loadMessages();
        
        broadcast(new NewMessage($message))->toOthers();
    }

    public function refreshMessages()
    {
        if ($this->selectedUser) {
            $this->loadMessages();
        }
    }

    public function render()
    {
        return view('livewire.floating-chat');
    }
}