<?php
namespace App\Livewire\User\Membership;

use App\Exceptions\MembershipException;
use App\Models\Settings;
use App\Services\MembershipService;
use Livewire\Component;
use Throwable;

class Courses extends Component
{
    public $courses;
    public $lessons;
    public $page;
    public $nextPageUrl;
    public $previousPageUrl;

    public function mount(MembershipService $membership, $page)
    {
        $settings = Settings::select('modules')->find(1);
        
        // More robust check for membership module status
        $isMembershipEnabled = $settings 
            && is_array($settings->modules) 
            && ($settings->modules['membership'] === 'true' || $settings->modules['membership'] === true);
        
        if (!$isMembershipEnabled) {
            session()->flash('message', 'Membership module is currently disabled.');
            return redirect()->route('user.dashboard');
        }

        $this->page = $page;
        try {
            $this->lessons = json_decode(json_encode($membership->lessonWithoutCourse()));
            $response = $membership->courses($this->page);
            $this->courses = json_decode(json_encode($response['data']));
            $this->nextPageUrl = $response['next_page_url'];
            $this->previousPageUrl = $response['prev_page_url'];
        } catch (MembershipException $e) {
            session()->flash('message', $e->getMessage());
            return redirect()->route('user.dashboard');
        } catch (Throwable $e) {
            session()->flash('message', $e->getMessage());
            return redirect()->route('user.dashboard');
        }
    }

    public function render()
    {
        $template = Settings::select('theme')->find(1)->theme;
        return view("{$template}.membership.courses")
            ->extends("layouts.{$template}")
            ->title('Courses');
    }
}