<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Signal extends Model
{
    use SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'signals';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'direction',
        'pair',
        'price',
        'tp1',
        'tp2',
        'sl1',
        'buy_stop',
        'sell_stop',
        'buy_limit',
        'sell_limit',
        'symbol',
        'signal_type',
        'entry_price',
        'take_profit',
        'stop_loss',
        'status',
        'published_at',
        'result',
        'result_json'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'price' => 'decimal:2',
        'tp1' => 'decimal:2',
        'tp2' => 'decimal:2',
        'sl1' => 'decimal:2',
        'entry_price' => 'decimal:2',
        'take_profit' => 'decimal:2',
        'stop_loss' => 'decimal:2',
        'published_at' => 'datetime',
        'result_json' => 'array'
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'published_at',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    /**
     * Get the user who created the signal.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the subscriptions for this signal.
     */
    public function subscriptions(): HasMany
    {
        return $this->hasMany(SignalSubscription::class, 'signal_id');
    }
}