 /***********************************************/
    /**   HELPER: FORMAT VOLUME INTO K, M, OR B   **/
    /***********************************************/
    function formatVolume(value, decimals = 2) {
        if (!value || isNaN(value)) return '0';
        // Billions
        if (value >= 1.0e9) {
            return (value / 1.0e9).toFixed(decimals) + 'B';
        }
        // Millions
        if (value >= 1.0e6) {
            return (value / 1.0e6).toFixed(decimals) + 'M';
        }
        // Thousands
        if (value >= 1.0e3) {
            return (value / 1.0e3).toFixed(decimals) + 'K';
        }
        // Less than 1,000
        return value.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }

    /***********************************************/
    /**         FETCH LIVE MARKET DATA (EX)       **/
    /***********************************************/
    const coingeckoAPI = 'https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum,litecoin&vs_currencies=usd&include_24hr_change=true&include_24hr_vol=true&include_24hr_high=true';

    fetch(coingeckoAPI)
        .then(response => response.json())
        .then(data => {
            // ================= BTC =================
            if (data.bitcoin) {
                // Hero Section BTC
                const btcPrice = data.bitcoin.usd.toLocaleString(undefined, { 
                    minimumFractionDigits: 2, 
                    maximumFractionDigits: 2 
                });
                const btcChange = data.bitcoin.usd_24h_change || 0;
                
                // Update hero BTC price
                const heroPriceEl = document.getElementById('btc-price');
                const heroChangeEl = document.getElementById('btc-change');
                heroPriceEl.textContent = `$${btcPrice}`;
                
                // Format 24h change
                if (btcChange >= 0) {
                    heroChangeEl.textContent = `+${btcChange.toFixed(2)}%`;
                    heroPriceEl.classList.remove('text-red-500');
                    heroChangeEl.classList.remove('text-red-500');
                    heroPriceEl.classList.add('text-green-500');
                    heroChangeEl.classList.add('text-green-500');
                } else {
                    heroChangeEl.textContent = `${btcChange.toFixed(2)}%`;
                    heroPriceEl.classList.remove('text-green-500');
                    heroChangeEl.classList.remove('text-green-500');
                    heroPriceEl.classList.add('text-red-500');
                    heroChangeEl.classList.add('text-red-500');
                }

                // Popular Markets - BTC
                const btcMarketPriceEl = document.getElementById('btc-market-price');
                const btcMarketChangeEl = document.getElementById('btc-market-change');
                btcMarketPriceEl.textContent = `$${btcPrice}`;
                if (btcChange >= 0) {
                    btcMarketPriceEl.classList.remove('text-red-500');
                    btcMarketPriceEl.classList.add('text-green-500');
                    btcMarketChangeEl.classList.remove('text-red-500');
                    btcMarketChangeEl.classList.add('text-green-500');
                    btcMarketChangeEl.textContent = `+${btcChange.toFixed(2)}%`;
                } else {
                    btcMarketPriceEl.classList.remove('text-green-500');
                    btcMarketPriceEl.classList.add('text-red-500');
                    btcMarketChangeEl.classList.remove('text-green-500');
                    btcMarketChangeEl.classList.add('text-red-500');
                    btcMarketChangeEl.textContent = `${btcChange.toFixed(2)}%`;
                }

                // BTC 24h volume & high
                const btcVolumeEl = document.getElementById('btc-market-volume');
                const btcHighEl = document.getElementById('btc-market-high');
                if (typeof data.bitcoin.usd_24h_vol !== 'undefined') {
                    const vol = formatVolume(data.bitcoin.usd_24h_vol);  // K/M/B
                    btcVolumeEl.textContent = `24h Volume: $${vol}`;
                }
                if (typeof data.bitcoin.usd_24h_high !== 'undefined') {
                    const high = data.bitcoin.usd_24h_high.toLocaleString(undefined, { 
                        minimumFractionDigits: 2 
                    });
                    btcHighEl.textContent = `24h High: $${high}`;
                }
            }

            // ================= ETH =================
            if (data.ethereum) {
                const ethPrice = data.ethereum.usd.toLocaleString(undefined, { 
                    minimumFractionDigits: 2, 
                    maximumFractionDigits: 2 
                });
                const ethChange = data.ethereum.usd_24h_change || 0;

                const ethMarketPriceEl = document.getElementById('eth-market-price');
                const ethMarketChangeEl = document.getElementById('eth-market-change');
                ethMarketPriceEl.textContent = `$${ethPrice}`;
                
                if (ethChange >= 0) {
                    ethMarketPriceEl.classList.remove('text-red-500');
                    ethMarketChangeEl.classList.remove('text-red-500');
                    ethMarketPriceEl.classList.add('text-green-500');
                    ethMarketChangeEl.classList.add('text-green-500');
                    ethMarketChangeEl.textContent = `+${ethChange.toFixed(2)}%`;
                } else {
                    ethMarketPriceEl.classList.remove('text-green-500');
                    ethMarketChangeEl.classList.remove('text-green-500');
                    ethMarketPriceEl.classList.add('text-red-500');
                    ethMarketChangeEl.classList.add('text-red-500');
                    ethMarketChangeEl.textContent = `${ethChange.toFixed(2)}%`;
                }

                // ETH 24h volume & high
                const ethVolumeEl = document.getElementById('eth-market-volume');
                const ethHighEl = document.getElementById('eth-market-high');
                if (typeof data.ethereum.usd_24h_vol !== 'undefined') {
                    const vol = formatVolume(data.ethereum.usd_24h_vol);
                    ethVolumeEl.textContent = `24h Volume: $${vol}`;
                }
                if (typeof data.ethereum.usd_24h_high !== 'undefined') {
                    const high = data.ethereum.usd_24h_high.toLocaleString(undefined, { 
                        minimumFractionDigits: 2 
                    });
                    ethHighEl.textContent = `24h High: $${high}`;
                }
            }

            // ================= LTC =================
            if (data.litecoin) {
                const ltcPrice = data.litecoin.usd.toLocaleString(undefined, { 
                    minimumFractionDigits: 2, 
                    maximumFractionDigits: 2 
                });
                const ltcChange = data.litecoin.usd_24h_change || 0;

                const ltcMarketPriceEl = document.getElementById('ltc-market-price');
                const ltcMarketChangeEl = document.getElementById('ltc-market-change');
                ltcMarketPriceEl.textContent = `$${ltcPrice}`;

                if (ltcChange >= 0) {
                    ltcMarketPriceEl.classList.remove('text-red-500');
                    ltcMarketChangeEl.classList.remove('text-red-500');
                    ltcMarketPriceEl.classList.add('text-green-500');
                    ltcMarketChangeEl.classList.add('text-green-500');
                    ltcMarketChangeEl.textContent = `+${ltcChange.toFixed(2)}%`;
                } else {
                    ltcMarketPriceEl.classList.remove('text-green-500');
                    ltcMarketChangeEl.classList.remove('text-green-500');
                    ltcMarketPriceEl.classList.add('text-red-500');
                    ltcMarketChangeEl.classList.add('text-red-500');
                    ltcMarketChangeEl.textContent = `${ltcChange.toFixed(2)}%`;
                }

                // LTC 24h volume & high
                const ltcVolumeEl = document.getElementById('ltc-market-volume');
                const ltcHighEl = document.getElementById('ltc-market-high');
                if (typeof data.litecoin.usd_24h_vol !== 'undefined') {
                    const vol = formatVolume(data.litecoin.usd_24h_vol);
                    ltcVolumeEl.textContent = `24h Volume: $${vol}`;
                }
                if (typeof data.litecoin.usd_24h_high !== 'undefined') {
                    const high = data.litecoin.usd_24h_high.toLocaleString(undefined, { 
                        minimumFractionDigits: 2 
                    });
                    ltcHighEl.textContent = `24h High: $${high}`;
                }
            }
        })
        .catch(err => {
            console.error('Error fetching crypto data:', err);
            // Optionally show fallback or error message
        });
        
         // TradingView Widget
    new TradingView.widget({
        "autosize": true,
        "symbol": "BINANCE:BTCUSDT",
        "interval": "D",
        "timezone": "Etc/UTC",
        "theme": "dark",
        "style": "1",
        "locale": "en",
        "enable_publishing": false,
        "hide_legend": true,
        "save_image": false,
        "container_id": "tradingview_widget",
        "backgroundColor": "#0F0A1F",
        "gridColor": "#1A1428"
    });
