@extends('layouts.admin')

@section('title', 'Theme Configuration')

@section('content')
<div class="container-fluid">
    <div class="page-header">
        <h3 class="fw-bold mb-3">Theme Configuration</h3>
        <ul class="breadcrumbs mb-3">
            <li class="nav-home">
                <a href="{{ route('admin.dashboard') }}">
                    <i class="icon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="icon-arrow-right"></i>
            </li>
            <li class="nav-item">
                <a href="#">Settings</a>
            </li>
            <li class="separator">
                <i class="icon-arrow-right"></i>
            </li>
            <li class="nav-item">
                <a href="#">Theme</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <!-- Color Picker Section -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Customize Colors</div>
                    <div class="card-category">Change your application's color scheme</div>
                </div>
                <div class="card-body">
                    <form id="themeForm">
                        @csrf
                        <div class="row">
                            <!-- Primary Colors -->
                            <div class="col-md-6">
                                <h5 class="mb-3">Primary Colors</h5>
                                
                                <div class="form-group">
                                    <label>Main Primary Color</label>
                                    <div class="input-group">
                                        <input type="color" class="form-control form-control-color" 
                                               id="primary" name="primary" 
                                               value="{{ $currentColors['primary']['main'] ?? 'var(--color-primary)' }}">
                                        <input type="text" class="form-control" 
                                               id="primary_text" name="primary_text" 
                                               value="{{ $currentColors['primary']['main'] ?? 'var(--color-primary)' }}"
                                               placeholder="var(--color-primary)">
                                    </div>
                                    <small class="form-text text-muted">Main brand color used for buttons and links</small>
                                </div>

                                <div class="form-group">
                                    <label>Light Primary Color</label>
                                    <div class="input-group">
                                        <input type="color" class="form-control form-control-color" 
                                               id="primary_light" name="primary_light" 
                                               value="{{ $currentColors['primary']['light'] ?? '#3B82F6' }}">
                                        <input type="text" class="form-control" 
                                               id="primary_light_text" name="primary_light_text" 
                                               value="{{ $currentColors['primary']['light'] ?? '#3B82F6' }}"
                                               placeholder="#3B82F6">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Dark Primary Color</label>
                                    <div class="input-group">
                                        <input type="color" class="form-control form-control-color" 
                                               id="primary_dark" name="primary_dark" 
                                               value="{{ $currentColors['primary']['dark'] ?? '#1D4ED8' }}">
                                        <input type="text" class="form-control" 
                                               id="primary_dark_text" name="primary_dark_text" 
                                               value="{{ $currentColors['primary']['dark'] ?? '#1D4ED8' }}"
                                               placeholder="#1D4ED8">
                                    </div>
                                    <small class="form-text text-muted">Used for hover states</small>
                                </div>
                            </div>

                            <!-- Background Colors -->
                            <div class="col-md-6">
                                <h5 class="mb-3">Background Colors</h5>
                                
                                <div class="form-group">
                                    <label>Main Background</label>
                                    <div class="input-group">
                                        <input type="color" class="form-control form-control-color" 
                                               id="background_primary" name="background_primary" 
                                               value="{{ $currentColors['background']['primary'] ?? '#0A0714' }}">
                                        <input type="text" class="form-control" 
                                               id="background_primary_text" name="background_primary_text" 
                                               value="{{ $currentColors['background']['primary'] ?? '#0A0714' }}"
                                               placeholder="#0A0714">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Secondary Background</label>
                                    <div class="input-group">
                                        <input type="color" class="form-control form-control-color" 
                                               id="background_secondary" name="background_secondary" 
                                               value="{{ $currentColors['background']['secondary'] ?? 'var(--color-secondary)' }}">
                                        <input type="text" class="form-control" 
                                               id="background_secondary_text" name="background_secondary_text" 
                                               value="{{ $currentColors['background']['secondary'] ?? 'var(--color-secondary)' }}"
                                               placeholder="var(--color-secondary)">
                                    </div>
                                    <small class="form-text text-muted">Used for cards and modals</small>
                                </div>

                                <div class="form-group">
                                    <label>Input Background</label>
                                    <div class="input-group">
                                        <input type="color" class="form-control form-control-color" 
                                               id="background_tertiary" name="background_tertiary" 
                                               value="{{ $currentColors['background']['tertiary'] ?? 'var(--color-tertiary)' }}">
                                        <input type="text" class="form-control" 
                                               id="background_tertiary_text" name="background_tertiary_text" 
                                               value="{{ $currentColors['background']['tertiary'] ?? 'var(--color-tertiary)' }}"
                                               placeholder="var(--color-tertiary)">
                                    </div>
                                    <small class="form-text text-muted">Used for form inputs</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="button" class="btn btn-primary me-2" id="previewBtn">
                                <i class="fa fa-eye"></i> Preview Changes
                            </button>
                            <button type="submit" class="btn btn-success me-2" id="saveBtn">
                                <i class="fa fa-save"></i> Save Changes
                            </button>
                            <button type="button" class="btn btn-warning me-2" id="resetBtn">
                                <i class="fa fa-undo"></i> Reset to Default
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Color Schemes Section -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Quick Color Schemes</div>
                    <div class="card-category">Apply predefined color schemes</div>
                </div>
                <div class="card-body">
                    <div class="color-schemes">
                        @foreach($availableSchemes as $schemeName => $scheme)
                            <div class="scheme-item mb-3 p-3 border rounded cursor-pointer" 
                                 data-scheme="{{ $schemeName }}"
                                 style="border-color: {{ $scheme['primary'] }}20;">
                                <div class="d-flex align-items-center">
                                    <div class="color-preview me-3">
                                        <div class="color-circle" 
                                             style="background-color: {{ $scheme['primary'] }}; width: 30px; height: 30px; border-radius: 50%;"></div>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 text-capitalize">{{ $schemeName }}</h6>
                                        <small class="text-muted">{{ $scheme['primary'] }}</small>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Preview Section -->
            <div class="card mt-3">
                <div class="card-header">
                    <div class="card-title">Live Preview</div>
                </div>
                <div class="card-body">
                    <div class="preview-area p-3 rounded" style="background: var(--color-background-secondary, #0F0A1F);">
                        <button class="btn btn-primary mb-2" style="background: var(--color-primary, #2563EB);">Primary Button</button>
                        <div class="form-group">
                            <input type="text" class="form-control" placeholder="Sample Input" 
                                   style="background: var(--color-background-tertiary, #1A1428); border-color: var(--color-border-primary, #334155);">
                        </div>
                        <div class="text-primary">Sample Primary Text</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style id="dynamic-theme-styles">
/* Dynamic styles will be injected here */
</style>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sync color picker with text input
    function syncColorInputs(colorId, textId) {
        const colorInput = document.getElementById(colorId);
        const textInput = document.getElementById(textId);
        
        colorInput.addEventListener('change', function() {
            textInput.value = this.value;
        });
        
        textInput.addEventListener('change', function() {
            if (/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/.test(this.value)) {
                colorInput.value = this.value;
            }
        });
    }

    // Initialize color input syncing
    syncColorInputs('primary', 'primary_text');
    syncColorInputs('primary_light', 'primary_light_text');
    syncColorInputs('primary_dark', 'primary_dark_text');
    syncColorInputs('background_primary', 'background_primary_text');
    syncColorInputs('background_secondary', 'background_secondary_text');
    syncColorInputs('background_tertiary', 'background_tertiary_text');

    // Preview functionality
    document.getElementById('previewBtn').addEventListener('click', function() {
        const formData = new FormData(document.getElementById('themeForm'));
        
        fetch('{{ route("admin.theme.preview") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Inject preview CSS
                document.getElementById('dynamic-theme-styles').textContent = data.css;
                showAlert('Preview applied! Changes are temporary until saved.', 'info');
            }
        })
        .catch(error => {
            showAlert('Error applying preview', 'error');
        });
    });

    // Save functionality
    document.getElementById('themeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        fetch('{{ route("admin.theme.update") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update the actual CSS
                document.getElementById('dynamic-theme-styles').textContent = data.css;
                showAlert(data.message, 'success');
            } else {
                showAlert(data.message, 'error');
            }
        })
        .catch(error => {
            showAlert('Error saving changes', 'error');
        });
    });

    // Reset functionality
    document.getElementById('resetBtn').addEventListener('click', function() {
        if (confirm('Are you sure you want to reset to default colors?')) {
            fetch('{{ route("admin.theme.reset") }}', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload(); // Reload to show default values
                } else {
                    showAlert(data.message, 'error');
                }
            });
        }
    });

    // Color scheme selection
    document.querySelectorAll('.scheme-item').forEach(item => {
        item.addEventListener('click', function() {
            const scheme = this.dataset.scheme;
            
            fetch('{{ route("admin.theme.apply-scheme") }}', {
                method: 'POST',
                body: JSON.stringify({ scheme: scheme }),
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload(); // Reload to show new scheme values
                } else {
                    showAlert(data.message, 'error');
                }
            });
        });
    });

    function showAlert(message, type) {
        // You can replace this with your preferred notification system
        const alertClass = type === 'success' ? 'alert-success' : type === 'error' ? 'alert-danger' : 'alert-info';
        const alertHtml = `
            <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;
        
        // Insert at top of page
        document.querySelector('.container-fluid').insertAdjacentHTML('afterbegin', alertHtml);
        
        // Auto dismiss after 5 seconds
        setTimeout(() => {
            const alert = document.querySelector('.alert');
            if (alert) {
                alert.remove();
            }
        }, 5000);
    }
});
</script>
@endpush




