<x-guest-layout>
   <x-slot:title>{{ __('t.register_account') }}</x-slot:title>
   
   <div class="min-h-screen flex flex-col items-center justify-center">
       <div class="w-full max-w-md">
           {{-- Mobile Logo --}}
           <div class="lg:hidden flex flex-col items-center gap-4 mb-8">
               <img 
                   alt="{{ __('t.logo_alt') }}" 
                   src="{{ asset($settings->logo) }}"
                   class="w-[250px] h-auto animate-float" 
               />
               <div class="flex items-center gap-2 text-sm">
                   <div class="w-2 h-2 rounded-full bg-[#F0B90B] animate-pulse"></div>
                   <span class="text-gray-400">{{ __('t.trading_platform') }}</span>
               </div>
           </div>

           <x-language-switcher />
           
           <div class="bg-theme-secondary rounded-2xl p-6 mt-6 border border-gray-800/50">
               {{-- Header --}}
               <div class="text-center mb-8 space-y-4">
                   <div class="bg-gradient-to-b from-[#F0B90B]/10 to-transparent w-20 h-20 rounded-2xl flex items-center justify-center mx-auto">
                       <i class="fas fa-user-plus text-[#F0B90B] text-3xl"></i>
                   </div>
                   <div>
                       <h1 class="text-2xl font-medium bg-gradient-to-r from-white to-gray-300 bg-clip-text text-transparent">
                           {{ __('t.create_account') }}
                       </h1>
                       <p class="text-gray-400 mt-2">{{ __('t.start_trading_journey') }}</p>
                   </div>
               </div>

               @if ($settings->enable_social_login)
                   @include('auth.social')
               @endif

               <form method="POST" action="{{ route('register') }}" class="space-y-6">
                   @csrf
                   <x-honeypot />

                   {{-- Basic Info Fields --}}
                   <div class="grid gap-6">
                       {{-- Username --}}
                       <div x-data="{ inputText: '' }">
                           <label class="text-sm text-gray-400">{{ __('t.username') }}</label>
                           <div class="relative mt-2">
                               <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                   <i class="fas fa-at text-gray-400"></i>
                               </div>
                               <x-form.input 
                                   type="text" 
                                   x-model="inputText"
                                   @keyup="inputText = inputText.replace(/\s/g, '')"
                                   name="username"
                                   required
                                   placeholder="{{ __('t.choose_username') }}"
                                   class="w-full bg-theme-tertiary border border-gray-800/50 rounded-xl pl-12 pr-4 py-3.5 text-gray-100 focus:outline-none focus:border-[#F0B90B] transition-colors" />
                           </div>
                       </div>

                       {{-- Full Name --}}
                       <div>
                           <label class="text-sm text-gray-400 block mb-2">{{ __('t.fullname') }}</label>
                           <div class="relative">
                               <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                   <i data-lucide="user" class="w-5 h-5 text-gray-400"></i>
                               </div>
                               <x-form.input 
                                   type="text"
                                   name="name"
                                   value="{{ old('name') }}"
                                   required
                                   class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B]" />
                           </div>
                       </div>

                       {{-- Email --}}
                       <div>
                           <label class="text-sm text-gray-400 block mb-2">{{ __('t.email_address') }}</label>
                           <div class="relative">
                               <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                   <i data-lucide="mail" class="w-5 h-5 text-gray-400"></i>
                               </div>
                               <x-form.input 
                                   type="email"
                                   name="email"
                                   value="{{ old('email') }}"
                                   required
                                   class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B]" />
                           </div>
                       </div>

                       {{-- Phone --}}
                       <div>
                           <label class="text-sm text-gray-400 block mb-2">{{ __('t.phone_number') }}</label>
                           <div class="relative">
                               <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                   <i data-lucide="phone" class="w-5 h-5 text-gray-400"></i>
                               </div>
                               <x-form.input 
                                   type="tel"
                                   name="phone_number"
                                   value="{{ old('phone_number') }}"
                                   required
                                   class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B]" />
                           </div>
                       </div>
                   </div>

                   {{-- Additional Info Section --}}
                   <div class="space-y-6">
                       {{-- Country & Referral --}}
                       <div>
                           <label class="text-sm text-gray-400 block mb-2">{{ __('t.choose_country') }}</label>
                           <div class="relative">
                               <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                   <i data-lucide="globe" class="w-5 h-5 text-gray-400"></i>
                               </div>
                               <select name="country" 
                                   class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B] appearance-none">
                                   <option selected disabled>{{ __('t.choose_country') }}</option>
                                   @include('auth.countries')
                               </select>
                               <div class="absolute right-4 top-1/2 -translate-y-1/2 pointer-events-none">
                                   <i data-lucide="chevron-down" class="w-5 h-5 text-gray-400"></i>
                               </div>
                           </div>
                           @error('country')
                               <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                           @enderror
                       </div>

                       {{-- Password Section with Strength Meter --}}
                       <div class="space-y-6">
                           <div x-data="{ showPassword: false }">
                               <label class="text-sm text-gray-400">{{ __('t.password') }}</label>
                               <div class="relative mt-2">
                                   <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                       <i class="fas fa-lock text-gray-400"></i>
                                   </div>
                                   <x-form.input 
                                       x-bind:type="showPassword ? 'text' : 'password'"
                                       name="password"
                                       required
                                       placeholder="{{ __('t.password_placeholder') }}"
                                       class="w-full bg-theme-tertiary border border-gray-800/50 rounded-xl pl-12 pr-12 py-3.5 text-gray-100 focus:outline-none focus:border-[#F0B90B] transition-colors" />
                                   <button type="button"
                                       @click="showPassword = !showPassword"
                                       class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-[#F0B90B] transition-colors">
                                       <i class="fas" :class="showPassword ? 'fa-eye-slash' : 'fa-eye'"></i>
                                   </button>
                               </div>

                               {{-- Password Strength Meter --}}
                               <div class="mt-3 grid grid-cols-4 gap-2">
                                   <div class="h-1 password-strength-bar rounded-full transition-all duration-300"></div>
                                   <div class="h-1 password-strength-bar rounded-full transition-all duration-300"></div>
                                   <div class="h-1 password-strength-bar rounded-full transition-all duration-300"></div>
                                   <div class="h-1 password-strength-bar rounded-full transition-all duration-300"></div>
                               </div>
                               <p class="password-hint text-sm text-gray-400 mt-2">{{ __('t.password_hint') }}</p>
                           </div>
                       </div>
                   </div>

                   {{-- Confirm Password --}}
                   <div>
                       <label class="text-sm text-gray-400 block mb-2">{{ __('t.repeat_password') }}</label>
                       <div class="relative">
                           <div class="absolute left-4 top-1/2 -translate-y-1/2">
                               <i data-lucide="check-circle" class="w-5 h-5 text-gray-400"></i>
                           </div>
                           <x-form.input 
                               type="password"
                               name="password_confirmation"
                               required
                               autocomplete="new-password"
                               class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary" />
                       </div>
                   </div>

                   {{-- Referral (Optional) --}}
                   @if (session('ref_by') || true)
                       <div>
                           <label class="text-sm text-gray-400 block mb-2">{{ __('t.referral_id') }}</label>
                           <div class="relative">
                               <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                   <i data-lucide="users" class="w-5 h-5 text-gray-400"></i>
                               </div>
                               <x-form.input 
                                   type="text"
                                   name="refferal"
                                   value="{{ session('ref_by') }}"
                                   placeholder="{{ __('t.referral_optional') }}"
                                   class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B]" />
                           </div>
                       </div>
                   @endif
               </div>

               {{-- Terms & Submit --}}
               <div class="space-y-6 mt-8">
                   @if ($settings->use_terms)
                       <label class="flex items-start gap-3">
                           <input 
                               type="checkbox"
                               required
                               class="mt-1 rounded-lg border-gray-800/50 text-[#F0B90B] focus:ring-[#F0B90B]/20" />
                           <span class="text-sm text-gray-400">
                               {{ __('t.agree_terms_conditions') }} 
                               <a href="" class="text-[#F0B90B] hover:brightness-110 transition-all">
                                   {{ __('t.terms_conditions') }}
                               </a>
                           </span>
                       </label>
                   @endif

                   <button type="submit"
                       class="w-full bg-gradient-to-r from-[#F0B90B] to-[#F0B90B]/80 text-black font-medium px-6 py-3.5 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-2">
                       <span class="indicator-label flex items-center gap-2">
                           <i class="fas fa-user-plus"></i>
                           {{ __('t.create_account') }}
                       </span>
                       <span class="indicator-progress hidden">
                           {{ __('t.please_wait') }}
                           <i class="fas fa-spinner fa-spin"></i>
                       </span>
                   </button>

                   <div class="text-center text-gray-400 text-sm">
                       {{ __('t.already_have_account') }} 
                       <a href="{{ route('login') }}" class="text-[#F0B90B] hover:brightness-110 transition-all font-medium">
                           {{ __('t.sign_in') }}
                       </a>
                   </div>
               </div>
           </form>
       </div>

       {{-- Security Badges --}}
       <div class="flex justify-center gap-6 mt-8">
           <div class="w-3 h-3 rounded-full bg-[#F0B90B]/20 animate-pulse"></div>
           <div class="w-3 h-3 rounded-full bg-[#F0B90B]/20 animate-pulse" style="animation-delay: 0.2s"></div>
           <div class="w-3 h-3 rounded-full bg-[#F0B90B]/20 animate-pulse" style="animation-delay: 0.4s"></div>
       </div>
   </div>
</x-guest-layout>

<script>
    lucide.createIcons();

    // Form submission handling
    document.querySelector('form').addEventListener('submit', function() {
        const button = this.querySelector('button[type="submit"]');
        const label = button.querySelector('.indicator-label');
        const progress = button.querySelector('.indicator-progress');

        label.classList.add('hidden');
        progress.classList.remove('hidden');
    });

    // Password Strength Meter
    document.addEventListener('DOMContentLoaded', () => {
        const passwordInput = document.querySelector('input[name="password"]');
        const strengthBars = document.querySelectorAll('.password-strength-bar');
        const hintText = document.querySelector('.password-hint');

        function checkStrength(password) {
            const criteria = [
                password.length >= 8,
                /[a-z]/.test(password),
                /[A-Z]/.test(password),
                /\d/.test(password),
                /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(password)
            ];

            const strength = criteria.filter(Boolean).length;
            
            strengthBars.forEach((bar, i) => {
                if (i < strength) {
                    bar.classList.remove('bg-theme-tertiary');
                    bar.classList.add('bg-[#F0B90B]');
                } else {
                    bar.classList.remove('bg-[#F0B90B]');
                    bar.classList.add('bg-theme-tertiary');
                }
            });

            if (password.length === 0) {
                hintText.textContent = '{{ __("t.password_hint") }}';
                hintText.classList.remove('text-red-400', 'text-[#F0B90B]');
            } else if (strength < 5) {
                const missing = [
                    '{{ __("t.password_strength.min_length") }}',
                    '{{ __("t.password_strength.lowercase") }}',
                    '{{ __("t.password_strength.uppercase") }}',
                    '{{ __("t.password_strength.number") }}',
                    '{{ __("t.password_strength.symbol") }}'
                ].filter((_, i) => !criteria[i]);

                hintText.textContent = `{{ __("t.password_strength.missing") }} ${missing.join(', ')}`;
                hintText.classList.add('text-red-400');
                hintText.classList.remove('text-[#F0B90B]');
            } else {
                hintText.textContent = '{{ __("t.password_strength.strong") }}';
                hintText.classList.add('text-[#F0B90B]');
                hintText.classList.remove('text-red-400');
            }
        }

        passwordInput.addEventListener('input', (e) => checkStrength(e.target.value));
    });
</script>





