@props([
    'type' => 'text',
    'label' => null,
    'placeholder' => '',
    'error' => null,
    'icon' => null,
    'iconPosition' => 'left', // left, right
    'size' => 'md', // sm, md, lg
    'variant' => 'default' // default, success, error
])

@php
$inputClasses = 'w-full rounded-xl transition-all duration-200 focus:outline-none focus:ring-2 placeholder:text-text-muted';

// Size classes
$sizeClasses = [
    'sm' => 'px-3 py-2 text-sm',
    'md' => 'px-4 py-3 text-base',
    'lg' => 'px-6 py-4 text-lg'
];

// Variant classes
$variantClasses = [
    'default' => 'bg-background-tertiary border border-border-primary text-text-primary focus:border-primary focus:ring-primary-20',
    'success' => 'bg-background-tertiary border border-success text-text-primary focus:border-success focus:ring-success/20',
    'error' => 'bg-background-tertiary border border-error text-text-primary focus:border-error focus:ring-error/20'
];

$iconClasses = $icon ? ($iconPosition === 'left' ? 'pl-12' : 'pr-12') : '';

$finalClasses = $inputClasses . ' ' . ($sizeClasses[$size] ?? $sizeClasses['md']) . ' ' . ($variantClasses[$variant] ?? $variantClasses['default']) . ' ' . $iconClasses;
@endphp

<div class="w-full">
    @if($label)
        <label class="block text-sm font-medium text-text-secondary mb-2">
            {{ $label }}
        </label>
    @endif
    
    <div class="relative">
        @if($icon && $iconPosition === 'left')
            <div class="absolute left-4 top-1/2 -translate-y-1/2 text-text-muted">
                {!! $icon !!}
            </div>
        @endif
        
        <input 
            type="{{ $type }}"
            placeholder="{{ $placeholder }}"
            {{ $attributes->merge(['class' => $finalClasses]) }}
        />
        
        @if($icon && $iconPosition === 'right')
            <div class="absolute right-4 top-1/2 -translate-y-1/2 text-text-muted">
                {!! $icon !!}
            </div>
        @endif
    </div>
    
    @if($error)
        <p class="mt-1 text-sm text-error">{{ $error }}</p>
    @endif
</div>




