<style>
    .gu-mirror {
        margin: 0 !important;
        opacity: .8;
        position: fixed !important;
        z-index: 9999 !important
    }

    .gu-hide {
        display: none !important
    }

    .gu-unselectable {
        -webkit-user-select: none !important;
        -moz-user-select: none !important;
        -ms-user-select: none !important;
        user-select: none !important
    }

    .gu-transit {
        opacity: .2
    }

    .flatpickr-calendar {
        -webkit-animation: none;
        animation: none;
        background: transparent;
        background: #fff;
        border: 0;
        border-radius: 5px;
        -webkit-box-shadow: 1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, .08);
        box-shadow: 1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, .08);
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        direction: ltr;
        display: none;
        font-size: 14px;
        line-height: 24px;
        opacity: 0;
        padding: 0;
        position: absolute;
        text-align: center;
        -ms-touch-action: manipulation;
        touch-action: manipulation;
        visibility: hidden;
        width: 307.875px
    }

    .flatpickr-calendar.inline,
    .flatpickr-calendar.open {
        max-height: 640px;
        opacity: 1;
        visibility: visible
    }

    .flatpickr-calendar.open {
        display: inline-block;
        z-index: 99999
    }

    .flatpickr-calendar.animate.open {
        -webkit-animation: fpFadeInDown .3s cubic-bezier(.23, 1, .32, 1);
        animation: fpFadeInDown .3s cubic-bezier(.23, 1, .32, 1)
    }

    .flatpickr-calendar.inline {
        display: block;
        position: relative;
        top: 2px
    }

    .flatpickr-calendar.static {
        position: absolute;
        top: calc(100% + 2px)
    }

    .flatpickr-calendar.static.open {
        display: block;
        z-index: 999
    }

    .flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7) {
        -webkit-box-shadow: none !important;
        box-shadow: none !important
    }

    .flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1) {
        -webkit-box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;
        box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6
    }

    .flatpickr-calendar .hasTime .dayContainer,
    .flatpickr-calendar .hasWeeks .dayContainer {
        border-bottom: 0;
        border-bottom-left-radius: 0;
        border-bottom-right-radius: 0
    }

    .flatpickr-calendar .hasWeeks .dayContainer {
        border-left: 0
    }

    .flatpickr-calendar.hasTime .flatpickr-time {
        border-top: 1px solid #e6e6e6;
        height: 40px
    }

    .flatpickr-calendar.noCalendar.hasTime .flatpickr-time {
        height: auto
    }

    .flatpickr-calendar:after,
    .flatpickr-calendar:before {
        border: solid transparent;
        content: "";
        display: block;
        height: 0;
        left: 22px;
        pointer-events: none;
        position: absolute;
        width: 0
    }

    .flatpickr-calendar.arrowRight:after,
    .flatpickr-calendar.arrowRight:before,
    .flatpickr-calendar.rightMost:after,
    .flatpickr-calendar.rightMost:before {
        left: auto;
        right: 22px
    }

    .flatpickr-calendar.arrowCenter:after,
    .flatpickr-calendar.arrowCenter:before {
        left: 50%;
        right: 50%
    }

    .flatpickr-calendar:before {
        border-width: 5px;
        margin: 0 -5px
    }

    .flatpickr-calendar:after {
        border-width: 4px;
        margin: 0 -4px
    }

    .flatpickr-calendar.arrowTop:after,
    .flatpickr-calendar.arrowTop:before {
        bottom: 100%
    }

    .flatpickr-calendar.arrowTop:before {
        border-bottom-color: #e6e6e6
    }

    .flatpickr-calendar.arrowTop:after {
        border-bottom-color: #fff
    }

    .flatpickr-calendar.arrowBottom:after,
    .flatpickr-calendar.arrowBottom:before {
        top: 100%
    }

    .flatpickr-calendar.arrowBottom:before {
        border-top-color: #e6e6e6
    }

    .flatpickr-calendar.arrowBottom:after {
        border-top-color: #fff
    }

    .flatpickr-calendar:focus {
        outline: 0
    }

    .flatpickr-wrapper {
        display: inline-block;
        position: relative
    }

    .flatpickr-months {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex
    }

    .flatpickr-months .flatpickr-month {
        -webkit-box-flex: 1;
        background: transparent;
        -webkit-flex: 1;
        -ms-flex: 1;
        flex: 1;
        line-height: 1;
        overflow: hidden;
        position: relative;
        text-align: center
    }

    .flatpickr-months .flatpickr-month,
    .flatpickr-months .flatpickr-next-month,
    .flatpickr-months .flatpickr-prev-month {
        fill: rgba(0, 0, 0, .9);
        color: rgba(0, 0, 0, .9);
        height: 34px;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none
    }

    .flatpickr-months .flatpickr-next-month,
    .flatpickr-months .flatpickr-prev-month {
        cursor: pointer;
        padding: 10px;
        position: absolute;
        text-decoration: none;
        top: 0;
        z-index: 3
    }

    .flatpickr-months .flatpickr-next-month.flatpickr-disabled,
    .flatpickr-months .flatpickr-prev-month.flatpickr-disabled {
        display: none
    }

    .flatpickr-months .flatpickr-next-month i,
    .flatpickr-months .flatpickr-prev-month i {
        position: relative
    }

    .flatpickr-months .flatpickr-next-month.flatpickr-prev-month,
    .flatpickr-months .flatpickr-prev-month.flatpickr-prev-month {
        left: 0
    }

    .flatpickr-months .flatpickr-next-month.flatpickr-next-month,
    .flatpickr-months .flatpickr-prev-month.flatpickr-next-month {
        right: 0
    }

    .flatpickr-months .flatpickr-next-month:hover,
    .flatpickr-months .flatpickr-prev-month:hover {
        color: #959ea9
    }

    .flatpickr-months .flatpickr-next-month:hover svg,
    .flatpickr-months .flatpickr-prev-month:hover svg {
        fill: #f64747
    }

    .flatpickr-months .flatpickr-next-month svg,
    .flatpickr-months .flatpickr-prev-month svg {
        height: 14px;
        width: 14px
    }

    .flatpickr-months .flatpickr-next-month svg path,
    .flatpickr-months .flatpickr-prev-month svg path {
        fill: inherit;
        -webkit-transition: fill .1s;
        transition: fill .1s
    }

    .numInputWrapper {
        height: auto;
        position: relative
    }

    .numInputWrapper input,
    .numInputWrapper span {
        display: inline-block
    }

    .numInputWrapper input {
        width: 100%
    }

    .numInputWrapper input::-ms-clear {
        display: none
    }

    .numInputWrapper input::-webkit-inner-spin-button,
    .numInputWrapper input::-webkit-outer-spin-button {
        -webkit-appearance: none;
        margin: 0
    }

    .numInputWrapper span {
        border: 1px solid rgba(57, 57, 57, .15);
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        cursor: pointer;
        height: 50%;
        line-height: 50%;
        opacity: 0;
        padding: 0 4px 0 2px;
        position: absolute;
        right: 0;
        width: 14px
    }

    .numInputWrapper span:hover {
        background: rgba(0, 0, 0, .1)
    }

    .numInputWrapper span:active {
        background: rgba(0, 0, 0, .2)
    }

    .numInputWrapper span:after {
        content: "";
        display: block;
        position: absolute
    }

    .numInputWrapper span.arrowUp {
        border-bottom: 0;
        top: 0
    }

    .numInputWrapper span.arrowUp:after {
        border-bottom: 4px solid rgba(57, 57, 57, .6);
        border-left: 4px solid transparent;
        border-right: 4px solid transparent;
        top: 26%
    }

    .numInputWrapper span.arrowDown {
        top: 50%
    }

    .numInputWrapper span.arrowDown:after {
        border-left: 4px solid transparent;
        border-right: 4px solid transparent;
        border-top: 4px solid rgba(57, 57, 57, .6);
        top: 40%
    }

    .numInputWrapper span svg {
        height: auto;
        width: inherit
    }

    .numInputWrapper span svg path {
        fill: rgba(0, 0, 0, .5)
    }

    .numInputWrapper:hover {
        background: rgba(0, 0, 0, .05)
    }

    .numInputWrapper:hover span {
        opacity: 1
    }

    .flatpickr-current-month {
        color: inherit;
        display: inline-block;
        font-size: 135%;
        font-weight: 300;
        height: 34px;
        left: 12.5%;
        line-height: inherit;
        line-height: 1;
        padding: 7.48px 0 0;
        position: absolute;
        text-align: center;
        -webkit-transform: translateZ(0);
        transform: translateZ(0);
        width: 75%
    }

    .flatpickr-current-month span.cur-month {
        color: inherit;
        display: inline-block;
        font-family: inherit;
        font-weight: 700;
        margin-left: .5ch;
        padding: 0
    }

    .flatpickr-current-month span.cur-month:hover {
        background: rgba(0, 0, 0, .05)
    }

    .flatpickr-current-month .numInputWrapper {
        display: inline-block;
        width: 6ch;
        width: 7ch\0
    }

    .flatpickr-current-month .numInputWrapper span.arrowUp:after {
        border-bottom-color: rgba(0, 0, 0, .9)
    }

    .flatpickr-current-month .numInputWrapper span.arrowDown:after {
        border-top-color: rgba(0, 0, 0, .9)
    }

    .flatpickr-current-month input.cur-year {
        -webkit-appearance: textfield;
        -moz-appearance: textfield;
        appearance: textfield;
        background: transparent;
        border: 0;
        border-radius: 0;
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        color: inherit;
        cursor: text;
        display: inline-block;
        font-family: inherit;
        font-size: inherit;
        font-weight: 300;
        height: auto;
        line-height: inherit;
        margin: 0;
        padding: 0 0 0 .5ch;
        vertical-align: initial
    }

    .flatpickr-current-month input.cur-year:focus {
        outline: 0
    }

    .flatpickr-current-month input.cur-year[disabled],
    .flatpickr-current-month input.cur-year[disabled]:hover {
        background: transparent;
        color: rgba(0, 0, 0, .5);
        font-size: 100%;
        pointer-events: none
    }

    .flatpickr-current-month .flatpickr-monthDropdown-months {
        appearance: menulist;
        -webkit-appearance: menulist;
        -moz-appearance: menulist;
        background: transparent;
        border: none;
        border-radius: 0;
        box-sizing: border-box;
        -webkit-box-sizing: border-box;
        color: inherit;
        cursor: pointer;
        font-family: inherit;
        font-size: inherit;
        font-weight: 300;
        height: auto;
        line-height: inherit;
        margin: -1px 0 0;
        outline: none;
        padding: 0 0 0 .5ch;
        position: relative;
        vertical-align: initial;
        width: auto
    }

    .flatpickr-current-month .flatpickr-monthDropdown-months:active,
    .flatpickr-current-month .flatpickr-monthDropdown-months:focus {
        outline: none
    }

    .flatpickr-current-month .flatpickr-monthDropdown-months:hover {
        background: rgba(0, 0, 0, .05)
    }

    .flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month {
        background-color: transparent;
        outline: none;
        padding: 0
    }

    .flatpickr-weekdays {
        -webkit-box-align: center;
        -ms-flex-align: center;
        -webkit-align-items: center;
        align-items: center;
        background: transparent;
        height: 28px;
        overflow: hidden;
        text-align: center;
        width: 100%
    }

    .flatpickr-weekdays,
    .flatpickr-weekdays .flatpickr-weekdaycontainer {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex
    }

    .flatpickr-weekdays .flatpickr-weekdaycontainer,
    span.flatpickr-weekday {
        -webkit-box-flex: 1;
        -webkit-flex: 1;
        -ms-flex: 1;
        flex: 1
    }

    span.flatpickr-weekday {
        background: transparent;
        color: rgba(0, 0, 0, .54);
        cursor: default;
        display: block;
        font-size: 90%;
        font-weight: bolder;
        line-height: 1;
        margin: 0;
        text-align: center
    }

    .dayContainer,
    .flatpickr-weeks {
        padding: 1px 0 0
    }

    .flatpickr-days {
        -webkit-box-align: start;
        -ms-flex-align: start;
        -webkit-align-items: flex-start;
        align-items: flex-start;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        overflow: hidden;
        position: relative;
        width: 307.875px
    }

    .flatpickr-days:focus {
        outline: 0
    }

    .dayContainer {
        -ms-flex-pack: justify;
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        display: inline-block;
        display: -ms-flexbox;
        display: -webkit-box;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-wrap: wrap;
        flex-wrap: wrap;
        -ms-flex-wrap: wrap;
        -webkit-justify-content: space-around;
        justify-content: space-around;
        max-width: 307.875px;
        min-width: 307.875px;
        opacity: 1;
        outline: 0;
        padding: 0;
        text-align: left;
        -webkit-transform: translateZ(0);
        transform: translateZ(0);
        width: 307.875px
    }

    .dayContainer+.dayContainer {
        -webkit-box-shadow: -1px 0 0 #e6e6e6;
        box-shadow: -1px 0 0 #e6e6e6
    }

    .flatpickr-day {
        -ms-flex-preferred-size: 14.2857143%;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        background: none;
        border: 1px solid transparent;
        border-radius: 150px;
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        color: #393939;
        cursor: pointer;
        display: inline-block;
        -webkit-flex-basis: 14.2857143%;
        flex-basis: 14.2857143%;
        font-weight: 400;
        height: 39px;
        -webkit-justify-content: center;
        justify-content: center;
        line-height: 39px;
        margin: 0;
        max-width: 39px;
        position: relative;
        text-align: center;
        width: 14.2857143%
    }

    .flatpickr-day.inRange,
    .flatpickr-day.nextMonthDay.inRange,
    .flatpickr-day.nextMonthDay.today.inRange,
    .flatpickr-day.nextMonthDay:focus,
    .flatpickr-day.nextMonthDay:hover,
    .flatpickr-day.prevMonthDay.inRange,
    .flatpickr-day.prevMonthDay.today.inRange,
    .flatpickr-day.prevMonthDay:focus,
    .flatpickr-day.prevMonthDay:hover,
    .flatpickr-day.today.inRange,
    .flatpickr-day:focus,
    .flatpickr-day:hover {
        background: #e6e6e6;
        border-color: #e6e6e6;
        cursor: pointer;
        outline: 0
    }

    .flatpickr-day.today {
        border-color: #959ea9
    }

    .flatpickr-day.today:focus,
    .flatpickr-day.today:hover {
        background: #959ea9;
        border-color: #959ea9;
        color: #fff
    }

    .flatpickr-day.endRange,
    .flatpickr-day.endRange.inRange,
    .flatpickr-day.endRange.nextMonthDay,
    .flatpickr-day.endRange.prevMonthDay,
    .flatpickr-day.endRange:focus,
    .flatpickr-day.endRange:hover,
    .flatpickr-day.selected,
    .flatpickr-day.selected.inRange,
    .flatpickr-day.selected.nextMonthDay,
    .flatpickr-day.selected.prevMonthDay,
    .flatpickr-day.selected:focus,
    .flatpickr-day.selected:hover,
    .flatpickr-day.startRange,
    .flatpickr-day.startRange.inRange,
    .flatpickr-day.startRange.nextMonthDay,
    .flatpickr-day.startRange.prevMonthDay,
    .flatpickr-day.startRange:focus,
    .flatpickr-day.startRange:hover {
        background: #569ff7;
        border-color: #569ff7;
        -webkit-box-shadow: none;
        box-shadow: none;
        color: #fff
    }

    .flatpickr-day.endRange.startRange,
    .flatpickr-day.selected.startRange,
    .flatpickr-day.startRange.startRange {
        border-radius: 50px 0 0 50px
    }

    .flatpickr-day.endRange.endRange,
    .flatpickr-day.selected.endRange,
    .flatpickr-day.startRange.endRange {
        border-radius: 0 50px 50px 0
    }

    .flatpickr-day.endRange.startRange+.endRange:not(:nth-child(7n+1)),
    .flatpickr-day.selected.startRange+.endRange:not(:nth-child(7n+1)),
    .flatpickr-day.startRange.startRange+.endRange:not(:nth-child(7n+1)) {
        -webkit-box-shadow: -10px 0 0 #569ff7;
        box-shadow: -10px 0 0 #569ff7
    }

    .flatpickr-day.endRange.startRange.endRange,
    .flatpickr-day.selected.startRange.endRange,
    .flatpickr-day.startRange.startRange.endRange {
        border-radius: 50px
    }

    .flatpickr-day.inRange {
        border-radius: 0;
        -webkit-box-shadow: -5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;
        box-shadow: -5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6
    }

    .flatpickr-day.flatpickr-disabled,
    .flatpickr-day.flatpickr-disabled:hover {
        color: rgba(57, 57, 57, .1);
        cursor: not-allowed
    }

    .flatpickr-day.week.selected {
        border-radius: 0;
        -webkit-box-shadow: -5px 0 0 #569ff7, 5px 0 0 #569ff7;
        box-shadow: -5px 0 0 #569ff7, 5px 0 0 #569ff7
    }

    .flatpickr-day.hidden {
        visibility: hidden
    }

    .rangeMode .flatpickr-day {
        margin-top: 1px
    }

    .flatpickr-weekwrapper {
        float: left
    }

    .flatpickr-weekwrapper .flatpickr-weeks {
        -webkit-box-shadow: 1px 0 0 #e6e6e6;
        box-shadow: 1px 0 0 #e6e6e6;
        padding: 0 12px
    }

    .flatpickr-weekwrapper .flatpickr-weekday {
        float: none;
        line-height: 28px;
        width: 100%
    }

    .flatpickr-weekwrapper span.flatpickr-day,
    .flatpickr-weekwrapper span.flatpickr-day:hover {
        background: transparent;
        border: none;
        color: rgba(57, 57, 57, .3);
        cursor: default;
        display: block;
        max-width: none;
        width: 100%
    }

    .flatpickr-innerContainer {
        display: block;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        overflow: hidden
    }

    .flatpickr-innerContainer,
    .flatpickr-rContainer {
        -webkit-box-sizing: border-box;
        box-sizing: border-box
    }

    .flatpickr-rContainer {
        display: inline-block;
        padding: 0
    }

    .flatpickr-time {
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        display: block;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        height: 0;
        line-height: 40px;
        max-height: 40px;
        outline: 0;
        overflow: hidden;
        text-align: center
    }

    .flatpickr-time:after {
        clear: both;
        content: "";
        display: table
    }

    .flatpickr-time .numInputWrapper {
        -webkit-box-flex: 1;
        -webkit-flex: 1;
        -ms-flex: 1;
        flex: 1;
        float: left;
        height: 40px;
        width: 40%
    }

    .flatpickr-time .numInputWrapper span.arrowUp:after {
        border-bottom-color: #393939
    }

    .flatpickr-time .numInputWrapper span.arrowDown:after {
        border-top-color: #393939
    }

    .flatpickr-time.hasSeconds .numInputWrapper {
        width: 26%
    }

    .flatpickr-time.time24hr .numInputWrapper {
        width: 49%
    }

    .flatpickr-time input {
        -webkit-appearance: textfield;
        -moz-appearance: textfield;
        appearance: textfield;
        background: transparent;
        border: 0;
        border-radius: 0;
        -webkit-box-shadow: none;
        box-shadow: none;
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        color: #393939;
        font-size: 14px;
        height: inherit;
        line-height: inherit;
        margin: 0;
        padding: 0;
        position: relative;
        text-align: center
    }

    .flatpickr-time input.flatpickr-hour {
        font-weight: 700
    }

    .flatpickr-time input.flatpickr-minute,
    .flatpickr-time input.flatpickr-second {
        font-weight: 400
    }

    .flatpickr-time input:focus {
        border: 0;
        outline: 0
    }

    .flatpickr-time .flatpickr-am-pm,
    .flatpickr-time .flatpickr-time-separator {
        -ms-flex-item-align: center;
        -webkit-align-self: center;
        align-self: center;
        color: #393939;
        float: left;
        font-weight: 700;
        height: inherit;
        line-height: inherit;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        width: 2%
    }

    .flatpickr-time .flatpickr-am-pm {
        cursor: pointer;
        font-weight: 400;
        outline: 0;
        text-align: center;
        width: 18%
    }

    .flatpickr-time .flatpickr-am-pm:focus,
    .flatpickr-time .flatpickr-am-pm:hover,
    .flatpickr-time input:focus,
    .flatpickr-time input:hover {
        background: #eee
    }

    .flatpickr-input[readonly] {
        cursor: pointer
    }

    @-webkit-keyframes fpFadeInDown {
        0% {
            opacity: 0;
            -webkit-transform: translate3d(0, -20px, 0);
            transform: translate3d(0, -20px, 0)
        }

        to {
            opacity: 1;
            -webkit-transform: translateZ(0);
            transform: translateZ(0)
        }
    }

    @keyframes fpFadeInDown {
        0% {
            opacity: 0;
            -webkit-transform: translate3d(0, -20px, 0);
            transform: translate3d(0, -20px, 0)
        }

        to {
            opacity: 1;
            -webkit-transform: translateZ(0);
            transform: translateZ(0)
        }
    }

    .fc-not-allowed,
    .fc-not-allowed .fc-event {
        cursor: not-allowed
    }

    .fc-unselectable {
        -webkit-touch-callout: none;
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none
    }

    .fc {
        display: flex;
        flex-direction: column;
        font-size: 1em
    }

    .fc,
    .fc *,
    .fc :after,
    .fc :before {
        box-sizing: border-box
    }

    .fc table {
        border-collapse: collapse;
        border-spacing: 0;
        font-size: 1em
    }

    .fc th {
        text-align: center
    }

    .fc td,
    .fc th {
        padding: 0;
        vertical-align: top
    }

    .fc a[data-navlink] {
        cursor: pointer
    }

    .fc a[data-navlink]:hover {
        text-decoration: underline
    }

    .fc-direction-ltr {
        direction: ltr;
        text-align: left
    }

    .fc-direction-rtl {
        direction: rtl;
        text-align: right
    }

    .fc-theme-standard td,
    .fc-theme-standard th {
        border: 1px solid #ddd;
        border: 1px solid var(--fc-border-color, #ddd)
    }

    .fc-liquid-hack td,
    .fc-liquid-hack th {
        position: relative
    }

    @font-face {
        font-family: fcicons;
        font-style: normal;
        font-weight: 400;
        src: url("data:application/x-font-ttf;charset=utf-8;base64,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") format("truetype")
    }

    .fc-icon {
        speak: none;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        display: inline-block;
        font-family: fcicons !important;
        font-style: normal;
        font-variant: normal;
        font-weight: 400;
        height: 1em;
        line-height: 1;
        text-align: center;
        text-transform: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        width: 1em
    }

    .fc-icon-chevron-left:before {
        content: "\e900"
    }

    .fc-icon-chevron-right:before {
        content: "\e901"
    }

    .fc-icon-chevrons-left:before {
        content: "\e902"
    }

    .fc-icon-chevrons-right:before {
        content: "\e903"
    }

    .fc-icon-minus-square:before {
        content: "\e904"
    }

    .fc-icon-plus-square:before {
        content: "\e905"
    }

    .fc-icon-x:before {
        content: "\e906"
    }

    .fc .fc-button {
        border-radius: 0;
        font-family: inherit;
        font-size: inherit;
        line-height: inherit;
        margin: 0;
        overflow: visible;
        text-transform: none
    }

    .fc .fc-button:focus {
        outline: 1px dotted;
        outline: 5px auto -webkit-focus-ring-color
    }

    .fc .fc-button {
        -webkit-appearance: button
    }

    .fc .fc-button:not(:disabled) {
        cursor: pointer
    }

    .fc .fc-button::-moz-focus-inner {
        border-style: none;
        padding: 0
    }

    .fc .fc-button {
        background-color: transparent;
        border: 1px solid transparent;
        border-radius: .25em;
        display: inline-block;
        font-size: 1em;
        font-weight: 400;
        line-height: 1.5;
        padding: .4em .65em;
        text-align: center;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        vertical-align: middle
    }

    .fc .fc-button:hover {
        text-decoration: none
    }

    .fc .fc-button:focus {
        box-shadow: 0 0 0 .2rem rgba(44, 62, 80, .25);
        outline: 0
    }

    .fc .fc-button:disabled {
        opacity: .65
    }

    .fc .fc-button-primary {
        background-color: #2c3e50;
        background-color: var(--fc-button-bg-color, #2c3e50);
        border-color: #2c3e50;
        border-color: var(--fc-button-border-color, #2c3e50);
        color: #fff;
        color: var(--fc-button-text-color, #fff)
    }

    .fc .fc-button-primary:hover {
        background-color: #1e2b37;
        background-color: var(--fc-button-hover-bg-color, #1e2b37);
        border-color: #1a252f;
        border-color: var(--fc-button-hover-border-color, #1a252f);
        color: #fff;
        color: var(--fc-button-text-color, #fff)
    }

    .fc .fc-button-primary:disabled {
        background-color: #2c3e50;
        background-color: var(--fc-button-bg-color, #2c3e50);
        border-color: #2c3e50;
        border-color: var(--fc-button-border-color, #2c3e50);
        color: #fff;
        color: var(--fc-button-text-color, #fff)
    }

    .fc .fc-button-primary:focus {
        box-shadow: 0 0 0 .2rem rgba(76, 91, 106, .5)
    }

    .fc .fc-button-primary:not(:disabled).fc-button-active,
    .fc .fc-button-primary:not(:disabled):active {
        background-color: #1a252f;
        background-color: var(--fc-button-active-bg-color, #1a252f);
        border-color: #151e27;
        border-color: var(--fc-button-active-border-color, #151e27);
        color: #fff;
        color: var(--fc-button-text-color, #fff)
    }

    .fc .fc-button-primary:not(:disabled).fc-button-active:focus,
    .fc .fc-button-primary:not(:disabled):active:focus {
        box-shadow: 0 0 0 .2rem rgba(76, 91, 106, .5)
    }

    .fc .fc-button .fc-icon {
        font-size: 1.5em;
        vertical-align: middle
    }

    .fc .fc-button-group {
        display: inline-flex;
        position: relative;
        vertical-align: middle
    }

    .fc .fc-button-group>.fc-button {
        flex: 1 1 auto;
        position: relative
    }

    .fc .fc-button-group>.fc-button.fc-button-active,
    .fc .fc-button-group>.fc-button:active,
    .fc .fc-button-group>.fc-button:focus,
    .fc .fc-button-group>.fc-button:hover {
        z-index: 1
    }

    .fc-direction-ltr .fc-button-group>.fc-button:not(:first-child) {
        border-bottom-left-radius: 0;
        border-top-left-radius: 0;
        margin-left: -1px
    }

    .fc-direction-ltr .fc-button-group>.fc-button:not(:last-child) {
        border-bottom-right-radius: 0;
        border-top-right-radius: 0
    }

    .fc-direction-rtl .fc-button-group>.fc-button:not(:first-child) {
        border-bottom-right-radius: 0;
        border-top-right-radius: 0;
        margin-right: -1px
    }

    .fc-direction-rtl .fc-button-group>.fc-button:not(:last-child) {
        border-bottom-left-radius: 0;
        border-top-left-radius: 0
    }

    .fc .fc-toolbar {
        align-items: center;
        display: flex;
        justify-content: space-between
    }

    .fc .fc-toolbar.fc-header-toolbar {
        margin-bottom: 1.5em
    }

    .fc .fc-toolbar.fc-footer-toolbar {
        margin-top: 1.5em
    }

    .fc .fc-toolbar-title {
        font-size: 1.75em;
        margin: 0
    }

    .fc-direction-ltr .fc-toolbar>*>:not(:first-child) {
        margin-left: .75em
    }

    .fc-direction-rtl .fc-toolbar>*>:not(:first-child) {
        margin-right: .75em
    }

    .fc-direction-rtl .fc-toolbar-ltr {
        flex-direction: row-reverse
    }

    .fc .fc-scroller {
        -webkit-overflow-scrolling: touch;
        position: relative
    }

    .fc .fc-scroller-liquid {
        height: 100%
    }

    .fc .fc-scroller-liquid-absolute {
        bottom: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc .fc-scroller-harness {
        direction: ltr;
        overflow: hidden;
        position: relative
    }

    .fc .fc-scroller-harness-liquid {
        height: 100%
    }

    .fc-direction-rtl .fc-scroller-harness>.fc-scroller {
        direction: rtl
    }

    .fc-theme-standard .fc-scrollgrid {
        border: 1px solid #ddd;
        border: 1px solid var(--fc-border-color, #ddd)
    }

    .fc .fc-scrollgrid,
    .fc .fc-scrollgrid table {
        table-layout: fixed;
        width: 100%
    }

    .fc .fc-scrollgrid table {
        border-left-style: hidden;
        border-right-style: hidden;
        border-top-style: hidden
    }

    .fc .fc-scrollgrid {
        border-bottom-width: 0;
        border-collapse: separate;
        border-right-width: 0
    }

    .fc .fc-scrollgrid-liquid {
        height: 100%
    }

    .fc .fc-scrollgrid-section,
    .fc .fc-scrollgrid-section table,
    .fc .fc-scrollgrid-section>td {
        height: 1px
    }

    .fc .fc-scrollgrid-section-liquid>td {
        height: 100%
    }

    .fc .fc-scrollgrid-section>* {
        border-left-width: 0;
        border-top-width: 0
    }

    .fc .fc-scrollgrid-section-footer>*,
    .fc .fc-scrollgrid-section-header>* {
        border-bottom-width: 0
    }

    .fc .fc-scrollgrid-section-body table,
    .fc .fc-scrollgrid-section-footer table {
        border-bottom-style: hidden
    }

    .fc .fc-scrollgrid-section-sticky>* {
        background: #fff;
        background: var(--fc-page-bg-color, #fff);
        position: sticky;
        z-index: 3
    }

    .fc .fc-scrollgrid-section-header.fc-scrollgrid-section-sticky>* {
        top: 0
    }

    .fc .fc-scrollgrid-section-footer.fc-scrollgrid-section-sticky>* {
        bottom: 0
    }

    .fc .fc-scrollgrid-sticky-shim {
        height: 1px;
        margin-bottom: -1px
    }

    .fc-sticky {
        position: sticky
    }

    .fc .fc-view-harness {
        flex-grow: 1;
        position: relative
    }

    .fc .fc-view-harness-active>.fc-view {
        bottom: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc .fc-col-header-cell-cushion {
        display: inline-block;
        padding: 2px 4px
    }

    .fc .fc-bg-event,
    .fc .fc-highlight,
    .fc .fc-non-business {
        bottom: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc .fc-non-business {
        background: hsla(0, 0%, 84%, .3);
        background: var(--fc-non-business-color, hsla(0, 0%, 84%, .3))
    }

    .fc .fc-bg-event {
        background: #8fdf82;
        background: var(--fc-bg-event-color, #8fdf82);
        opacity: .3;
        opacity: var(--fc-bg-event-opacity, .3)
    }

    .fc .fc-bg-event .fc-event-title {
        font-size: .85em;
        font-size: var(--fc-small-font-size, .85em);
        font-style: italic;
        margin: .5em
    }

    .fc .fc-highlight {
        background: rgba(188, 232, 241, .3);
        background: var(--fc-highlight-color, rgba(188, 232, 241, .3))
    }

    .fc .fc-cell-shaded,
    .fc .fc-day-disabled {
        background: hsla(0, 0%, 82%, .3);
        background: var(--fc-neutral-bg-color, hsla(0, 0%, 82%, .3))
    }

    a.fc-event,
    a.fc-event:hover {
        text-decoration: none
    }

    .fc-event.fc-event-draggable,
    .fc-event[href] {
        cursor: pointer
    }

    .fc-event .fc-event-main {
        position: relative;
        z-index: 2
    }

    .fc-event-dragging:not(.fc-event-selected) {
        opacity: .75
    }

    .fc-event-dragging.fc-event-selected {
        box-shadow: 0 2px 7px rgba(0, 0, 0, .3)
    }

    .fc-event .fc-event-resizer {
        display: none;
        position: absolute;
        z-index: 4
    }

    .fc-event-selected .fc-event-resizer,
    .fc-event:hover .fc-event-resizer {
        display: block
    }

    .fc-event-selected .fc-event-resizer {
        background: #fff;
        background: var(--fc-page-bg-color, #fff);
        border-color: inherit;
        border-radius: 4px;
        border-radius: calc(var(--fc-event-resizer-dot-total-width, 8px)/2);
        border-style: solid;
        border-width: 1px;
        border-width: var(--fc-event-resizer-dot-border-width, 1px);
        height: 8px;
        height: var(--fc-event-resizer-dot-total-width, 8px);
        width: 8px;
        width: var(--fc-event-resizer-dot-total-width, 8px)
    }

    .fc-event-selected .fc-event-resizer:before {
        bottom: -20px;
        content: "";
        left: -20px;
        position: absolute;
        right: -20px;
        top: -20px
    }

    .fc-event-selected,
    .fc-event:focus {
        box-shadow: 0 2px 5px rgba(0, 0, 0, .2)
    }

    .fc-event-selected:before,
    .fc-event:focus:before {
        bottom: 0;
        content: "";
        left: 0;
        position: absolute;
        right: 0;
        top: 0;
        z-index: 3
    }

    .fc-event-selected:after,
    .fc-event:focus:after {
        background: rgba(0, 0, 0, .25);
        background: var(--fc-event-selected-overlay-color, rgba(0, 0, 0, .25));
        bottom: -1px;
        content: "";
        left: -1px;
        position: absolute;
        right: -1px;
        top: -1px;
        z-index: 1
    }

    .fc-h-event {
        background-color: #3788d8;
        background-color: var(--fc-event-bg-color, #3788d8);
        border: 1px solid #3788d8;
        border: 1px solid var(--fc-event-border-color, #3788d8);
        display: block
    }

    .fc-h-event .fc-event-main {
        color: #fff;
        color: var(--fc-event-text-color, #fff)
    }

    .fc-h-event .fc-event-main-frame {
        display: flex
    }

    .fc-h-event .fc-event-time {
        max-width: 100%;
        overflow: hidden
    }

    .fc-h-event .fc-event-title-container {
        flex-grow: 1;
        flex-shrink: 1;
        min-width: 0
    }

    .fc-h-event .fc-event-title {
        display: inline-block;
        left: 0;
        max-width: 100%;
        overflow: hidden;
        right: 0;
        vertical-align: top
    }

    .fc-h-event.fc-event-selected:before {
        bottom: -10px;
        top: -10px
    }

    .fc-direction-ltr .fc-daygrid-block-event:not(.fc-event-start),
    .fc-direction-rtl .fc-daygrid-block-event:not(.fc-event-end) {
        border-bottom-left-radius: 0;
        border-left-width: 0;
        border-top-left-radius: 0
    }

    .fc-direction-ltr .fc-daygrid-block-event:not(.fc-event-end),
    .fc-direction-rtl .fc-daygrid-block-event:not(.fc-event-start) {
        border-bottom-right-radius: 0;
        border-right-width: 0;
        border-top-right-radius: 0
    }

    .fc-h-event:not(.fc-event-selected) .fc-event-resizer {
        bottom: 0;
        top: 0;
        width: 8px;
        width: var(--fc-event-resizer-thickness, 8px)
    }

    .fc-direction-ltr .fc-h-event:not(.fc-event-selected) .fc-event-resizer-start,
    .fc-direction-rtl .fc-h-event:not(.fc-event-selected) .fc-event-resizer-end {
        cursor: w-resize;
        left: -4px;
        left: calc(var(--fc-event-resizer-thickness, 8px)*-.5)
    }

    .fc-direction-ltr .fc-h-event:not(.fc-event-selected) .fc-event-resizer-end,
    .fc-direction-rtl .fc-h-event:not(.fc-event-selected) .fc-event-resizer-start {
        cursor: e-resize;
        right: -4px;
        right: calc(var(--fc-event-resizer-thickness, 8px)*-.5)
    }

    .fc-h-event.fc-event-selected .fc-event-resizer {
        margin-top: -4px;
        margin-top: calc(var(--fc-event-resizer-dot-total-width, 8px)*-.5);
        top: 50%
    }

    .fc-direction-ltr .fc-h-event.fc-event-selected .fc-event-resizer-start,
    .fc-direction-rtl .fc-h-event.fc-event-selected .fc-event-resizer-end {
        left: -4px;
        left: calc(var(--fc-event-resizer-dot-total-width, 8px)*-.5)
    }

    .fc-direction-ltr .fc-h-event.fc-event-selected .fc-event-resizer-end,
    .fc-direction-rtl .fc-h-event.fc-event-selected .fc-event-resizer-start {
        right: -4px;
        right: calc(var(--fc-event-resizer-dot-total-width, 8px)*-.5)
    }

    .fc .fc-popover {
        box-shadow: 0 2px 6px rgba(0, 0, 0, .15);
        position: absolute;
        z-index: 9999
    }

    .fc .fc-popover-header {
        align-items: center;
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        padding: 3px 4px
    }

    .fc .fc-popover-title {
        margin: 0 2px
    }

    .fc .fc-popover-close {
        cursor: pointer;
        font-size: 1.1em;
        opacity: .65
    }

    .fc-theme-standard .fc-popover {
        background: #fff;
        background: var(--fc-page-bg-color, #fff);
        border: 1px solid #ddd;
        border: 1px solid var(--fc-border-color, #ddd)
    }

    .fc-theme-standard .fc-popover-header {
        background: hsla(0, 0%, 82%, .3);
        background: var(--fc-neutral-bg-color, hsla(0, 0%, 82%, .3))
    }

    :root {
        --fc-list-event-dot-width: 10px;
        --fc-list-event-hover-bg-color: #f5f5f5
    }

    .fc-theme-standard .fc-list {
        border: 1px solid #ddd;
        border: 1px solid var(--fc-border-color, #ddd)
    }

    .fc .fc-list-empty {
        align-items: center;
        background-color: hsla(0, 0%, 82%, .3);
        background-color: var(--fc-neutral-bg-color, hsla(0, 0%, 82%, .3));
        display: flex;
        height: 100%;
        justify-content: center
    }

    .fc .fc-list-empty-cushion {
        margin: 5em 0
    }

    .fc .fc-list-table {
        border-style: hidden;
        width: 100%
    }

    .fc .fc-list-table tr>* {
        border-left: 0;
        border-right: 0
    }

    .fc .fc-list-sticky .fc-list-day>* {
        background: #fff;
        background: var(--fc-page-bg-color, #fff);
        position: sticky;
        top: 0
    }

    .fc .fc-list-table thead {
        left: -10000px;
        position: absolute
    }

    .fc .fc-list-table tbody>tr:first-child th {
        border-top: 0
    }

    .fc .fc-list-table th {
        padding: 0
    }

    .fc .fc-list-day-cushion,
    .fc .fc-list-table td {
        padding: 8px 14px
    }

    .fc .fc-list-day-cushion:after {
        clear: both;
        content: "";
        display: table
    }

    .fc-theme-standard .fc-list-day-cushion {
        background-color: hsla(0, 0%, 82%, .3);
        background-color: var(--fc-neutral-bg-color, hsla(0, 0%, 82%, .3))
    }

    .fc-direction-ltr .fc-list-day-text,
    .fc-direction-rtl .fc-list-day-side-text {
        float: left
    }

    .fc-direction-ltr .fc-list-day-side-text,
    .fc-direction-rtl .fc-list-day-text {
        float: right
    }

    .fc-direction-ltr .fc-list-table .fc-list-event-graphic {
        padding-right: 0
    }

    .fc-direction-rtl .fc-list-table .fc-list-event-graphic {
        padding-left: 0
    }

    .fc .fc-list-event.fc-event-forced-url {
        cursor: pointer
    }

    .fc .fc-list-event:hover td {
        background-color: #f5f5f5;
        background-color: var(--fc-list-event-hover-bg-color, #f5f5f5)
    }

    .fc .fc-list-event-graphic,
    .fc .fc-list-event-time {
        white-space: nowrap;
        width: 1px
    }

    .fc .fc-list-event-dot {
        border: 5px solid #3788d8;
        border: calc(var(--fc-list-event-dot-width, 10px)/2) solid var(--fc-event-border-color, #3788d8);
        border-radius: 5px;
        border-radius: calc(var(--fc-list-event-dot-width, 10px)/2);
        box-sizing: content-box;
        display: inline-block;
        height: 0;
        width: 0
    }

    .fc .fc-list-event-title a {
        color: inherit;
        text-decoration: none
    }

    .fc .fc-list-event.fc-event-forced-url:hover a {
        text-decoration: underline
    }

    :root {
        --fc-daygrid-event-dot-width: 8px
    }

    .fc-daygrid-day-events:after,
    .fc-daygrid-day-events:before,
    .fc-daygrid-day-frame:after,
    .fc-daygrid-day-frame:before,
    .fc-daygrid-event-harness:after,
    .fc-daygrid-event-harness:before {
        clear: both;
        content: "";
        display: table
    }

    .fc .fc-daygrid-body {
        position: relative;
        z-index: 1
    }

    .fc .fc-daygrid-day.fc-day-today {
        background-color: rgba(255, 220, 40, .15);
        background-color: var(--fc-today-bg-color, rgba(255, 220, 40, .15))
    }

    .fc .fc-daygrid-day-frame {
        min-height: 100%;
        position: relative
    }

    .fc .fc-daygrid-day-top {
        display: flex;
        flex-direction: row-reverse
    }

    .fc .fc-day-other .fc-daygrid-day-top {
        opacity: .3
    }

    .fc .fc-daygrid-day-number {
        padding: 4px;
        position: relative;
        z-index: 4
    }

    .fc .fc-daygrid-day-events {
        margin-top: 1px
    }

    .fc .fc-daygrid-body-balanced .fc-daygrid-day-events {
        left: 0;
        position: absolute;
        right: 0
    }

    .fc .fc-daygrid-body-unbalanced .fc-daygrid-day-events {
        min-height: 2em;
        position: relative
    }

    .fc .fc-daygrid-body-natural .fc-daygrid-day-events {
        margin-bottom: 1em
    }

    .fc .fc-daygrid-event-harness {
        position: relative
    }

    .fc .fc-daygrid-event-harness-abs {
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc .fc-daygrid-bg-harness {
        bottom: 0;
        position: absolute;
        top: 0
    }

    .fc .fc-daygrid-day-bg .fc-non-business {
        z-index: 1
    }

    .fc .fc-daygrid-day-bg .fc-bg-event {
        z-index: 2
    }

    .fc .fc-daygrid-day-bg .fc-highlight {
        z-index: 3
    }

    .fc .fc-daygrid-event {
        margin-top: 1px;
        z-index: 6
    }

    .fc .fc-daygrid-event.fc-event-mirror {
        z-index: 7
    }

    .fc .fc-daygrid-day-bottom {
        font-size: .85em;
        padding: 2px 3px 0
    }

    .fc .fc-daygrid-day-bottom:before {
        clear: both;
        content: "";
        display: table
    }

    .fc .fc-daygrid-more-link {
        cursor: pointer;
        position: relative;
        z-index: 4
    }

    .fc .fc-daygrid-week-number {
        background-color: hsla(0, 0%, 82%, .3);
        background-color: var(--fc-neutral-bg-color, hsla(0, 0%, 82%, .3));
        color: grey;
        color: var(--fc-neutral-text-color, grey);
        min-width: 1.5em;
        padding: 2px;
        position: absolute;
        text-align: center;
        top: 0;
        z-index: 5
    }

    .fc .fc-more-popover .fc-popover-body {
        min-width: 220px;
        padding: 10px
    }

    .fc-direction-ltr .fc-daygrid-event.fc-event-start,
    .fc-direction-rtl .fc-daygrid-event.fc-event-end {
        margin-left: 2px
    }

    .fc-direction-ltr .fc-daygrid-event.fc-event-end,
    .fc-direction-rtl .fc-daygrid-event.fc-event-start {
        margin-right: 2px
    }

    .fc-direction-ltr .fc-daygrid-week-number {
        border-radius: 0 0 3px 0;
        left: 0
    }

    .fc-direction-rtl .fc-daygrid-week-number {
        border-radius: 0 0 0 3px;
        right: 0
    }

    .fc-liquid-hack .fc-daygrid-day-frame {
        position: static
    }

    .fc-daygrid-event {
        border-radius: 3px;
        font-size: .85em;
        font-size: var(--fc-small-font-size, .85em);
        position: relative;
        white-space: nowrap
    }

    .fc-daygrid-block-event .fc-event-time {
        font-weight: 700
    }

    .fc-daygrid-block-event .fc-event-time,
    .fc-daygrid-block-event .fc-event-title {
        padding: 1px
    }

    .fc-daygrid-dot-event {
        align-items: center;
        display: flex;
        padding: 2px 0
    }

    .fc-daygrid-dot-event .fc-event-title {
        flex-grow: 1;
        flex-shrink: 1;
        font-weight: 700;
        min-width: 0;
        overflow: hidden
    }

    .fc-daygrid-dot-event.fc-event-mirror,
    .fc-daygrid-dot-event:hover {
        background: rgba(0, 0, 0, .1)
    }

    .fc-daygrid-dot-event.fc-event-selected:before {
        bottom: -10px;
        top: -10px
    }

    .fc-daygrid-event-dot {
        border: 4px solid #3788d8;
        border: calc(var(--fc-daygrid-event-dot-width, 8px)/2) solid var(--fc-event-border-color, #3788d8);
        border-radius: 4px;
        border-radius: calc(var(--fc-daygrid-event-dot-width, 8px)/2);
        box-sizing: content-box;
        height: 0;
        margin: 0 4px;
        width: 0
    }

    .fc-direction-ltr .fc-daygrid-event .fc-event-time {
        margin-right: 3px
    }

    .fc-direction-rtl .fc-daygrid-event .fc-event-time {
        margin-left: 3px
    }

    .fc-v-event {
        background-color: #3788d8;
        background-color: var(--fc-event-bg-color, #3788d8);
        border: 1px solid #3788d8;
        border: 1px solid var(--fc-event-border-color, #3788d8);
        display: block
    }

    .fc-v-event .fc-event-main {
        color: #fff;
        color: var(--fc-event-text-color, #fff);
        height: 100%
    }

    .fc-v-event .fc-event-main-frame {
        display: flex;
        flex-direction: column;
        height: 100%
    }

    .fc-v-event .fc-event-time {
        flex-grow: 0;
        flex-shrink: 0;
        max-height: 100%;
        overflow: hidden
    }

    .fc-v-event .fc-event-title-container {
        flex-grow: 1;
        flex-shrink: 1;
        min-height: 0
    }

    .fc-v-event .fc-event-title {
        bottom: 0;
        max-height: 100%;
        overflow: hidden;
        top: 0
    }

    .fc-v-event:not(.fc-event-start) {
        border-top-left-radius: 0;
        border-top-right-radius: 0;
        border-top-width: 0
    }

    .fc-v-event:not(.fc-event-end) {
        border-bottom-left-radius: 0;
        border-bottom-right-radius: 0;
        border-bottom-width: 0
    }

    .fc-v-event.fc-event-selected:before {
        left: -10px;
        right: -10px
    }

    .fc-v-event .fc-event-resizer-start {
        cursor: n-resize
    }

    .fc-v-event .fc-event-resizer-end {
        cursor: s-resize
    }

    .fc-v-event:not(.fc-event-selected) .fc-event-resizer {
        height: 8px;
        height: var(--fc-event-resizer-thickness, 8px);
        left: 0;
        right: 0
    }

    .fc-v-event:not(.fc-event-selected) .fc-event-resizer-start {
        top: -4px;
        top: calc(var(--fc-event-resizer-thickness, 8px)/-2)
    }

    .fc-v-event:not(.fc-event-selected) .fc-event-resizer-end {
        bottom: -4px;
        bottom: calc(var(--fc-event-resizer-thickness, 8px)/-2)
    }

    .fc-v-event.fc-event-selected .fc-event-resizer {
        left: 50%;
        margin-left: -4px;
        margin-left: calc(var(--fc-event-resizer-dot-total-width, 8px)/-2)
    }

    .fc-v-event.fc-event-selected .fc-event-resizer-start {
        top: -4px;
        top: calc(var(--fc-event-resizer-dot-total-width, 8px)/-2)
    }

    .fc-v-event.fc-event-selected .fc-event-resizer-end {
        bottom: -4px;
        bottom: calc(var(--fc-event-resizer-dot-total-width, 8px)/-2)
    }

    .fc .fc-timegrid .fc-daygrid-body {
        z-index: 2
    }

    .fc .fc-timegrid-divider {
        padding: 0 0 2px
    }

    .fc .fc-timegrid-body {
        min-height: 100%;
        position: relative;
        z-index: 1
    }

    .fc .fc-timegrid-axis-chunk {
        position: relative
    }

    .fc .fc-timegrid-axis-chunk>table,
    .fc .fc-timegrid-slots {
        position: relative;
        z-index: 1
    }

    .fc .fc-timegrid-slot {
        border-bottom: 0;
        height: 1.5em
    }

    .fc .fc-timegrid-slot:empty:before {
        content: "\00a0"
    }

    .fc .fc-timegrid-slot-minor {
        border-top-style: dotted
    }

    .fc .fc-timegrid-slot-label-cushion {
        display: inline-block;
        white-space: nowrap
    }

    .fc .fc-timegrid-slot-label {
        vertical-align: middle
    }

    .fc .fc-timegrid-axis-cushion,
    .fc .fc-timegrid-slot-label-cushion {
        padding: 0 4px
    }

    .fc .fc-timegrid-axis-frame-liquid {
        height: 100%
    }

    .fc .fc-timegrid-axis-frame {
        align-items: center;
        display: flex;
        justify-content: flex-end;
        overflow: hidden
    }

    .fc .fc-timegrid-axis-cushion {
        flex-shrink: 0;
        max-width: 60px
    }

    .fc-direction-ltr .fc-timegrid-slot-label-frame {
        text-align: right
    }

    .fc-direction-rtl .fc-timegrid-slot-label-frame {
        text-align: left
    }

    .fc-liquid-hack .fc-timegrid-axis-frame-liquid {
        bottom: 0;
        height: auto;
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc .fc-timegrid-col.fc-day-today {
        background-color: rgba(255, 220, 40, .15);
        background-color: var(--fc-today-bg-color, rgba(255, 220, 40, .15))
    }

    .fc .fc-timegrid-col-frame {
        min-height: 100%;
        position: relative
    }

    .fc-media-screen.fc-liquid-hack .fc-timegrid-col-frame {
        bottom: 0;
        height: auto;
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc-media-screen .fc-timegrid-cols {
        bottom: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc-media-screen .fc-timegrid-cols>table {
        height: 100%
    }

    .fc-media-screen .fc-timegrid-col-bg,
    .fc-media-screen .fc-timegrid-col-events,
    .fc-media-screen .fc-timegrid-now-indicator-container {
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc .fc-timegrid-col-bg {
        z-index: 2
    }

    .fc .fc-timegrid-col-bg .fc-non-business {
        z-index: 1
    }

    .fc .fc-timegrid-col-bg .fc-bg-event {
        z-index: 2
    }

    .fc .fc-timegrid-col-bg .fc-highlight {
        z-index: 3
    }

    .fc .fc-timegrid-bg-harness {
        left: 0;
        position: absolute;
        right: 0
    }

    .fc .fc-timegrid-col-events {
        z-index: 3
    }

    .fc .fc-timegrid-now-indicator-container {
        bottom: 0;
        overflow: hidden
    }

    .fc-direction-ltr .fc-timegrid-col-events {
        margin: 0 2.5% 0 2px
    }

    .fc-direction-rtl .fc-timegrid-col-events {
        margin: 0 2px 0 2.5%
    }

    .fc-timegrid-event-harness {
        position: absolute
    }

    .fc-timegrid-event-harness>.fc-timegrid-event {
        bottom: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: 0
    }

    .fc-timegrid-event-harness-inset .fc-timegrid-event,
    .fc-timegrid-event.fc-event-mirror,
    .fc-timegrid-more-link {
        box-shadow: 0 0 0 1px #fff;
        box-shadow: 0 0 0 1px var(--fc-page-bg-color, #fff)
    }

    .fc-timegrid-event,
    .fc-timegrid-more-link {
        border-radius: 3px;
        font-size: .85em;
        font-size: var(--fc-small-font-size, .85em)
    }

    .fc-timegrid-event {
        margin-bottom: 1px
    }

    .fc-timegrid-event .fc-event-main {
        padding: 1px 1px 0
    }

    .fc-timegrid-event .fc-event-time {
        font-size: .85em;
        font-size: var(--fc-small-font-size, .85em);
        margin-bottom: 1px;
        white-space: nowrap
    }

    .fc-timegrid-event-short .fc-event-main-frame {
        flex-direction: row;
        overflow: hidden
    }

    .fc-timegrid-event-short .fc-event-time:after {
        content: "\00a0-\00a0"
    }

    .fc-timegrid-event-short .fc-event-title {
        font-size: .85em;
        font-size: var(--fc-small-font-size, .85em)
    }

    .fc-timegrid-more-link {
        background: #d0d0d0;
        background: var(--fc-more-link-bg-color, #d0d0d0);
        color: inherit;
        color: var(--fc-more-link-text-color, inherit);
        cursor: pointer;
        margin-bottom: 1px;
        position: absolute;
        z-index: 9999
    }

    .fc-timegrid-more-link-inner {
        padding: 3px 2px;
        top: 0
    }

    .fc-direction-ltr .fc-timegrid-more-link {
        right: 0
    }

    .fc-direction-rtl .fc-timegrid-more-link {
        left: 0
    }

    .fc .fc-timegrid-now-indicator-line {
        border-color: red;
        border-color: var(--fc-now-indicator-color, red);
        border-style: solid;
        border-width: 1px 0 0;
        left: 0;
        position: absolute;
        right: 0;
        z-index: 4
    }

    .fc .fc-timegrid-now-indicator-arrow {
        border-color: red;
        border-color: var(--fc-now-indicator-color, red);
        border-style: solid;
        margin-top: -5px;
        position: absolute;
        z-index: 4
    }

    .fc-direction-ltr .fc-timegrid-now-indicator-arrow {
        border-bottom-color: transparent;
        border-top-color: transparent;
        border-width: 5px 0 5px 6px;
        left: 0
    }

    .fc-direction-rtl .fc-timegrid-now-indicator-arrow {
        border-bottom-color: transparent;
        border-top-color: transparent;
        border-width: 5px 6px 5px 0;
        right: 0
    }

    .fc-theme-bootstrap5 a:not([href]) {
        color: inherit;
        text-decoration: inherit
    }

    .fc-theme-bootstrap5 .fc-list,
    .fc-theme-bootstrap5 .fc-scrollgrid,
    .fc-theme-bootstrap5 td,
    .fc-theme-bootstrap5 th {
        border: 1px solid var(--bs-gray-400)
    }

    .fc-theme-bootstrap5 .fc-scrollgrid {
        border-bottom-width: 0;
        border-right-width: 0
    }

    .fc-theme-bootstrap5-shaded {
        background-color: var(--bs-gray-200)
    }

    /*!
 * Quill Editor v1.3.7
 * https://quilljs.com/
 * Copyright (c) 2014, Jason Chen
 * Copyright (c) 2013, salesforce.com
 */

    /*!
 * Quill Editor v1.3.7
 * https://quilljs.com/
 * Copyright (c) 2014, Jason Chen
 * Copyright (c) 2013, salesforce.com
 */
    .ql-container {
        box-sizing: border-box;
        font-family: Helvetica, Arial, sans-serif;
        font-size: 13px;
        height: 100%;
        margin: 0;
        position: relative
    }

    .ql-container.ql-disabled .ql-tooltip {
        visibility: hidden
    }

    .ql-container.ql-disabled .ql-editor ul[data-checked]>li:before {
        pointer-events: none
    }

    .ql-clipboard {
        height: 1px;
        left: -100000px;
        overflow-y: hidden;
        position: absolute;
        top: 50%
    }

    .ql-clipboard p {
        margin: 0;
        padding: 0
    }

    .ql-editor {
        word-wrap: break-word;
        box-sizing: border-box;
        height: 100%;
        line-height: 1.42;
        outline: none;
        overflow-y: auto;
        padding: 12px 15px;
        tab-size: 4;
        -moz-tab-size: 4;
        text-align: left;
        white-space: pre-wrap
    }

    .ql-editor>* {
        cursor: text
    }

    .ql-editor blockquote,
    .ql-editor h1,
    .ql-editor h2,
    .ql-editor h3,
    .ql-editor h4,
    .ql-editor h5,
    .ql-editor h6,
    .ql-editor ol,
    .ql-editor p,
    .ql-editor pre,
    .ql-editor ul {
        counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;
        margin: 0;
        padding: 0
    }

    .ql-editor ol,
    .ql-editor ul {
        padding-left: 1.5em
    }

    .ql-editor ol>li,
    .ql-editor ul>li {
        list-style-type: none
    }

    .ql-editor ul>li:before {
        content: "\2022"
    }

    .ql-editor ul[data-checked=false],
    .ql-editor ul[data-checked=true] {
        pointer-events: none
    }

    .ql-editor ul[data-checked=false]>li *,
    .ql-editor ul[data-checked=true]>li * {
        pointer-events: all
    }

    .ql-editor ul[data-checked=false]>li:before,
    .ql-editor ul[data-checked=true]>li:before {
        color: #777;
        cursor: pointer;
        pointer-events: all
    }

    .ql-editor ul[data-checked=true]>li:before {
        content: "\2611"
    }

    .ql-editor ul[data-checked=false]>li:before {
        content: "\2610"
    }

    .ql-editor li:before {
        display: inline-block;
        white-space: nowrap;
        width: 1.2em
    }

    .ql-editor li:not(.ql-direction-rtl):before {
        margin-left: -1.5em;
        margin-right: .3em;
        text-align: right
    }

    .ql-editor li.ql-direction-rtl:before {
        margin-left: .3em;
        margin-right: -1.5em
    }

    .ql-editor ol li:not(.ql-direction-rtl),
    .ql-editor ul li:not(.ql-direction-rtl) {
        padding-left: 1.5em
    }

    .ql-editor ol li.ql-direction-rtl,
    .ql-editor ul li.ql-direction-rtl {
        padding-right: 1.5em
    }

    .ql-editor ol li {
        counter-increment: list-0;
        counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9
    }

    .ql-editor ol li:before {
        content: counter(list-0, decimal) ". "
    }

    .ql-editor ol li.ql-indent-1 {
        counter-increment: list-1
    }

    .ql-editor ol li.ql-indent-1:before {
        content: counter(list-1, lower-alpha) ". "
    }

    .ql-editor ol li.ql-indent-1 {
        counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9
    }

    .ql-editor ol li.ql-indent-2 {
        counter-increment: list-2
    }

    .ql-editor ol li.ql-indent-2:before {
        content: counter(list-2, lower-roman) ". "
    }

    .ql-editor ol li.ql-indent-2 {
        counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9
    }

    .ql-editor ol li.ql-indent-3 {
        counter-increment: list-3
    }

    .ql-editor ol li.ql-indent-3:before {
        content: counter(list-3, decimal) ". "
    }

    .ql-editor ol li.ql-indent-3 {
        counter-reset: list-4 list-5 list-6 list-7 list-8 list-9
    }

    .ql-editor ol li.ql-indent-4 {
        counter-increment: list-4
    }

    .ql-editor ol li.ql-indent-4:before {
        content: counter(list-4, lower-alpha) ". "
    }

    .ql-editor ol li.ql-indent-4 {
        counter-reset: list-5 list-6 list-7 list-8 list-9
    }

    .ql-editor ol li.ql-indent-5 {
        counter-increment: list-5
    }

    .ql-editor ol li.ql-indent-5:before {
        content: counter(list-5, lower-roman) ". "
    }

    .ql-editor ol li.ql-indent-5 {
        counter-reset: list-6 list-7 list-8 list-9
    }

    .ql-editor ol li.ql-indent-6 {
        counter-increment: list-6
    }

    .ql-editor ol li.ql-indent-6:before {
        content: counter(list-6, decimal) ". "
    }

    .ql-editor ol li.ql-indent-6 {
        counter-reset: list-7 list-8 list-9
    }

    .ql-editor ol li.ql-indent-7 {
        counter-increment: list-7
    }

    .ql-editor ol li.ql-indent-7:before {
        content: counter(list-7, lower-alpha) ". "
    }

    .ql-editor ol li.ql-indent-7 {
        counter-reset: list-8 list-9
    }

    .ql-editor ol li.ql-indent-8 {
        counter-increment: list-8
    }

    .ql-editor ol li.ql-indent-8:before {
        content: counter(list-8, lower-roman) ". "
    }

    .ql-editor ol li.ql-indent-8 {
        counter-reset: list-9
    }

    .ql-editor ol li.ql-indent-9 {
        counter-increment: list-9
    }

    .ql-editor ol li.ql-indent-9:before {
        content: counter(list-9, decimal) ". "
    }

    .ql-editor .ql-indent-1:not(.ql-direction-rtl) {
        padding-left: 3em
    }

    .ql-editor li.ql-indent-1:not(.ql-direction-rtl) {
        padding-left: 4.5em
    }

    .ql-editor .ql-indent-1.ql-direction-rtl.ql-align-right {
        padding-right: 3em
    }

    .ql-editor li.ql-indent-1.ql-direction-rtl.ql-align-right {
        padding-right: 4.5em
    }

    .ql-editor .ql-indent-2:not(.ql-direction-rtl) {
        padding-left: 6em
    }

    .ql-editor li.ql-indent-2:not(.ql-direction-rtl) {
        padding-left: 7.5em
    }

    .ql-editor .ql-indent-2.ql-direction-rtl.ql-align-right {
        padding-right: 6em
    }

    .ql-editor li.ql-indent-2.ql-direction-rtl.ql-align-right {
        padding-right: 7.5em
    }

    .ql-editor .ql-indent-3:not(.ql-direction-rtl) {
        padding-left: 9em
    }

    .ql-editor li.ql-indent-3:not(.ql-direction-rtl) {
        padding-left: 10.5em
    }

    .ql-editor .ql-indent-3.ql-direction-rtl.ql-align-right {
        padding-right: 9em
    }

    .ql-editor li.ql-indent-3.ql-direction-rtl.ql-align-right {
        padding-right: 10.5em
    }

    .ql-editor .ql-indent-4:not(.ql-direction-rtl) {
        padding-left: 12em
    }

    .ql-editor li.ql-indent-4:not(.ql-direction-rtl) {
        padding-left: 13.5em
    }

    .ql-editor .ql-indent-4.ql-direction-rtl.ql-align-right {
        padding-right: 12em
    }

    .ql-editor li.ql-indent-4.ql-direction-rtl.ql-align-right {
        padding-right: 13.5em
    }

    .ql-editor .ql-indent-5:not(.ql-direction-rtl) {
        padding-left: 15em
    }

    .ql-editor li.ql-indent-5:not(.ql-direction-rtl) {
        padding-left: 16.5em
    }

    .ql-editor .ql-indent-5.ql-direction-rtl.ql-align-right {
        padding-right: 15em
    }

    .ql-editor li.ql-indent-5.ql-direction-rtl.ql-align-right {
        padding-right: 16.5em
    }

    .ql-editor .ql-indent-6:not(.ql-direction-rtl) {
        padding-left: 18em
    }

    .ql-editor li.ql-indent-6:not(.ql-direction-rtl) {
        padding-left: 19.5em
    }

    .ql-editor .ql-indent-6.ql-direction-rtl.ql-align-right {
        padding-right: 18em
    }

    .ql-editor li.ql-indent-6.ql-direction-rtl.ql-align-right {
        padding-right: 19.5em
    }

    .ql-editor .ql-indent-7:not(.ql-direction-rtl) {
        padding-left: 21em
    }

    .ql-editor li.ql-indent-7:not(.ql-direction-rtl) {
        padding-left: 22.5em
    }

    .ql-editor .ql-indent-7.ql-direction-rtl.ql-align-right {
        padding-right: 21em
    }

    .ql-editor li.ql-indent-7.ql-direction-rtl.ql-align-right {
        padding-right: 22.5em
    }

    .ql-editor .ql-indent-8:not(.ql-direction-rtl) {
        padding-left: 24em
    }

    .ql-editor li.ql-indent-8:not(.ql-direction-rtl) {
        padding-left: 25.5em
    }

    .ql-editor .ql-indent-8.ql-direction-rtl.ql-align-right {
        padding-right: 24em
    }

    .ql-editor li.ql-indent-8.ql-direction-rtl.ql-align-right {
        padding-right: 25.5em
    }

    .ql-editor .ql-indent-9:not(.ql-direction-rtl) {
        padding-left: 27em
    }

    .ql-editor li.ql-indent-9:not(.ql-direction-rtl) {
        padding-left: 28.5em
    }

    .ql-editor .ql-indent-9.ql-direction-rtl.ql-align-right {
        padding-right: 27em
    }

    .ql-editor li.ql-indent-9.ql-direction-rtl.ql-align-right {
        padding-right: 28.5em
    }

    .ql-editor .ql-video {
        display: block;
        max-width: 100%
    }

    .ql-editor .ql-video.ql-align-center {
        margin: 0 auto
    }

    .ql-editor .ql-video.ql-align-right {
        margin: 0 0 0 auto
    }

    .ql-editor .ql-bg-black {
        background-color: #000
    }

    .ql-editor .ql-bg-red {
        background-color: #e60000
    }

    .ql-editor .ql-bg-orange {
        background-color: #f90
    }

    .ql-editor .ql-bg-yellow {
        background-color: #ff0
    }

    .ql-editor .ql-bg-green {
        background-color: #008a00
    }

    .ql-editor .ql-bg-blue {
        background-color: #06c
    }

    .ql-editor .ql-bg-purple {
        background-color: #93f
    }

    .ql-editor .ql-color-white {
        color: #fff
    }

    .ql-editor .ql-color-red {
        color: #e60000
    }

    .ql-editor .ql-color-orange {
        color: #f90
    }

    .ql-editor .ql-color-yellow {
        color: #ff0
    }

    .ql-editor .ql-color-green {
        color: #008a00
    }

    .ql-editor .ql-color-blue {
        color: #06c
    }

    .ql-editor .ql-color-purple {
        color: #93f
    }

    .ql-editor .ql-font-serif {
        font-family: Georgia, Times New Roman, serif
    }

    .ql-editor .ql-font-monospace {
        font-family: Monaco, Courier New, monospace
    }

    .ql-editor .ql-size-small {
        font-size: .75em
    }

    .ql-editor .ql-size-large {
        font-size: 1.5em
    }

    .ql-editor .ql-size-huge {
        font-size: 2.5em
    }

    .ql-editor .ql-direction-rtl {
        direction: rtl;
        text-align: inherit
    }

    .ql-editor .ql-align-center {
        text-align: center
    }

    .ql-editor .ql-align-justify {
        text-align: justify
    }

    .ql-editor .ql-align-right {
        text-align: right
    }

    .ql-editor.ql-blank:before {
        color: rgba(0, 0, 0, .6);
        content: attr(data-placeholder);
        font-style: italic;
        left: 15px;
        pointer-events: none;
        position: absolute;
        right: 15px
    }

    .ql-snow .ql-toolbar:after,
    .ql-snow.ql-toolbar:after {
        clear: both;
        content: "";
        display: table
    }

    .ql-snow .ql-toolbar button,
    .ql-snow.ql-toolbar button {
        background: none;
        border: none;
        cursor: pointer;
        display: inline-block;
        float: left;
        height: 24px;
        padding: 3px 5px;
        width: 28px
    }

    .ql-snow .ql-toolbar button svg,
    .ql-snow.ql-toolbar button svg {
        float: left;
        height: 100%
    }

    .ql-snow .ql-toolbar button:active:hover,
    .ql-snow.ql-toolbar button:active:hover {
        outline: none
    }

    .ql-snow .ql-toolbar input.ql-image[type=file],
    .ql-snow.ql-toolbar input.ql-image[type=file] {
        display: none
    }

    .ql-snow .ql-toolbar .ql-picker-item.ql-selected,
    .ql-snow .ql-toolbar .ql-picker-item:hover,
    .ql-snow .ql-toolbar .ql-picker-label.ql-active,
    .ql-snow .ql-toolbar .ql-picker-label:hover,
    .ql-snow .ql-toolbar button.ql-active,
    .ql-snow .ql-toolbar button:focus,
    .ql-snow .ql-toolbar button:hover,
    .ql-snow.ql-toolbar .ql-picker-item.ql-selected,
    .ql-snow.ql-toolbar .ql-picker-item:hover,
    .ql-snow.ql-toolbar .ql-picker-label.ql-active,
    .ql-snow.ql-toolbar .ql-picker-label:hover,
    .ql-snow.ql-toolbar button.ql-active,
    .ql-snow.ql-toolbar button:focus,
    .ql-snow.ql-toolbar button:hover {
        color: #06c
    }

    .ql-snow .ql-toolbar .ql-picker-item.ql-selected .ql-fill,
    .ql-snow .ql-toolbar .ql-picker-item.ql-selected .ql-stroke.ql-fill,
    .ql-snow .ql-toolbar .ql-picker-item:hover .ql-fill,
    .ql-snow .ql-toolbar .ql-picker-item:hover .ql-stroke.ql-fill,
    .ql-snow .ql-toolbar .ql-picker-label.ql-active .ql-fill,
    .ql-snow .ql-toolbar .ql-picker-label.ql-active .ql-stroke.ql-fill,
    .ql-snow .ql-toolbar .ql-picker-label:hover .ql-fill,
    .ql-snow .ql-toolbar .ql-picker-label:hover .ql-stroke.ql-fill,
    .ql-snow .ql-toolbar button.ql-active .ql-fill,
    .ql-snow .ql-toolbar button.ql-active .ql-stroke.ql-fill,
    .ql-snow .ql-toolbar button:focus .ql-fill,
    .ql-snow .ql-toolbar button:focus .ql-stroke.ql-fill,
    .ql-snow .ql-toolbar button:hover .ql-fill,
    .ql-snow .ql-toolbar button:hover .ql-stroke.ql-fill,
    .ql-snow.ql-toolbar .ql-picker-item.ql-selected .ql-fill,
    .ql-snow.ql-toolbar .ql-picker-item.ql-selected .ql-stroke.ql-fill,
    .ql-snow.ql-toolbar .ql-picker-item:hover .ql-fill,
    .ql-snow.ql-toolbar .ql-picker-item:hover .ql-stroke.ql-fill,
    .ql-snow.ql-toolbar .ql-picker-label.ql-active .ql-fill,
    .ql-snow.ql-toolbar .ql-picker-label.ql-active .ql-stroke.ql-fill,
    .ql-snow.ql-toolbar .ql-picker-label:hover .ql-fill,
    .ql-snow.ql-toolbar .ql-picker-label:hover .ql-stroke.ql-fill,
    .ql-snow.ql-toolbar button.ql-active .ql-fill,
    .ql-snow.ql-toolbar button.ql-active .ql-stroke.ql-fill,
    .ql-snow.ql-toolbar button:focus .ql-fill,
    .ql-snow.ql-toolbar button:focus .ql-stroke.ql-fill,
    .ql-snow.ql-toolbar button:hover .ql-fill,
    .ql-snow.ql-toolbar button:hover .ql-stroke.ql-fill {
        fill: #06c
    }

    .ql-snow .ql-toolbar .ql-picker-item.ql-selected .ql-stroke,
    .ql-snow .ql-toolbar .ql-picker-item.ql-selected .ql-stroke-miter,
    .ql-snow .ql-toolbar .ql-picker-item:hover .ql-stroke,
    .ql-snow .ql-toolbar .ql-picker-item:hover .ql-stroke-miter,
    .ql-snow .ql-toolbar .ql-picker-label.ql-active .ql-stroke,
    .ql-snow .ql-toolbar .ql-picker-label.ql-active .ql-stroke-miter,
    .ql-snow .ql-toolbar .ql-picker-label:hover .ql-stroke,
    .ql-snow .ql-toolbar .ql-picker-label:hover .ql-stroke-miter,
    .ql-snow .ql-toolbar button.ql-active .ql-stroke,
    .ql-snow .ql-toolbar button.ql-active .ql-stroke-miter,
    .ql-snow .ql-toolbar button:focus .ql-stroke,
    .ql-snow .ql-toolbar button:focus .ql-stroke-miter,
    .ql-snow .ql-toolbar button:hover .ql-stroke,
    .ql-snow .ql-toolbar button:hover .ql-stroke-miter,
    .ql-snow.ql-toolbar .ql-picker-item.ql-selected .ql-stroke,
    .ql-snow.ql-toolbar .ql-picker-item.ql-selected .ql-stroke-miter,
    .ql-snow.ql-toolbar .ql-picker-item:hover .ql-stroke,
    .ql-snow.ql-toolbar .ql-picker-item:hover .ql-stroke-miter,
    .ql-snow.ql-toolbar .ql-picker-label.ql-active .ql-stroke,
    .ql-snow.ql-toolbar .ql-picker-label.ql-active .ql-stroke-miter,
    .ql-snow.ql-toolbar .ql-picker-label:hover .ql-stroke,
    .ql-snow.ql-toolbar .ql-picker-label:hover .ql-stroke-miter,
    .ql-snow.ql-toolbar button.ql-active .ql-stroke,
    .ql-snow.ql-toolbar button.ql-active .ql-stroke-miter,
    .ql-snow.ql-toolbar button:focus .ql-stroke,
    .ql-snow.ql-toolbar button:focus .ql-stroke-miter,
    .ql-snow.ql-toolbar button:hover .ql-stroke,
    .ql-snow.ql-toolbar button:hover .ql-stroke-miter {
        stroke: #06c
    }

    @media (pointer:coarse) {

        .ql-snow .ql-toolbar button:hover:not(.ql-active),
        .ql-snow.ql-toolbar button:hover:not(.ql-active) {
            color: #444
        }

        .ql-snow .ql-toolbar button:hover:not(.ql-active) .ql-fill,
        .ql-snow .ql-toolbar button:hover:not(.ql-active) .ql-stroke.ql-fill,
        .ql-snow.ql-toolbar button:hover:not(.ql-active) .ql-fill,
        .ql-snow.ql-toolbar button:hover:not(.ql-active) .ql-stroke.ql-fill {
            fill: #444
        }

        .ql-snow .ql-toolbar button:hover:not(.ql-active) .ql-stroke,
        .ql-snow .ql-toolbar button:hover:not(.ql-active) .ql-stroke-miter,
        .ql-snow.ql-toolbar button:hover:not(.ql-active) .ql-stroke,
        .ql-snow.ql-toolbar button:hover:not(.ql-active) .ql-stroke-miter {
            stroke: #444
        }
    }

    .ql-snow,
    .ql-snow * {
        box-sizing: border-box
    }

    .ql-snow .ql-hidden {
        display: none
    }

    .ql-snow .ql-out-bottom,
    .ql-snow .ql-out-top {
        visibility: hidden
    }

    .ql-snow .ql-tooltip {
        position: absolute;
        transform: translateY(10px)
    }

    .ql-snow .ql-tooltip a {
        cursor: pointer;
        text-decoration: none
    }

    .ql-snow .ql-tooltip.ql-flip {
        transform: translateY(-10px)
    }

    .ql-snow .ql-formats {
        display: inline-block;
        vertical-align: middle
    }

    .ql-snow .ql-formats:after {
        clear: both;
        content: "";
        display: table
    }

    .ql-snow .ql-stroke {
        fill: none;
        stroke: #444;
        stroke-linecap: round;
        stroke-linejoin: round;
        stroke-width: 2
    }

    .ql-snow .ql-stroke-miter {
        fill: none;
        stroke: #444;
        stroke-miterlimit: 10;
        stroke-width: 2
    }

    .ql-snow .ql-fill,
    .ql-snow .ql-stroke.ql-fill {
        fill: #444
    }

    .ql-snow .ql-empty {
        fill: none
    }

    .ql-snow .ql-even {
        fill-rule: evenodd
    }

    .ql-snow .ql-stroke.ql-thin,
    .ql-snow .ql-thin {
        stroke-width: 1
    }

    .ql-snow .ql-transparent {
        opacity: .4
    }

    .ql-snow .ql-direction svg:last-child {
        display: none
    }

    .ql-snow .ql-direction.ql-active svg:last-child {
        display: inline
    }

    .ql-snow .ql-direction.ql-active svg:first-child {
        display: none
    }

    .ql-snow .ql-editor h1 {
        font-size: 2em
    }

    .ql-snow .ql-editor h2 {
        font-size: 1.5em
    }

    .ql-snow .ql-editor h3 {
        font-size: 1.17em
    }

    .ql-snow .ql-editor h4 {
        font-size: 1em
    }

    .ql-snow .ql-editor h5 {
        font-size: .83em
    }

    .ql-snow .ql-editor h6 {
        font-size: .67em
    }

    .ql-snow .ql-editor a {
        text-decoration: underline
    }

    .ql-snow .ql-editor blockquote {
        border-left: 4px solid #ccc;
        margin-bottom: 5px;
        margin-top: 5px;
        padding-left: 16px
    }

    .ql-snow .ql-editor code,
    .ql-snow .ql-editor pre {
        background-color: #f0f0f0;
        border-radius: 3px
    }

    .ql-snow .ql-editor pre {
        margin-bottom: 5px;
        margin-top: 5px;
        padding: 5px 10px;
        white-space: pre-wrap
    }

    .ql-snow .ql-editor code {
        font-size: 85%;
        padding: 2px 4px
    }

    .ql-snow .ql-editor pre.ql-syntax {
        background-color: #23241f;
        color: #f8f8f2;
        overflow: visible
    }

    .ql-snow .ql-editor img {
        max-width: 100%
    }

    .ql-snow .ql-picker {
        color: #444;
        display: inline-block;
        float: left;
        font-size: 14px;
        font-weight: 500;
        height: 24px;
        position: relative;
        vertical-align: middle
    }

    .ql-snow .ql-picker-label {
        cursor: pointer;
        display: inline-block;
        height: 100%;
        padding-left: 8px;
        padding-right: 2px;
        position: relative;
        width: 100%
    }

    .ql-snow .ql-picker-label:before {
        display: inline-block;
        line-height: 22px
    }

    .ql-snow .ql-picker-options {
        background-color: #fff;
        display: none;
        min-width: 100%;
        padding: 4px 8px;
        position: absolute;
        white-space: nowrap
    }

    .ql-snow .ql-picker-options .ql-picker-item {
        cursor: pointer;
        display: block;
        padding-bottom: 5px;
        padding-top: 5px
    }

    .ql-snow .ql-picker.ql-expanded .ql-picker-label {
        color: #ccc;
        z-index: 2
    }

    .ql-snow .ql-picker.ql-expanded .ql-picker-label .ql-fill {
        fill: #ccc
    }

    .ql-snow .ql-picker.ql-expanded .ql-picker-label .ql-stroke {
        stroke: #ccc
    }

    .ql-snow .ql-picker.ql-expanded .ql-picker-options {
        display: block;
        margin-top: -1px;
        top: 100%;
        z-index: 1
    }

    .ql-snow .ql-color-picker,
    .ql-snow .ql-icon-picker {
        width: 28px
    }

    .ql-snow .ql-color-picker .ql-picker-label,
    .ql-snow .ql-icon-picker .ql-picker-label {
        padding: 2px 4px
    }

    .ql-snow .ql-color-picker .ql-picker-label svg,
    .ql-snow .ql-icon-picker .ql-picker-label svg {
        right: 4px
    }

    .ql-snow .ql-icon-picker .ql-picker-options {
        padding: 4px 0
    }

    .ql-snow .ql-icon-picker .ql-picker-item {
        height: 24px;
        padding: 2px 4px;
        width: 24px
    }

    .ql-snow .ql-color-picker .ql-picker-options {
        padding: 3px 5px;
        width: 152px
    }

    .ql-snow .ql-color-picker .ql-picker-item {
        border: 1px solid transparent;
        float: left;
        height: 16px;
        margin: 2px;
        padding: 0;
        width: 16px
    }

    .ql-snow .ql-picker:not(.ql-color-picker):not(.ql-icon-picker) svg {
        margin-top: -9px;
        position: absolute;
        right: 0;
        top: 50%;
        width: 18px
    }

    .ql-snow .ql-picker.ql-font .ql-picker-item[data-label]:not([data-label=""]):before,
    .ql-snow .ql-picker.ql-font .ql-picker-label[data-label]:not([data-label=""]):before,
    .ql-snow .ql-picker.ql-header .ql-picker-item[data-label]:not([data-label=""]):before,
    .ql-snow .ql-picker.ql-header .ql-picker-label[data-label]:not([data-label=""]):before,
    .ql-snow .ql-picker.ql-size .ql-picker-item[data-label]:not([data-label=""]):before,
    .ql-snow .ql-picker.ql-size .ql-picker-label[data-label]:not([data-label=""]):before {
        content: attr(data-label)
    }

    .ql-snow .ql-picker.ql-header {
        width: 98px
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item:before,
    .ql-snow .ql-picker.ql-header .ql-picker-label:before {
        content: "Normal"
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="1"]:before,
    .ql-snow .ql-picker.ql-header .ql-picker-label[data-value="1"]:before {
        content: "Heading 1"
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="2"]:before,
    .ql-snow .ql-picker.ql-header .ql-picker-label[data-value="2"]:before {
        content: "Heading 2"
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="3"]:before,
    .ql-snow .ql-picker.ql-header .ql-picker-label[data-value="3"]:before {
        content: "Heading 3"
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="4"]:before,
    .ql-snow .ql-picker.ql-header .ql-picker-label[data-value="4"]:before {
        content: "Heading 4"
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="5"]:before,
    .ql-snow .ql-picker.ql-header .ql-picker-label[data-value="5"]:before {
        content: "Heading 5"
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="6"]:before,
    .ql-snow .ql-picker.ql-header .ql-picker-label[data-value="6"]:before {
        content: "Heading 6"
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="1"]:before {
        font-size: 2em
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="2"]:before {
        font-size: 1.5em
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="3"]:before {
        font-size: 1.17em
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="4"]:before {
        font-size: 1em
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="5"]:before {
        font-size: .83em
    }

    .ql-snow .ql-picker.ql-header .ql-picker-item[data-value="6"]:before {
        font-size: .67em
    }

    .ql-snow .ql-picker.ql-font {
        width: 108px
    }

    .ql-snow .ql-picker.ql-font .ql-picker-item:before,
    .ql-snow .ql-picker.ql-font .ql-picker-label:before {
        content: "Sans Serif"
    }

    .ql-snow .ql-picker.ql-font .ql-picker-item[data-value=serif]:before,
    .ql-snow .ql-picker.ql-font .ql-picker-label[data-value=serif]:before {
        content: "Serif"
    }

    .ql-snow .ql-picker.ql-font .ql-picker-item[data-value=monospace]:before,
    .ql-snow .ql-picker.ql-font .ql-picker-label[data-value=monospace]:before {
        content: "Monospace"
    }

    .ql-snow .ql-picker.ql-font .ql-picker-item[data-value=serif]:before {
        font-family: Georgia, Times New Roman, serif
    }

    .ql-snow .ql-picker.ql-font .ql-picker-item[data-value=monospace]:before {
        font-family: Monaco, Courier New, monospace
    }

    .ql-snow .ql-picker.ql-size {
        width: 98px
    }

    .ql-snow .ql-picker.ql-size .ql-picker-item:before,
    .ql-snow .ql-picker.ql-size .ql-picker-label:before {
        content: "Normal"
    }

    .ql-snow .ql-picker.ql-size .ql-picker-item[data-value=small]:before,
    .ql-snow .ql-picker.ql-size .ql-picker-label[data-value=small]:before {
        content: "Small"
    }

    .ql-snow .ql-picker.ql-size .ql-picker-item[data-value=large]:before,
    .ql-snow .ql-picker.ql-size .ql-picker-label[data-value=large]:before {
        content: "Large"
    }

    .ql-snow .ql-picker.ql-size .ql-picker-item[data-value=huge]:before,
    .ql-snow .ql-picker.ql-size .ql-picker-label[data-value=huge]:before {
        content: "Huge"
    }

    .ql-snow .ql-picker.ql-size .ql-picker-item[data-value=small]:before {
        font-size: 10px
    }

    .ql-snow .ql-picker.ql-size .ql-picker-item[data-value=large]:before {
        font-size: 18px
    }

    .ql-snow .ql-picker.ql-size .ql-picker-item[data-value=huge]:before {
        font-size: 32px
    }

    .ql-snow .ql-color-picker.ql-background .ql-picker-item {
        background-color: #fff
    }

    .ql-snow .ql-color-picker.ql-color .ql-picker-item {
        background-color: #000
    }

    .ql-toolbar.ql-snow {
        border: 1px solid #ccc;
        box-sizing: border-box;
        font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        padding: 8px
    }

    .ql-toolbar.ql-snow .ql-formats {
        margin-right: 15px
    }

    .ql-toolbar.ql-snow .ql-picker-label {
        border: 1px solid transparent
    }

    .ql-toolbar.ql-snow .ql-picker-options {
        border: 1px solid transparent;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .2)
    }

    .ql-toolbar.ql-snow .ql-picker.ql-expanded .ql-picker-label,
    .ql-toolbar.ql-snow .ql-picker.ql-expanded .ql-picker-options {
        border-color: #ccc
    }

    .ql-toolbar.ql-snow .ql-color-picker .ql-picker-item.ql-selected,
    .ql-toolbar.ql-snow .ql-color-picker .ql-picker-item:hover {
        border-color: #000
    }

    .ql-toolbar.ql-snow+.ql-container.ql-snow {
        border-top: 0
    }

    .ql-snow .ql-tooltip {
        background-color: #fff;
        border: 1px solid #ccc;
        box-shadow: 0 0 5px #ddd;
        color: #444;
        padding: 5px 12px;
        white-space: nowrap
    }

    .ql-snow .ql-tooltip:before {
        content: "Visit URL:";
        line-height: 26px;
        margin-right: 8px
    }

    .ql-snow .ql-tooltip input[type=text] {
        border: 1px solid #ccc;
        display: none;
        font-size: 13px;
        height: 26px;
        margin: 0;
        padding: 3px 5px;
        width: 170px
    }

    .ql-snow .ql-tooltip a.ql-preview {
        display: inline-block;
        max-width: 200px;
        overflow-x: hidden;
        text-overflow: ellipsis;
        vertical-align: top
    }

    .ql-snow .ql-tooltip a.ql-action:after {
        border-right: 1px solid #ccc;
        content: "Edit";
        margin-left: 16px;
        padding-right: 8px
    }

    .ql-snow .ql-tooltip a.ql-remove:before {
        content: "Remove";
        margin-left: 8px
    }

    .ql-snow .ql-tooltip a {
        line-height: 26px
    }

    .ql-snow .ql-tooltip.ql-editing a.ql-preview,
    .ql-snow .ql-tooltip.ql-editing a.ql-remove {
        display: none
    }

    .ql-snow .ql-tooltip.ql-editing input[type=text] {
        display: inline-block
    }

    .ql-snow .ql-tooltip.ql-editing a.ql-action:after {
        border-right: 0;
        content: "Save";
        padding-right: 0
    }

    .ql-snow .ql-tooltip[data-mode=link]:before {
        content: "Enter link:"
    }

    .ql-snow .ql-tooltip[data-mode=formula]:before {
        content: "Enter formula:"
    }

    .ql-snow .ql-tooltip[data-mode=video]:before {
        content: "Enter video:"
    }

    .ql-snow a {
        color: #06c
    }

    .ql-container.ql-snow {
        border: 1px solid #ccc
    }

    :root,
    [data-theme=light] {
        --prefix: --bs-;
        --bs-indigo: #6610f2;
        --bs-purple: #6f42c1;
        --bs-pink: #d63384;
        --bs-red: #d82c5b;
        --bs-orange: #fd7e14;
        --bs-yellow: #ebcf4f;
        --bs-green: #31cf80;
        --bs-teal: #20c997;
        --bs-cyan: #2dadcf;
        --bs-gray: #989ea6;
        --bs-gray-dark: #343a40;
        --bs-primary: {{ $settings->website_theme }};
        --bs-secondary: #9ea9b4;
        --bs-success: #31cf80;
        --bs-info: #2dadcf;
        --bs-warning: #ebcf4f;
        --bs-danger: #d82c5b;
        --bs-light: #f6f7f8;
        --bs-dark: #0e2238;
        --bs-light-green: #f1f5f7;
        --bs-white: #fff;
        --bs-black: #000;
        --bs-blue: #0075c7;
        --bs-gray-100: #f6f7f8;
        --bs-gray-200: #f4f4f4;
        --bs-gray-300: #edeef0;
        --bs-gray-400: #d6dae2;
        --bs-gray-500: #a5abb3;
        --bs-gray-600: #989ea6;
        --bs-gray-700: #707070;
        --bs-gray-800: #343a40;
        --bs-gray-900: #212529;
        --bs-primary-rgb: 0, 186, 199;
        --bs-secondary-rgb: 158, 169, 180;
        --bs-success-rgb: 49, 207, 128;
        --bs-info-rgb: 45, 173, 207;
        --bs-warning-rgb: 235, 207, 79;
        --bs-danger-rgb: 216, 44, 91;
        --bs-light-rgb: 246, 247, 248;
        --bs-dark-rgb: 14, 34, 56;
        --bs-light-green-rgb: 241, 245, 247;
        --bs-blue-rgb: 0, 117, 199;
        --bs-gray-100-rgb: 246, 247, 248;
        --bs-gray-200-rgb: 244, 244, 244;
        --bs-gray-300-rgb: 237, 238, 240;
        --bs-gray-400-rgb: 214, 218, 226;
        --bs-gray-500-rgb: 165, 171, 179;
        --bs-gray-600-rgb: 152, 158, 166;
        --bs-gray-700-rgb: 112, 112, 112;
        --bs-gray-800-rgb: 52, 58, 64;
        --bs-gray-900-rgb: 33, 37, 41;
        --bs-white-rgb: 255, 255, 255;
        --bs-black-rgb: 0, 0, 0;
        --bs-body-color-rgb: 14, 34, 56;
        --bs-body-bg-rgb: 248, 250, 251;
        --bs-font-sans-serif: "Open Sans", sans-serif;
        --bs-font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
        --bs-gradient: linear-gradient(180deg, hsla(0, 0%, 100%, .15), hsla(0, 0%, 100%, 0));
        --bs-body-font-family: var(--bs-font-sans-serif);
        --bs-body-font-size: 0.875rem;
        --bs-body-font-weight: 400;
        --bs-body-line-height: 1.5;
        --bs-body-color: #0e2238;
        --bs-body-bg: #f8fafb;
        --bs-heading-color: ;
        --bs-link-color: {{ $settings->website_theme }};
        --bs-link-hover-color: {{ $settings->website_theme }};
        --bs-code-color: {{ $settings->website_theme }};
        --bs-highlight-bg: #fbf5dc;
        --bs-breakpoint-xs: 0;
        --bs-breakpoint-sm: 576px;
        --bs-breakpoint-md: 768px;
        --bs-breakpoint-lg: 992px;
        --bs-breakpoint-xl: 1200px;
        --bs-breakpoint-xxl: 1400px;
        --bs-border-width: 1px;
        --bs-border-style: solid;
        --bs-border-color: #f4f4f4;
        --bs-border-color-translucent: hsla(214, 7%, 62%, .1);
        --bs-border-radius: 0.625rem;
        --bs-border-radius-sm: 0.25rem;
        --bs-border-radius-lg: 0.75rem;
        --bs-border-radius-xl: 1rem;
        --bs-border-radius-2xl: 2rem;
        --bs-border-radius-pill: 50rem;
        --bs-form-control-bg: var(--bs-body-bg);
        --bs-chart-tooltip-bg: var(--bs-dark)
    }

    [data-theme=dark] {
        --bs-body-color: #bcc0c6;
        --bs-body-color-rgb: 188, 192, 198;
        --bs-body-bg: #252626;
        --bs-body-bg-rgb: 37, 38, 38;
        --bs-primary: {{ $settings->website_theme }};
        --bs-secondary: #9ea9b4;
        --bs-success: #31cf80;
        --bs-info: #2dadcf;
        --bs-warning: #ebcf4f;
        --bs-danger: #d82c5b;
        --bs-light: #363637;
        --bs-dark: #595c5f;
        --bs-light-green: #1d1d1e;
        --bs-white: #2d2d2d;
        --bs-black: #fff;
        --bs-gray-100: #1f1f1f;
        --bs-gray-200: #1f1f1f;
        --bs-gray-300: #1e1e1e;
        --bs-gray-400: #1b1b1c;
        --bs-gray-500: #b7bcc2;
        --bs-gray-600: #b2b6bc;
        --bs-gray-700: #9b9b9b;
        --bs-gray-800: #85898c;
        --bs-gray-900: #909294;
        --bs-primary-rgb: {{ $settings->website_theme }};
        --bs-secondary-rgb: 158, 169, 180;
        --bs-success-rgb: 49, 207, 128;
        --bs-info-rgb: 45, 173, 207;
        --bs-warning-rgb: 235, 207, 79;
        --bs-danger-rgb: 216, 44, 91;
        --bs-light-rgb: 54, 54, 55;
        --bs-dark-rgb: 89, 92, 95;
        --bs-light-green-rgb: 29, 29, 30;
        --bs-white-rgb: 45, 45, 45;
        --bs-black-rgb: 255, 255, 255;
        --bs-gray-100-rgb: 31, 31, 31;
        --bs-gray-200-rgb: 31, 31, 31;
        --bs-gray-300-rgb: 30, 30, 30;
        --bs-gray-400-rgb: 27, 27, 28;
        --bs-gray-500-rgb: 183, 188, 194;
        --bs-gray-600-rgb: 178, 182, 188;
        --bs-gray-700-rgb: 155, 155, 155;
        --bs-gray-800-rgb: 133, 137, 140;
        --bs-gray-900-rgb: 144, 146, 148;
        --bs-border-color: #383838
    }

    *,
    :after,
    :before {
        box-sizing: border-box
    }

    @media(prefers-reduced-motion:no-preference) {
        :root {
            scroll-behavior: smooth
        }
    }

    body {
        -webkit-text-size-adjust: 100%;
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
        background-color: var(--bs-body-bg);
        color: var(--bs-body-color);
        font-family: var(--bs-body-font-family);
        font-size: var(--bs-body-font-size);
        font-weight: var(--bs-body-font-weight);
        line-height: var(--bs-body-line-height);
        margin: 0;
        text-align: var(--bs-body-text-align)
    }

    hr {
        border: 0;
        border-top: 1px solid;
        color: #989ea6;
        margin: 1.875rem 0;
        opacity: .1
    }

    .h1,
    .h2,
    .h3,
    .h4,
    .h5,
    .h6,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
        font-weight: 700;
        line-height: 1.375;
        margin-bottom: 1.471875rem;
        margin-top: 0
    }

    .h1,
    h1 {
        font-size: calc(1.275rem + .3vw)
    }

    @media(min-width:1200px) {

        .h1,
        h1 {
            font-size: 1.5rem
        }
    }

    .h2,
    h2 {
        font-size: calc(1.2625rem + .15vw)
    }

    @media(min-width:1200px) {

        .h2,
        h2 {
            font-size: 1.375rem
        }
    }

    .h3,
    h3 {
        font-size: 1.125rem
    }

    .h4,
    h4 {
        font-size: .875rem
    }

    .h5,
    h5 {
        font-size: .75rem
    }

    .h6,
    h6 {
        font-size: .625rem
    }

    p {
        margin-bottom: 1.875rem;
        margin-top: 0
    }

    abbr[title] {
        cursor: help;
        -webkit-text-decoration: underline dotted;
        text-decoration: underline dotted;
        -webkit-text-decoration-skip-ink: none;
        text-decoration-skip-ink: none
    }

    address {
        font-style: normal;
        line-height: inherit;
        margin-bottom: 1rem
    }

    ol,
    ul {
        padding-left: 2rem
    }

    dl,
    ol,
    ul {
        margin-bottom: 1rem;
        margin-top: 0
    }

    ol ol,
    ol ul,
    ul ol,
    ul ul {
        margin-bottom: 0
    }

    dd {
        margin-bottom: .5rem;
        margin-left: 0
    }

    blockquote {
        margin: 0 0 1rem
    }

    b,
    strong {
        font-weight: 700
    }

    .small,
    small {
        font-size: 1em
    }

    .mark,
    mark {
        background-color: var(--bs-highlight-bg);
        padding: .1875em
    }

    sub,
    sup {
        font-size: .75em;
        line-height: 0;
        position: relative;
        vertical-align: baseline
    }

    sub {
        bottom: -.25em
    }

    sup {
        top: -.5em
    }

    a {
        color: var(--bs-link-color)
    }

    a,
    a:hover {
        text-decoration: none
    }

    a:hover {
        color: var(--bs-link-hover-color)
    }

    a:not([href]):not([class]),
    a:not([href]):not([class]):hover {
        color: inherit;
        text-decoration: none
    }

    code,
    kbd,
    pre,
    samp {
        font-family: var(--bs-font-monospace);
        font-size: 1em
    }

    pre {
        display: block;
        font-size: 1em;
        margin-bottom: 1rem;
        margin-top: 0;
        overflow: auto
    }

    pre code {
        color: inherit;
        font-size: inherit;
        word-break: normal
    }

    code {
        word-wrap: break-word;
        color: var(--bs-code-color);
        font-size: 1em
    }

    a>code {
        color: inherit
    }

    kbd {
        background-color: var(--bs-body-color);
        border-radius: .25rem;
        color: var(--bs-body-bg);
        padding: .1875rem .375rem
    }

    kbd,
    kbd kbd {
        font-size: 1em
    }

    kbd kbd {
        padding: 0
    }

    figure {
        margin: 0 0 1rem
    }

    img,
    svg {
        vertical-align: middle
    }

    table {
        border-collapse: collapse;
        caption-side: bottom
    }

    caption {
        color: rgba(var(--bs-body-color-rgb), .3525);
        padding-bottom: 1rem;
        padding-top: 1rem;
        text-align: left
    }

    th {
        font-weight: 700;
        text-align: inherit;
        text-align: -webkit-match-parent
    }

    tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
        border: 0 solid;
        border-color: inherit
    }

    label {
        display: inline-block
    }

    button {
        border-radius: 0
    }

    button:focus:not(:focus-visible) {
        outline: 0
    }

    button,
    input,
    optgroup,
    select,
    textarea {
        font-family: inherit;
        font-size: inherit;
        line-height: inherit;
        margin: 0
    }

    button,
    select {
        text-transform: none
    }

    [role=button] {
        cursor: pointer
    }

    select {
        word-wrap: normal
    }

    select:disabled {
        opacity: 1
    }

    [list]:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=week]):not([type=time])::-webkit-calendar-picker-indicator {
        display: none !important
    }

    [type=button],
    [type=reset],
    [type=submit],
    button {
        -webkit-appearance: button
    }

    [type=button]:not(:disabled),
    [type=reset]:not(:disabled),
    [type=submit]:not(:disabled),
    button:not(:disabled) {
        cursor: pointer
    }

    ::-moz-focus-inner {
        border-style: none;
        padding: 0
    }

    textarea {
        resize: vertical
    }

    fieldset {
        border: 0;
        margin: 0;
        min-width: 0;
        padding: 0
    }

    legend {
        float: left;
        font-size: calc(1.275rem + .3vw);
        line-height: inherit;
        margin-bottom: .5rem;
        padding: 0;
        width: 100%
    }

    @media(min-width:1200px) {
        legend {
            font-size: 1.5rem
        }
    }

    legend+* {
        clear: left
    }

    ::-webkit-datetime-edit-day-field,
    ::-webkit-datetime-edit-fields-wrapper,
    ::-webkit-datetime-edit-hour-field,
    ::-webkit-datetime-edit-minute,
    ::-webkit-datetime-edit-month-field,
    ::-webkit-datetime-edit-text,
    ::-webkit-datetime-edit-year-field {
        padding: 0
    }

    ::-webkit-inner-spin-button {
        height: auto
    }

    [type=search] {
        -webkit-appearance: textfield;
        outline-offset: -2px
    }

    ::-webkit-search-decoration {
        -webkit-appearance: none
    }

    ::-webkit-color-swatch-wrapper {
        padding: 0
    }

    ::-webkit-file-upload-button {
        -webkit-appearance: button;
        font: inherit
    }

    ::file-selector-button {
        -webkit-appearance: button;
        font: inherit
    }

    output {
        display: inline-block
    }

    iframe {
        border: 0
    }

    summary {
        cursor: pointer;
        display: list-item
    }

    progress {
        vertical-align: baseline
    }

    [hidden] {
        display: none !important
    }

    .lead {
        font-size: 1.09375rem;
        font-weight: 600
    }

    .display-1 {
        font-size: calc(1.425rem + 2.1vw);
        font-weight: 700;
        line-height: 1.375
    }

    @media(min-width:1200px) {
        .display-1 {
            font-size: 3rem
        }
    }

    .display-2 {
        font-size: calc(1.35rem + 1.2vw);
        font-weight: 700;
        line-height: 1.375
    }

    @media(min-width:1200px) {
        .display-2 {
            font-size: 2.25rem
        }
    }

    .display-3 {
        font-size: calc(1.325rem + .9vw);
        font-weight: 700;
        line-height: 1.375
    }

    @media(min-width:1200px) {
        .display-3 {
            font-size: 2rem
        }
    }

    .display-4 {
        font-size: calc(1.3rem + .6vw);
        font-weight: 700;
        line-height: 1.375
    }

    @media(min-width:1200px) {
        .display-4 {
            font-size: 1.75rem
        }
    }

    .display-5 {
        font-size: calc(1.275rem + .3vw);
        font-weight: 700;
        line-height: 1.375
    }

    @media(min-width:1200px) {
        .display-5 {
            font-size: 1.5rem
        }
    }

    .display-6 {
        font-size: 1.25rem;
        font-weight: 700;
        line-height: 1.375
    }

    .list-inline,
    .list-unstyled {
        list-style: none;
        padding-left: 0
    }

    .list-inline-item {
        display: inline-block
    }

    .list-inline-item:not(:last-child) {
        margin-right: .5rem
    }

    .initialism {
        font-size: 1em;
        text-transform: uppercase
    }

    .blockquote {
        font-size: 1.09375rem;
        margin-bottom: 1.875rem
    }

    .blockquote>:last-child {
        margin-bottom: 0
    }

    .blockquote-footer {
        color: #989ea6;
        font-size: 1em;
        margin-bottom: 1.875rem;
        margin-top: -1.875rem
    }

    .blockquote-footer:before {
        content: "— "
    }

    .img-fluid,
    .img-thumbnail {
        height: auto;
        max-width: 100%
    }

    .img-thumbnail {
        background-color: #f8fafb;
        border: 1px solid var(--bs-border-color);
        border-radius: .625rem;
        box-shadow: 0 .125rem .125rem 0 rgba(14, 34, 56, .07);
        padding: .25rem
    }

    .figure {
        display: inline-block
    }

    .figure-img {
        line-height: 1;
        margin-bottom: .9375rem
    }

    .figure-caption {
        color: #989ea6;
        font-size: 1em
    }

    .container,
    .container-fluid,
    .container-lg,
    .container-md,
    .container-sm,
    .container-xl,
    .container-xxl {
        --bs-gutter-x: 1.875rem;
        --bs-gutter-y: 0;
        margin-left: auto;
        margin-right: auto;
        padding-left: calc(var(--bs-gutter-x)*.5);
        padding-right: calc(var(--bs-gutter-x)*.5);
        width: 100%
    }

    @media(min-width:576px) {

        .container,
        .container-sm {
            max-width: 540px
        }
    }

    @media(min-width:768px) {

        .container,
        .container-md,
        .container-sm {
            max-width: 720px
        }
    }

    @media(min-width:992px) {

        .container,
        .container-lg,
        .container-md,
        .container-sm {
            max-width: 960px
        }
    }

    @media(min-width:1200px) {

        .container,
        .container-lg,
        .container-md,
        .container-sm,
        .container-xl {
            max-width: 1320px
        }
    }

    @media(min-width:1400px) {

        .container,
        .container-lg,
        .container-md,
        .container-sm,
        .container-xl,
        .container-xxl {
            max-width: 1480px
        }
    }

    .row {
        --bs-gutter-x: 1.875rem;
        --bs-gutter-y: 0;
        display: flex;
        flex-wrap: wrap;
        margin-left: calc(var(--bs-gutter-x)*-.5);
        margin-right: calc(var(--bs-gutter-x)*-.5);
        margin-top: calc(var(--bs-gutter-y)*-1)
    }

    .row>* {
        flex-shrink: 0;
        margin-top: var(--bs-gutter-y);
        max-width: 100%;
        padding-left: calc(var(--bs-gutter-x)*.5);
        padding-right: calc(var(--bs-gutter-x)*.5);
        width: 100%
    }

    .col {
        flex: 1 0 0%
    }

    .row-cols-auto>* {
        flex: 0 0 auto;
        width: auto
    }

    .row-cols-1>* {
        flex: 0 0 auto;
        width: 100%
    }

    .row-cols-2>* {
        flex: 0 0 auto;
        width: 50%
    }

    .row-cols-3>* {
        flex: 0 0 auto;
        width: 33.3333333333%
    }

    .row-cols-4>* {
        flex: 0 0 auto;
        width: 25%
    }

    .row-cols-5>* {
        flex: 0 0 auto;
        width: 20%
    }

    .row-cols-6>* {
        flex: 0 0 auto;
        width: 16.6666666667%
    }

    .col-auto {
        flex: 0 0 auto;
        width: auto
    }

    .col-1 {
        flex: 0 0 auto;
        width: 8.33333333%
    }

    .col-2 {
        flex: 0 0 auto;
        width: 16.66666667%
    }

    .col-3 {
        flex: 0 0 auto;
        width: 25%
    }

    .col-4 {
        flex: 0 0 auto;
        width: 33.33333333%
    }

    .col-5 {
        flex: 0 0 auto;
        width: 41.66666667%
    }

    .col-6 {
        flex: 0 0 auto;
        width: 50%
    }

    .col-7 {
        flex: 0 0 auto;
        width: 58.33333333%
    }

    .col-8 {
        flex: 0 0 auto;
        width: 66.66666667%
    }

    .col-9 {
        flex: 0 0 auto;
        width: 75%
    }

    .col-10 {
        flex: 0 0 auto;
        width: 83.33333333%
    }

    .col-11 {
        flex: 0 0 auto;
        width: 91.66666667%
    }

    .col-12 {
        flex: 0 0 auto;
        width: 100%
    }

    .offset-1 {
        margin-left: 8.33333333%
    }

    .offset-2 {
        margin-left: 16.66666667%
    }

    .offset-3 {
        margin-left: 25%
    }

    .offset-4 {
        margin-left: 33.33333333%
    }

    .offset-5 {
        margin-left: 41.66666667%
    }

    .offset-6 {
        margin-left: 50%
    }

    .offset-7 {
        margin-left: 58.33333333%
    }

    .offset-8 {
        margin-left: 66.66666667%
    }

    .offset-9 {
        margin-left: 75%
    }

    .offset-10 {
        margin-left: 83.33333333%
    }

    .offset-11 {
        margin-left: 91.66666667%
    }

    .g-0,
    .gx-0 {
        --bs-gutter-x: 0
    }

    .g-0,
    .gy-0 {
        --bs-gutter-y: 0
    }

    .g-1,
    .gx-1 {
        --bs-gutter-x: 0.234375rem
    }

    .g-1,
    .gy-1 {
        --bs-gutter-y: 0.234375rem
    }

    .g-2,
    .gx-2 {
        --bs-gutter-x: 0.46875rem
    }

    .g-2,
    .gy-2 {
        --bs-gutter-y: 0.46875rem
    }

    .g-3,
    .gx-3 {
        --bs-gutter-x: 0.624999375rem
    }

    .g-3,
    .gy-3 {
        --bs-gutter-y: 0.624999375rem
    }

    .g-4,
    .gx-4 {
        --bs-gutter-x: 0.9375rem
    }

    .g-4,
    .gy-4 {
        --bs-gutter-y: 0.9375rem
    }

    .g-5,
    .gx-5 {
        --bs-gutter-x: 1.2500000001rem
    }

    .g-5,
    .gy-5 {
        --bs-gutter-y: 1.2500000001rem
    }

    .g-6,
    .gx-6 {
        --bs-gutter-x: 1.875rem
    }

    .g-6,
    .gy-6 {
        --bs-gutter-y: 1.875rem
    }

    .g-7,
    .gx-7 {
        --bs-gutter-x: 2.8125rem
    }

    .g-7,
    .gy-7 {
        --bs-gutter-y: 2.8125rem
    }

    .g-8,
    .gx-8 {
        --bs-gutter-x: 3.75rem
    }

    .g-8,
    .gy-8 {
        --bs-gutter-y: 3.75rem
    }

    .g-9,
    .gx-9 {
        --bs-gutter-x: 5.625rem
    }

    .g-9,
    .gy-9 {
        --bs-gutter-y: 5.625rem
    }

    .g-10,
    .gx-10 {
        --bs-gutter-x: 8.4375rem
    }

    .g-10,
    .gy-10 {
        --bs-gutter-y: 8.4375rem
    }

    @media(min-width:576px) {
        .col-sm {
            flex: 1 0 0%
        }

        .row-cols-sm-auto>* {
            flex: 0 0 auto;
            width: auto
        }

        .row-cols-sm-1>* {
            flex: 0 0 auto;
            width: 100%
        }

        .row-cols-sm-2>* {
            flex: 0 0 auto;
            width: 50%
        }

        .row-cols-sm-3>* {
            flex: 0 0 auto;
            width: 33.3333333333%
        }

        .row-cols-sm-4>* {
            flex: 0 0 auto;
            width: 25%
        }

        .row-cols-sm-5>* {
            flex: 0 0 auto;
            width: 20%
        }

        .row-cols-sm-6>* {
            flex: 0 0 auto;
            width: 16.6666666667%
        }

        .col-sm-auto {
            flex: 0 0 auto;
            width: auto
        }

        .col-sm-1 {
            flex: 0 0 auto;
            width: 8.33333333%
        }

        .col-sm-2 {
            flex: 0 0 auto;
            width: 16.66666667%
        }

        .col-sm-3 {
            flex: 0 0 auto;
            width: 25%
        }

        .col-sm-4 {
            flex: 0 0 auto;
            width: 33.33333333%
        }

        .col-sm-5 {
            flex: 0 0 auto;
            width: 41.66666667%
        }

        .col-sm-6 {
            flex: 0 0 auto;
            width: 50%
        }

        .col-sm-7 {
            flex: 0 0 auto;
            width: 58.33333333%
        }

        .col-sm-8 {
            flex: 0 0 auto;
            width: 66.66666667%
        }

        .col-sm-9 {
            flex: 0 0 auto;
            width: 75%
        }

        .col-sm-10 {
            flex: 0 0 auto;
            width: 83.33333333%
        }

        .col-sm-11 {
            flex: 0 0 auto;
            width: 91.66666667%
        }

        .col-sm-12 {
            flex: 0 0 auto;
            width: 100%
        }

        .offset-sm-0 {
            margin-left: 0
        }

        .offset-sm-1 {
            margin-left: 8.33333333%
        }

        .offset-sm-2 {
            margin-left: 16.66666667%
        }

        .offset-sm-3 {
            margin-left: 25%
        }

        .offset-sm-4 {
            margin-left: 33.33333333%
        }

        .offset-sm-5 {
            margin-left: 41.66666667%
        }

        .offset-sm-6 {
            margin-left: 50%
        }

        .offset-sm-7 {
            margin-left: 58.33333333%
        }

        .offset-sm-8 {
            margin-left: 66.66666667%
        }

        .offset-sm-9 {
            margin-left: 75%
        }

        .offset-sm-10 {
            margin-left: 83.33333333%
        }

        .offset-sm-11 {
            margin-left: 91.66666667%
        }

        .g-sm-0,
        .gx-sm-0 {
            --bs-gutter-x: 0
        }

        .g-sm-0,
        .gy-sm-0 {
            --bs-gutter-y: 0
        }

        .g-sm-1,
        .gx-sm-1 {
            --bs-gutter-x: 0.234375rem
        }

        .g-sm-1,
        .gy-sm-1 {
            --bs-gutter-y: 0.234375rem
        }

        .g-sm-2,
        .gx-sm-2 {
            --bs-gutter-x: 0.46875rem
        }

        .g-sm-2,
        .gy-sm-2 {
            --bs-gutter-y: 0.46875rem
        }

        .g-sm-3,
        .gx-sm-3 {
            --bs-gutter-x: 0.624999375rem
        }

        .g-sm-3,
        .gy-sm-3 {
            --bs-gutter-y: 0.624999375rem
        }

        .g-sm-4,
        .gx-sm-4 {
            --bs-gutter-x: 0.9375rem
        }

        .g-sm-4,
        .gy-sm-4 {
            --bs-gutter-y: 0.9375rem
        }

        .g-sm-5,
        .gx-sm-5 {
            --bs-gutter-x: 1.2500000001rem
        }

        .g-sm-5,
        .gy-sm-5 {
            --bs-gutter-y: 1.2500000001rem
        }

        .g-sm-6,
        .gx-sm-6 {
            --bs-gutter-x: 1.875rem
        }

        .g-sm-6,
        .gy-sm-6 {
            --bs-gutter-y: 1.875rem
        }

        .g-sm-7,
        .gx-sm-7 {
            --bs-gutter-x: 2.8125rem
        }

        .g-sm-7,
        .gy-sm-7 {
            --bs-gutter-y: 2.8125rem
        }

        .g-sm-8,
        .gx-sm-8 {
            --bs-gutter-x: 3.75rem
        }

        .g-sm-8,
        .gy-sm-8 {
            --bs-gutter-y: 3.75rem
        }

        .g-sm-9,
        .gx-sm-9 {
            --bs-gutter-x: 5.625rem
        }

        .g-sm-9,
        .gy-sm-9 {
            --bs-gutter-y: 5.625rem
        }

        .g-sm-10,
        .gx-sm-10 {
            --bs-gutter-x: 8.4375rem
        }

        .g-sm-10,
        .gy-sm-10 {
            --bs-gutter-y: 8.4375rem
        }
    }

    @media(min-width:768px) {
        .col-md {
            flex: 1 0 0%
        }

        .row-cols-md-auto>* {
            flex: 0 0 auto;
            width: auto
        }

        .row-cols-md-1>* {
            flex: 0 0 auto;
            width: 100%
        }

        .row-cols-md-2>* {
            flex: 0 0 auto;
            width: 50%
        }

        .row-cols-md-3>* {
            flex: 0 0 auto;
            width: 33.3333333333%
        }

        .row-cols-md-4>* {
            flex: 0 0 auto;
            width: 25%
        }

        .row-cols-md-5>* {
            flex: 0 0 auto;
            width: 20%
        }

        .row-cols-md-6>* {
            flex: 0 0 auto;
            width: 16.6666666667%
        }

        .col-md-auto {
            flex: 0 0 auto;
            width: auto
        }

        .col-md-1 {
            flex: 0 0 auto;
            width: 8.33333333%
        }

        .col-md-2 {
            flex: 0 0 auto;
            width: 16.66666667%
        }

        .col-md-3 {
            flex: 0 0 auto;
            width: 25%
        }

        .col-md-4 {
            flex: 0 0 auto;
            width: 33.33333333%
        }

        .col-md-5 {
            flex: 0 0 auto;
            width: 41.66666667%
        }

        .col-md-6 {
            flex: 0 0 auto;
            width: 50%
        }

        .col-md-7 {
            flex: 0 0 auto;
            width: 58.33333333%
        }

        .col-md-8 {
            flex: 0 0 auto;
            width: 66.66666667%
        }

        .col-md-9 {
            flex: 0 0 auto;
            width: 75%
        }

        .col-md-10 {
            flex: 0 0 auto;
            width: 83.33333333%
        }

        .col-md-11 {
            flex: 0 0 auto;
            width: 91.66666667%
        }

        .col-md-12 {
            flex: 0 0 auto;
            width: 100%
        }

        .offset-md-0 {
            margin-left: 0
        }

        .offset-md-1 {
            margin-left: 8.33333333%
        }

        .offset-md-2 {
            margin-left: 16.66666667%
        }

        .offset-md-3 {
            margin-left: 25%
        }

        .offset-md-4 {
            margin-left: 33.33333333%
        }

        .offset-md-5 {
            margin-left: 41.66666667%
        }

        .offset-md-6 {
            margin-left: 50%
        }

        .offset-md-7 {
            margin-left: 58.33333333%
        }

        .offset-md-8 {
            margin-left: 66.66666667%
        }

        .offset-md-9 {
            margin-left: 75%
        }

        .offset-md-10 {
            margin-left: 83.33333333%
        }

        .offset-md-11 {
            margin-left: 91.66666667%
        }

        .g-md-0,
        .gx-md-0 {
            --bs-gutter-x: 0
        }

        .g-md-0,
        .gy-md-0 {
            --bs-gutter-y: 0
        }

        .g-md-1,
        .gx-md-1 {
            --bs-gutter-x: 0.234375rem
        }

        .g-md-1,
        .gy-md-1 {
            --bs-gutter-y: 0.234375rem
        }

        .g-md-2,
        .gx-md-2 {
            --bs-gutter-x: 0.46875rem
        }

        .g-md-2,
        .gy-md-2 {
            --bs-gutter-y: 0.46875rem
        }

        .g-md-3,
        .gx-md-3 {
            --bs-gutter-x: 0.624999375rem
        }

        .g-md-3,
        .gy-md-3 {
            --bs-gutter-y: 0.624999375rem
        }

        .g-md-4,
        .gx-md-4 {
            --bs-gutter-x: 0.9375rem
        }

        .g-md-4,
        .gy-md-4 {
            --bs-gutter-y: 0.9375rem
        }

        .g-md-5,
        .gx-md-5 {
            --bs-gutter-x: 1.2500000001rem
        }

        .g-md-5,
        .gy-md-5 {
            --bs-gutter-y: 1.2500000001rem
        }

        .g-md-6,
        .gx-md-6 {
            --bs-gutter-x: 1.875rem
        }

        .g-md-6,
        .gy-md-6 {
            --bs-gutter-y: 1.875rem
        }

        .g-md-7,
        .gx-md-7 {
            --bs-gutter-x: 2.8125rem
        }

        .g-md-7,
        .gy-md-7 {
            --bs-gutter-y: 2.8125rem
        }

        .g-md-8,
        .gx-md-8 {
            --bs-gutter-x: 3.75rem
        }

        .g-md-8,
        .gy-md-8 {
            --bs-gutter-y: 3.75rem
        }

        .g-md-9,
        .gx-md-9 {
            --bs-gutter-x: 5.625rem
        }

        .g-md-9,
        .gy-md-9 {
            --bs-gutter-y: 5.625rem
        }

        .g-md-10,
        .gx-md-10 {
            --bs-gutter-x: 8.4375rem
        }

        .g-md-10,
        .gy-md-10 {
            --bs-gutter-y: 8.4375rem
        }
    }

    @media(min-width:992px) {
        .col-lg {
            flex: 1 0 0%
        }

        .row-cols-lg-auto>* {
            flex: 0 0 auto;
            width: auto
        }

        .row-cols-lg-1>* {
            flex: 0 0 auto;
            width: 100%
        }

        .row-cols-lg-2>* {
            flex: 0 0 auto;
            width: 50%
        }

        .row-cols-lg-3>* {
            flex: 0 0 auto;
            width: 33.3333333333%
        }

        .row-cols-lg-4>* {
            flex: 0 0 auto;
            width: 25%
        }

        .row-cols-lg-5>* {
            flex: 0 0 auto;
            width: 20%
        }

        .row-cols-lg-6>* {
            flex: 0 0 auto;
            width: 16.6666666667%
        }

        .col-lg-auto {
            flex: 0 0 auto;
            width: auto
        }

        .col-lg-1 {
            flex: 0 0 auto;
            width: 8.33333333%
        }

        .col-lg-2 {
            flex: 0 0 auto;
            width: 16.66666667%
        }

        .col-lg-3 {
            flex: 0 0 auto;
            width: 25%
        }

        .col-lg-4 {
            flex: 0 0 auto;
            width: 33.33333333%
        }

        .col-lg-5 {
            flex: 0 0 auto;
            width: 41.66666667%
        }

        .col-lg-6 {
            flex: 0 0 auto;
            width: 50%
        }

        .col-lg-7 {
            flex: 0 0 auto;
            width: 58.33333333%
        }

        .col-lg-8 {
            flex: 0 0 auto;
            width: 66.66666667%
        }

        .col-lg-9 {
            flex: 0 0 auto;
            width: 75%
        }

        .col-lg-10 {
            flex: 0 0 auto;
            width: 83.33333333%
        }

        .col-lg-11 {
            flex: 0 0 auto;
            width: 91.66666667%
        }

        .col-lg-12 {
            flex: 0 0 auto;
            width: 100%
        }

        .offset-lg-0 {
            margin-left: 0
        }

        .offset-lg-1 {
            margin-left: 8.33333333%
        }

        .offset-lg-2 {
            margin-left: 16.66666667%
        }

        .offset-lg-3 {
            margin-left: 25%
        }

        .offset-lg-4 {
            margin-left: 33.33333333%
        }

        .offset-lg-5 {
            margin-left: 41.66666667%
        }

        .offset-lg-6 {
            margin-left: 50%
        }

        .offset-lg-7 {
            margin-left: 58.33333333%
        }

        .offset-lg-8 {
            margin-left: 66.66666667%
        }

        .offset-lg-9 {
            margin-left: 75%
        }

        .offset-lg-10 {
            margin-left: 83.33333333%
        }

        .offset-lg-11 {
            margin-left: 91.66666667%
        }

        .g-lg-0,
        .gx-lg-0 {
            --bs-gutter-x: 0
        }

        .g-lg-0,
        .gy-lg-0 {
            --bs-gutter-y: 0
        }

        .g-lg-1,
        .gx-lg-1 {
            --bs-gutter-x: 0.234375rem
        }

        .g-lg-1,
        .gy-lg-1 {
            --bs-gutter-y: 0.234375rem
        }

        .g-lg-2,
        .gx-lg-2 {
            --bs-gutter-x: 0.46875rem
        }

        .g-lg-2,
        .gy-lg-2 {
            --bs-gutter-y: 0.46875rem
        }

        .g-lg-3,
        .gx-lg-3 {
            --bs-gutter-x: 0.624999375rem
        }

        .g-lg-3,
        .gy-lg-3 {
            --bs-gutter-y: 0.624999375rem
        }

        .g-lg-4,
        .gx-lg-4 {
            --bs-gutter-x: 0.9375rem
        }

        .g-lg-4,
        .gy-lg-4 {
            --bs-gutter-y: 0.9375rem
        }

        .g-lg-5,
        .gx-lg-5 {
            --bs-gutter-x: 1.2500000001rem
        }

        .g-lg-5,
        .gy-lg-5 {
            --bs-gutter-y: 1.2500000001rem
        }

        .g-lg-6,
        .gx-lg-6 {
            --bs-gutter-x: 1.875rem
        }

        .g-lg-6,
        .gy-lg-6 {
            --bs-gutter-y: 1.875rem
        }

        .g-lg-7,
        .gx-lg-7 {
            --bs-gutter-x: 2.8125rem
        }

        .g-lg-7,
        .gy-lg-7 {
            --bs-gutter-y: 2.8125rem
        }

        .g-lg-8,
        .gx-lg-8 {
            --bs-gutter-x: 3.75rem
        }

        .g-lg-8,
        .gy-lg-8 {
            --bs-gutter-y: 3.75rem
        }

        .g-lg-9,
        .gx-lg-9 {
            --bs-gutter-x: 5.625rem
        }

        .g-lg-9,
        .gy-lg-9 {
            --bs-gutter-y: 5.625rem
        }

        .g-lg-10,
        .gx-lg-10 {
            --bs-gutter-x: 8.4375rem
        }

        .g-lg-10,
        .gy-lg-10 {
            --bs-gutter-y: 8.4375rem
        }
    }

    @media(min-width:1200px) {
        .col-xl {
            flex: 1 0 0%
        }

        .row-cols-xl-auto>* {
            flex: 0 0 auto;
            width: auto
        }

        .row-cols-xl-1>* {
            flex: 0 0 auto;
            width: 100%
        }

        .row-cols-xl-2>* {
            flex: 0 0 auto;
            width: 50%
        }

        .row-cols-xl-3>* {
            flex: 0 0 auto;
            width: 33.3333333333%
        }

        .row-cols-xl-4>* {
            flex: 0 0 auto;
            width: 25%
        }

        .row-cols-xl-5>* {
            flex: 0 0 auto;
            width: 20%
        }

        .row-cols-xl-6>* {
            flex: 0 0 auto;
            width: 16.6666666667%
        }

        .col-xl-auto {
            flex: 0 0 auto;
            width: auto
        }

        .col-xl-1 {
            flex: 0 0 auto;
            width: 8.33333333%
        }

        .col-xl-2 {
            flex: 0 0 auto;
            width: 16.66666667%
        }

        .col-xl-3 {
            flex: 0 0 auto;
            width: 25%
        }

        .col-xl-4 {
            flex: 0 0 auto;
            width: 33.33333333%
        }

        .col-xl-5 {
            flex: 0 0 auto;
            width: 41.66666667%
        }

        .col-xl-6 {
            flex: 0 0 auto;
            width: 50%
        }

        .col-xl-7 {
            flex: 0 0 auto;
            width: 58.33333333%
        }

        .col-xl-8 {
            flex: 0 0 auto;
            width: 66.66666667%
        }

        .col-xl-9 {
            flex: 0 0 auto;
            width: 75%
        }

        .col-xl-10 {
            flex: 0 0 auto;
            width: 83.33333333%
        }

        .col-xl-11 {
            flex: 0 0 auto;
            width: 91.66666667%
        }

        .col-xl-12 {
            flex: 0 0 auto;
            width: 100%
        }

        .offset-xl-0 {
            margin-left: 0
        }

        .offset-xl-1 {
            margin-left: 8.33333333%
        }

        .offset-xl-2 {
            margin-left: 16.66666667%
        }

        .offset-xl-3 {
            margin-left: 25%
        }

        .offset-xl-4 {
            margin-left: 33.33333333%
        }

        .offset-xl-5 {
            margin-left: 41.66666667%
        }

        .offset-xl-6 {
            margin-left: 50%
        }

        .offset-xl-7 {
            margin-left: 58.33333333%
        }

        .offset-xl-8 {
            margin-left: 66.66666667%
        }

        .offset-xl-9 {
            margin-left: 75%
        }

        .offset-xl-10 {
            margin-left: 83.33333333%
        }

        .offset-xl-11 {
            margin-left: 91.66666667%
        }

        .g-xl-0,
        .gx-xl-0 {
            --bs-gutter-x: 0
        }

        .g-xl-0,
        .gy-xl-0 {
            --bs-gutter-y: 0
        }

        .g-xl-1,
        .gx-xl-1 {
            --bs-gutter-x: 0.234375rem
        }

        .g-xl-1,
        .gy-xl-1 {
            --bs-gutter-y: 0.234375rem
        }

        .g-xl-2,
        .gx-xl-2 {
            --bs-gutter-x: 0.46875rem
        }

        .g-xl-2,
        .gy-xl-2 {
            --bs-gutter-y: 0.46875rem
        }

        .g-xl-3,
        .gx-xl-3 {
            --bs-gutter-x: 0.624999375rem
        }

        .g-xl-3,
        .gy-xl-3 {
            --bs-gutter-y: 0.624999375rem
        }

        .g-xl-4,
        .gx-xl-4 {
            --bs-gutter-x: 0.9375rem
        }

        .g-xl-4,
        .gy-xl-4 {
            --bs-gutter-y: 0.9375rem
        }

        .g-xl-5,
        .gx-xl-5 {
            --bs-gutter-x: 1.2500000001rem
        }

        .g-xl-5,
        .gy-xl-5 {
            --bs-gutter-y: 1.2500000001rem
        }

        .g-xl-6,
        .gx-xl-6 {
            --bs-gutter-x: 1.875rem
        }

        .g-xl-6,
        .gy-xl-6 {
            --bs-gutter-y: 1.875rem
        }

        .g-xl-7,
        .gx-xl-7 {
            --bs-gutter-x: 2.8125rem
        }

        .g-xl-7,
        .gy-xl-7 {
            --bs-gutter-y: 2.8125rem
        }

        .g-xl-8,
        .gx-xl-8 {
            --bs-gutter-x: 3.75rem
        }

        .g-xl-8,
        .gy-xl-8 {
            --bs-gutter-y: 3.75rem
        }

        .g-xl-9,
        .gx-xl-9 {
            --bs-gutter-x: 5.625rem
        }

        .g-xl-9,
        .gy-xl-9 {
            --bs-gutter-y: 5.625rem
        }

        .g-xl-10,
        .gx-xl-10 {
            --bs-gutter-x: 8.4375rem
        }

        .g-xl-10,
        .gy-xl-10 {
            --bs-gutter-y: 8.4375rem
        }
    }

    @media(min-width:1400px) {
        .col-xxl {
            flex: 1 0 0%
        }

        .row-cols-xxl-auto>* {
            flex: 0 0 auto;
            width: auto
        }

        .row-cols-xxl-1>* {
            flex: 0 0 auto;
            width: 100%
        }

        .row-cols-xxl-2>* {
            flex: 0 0 auto;
            width: 50%
        }

        .row-cols-xxl-3>* {
            flex: 0 0 auto;
            width: 33.3333333333%
        }

        .row-cols-xxl-4>* {
            flex: 0 0 auto;
            width: 25%
        }

        .row-cols-xxl-5>* {
            flex: 0 0 auto;
            width: 20%
        }

        .row-cols-xxl-6>* {
            flex: 0 0 auto;
            width: 16.6666666667%
        }

        .col-xxl-auto {
            flex: 0 0 auto;
            width: auto
        }

        .col-xxl-1 {
            flex: 0 0 auto;
            width: 8.33333333%
        }

        .col-xxl-2 {
            flex: 0 0 auto;
            width: 16.66666667%
        }

        .col-xxl-3 {
            flex: 0 0 auto;
            width: 25%
        }

        .col-xxl-4 {
            flex: 0 0 auto;
            width: 33.33333333%
        }

        .col-xxl-5 {
            flex: 0 0 auto;
            width: 41.66666667%
        }

        .col-xxl-6 {
            flex: 0 0 auto;
            width: 50%
        }

        .col-xxl-7 {
            flex: 0 0 auto;
            width: 58.33333333%
        }

        .col-xxl-8 {
            flex: 0 0 auto;
            width: 66.66666667%
        }

        .col-xxl-9 {
            flex: 0 0 auto;
            width: 75%
        }

        .col-xxl-10 {
            flex: 0 0 auto;
            width: 83.33333333%
        }

        .col-xxl-11 {
            flex: 0 0 auto;
            width: 91.66666667%
        }

        .col-xxl-12 {
            flex: 0 0 auto;
            width: 100%
        }

        .offset-xxl-0 {
            margin-left: 0
        }

        .offset-xxl-1 {
            margin-left: 8.33333333%
        }

        .offset-xxl-2 {
            margin-left: 16.66666667%
        }

        .offset-xxl-3 {
            margin-left: 25%
        }

        .offset-xxl-4 {
            margin-left: 33.33333333%
        }

        .offset-xxl-5 {
            margin-left: 41.66666667%
        }

        .offset-xxl-6 {
            margin-left: 50%
        }

        .offset-xxl-7 {
            margin-left: 58.33333333%
        }

        .offset-xxl-8 {
            margin-left: 66.66666667%
        }

        .offset-xxl-9 {
            margin-left: 75%
        }

        .offset-xxl-10 {
            margin-left: 83.33333333%
        }

        .offset-xxl-11 {
            margin-left: 91.66666667%
        }

        .g-xxl-0,
        .gx-xxl-0 {
            --bs-gutter-x: 0
        }

        .g-xxl-0,
        .gy-xxl-0 {
            --bs-gutter-y: 0
        }

        .g-xxl-1,
        .gx-xxl-1 {
            --bs-gutter-x: 0.234375rem
        }

        .g-xxl-1,
        .gy-xxl-1 {
            --bs-gutter-y: 0.234375rem
        }

        .g-xxl-2,
        .gx-xxl-2 {
            --bs-gutter-x: 0.46875rem
        }

        .g-xxl-2,
        .gy-xxl-2 {
            --bs-gutter-y: 0.46875rem
        }

        .g-xxl-3,
        .gx-xxl-3 {
            --bs-gutter-x: 0.624999375rem
        }

        .g-xxl-3,
        .gy-xxl-3 {
            --bs-gutter-y: 0.624999375rem
        }

        .g-xxl-4,
        .gx-xxl-4 {
            --bs-gutter-x: 0.9375rem
        }

        .g-xxl-4,
        .gy-xxl-4 {
            --bs-gutter-y: 0.9375rem
        }

        .g-xxl-5,
        .gx-xxl-5 {
            --bs-gutter-x: 1.2500000001rem
        }

        .g-xxl-5,
        .gy-xxl-5 {
            --bs-gutter-y: 1.2500000001rem
        }

        .g-xxl-6,
        .gx-xxl-6 {
            --bs-gutter-x: 1.875rem
        }

        .g-xxl-6,
        .gy-xxl-6 {
            --bs-gutter-y: 1.875rem
        }

        .g-xxl-7,
        .gx-xxl-7 {
            --bs-gutter-x: 2.8125rem
        }

        .g-xxl-7,
        .gy-xxl-7 {
            --bs-gutter-y: 2.8125rem
        }

        .g-xxl-8,
        .gx-xxl-8 {
            --bs-gutter-x: 3.75rem
        }

        .g-xxl-8,
        .gy-xxl-8 {
            --bs-gutter-y: 3.75rem
        }

        .g-xxl-9,
        .gx-xxl-9 {
            --bs-gutter-x: 5.625rem
        }

        .g-xxl-9,
        .gy-xxl-9 {
            --bs-gutter-y: 5.625rem
        }

        .g-xxl-10,
        .gx-xxl-10 {
            --bs-gutter-x: 8.4375rem
        }

        .g-xxl-10,
        .gy-xxl-10 {
            --bs-gutter-y: 8.4375rem
        }
    }

    .table {
        --bs-table-color: var(--bs-body-color);
        --bs-table-bg: transparent;
        --bs-table-accent-bg: transparent;
        --bs-table-striped-color: var(--bs-body-color);
        --bs-table-striped-bg: rgba(0, 0, 0, .05);
        --bs-table-active-color: var(--bs-body-color);
        --bs-table-active-bg: rgba(0, 186, 199, .1);
        --bs-table-hover-color: var(--bs-body-color);
        --bs-table-hover-bg: rgba(0, 186, 199, .1);
        border-color: var(--bs-table-border-color);
        color: var(--bs-table-color);
        margin-bottom: 1.875rem;
        vertical-align: top;
        width: 100%
    }

    .table>:not(caption)>*>* {
        background-color: var(--bs-table-bg);
        border-bottom-width: 1px;
        box-shadow: inset 0 0 0 9999px var(--bs-table-accent-bg);
        padding: 1rem 1.25rem
    }

    .table>tbody {
        vertical-align: inherit
    }

    .table>thead {
        vertical-align: bottom
    }

    .table-group-divider {
        border-top: 2px solid
    }

    .caption-top {
        caption-side: top
    }

    .table-sm>:not(caption)>*>* {
        padding: .5rem 1.25rem
    }

    .table-bordered>:not(caption)>* {
        border-width: 1px 0
    }

    .table-bordered>:not(caption)>*>* {
        border-width: 0 1px
    }

    .table-borderless>:not(caption)>*>* {
        border-bottom-width: 0
    }

    .table-borderless>:not(:first-child) {
        border-top-width: 0
    }

    .table-striped-columns>:not(caption)>tr>:nth-child(2n),
    .table-striped>tbody>tr:nth-of-type(odd)>* {
        --bs-table-accent-bg: var(--bs-table-striped-bg);
        color: var(--bs-table-striped-color)
    }

    .table-active {
        --bs-table-accent-bg: var(--bs-table-active-bg);
        color: var(--bs-table-active-color)
    }

    .table-hover>tbody>tr:hover>* {
        --bs-table-accent-bg: var(--bs-table-hover-bg);
        color: var(--bs-table-hover-color)
    }

    .table-primary {
        --bs-table-color: #000;
        --bs-table-bg: #ccf1f4;
        --bs-table-border-color: #b8d9dc;
        --bs-table-striped-bg: #c2e5e8;
        --bs-table-striped-color: #000;
        --bs-table-active-bg: #b8d9dc;
        --bs-table-active-color: #fff;
        --bs-table-hover-bg: #b8d9dc;
        --bs-table-hover-color: #fff;
        border-color: var(--bs-table-border-color);
        color: var(--bs-table-color)
    }

    .table-secondary {
        --bs-table-color: #000;
        --bs-table-bg: #eceef0;
        --bs-table-border-color: #d4d6d8;
        --bs-table-striped-bg: #e0e2e4;
        --bs-table-striped-color: #000;
        --bs-table-active-bg: #d4d6d8;
        --bs-table-active-color: #000;
        --bs-table-hover-bg: #d4d6d8;
        --bs-table-hover-color: #000
    }

    .table-secondary,
    .table-success {
        border-color: var(--bs-table-border-color);
        color: var(--bs-table-color)
    }

    .table-success {
        --bs-table-color: #000;
        --bs-table-bg: #d6f5e6;
        --bs-table-border-color: #c1ddcf;
        --bs-table-striped-bg: #cbe9db;
        --bs-table-striped-color: #000;
        --bs-table-active-bg: #c1ddcf;
        --bs-table-active-color: #000;
        --bs-table-hover-bg: #c1ddcf;
        --bs-table-hover-color: #000
    }

    .table-info {
        --bs-table-color: #000;
        --bs-table-bg: #d5eff5;
        --bs-table-border-color: #c0d7dd;
        --bs-table-striped-bg: #cae3e9;
        --bs-table-striped-color: #000;
        --bs-table-active-bg: #c0d7dd;
        --bs-table-active-color: #000;
        --bs-table-hover-bg: #c0d7dd;
        --bs-table-hover-color: #000
    }

    .table-info,
    .table-warning {
        border-color: var(--bs-table-border-color);
        color: var(--bs-table-color)
    }

    .table-warning {
        --bs-table-color: #000;
        --bs-table-bg: #fbf5dc;
        --bs-table-border-color: #e2ddc6;
        --bs-table-striped-bg: #eee9d1;
        --bs-table-striped-color: #000;
        --bs-table-active-bg: #e2ddc6;
        --bs-table-active-color: #000;
        --bs-table-hover-bg: #e2ddc6;
        --bs-table-hover-color: #000
    }

    .table-danger {
        --bs-table-color: #000;
        --bs-table-bg: #f7d5de;
        --bs-table-border-color: #dec0c8;
        --bs-table-striped-bg: #ebcad3;
        --bs-table-striped-color: #fff;
        --bs-table-active-bg: #dec0c8;
        --bs-table-active-color: #fff;
        --bs-table-hover-bg: #dec0c8;
        --bs-table-hover-color: #fff
    }

    .table-danger,
    .table-light {
        border-color: var(--bs-table-border-color);
        color: var(--bs-table-color)
    }

    .table-light {
        --bs-table-color: #000;
        --bs-table-bg: #f6f7f8;
        --bs-table-border-color: #dddedf;
        --bs-table-striped-bg: #eaebec;
        --bs-table-striped-color: #000;
        --bs-table-active-bg: #dddedf;
        --bs-table-active-color: #000;
        --bs-table-hover-bg: #dddedf;
        --bs-table-hover-color: #000
    }

    .table-dark {
        --bs-table-color: #fff;
        --bs-table-bg: #0e2238;
        --bs-table-border-color: #26384c;
        --bs-table-striped-bg: #1a2d42;
        --bs-table-striped-color: #fff;
        --bs-table-active-bg: #26384c;
        --bs-table-active-color: #fff;
        --bs-table-hover-bg: #26384c;
        --bs-table-hover-color: #fff;
        border-color: var(--bs-table-border-color);
        color: var(--bs-table-color)
    }

    .table-responsive {
        -webkit-overflow-scrolling: touch;
        overflow-x: auto
    }

    @media(max-width:575.98px) {
        .table-responsive-sm {
            -webkit-overflow-scrolling: touch;
            overflow-x: auto
        }
    }

    @media(max-width:767.98px) {
        .table-responsive-md {
            -webkit-overflow-scrolling: touch;
            overflow-x: auto
        }
    }

    @media(max-width:991.98px) {
        .table-responsive-lg {
            -webkit-overflow-scrolling: touch;
            overflow-x: auto
        }
    }

    @media(max-width:1199.98px) {
        .table-responsive-xl {
            -webkit-overflow-scrolling: touch;
            overflow-x: auto
        }
    }

    @media(max-width:1399.98px) {
        .table-responsive-xxl {
            -webkit-overflow-scrolling: touch;
            overflow-x: auto
        }
    }

    .form-label {
        font-size: .75rem;
        font-weight: 700;
        margin-bottom: .3125rem
    }

    .col-form-label {
        font-size: inherit;
        font-weight: 700;
        line-height: 1.5;
        margin-bottom: 0;
        padding-bottom: calc(.625rem + 1px);
        padding-top: calc(.625rem + 1px)
    }

    .col-form-label-lg {
        font-size: 1rem;
        padding-bottom: calc(.6875rem + 1px);
        padding-top: calc(.6875rem + 1px)
    }

    .col-form-label-sm {
        font-size: .6875rem;
        padding-bottom: calc(.375rem + 1px);
        padding-top: calc(.375rem + 1px)
    }

    .form-text {
        color: rgba(var(--bs-body-color-rgb), .3525);
        font-size: .85715em;
        margin-top: .25rem
    }

    .form-control {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        background-clip: padding-box;
        background-color: var(--bs-form-control-bg);
        border: 1px solid var(--bs-gray-300);
        border-radius: .625rem;
        box-shadow: 0 0 transparent;
        color: var(--bs-body-color);
        display: block;
        font-size: .75rem;
        font-weight: 400;
        line-height: 1.5;
        padding: .625rem .75rem;
        transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        width: 100%
    }

    @media(prefers-reduced-motion:reduce) {
        .form-control {
            transition: none
        }
    }

    .form-control[type=file] {
        overflow: hidden
    }

    .form-control[type=file]:not(:disabled):not([readonly]) {
        cursor: pointer
    }

    .form-control:focus {
        background-color: var(--bs-form-control-bg);
        border-color: {{ $settings->website_theme }};
        box-shadow: 0 0 transparent, 0 0 .75rem 0 rgba(0, 186, 199, .25);
        color: var(--bs-body-color);
        outline: 0
    }

    .form-control::-webkit-date-and-time-value {
        height: 1.5em
    }

    .form-control::-moz-placeholder {
        color: rgba(var(--bs-body-color-rgb), .4);
        opacity: 1
    }

    .form-control::placeholder {
        color: rgba(var(--bs-body-color-rgb), .4);
        opacity: 1
    }

    .form-control:disabled {
        background-color: #edeef0;
        opacity: 1
    }

    .form-control::-webkit-file-upload-button {
        -webkit-margin-end: .75rem;
        background-color: #edeef0;
        border: 0 solid;
        border-color: inherit;
        border-inline-end-width: 1px;
        border-radius: 0;
        color: var(--bs-body-color);
        margin: -.625rem -.75rem;
        margin-inline-end: .75rem;
        padding: .625rem .75rem;
        pointer-events: none;
        -webkit-transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out
    }

    .form-control::file-selector-button {
        -webkit-margin-end: .75rem;
        background-color: #edeef0;
        border: 0 solid;
        border-color: inherit;
        border-inline-end-width: 1px;
        border-radius: 0;
        color: var(--bs-body-color);
        margin: -.625rem -.75rem;
        margin-inline-end: .75rem;
        padding: .625rem .75rem;
        pointer-events: none;
        transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out
    }

    @media(prefers-reduced-motion:reduce) {
        .form-control::-webkit-file-upload-button {
            -webkit-transition: none;
            transition: none
        }

        .form-control::file-selector-button {
            transition: none
        }
    }

    .form-control:hover:not(:disabled):not([readonly])::-webkit-file-upload-button {
        background-color: #e1e2e4
    }

    .form-control:hover:not(:disabled):not([readonly])::file-selector-button {
        background-color: #e1e2e4
    }

    .form-control-plaintext {
        background-color: transparent;
        border: solid transparent;
        border-width: 1px 0;
        color: #0e2238;
        display: block;
        line-height: 1.5;
        margin-bottom: 0;
        padding: .625rem 0;
        width: 100%
    }

    .form-control-plaintext:focus {
        outline: 0
    }

    .form-control-plaintext.form-control-lg,
    .form-control-plaintext.form-control-sm {
        padding-left: 0;
        padding-right: 0
    }

    .form-control-sm {
        border-radius: .625rem;
        font-size: .6875rem;
        min-height: calc(1.5em + .75rem + 2px);
        padding: .375rem .5rem
    }

    .form-control-sm::-webkit-file-upload-button {
        -webkit-margin-end: .5rem;
        margin: -.375rem -.5rem;
        margin-inline-end: .5rem;
        padding: .375rem .5rem
    }

    .form-control-sm::file-selector-button {
        -webkit-margin-end: .5rem;
        margin: -.375rem -.5rem;
        margin-inline-end: .5rem;
        padding: .375rem .5rem
    }

    .form-control-lg {
        border-radius: .625rem;
        font-size: 1rem;
        min-height: calc(1.5em + 1.375rem + 2px);
        padding: .6875rem 1rem
    }

    .form-control-lg::-webkit-file-upload-button {
        -webkit-margin-end: 1rem;
        margin: -.6875rem -1rem;
        margin-inline-end: 1rem;
        padding: .6875rem 1rem
    }

    .form-control-lg::file-selector-button {
        -webkit-margin-end: 1rem;
        margin: -.6875rem -1rem;
        margin-inline-end: 1rem;
        padding: .6875rem 1rem
    }

    textarea.form-control {
        min-height: calc(1.5em + 1.25rem + 2px)
    }

    textarea.form-control-sm {
        min-height: calc(1.5em + .75rem + 2px)
    }

    textarea.form-control-lg {
        min-height: calc(1.5em + 1.375rem + 2px)
    }

    .form-control-color {
        height: calc(1.5em + 1.25rem + 2px);
        padding: .625rem;
        width: 3rem
    }

    .form-control-color:not(:disabled):not([readonly]) {
        cursor: pointer
    }

    .form-control-color::-moz-color-swatch {
        border: 0 !important;
        border-radius: .625rem
    }

    .form-control-color::-webkit-color-swatch {
        border-radius: .625rem
    }

    .form-control-color.form-control-sm {
        height: calc(1.5em + .75rem + 2px)
    }

    .form-control-color.form-control-lg {
        height: calc(1.5em + 1.375rem + 2px)
    }

    .form-select {
        -moz-padding-start: calc(.75rem - 3px);
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3E%3Cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3E%3C/svg%3E");
        background-position: right .75rem center;
        background-repeat: no-repeat;
        background-size: 16px 12px;
        border: 1px solid var(--bs-gray-300);
        border-radius: .625rem;
        box-shadow: 0 0 transparent;
        color: var(--bs-body-color);
        display: block;
        font-family: Open Sans, Segoe UI Emoji, Segoe UI Symbol, Segoe UI, Apple Color Emoji, Twemoji Mozilla, Noto Color Emoji, EmojiOne Color, Android Emoji, sans-serif, system-ui, -apple-system;
        font-size: .75rem;
        font-weight: 400;
        line-height: 1.5;
        padding: .625rem 2.25rem .625rem .75rem;
        transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        width: 100%
    }

    @media(prefers-reduced-motion:reduce) {
        .form-select {
            transition: none
        }
    }

    .form-select:focus {
        border-color: {{ $settings->website_theme }};

        box-shadow: 0 0 transparent, 0 0 transparent;outline:0}.form-select[multiple],.form-select[size]:not([size="1"]) {
            background-image: none;
            padding-right: .75rem
        }

        .form-select:disabled {
            background-color: #f4f4f4
        }

        .form-select:-moz-focusring {
            color: transparent;
            text-shadow: 0 0 0 var(--bs-body-color)
        }

        .form-select-sm {
            border-radius: .625rem;
            font-size: .6875rem;
            padding-bottom: .375rem;
            padding-left: .5rem;
            padding-top: .375rem
        }

        .form-select-lg {
            border-radius: .625rem;
            font-size: 1rem;
            padding-bottom: .6875rem;
            padding-left: 1rem;
            padding-top: .6875rem
        }

        .form-check {
            display: block;
            margin-bottom: 1.125rem;
            min-height: 1.3125rem;
            padding-left: 1.5rem
        }

        .form-check .form-check-input {
            float: left;
            margin-left: -1.5rem
        }

        .form-check-reverse {
            padding-left: 0;
            padding-right: 1.5rem;
            text-align: right
        }

        .form-check-reverse .form-check-input {
            float: right;
            margin-left: 0;
            margin-right: -1.5rem
        }

        .form-check-input {
            color-adjust: exact;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-color: var(--bs-form-control-bg);
            background-position: 50%;
            background-repeat: no-repeat;
            background-size: contain;
            border: 1px solid var(--bs-gray-300);
            height: 1rem;
            margin-top: .25rem;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            vertical-align: top;
            width: 1rem
        }

        .form-check-input[type=checkbox] {
            border-radius: .1875rem
        }

        .form-check-input[type=radio] {
            border-radius: 50%
        }

        .form-check-input:active {
            filter: brightness(100%)
        }

        .form-check-input:focus {
            border-color: var(--bs-gray-300);
            box-shadow: 0 0 .75rem .25rem rgba(0, 186, 199, .25);
            outline: 0
        }

        .form-check-input:checked {
            background-color: {{ $settings->website_theme }};
            border-color: {{ $settings->website_theme }}
        }

        .form-check-input:checked[type=checkbox] {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23FFF' class='bi bi-check-lg' viewBox='0 0 16 16'%3E%3Cpath d='M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425a.247.247 0 0 1 .02-.022Z'/%3E%3C/svg%3E")
        }

        .form-check-input:checked[type=radio] {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3E%3Ccircle r='2' fill='%23FFF'/%3E%3C/svg%3E")
        }

        .form-check-input[type=checkbox]:indeterminate {
            background-color: {{ $settings->website_theme }};
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3E%3Cpath fill='none' stroke='%23FFF' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10h8'/%3E%3C/svg%3E");
            border-color: {{ $settings->website_theme }}
        }

        .form-check-input:disabled {
            filter: none;
            opacity: .5;
            pointer-events: none
        }

        .form-check-input:disabled~.form-check-label,
        .form-check-input[disabled]~.form-check-label {
            cursor: default;
            opacity: .5
        }

        .form-switch {
            padding-left: 3.25em
        }

        .form-switch .form-check-input {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3E%3Ccircle r='3' fill='%23D6DAE2'/%3E%3C/svg%3E");
            background-position: 0;
            border-radius: 2.75em;
            margin-left: -3.25em;
            transition: background-position .15s ease-in-out;
            width: 2.75em
        }

        @media(prefers-reduced-motion:reduce) {
            .form-switch .form-check-input {
                transition: none
            }
        }

        .form-switch .form-check-input:focus {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3E%3Ccircle r='3' fill='%23D6DAE2'/%3E%3C/svg%3E")
        }

        .form-switch .form-check-input:checked {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3E%3Ccircle r='3' fill='%23FFF'/%3E%3C/svg%3E");
            background-position: 100%
        }

        .form-switch.form-check-reverse {
            padding-left: 0;
            padding-right: 3.25em
        }

        .form-switch.form-check-reverse .form-check-input {
            margin-left: 0;
            margin-right: -3.25em
        }

        .form-check-inline {
            display: inline-block;
            margin-right: 1rem
        }

        .btn-check {
            clip: rect(0, 0, 0, 0);
            pointer-events: none;
            position: absolute
        }

        .btn-check:disabled+.btn,
        .btn-check[disabled]+.btn {
            filter: none;
            opacity: .65;
            pointer-events: none
        }

        .form-range {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-color: transparent;
            height: 1rem;
            padding: 0;
            width: 100%
        }

        .form-range:focus {
            outline: 0
        }

        .form-range:focus::-webkit-slider-thumb {
            box-shadow: 0 0 0 1px #f8fafb, 0 0 .75rem 0 rgba(0, 186, 199, .25)
        }

        .form-range:focus::-moz-range-thumb {
            box-shadow: 0 0 0 1px #f8fafb, 0 0 .75rem 0 rgba(0, 186, 199, .25)
        }

        .form-range::-moz-focus-outer {
            border: 0
        }

        .form-range::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            background-color: {{ $settings->website_theme }};
            border: 0;
            border-radius: 1rem;
            box-shadow: 0 .1rem .25rem rgba(0, 0, 0, .1);
            height: 1rem;
            margin-top: -.25rem;
            -webkit-transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            width: 1rem
        }

        @media(prefers-reduced-motion:reduce) {
            .form-range::-webkit-slider-thumb {
                -webkit-transition: none;
                transition: none
            }
        }

        .form-range::-webkit-slider-thumb:active {
            background-color: #b3eaee
        }

        .form-range::-webkit-slider-runnable-track {
            background-color: #edeef0;
            border-color: transparent;
            border-radius: 1rem;
            box-shadow: inset 0 1px 2px rgba(14, 34, 56, .07);
            color: transparent;
            cursor: pointer;
            height: .5rem;
            width: 100%
        }

        .form-range::-moz-range-thumb {
            -moz-appearance: none;
            appearance: none;
            background-color: {{ $settings->website_theme }};
            border: 0;
            border-radius: 1rem;
            box-shadow: 0 .1rem .25rem rgba(0, 0, 0, .1);
            height: 1rem;
            -moz-transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            width: 1rem
        }

        @media(prefers-reduced-motion:reduce) {
            .form-range::-moz-range-thumb {
                -moz-transition: none;
                transition: none
            }
        }

        .form-range::-moz-range-thumb:active {
            background-color: #b3eaee
        }

        .form-range::-moz-range-track {
            background-color: #edeef0;
            border-color: transparent;
            border-radius: 1rem;
            box-shadow: inset 0 1px 2px rgba(14, 34, 56, .07);
            color: transparent;
            cursor: pointer;
            height: .5rem;
            width: 100%
        }

        .form-range:disabled {
            pointer-events: none
        }

        .form-range:disabled::-webkit-slider-thumb {
            background-color: #a5abb3
        }

        .form-range:disabled::-moz-range-thumb {
            background-color: #a5abb3
        }

        .form-floating {
            position: relative
        }

        .form-floating>.form-control,
        .form-floating>.form-control-plaintext,
        .form-floating>.form-select {
            height: calc(3.5rem + 2px);
            line-height: 1.25
        }

        .form-floating>label {
            border: 1px solid transparent;
            height: 100%;
            left: 0;
            overflow: hidden;
            padding: 1rem .75rem;
            pointer-events: none;
            position: absolute;
            text-align: start;
            text-overflow: ellipsis;
            top: 0;
            transform-origin: 0 0;
            transition: opacity .1s ease-in-out, transform .1s ease-in-out;
            white-space: nowrap;
            width: 100%
        }

        @media(prefers-reduced-motion:reduce) {
            .form-floating>label {
                transition: none
            }
        }

        .form-floating>.form-control,
        .form-floating>.form-control-plaintext {
            padding: 1rem .75rem
        }

        .form-floating>.form-control-plaintext::-moz-placeholder,
        .form-floating>.form-control::-moz-placeholder {
            color: transparent
        }

        .form-floating>.form-control-plaintext::placeholder,
        .form-floating>.form-control::placeholder {
            color: transparent
        }

        .form-floating>.form-control-plaintext:not(:-moz-placeholder-shown),
        .form-floating>.form-control:not(:-moz-placeholder-shown) {
            padding-bottom: .625rem;
            padding-top: 1.625rem
        }

        .form-floating>.form-control-plaintext:focus,
        .form-floating>.form-control-plaintext:not(:placeholder-shown),
        .form-floating>.form-control:focus,
        .form-floating>.form-control:not(:placeholder-shown) {
            padding-bottom: .625rem;
            padding-top: 1.625rem
        }

        .form-floating>.form-control-plaintext:-webkit-autofill,
        .form-floating>.form-control:-webkit-autofill {
            padding-bottom: .625rem;
            padding-top: 1.625rem
        }

        .form-floating>.form-select {
            padding-bottom: .625rem;
            padding-top: 1.625rem
        }

        .form-floating>.form-control:not(:-moz-placeholder-shown)~label {
            opacity: .65;
            transform: scale(.85) translateY(-.5rem) translateX(.15rem)
        }

        .form-floating>.form-control-plaintext~label,
        .form-floating>.form-control:focus~label,
        .form-floating>.form-control:not(:placeholder-shown)~label,
        .form-floating>.form-select~label {
            opacity: .65;
            transform: scale(.85) translateY(-.5rem) translateX(.15rem)
        }

        .form-floating>.form-control:-webkit-autofill~label {
            opacity: .65;
            transform: scale(.85) translateY(-.5rem) translateX(.15rem)
        }

        .form-floating>.form-control-plaintext~label {
            border-width: 1px 0
        }

        .input-group {
            align-items: stretch;
            display: flex;
            flex-wrap: wrap;
            position: relative;
            width: 100%
        }

        .input-group>.form-control,
        .input-group>.form-floating,
        .input-group>.form-select {
            flex: 1 1 auto;
            min-width: 0;
            position: relative;
            width: 1%
        }

        .input-group>.form-control:focus,
        .input-group>.form-floating:focus-within,
        .input-group>.form-select:focus {
            z-index: 5
        }

        .input-group .btn {
            position: relative;
            z-index: 2
        }

        .input-group .btn:focus {
            z-index: 5
        }

        .input-group-text {
            align-items: center;
            background-color: var(--bs-form-control-bg);
            border: 1px solid var(--bs-gray-300);
            border-radius: .625rem;
            color: var(--bs-body-color);
            display: flex;
            font-size: .75rem;
            font-weight: 400;
            line-height: 1.5;
            padding: .625rem .75rem;
            text-align: center;
            white-space: nowrap
        }

        .input-group-lg>.btn,
        .input-group-lg>.form-control,
        .input-group-lg>.form-select,
        .input-group-lg>.input-group-text {
            border-radius: .625rem;
            font-size: 1rem;
            padding: .6875rem 1rem
        }

        .input-group-sm>.btn,
        .input-group-sm>.form-control,
        .input-group-sm>.form-select,
        .input-group-sm>.input-group-text {
            border-radius: .625rem;
            font-size: .6875rem;
            padding: .375rem .5rem
        }

        .input-group-lg>.form-select,
        .input-group-sm>.form-select {
            padding-right: 3rem
        }

        .input-group.has-validation>.dropdown-toggle:nth-last-child(n+4),
        .input-group.has-validation>.form-floating:nth-last-child(n+3)>.form-control,
        .input-group.has-validation>.form-floating:nth-last-child(n+3)>.form-select,
        .input-group.has-validation>:nth-last-child(n+3):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating),
        .input-group:not(.has-validation)>.dropdown-toggle:nth-last-child(n+3),
        .input-group:not(.has-validation)>.form-floating:not(:last-child)>.form-control,
        .input-group:not(.has-validation)>.form-floating:not(:last-child)>.form-select,
        .input-group:not(.has-validation)>:not(:last-child):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating) {
            border-bottom-right-radius: 0;
            border-top-right-radius: 0
        }

        .input-group>:not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback) {
            border-bottom-left-radius: 0;
            border-top-left-radius: 0;
            margin-left: -1px
        }

        .input-group>.form-floating:not(:first-child)>.form-control,
        .input-group>.form-floating:not(:first-child)>.form-select {
            border-bottom-left-radius: 0;
            border-top-left-radius: 0
        }

        .valid-feedback {
            color: #31cf80;
            display: none;
            font-size: .75rem;
            margin-top: .25rem;
            width: 100%
        }

        .valid-tooltip {
            background-color: #31cf80;
            border-radius: .25rem;
            color: #fff;
            display: none;
            font-size: .6875rem;
            margin-top: .1rem;
            max-width: 100%;
            padding: .46875rem .9375rem;
            position: absolute;
            top: 100%;
            z-index: 5
        }

        .is-valid~.valid-feedback,
        .is-valid~.valid-tooltip,
        .was-validated :valid~.valid-feedback,
        .was-validated :valid~.valid-tooltip {
            display: block
        }

        .form-control.is-valid,
        .was-validated .form-control:valid {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3E%3Cpath fill='%2331CF80' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3E%3C/svg%3E");
            background-position: right calc(.375em + .3125rem) center;
            background-repeat: no-repeat;
            background-size: calc(.75em + .625rem) calc(.75em + .625rem);
            border-color: #31cf80;
            padding-right: calc(1.5em + 1.25rem)
        }

        .form-control.is-valid:focus,
        .was-validated .form-control:valid:focus {
            border-color: #31cf80;
            box-shadow: 0 0 .75rem 0 rgba(49, 207, 128, .25)
        }

        .was-validated textarea.form-control:valid,
        textarea.form-control.is-valid {
            background-position: top calc(.375em + .3125rem) right calc(.375em + .3125rem);
            padding-right: calc(1.5em + 1.25rem)
        }

        .form-select.is-valid,
        .was-validated .form-select:valid{border-color:#31cf80}.form-select.is-valid:not([multiple]):not([size]),.form-select.is-valid:not([multiple])[size="1"],
        .was-validated .form-select:valid:not([multiple]):not([size]),
        .was-validated .form-select:valid:not([multiple])[size="1"] {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3E%3Cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3E%3C/svg%3E"), url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3E%3Cpath fill='%2331CF80' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3E%3C/svg%3E");
            background-position: right .75rem center, center right 2.25rem;
            background-size: 16px 12px, calc(.75em + .625rem) calc(.75em + .625rem);
            padding-right: 4.125rem
        }

        .form-select.is-valid:focus,
        .was-validated .form-select:valid:focus {
            border-color: #31cf80;
            box-shadow: 0 0 .75rem 0 rgba(49, 207, 128, .25)
        }

        .form-control-color.is-valid,
        .was-validated .form-control-color:valid {
            width: calc(4.25rem + 1.5em)
        }

        .form-check-input.is-valid,
        .was-validated .form-check-input:valid {
            border-color: #31cf80
        }

        .form-check-input.is-valid:checked,
        .was-validated .form-check-input:valid:checked {
            background-color: #31cf80
        }

        .form-check-input.is-valid:focus,
        .was-validated .form-check-input:valid:focus {
            box-shadow: 0 0 .75rem 0 rgba(49, 207, 128, .25)
        }

        .form-check-input.is-valid~.form-check-label,
        .was-validated .form-check-input:valid~.form-check-label {
            color: #31cf80
        }

        .form-check-inline .form-check-input~.valid-feedback {
            margin-left: .5em
        }

        .input-group>.form-control:not(:focus).is-valid,
        .input-group>.form-floating:not(:focus-within).is-valid,
        .input-group>.form-select:not(:focus).is-valid,
        .was-validated .input-group>.form-control:not(:focus):valid,
        .was-validated .input-group>.form-floating:not(:focus-within):valid,
        .was-validated .input-group>.form-select:not(:focus):valid {
            z-index: 3
        }

        .invalid-feedback {
            color: #d82c5b;
            display: none;
            font-size: .75rem;
            margin-top: .25rem;
            width: 100%
        }

        .invalid-tooltip {
            background-color: #d82c5b;
            border-radius: .25rem;
            color: #fff;
            display: none;
            font-size: .6875rem;
            margin-top: .1rem;
            max-width: 100%;
            padding: .46875rem .9375rem;
            position: absolute;
            top: 100%;
            z-index: 5
        }

        .is-invalid~.invalid-feedback,
        .is-invalid~.invalid-tooltip,
        .was-validated :invalid~.invalid-feedback,
        .was-validated :invalid~.invalid-tooltip {
            display: block
        }

        .form-control.is-invalid,
        .was-validated .form-control:invalid {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23D82C5B'%3E%3Ccircle cx='6' cy='6' r='4.5'/%3E%3Cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3E%3Ccircle cx='6' cy='8.2' r='.6' fill='%23D82C5B' stroke='none'/%3E%3C/svg%3E");
            background-position: right calc(.375em + .3125rem) center;
            background-repeat: no-repeat;
            background-size: calc(.75em + .625rem) calc(.75em + .625rem);
            border-color: #d82c5b;
            padding-right: calc(1.5em + 1.25rem)
        }

        .form-control.is-invalid:focus,
        .was-validated .form-control:invalid:focus {
            border-color: #d82c5b;
            box-shadow: 0 0 .75rem 0 rgba(216, 44, 91, .25)
        }

        .was-validated textarea.form-control:invalid,
        textarea.form-control.is-invalid {
            background-position: top calc(.375em + .3125rem) right calc(.375em + .3125rem);
            padding-right: calc(1.5em + 1.25rem)
        }

        .form-select.is-invalid,
        .was-validated .form-select:invalid{border-color:#d82c5b}.form-select.is-invalid:not([multiple]):not([size]),.form-select.is-invalid:not([multiple])[size="1"],
        .was-validated .form-select:invalid:not([multiple]):not([size]),
        .was-validated .form-select:invalid:not([multiple])[size="1"] {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3E%3Cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3E%3C/svg%3E"), url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23D82C5B'%3E%3Ccircle cx='6' cy='6' r='4.5'/%3E%3Cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3E%3Ccircle cx='6' cy='8.2' r='.6' fill='%23D82C5B' stroke='none'/%3E%3C/svg%3E");
            background-position: right .75rem center, center right 2.25rem;
            background-size: 16px 12px, calc(.75em + .625rem) calc(.75em + .625rem);
            padding-right: 4.125rem
        }

        .form-select.is-invalid:focus,
        .was-validated .form-select:invalid:focus {
            border-color: #d82c5b;
            box-shadow: 0 0 .75rem 0 rgba(216, 44, 91, .25)
        }

        .form-control-color.is-invalid,
        .was-validated .form-control-color:invalid {
            width: calc(4.25rem + 1.5em)
        }

        .form-check-input.is-invalid,
        .was-validated .form-check-input:invalid {
            border-color: #d82c5b
        }

        .form-check-input.is-invalid:checked,
        .was-validated .form-check-input:invalid:checked {
            background-color: #d82c5b
        }

        .form-check-input.is-invalid:focus,
        .was-validated .form-check-input:invalid:focus {
            box-shadow: 0 0 .75rem 0 rgba(216, 44, 91, .25)
        }

        .form-check-input.is-invalid~.form-check-label,
        .was-validated .form-check-input:invalid~.form-check-label {
            color: #d82c5b
        }

        .form-check-inline .form-check-input~.invalid-feedback {
            margin-left: .5em
        }

        .input-group>.form-control:not(:focus).is-invalid,
        .input-group>.form-floating:not(:focus-within).is-invalid,
        .input-group>.form-select:not(:focus).is-invalid,
        .was-validated .input-group>.form-control:not(:focus):invalid,
        .was-validated .input-group>.form-floating:not(:focus-within):invalid,
        .was-validated .input-group>.form-select:not(:focus):invalid {
            z-index: 4
        }

        .btn {
            --bs-btn-padding-x: 1.5625rem;
            --bs-btn-padding-y: 0.53125rem;
            --bs-btn-font-family: ;
            --bs-btn-font-size: 0.875rem;
            --bs-btn-font-weight: 600;
            --bs-btn-line-height: 1.5;
            --bs-btn-color: #0e2238;
            --bs-btn-bg: transparent;
            --bs-btn-border-width: 1px;
            --bs-btn-border-color: transparent;
            --bs-btn-border-radius: 1.25rem;
            --bs-btn-hover-border-color: transparent;
            --bs-btn-box-shadow: 0 0 transparent;
            --bs-btn-disabled-opacity: 0.65;
            --bs-btn-focus-box-shadow: 0 0 0 12px rgba(var(--bs-btn-focus-shadow-rgb), .5);
            background-color: var(--bs-btn-bg);
            border: var(--bs-btn-border-width) solid var(--bs-btn-border-color);
            border-radius: var(--bs-btn-border-radius);
            box-shadow: var(--bs-btn-box-shadow);
            color: var(--bs-btn-color);
            cursor: pointer;
            display: inline-block;
            font-family: var(--bs-btn-font-family);
            font-size: var(--bs-btn-font-size);
            font-weight: var(--bs-btn-font-weight);
            line-height: var(--bs-btn-line-height);
            padding: var(--bs-btn-padding-y) var(--bs-btn-padding-x);
            text-align: center;
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
            vertical-align: middle
        }

        @media(prefers-reduced-motion:reduce) {
            .btn {
                transition: none
            }
        }

        .btn:hover {
            background-color: var(--bs-btn-hover-bg);
            border-color: var(--bs-btn-hover-border-color);
            color: var(--bs-btn-hover-color)
        }

        .btn-check+.btn:hover {
            background-color: var(--bs-btn-bg);
            border-color: var(--bs-btn-border-color);
            color: var(--bs-btn-color)
        }

        .btn:focus-visible {
            background-color: var(--bs-btn-hover-bg);
            border-color: var(--bs-btn-hover-border-color);
            box-shadow: var(--bs-btn-box-shadow), var(--bs-btn-focus-box-shadow);
            color: var(--bs-btn-hover-color);
            outline: 0
        }

        .btn-check:focus-visible+.btn {
            border-color: var(--bs-btn-hover-border-color);
            box-shadow: var(--bs-btn-box-shadow), var(--bs-btn-focus-box-shadow);
            outline: 0
        }

        .btn-check:checked+.btn,
        .btn.active,
        .btn.show,
        .btn:first-child:active,
        :not(.btn-check)+.btn:active {
            background-color: var(--bs-btn-active-bg);
            border-color: var(--bs-btn-active-border-color);
            box-shadow: var(--bs-btn-active-shadow);
            color: var(--bs-btn-active-color)
        }

        .btn-check:checked+.btn:focus-visible,
        .btn.active:focus-visible,
        .btn.show:focus-visible,
        .btn:first-child:active:focus-visible,
        :not(.btn-check)+.btn:active:focus-visible {
            box-shadow: var(--bs-btn-active-shadow), var(--bs-btn-focus-box-shadow)
        }

        .btn.disabled,
        .btn:disabled,
        fieldset:disabled .btn {
            background-color: var(--bs-btn-disabled-bg);
            border-color: var(--bs-btn-disabled-border-color);
            box-shadow: none;
            color: var(--bs-btn-disabled-color);
            opacity: var(--bs-btn-disabled-opacity);
            pointer-events: none
        }

        .btn-primary {
            --bs-btn-color: #fff;
            --bs-btn-bg: {{ $settings->website_theme }};
            --bs-btn-border-color: {{ $settings->website_theme }};
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #242424;
            --bs-btn-hover-border-color: {{ $settings->website_theme }};
            --bs-btn-focus-shadow-rgb: 38, 196, 207;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: {{ $settings->website_theme }};
            --bs-btn-active-border-color: #008c95;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: {{ $settings->website_theme }};
            --bs-btn-disabled-border-color: {{ $settings->website_theme }}
        }

        .btn-secondary {
            --bs-btn-color: #fff;
            --bs-btn-bg: #9ea9b4;
            --bs-btn-border-color: #9ea9b4;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #869099;
            --bs-btn-hover-border-color: #7e8790;
            --bs-btn-focus-shadow-rgb: 173, 182, 191;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #7e8790;
            --bs-btn-active-border-color: #777f87;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #9ea9b4;
            --bs-btn-disabled-border-color: #9ea9b4
        }

        .btn-success {
            --bs-btn-color: #fff;
            --bs-btn-bg: #31cf80;
            --bs-btn-border-color: #31cf80;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2ab06d;
            --bs-btn-hover-border-color: #27a666;
            --bs-btn-focus-shadow-rgb: 80, 214, 147;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #27a666;
            --bs-btn-active-border-color: #259b60;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #31cf80;
            --bs-btn-disabled-border-color: #31cf80
        }

        .btn-info {
            --bs-btn-color: #fff;
            --bs-btn-bg: #2dadcf;
            --bs-btn-border-color: #2dadcf;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2693b0;
            --bs-btn-hover-border-color: #248aa6;
            --bs-btn-focus-shadow-rgb: 77, 185, 214;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #248aa6;
            --bs-btn-active-border-color: #22829b;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #2dadcf;
            --bs-btn-disabled-border-color: #2dadcf
        }

        .btn-warning {
            --bs-btn-color: #fff;
            --bs-btn-bg: #ebcf4f;
            --bs-btn-border-color: #ebcf4f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #c8b043;
            --bs-btn-hover-border-color: #bca63f;
            --bs-btn-focus-shadow-rgb: 238, 214, 105;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #bca63f;
            --bs-btn-active-border-color: #b09b3b;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #ebcf4f;
            --bs-btn-disabled-border-color: #ebcf4f
        }

        .btn-danger {
            --bs-btn-color: #fff;
            --bs-btn-bg: #d82c5b;
            --bs-btn-border-color: #d82c5b;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #b8254d;
            --bs-btn-hover-border-color: #ad2349;
            --bs-btn-focus-shadow-rgb: 222, 76, 116;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #ad2349;
            --bs-btn-active-border-color: #a22144;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #d82c5b;
            --bs-btn-disabled-border-color: #d82c5b
        }

        .btn-light {
            --bs-btn-color: #000;
            --bs-btn-bg: #f6f7f8;
            --bs-btn-border-color: #f6f7f8;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #d1d2d3;
            --bs-btn-hover-border-color: #c5c6c6;
            --bs-btn-focus-shadow-rgb: 209, 210, 211;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #c5c6c6;
            --bs-btn-active-border-color: #b9b9ba;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #f6f7f8;
            --bs-btn-disabled-border-color: #f6f7f8
        }

        .btn-dark {
            --bs-btn-color: #fff;
            --bs-btn-bg: #0e2238;
            --bs-btn-border-color: #0e2238;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #324356;
            --bs-btn-hover-border-color: #26384c;
            --bs-btn-focus-shadow-rgb: 50, 67, 86;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #3e4e60;
            --bs-btn-active-border-color: #26384c;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #0e2238;
            --bs-btn-disabled-border-color: #0e2238
        }

        .btn-light-green {
            --bs-btn-color: #000;
            --bs-btn-bg: #f1f5f7;
            --bs-btn-border-color: #f1f5f7;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f3f7f8;
            --bs-btn-hover-border-color: #f2f6f8;
            --bs-btn-focus-shadow-rgb: 205, 208, 210;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f4f7f9;
            --bs-btn-active-border-color: #f2f6f8;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #f1f5f7;
            --bs-btn-disabled-border-color: #f1f5f7
        }

        .btn-white {
            --bs-btn-color: #000;
            --bs-btn-bg: #fff;
            --bs-btn-border-color: #fff;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #fff;
            --bs-btn-hover-border-color: #fff;
            --bs-btn-focus-shadow-rgb: 217, 217, 217;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #fff;
            --bs-btn-active-border-color: #fff;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #fff;
            --bs-btn-disabled-border-color: #fff
        }

        .btn-black {
            --bs-btn-color: #fff;
            --bs-btn-bg: #000;
            --bs-btn-border-color: #000;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #000;
            --bs-btn-hover-border-color: #000;
            --bs-btn-focus-shadow-rgb: 38, 38, 38;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #000;
            --bs-btn-active-border-color: #000;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #000;
            --bs-btn-disabled-border-color: #000
        }

        .btn-blue {
            --bs-btn-color: #fff;
            --bs-btn-bg: #0075c7;
            --bs-btn-border-color: #0075c7;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #0063a9;
            --bs-btn-hover-border-color: #005e9f;
            --bs-btn-focus-shadow-rgb: 38, 138, 207;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #005e9f;
            --bs-btn-active-border-color: #005895;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #0075c7;
            --bs-btn-disabled-border-color: #0075c7
        }

        .btn-gray-100 {
            --bs-btn-color: #000;
            --bs-btn-bg: #f6f7f8;
            --bs-btn-border-color: #f6f7f8;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f7f8f9;
            --bs-btn-hover-border-color: #f7f8f9;
            --bs-btn-focus-shadow-rgb: 209, 210, 211;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f8f9f9;
            --bs-btn-active-border-color: #f7f8f9;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #f6f7f8;
            --bs-btn-disabled-border-color: #f6f7f8
        }

        .btn-gray-200 {
            --bs-btn-color: #000;
            --bs-btn-bg: #f4f4f4;
            --bs-btn-border-color: #f4f4f4;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f6f6f6;
            --bs-btn-hover-border-color: #f5f5f5;
            --bs-btn-focus-shadow-rgb: 207, 207, 207;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f6f6f6;
            --bs-btn-active-border-color: #f5f5f5;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #f4f4f4;
            --bs-btn-disabled-border-color: #f4f4f4
        }

        .btn-gray-300 {
            --bs-btn-color: #000;
            --bs-btn-bg: #edeef0;
            --bs-btn-border-color: #edeef0;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f0f1f2;
            --bs-btn-hover-border-color: #eff0f2;
            --bs-btn-focus-shadow-rgb: 201, 202, 204;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f1f1f3;
            --bs-btn-active-border-color: #eff0f2;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #edeef0;
            --bs-btn-disabled-border-color: #edeef0
        }

        .btn-gray-400 {
            --bs-btn-color: #000;
            --bs-btn-bg: #d6dae2;
            --bs-btn-border-color: #d6dae2;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #dce0e6;
            --bs-btn-hover-border-color: #dadee5;
            --bs-btn-focus-shadow-rgb: 182, 185, 192;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #dee1e8;
            --bs-btn-active-border-color: #dadee5;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #d6dae2;
            --bs-btn-disabled-border-color: #d6dae2
        }

        .btn-gray-500 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #a5abb3;
            --bs-btn-border-color: #a5abb3;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #8c9198;
            --bs-btn-hover-border-color: #84898f;
            --bs-btn-focus-shadow-rgb: 179, 184, 190;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #84898f;
            --bs-btn-active-border-color: #7c8086;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #a5abb3;
            --bs-btn-disabled-border-color: #a5abb3
        }

        .btn-gray-600 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #989ea6;
            --bs-btn-border-color: #989ea6;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #81868d;
            --bs-btn-hover-border-color: #7a7e85;
            --bs-btn-focus-shadow-rgb: 167, 173, 179;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #7a7e85;
            --bs-btn-active-border-color: #72777d;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #989ea6;
            --bs-btn-disabled-border-color: #989ea6
        }

        .btn-gray-700 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #707070;
            --bs-btn-border-color: #707070;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #5f5f5f;
            --bs-btn-hover-border-color: #5a5a5a;
            --bs-btn-focus-shadow-rgb: 133, 133, 133;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #5a5a5a;
            --bs-btn-active-border-color: #545454;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #707070;
            --bs-btn-disabled-border-color: #707070
        }

        .btn-gray-800 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #343a40;
            --bs-btn-border-color: #343a40;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2c3136;
            --bs-btn-hover-border-color: #2a2e33;
            --bs-btn-focus-shadow-rgb: 82, 88, 93;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #2a2e33;
            --bs-btn-active-border-color: #272c30;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #343a40;
            --bs-btn-disabled-border-color: #343a40
        }

        .btn-gray-900 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #212529;
            --bs-btn-border-color: #212529;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #1c1f23;
            --bs-btn-hover-border-color: #1a1e21;
            --bs-btn-focus-shadow-rgb: 66, 70, 73;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #1a1e21;
            --bs-btn-active-border-color: #191c1f;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #212529;
            --bs-btn-disabled-border-color: #212529
        }

        .btn-outline-primary {
            --bs-btn-color: {{ $settings->website_theme }};
            --bs-btn-border-color: {{ $settings->website_theme }};
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: {{ $settings->website_theme }};
            --bs-btn-hover-border-color: {{ $settings->website_theme }};
            --bs-btn-focus-shadow-rgb: 0, 186, 199;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: {{ $settings->website_theme }};
            --bs-btn-active-border-color: {{ $settings->website_theme }};
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: {{ $settings->website_theme }};
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: {{ $settings->website_theme }};
            --bs-gradient: none
        }

        .btn-outline-secondary {
            --bs-btn-color: #9ea9b4;
            --bs-btn-border-color: #9ea9b4;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #9ea9b4;
            --bs-btn-hover-border-color: #9ea9b4;
            --bs-btn-focus-shadow-rgb: 158, 169, 180;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #9ea9b4;
            --bs-btn-active-border-color: #9ea9b4;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #9ea9b4;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #9ea9b4;
            --bs-gradient: none
        }

        .btn-outline-success {
            --bs-btn-color: #31cf80;
            --bs-btn-border-color: #31cf80;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #31cf80;
            --bs-btn-hover-border-color: #31cf80;
            --bs-btn-focus-shadow-rgb: 49, 207, 128;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #31cf80;
            --bs-btn-active-border-color: #31cf80;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #31cf80;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #31cf80;
            --bs-gradient: none
        }

        .btn-outline-info {
            --bs-btn-color: #2dadcf;
            --bs-btn-border-color: #2dadcf;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2dadcf;
            --bs-btn-hover-border-color: #2dadcf;
            --bs-btn-focus-shadow-rgb: 45, 173, 207;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #2dadcf;
            --bs-btn-active-border-color: #2dadcf;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #2dadcf;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #2dadcf;
            --bs-gradient: none
        }

        .btn-outline-warning {
            --bs-btn-color: #ebcf4f;
            --bs-btn-border-color: #ebcf4f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #ebcf4f;
            --bs-btn-hover-border-color: #ebcf4f;
            --bs-btn-focus-shadow-rgb: 235, 207, 79;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #ebcf4f;
            --bs-btn-active-border-color: #ebcf4f;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #ebcf4f;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #ebcf4f;
            --bs-gradient: none
        }

        .btn-outline-danger {
            --bs-btn-color: #d82c5b;
            --bs-btn-border-color: #d82c5b;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #d82c5b;
            --bs-btn-hover-border-color: #d82c5b;
            --bs-btn-focus-shadow-rgb: 216, 44, 91;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #d82c5b;
            --bs-btn-active-border-color: #d82c5b;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #d82c5b;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #d82c5b;
            --bs-gradient: none
        }

        .btn-outline-light {
            --bs-btn-color: #f6f7f8;
            --bs-btn-border-color: #f6f7f8;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f6f7f8;
            --bs-btn-hover-border-color: #f6f7f8;
            --bs-btn-focus-shadow-rgb: 246, 247, 248;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f6f7f8;
            --bs-btn-active-border-color: #f6f7f8;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #f6f7f8;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #f6f7f8;
            --bs-gradient: none
        }

        .btn-outline-dark {
            --bs-btn-color: #0e2238;
            --bs-btn-border-color: #0e2238;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #0e2238;
            --bs-btn-hover-border-color: #0e2238;
            --bs-btn-focus-shadow-rgb: 14, 34, 56;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #0e2238;
            --bs-btn-active-border-color: #0e2238;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #0e2238;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #0e2238;
            --bs-gradient: none
        }

        .btn-outline-light-green {
            --bs-btn-color: #f1f5f7;
            --bs-btn-border-color: #f1f5f7;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f1f5f7;
            --bs-btn-hover-border-color: #f1f5f7;
            --bs-btn-focus-shadow-rgb: 241, 245, 247;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f1f5f7;
            --bs-btn-active-border-color: #f1f5f7;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #f1f5f7;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #f1f5f7;
            --bs-gradient: none
        }

        .btn-outline-white {
            --bs-btn-color: #fff;
            --bs-btn-border-color: #fff;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #fff;
            --bs-btn-hover-border-color: #fff;
            --bs-btn-focus-shadow-rgb: 255, 255, 255;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #fff;
            --bs-btn-active-border-color: #fff;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #fff;
            --bs-gradient: none
        }

        .btn-outline-black {
            --bs-btn-color: #000;
            --bs-btn-border-color: #000;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #000;
            --bs-btn-hover-border-color: #000;
            --bs-btn-focus-shadow-rgb: 0, 0, 0;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #000;
            --bs-btn-active-border-color: #000;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #000;
            --bs-gradient: none
        }

        .btn-outline-blue {
            --bs-btn-color: #0075c7;
            --bs-btn-border-color: #0075c7;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #0075c7;
            --bs-btn-hover-border-color: #0075c7;
            --bs-btn-focus-shadow-rgb: 0, 117, 199;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #0075c7;
            --bs-btn-active-border-color: #0075c7;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #0075c7;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #0075c7;
            --bs-gradient: none
        }

        .btn-outline-gray-100 {
            --bs-btn-color: #f6f7f8;
            --bs-btn-border-color: #f6f7f8;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f6f7f8;
            --bs-btn-hover-border-color: #f6f7f8;
            --bs-btn-focus-shadow-rgb: 246, 247, 248;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f6f7f8;
            --bs-btn-active-border-color: #f6f7f8;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #f6f7f8;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #f6f7f8;
            --bs-gradient: none
        }

        .btn-outline-gray-200 {
            --bs-btn-color: #f4f4f4;
            --bs-btn-border-color: #f4f4f4;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #f4f4f4;
            --bs-btn-hover-border-color: #f4f4f4;
            --bs-btn-focus-shadow-rgb: 244, 244, 244;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #f4f4f4;
            --bs-btn-active-border-color: #f4f4f4;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #f4f4f4;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #f4f4f4;
            --bs-gradient: none
        }

        .btn-outline-gray-300 {
            --bs-btn-color: #edeef0;
            --bs-btn-border-color: #edeef0;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #edeef0;
            --bs-btn-hover-border-color: #edeef0;
            --bs-btn-focus-shadow-rgb: 237, 238, 240;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #edeef0;
            --bs-btn-active-border-color: #edeef0;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #edeef0;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #edeef0;
            --bs-gradient: none
        }

        .btn-outline-gray-400 {
            --bs-btn-color: #d6dae2;
            --bs-btn-border-color: #d6dae2;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #d6dae2;
            --bs-btn-hover-border-color: #d6dae2;
            --bs-btn-focus-shadow-rgb: 214, 218, 226;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #d6dae2;
            --bs-btn-active-border-color: #d6dae2;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #d6dae2;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #d6dae2;
            --bs-gradient: none
        }

        .btn-outline-gray-500 {
            --bs-btn-color: #a5abb3;
            --bs-btn-border-color: #a5abb3;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #a5abb3;
            --bs-btn-hover-border-color: #a5abb3;
            --bs-btn-focus-shadow-rgb: 165, 171, 179;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #a5abb3;
            --bs-btn-active-border-color: #a5abb3;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #a5abb3;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #a5abb3;
            --bs-gradient: none
        }

        .btn-outline-gray-600 {
            --bs-btn-color: #989ea6;
            --bs-btn-border-color: #989ea6;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #989ea6;
            --bs-btn-hover-border-color: #989ea6;
            --bs-btn-focus-shadow-rgb: 152, 158, 166;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #989ea6;
            --bs-btn-active-border-color: #989ea6;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #989ea6;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #989ea6;
            --bs-gradient: none
        }

        .btn-outline-gray-700 {
            --bs-btn-color: #707070;
            --bs-btn-border-color: #707070;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #707070;
            --bs-btn-hover-border-color: #707070;
            --bs-btn-focus-shadow-rgb: 112, 112, 112;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #707070;
            --bs-btn-active-border-color: #707070;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #707070;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #707070;
            --bs-gradient: none
        }

        .btn-outline-gray-800 {
            --bs-btn-color: #343a40;
            --bs-btn-border-color: #343a40;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #343a40;
            --bs-btn-hover-border-color: #343a40;
            --bs-btn-focus-shadow-rgb: 52, 58, 64;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #343a40;
            --bs-btn-active-border-color: #343a40;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #343a40;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #343a40;
            --bs-gradient: none
        }

        .btn-outline-gray-900 {
            --bs-btn-color: #212529;
            --bs-btn-border-color: #212529;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #212529;
            --bs-btn-hover-border-color: #212529;
            --bs-btn-focus-shadow-rgb: 33, 37, 41;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #212529;
            --bs-btn-active-border-color: #212529;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #212529;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #212529;
            --bs-gradient: none
        }

        .btn-link {
            --bs-btn-font-weight: 400;
            --bs-btn-color: var(--bs-link-color);
            --bs-btn-bg: transparent;
            --bs-btn-border-color: transparent;
            --bs-btn-hover-color: var(--bs-link-hover-color);
            --bs-btn-hover-border-color: transparent;
            --bs-btn-active-color: var(--bs-link-hover-color);
            --bs-btn-active-border-color: transparent;
            --bs-btn-disabled-color: #989ea6;
            --bs-btn-disabled-border-color: transparent;
            --bs-btn-box-shadow: none;
            --bs-btn-focus-shadow-rgb: 38, 196, 207;
            text-decoration: none
        }

        .btn-link:focus-visible,
        .btn-link:hover {
            text-decoration: none
        }

        .btn-link:focus-visible {
            color: var(--bs-btn-color)
        }

        .btn-link:hover {
            color: var(--bs-btn-hover-color)
        }

        .btn-group-lg>.btn,
        .btn-lg {
            --bs-btn-padding-y: 0.6875rem;
            --bs-btn-padding-x: 1.875rem;
            --bs-btn-font-size: 1rem;
            --bs-btn-border-radius: 1.5rem
        }

        .btn-group-sm>.btn,
        .btn-sm {
            --bs-btn-padding-y: 0.375rem;
            --bs-btn-padding-x: 1.25rem;
            --bs-btn-font-size: 0.6875rem;
            --bs-btn-border-radius: 1.25rem
        }

        .fade {
            transition: opacity .15s linear
        }

        @media(prefers-reduced-motion:reduce) {
            .fade {
                transition: none
            }
        }

        .fade:not(.show) {
            opacity: 0
        }

        .collapse:not(.show) {
            display: none
        }

        .collapsing {
            height: 0;
            overflow: hidden;
            transition: height .35s ease
        }

        @media(prefers-reduced-motion:reduce) {
            .collapsing {
                transition: none
            }
        }

        .collapsing.collapse-horizontal {
            height: auto;
            transition: width .35s ease;
            width: 0
        }

        @media(prefers-reduced-motion:reduce) {
            .collapsing.collapse-horizontal {
                transition: none
            }
        }

        .dropdown,
        .dropdown-center,
        .dropend,
        .dropstart,
        .dropup,
        .dropup-center {
            position: relative
        }

        .dropdown-toggle {
            white-space: nowrap
        }

        .dropdown-toggle:after {
            border-bottom: 0;
            border-left: .75em solid transparent;
            border-right: .75em solid transparent;
            border-top: .75em solid;
            margin-left: 1.3125em;
            vertical-align: .6375em
        }

        .dropdown-toggle:empty:after {
            margin-left: 0
        }

        .dropdown-menu {
            --bs-dropdown-zindex: 1000;
            --bs-dropdown-min-width: 10rem;
            --bs-dropdown-padding-x: 0;
            --bs-dropdown-padding-y: 0.375rem;
            --bs-dropdown-spacer: 0.625rem;
            --bs-dropdown-font-size: 0.875rem;
            --bs-dropdown-color: var(--bs-body-color);
            --bs-dropdown-bg: #fff;
            --bs-dropdown-border-color: var(--bs-border-color);
            --bs-dropdown-border-radius: 0.625rem;
            --bs-dropdown-border-width: 0;
            --bs-dropdown-inner-border-radius: 0.625rem;
            --bs-dropdown-divider-bg: #edeef0;
            --bs-dropdown-divider-margin-y: 0.46875rem;
            --bs-dropdown-box-shadow: 0 1rem 3rem rgba(14, 34, 56, .1);
            --bs-dropdown-link-color: var(--bs-body-color);
            --bs-dropdown-link-hover-color: #0d1f32;
            --bs-dropdown-link-hover-bg: var(--bs-gray-100);
            --bs-dropdown-link-active-color: #0d1f32;
            --bs-dropdown-link-active-bg: var(--bs-gray-100);
            --bs-dropdown-link-disabled-color: #a5abb3;
            --bs-dropdown-item-padding-x: 0.9375rem;
            --bs-dropdown-item-padding-y: 0.46875rem;
            --bs-dropdown-header-color: var(--bs-secondary);
            --bs-dropdown-header-padding-x: 0.9375rem;
            --bs-dropdown-header-padding-y: 0.375rem;
            background-clip: padding-box;
            background-color: var(--bs-dropdown-bg);
            border: var(--bs-dropdown-border-width) solid var(--bs-dropdown-border-color);
            border-radius: var(--bs-dropdown-border-radius);
            box-shadow: var(--bs-dropdown-box-shadow);
            color: var(--bs-dropdown-color);
            display: none;
            font-size: var(--bs-dropdown-font-size);
            list-style: none;
            margin: 0;
            min-width: var(--bs-dropdown-min-width);
            padding: var(--bs-dropdown-padding-y) var(--bs-dropdown-padding-x);
            position: absolute;
            text-align: left;
            z-index: var(--bs-dropdown-zindex)
        }

        .dropdown-menu[data-bs-popper] {
            left: 0;
            margin-top: var(--bs-dropdown-spacer);
            top: 100%
        }

        .dropdown-menu-start {
            --bs-position: start
        }

        .dropdown-menu-start[data-bs-popper] {
            left: 0;
            right: auto
        }

        .dropdown-menu-end {
            --bs-position: end
        }

        .dropdown-menu-end[data-bs-popper] {
            left: auto;
            right: 0
        }

        @media(min-width:576px) {
            .dropdown-menu-sm-start {
                --bs-position: start
            }

            .dropdown-menu-sm-start[data-bs-popper] {
                left: 0;
                right: auto
            }

            .dropdown-menu-sm-end {
                --bs-position: end
            }

            .dropdown-menu-sm-end[data-bs-popper] {
                left: auto;
                right: 0
            }
        }

        @media(min-width:768px) {
            .dropdown-menu-md-start {
                --bs-position: start
            }

            .dropdown-menu-md-start[data-bs-popper] {
                left: 0;
                right: auto
            }

            .dropdown-menu-md-end {
                --bs-position: end
            }

            .dropdown-menu-md-end[data-bs-popper] {
                left: auto;
                right: 0
            }
        }

        @media(min-width:992px) {
            .dropdown-menu-lg-start {
                --bs-position: start
            }

            .dropdown-menu-lg-start[data-bs-popper] {
                left: 0;
                right: auto
            }

            .dropdown-menu-lg-end {
                --bs-position: end
            }

            .dropdown-menu-lg-end[data-bs-popper] {
                left: auto;
                right: 0
            }
        }

        @media(min-width:1200px) {
            .dropdown-menu-xl-start {
                --bs-position: start
            }

            .dropdown-menu-xl-start[data-bs-popper] {
                left: 0;
                right: auto
            }

            .dropdown-menu-xl-end {
                --bs-position: end
            }

            .dropdown-menu-xl-end[data-bs-popper] {
                left: auto;
                right: 0
            }
        }

        @media(min-width:1400px) {
            .dropdown-menu-xxl-start {
                --bs-position: start
            }

            .dropdown-menu-xxl-start[data-bs-popper] {
                left: 0;
                right: auto
            }

            .dropdown-menu-xxl-end {
                --bs-position: end
            }

            .dropdown-menu-xxl-end[data-bs-popper] {
                left: auto;
                right: 0
            }
        }

        .dropup .dropdown-menu[data-bs-popper] {
            bottom: 100%;
            margin-bottom: var(--bs-dropdown-spacer);
            margin-top: 0;
            top: auto
        }

        .dropup .dropdown-toggle:after {
            border-bottom: .75em solid;
            border-left: .75em solid transparent;
            border-right: .75em solid transparent;
            border-top: 0;
            margin-left: 1.3125em;
            vertical-align: .6375em
        }

        .dropup .dropdown-toggle:empty:after {
            margin-left: 0
        }

        .dropend .dropdown-menu[data-bs-popper] {
            left: 100%;
            margin-left: var(--bs-dropdown-spacer);
            margin-top: 0;
            right: auto;
            top: 0
        }

        .dropend .dropdown-toggle:after {
            border-bottom: .75em solid transparent;
            border-left: .75em solid;
            border-right: 0;
            border-top: .75em solid transparent;
            margin-left: 1.3125em;
            vertical-align: .6375em
        }

        .dropend .dropdown-toggle:empty:after {
            margin-left: 0
        }

        .dropstart .dropdown-menu[data-bs-popper] {
            left: auto;
            margin-right: var(--bs-dropdown-spacer);
            margin-top: 0;
            right: 100%;
            top: 0
        }

        .dropstart .dropdown-toggle:after {
            display: none;
            margin-left: 1.3125em;
            vertical-align: .6375em
        }

        .dropstart .dropdown-toggle:before {
            border-bottom: .75em solid transparent;
            border-right: .75em solid;
            border-top: .75em solid transparent;
            content: "";
            display: inline-block;
            margin-right: 1.3125em;
            vertical-align: .6375em
        }

        .dropstart .dropdown-toggle:empty:after {
            margin-left: 0
        }

        .dropstart .dropdown-toggle:before {
            vertical-align: 0
        }

        .dropdown-divider {
            border-top: 1px solid var(--bs-dropdown-divider-bg);
            height: 0;
            margin: var(--bs-dropdown-divider-margin-y) 0;
            opacity: 1;
            overflow: hidden
        }

        .dropdown-item {
            background-color: transparent;
            border: 0;
            clear: both;
            color: var(--bs-dropdown-link-color);
            display: block;
            font-weight: 400;
            padding: var(--bs-dropdown-item-padding-y) var(--bs-dropdown-item-padding-x);
            text-align: inherit;
            white-space: nowrap;
            width: 100%
        }

        .dropdown-item:focus,
        .dropdown-item:hover {
            background-color: var(--bs-dropdown-link-hover-bg);
            color: var(--bs-dropdown-link-hover-color)
        }

        .dropdown-item.active,
        .dropdown-item:active {
            background-color: var(--bs-dropdown-link-active-bg);
            color: var(--bs-dropdown-link-active-color);
            text-decoration: none
        }

        .dropdown-item.disabled,
        .dropdown-item:disabled {
            background-color: transparent;
            color: var(--bs-dropdown-link-disabled-color);
            pointer-events: none
        }

        .dropdown-menu.show {
            display: block
        }

        .dropdown-header {
            color: var(--bs-dropdown-header-color);
            display: block;
            font-size: .6875rem;
            margin-bottom: 0;
            padding: var(--bs-dropdown-header-padding-y) var(--bs-dropdown-header-padding-x);
            white-space: nowrap
        }

        .dropdown-item-text {
            color: var(--bs-dropdown-link-color);
            display: block;
            padding: var(--bs-dropdown-item-padding-y) var(--bs-dropdown-item-padding-x)
        }

        .dropdown-menu-dark {
            --bs-dropdown-color: #f6f7f8;
            --bs-dropdown-bg: #323232;
            --bs-dropdown-border-color: var(--bs-border-color);
            --bs-dropdown-box-shadow: 0 1rem 3rem rgba(14, 34, 56, .1);
            --bs-dropdown-link-color: #f6f7f8;
            --bs-dropdown-link-hover-color: #fff;
            --bs-dropdown-divider-bg: hsla(220, 9%, 94%, .1);
            --bs-dropdown-link-hover-bg: #3e3e3e;
            --bs-dropdown-link-active-color: #fff;
            --bs-dropdown-link-active-bg: #3e3e3e;
            --bs-dropdown-link-disabled-color: #a5abb3;
            --bs-dropdown-header-color: #a5abb3
        }

        .btn-group,
        .btn-group-vertical {
            display: inline-flex;
            position: relative;
            vertical-align: middle
        }

        .btn-group-vertical>.btn,
        .btn-group>.btn {
            flex: 1 1 auto;
            position: relative
        }

        .btn-group-vertical>.btn-check:checked+.btn,
        .btn-group-vertical>.btn-check:focus+.btn,
        .btn-group-vertical>.btn.active,
        .btn-group-vertical>.btn:active,
        .btn-group-vertical>.btn:focus,
        .btn-group-vertical>.btn:hover,
        .btn-group>.btn-check:checked+.btn,
        .btn-group>.btn-check:focus+.btn,
        .btn-group>.btn.active,
        .btn-group>.btn:active,
        .btn-group>.btn:focus,
        .btn-group>.btn:hover {
            z-index: 1
        }

        .btn-toolbar {
            display: flex;
            flex-wrap: wrap;
            justify-content: flex-start
        }

        .btn-toolbar .input-group {
            width: auto
        }

        .btn-group {
            border-radius: 1.25rem
        }

        .btn-group>.btn-group:not(:first-child),
        .btn-group>:not(.btn-check:first-child)+.btn {
            margin-left: -1px
        }

        .btn-group>.btn-group:not(:last-child)>.btn,
        .btn-group>.btn.dropdown-toggle-split:first-child,
        .btn-group>.btn:not(:last-child):not(.dropdown-toggle) {
            border-bottom-right-radius: 0;
            border-top-right-radius: 0
        }

        .btn-group>.btn-group:not(:first-child)>.btn,
        .btn-group>.btn:nth-child(n+3),
        .btn-group>:not(.btn-check)+.btn {
            border-bottom-left-radius: 0;
            border-top-left-radius: 0
        }

        .dropdown-toggle-split {
            padding-left: 1.171875rem;
            padding-right: 1.171875rem
        }

        .dropdown-toggle-split:after,
        .dropend .dropdown-toggle-split:after,
        .dropup .dropdown-toggle-split:after {
            margin-left: 0
        }

        .dropstart .dropdown-toggle-split:before {
            margin-right: 0
        }

        .btn-group-sm>.btn+.dropdown-toggle-split,
        .btn-sm+.dropdown-toggle-split {
            padding-left: .9375rem;
            padding-right: .9375rem
        }

        .btn-group-lg>.btn+.dropdown-toggle-split,
        .btn-lg+.dropdown-toggle-split {
            padding-left: 1.40625rem;
            padding-right: 1.40625rem
        }

        .btn-group.show .dropdown-toggle {
            box-shadow: 0 0 transparent
        }

        .btn-group.show .dropdown-toggle.btn-link {
            box-shadow: none
        }

        .btn-group-vertical {
            align-items: flex-start;
            flex-direction: column;
            justify-content: center
        }

        .btn-group-vertical>.btn,
        .btn-group-vertical>.btn-group {
            width: 100%
        }

        .btn-group-vertical>.btn-group:not(:first-child),
        .btn-group-vertical>.btn:not(:first-child) {
            margin-top: -1px
        }

        .btn-group-vertical>.btn-group:not(:last-child)>.btn,
        .btn-group-vertical>.btn:not(:last-child):not(.dropdown-toggle) {
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0
        }

        .btn-group-vertical>.btn-group:not(:first-child)>.btn,
        .btn-group-vertical>.btn~.btn {
            border-top-left-radius: 0;
            border-top-right-radius: 0
        }

        .nav {
            --bs-nav-link-padding-x: 1rem;
            --bs-nav-link-padding-y: 0.90625rem;
            --bs-nav-link-font-weight: ;
            --bs-nav-link-color: var(--bs-link-color);
            --bs-nav-link-hover-color: var(--bs-link-hover-color);
            --bs-nav-link-disabled-color: #989ea6;
            display: flex;
            flex-wrap: wrap;
            list-style: none;
            margin-bottom: 0;
            padding-left: 0
        }

        .nav-link {
            color: var(--bs-nav-link-color);
            display: block;
            font-size: var(--bs-nav-link-font-size);
            font-weight: var(--bs-nav-link-font-weight);
            padding: var(--bs-nav-link-padding-y) var(--bs-nav-link-padding-x);
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out
        }

        @media(prefers-reduced-motion:reduce) {
            .nav-link {
                transition: none
            }
        }

        .nav-link:focus,
        .nav-link:hover {
            color: var(--bs-nav-link-hover-color)
        }

        .nav-link.disabled {
            color: var(--bs-nav-link-disabled-color);
            cursor: default;
            pointer-events: none
        }

        .nav-tabs {
            --bs-nav-tabs-border-width: 1px;
            --bs-nav-tabs-border-color: hsla(214, 7%, 62%, .2);
            --bs-nav-tabs-border-radius: 0;
            --bs-nav-tabs-link-hover-border-color: transparent;
            --bs-nav-tabs-link-active-color: var(--bs-primary);
            --bs-nav-tabs-link-active-bg: transparent;
            --bs-nav-tabs-link-active-border-color: transparent transparent {{ $settings->website_theme }};
            border-bottom: var(--bs-nav-tabs-border-width) solid var(--bs-nav-tabs-border-color)
        }

        .nav-tabs .nav-link {
            background: none;
            border: var(--bs-nav-tabs-border-width) solid transparent;
            border-top-left-radius: var(--bs-nav-tabs-border-radius);
            border-top-right-radius: var(--bs-nav-tabs-border-radius);
            margin-bottom: calc(var(--bs-nav-tabs-border-width)*-1)
        }

        .nav-tabs .nav-link:focus,
        .nav-tabs .nav-link:hover {
            border-color: var(--bs-nav-tabs-link-hover-border-color);
            isolation: isolate
        }

        .nav-tabs .nav-link.disabled,
        .nav-tabs .nav-link:disabled {
            background-color: transparent;
            border-color: transparent;
            color: var(--bs-nav-link-disabled-color)
        }

        .nav-tabs .nav-item.show .nav-link,
        .nav-tabs .nav-link.active {
            background-color: var(--bs-nav-tabs-link-active-bg);
            border-color: var(--bs-nav-tabs-link-active-border-color);
            color: var(--bs-nav-tabs-link-active-color)
        }

        .nav-tabs .dropdown-menu {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            margin-top: calc(var(--bs-nav-tabs-border-width)*-1)
        }

        .nav-pills {
            --bs-nav-pills-border-radius: 0.625rem;
            --bs-nav-pills-link-active-color: #fff;
            --bs-nav-pills-link-active-bg: {{ $settings->website_theme }}
        }

        .nav-pills .nav-link {
            background: none;
            border: 0;
            border-radius: var(--bs-nav-pills-border-radius)
        }

        .nav-pills .nav-link:disabled {
            background-color: transparent;
            border-color: transparent;
            color: var(--bs-nav-link-disabled-color)
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            background-color: var(--bs-nav-pills-link-active-bg);
            color: var(--bs-nav-pills-link-active-color)
        }

        .nav-fill .nav-item,
        .nav-fill>.nav-link {
            flex: 1 1 auto;
            text-align: center
        }

        .nav-justified .nav-item,
        .nav-justified>.nav-link {
            flex-basis: 0;
            flex-grow: 1;
            text-align: center
        }

        .nav-fill .nav-item .nav-link,
        .nav-justified .nav-item .nav-link {
            width: 100%
        }

        .tab-content>.tab-pane {
            display: none
        }

        .tab-content>.active {
            display: block
        }

        .navbar {
            --bs-navbar-padding-x: 1.875rem;
            --bs-navbar-padding-y: 1.875rem;
            --bs-navbar-color: #9ea9b4;
            --bs-navbar-hover-color: {{ $settings->website_theme }};
            --bs-navbar-disabled-color: rgba(0, 0, 0, .3);
            --bs-navbar-active-color: {{ $settings->website_theme }};
            --bs-navbar-brand-padding-y: 0.375rem;
            --bs-navbar-brand-margin-end: 0;
            --bs-navbar-brand-font-size: 1rem;
            --bs-navbar-brand-color: {{ $settings->website_theme }};
            --bs-navbar-brand-hover-color: {{ $settings->website_theme }};
            --bs-navbar-nav-link-padding-x: 1.875rem;
            --bs-navbar-toggler-padding-y: 0;
            --bs-navbar-toggler-padding-x: 0;
            --bs-navbar-toggler-font-size: 1rem;
            --bs-navbar-toggler-icon-bg: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'%3E%3Crect width='23' height='3' x='.5' y='2.5' fill='%239EA9B4' rx='1' ry='1'/%3E%3Crect width='23' height='3' x='.5' y='10.5' fill='%239EA9B4' rx='1' ry='1'/%3E%3Crect width='23' height='3' x='.5' y='18.5' fill='%239EA9B4' rx='1' ry='1'/%3E%3C/svg%3E");
            --bs-navbar-toggler-border-color: transparent;
            --bs-navbar-toggler-border-radius: 0;
            --bs-navbar-toggler-focus-width: 0;
            --bs-navbar-toggler-transition: none;
            align-items: center;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            padding: var(--bs-navbar-padding-y) var(--bs-navbar-padding-x);
            position: relative
        }

        .navbar>.container,
        .navbar>.container-fluid,
        .navbar>.container-lg,
        .navbar>.container-md,
        .navbar>.container-sm,
        .navbar>.container-xl,
        .navbar>.container-xxl {
            align-items: center;
            display: flex;
            flex-wrap: inherit;
            justify-content: space-between
        }

        .navbar-brand {
            color: var(--bs-navbar-brand-color);
            font-size: var(--bs-navbar-brand-font-size);
            margin-right: var(--bs-navbar-brand-margin-end);
            padding-bottom: var(--bs-navbar-brand-padding-y);
            padding-top: var(--bs-navbar-brand-padding-y);
            white-space: nowrap
        }

        .navbar-brand:focus,
        .navbar-brand:hover {
            color: var(--bs-navbar-brand-hover-color)
        }

        .navbar-nav {
            --bs-nav-link-padding-x: 0;
            --bs-nav-link-padding-y: 0.90625rem;
            --bs-nav-link-font-weight: ;
            --bs-nav-link-color: var(--bs-navbar-color);
            --bs-nav-link-hover-color: var(--bs-navbar-hover-color);
            --bs-nav-link-disabled-color: var(--bs-navbar-disabled-color);
            display: flex;
            flex-direction: column;
            list-style: none;
            margin-bottom: 0;
            padding-left: 0
        }

        .navbar-nav .nav-link.active,
        .navbar-nav .show>.nav-link {
            color: var(--bs-navbar-active-color)
        }

        .navbar-nav .dropdown-menu {
            position: static
        }

        .navbar-text {
            color: var(--bs-navbar-color);
            padding-bottom: .90625rem;
            padding-top: .90625rem
        }

        .navbar-text a,
        .navbar-text a:focus,
        .navbar-text a:hover {
            color: var(--bs-navbar-active-color)
        }

        .navbar-collapse {
            align-items: center;
            flex-basis: 100%;
            flex-grow: 1
        }

        .navbar-toggler {
            background-color: transparent;
            border: var(--bs-border-width) solid var(--bs-navbar-toggler-border-color);
            border-radius: var(--bs-navbar-toggler-border-radius);
            color: var(--bs-navbar-color);
            font-size: var(--bs-navbar-toggler-font-size);
            line-height: 1;
            padding: var(--bs-navbar-toggler-padding-y) var(--bs-navbar-toggler-padding-x);
            transition: var(--bs-navbar-toggler-transition)
        }

        @media(prefers-reduced-motion:reduce) {
            .navbar-toggler {
                transition: none
            }
        }

        .navbar-toggler:hover {
            text-decoration: none
        }

        .navbar-toggler:focus {
            box-shadow: 0 0 0 var(--bs-navbar-toggler-focus-width);
            outline: 0;
            text-decoration: none
        }

        .navbar-toggler-icon {
            background-image: var(--bs-navbar-toggler-icon-bg);
            background-position: 50%;
            background-repeat: no-repeat;
            background-size: 100%;
            display: inline-block;
            height: 1.5em;
            vertical-align: middle;
            width: 1.5em
        }

        .navbar-nav-scroll {
            max-height: var(--bs-scroll-height, 75vh);
            overflow-y: auto
        }

        @media(min-width:576px) {
            .navbar-expand-sm {
                flex-wrap: nowrap;
                justify-content: flex-start
            }

            .navbar-expand-sm .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-sm .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-sm .navbar-nav .nav-link {
                padding-left: var(--bs-navbar-nav-link-padding-x);
                padding-right: var(--bs-navbar-nav-link-padding-x)
            }

            .navbar-expand-sm .navbar-nav-scroll {
                overflow: visible
            }

            .navbar-expand-sm .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-sm .navbar-toggler {
                display: none
            }

            .navbar-expand-sm .offcanvas {
                background-color: transparent !important;
                border: 0 !important;
                box-shadow: none;
                flex-grow: 1;
                height: auto !important;
                position: static;
                transform: none !important;
                transition: none;
                visibility: visible !important;
                width: auto !important;
                z-index: auto
            }

            .navbar-expand-sm .offcanvas .offcanvas-header {
                display: none
            }

            .navbar-expand-sm .offcanvas .offcanvas-body {
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(min-width:768px) {
            .navbar-expand-md {
                flex-wrap: nowrap;
                justify-content: flex-start
            }

            .navbar-expand-md .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-md .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-md .navbar-nav .nav-link {
                padding-left: var(--bs-navbar-nav-link-padding-x);
                padding-right: var(--bs-navbar-nav-link-padding-x)
            }

            .navbar-expand-md .navbar-nav-scroll {
                overflow: visible
            }

            .navbar-expand-md .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-md .navbar-toggler {
                display: none
            }

            .navbar-expand-md .offcanvas {
                background-color: transparent !important;
                border: 0 !important;
                box-shadow: none;
                flex-grow: 1;
                height: auto !important;
                position: static;
                transform: none !important;
                transition: none;
                visibility: visible !important;
                width: auto !important;
                z-index: auto
            }

            .navbar-expand-md .offcanvas .offcanvas-header {
                display: none
            }

            .navbar-expand-md .offcanvas .offcanvas-body {
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(min-width:992px) {
            .navbar-expand-lg {
                flex-wrap: nowrap;
                justify-content: flex-start
            }

            .navbar-expand-lg .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-lg .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-lg .navbar-nav .nav-link {
                padding-left: var(--bs-navbar-nav-link-padding-x);
                padding-right: var(--bs-navbar-nav-link-padding-x)
            }

            .navbar-expand-lg .navbar-nav-scroll {
                overflow: visible
            }

            .navbar-expand-lg .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-lg .navbar-toggler {
                display: none
            }

            .navbar-expand-lg .offcanvas {
                background-color: transparent !important;
                border: 0 !important;
                box-shadow: none;
                flex-grow: 1;
                height: auto !important;
                position: static;
                transform: none !important;
                transition: none;
                visibility: visible !important;
                width: auto !important;
                z-index: auto
            }

            .navbar-expand-lg .offcanvas .offcanvas-header {
                display: none
            }

            .navbar-expand-lg .offcanvas .offcanvas-body {
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(min-width:1200px) {
            .navbar-expand-xl {
                flex-wrap: nowrap;
                justify-content: flex-start
            }

            .navbar-expand-xl .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-xl .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-xl .navbar-nav .nav-link {
                padding-left: var(--bs-navbar-nav-link-padding-x);
                padding-right: var(--bs-navbar-nav-link-padding-x)
            }

            .navbar-expand-xl .navbar-nav-scroll {
                overflow: visible
            }

            .navbar-expand-xl .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-xl .navbar-toggler {
                display: none
            }

            .navbar-expand-xl .offcanvas {
                background-color: transparent !important;
                border: 0 !important;
                box-shadow: none;
                flex-grow: 1;
                height: auto !important;
                position: static;
                transform: none !important;
                transition: none;
                visibility: visible !important;
                width: auto !important;
                z-index: auto
            }

            .navbar-expand-xl .offcanvas .offcanvas-header {
                display: none
            }

            .navbar-expand-xl .offcanvas .offcanvas-body {
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(min-width:1400px) {
            .navbar-expand-xxl {
                flex-wrap: nowrap;
                justify-content: flex-start
            }

            .navbar-expand-xxl .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-xxl .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-xxl .navbar-nav .nav-link {
                padding-left: var(--bs-navbar-nav-link-padding-x);
                padding-right: var(--bs-navbar-nav-link-padding-x)
            }

            .navbar-expand-xxl .navbar-nav-scroll {
                overflow: visible
            }

            .navbar-expand-xxl .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-xxl .navbar-toggler {
                display: none
            }

            .navbar-expand-xxl .offcanvas {
                background-color: transparent !important;
                border: 0 !important;
                box-shadow: none;
                flex-grow: 1;
                height: auto !important;
                position: static;
                transform: none !important;
                transition: none;
                visibility: visible !important;
                width: auto !important;
                z-index: auto
            }

            .navbar-expand-xxl .offcanvas .offcanvas-header {
                display: none
            }

            .navbar-expand-xxl .offcanvas .offcanvas-body {
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        .navbar-expand {
            flex-wrap: nowrap;
            justify-content: flex-start
        }

        .navbar-expand .navbar-nav {
            flex-direction: row
        }

        .navbar-expand .navbar-nav .dropdown-menu {
            position: absolute
        }

        .navbar-expand .navbar-nav .nav-link {
            padding-left: var(--bs-navbar-nav-link-padding-x);
            padding-right: var(--bs-navbar-nav-link-padding-x)
        }

        .navbar-expand .navbar-nav-scroll {
            overflow: visible
        }

        .navbar-expand .navbar-collapse {
            display: flex !important;
            flex-basis: auto
        }

        .navbar-expand .navbar-toggler {
            display: none
        }

        .navbar-expand .offcanvas {
            background-color: transparent !important;
            border: 0 !important;
            box-shadow: none;
            flex-grow: 1;
            height: auto !important;
            position: static;
            transform: none !important;
            transition: none;
            visibility: visible !important;
            width: auto !important;
            z-index: auto
        }

        .navbar-expand .offcanvas .offcanvas-header {
            display: none
        }

        .navbar-expand .offcanvas .offcanvas-body {
            display: flex;
            flex-grow: 0;
            overflow-y: visible;
            padding: 0
        }

        .navbar-dark {
            --bs-navbar-color: #9ea9b4;
            --bs-navbar-hover-color: {{ $settings->website_theme }};
            --bs-navbar-disabled-color: hsla(0, 0%, 100%, .25);
            --bs-navbar-active-color: {{ $settings->website_theme }};
            --bs-navbar-brand-color: {{ $settings->website_theme }};
            --bs-navbar-brand-hover-color: {{ $settings->website_theme }};
            --bs-navbar-toggler-border-color: transparent;
            --bs-navbar-toggler-icon-bg: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'%3E%3Crect width='23' height='3' x='.5' y='2.5' fill='%239EA9B4' rx='1' ry='1'/%3E%3Crect width='23' height='3' x='.5' y='10.5' fill='%239EA9B4' rx='1' ry='1'/%3E%3Crect width='23' height='3' x='.5' y='18.5' fill='%239EA9B4' rx='1' ry='1'/%3E%3C/svg%3E")
        }

        .card {
            --bs-card-spacer-y: 1.2500000001rem;
            --bs-card-spacer-x: 1.2500000001rem;
            --bs-card-title-spacer-y: 0.9375rem;
            --bs-card-border-width: 1px;
            --bs-card-border-color: var(--bs-border-color-translucent);
            --bs-card-border-radius: 0.625rem;
            --bs-card-box-shadow: 0 0.1875rem 0.1875rem 0 rgba(14, 34, 56, .07);
            --bs-card-inner-border-radius: calc(0.625rem - 1px);
            --bs-card-cap-padding-y: 1.2500000001rem;
            --bs-card-cap-padding-x: 1.2500000001rem;
            --bs-card-cap-bg: transparent;
            --bs-card-cap-color: ;
            --bs-card-height: ;
            --bs-card-color: ;
            --bs-card-bg: #fff;
            --bs-card-img-overlay-padding: 1.875rem;
            --bs-card-group-margin: 0.9375rem;
            word-wrap: break-word;
            background-clip: border-box;
            background-color: var(--bs-card-bg);
            border: var(--bs-card-border-width) solid var(--bs-card-border-color);
            border-radius: var(--bs-card-border-radius);
            display: flex;
            flex-direction: column;
            height: var(--bs-card-height);
            min-width: 0;
            position: relative
        }

        .card>hr {
            margin-left: 0;
            margin-right: 0
        }

        .card>.list-group {
            border-bottom: inherit;
            border-top: inherit
        }

        .card>.list-group:first-child {
            border-top-left-radius: var(--bs-card-inner-border-radius);
            border-top-right-radius: var(--bs-card-inner-border-radius);
            border-top-width: 0
        }

        .card>.list-group:last-child {
            border-bottom-left-radius: var(--bs-card-inner-border-radius);
            border-bottom-right-radius: var(--bs-card-inner-border-radius);
            border-bottom-width: 0
        }

        .card>.card-header+.list-group,
        .card>.list-group+.card-footer {
            border-top: 0
        }

        .card-body {
            color: var(--bs-card-color);
            flex: 1 1 auto;
            padding: var(--bs-card-spacer-y) var(--bs-card-spacer-x)
        }

        .card-title {
            margin-bottom: var(--bs-card-title-spacer-y)
        }

        .card-subtitle {
            margin-top: calc(var(--bs-card-title-spacer-y)*-.5)
        }

        .card-subtitle,
        .card-text:last-child {
            margin-bottom: 0
        }

        .card-link+.card-link {
            margin-left: var(--bs-card-spacer-x)
        }

        .card-header {
            background-color: var(--bs-card-cap-bg);
            border-bottom: var(--bs-card-border-width) solid var(--bs-card-border-color);
            color: var(--bs-card-cap-color);
            margin-bottom: 0;
            padding: var(--bs-card-cap-padding-y) var(--bs-card-cap-padding-x)
        }

        .card-header:first-child {
            border-radius: var(--bs-card-inner-border-radius) var(--bs-card-inner-border-radius) 0 0
        }

        .card-footer {
            background-color: var(--bs-card-cap-bg);
            border-top: var(--bs-card-border-width) solid var(--bs-card-border-color);
            color: var(--bs-card-cap-color);
            padding: var(--bs-card-cap-padding-y) var(--bs-card-cap-padding-x)
        }

        .card-footer:last-child {
            border-radius: 0 0 var(--bs-card-inner-border-radius) var(--bs-card-inner-border-radius)
        }

        .card-header-tabs {
            border-bottom: 0;
            margin-bottom: calc(var(--bs-card-cap-padding-y)*-1);
            margin-left: calc(var(--bs-card-cap-padding-x)*-.5);
            margin-right: calc(var(--bs-card-cap-padding-x)*-.5)
        }

        .card-header-tabs .nav-link.active {
            background-color: var(--bs-card-bg);
            border-bottom-color: var(--bs-card-bg)
        }

        .card-header-pills {
            margin-left: calc(var(--bs-card-cap-padding-x)*-.5);
            margin-right: calc(var(--bs-card-cap-padding-x)*-.5)
        }

        .card-img-overlay {
            border-radius: var(--bs-card-inner-border-radius);
            bottom: 0;
            left: 0;
            padding: var(--bs-card-img-overlay-padding);
            position: absolute;
            right: 0;
            top: 0
        }

        .card-img,
        .card-img-bottom,
        .card-img-top {
            width: 100%
        }

        .card-img,
        .card-img-top {
            border-top-left-radius: var(--bs-card-inner-border-radius);
            border-top-right-radius: var(--bs-card-inner-border-radius)
        }

        .card-img,
        .card-img-bottom {
            border-bottom-left-radius: var(--bs-card-inner-border-radius);
            border-bottom-right-radius: var(--bs-card-inner-border-radius)
        }

        .card-group>.card {
            margin-bottom: var(--bs-card-group-margin)
        }

        @media(min-width:576px) {
            .card-group {
                display: flex;
                flex-flow: row wrap
            }

            .card-group>.card {
                flex: 1 0 0%;
                margin-bottom: 0
            }

            .card-group>.card+.card {
                border-left: 0;
                margin-left: 0
            }

            .card-group>.card:not(:last-child) {
                border-bottom-right-radius: 0;
                border-top-right-radius: 0
            }

            .card-group>.card:not(:last-child) .card-header,
            .card-group>.card:not(:last-child) .card-img-top {
                border-top-right-radius: 0
            }

            .card-group>.card:not(:last-child) .card-footer,
            .card-group>.card:not(:last-child) .card-img-bottom {
                border-bottom-right-radius: 0
            }

            .card-group>.card:not(:first-child) {
                border-bottom-left-radius: 0;
                border-top-left-radius: 0
            }

            .card-group>.card:not(:first-child) .card-header,
            .card-group>.card:not(:first-child) .card-img-top {
                border-top-left-radius: 0
            }

            .card-group>.card:not(:first-child) .card-footer,
            .card-group>.card:not(:first-child) .card-img-bottom {
                border-bottom-left-radius: 0
            }
        }

        .accordion {
            --bs-accordion-color: #0e2238;
            --bs-accordion-bg: #f8fafb;
            --bs-accordion-transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, border-radius 0.15s ease;
            --bs-accordion-border-color: var(--bs-border-color);
            --bs-accordion-border-width: 1px;
            --bs-accordion-border-radius: 0.625rem;
            --bs-accordion-inner-border-radius: calc(0.625rem - 1px);
            --bs-accordion-btn-padding-x: 1.25rem;
            --bs-accordion-btn-padding-y: 1rem;
            --bs-accordion-btn-color: #0e2238;
            --bs-accordion-btn-bg: var(--bs-accordion-bg);
            --bs-accordion-btn-icon: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%230E2238' viewBox='0 0 16 16'%3E%3Cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3E%3C/svg%3E");
            --bs-accordion-btn-icon-width: 1.25rem;
            --bs-accordion-btn-icon-transform: rotate(-180deg);
            --bs-accordion-btn-icon-transition: transform 0.2s ease-in-out;
            --bs-accordion-btn-active-icon: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%2300a7b3' viewBox='0 0 16 16'%3E%3Cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3E%3C/svg%3E");
            --bs-accordion-btn-focus-border-color: {{ $settings->website_theme }};
            --bs-accordion-btn-focus-box-shadow: 0 4px 12px rgba(var(--bs-btn-focus-shadow-rgb), 0.35);
            --bs-accordion-body-padding-x: 1.25rem;
            --bs-accordion-body-padding-y: 1rem;
            --bs-accordion-active-color: #00a7b3;
            --bs-accordion-active-bg: #e6f8f9
        }

        .accordion-button {
            align-items: center;
            background-color: var(--bs-accordion-btn-bg);
            border: 0;
            border-radius: 0;
            color: var(--bs-accordion-btn-color);
            display: flex;
            font-size: .875rem;
            overflow-anchor: none;
            padding: var(--bs-accordion-btn-padding-y) var(--bs-accordion-btn-padding-x);
            position: relative;
            text-align: left;
            transition: var(--bs-accordion-transition);
            width: 100%
        }

        @media(prefers-reduced-motion:reduce) {
            .accordion-button {
                transition: none
            }
        }

        .accordion-button:not(.collapsed) {
            background-color: var(--bs-accordion-active-bg);
            box-shadow: inset 0 calc(var(--bs-accordion-border-width)*-1) 0 var(--bs-accordion-border-color);
            color: var(--bs-accordion-active-color)
        }

        .accordion-button:not(.collapsed):after {
            background-image: var(--bs-accordion-btn-active-icon);
            transform: var(--bs-accordion-btn-icon-transform)
        }

        .accordion-button:after {
            background-image: var(--bs-accordion-btn-icon);
            background-repeat: no-repeat;
            background-size: var(--bs-accordion-btn-icon-width);
            content: "";
            flex-shrink: 0;
            height: var(--bs-accordion-btn-icon-width);
            margin-left: auto;
            transition: var(--bs-accordion-btn-icon-transition);
            width: var(--bs-accordion-btn-icon-width)
        }

        @media(prefers-reduced-motion:reduce) {
            .accordion-button:after {
                transition: none
            }
        }

        .accordion-button:hover {
            z-index: 2
        }

        .accordion-button:focus {
            border-color: var(--bs-accordion-btn-focus-border-color);
            box-shadow: var(--bs-accordion-btn-focus-box-shadow);
            outline: 0;
            z-index: 3
        }

        .accordion-header {
            margin-bottom: 0
        }

        .accordion-item {
            background-color: var(--bs-accordion-bg);
            border: var(--bs-accordion-border-width) solid var(--bs-accordion-border-color);
            color: var(--bs-accordion-color)
        }

        .accordion-item:first-of-type {
            border-top-left-radius: var(--bs-accordion-border-radius);
            border-top-right-radius: var(--bs-accordion-border-radius)
        }

        .accordion-item:first-of-type .accordion-button {
            border-top-left-radius: var(--bs-accordion-inner-border-radius);
            border-top-right-radius: var(--bs-accordion-inner-border-radius)
        }

        .accordion-item:not(:first-of-type) {
            border-top: 0
        }

        .accordion-item:last-of-type {
            border-bottom-left-radius: var(--bs-accordion-border-radius);
            border-bottom-right-radius: var(--bs-accordion-border-radius)
        }

        .accordion-item:last-of-type .accordion-button.collapsed {
            border-bottom-left-radius: var(--bs-accordion-inner-border-radius);
            border-bottom-right-radius: var(--bs-accordion-inner-border-radius)
        }

        .accordion-item:last-of-type .accordion-collapse {
            border-bottom-left-radius: var(--bs-accordion-border-radius);
            border-bottom-right-radius: var(--bs-accordion-border-radius)
        }

        .accordion-body {
            padding: var(--bs-accordion-body-padding-y) var(--bs-accordion-body-padding-x)
        }

        .accordion-flush .accordion-collapse {
            border-width: 0
        }

        .accordion-flush .accordion-item {
            border-left: 0;
            border-radius: 0;
            border-right: 0
        }

        .accordion-flush .accordion-item:first-child {
            border-top: 0
        }

        .accordion-flush .accordion-item:last-child {
            border-bottom: 0
        }

        .accordion-flush .accordion-item .accordion-button,
        .accordion-flush .accordion-item .accordion-button.collapsed {
            border-radius: 0
        }

        .breadcrumb {
            --bs-breadcrumb-padding-x: 0;
            --bs-breadcrumb-padding-y: 0;
            --bs-breadcrumb-margin-bottom: 0;
            --bs-breadcrumb-font-size: 0.75rem;
            --bs-breadcrumb-bg: transparent;
            --bs-breadcrumb-border-radius: 0;
            --bs-breadcrumb-divider-color: #9ea9b4;
            --bs-breadcrumb-item-padding-x: 0.5rem;
            --bs-breadcrumb-item-active-color: var(--bs-body-color);
            background-color: var(--bs-breadcrumb-bg);
            border-radius: var(--bs-breadcrumb-border-radius);
            display: flex;
            flex-wrap: wrap;
            font-size: var(--bs-breadcrumb-font-size);
            list-style: none;
            margin-bottom: var(--bs-breadcrumb-margin-bottom);
            padding: var(--bs-breadcrumb-padding-y) var(--bs-breadcrumb-padding-x)
        }

        .breadcrumb-item+.breadcrumb-item {
            padding-left: var(--bs-breadcrumb-item-padding-x)
        }

        .breadcrumb-item+.breadcrumb-item:before {
            color: var(--bs-breadcrumb-divider-color);
            content: var(--bs-breadcrumb-divider, url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='10' height='10' viewBox='0 0 24 24'%3E%3Cpath fill='none' stroke='%239EA9B4' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m5.5.75 10.72 10.72a.749.749 0 0 1 0 1.06L5.5 23.25'/%3E%3C/svg%3E"));
            float: left;
            padding-right: var(--bs-breadcrumb-item-padding-x)
        }

        .breadcrumb-item.active {
            color: var(--bs-breadcrumb-item-active-color)
        }

        .pagination {
            --bs-pagination-padding-x: 0.75rem;
            --bs-pagination-padding-y: 0.375rem;
            --bs-pagination-font-size: 0.875rem;
            --bs-pagination-color: var(--bs-link-color);
            --bs-pagination-bg: var(--bs-body-bg);
            --bs-pagination-border-width: 1px;
            --bs-pagination-border-color: var(--bs-border-color-translucent);
            --bs-pagination-border-radius: 0.625rem;
            --bs-pagination-hover-color: var(--bs-link-hover-color);
            --bs-pagination-hover-bg: var(--bs-gray-100);
            --bs-pagination-hover-border-color: var(--bs-border-color-translucent);
            --bs-pagination-focus-color: var(--bs-link-hover-color);
            --bs-pagination-focus-bg: #f4f4f4;
            --bs-pagination-focus-box-shadow: 0 0 0.75rem 0.25rem rgba(0, 186, 199, .25);
            --bs-pagination-active-color: #fff;
            --bs-pagination-active-bg: {{ $settings->website_theme }};
            --bs-pagination-active-border-color: {{ $settings->website_theme }};
            --bs-pagination-disabled-color: #989ea6;
            --bs-pagination-disabled-bg: #fff;
            --bs-pagination-disabled-border-color: #edeef0;
            display: flex;
            list-style: none;
            padding-left: 0
        }

        .page-link {
            background-color: var(--bs-pagination-bg);
            border: var(--bs-pagination-border-width) solid var(--bs-pagination-border-color);
            color: var(--bs-pagination-color);
            display: block;
            font-size: var(--bs-pagination-font-size);
            padding: var(--bs-pagination-padding-y) var(--bs-pagination-padding-x);
            position: relative;
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out
        }

        @media(prefers-reduced-motion:reduce) {
            .page-link {
                transition: none
            }
        }

        .page-link:hover {
            background-color: var(--bs-pagination-hover-bg);
            border-color: var(--bs-pagination-hover-border-color);
            color: var(--bs-pagination-hover-color);
            z-index: 2
        }

        .page-link:focus {
            background-color: var(--bs-pagination-focus-bg);
            box-shadow: var(--bs-pagination-focus-box-shadow);
            color: var(--bs-pagination-focus-color);
            outline: 0;
            z-index: 3
        }

        .active>.page-link,
        .page-link.active {
            background-color: var(--bs-pagination-active-bg);
            border-color: var(--bs-pagination-active-border-color);
            color: var(--bs-pagination-active-color);
            z-index: 3
        }

        .disabled>.page-link,
        .page-link.disabled {
            background-color: var(--bs-pagination-disabled-bg);
            border-color: var(--bs-pagination-disabled-border-color);
            color: var(--bs-pagination-disabled-color);
            pointer-events: none
        }

        .page-item:not(:first-child) .page-link {
            margin-left: -1px
        }

        .page-item:first-child .page-link {
            border-bottom-left-radius: var(--bs-pagination-border-radius);
            border-top-left-radius: var(--bs-pagination-border-radius)
        }

        .page-item:last-child .page-link {
            border-bottom-right-radius: var(--bs-pagination-border-radius);
            border-top-right-radius: var(--bs-pagination-border-radius)
        }

        .pagination-lg {
            --bs-pagination-padding-x: 1.5rem;
            --bs-pagination-padding-y: 0.75rem;
            --bs-pagination-font-size: 1rem;
            --bs-pagination-border-radius: 0.75rem
        }

        .pagination-sm {
            --bs-pagination-padding-x: 0.5rem;
            --bs-pagination-padding-y: 0.25rem;
            --bs-pagination-font-size: 0.6875rem;
            --bs-pagination-border-radius: 0.25rem
        }

        .badge {
            --bs-badge-padding-x: 0.75em;
            --bs-badge-padding-y: 0.25em;
            --bs-badge-font-size: 72%;
            --bs-badge-font-weight: 600;
            --bs-badge-color: #fff;
            --bs-badge-border-radius: 0.25rem;
            border-radius: var(--bs-badge-border-radius);
            color: var(--bs-badge-color);
            display: inline-block;
            font-size: var(--bs-badge-font-size);
            font-weight: var(--bs-badge-font-weight);
            line-height: 1;
            padding: var(--bs-badge-padding-y) var(--bs-badge-padding-x);
            text-align: center;
            vertical-align: baseline;
            white-space: nowrap
        }

        .badge:empty {
            display: none
        }

        .btn .badge {
            position: relative;
            top: -1px
        }

        .alert {
            --bs-alert-bg: transparent;
            --bs-alert-padding-x: 1.875rem;
            --bs-alert-padding-y: 1.25rem;
            --bs-alert-margin-bottom: 1rem;
            --bs-alert-color: inherit;
            --bs-alert-border-color: transparent;
            --bs-alert-border: 1px solid var(--bs-alert-border-color);
            --bs-alert-border-radius: 0.25rem;
            background-color: var(--bs-alert-bg);
            border: var(--bs-alert-border);
            border-radius: var(--bs-alert-border-radius);
            color: var(--bs-alert-color);
            margin-bottom: var(--bs-alert-margin-bottom);
            padding: var(--bs-alert-padding-y) var(--bs-alert-padding-x);
            position: relative
        }

        .alert-heading {
            color: inherit
        }

        .alert-link {
            font-weight: 700
        }

        .alert-dismissible {
            padding-right: 5.625rem
        }

        .alert-dismissible .btn-close {
            padding: 1.5625rem 1.875rem;
            position: absolute;
            right: 0;
            top: 0;
            z-index: 2
        }

        .alert-primary {
            --bs-alert-color: #f0fbfc;
            --bs-alert-bg: {{ $settings->website_theme }};
            --bs-alert-border-color: {{ $settings->website_theme }}
        }

        .alert-primary .alert-link {
            color: #c0c9ca
        }

        .alert-secondary {
            --bs-alert-color: #f9fafb;
            --bs-alert-bg: #9ea9b4;
            --bs-alert-border-color: #9ea9b4
        }

        .alert-secondary .alert-link {
            color: #c7c8c9
        }

        .alert-success {
            --bs-alert-color: #f3fcf7;
            --bs-alert-bg: #31cf80;
            --bs-alert-border-color: #31cf80
        }

        .alert-success .alert-link {
            color: #c2cac6
        }

        .alert-info {
            --bs-alert-color: #f2fafc;
            --bs-alert-bg: #2dadcf;
            --bs-alert-border-color: #2dadcf
        }

        .alert-info .alert-link {
            color: #c2c8ca
        }

        .alert-warning {
            --bs-alert-color: #fefcf4;
            --bs-alert-bg: #ebcf4f;
            --bs-alert-border-color: #ebcf4f
        }

        .alert-warning .alert-link {
            color: #cbcac3
        }

        .alert-danger {
            --bs-alert-color: #fdf2f5;
            --bs-alert-bg: #d82c5b;
            --bs-alert-border-color: #d82c5b
        }

        .alert-danger .alert-link {
            color: #cac2c4
        }

        .alert-light {
            --bs-alert-color: #0f0f0f;
            --bs-alert-bg: #f6f7f8;
            --bs-alert-border-color: #f6f7f8
        }

        .alert-light .alert-link {
            color: #0c0c0c
        }

        .alert-dark {
            --bs-alert-color: #f1f2f3;
            --bs-alert-bg: #0e2238;
            --bs-alert-border-color: #0e2238
        }

        .alert-dark .alert-link {
            color: #c1c2c2
        }

        .alert-light-green {
            --bs-alert-color: #0e0f0f;
            --bs-alert-bg: #f1f5f7;
            --bs-alert-border-color: #f1f5f7
        }

        .alert-light-green .alert-link {
            color: #0b0c0c
        }

        .alert-white {
            --bs-alert-color: #0f0f0f;
            --bs-alert-bg: #fff;
            --bs-alert-border-color: #fff
        }

        .alert-white .alert-link {
            color: #0c0c0c
        }

        .alert-black {
            --bs-alert-color: #f0f0f0;
            --bs-alert-bg: #000;
            --bs-alert-border-color: #000
        }

        .alert-black .alert-link {
            color: silver
        }

        .alert-blue {
            --bs-alert-color: #f0f7fc;
            --bs-alert-bg: #0075c7;
            --bs-alert-border-color: #0075c7
        }

        .alert-blue .alert-link {
            color: #c0c6ca
        }

        .alert-gray-100 {
            --bs-alert-color: #0f0f0f;
            --bs-alert-bg: #f6f7f8;
            --bs-alert-border-color: #f6f7f8
        }

        .alert-gray-100 .alert-link {
            color: #0c0c0c
        }

        .alert-gray-200 {
            --bs-alert-color: #0f0f0f;
            --bs-alert-bg: #f4f4f4;
            --bs-alert-border-color: #f4f4f4
        }

        .alert-gray-200 .alert-link {
            color: #0c0c0c
        }

        .alert-gray-300 {
            --bs-alert-color: #0e0e0e;
            --bs-alert-bg: #edeef0;
            --bs-alert-border-color: #edeef0
        }

        .alert-gray-300 .alert-link {
            color: #0b0b0b
        }

        .alert-gray-400 {
            --bs-alert-color: #0d0d0e;
            --bs-alert-bg: #d6dae2;
            --bs-alert-border-color: #d6dae2
        }

        .alert-gray-400 .alert-link {
            color: #0a0a0b
        }

        .alert-gray-500 {
            --bs-alert-color: #fafafa;
            --bs-alert-bg: #a5abb3;
            --bs-alert-border-color: #a5abb3
        }

        .alert-gray-500 .alert-link {
            color: #c8c8c8
        }

        .alert-gray-600 {
            --bs-alert-color: #f9f9fa;
            --bs-alert-bg: #989ea6;
            --bs-alert-border-color: #989ea6
        }

        .alert-gray-600 .alert-link {
            color: #c7c7c8
        }

        .alert-gray-700 {
            --bs-alert-color: #f6f6f6;
            --bs-alert-bg: #707070;
            --bs-alert-border-color: #707070
        }

        .alert-gray-700 .alert-link {
            color: #c5c5c5
        }

        .alert-gray-800 {
            --bs-alert-color: #f3f3f4;
            --bs-alert-bg: #343a40;
            --bs-alert-border-color: #343a40
        }

        .alert-gray-800 .alert-link {
            color: #c2c2c3
        }

        .alert-gray-900 {
            --bs-alert-color: #f2f2f2;
            --bs-alert-bg: #212529;
            --bs-alert-border-color: #212529
        }

        .alert-gray-900 .alert-link {
            color: #c2c2c2
        }

        @keyframes progress-bar-stripes {
            0% {
                background-position-x: .75rem
            }
        }

        .progress {
            --bs-progress-height: 0.75rem;
            --bs-progress-font-size: 0.65625rem;
            --bs-progress-bg: var(--bs-gray-300);
            --bs-progress-border-radius: 0.625rem;
            --bs-progress-box-shadow: inset 0 1px 2px rgba(14, 34, 56, .07);
            --bs-progress-bar-color: #fff;
            --bs-progress-bar-bg: {{ $settings->website_theme }};
            --bs-progress-bar-transition: width 0.6s ease;
            background-color: var(--bs-progress-bg);
            border-radius: var(--bs-progress-border-radius);
            box-shadow: var(--bs-progress-box-shadow);
            font-size: var(--bs-progress-font-size);
            height: var(--bs-progress-height)
        }

        .progress,
        .progress-bar {
            display: flex;
            overflow: hidden
        }

        .progress-bar {
            background-color: var(--bs-progress-bar-bg);
            color: var(--bs-progress-bar-color);
            flex-direction: column;
            justify-content: center;
            text-align: center;
            transition: var(--bs-progress-bar-transition);
            white-space: nowrap
        }

        @media(prefers-reduced-motion:reduce) {
            .progress-bar {
                transition: none
            }
        }

        .progress-bar-striped {
            background-image: linear-gradient(45deg, hsla(0, 0%, 100%, .15) 25%, transparent 0, transparent 50%, hsla(0, 0%, 100%, .15) 0, hsla(0, 0%, 100%, .15) 75%, transparent 0, transparent);
            background-size: var(--bs-progress-height) var(--bs-progress-height)
        }

        .progress-bar-animated {
            animation: progress-bar-stripes 1s linear infinite
        }

        @media(prefers-reduced-motion:reduce) {
            .progress-bar-animated {
                animation: none
            }
        }

        .list-group {
            --bs-list-group-color: var(--bs-body-color);
            --bs-list-group-bg: transparent;
            --bs-list-group-border-color: hsla(214, 7%, 62%, .1);
            --bs-list-group-border-width: 1px;
            --bs-list-group-border-radius: 0.625rem;
            --bs-list-group-item-padding-x: 1.25rem;
            --bs-list-group-item-padding-y: 0.9375rem;
            --bs-list-group-action-color: var(--bs-body-color);
            --bs-list-group-action-hover-color: var(--bs-body-color);
            --bs-list-group-action-hover-bg: rgba(0, 186, 199, .1);
            --bs-list-group-action-active-color: var(--bs-body-color);
            --bs-list-group-action-active-bg: rgba(0, 186, 199, .1);
            --bs-list-group-disabled-color: #989ea6;
            --bs-list-group-disabled-bg: transparent;
            --bs-list-group-active-color: var(--bs-body-color);
            --bs-list-group-active-bg: rgba(0, 186, 199, .1);
            --bs-list-group-active-border-color: rgba(0, 186, 199, .1);
            border-radius: var(--bs-list-group-border-radius);
            display: flex;
            flex-direction: column;
            margin-bottom: 0;
            padding-left: 0
        }

        .list-group-numbered {
            counter-reset: section;
            list-style-type: none
        }

        .list-group-numbered>.list-group-item:before {
            content: counters(section, ".") ". ";
            counter-increment: section
        }

        .list-group-item-action {
            color: var(--bs-list-group-action-color);
            text-align: inherit;
            width: 100%
        }

        .list-group-item-action:focus,
        .list-group-item-action:hover {
            background-color: var(--bs-list-group-action-hover-bg);
            color: var(--bs-list-group-action-hover-color);
            text-decoration: none;
            z-index: 1
        }

        .list-group-item-action:active {
            background-color: var(--bs-list-group-action-active-bg);
            color: var(--bs-list-group-action-active-color)
        }

        .list-group-item {
            background-color: var(--bs-list-group-bg);
            border: var(--bs-list-group-border-width) solid var(--bs-list-group-border-color);
            color: var(--bs-list-group-color);
            display: block;
            padding: var(--bs-list-group-item-padding-y) var(--bs-list-group-item-padding-x);
            position: relative
        }

        .list-group-item:first-child {
            border-top-left-radius: inherit;
            border-top-right-radius: inherit
        }

        .list-group-item:last-child {
            border-bottom-left-radius: inherit;
            border-bottom-right-radius: inherit
        }

        .list-group-item.disabled,
        .list-group-item:disabled {
            background-color: var(--bs-list-group-disabled-bg);
            color: var(--bs-list-group-disabled-color);
            pointer-events: none
        }

        .list-group-item.active {
            background-color: var(--bs-list-group-active-bg);
            border-color: var(--bs-list-group-active-border-color);
            color: var(--bs-list-group-active-color);
            z-index: 2
        }

        .list-group-item+.list-group-item {
            border-top-width: 0
        }

        .list-group-item+.list-group-item.active {
            border-top-width: var(--bs-list-group-border-width);
            margin-top: calc(var(--bs-list-group-border-width)*-1)
        }

        .list-group-horizontal {
            flex-direction: row
        }

        .list-group-horizontal>.list-group-item:first-child:not(:last-child) {
            border-bottom-left-radius: var(--bs-list-group-border-radius);
            border-top-right-radius: 0
        }

        .list-group-horizontal>.list-group-item:last-child:not(:first-child) {
            border-bottom-left-radius: 0;
            border-top-right-radius: var(--bs-list-group-border-radius)
        }

        .list-group-horizontal>.list-group-item.active {
            margin-top: 0
        }

        .list-group-horizontal>.list-group-item+.list-group-item {
            border-left-width: 0;
            border-top-width: var(--bs-list-group-border-width)
        }

        .list-group-horizontal>.list-group-item+.list-group-item.active {
            border-left-width: var(--bs-list-group-border-width);
            margin-left: calc(var(--bs-list-group-border-width)*-1)
        }

        @media(min-width:576px) {
            .list-group-horizontal-sm {
                flex-direction: row
            }

            .list-group-horizontal-sm>.list-group-item:first-child:not(:last-child) {
                border-bottom-left-radius: var(--bs-list-group-border-radius);
                border-top-right-radius: 0
            }

            .list-group-horizontal-sm>.list-group-item:last-child:not(:first-child) {
                border-bottom-left-radius: 0;
                border-top-right-radius: var(--bs-list-group-border-radius)
            }

            .list-group-horizontal-sm>.list-group-item.active {
                margin-top: 0
            }

            .list-group-horizontal-sm>.list-group-item+.list-group-item {
                border-left-width: 0;
                border-top-width: var(--bs-list-group-border-width)
            }

            .list-group-horizontal-sm>.list-group-item+.list-group-item.active {
                border-left-width: var(--bs-list-group-border-width);
                margin-left: calc(var(--bs-list-group-border-width)*-1)
            }
        }

        @media(min-width:768px) {
            .list-group-horizontal-md {
                flex-direction: row
            }

            .list-group-horizontal-md>.list-group-item:first-child:not(:last-child) {
                border-bottom-left-radius: var(--bs-list-group-border-radius);
                border-top-right-radius: 0
            }

            .list-group-horizontal-md>.list-group-item:last-child:not(:first-child) {
                border-bottom-left-radius: 0;
                border-top-right-radius: var(--bs-list-group-border-radius)
            }

            .list-group-horizontal-md>.list-group-item.active {
                margin-top: 0
            }

            .list-group-horizontal-md>.list-group-item+.list-group-item {
                border-left-width: 0;
                border-top-width: var(--bs-list-group-border-width)
            }

            .list-group-horizontal-md>.list-group-item+.list-group-item.active {
                border-left-width: var(--bs-list-group-border-width);
                margin-left: calc(var(--bs-list-group-border-width)*-1)
            }
        }

        @media(min-width:992px) {
            .list-group-horizontal-lg {
                flex-direction: row
            }

            .list-group-horizontal-lg>.list-group-item:first-child:not(:last-child) {
                border-bottom-left-radius: var(--bs-list-group-border-radius);
                border-top-right-radius: 0
            }

            .list-group-horizontal-lg>.list-group-item:last-child:not(:first-child) {
                border-bottom-left-radius: 0;
                border-top-right-radius: var(--bs-list-group-border-radius)
            }

            .list-group-horizontal-lg>.list-group-item.active {
                margin-top: 0
            }

            .list-group-horizontal-lg>.list-group-item+.list-group-item {
                border-left-width: 0;
                border-top-width: var(--bs-list-group-border-width)
            }

            .list-group-horizontal-lg>.list-group-item+.list-group-item.active {
                border-left-width: var(--bs-list-group-border-width);
                margin-left: calc(var(--bs-list-group-border-width)*-1)
            }
        }

        @media(min-width:1200px) {
            .list-group-horizontal-xl {
                flex-direction: row
            }

            .list-group-horizontal-xl>.list-group-item:first-child:not(:last-child) {
                border-bottom-left-radius: var(--bs-list-group-border-radius);
                border-top-right-radius: 0
            }

            .list-group-horizontal-xl>.list-group-item:last-child:not(:first-child) {
                border-bottom-left-radius: 0;
                border-top-right-radius: var(--bs-list-group-border-radius)
            }

            .list-group-horizontal-xl>.list-group-item.active {
                margin-top: 0
            }

            .list-group-horizontal-xl>.list-group-item+.list-group-item {
                border-left-width: 0;
                border-top-width: var(--bs-list-group-border-width)
            }

            .list-group-horizontal-xl>.list-group-item+.list-group-item.active {
                border-left-width: var(--bs-list-group-border-width);
                margin-left: calc(var(--bs-list-group-border-width)*-1)
            }
        }

        @media(min-width:1400px) {
            .list-group-horizontal-xxl {
                flex-direction: row
            }

            .list-group-horizontal-xxl>.list-group-item:first-child:not(:last-child) {
                border-bottom-left-radius: var(--bs-list-group-border-radius);
                border-top-right-radius: 0
            }

            .list-group-horizontal-xxl>.list-group-item:last-child:not(:first-child) {
                border-bottom-left-radius: 0;
                border-top-right-radius: var(--bs-list-group-border-radius)
            }

            .list-group-horizontal-xxl>.list-group-item.active {
                margin-top: 0
            }

            .list-group-horizontal-xxl>.list-group-item+.list-group-item {
                border-left-width: 0;
                border-top-width: var(--bs-list-group-border-width)
            }

            .list-group-horizontal-xxl>.list-group-item+.list-group-item.active {
                border-left-width: var(--bs-list-group-border-width);
                margin-left: calc(var(--bs-list-group-border-width)*-1)
            }
        }

        .list-group-flush {
            border-radius: 0
        }

        .list-group-flush>.list-group-item {
            border-width: 0 0 var(--bs-list-group-border-width)
        }

        .list-group-flush>.list-group-item:last-child {
            border-bottom-width: 0
        }

        .list-group-item-primary {
            background-color: #ccf1f4;
            color: #007077
        }

        .list-group-item-primary.list-group-item-action:focus,
        .list-group-item-primary.list-group-item-action:hover {
            background-color: #b8d9dc;
            color: #007077
        }

        .list-group-item-primary.list-group-item-action.active {
            background-color: #007077;
            border-color: #007077;
            color: #fff
        }

        .list-group-item-secondary {
            background-color: #eceef0;
            color: #5f656c
        }

        .list-group-item-secondary.list-group-item-action:focus,
        .list-group-item-secondary.list-group-item-action:hover {
            background-color: #d4d6d8;
            color: #5f656c
        }

        .list-group-item-secondary.list-group-item-action.active {
            background-color: #5f656c;
            border-color: #5f656c;
            color: #fff
        }

        .list-group-item-success {
            background-color: #d6f5e6;
            color: #1d7c4d
        }

        .list-group-item-success.list-group-item-action:focus,
        .list-group-item-success.list-group-item-action:hover {
            background-color: #c1ddcf;
            color: #1d7c4d
        }

        .list-group-item-success.list-group-item-action.active {
            background-color: #1d7c4d;
            border-color: #1d7c4d;
            color: #fff
        }

        .list-group-item-info {
            background-color: #d5eff5;
            color: #1b687c
        }

        .list-group-item-info.list-group-item-action:focus,
        .list-group-item-info.list-group-item-action:hover {
            background-color: #c0d7dd;
            color: #1b687c
        }

        .list-group-item-info.list-group-item-action.active {
            background-color: #1b687c;
            border-color: #1b687c;
            color: #fff
        }

        .list-group-item-warning {
            background-color: #fbf5dc;
            color: #8d7c2f
        }

        .list-group-item-warning.list-group-item-action:focus,
        .list-group-item-warning.list-group-item-action:hover {
            background-color: #e2ddc6;
            color: #8d7c2f
        }

        .list-group-item-warning.list-group-item-action.active {
            background-color: #8d7c2f;
            border-color: #8d7c2f;
            color: #fff
        }

        .list-group-item-danger {
            background-color: #f7d5de;
            color: #821a37
        }

        .list-group-item-danger.list-group-item-action:focus,
        .list-group-item-danger.list-group-item-action:hover {
            background-color: #dec0c8;
            color: #821a37
        }

        .list-group-item-danger.list-group-item-action.active {
            background-color: #821a37;
            border-color: #821a37;
            color: #fff
        }

        .list-group-item-light {
            background-color: #fdfdfe;
            color: #949495
        }

        .list-group-item-light.list-group-item-action:focus,
        .list-group-item-light.list-group-item-action:hover {
            background-color: #e4e4e5;
            color: #949495
        }

        .list-group-item-light.list-group-item-action.active {
            background-color: #949495;
            border-color: #949495;
            color: #fff
        }

        .list-group-item-dark {
            background-color: #cfd3d7;
            color: #081422
        }

        .list-group-item-dark.list-group-item-action:focus,
        .list-group-item-dark.list-group-item-action:hover {
            background-color: #babec2;
            color: #081422
        }

        .list-group-item-dark.list-group-item-action.active {
            background-color: #081422;
            border-color: #081422;
            color: #fff
        }

        .list-group-item-light-green {
            background-color: #fcfdfd;
            color: #919394
        }

        .list-group-item-light-green.list-group-item-action:focus,
        .list-group-item-light-green.list-group-item-action:hover {
            background-color: #e3e4e4;
            color: #919394
        }

        .list-group-item-light-green.list-group-item-action.active {
            background-color: #919394;
            border-color: #919394;
            color: #fff
        }

        .list-group-item-white {
            background-color: #fff;
            color: #999
        }

        .list-group-item-white.list-group-item-action:focus,
        .list-group-item-white.list-group-item-action:hover {
            background-color: #e6e6e6;
            color: #999
        }

        .list-group-item-white.list-group-item-action.active {
            background-color: #999;
            border-color: #999;
            color: #fff
        }

        .list-group-item-black {
            background-color: #ccc;
            color: #000
        }

        .list-group-item-black.list-group-item-action:focus,
        .list-group-item-black.list-group-item-action:hover {
            background-color: #b8b8b8;
            color: #000
        }

        .list-group-item-black.list-group-item-action.active {
            background-color: #000;
            border-color: #000;
            color: #fff
        }

        .list-group-item-blue {
            background-color: #cce3f4;
            color: #004677
        }

        .list-group-item-blue.list-group-item-action:focus,
        .list-group-item-blue.list-group-item-action:hover {
            background-color: #b8ccdc;
            color: #004677
        }

        .list-group-item-blue.list-group-item-action.active {
            background-color: #004677;
            border-color: #004677;
            color: #fff
        }

        .list-group-item-gray-100 {
            background-color: #fdfdfe;
            color: #949495
        }

        .list-group-item-gray-100.list-group-item-action:focus,
        .list-group-item-gray-100.list-group-item-action:hover {
            background-color: #e4e4e5;
            color: #949495
        }

        .list-group-item-gray-100.list-group-item-action.active {
            background-color: #949495;
            border-color: #949495;
            color: #fff
        }

        .list-group-item-gray-200 {
            background-color: #fdfdfd;
            color: #929292
        }

        .list-group-item-gray-200.list-group-item-action:focus,
        .list-group-item-gray-200.list-group-item-action:hover {
            background-color: #e4e4e4;
            color: #929292
        }

        .list-group-item-gray-200.list-group-item-action.active {
            background-color: #929292;
            border-color: #929292;
            color: #fff
        }

        .list-group-item-gray-300 {
            background-color: #fbfcfc;
            color: #8e8f90
        }

        .list-group-item-gray-300.list-group-item-action:focus,
        .list-group-item-gray-300.list-group-item-action:hover {
            background-color: #e2e3e3;
            color: #8e8f90
        }

        .list-group-item-gray-300.list-group-item-action.active {
            background-color: #8e8f90;
            border-color: #8e8f90;
            color: #fff
        }

        .list-group-item-gray-400 {
            background-color: #f7f8f9;
            color: #808388
        }

        .list-group-item-gray-400.list-group-item-action:focus,
        .list-group-item-gray-400.list-group-item-action:hover {
            background-color: #dedfe0;
            color: #808388
        }

        .list-group-item-gray-400.list-group-item-action.active {
            background-color: #808388;
            border-color: #808388;
            color: #fff
        }

        .list-group-item-gray-500 {
            background-color: #edeef0;
            color: #63676b
        }

        .list-group-item-gray-500.list-group-item-action:focus,
        .list-group-item-gray-500.list-group-item-action:hover {
            background-color: #d5d6d8;
            color: #63676b
        }

        .list-group-item-gray-500.list-group-item-action.active {
            background-color: #63676b;
            border-color: #63676b;
            color: #fff
        }

        .list-group-item-gray-600 {
            background-color: #eaeced;
            color: #5b5f64
        }

        .list-group-item-gray-600.list-group-item-action:focus,
        .list-group-item-gray-600.list-group-item-action:hover {
            background-color: #d3d4d5;
            color: #5b5f64
        }

        .list-group-item-gray-600.list-group-item-action.active {
            background-color: #5b5f64;
            border-color: #5b5f64;
            color: #fff
        }

        .list-group-item-gray-700 {
            background-color: #e2e2e2;
            color: #434343
        }

        .list-group-item-gray-700.list-group-item-action:focus,
        .list-group-item-gray-700.list-group-item-action:hover {
            background-color: #cbcbcb;
            color: #434343
        }

        .list-group-item-gray-700.list-group-item-action.active {
            background-color: #434343;
            border-color: #434343;
            color: #fff
        }

        .list-group-item-gray-800 {
            background-color: #d6d8d9;
            color: #1f2326
        }

        .list-group-item-gray-800.list-group-item-action:focus,
        .list-group-item-gray-800.list-group-item-action:hover {
            background-color: #c1c2c3;
            color: #1f2326
        }

        .list-group-item-gray-800.list-group-item-action.active {
            background-color: #1f2326;
            border-color: #1f2326;
            color: #fff
        }

        .list-group-item-gray-900 {
            background-color: #d3d3d4;
            color: #141619
        }

        .list-group-item-gray-900.list-group-item-action:focus,
        .list-group-item-gray-900.list-group-item-action:hover {
            background-color: #bebebf;
            color: #141619
        }

        .list-group-item-gray-900.list-group-item-action.active {
            background-color: #141619;
            border-color: #141619;
            color: #fff
        }

        .btn-close {
            background: transparent url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 24 24'%3E%3Cpath fill='%230E2238' d='M14.3 12.179a.25.25 0 0 1 0-.354l9.263-9.262A1.5 1.5 0 0 0 21.439.442L12.177 9.7a.25.25 0 0 1-.354 0L2.561.442A1.5 1.5 0 0 0 .439 2.563L9.7 11.825a.25.25 0 0 1 0 .354L.439 21.442a1.5 1.5 0 0 0 2.122 2.121l9.262-9.263a.25.25 0 0 1 .354 0l9.262 9.263a1.5 1.5 0 0 0 2.122-2.121Z'/%3E%3C/svg%3E") 50%/1em auto no-repeat;
            border: 0;
            border-radius: .625rem;
            box-sizing: content-box;
            color: #0e2238;
            height: 1em;
            opacity: .75;
            padding: .25em;
            width: 1em
        }

        .btn-close:hover {
            color: #0e2238;
            opacity: 1;
            text-decoration: none
        }

        .btn-close:focus {
            box-shadow: 0 0 transparent;
            opacity: 1;
            outline: 0
        }

        .btn-close.disabled,
        .btn-close:disabled {
            opacity: .25;
            pointer-events: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none
        }

        .btn-close-white {
            filter: invert(1) grayscale(100%) brightness(200%)
        }

        .toast {
            --bs-toast-zindex: 1090;
            --bs-toast-padding-x: 0.9375rem;
            --bs-toast-padding-y: 0.75rem;
            --bs-toast-spacing: 1.875rem;
            --bs-toast-max-width: 350px;
            --bs-toast-font-size: 0.875rem;
            --bs-toast-color: ;
            --bs-toast-bg: hsla(0, 0%, 100%, .9);
            --bs-toast-border-width: 1px;
            --bs-toast-border-color: var(--bs-border-color-translucent);
            --bs-toast-border-radius: 0.625rem;
            --bs-toast-box-shadow: 0 0.1875rem 0.1875rem 0 rgba(14, 34, 56, .07);
            --bs-toast-header-color: #989ea6;
            --bs-toast-header-bg: hsla(0, 0%, 100%, .85);
            --bs-toast-header-border-color: rgba(0, 0, 0, .05);
            background-clip: padding-box;
            background-color: var(--bs-toast-bg);
            border: var(--bs-toast-border-width) solid var(--bs-toast-border-color);
            border-radius: var(--bs-toast-border-radius);
            box-shadow: var(--bs-toast-box-shadow);
            color: var(--bs-toast-color);
            font-size: var(--bs-toast-font-size);
            max-width: 100%;
            pointer-events: auto;
            width: var(--bs-toast-max-width)
        }

        .toast.showing {
            opacity: 0
        }

        .toast:not(.show) {
            display: none
        }

        .toast-container {
            --bs-toast-zindex: 1090;
            max-width: 100%;
            pointer-events: none;
            position: absolute;
            width: -webkit-max-content;
            width: -moz-max-content;
            width: max-content;
            z-index: var(--bs-toast-zindex)
        }

        .toast-container>:not(:last-child) {
            margin-bottom: var(--bs-toast-spacing)
        }

        .toast-header {
            align-items: center;
            background-clip: padding-box;
            background-color: var(--bs-toast-header-bg);
            border-bottom: var(--bs-toast-border-width) solid var(--bs-toast-header-border-color);
            border-top-left-radius: calc(var(--bs-toast-border-radius) - var(--bs-toast-border-width));
            border-top-right-radius: calc(var(--bs-toast-border-radius) - var(--bs-toast-border-width));
            color: var(--bs-toast-header-color);
            display: flex;
            padding: var(--bs-toast-padding-y) var(--bs-toast-padding-x)
        }

        .toast-header .btn-close {
            margin-left: var(--bs-toast-padding-x);
            margin-right: calc(var(--bs-toast-padding-x)*-.5)
        }

        .toast-body {
            word-wrap: break-word;
            padding: var(--bs-toast-padding-x)
        }

        .modal {
            --bs-modal-zindex: 1055;
            --bs-modal-width: 500px;
            --bs-modal-padding: 1.875rem;
            --bs-modal-margin: 0.5rem;
            --bs-modal-color: ;
            --bs-modal-bg: var(--bs-white);
            --bs-modal-border-color: var(--bs-border-color-translucent);
            --bs-modal-border-width: 0;
            --bs-modal-border-radius: 0.75rem;
            --bs-modal-box-shadow: 0 0.125rem 0.125rem 0 rgba(14, 34, 56, .07);
            --bs-modal-inner-border-radius: 0.75rem;
            --bs-modal-header-padding-x: 1.875rem;
            --bs-modal-header-padding-y: 1.875rem;
            --bs-modal-header-padding: 1.875rem 1.875rem;
            --bs-modal-header-border-color: var(--bs-border-color);
            --bs-modal-header-border-width: 0;
            --bs-modal-title-line-height: 1.5;
            --bs-modal-footer-gap: 0.5rem;
            --bs-modal-footer-bg: ;
            --bs-modal-footer-border-color: var(--bs-border-color);
            --bs-modal-footer-border-width: 0;
            display: none;
            height: 100%;
            left: 0;
            outline: 0;
            overflow-x: hidden;
            overflow-y: auto;
            position: fixed;
            top: 0;
            width: 100%;
            z-index: var(--bs-modal-zindex)
        }

        .modal-dialog {
            margin: var(--bs-modal-margin);
            pointer-events: none;
            position: relative;
            width: auto
        }

        .modal.fade .modal-dialog {
            transform: translateY(-50px);
            transition: transform .3s ease-out
        }

        @media(prefers-reduced-motion:reduce) {
            .modal.fade .modal-dialog {
                transition: none
            }
        }

        .modal.show .modal-dialog {
            transform: none
        }

        .modal.modal-static .modal-dialog {
            transform: scale(1.02)
        }

        .modal-dialog-scrollable {
            height: calc(100% - var(--bs-modal-margin)*2)
        }

        .modal-dialog-scrollable .modal-content {
            max-height: 100%;
            overflow: hidden
        }

        .modal-dialog-scrollable .modal-body {
            overflow-y: auto
        }

        .modal-dialog-centered {
            align-items: center;
            display: flex;
            min-height: calc(100% - var(--bs-modal-margin)*2)
        }

        .modal-content {
            background-clip: padding-box;
            background-color: var(--bs-modal-bg);
            border: var(--bs-modal-border-width) solid var(--bs-modal-border-color);
            border-radius: var(--bs-modal-border-radius);
            box-shadow: var(--bs-modal-box-shadow);
            color: var(--bs-modal-color);
            display: flex;
            flex-direction: column;
            outline: 0;
            pointer-events: auto;
            position: relative;
            width: 100%
        }

        .modal-backdrop {
            --bs-backdrop-zindex: 1050;
            --bs-backdrop-bg: #0e2238;
            --bs-backdrop-opacity: 0.25;
            background-color: var(--bs-backdrop-bg);
            height: 100vh;
            left: 0;
            position: fixed;
            top: 0;
            width: 100vw;
            z-index: var(--bs-backdrop-zindex)
        }

        .modal-backdrop.fade {
            opacity: 0
        }

        .modal-backdrop.show {
            opacity: var(--bs-backdrop-opacity)
        }

        .modal-header {
            align-items: center;
            border-bottom: var(--bs-modal-header-border-width) solid var(--bs-modal-header-border-color);
            border-top-left-radius: var(--bs-modal-inner-border-radius);
            border-top-right-radius: var(--bs-modal-inner-border-radius);
            display: flex;
            flex-shrink: 0;
            justify-content: space-between;
            padding: var(--bs-modal-header-padding)
        }

        .modal-header .btn-close {
            margin: calc(var(--bs-modal-header-padding-y)*-.5) calc(var(--bs-modal-header-padding-x)*-.5) calc(var(--bs-modal-header-padding-y)*-.5) auto;
            padding: calc(var(--bs-modal-header-padding-y)*.5) calc(var(--bs-modal-header-padding-x)*.5)
        }

        .modal-title {
            line-height: var(--bs-modal-title-line-height);
            margin-bottom: 0
        }

        .modal-body {
            flex: 1 1 auto;
            padding: var(--bs-modal-padding);
            position: relative
        }

        .modal-footer {
            align-items: center;
            background-color: var(--bs-modal-footer-bg);
            border-bottom-left-radius: var(--bs-modal-inner-border-radius);
            border-bottom-right-radius: var(--bs-modal-inner-border-radius);
            border-top: var(--bs-modal-footer-border-width) solid var(--bs-modal-footer-border-color);
            display: flex;
            flex-shrink: 0;
            flex-wrap: wrap;
            justify-content: flex-end;
            padding: calc(var(--bs-modal-padding) - var(--bs-modal-footer-gap)*.5)
        }

        .modal-footer>* {
            margin: calc(var(--bs-modal-footer-gap)*.5)
        }

        @media(min-width:576px) {
            .modal {
                --bs-modal-margin: 1.75rem;
                --bs-modal-box-shadow: 0 0.1875rem 0.1875rem 0 rgba(14, 34, 56, .07)
            }

            .modal-dialog {
                margin-left: auto;
                margin-right: auto;
                max-width: var(--bs-modal-width)
            }

            .modal-sm {
                --bs-modal-width: 300px
            }
        }

        @media(min-width:992px) {

            .modal-lg,
            .modal-xl {
                --bs-modal-width: 800px
            }
        }

        @media(min-width:1200px) {
            .modal-xl {
                --bs-modal-width: 1140px
            }
        }

        .modal-fullscreen {
            height: 100%;
            margin: 0;
            max-width: none;
            width: 100vw
        }

        .modal-fullscreen .modal-content {
            border: 0;
            border-radius: 0;
            height: 100%
        }

        .modal-fullscreen .modal-footer,
        .modal-fullscreen .modal-header {
            border-radius: 0
        }

        .modal-fullscreen .modal-body {
            overflow-y: auto
        }

        @media(max-width:575.98px) {
            .modal-fullscreen-sm-down {
                height: 100%;
                margin: 0;
                max-width: none;
                width: 100vw
            }

            .modal-fullscreen-sm-down .modal-content {
                border: 0;
                border-radius: 0;
                height: 100%
            }

            .modal-fullscreen-sm-down .modal-footer,
            .modal-fullscreen-sm-down .modal-header {
                border-radius: 0
            }

            .modal-fullscreen-sm-down .modal-body {
                overflow-y: auto
            }
        }

        @media(max-width:767.98px) {
            .modal-fullscreen-md-down {
                height: 100%;
                margin: 0;
                max-width: none;
                width: 100vw
            }

            .modal-fullscreen-md-down .modal-content {
                border: 0;
                border-radius: 0;
                height: 100%
            }

            .modal-fullscreen-md-down .modal-footer,
            .modal-fullscreen-md-down .modal-header {
                border-radius: 0
            }

            .modal-fullscreen-md-down .modal-body {
                overflow-y: auto
            }
        }

        @media(max-width:991.98px) {
            .modal-fullscreen-lg-down {
                height: 100%;
                margin: 0;
                max-width: none;
                width: 100vw
            }

            .modal-fullscreen-lg-down .modal-content {
                border: 0;
                border-radius: 0;
                height: 100%
            }

            .modal-fullscreen-lg-down .modal-footer,
            .modal-fullscreen-lg-down .modal-header {
                border-radius: 0
            }

            .modal-fullscreen-lg-down .modal-body {
                overflow-y: auto
            }
        }

        @media(max-width:1199.98px) {
            .modal-fullscreen-xl-down {
                height: 100%;
                margin: 0;
                max-width: none;
                width: 100vw
            }

            .modal-fullscreen-xl-down .modal-content {
                border: 0;
                border-radius: 0;
                height: 100%
            }

            .modal-fullscreen-xl-down .modal-footer,
            .modal-fullscreen-xl-down .modal-header {
                border-radius: 0
            }

            .modal-fullscreen-xl-down .modal-body {
                overflow-y: auto
            }
        }

        @media(max-width:1399.98px) {
            .modal-fullscreen-xxl-down {
                height: 100%;
                margin: 0;
                max-width: none;
                width: 100vw
            }

            .modal-fullscreen-xxl-down .modal-content {
                border: 0;
                border-radius: 0;
                height: 100%
            }

            .modal-fullscreen-xxl-down .modal-footer,
            .modal-fullscreen-xxl-down .modal-header {
                border-radius: 0
            }

            .modal-fullscreen-xxl-down .modal-body {
                overflow-y: auto
            }
        }

        .tooltip {
            --bs-tooltip-zindex: 1080;
            --bs-tooltip-max-width: 200px;
            --bs-tooltip-padding-x: 0.9375rem;
            --bs-tooltip-padding-y: 0.46875rem;
            --bs-tooltip-margin: ;
            --bs-tooltip-font-size: 0.6875rem;
            --bs-tooltip-color: var(--bs-white);
            --bs-tooltip-bg: var(--bs-dark);
            --bs-tooltip-border-radius: 0.25rem;
            --bs-tooltip-opacity: 1;
            --bs-tooltip-arrow-width: 0.8rem;
            --bs-tooltip-arrow-height: 0.4rem;
            word-wrap: break-word;
            display: block;
            font-family: var(--bs-font-sans-serif);
            font-size: var(--bs-tooltip-font-size);
            font-style: normal;
            font-weight: 400;
            letter-spacing: normal;
            line-break: auto;
            line-height: 1.5;
            margin: var(--bs-tooltip-margin);
            opacity: 0;
            padding: var(--bs-tooltip-arrow-height);
            text-align: left;
            text-align: start;
            text-decoration: none;
            text-shadow: none;
            text-transform: none;
            white-space: normal;
            word-break: normal;
            word-spacing: normal;
            z-index: var(--bs-tooltip-zindex)
        }

        .tooltip.show {
            opacity: var(--bs-tooltip-opacity)
        }

        .tooltip .tooltip-arrow {
            display: block;
            height: var(--bs-tooltip-arrow-height);
            width: var(--bs-tooltip-arrow-width)
        }

        .tooltip .tooltip-arrow:before {
            border-color: transparent;
            border-style: solid;
            content: "";
            position: absolute
        }

        .bs-tooltip-auto[data-popper-placement^=top] .tooltip-arrow,
        .bs-tooltip-top .tooltip-arrow {
            bottom: 0
        }

        .bs-tooltip-auto[data-popper-placement^=top] .tooltip-arrow:before,
        .bs-tooltip-top .tooltip-arrow:before {
            border-top-color: var(--bs-tooltip-bg);
            border-width: var(--bs-tooltip-arrow-height) calc(var(--bs-tooltip-arrow-width)*.5) 0;
            top: -1px
        }

        .bs-tooltip-auto[data-popper-placement^=right] .tooltip-arrow,
        .bs-tooltip-end .tooltip-arrow {
            height: var(--bs-tooltip-arrow-width);
            left: 0;
            width: var(--bs-tooltip-arrow-height)
        }

        .bs-tooltip-auto[data-popper-placement^=right] .tooltip-arrow:before,
        .bs-tooltip-end .tooltip-arrow:before {
            border-right-color: var(--bs-tooltip-bg);
            border-width: calc(var(--bs-tooltip-arrow-width)*.5) var(--bs-tooltip-arrow-height) calc(var(--bs-tooltip-arrow-width)*.5) 0;
            right: -1px
        }

        .bs-tooltip-auto[data-popper-placement^=bottom] .tooltip-arrow,
        .bs-tooltip-bottom .tooltip-arrow {
            top: 0
        }

        .bs-tooltip-auto[data-popper-placement^=bottom] .tooltip-arrow:before,
        .bs-tooltip-bottom .tooltip-arrow:before {
            border-bottom-color: var(--bs-tooltip-bg);
            border-width: 0 calc(var(--bs-tooltip-arrow-width)*.5) var(--bs-tooltip-arrow-height);
            bottom: -1px
        }

        .bs-tooltip-auto[data-popper-placement^=left] .tooltip-arrow,
        .bs-tooltip-start .tooltip-arrow {
            height: var(--bs-tooltip-arrow-width);
            right: 0;
            width: var(--bs-tooltip-arrow-height)
        }

        .bs-tooltip-auto[data-popper-placement^=left] .tooltip-arrow:before,
        .bs-tooltip-start .tooltip-arrow:before {
            border-left-color: var(--bs-tooltip-bg);
            border-width: calc(var(--bs-tooltip-arrow-width)*.5) 0 calc(var(--bs-tooltip-arrow-width)*.5) var(--bs-tooltip-arrow-height);
            left: -1px
        }

        .tooltip-inner {
            background-color: var(--bs-tooltip-bg);
            border-radius: var(--bs-tooltip-border-radius);
            color: var(--bs-tooltip-color);
            max-width: var(--bs-tooltip-max-width);
            padding: var(--bs-tooltip-padding-y) var(--bs-tooltip-padding-x);
            text-align: center
        }

        .popover {
            --bs-popover-zindex: 1070;
            --bs-popover-max-width: 276px;
            --bs-popover-font-size: 0.6875rem;
            --bs-popover-bg: var(--bs-white);
            --bs-popover-border-width: 1px;
            --bs-popover-border-color: var(--bs-border-color-translucent);
            --bs-popover-border-radius: 0.625rem;
            --bs-popover-inner-border-radius: calc(0.625rem - 1px);
            --bs-popover-box-shadow: 0 0.125rem 0.125rem 0 rgba(14, 34, 56, .07);
            --bs-popover-header-padding-x: 1.875rem;
            --bs-popover-header-padding-y: 0.5rem;
            --bs-popover-header-font-size: 0.875rem;
            --bs-popover-header-color: ;
            --bs-popover-header-bg: var(--bs-light);
            --bs-popover-body-padding-x: 1.875rem;
            --bs-popover-body-padding-y: 1.875rem;
            --bs-popover-body-color: #0e2238;
            --bs-popover-arrow-width: 1rem;
            --bs-popover-arrow-height: 0.5rem;
            --bs-popover-arrow-border: var(--bs-popover-border-color);
            word-wrap: break-word;
            background-clip: padding-box;
            background-color: var(--bs-popover-bg);
            border: var(--bs-popover-border-width) solid var(--bs-popover-border-color);
            border-radius: var(--bs-popover-border-radius);
            box-shadow: var(--bs-popover-box-shadow);
            display: block;
            font-family: var(--bs-font-sans-serif);
            font-size: var(--bs-popover-font-size);
            font-style: normal;
            font-weight: 400;
            letter-spacing: normal;
            line-break: auto;
            line-height: 1.5;
            max-width: var(--bs-popover-max-width);
            text-align: left;
            text-align: start;
            text-decoration: none;
            text-shadow: none;
            text-transform: none;
            white-space: normal;
            word-break: normal;
            word-spacing: normal;
            z-index: var(--bs-popover-zindex)
        }

        .popover .popover-arrow {
            display: block;
            height: var(--bs-popover-arrow-height);
            width: var(--bs-popover-arrow-width)
        }

        .popover .popover-arrow:after,
        .popover .popover-arrow:before {
            border: 0 solid transparent;
            content: "";
            display: block;
            position: absolute
        }

        .bs-popover-auto[data-popper-placement^=top]>.popover-arrow,
        .bs-popover-top>.popover-arrow {
            bottom: calc((var(--bs-popover-arrow-height))*-1 - var(--bs-popover-border-width))
        }

        .bs-popover-auto[data-popper-placement^=top]>.popover-arrow:after,
        .bs-popover-auto[data-popper-placement^=top]>.popover-arrow:before,
        .bs-popover-top>.popover-arrow:after,
        .bs-popover-top>.popover-arrow:before {
            border-width: var(--bs-popover-arrow-height) calc(var(--bs-popover-arrow-width)*.5) 0
        }

        .bs-popover-auto[data-popper-placement^=top]>.popover-arrow:before,
        .bs-popover-top>.popover-arrow:before {
            border-top-color: var(--bs-popover-arrow-border);
            bottom: 0
        }

        .bs-popover-auto[data-popper-placement^=top]>.popover-arrow:after,
        .bs-popover-top>.popover-arrow:after {
            border-top-color: var(--bs-popover-bg);
            bottom: var(--bs-popover-border-width)
        }

        .bs-popover-auto[data-popper-placement^=right]>.popover-arrow,
        .bs-popover-end>.popover-arrow {
            height: var(--bs-popover-arrow-width);
            left: calc((var(--bs-popover-arrow-height))*-1 - var(--bs-popover-border-width));
            width: var(--bs-popover-arrow-height)
        }

        .bs-popover-auto[data-popper-placement^=right]>.popover-arrow:after,
        .bs-popover-auto[data-popper-placement^=right]>.popover-arrow:before,
        .bs-popover-end>.popover-arrow:after,
        .bs-popover-end>.popover-arrow:before {
            border-width: calc(var(--bs-popover-arrow-width)*.5) var(--bs-popover-arrow-height) calc(var(--bs-popover-arrow-width)*.5) 0
        }

        .bs-popover-auto[data-popper-placement^=right]>.popover-arrow:before,
        .bs-popover-end>.popover-arrow:before {
            border-right-color: var(--bs-popover-arrow-border);
            left: 0
        }

        .bs-popover-auto[data-popper-placement^=right]>.popover-arrow:after,
        .bs-popover-end>.popover-arrow:after {
            border-right-color: var(--bs-popover-bg);
            left: var(--bs-popover-border-width)
        }

        .bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow,
        .bs-popover-bottom>.popover-arrow {
            top: calc((var(--bs-popover-arrow-height))*-1 - var(--bs-popover-border-width))
        }

        .bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:after,
        .bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:before,
        .bs-popover-bottom>.popover-arrow:after,
        .bs-popover-bottom>.popover-arrow:before {
            border-width: 0 calc(var(--bs-popover-arrow-width)*.5) var(--bs-popover-arrow-height)
        }

        .bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:before,
        .bs-popover-bottom>.popover-arrow:before {
            border-bottom-color: var(--bs-popover-arrow-border);
            top: 0
        }

        .bs-popover-auto[data-popper-placement^=bottom]>.popover-arrow:after,
        .bs-popover-bottom>.popover-arrow:after {
            border-bottom-color: var(--bs-popover-bg);
            top: var(--bs-popover-border-width)
        }

        .bs-popover-auto[data-popper-placement^=bottom] .popover-header:before,
        .bs-popover-bottom .popover-header:before {
            border-bottom: var(--bs-popover-border-width) solid var(--bs-popover-header-bg);
            content: "";
            display: block;
            left: 50%;
            margin-left: calc(var(--bs-popover-arrow-width)*-.5);
            position: absolute;
            top: 0;
            width: var(--bs-popover-arrow-width)
        }

        .bs-popover-auto[data-popper-placement^=left]>.popover-arrow,
        .bs-popover-start>.popover-arrow {
            height: var(--bs-popover-arrow-width);
            right: calc((var(--bs-popover-arrow-height))*-1 - var(--bs-popover-border-width));
            width: var(--bs-popover-arrow-height)
        }

        .bs-popover-auto[data-popper-placement^=left]>.popover-arrow:after,
        .bs-popover-auto[data-popper-placement^=left]>.popover-arrow:before,
        .bs-popover-start>.popover-arrow:after,
        .bs-popover-start>.popover-arrow:before {
            border-width: calc(var(--bs-popover-arrow-width)*.5) 0 calc(var(--bs-popover-arrow-width)*.5) var(--bs-popover-arrow-height)
        }

        .bs-popover-auto[data-popper-placement^=left]>.popover-arrow:before,
        .bs-popover-start>.popover-arrow:before {
            border-left-color: var(--bs-popover-arrow-border);
            right: 0
        }

        .bs-popover-auto[data-popper-placement^=left]>.popover-arrow:after,
        .bs-popover-start>.popover-arrow:after {
            border-left-color: var(--bs-popover-bg);
            right: var(--bs-popover-border-width)
        }

        .popover-header {
            background-color: var(--bs-popover-header-bg);
            border-bottom: var(--bs-popover-border-width) solid var(--bs-popover-border-color);
            border-top-left-radius: var(--bs-popover-inner-border-radius);
            border-top-right-radius: var(--bs-popover-inner-border-radius);
            color: var(--bs-popover-header-color);
            font-size: var(--bs-popover-header-font-size);
            margin-bottom: 0;
            padding: var(--bs-popover-header-padding-y) var(--bs-popover-header-padding-x)
        }

        .popover-header:empty {
            display: none
        }

        .popover-body {
            color: var(--bs-popover-body-color);
            padding: var(--bs-popover-body-padding-y) var(--bs-popover-body-padding-x)
        }

        .carousel {
            position: relative
        }

        .carousel.pointer-event {
            touch-action: pan-y
        }

        .carousel-inner {
            overflow: hidden;
            position: relative;
            width: 100%
        }

        .carousel-inner:after {
            clear: both;
            content: "";
            display: block
        }

        .carousel-item {
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            display: none;
            float: left;
            margin-right: -100%;
            position: relative;
            transition: transform .6s ease-in-out;
            width: 100%
        }

        @media(prefers-reduced-motion:reduce) {
            .carousel-item {
                transition: none
            }
        }

        .carousel-item-next,
        .carousel-item-prev,
        .carousel-item.active {
            display: block
        }

        .active.carousel-item-end,
        .carousel-item-next:not(.carousel-item-start) {
            transform: translateX(100%)
        }

        .active.carousel-item-start,
        .carousel-item-prev:not(.carousel-item-end) {
            transform: translateX(-100%)
        }

        .carousel-fade .carousel-item {
            opacity: 0;
            transform: none;
            transition-property: opacity
        }

        .carousel-fade .carousel-item-next.carousel-item-start,
        .carousel-fade .carousel-item-prev.carousel-item-end,
        .carousel-fade .carousel-item.active {
            opacity: 1;
            z-index: 1
        }

        .carousel-fade .active.carousel-item-end,
        .carousel-fade .active.carousel-item-start {
            opacity: 0;
            transition: opacity 0s .6s;
            z-index: 0
        }

        @media(prefers-reduced-motion:reduce) {

            .carousel-fade .active.carousel-item-end,
            .carousel-fade .active.carousel-item-start {
                transition: none
            }
        }

        .carousel-control-next,
        .carousel-control-prev {
            align-items: center;
            background: none;
            border: 0;
            bottom: 0;
            color: #fff;
            display: flex;
            justify-content: center;
            opacity: .5;
            padding: 0;
            position: absolute;
            text-align: center;
            top: 0;
            transition: opacity .15s ease;
            width: 15%;
            z-index: 1
        }

        @media(prefers-reduced-motion:reduce) {

            .carousel-control-next,
            .carousel-control-prev {
                transition: none
            }
        }

        .carousel-control-next:focus,
        .carousel-control-next:hover,
        .carousel-control-prev:focus,
        .carousel-control-prev:hover {
            color: #fff;
            opacity: .9;
            outline: 0;
            text-decoration: none
        }

        .carousel-control-prev {
            left: 0
        }

        .carousel-control-next {
            right: 0
        }

        .carousel-control-next-icon,
        .carousel-control-prev-icon {
            background-position: 50%;
            background-repeat: no-repeat;
            background-size: 100% 100%;
            display: inline-block;
            height: 2rem;
            width: 2rem
        }

        .carousel-control-prev-icon {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23FFF' viewBox='0 0 16 16'%3E%3Cpath d='M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z'/%3E%3C/svg%3E")
        }

        .carousel-control-next-icon {
            background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23FFF' viewBox='0 0 16 16'%3E%3Cpath d='M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z'/%3E%3C/svg%3E")
        }

        .carousel-indicators {
            bottom: 0;
            display: flex;
            justify-content: center;
            left: 0;
            list-style: none;
            margin-bottom: 1rem;
            margin-left: 15%;
            margin-right: 15%;
            padding: 0;
            position: absolute;
            right: 0;
            z-index: 2
        }

        .carousel-indicators [data-bs-target] {
            background-clip: padding-box;
            background-color: #fff;
            border: 0;
            border-bottom: 10px solid transparent;
            border-top: 10px solid transparent;
            box-sizing: content-box;
            cursor: pointer;
            flex: 0 1 auto;
            height: 3px;
            margin-left: 3px;
            margin-right: 3px;
            opacity: .5;
            padding: 0;
            text-indent: -999px;
            transition: opacity .6s ease;
            width: 30px
        }

        @media(prefers-reduced-motion:reduce) {
            .carousel-indicators [data-bs-target] {
                transition: none
            }
        }

        .carousel-indicators .active {
            opacity: 1
        }

        .carousel-caption {
            bottom: 1.25rem;
            color: #fff;
            left: 15%;
            padding-bottom: 1.25rem;
            padding-top: 1.25rem;
            position: absolute;
            right: 15%;
            text-align: center
        }

        .carousel-dark .carousel-control-next-icon,
        .carousel-dark .carousel-control-prev-icon {
            filter: invert(1) grayscale(100)
        }

        .carousel-dark .carousel-indicators [data-bs-target] {
            background-color: #000
        }

        .carousel-dark .carousel-caption {
            color: #000
        }

        .spinner-border,
        .spinner-grow {
            animation: var(--bs-spinner-animation-speed) linear infinite var(--bs-spinner-animation-name);
            border-radius: 50%;
            display: inline-block;
            height: var(--bs-spinner-height);
            vertical-align: var(--bs-spinner-vertical-align);
            width: var(--bs-spinner-width)
        }

        @keyframes spinner-border {
            to {
                transform: rotate(1turn)
            }
        }

        .spinner-border {
            --bs-spinner-width: 2rem;
            --bs-spinner-height: 2rem;
            --bs-spinner-vertical-align: -0.125em;
            --bs-spinner-border-width: 0.25em;
            --bs-spinner-animation-speed: 0.75s;
            --bs-spinner-animation-name: spinner-border;
            border-right-color: currentcolor;
            border: var(--bs-spinner-border-width) solid;
            border-right: var(--bs-spinner-border-width) solid transparent
        }

        .spinner-border-sm {
            --bs-spinner-width: 1rem;
            --bs-spinner-height: 1rem;
            --bs-spinner-border-width: 0.2em
        }

        @keyframes spinner-grow {
            0% {
                transform: scale(0)
            }

            50% {
                opacity: 1;
                transform: none
            }
        }

        .spinner-grow {
            --bs-spinner-width: 2rem;
            --bs-spinner-height: 2rem;
            --bs-spinner-vertical-align: -0.125em;
            --bs-spinner-animation-speed: 0.75s;
            --bs-spinner-animation-name: spinner-grow;
            background-color: currentcolor;
            opacity: 0
        }

        .spinner-grow-sm {
            --bs-spinner-width: 1rem;
            --bs-spinner-height: 1rem
        }

        @media(prefers-reduced-motion:reduce) {

            .spinner-border,
            .spinner-grow {
                --bs-spinner-animation-speed: 1.5s
            }
        }

        .offcanvas,
        .offcanvas-lg,
        .offcanvas-md,
        .offcanvas-sm,
        .offcanvas-xl,
        .offcanvas-xxl {
            --bs-offcanvas-zindex: 1045;
            --bs-offcanvas-width: 400px;
            --bs-offcanvas-height: 30vh;
            --bs-offcanvas-padding-x: 1.875rem;
            --bs-offcanvas-padding-y: 1.875rem;
            --bs-offcanvas-color: ;
            --bs-offcanvas-bg: var(--bs-white);
            --bs-offcanvas-border-width: 0;
            --bs-offcanvas-border-color: var(--bs-border-color-translucent);
            --bs-offcanvas-box-shadow: 0 0.125rem 0.125rem 0 rgba(14, 34, 56, .07)
        }

        @media(max-width:575.98px) {
            .offcanvas-sm {
                background-clip: padding-box;
                background-color: var(--bs-offcanvas-bg);
                bottom: 0;
                box-shadow: var(--bs-offcanvas-box-shadow);
                color: var(--bs-offcanvas-color);
                display: flex;
                flex-direction: column;
                max-width: 100%;
                outline: 0;
                position: fixed;
                transition: transform .3s ease-in-out;
                visibility: hidden;
                z-index: var(--bs-offcanvas-zindex)
            }
        }

        @media(max-width:575.98px)and (prefers-reduced-motion:reduce) {
            .offcanvas-sm {
                transition: none
            }
        }

        @media(max-width:575.98px) {
            .offcanvas-sm.offcanvas-start {
                border-right: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                left: 0;
                top: 0;
                transform: translateX(-100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-sm.offcanvas-end {
                border-left: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                right: 0;
                top: 0;
                transform: translateX(100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-sm.offcanvas-top {
                border-bottom: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                top: 0;
                transform: translateY(-100%)
            }

            .offcanvas-sm.offcanvas-bottom,
            .offcanvas-sm.offcanvas-top {
                height: var(--bs-offcanvas-height);
                left: 0;
                max-height: 100%;
                right: 0
            }

            .offcanvas-sm.offcanvas-bottom {
                border-top: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                transform: translateY(100%)
            }

            .offcanvas-sm.show:not(.hiding),
            .offcanvas-sm.showing {
                transform: none
            }

            .offcanvas-sm.hiding,
            .offcanvas-sm.show,
            .offcanvas-sm.showing {
                visibility: visible
            }
        }

        @media(min-width:576px) {
            .offcanvas-sm {
                --bs-offcanvas-height: auto;
                --bs-offcanvas-border-width: 0;
                background-color: transparent !important
            }

            .offcanvas-sm .offcanvas-header {
                display: none
            }

            .offcanvas-sm .offcanvas-body {
                background-color: transparent !important;
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(max-width:767.98px) {
            .offcanvas-md {
                background-clip: padding-box;
                background-color: var(--bs-offcanvas-bg);
                bottom: 0;
                box-shadow: var(--bs-offcanvas-box-shadow);
                color: var(--bs-offcanvas-color);
                display: flex;
                flex-direction: column;
                max-width: 100%;
                outline: 0;
                position: fixed;
                transition: transform .3s ease-in-out;
                visibility: hidden;
                z-index: var(--bs-offcanvas-zindex)
            }
        }

        @media(max-width:767.98px)and (prefers-reduced-motion:reduce) {
            .offcanvas-md {
                transition: none
            }
        }

        @media(max-width:767.98px) {
            .offcanvas-md.offcanvas-start {
                border-right: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                left: 0;
                top: 0;
                transform: translateX(-100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-md.offcanvas-end {
                border-left: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                right: 0;
                top: 0;
                transform: translateX(100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-md.offcanvas-top {
                border-bottom: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                top: 0;
                transform: translateY(-100%)
            }

            .offcanvas-md.offcanvas-bottom,
            .offcanvas-md.offcanvas-top {
                height: var(--bs-offcanvas-height);
                left: 0;
                max-height: 100%;
                right: 0
            }

            .offcanvas-md.offcanvas-bottom {
                border-top: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                transform: translateY(100%)
            }

            .offcanvas-md.show:not(.hiding),
            .offcanvas-md.showing {
                transform: none
            }

            .offcanvas-md.hiding,
            .offcanvas-md.show,
            .offcanvas-md.showing {
                visibility: visible
            }
        }

        @media(min-width:768px) {
            .offcanvas-md {
                --bs-offcanvas-height: auto;
                --bs-offcanvas-border-width: 0;
                background-color: transparent !important
            }

            .offcanvas-md .offcanvas-header {
                display: none
            }

            .offcanvas-md .offcanvas-body {
                background-color: transparent !important;
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(max-width:991.98px) {
            .offcanvas-lg {
                background-clip: padding-box;
                background-color: var(--bs-offcanvas-bg);
                bottom: 0;
                box-shadow: var(--bs-offcanvas-box-shadow);
                color: var(--bs-offcanvas-color);
                display: flex;
                flex-direction: column;
                max-width: 100%;
                outline: 0;
                position: fixed;
                transition: transform .3s ease-in-out;
                visibility: hidden;
                z-index: var(--bs-offcanvas-zindex)
            }
        }

        @media(max-width:991.98px)and (prefers-reduced-motion:reduce) {
            .offcanvas-lg {
                transition: none
            }
        }

        @media(max-width:991.98px) {
            .offcanvas-lg.offcanvas-start {
                border-right: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                left: 0;
                top: 0;
                transform: translateX(-100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-lg.offcanvas-end {
                border-left: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                right: 0;
                top: 0;
                transform: translateX(100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-lg.offcanvas-top {
                border-bottom: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                top: 0;
                transform: translateY(-100%)
            }

            .offcanvas-lg.offcanvas-bottom,
            .offcanvas-lg.offcanvas-top {
                height: var(--bs-offcanvas-height);
                left: 0;
                max-height: 100%;
                right: 0
            }

            .offcanvas-lg.offcanvas-bottom {
                border-top: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                transform: translateY(100%)
            }

            .offcanvas-lg.show:not(.hiding),
            .offcanvas-lg.showing {
                transform: none
            }

            .offcanvas-lg.hiding,
            .offcanvas-lg.show,
            .offcanvas-lg.showing {
                visibility: visible
            }
        }

        @media(min-width:992px) {
            .offcanvas-lg {
                --bs-offcanvas-height: auto;
                --bs-offcanvas-border-width: 0;
                background-color: transparent !important
            }

            .offcanvas-lg .offcanvas-header {
                display: none
            }

            .offcanvas-lg .offcanvas-body {
                background-color: transparent !important;
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(max-width:1199.98px) {
            .offcanvas-xl {
                background-clip: padding-box;
                background-color: var(--bs-offcanvas-bg);
                bottom: 0;
                box-shadow: var(--bs-offcanvas-box-shadow);
                color: var(--bs-offcanvas-color);
                display: flex;
                flex-direction: column;
                max-width: 100%;
                outline: 0;
                position: fixed;
                transition: transform .3s ease-in-out;
                visibility: hidden;
                z-index: var(--bs-offcanvas-zindex)
            }
        }

        @media(max-width:1199.98px)and (prefers-reduced-motion:reduce) {
            .offcanvas-xl {
                transition: none
            }
        }

        @media(max-width:1199.98px) {
            .offcanvas-xl.offcanvas-start {
                border-right: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                left: 0;
                top: 0;
                transform: translateX(-100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-xl.offcanvas-end {
                border-left: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                right: 0;
                top: 0;
                transform: translateX(100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-xl.offcanvas-top {
                border-bottom: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                top: 0;
                transform: translateY(-100%)
            }

            .offcanvas-xl.offcanvas-bottom,
            .offcanvas-xl.offcanvas-top {
                height: var(--bs-offcanvas-height);
                left: 0;
                max-height: 100%;
                right: 0
            }

            .offcanvas-xl.offcanvas-bottom {
                border-top: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                transform: translateY(100%)
            }

            .offcanvas-xl.show:not(.hiding),
            .offcanvas-xl.showing {
                transform: none
            }

            .offcanvas-xl.hiding,
            .offcanvas-xl.show,
            .offcanvas-xl.showing {
                visibility: visible
            }
        }

        @media(min-width:1200px) {
            .offcanvas-xl {
                --bs-offcanvas-height: auto;
                --bs-offcanvas-border-width: 0;
                background-color: transparent !important
            }

            .offcanvas-xl .offcanvas-header {
                display: none
            }

            .offcanvas-xl .offcanvas-body {
                background-color: transparent !important;
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        @media(max-width:1399.98px) {
            .offcanvas-xxl {
                background-clip: padding-box;
                background-color: var(--bs-offcanvas-bg);
                bottom: 0;
                box-shadow: var(--bs-offcanvas-box-shadow);
                color: var(--bs-offcanvas-color);
                display: flex;
                flex-direction: column;
                max-width: 100%;
                outline: 0;
                position: fixed;
                transition: transform .3s ease-in-out;
                visibility: hidden;
                z-index: var(--bs-offcanvas-zindex)
            }
        }

        @media(max-width:1399.98px)and (prefers-reduced-motion:reduce) {
            .offcanvas-xxl {
                transition: none
            }
        }

        @media(max-width:1399.98px) {
            .offcanvas-xxl.offcanvas-start {
                border-right: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                left: 0;
                top: 0;
                transform: translateX(-100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-xxl.offcanvas-end {
                border-left: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                right: 0;
                top: 0;
                transform: translateX(100%);
                width: var(--bs-offcanvas-width)
            }

            .offcanvas-xxl.offcanvas-top {
                border-bottom: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                top: 0;
                transform: translateY(-100%)
            }

            .offcanvas-xxl.offcanvas-bottom,
            .offcanvas-xxl.offcanvas-top {
                height: var(--bs-offcanvas-height);
                left: 0;
                max-height: 100%;
                right: 0
            }

            .offcanvas-xxl.offcanvas-bottom {
                border-top: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
                transform: translateY(100%)
            }

            .offcanvas-xxl.show:not(.hiding),
            .offcanvas-xxl.showing {
                transform: none
            }

            .offcanvas-xxl.hiding,
            .offcanvas-xxl.show,
            .offcanvas-xxl.showing {
                visibility: visible
            }
        }

        @media(min-width:1400px) {
            .offcanvas-xxl {
                --bs-offcanvas-height: auto;
                --bs-offcanvas-border-width: 0;
                background-color: transparent !important
            }

            .offcanvas-xxl .offcanvas-header {
                display: none
            }

            .offcanvas-xxl .offcanvas-body {
                background-color: transparent !important;
                display: flex;
                flex-grow: 0;
                overflow-y: visible;
                padding: 0
            }
        }

        .offcanvas {
            background-clip: padding-box;
            background-color: var(--bs-offcanvas-bg);
            bottom: 0;
            box-shadow: var(--bs-offcanvas-box-shadow);
            color: var(--bs-offcanvas-color);
            display: flex;
            flex-direction: column;
            max-width: 100%;
            outline: 0;
            position: fixed;
            transition: transform .3s ease-in-out;
            visibility: hidden;
            z-index: var(--bs-offcanvas-zindex)
        }

        @media(prefers-reduced-motion:reduce) {
            .offcanvas {
                transition: none
            }
        }

        .offcanvas.offcanvas-start {
            border-right: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
            left: 0;
            top: 0;
            transform: translateX(-100%);
            width: var(--bs-offcanvas-width)
        }

        .offcanvas.offcanvas-end {
            border-left: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
            right: 0;
            top: 0;
            transform: translateX(100%);
            width: var(--bs-offcanvas-width)
        }

        .offcanvas.offcanvas-top {
            border-bottom: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
            top: 0;
            transform: translateY(-100%)
        }

        .offcanvas.offcanvas-bottom,
        .offcanvas.offcanvas-top {
            height: var(--bs-offcanvas-height);
            left: 0;
            max-height: 100%;
            right: 0
        }

        .offcanvas.offcanvas-bottom {
            border-top: var(--bs-offcanvas-border-width) solid var(--bs-offcanvas-border-color);
            transform: translateY(100%)
        }

        .offcanvas.show:not(.hiding),
        .offcanvas.showing {
            transform: none
        }

        .offcanvas.hiding,
        .offcanvas.show,
        .offcanvas.showing {
            visibility: visible
        }

        .offcanvas-backdrop {
            background-color: #0e2238;
            height: 100vh;
            left: 0;
            position: fixed;
            top: 0;
            width: 100vw;
            z-index: 1040
        }

        .offcanvas-backdrop.fade {
            opacity: 0
        }

        .offcanvas-backdrop.show {
            opacity: .25
        }

        .offcanvas-header {
            align-items: center;
            display: flex;
            justify-content: space-between;
            padding: var(--bs-offcanvas-padding-y) var(--bs-offcanvas-padding-x)
        }

        .offcanvas-header .btn-close {
            margin-bottom: calc(var(--bs-offcanvas-padding-y)*-.5);
            margin-right: calc(var(--bs-offcanvas-padding-x)*-.5);
            margin-top: calc(var(--bs-offcanvas-padding-y)*-.5);
            padding: calc(var(--bs-offcanvas-padding-y)*.5) calc(var(--bs-offcanvas-padding-x)*.5)
        }

        .offcanvas-title {
            line-height: 1.5;
            margin-bottom: 0
        }

        .offcanvas-body {
            flex-grow: 1;
            overflow-y: auto;
            padding: var(--bs-offcanvas-padding-y) var(--bs-offcanvas-padding-x)
        }

        .placeholder {
            background-color: currentcolor;
            cursor: wait;
            display: inline-block;
            min-height: 1em;
            opacity: .5;
            vertical-align: middle
        }

        .placeholder.btn:before {
            content: "";
            display: inline-block
        }

        .placeholder-xs {
            min-height: .6em
        }

        .placeholder-sm {
            min-height: .8em
        }

        .placeholder-lg {
            min-height: 1.2em
        }

        .placeholder-glow .placeholder {
            animation: placeholder-glow 2s ease-in-out infinite
        }

        @keyframes placeholder-glow {
            50% {
                opacity: .2
            }
        }

        .placeholder-wave {
            animation: placeholder-wave 2s linear infinite;
            -webkit-mask-image: linear-gradient(130deg, #000 55%, rgba(0, 0, 0, .8) 75%, #000 95%);
            mask-image: linear-gradient(130deg, #000 55%, rgba(0, 0, 0, .8) 75%, #000 95%);
            -webkit-mask-size: 200% 100%;
            mask-size: 200% 100%
        }

        @keyframes placeholder-wave {
            to {
                -webkit-mask-position: -200% 0;
                mask-position: -200% 0
            }
        }

        .text-bg-primary-soft {
            background-color: #def6f8 !important;
            color: {{ $settings->website_theme }} !important
        }

        .text-bg-primary-soft .alert-link {
            color: {{ $settings->website_theme }}
        }

        .text-bg-secondary-soft {
            background-color: #f2f4f5 !important;
            color: #9ea9b4 !important
        }

        .text-bg-secondary-soft .alert-link {
            color: #9ea9b4
        }

        .text-bg-success-soft {
            background-color: #e4f9ee !important;
            color: #31cf80 !important
        }

        .text-bg-success-soft .alert-link {
            color: #31cf80
        }

        .text-bg-info-soft {
            background-color: #e4f4f9 !important;
            color: #2dadcf !important
        }

        .text-bg-info-soft .alert-link {
            color: #2dadcf
        }

        .text-bg-warning-soft {
            background-color: #fcf9e8 !important;
            color: #ebcf4f !important
        }

        .text-bg-warning-soft .alert-link {
            color: #ebcf4f
        }

        .text-bg-danger-soft {
            background-color: #fae4ea !important;
            color: #d82c5b !important
        }

        .text-bg-danger-soft .alert-link {
            color: #d82c5b
        }

        .text-bg-light-soft {
            background-color: #fefefe !important;
            color: #f6f7f8 !important
        }

        .text-bg-light-soft .alert-link {
            color: #f6f7f8
        }

        .text-bg-dark-soft {
            background-color: #e0e2e5 !important;
            color: #0e2238 !important
        }

        .text-bg-dark-soft .alert-link {
            color: #0e2238
        }

        .text-bg-light-green-soft {
            background-color: #fdfefe !important;
            color: #f1f5f7 !important
        }

        .text-bg-light-green-soft .alert-link {
            color: #f1f5f7
        }

        .text-bg-white-soft {
            background-color: #fff !important;
            color: #fff !important
        }

        .text-bg-white-soft .alert-link {
            color: #fff
        }

        .text-bg-black-soft {
            background-color: #dedede !important;
            color: #000 !important
        }

        .text-bg-black-soft .alert-link {
            color: #000
        }

        .text-bg-blue-soft {
            background-color: #deedf8 !important;
            color: #0075c7 !important
        }

        .text-bg-blue-soft .alert-link {
            color: #0075c7
        }

        .text-bg-gray-100-soft {
            background-color: #fefefe !important;
            color: #f6f7f8 !important
        }

        .text-bg-gray-100-soft .alert-link {
            color: #f6f7f8
        }

        .text-bg-gray-200-soft {
            background-color: #fefefe !important;
            color: #f4f4f4 !important
        }

        .text-bg-gray-200-soft .alert-link {
            color: #f4f4f4
        }

        .text-bg-gray-300-soft {
            background-color: #fdfdfd !important;
            color: #edeef0 !important
        }

        .text-bg-gray-300-soft .alert-link {
            color: #edeef0
        }

        .text-bg-gray-400-soft {
            background-color: #fafafb !important;
            color: #d6dae2 !important
        }

        .text-bg-gray-400-soft .alert-link {
            color: #d6dae2
        }

        .text-bg-gray-500-soft {
            background-color: #f3f4f5 !important;
            color: #a5abb3 !important
        }

        .text-bg-gray-500-soft .alert-link {
            color: #a5abb3
        }

        .text-bg-gray-600-soft {
            background-color: #f2f2f3 !important;
            color: #989ea6 !important
        }

        .text-bg-gray-600-soft .alert-link {
            color: #989ea6
        }

        .text-bg-gray-700-soft {
            background-color: #ececec !important;
            color: #707070 !important
        }

        .text-bg-gray-700-soft .alert-link {
            color: #707070
        }

        .text-bg-gray-800-soft {
            background-color: #e5e5e6 !important;
            color: #343a40 !important
        }

        .text-bg-gray-800-soft .alert-link {
            color: #343a40
        }

        .text-bg-gray-900-soft {
            background-color: #e2e3e3 !important;
            color: #212529 !important
        }

        .text-bg-gray-900-soft .alert-link {
            color: #212529
        }

        [data-theme=dark] .text-bg-primary {
            background-color: RGBA(0, 186, 199, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-secondary {
            background-color: RGBA(158, 169, 180, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-success {
            background-color: RGBA(49, 207, 128, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-info {
            background-color: RGBA(45, 173, 207, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-warning {
            background-color: RGBA(235, 207, 79, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-danger {
            background-color: RGBA(216, 44, 91, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-light {
            background-color: RGBA(54, 54, 55, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-dark {
            background-color: RGBA(89, 92, 95, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-light-green {
            background-color: RGBA(29, 29, 30, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-white {
            background-color: RGBA(45, 45, 45, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-black {
            background-color: RGBA(255, 255, 255, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        [data-theme=dark] .text-bg-gray-100,
        [data-theme=dark] .text-bg-gray-200 {
            background-color: RGBA(31, 31, 31, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-300 {
            background-color: RGBA(30, 30, 30, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-400 {
            background-color: RGBA(27, 27, 28, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-500 {
            background-color: RGBA(183, 188, 194, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-600 {
            background-color: RGBA(178, 182, 188, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-700 {
            background-color: RGBA(155, 155, 155, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-800 {
            background-color: RGBA(133, 137, 140, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-900 {
            background-color: RGBA(144, 146, 148, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-primary-soft {
            background-color: #def6f8 !important;
            color: {{ $settings->website_theme }} !important
        }

        [data-theme=dark] .text-bg-secondary-soft {
            background-color: #f2f4f5 !important;
            color: #9ea9b4 !important
        }

        [data-theme=dark] .text-bg-success-soft {
            background-color: #e4f9ee !important;
            color: #31cf80 !important
        }

        [data-theme=dark] .text-bg-info-soft {
            background-color: #e4f4f9 !important;
            color: #2dadcf !important
        }

        [data-theme=dark] .text-bg-warning-soft {
            background-color: #fcf9e8 !important;
            color: #ebcf4f !important
        }

        [data-theme=dark] .text-bg-danger-soft {
            background-color: #fae4ea !important;
            color: #d82c5b !important
        }

        [data-theme=dark] .text-bg-light-soft {
            background-color: #e5e5e5 !important;
            color: #363637 !important
        }

        [data-theme=dark] .text-bg-dark-soft {
            background-color: #e9eaea !important;
            color: #595c5f !important
        }

        [data-theme=dark] .text-bg-light-green-soft {
            background-color: #e2e2e2 !important;
            color: #1d1d1e !important
        }

        [data-theme=dark] .text-bg-white-soft {
            background-color: #e4e4e4 !important;
            color: #2d2d2d !important
        }

        [data-theme=dark] .text-bg-black-soft {
            background-color: #fff !important;
            color: #fff !important
        }

        [data-theme=dark] .text-bg-gray-100-soft,
        [data-theme=dark] .text-bg-gray-200-soft {
            background-color: #e2e2e2 !important;
            color: #1f1f1f !important
        }

        [data-theme=dark] .text-bg-gray-300-soft {
            background-color: #e2e2e2 !important;
            color: #1e1e1e !important
        }

        [data-theme=dark] .text-bg-gray-400-soft {
            background-color: #e1e1e1 !important;
            color: #1b1b1c !important
        }

        [data-theme=dark] .text-bg-gray-500-soft {
            background-color: #f6f6f7 !important;
            color: #b7bcc2 !important
        }

        [data-theme=dark] .text-bg-gray-600-soft {
            background-color: #f5f6f6 !important;
            color: #b2b6bc !important
        }

        [data-theme=dark] .text-bg-gray-700-soft {
            background-color: #f2f2f2 !important;
            color: #9b9b9b !important
        }

        [data-theme=dark] .text-bg-gray-800-soft {
            background-color: #eff0f0 !important;
            color: #85898c !important
        }

        [data-theme=dark] .text-bg-gray-900-soft {
            background-color: #f1f1f1 !important;
            color: #909294 !important
        }

        .overlay {
            position: relative
        }

        .overlay:before {
            bottom: 0;
            content: "";
            left: 0;
            position: absolute;
            right: 0;
            top: 0
        }

        .overlay-0:before {
            opacity: 0 !important
        }

        .overlay-10:before {
            opacity: 10% !important
        }

        .overlay-20:before {
            opacity: 20% !important
        }

        .overlay-30:before {
            opacity: 30% !important
        }

        .overlay-40:before {
            opacity: 40% !important
        }

        .overlay-50:before {
            opacity: 50% !important
        }

        .overlay-60:before {
            opacity: 60% !important
        }

        .overlay-70:before {
            opacity: 70% !important
        }

        .overlay-80:before {
            opacity: 80% !important
        }

        .overlay-90:before {
            opacity: 90% !important
        }

        .overlay-100:before {
            opacity: 100% !important
        }

        .overlay-primary:before {
            background-color: {{ $settings->website_theme }} !important
        }

        .overlay-secondary:before {
            background-color: #9ea9b4 !important
        }

        .overlay-success:before {
            background-color: #31cf80 !important
        }

        .overlay-info:before {
            background-color: #2dadcf !important
        }

        .overlay-warning:before {
            background-color: #ebcf4f !important
        }

        .overlay-danger:before {
            background-color: #d82c5b !important
        }

        .overlay-light:before {
            background-color: #f6f7f8 !important
        }

        .overlay-dark:before {
            background-color: #0e2238 !important
        }

        .overlay-light-green:before {
            background-color: #f1f5f7 !important
        }

        .overlay-white:before {
            background-color: #fff !important
        }

        .overlay-black:before {
            background-color: #000 !important
        }

        .overlay-blue:before {
            background-color: #0075c7 !important
        }

        .overlay-gray-100:before {
            background-color: #f6f7f8 !important
        }

        .overlay-gray-200:before {
            background-color: #f4f4f4 !important
        }

        .overlay-gray-300:before {
            background-color: #edeef0 !important
        }

        .overlay-gray-400:before {
            background-color: #d6dae2 !important
        }

        .overlay-gray-500:before {
            background-color: #a5abb3 !important
        }

        .overlay-gray-600:before {
            background-color: #989ea6 !important
        }

        .overlay-gray-700:before {
            background-color: #707070 !important
        }

        .overlay-gray-800:before {
            background-color: #343a40 !important
        }

        .overlay-gray-900:before {
            background-color: #212529 !important
        }

        .clearfix:after {
            clear: both;
            content: "";
            display: block
        }

        .text-bg-primary {
            background-color: RGBA(0, 186, 199, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-secondary {
            background-color: RGBA(158, 169, 180, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-success {
            background-color: RGBA(49, 207, 128, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-info {
            background-color: RGBA(45, 173, 207, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-warning {
            background-color: RGBA(235, 207, 79, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-danger {
            background-color: RGBA(216, 44, 91, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-light {
            background-color: RGBA(246, 247, 248, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        .text-bg-dark {
            background-color: RGBA(14, 34, 56, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-light-green {
            background-color: RGBA(241, 245, 247, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        .text-bg-white {
            background-color: RGBA(255, 255, 255, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        .text-bg-black {
            background-color: RGBA(0, 0, 0, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-blue {
            background-color: RGBA(0, 117, 199, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-gray-100 {
            background-color: RGBA(246, 247, 248, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        .text-bg-gray-200 {
            background-color: RGBA(244, 244, 244, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        .text-bg-gray-300 {
            background-color: RGBA(237, 238, 240, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        .text-bg-gray-400 {
            background-color: RGBA(214, 218, 226, var(--bs-bg-opacity, 1)) !important;
            color: #000 !important
        }

        .text-bg-gray-500 {
            background-color: RGBA(165, 171, 179, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-gray-600 {
            background-color: RGBA(152, 158, 166, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-gray-700 {
            background-color: RGBA(112, 112, 112, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-gray-800 {
            background-color: RGBA(52, 58, 64, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .text-bg-gray-900 {
            background-color: RGBA(33, 37, 41, var(--bs-bg-opacity, 1)) !important;
            color: #fff !important
        }

        .link-primary {
            color: {{ $settings->website_theme }} !important
        }

        .link-primary:focus,
        .link-primary:hover {
            color: {{ $settings->website_theme }} !important
        }

        .link-secondary {
            color: #9ea9b4 !important
        }

        .link-secondary:focus,
        .link-secondary:hover {
            color: #7e8790 !important
        }

        .link-success {
            color: #31cf80 !important
        }

        .link-success:focus,
        .link-success:hover {
            color: #27a666 !important
        }

        .link-info {
            color: #2dadcf !important
        }

        .link-info:focus,
        .link-info:hover {
            color: #248aa6 !important
        }

        .link-warning {
            color: #ebcf4f !important
        }

        .link-warning:focus,
        .link-warning:hover {
            color: #bca63f !important
        }

        .link-danger {
            color: #d82c5b !important
        }

        .link-danger:focus,
        .link-danger:hover {
            color: #ad2349 !important
        }

        .link-light {
            color: #f6f7f8 !important
        }

        .link-light:focus,
        .link-light:hover {
            color: #f8f9f9 !important
        }

        .link-dark {
            color: #0e2238 !important
        }

        .link-dark:focus,
        .link-dark:hover {
            color: #0b1b2d !important
        }

        .link-light-green {
            color: #f1f5f7 !important
        }

        .link-light-green:focus,
        .link-light-green:hover {
            color: #f4f7f9 !important
        }

        .link-white,
        .link-white:focus,
        .link-white:hover {
            color: #fff !important
        }

        .link-black,
        .link-black:focus,
        .link-black:hover {
            color: #000 !important
        }

        .link-blue {
            color: #0075c7 !important
        }

        .link-blue:focus,
        .link-blue:hover {
            color: #005e9f !important
        }

        .link-gray-100 {
            color: #f6f7f8 !important
        }

        .link-gray-100:focus,
        .link-gray-100:hover {
            color: #f8f9f9 !important
        }

        .link-gray-200 {
            color: #f4f4f4 !important
        }

        .link-gray-200:focus,
        .link-gray-200:hover {
            color: #f6f6f6 !important
        }

        .link-gray-300 {
            color: #edeef0 !important
        }

        .link-gray-300:focus,
        .link-gray-300:hover {
            color: #f1f1f3 !important
        }

        .link-gray-400 {
            color: #d6dae2 !important
        }

        .link-gray-400:focus,
        .link-gray-400:hover {
            color: #dee1e8 !important
        }

        .link-gray-500 {
            color: #a5abb3 !important
        }

        .link-gray-500:focus,
        .link-gray-500:hover {
            color: #84898f !important
        }

        .link-gray-600 {
            color: #989ea6 !important
        }

        .link-gray-600:focus,
        .link-gray-600:hover {
            color: #7a7e85 !important
        }

        .link-gray-700 {
            color: #707070 !important
        }

        .link-gray-700:focus,
        .link-gray-700:hover {
            color: #5a5a5a !important
        }

        .link-gray-800 {
            color: #343a40 !important
        }

        .link-gray-800:focus,
        .link-gray-800:hover {
            color: #2a2e33 !important
        }

        .link-gray-900 {
            color: #212529 !important
        }

        .link-gray-900:focus,
        .link-gray-900:hover {
            color: #1a1e21 !important
        }

        .ratio {
            position: relative;
            width: 100%
        }

        .ratio:before {
            content: "";
            display: block;
            padding-top: var(--bs-aspect-ratio)
        }

        .ratio>* {
            height: 100%;
            left: 0;
            position: absolute;
            top: 0;
            width: 100%
        }

        .ratio-1x1 {
            --bs-aspect-ratio: 100%
        }

        .ratio-4x3 {
            --bs-aspect-ratio: 75%
        }

        .ratio-16x9 {
            --bs-aspect-ratio: 56.25%
        }

        .ratio-21x9 {
            --bs-aspect-ratio: 42.8571428571%
        }

        .fixed-top {
            top: 0
        }

        .fixed-bottom,
        .fixed-top {
            left: 0;
            position: fixed;
            right: 0;
            z-index: 1030
        }

        .fixed-bottom {
            bottom: 0
        }

        .sticky-top {
            top: 0
        }

        .sticky-bottom,
        .sticky-top {
            position: -webkit-sticky;
            position: sticky;
            z-index: 1020
        }

        .sticky-bottom {
            bottom: 0
        }

        @media(min-width:576px) {
            .sticky-sm-top {
                top: 0
            }

            .sticky-sm-bottom,
            .sticky-sm-top {
                position: -webkit-sticky;
                position: sticky;
                z-index: 1020
            }

            .sticky-sm-bottom {
                bottom: 0
            }
        }

        @media(min-width:768px) {
            .sticky-md-top {
                top: 0
            }

            .sticky-md-bottom,
            .sticky-md-top {
                position: -webkit-sticky;
                position: sticky;
                z-index: 1020
            }

            .sticky-md-bottom {
                bottom: 0
            }
        }

        @media(min-width:992px) {
            .sticky-lg-top {
                top: 0
            }

            .sticky-lg-bottom,
            .sticky-lg-top {
                position: -webkit-sticky;
                position: sticky;
                z-index: 1020
            }

            .sticky-lg-bottom {
                bottom: 0
            }
        }

        @media(min-width:1200px) {
            .sticky-xl-top {
                top: 0
            }

            .sticky-xl-bottom,
            .sticky-xl-top {
                position: -webkit-sticky;
                position: sticky;
                z-index: 1020
            }

            .sticky-xl-bottom {
                bottom: 0
            }
        }

        @media(min-width:1400px) {
            .sticky-xxl-top {
                top: 0
            }

            .sticky-xxl-bottom,
            .sticky-xxl-top {
                position: -webkit-sticky;
                position: sticky;
                z-index: 1020
            }

            .sticky-xxl-bottom {
                bottom: 0
            }
        }

        .hstack {
            align-items: center;
            flex-direction: row
        }

        .hstack,
        .vstack {
            align-self: stretch;
            display: flex
        }

        .vstack {
            flex: 1 1 auto;
            flex-direction: column
        }

        .visually-hidden,
        .visually-hidden-focusable:not(:focus):not(:focus-within) {
            clip: rect(0, 0, 0, 0) !important;
            border: 0 !important;
            height: 1px !important;
            margin: -1px !important;
            overflow: hidden !important;
            padding: 0 !important;
            position: absolute !important;
            white-space: nowrap !important;
            width: 1px !important
        }

        .stretched-link:after {
            bottom: 0;
            content: "";
            left: 0;
            position: absolute;
            right: 0;
            top: 0;
            z-index: 1
        }

        .text-truncate {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap
        }

        .vr {
            align-self: stretch;
            background-color: currentcolor;
            display: inline-block;
            min-height: 1em;
            opacity: .1;
            width: 1px
        }

        .align-baseline {
            vertical-align: baseline !important
        }

        .align-top {
            vertical-align: top !important
        }

        .align-middle {
            vertical-align: middle !important
        }

        .align-bottom {
            vertical-align: bottom !important
        }

        .align-text-bottom {
            vertical-align: text-bottom !important
        }

        .align-text-top {
            vertical-align: text-top !important
        }

        .float-start {
            float: left !important
        }

        .float-end {
            float: right !important
        }

        .float-none {
            float: none !important
        }

        .opacity-0 {
            opacity: 0 !important
        }

        .opacity-10 {
            opacity: .1 !important
        }

        .opacity-20 {
            opacity: .2 !important
        }

        .opacity-30 {
            opacity: .3 !important
        }

        .opacity-40 {
            opacity: .4 !important
        }

        .opacity-50 {
            opacity: .5 !important
        }

        .opacity-60 {
            opacity: .6 !important
        }

        .opacity-70 {
            opacity: .7 !important
        }

        .opacity-80 {
            opacity: .8 !important
        }

        .opacity-90 {
            opacity: .9 !important
        }

        .opacity-100 {
            opacity: 1 !important
        }

        .overflow-auto {
            overflow: auto !important
        }

        .overflow-hidden {
            overflow: hidden !important
        }

        .overflow-visible {
            overflow: visible !important
        }

        .overflow-scroll {
            overflow: scroll !important
        }

        .d-inline {
            display: inline !important
        }

        .d-inline-block {
            display: inline-block !important
        }

        .d-block {
            display: block !important
        }

        .d-grid {
            display: grid !important
        }

        .d-table {
            display: table !important
        }

        .d-table-row {
            display: table-row !important
        }

        .d-table-cell {
            display: table-cell !important
        }

        .d-flex {
            display: flex !important
        }

        .d-inline-flex {
            display: inline-flex !important
        }

        .d-none {
            display: none !important
        }

        .shadow {
            box-shadow: 0 .1875rem .1875rem 0 rgba(14, 34, 56, .07) !important
        }

        .shadow-sm {
            box-shadow: 0 .125rem .125rem 0 rgba(14, 34, 56, .07) !important
        }

        .shadow-lg {
            box-shadow: 0 1rem 3rem rgba(14, 34, 56, .1) !important
        }

        .shadow-none {
            box-shadow: none !important
        }

        .position-static {
            position: static !important
        }

        .position-relative {
            position: relative !important
        }

        .position-absolute {
            position: absolute !important
        }

        .position-fixed {
            position: fixed !important
        }

        .position-sticky {
            position: -webkit-sticky !important;
            position: sticky !important
        }

        .top-0 {
            top: 0 !important
        }

        .top-25 {
            top: 25% !important
        }

        .top-50 {
            top: 50% !important
        }

        .top-75 {
            top: 75% !important
        }

        .top-100 {
            top: 100% !important
        }

        .top-auto {
            top: auto !important
        }

        .top-1px {
            top: 1px !important
        }

        .top-2px {
            top: 2px !important
        }

        .top-3px {
            top: 3px !important
        }

        .top-4px {
            top: 4px !important
        }

        .top-5px {
            top: 5px !important
        }

        .top-6px {
            top: 6px !important
        }

        .top-7px {
            top: 7px !important
        }

        .top-8px {
            top: 8px !important
        }

        .top-9px {
            top: 9px !important
        }

        .top-10px {
            top: 10px !important
        }

        .top-15px {
            top: 15px !important
        }

        .top-20px {
            top: 20px !important
        }

        .top-25px {
            top: 25px !important
        }

        .top-30px {
            top: 30px !important
        }

        .top-35px {
            top: 35px !important
        }

        .top-40px {
            top: 40px !important
        }

        .top-45px {
            top: 45px !important
        }

        .top-50px {
            top: 50px !important
        }

        .top-55px {
            top: 55px !important
        }

        .top-60px {
            top: 60px !important
        }

        .top-65px {
            top: 65px !important
        }

        .top-70px {
            top: 70px !important
        }

        .top-75px {
            top: 75px !important
        }

        .top-80px {
            top: 80px !important
        }

        .top-85px {
            top: 85px !important
        }

        .top-90px {
            top: 90px !important
        }

        .top-95px {
            top: 95px !important
        }

        .top-100px {
            top: 100px !important
        }

        .top-125px {
            top: 125px !important
        }

        .top-150px {
            top: 150px !important
        }

        .top-175px {
            top: 175px !important
        }

        .top-200px {
            top: 200px !important
        }

        .top-225px {
            top: 225px !important
        }

        .top-250px {
            top: 250px !important
        }

        .top-275px {
            top: 275px !important
        }

        .top-300px {
            top: 300px !important
        }

        .top-325px {
            top: 325px !important
        }

        .top-350px {
            top: 350px !important
        }

        .top-375px {
            top: 375px !important
        }

        .top-400px {
            top: 400px !important
        }

        .top-425px {
            top: 425px !important
        }

        .top-450px {
            top: 450px !important
        }

        .top-475px {
            top: 475px !important
        }

        .top-500px {
            top: 500px !important
        }

        .top-550px {
            top: 550px !important
        }

        .top-600px {
            top: 600px !important
        }

        .top-650px {
            top: 650px !important
        }

        .top-700px {
            top: 700px !important
        }

        .top-750px {
            top: 750px !important
        }

        .top-800px {
            top: 800px !important
        }

        .top-850px {
            top: 850px !important
        }

        .top-900px {
            top: 900px !important
        }

        .top-950px {
            top: 950px !important
        }

        .top-1000px {
            top: 1000px !important
        }

        .bottom-0 {
            bottom: 0 !important
        }

        .bottom-25 {
            bottom: 25% !important
        }

        .bottom-50 {
            bottom: 50% !important
        }

        .bottom-75 {
            bottom: 75% !important
        }

        .bottom-100 {
            bottom: 100% !important
        }

        .bottom-auto {
            bottom: auto !important
        }

        .bottom-1px {
            bottom: 1px !important
        }

        .bottom-2px {
            bottom: 2px !important
        }

        .bottom-3px {
            bottom: 3px !important
        }

        .bottom-4px {
            bottom: 4px !important
        }

        .bottom-5px {
            bottom: 5px !important
        }

        .bottom-6px {
            bottom: 6px !important
        }

        .bottom-7px {
            bottom: 7px !important
        }

        .bottom-8px {
            bottom: 8px !important
        }

        .bottom-9px {
            bottom: 9px !important
        }

        .bottom-10px {
            bottom: 10px !important
        }

        .bottom-15px {
            bottom: 15px !important
        }

        .bottom-20px {
            bottom: 20px !important
        }

        .bottom-25px {
            bottom: 25px !important
        }

        .bottom-30px {
            bottom: 30px !important
        }

        .bottom-35px {
            bottom: 35px !important
        }

        .bottom-40px {
            bottom: 40px !important
        }

        .bottom-45px {
            bottom: 45px !important
        }

        .bottom-50px {
            bottom: 50px !important
        }

        .bottom-55px {
            bottom: 55px !important
        }

        .bottom-60px {
            bottom: 60px !important
        }

        .bottom-65px {
            bottom: 65px !important
        }

        .bottom-70px {
            bottom: 70px !important
        }

        .bottom-75px {
            bottom: 75px !important
        }

        .bottom-80px {
            bottom: 80px !important
        }

        .bottom-85px {
            bottom: 85px !important
        }

        .bottom-90px {
            bottom: 90px !important
        }

        .bottom-95px {
            bottom: 95px !important
        }

        .bottom-100px {
            bottom: 100px !important
        }

        .bottom-125px {
            bottom: 125px !important
        }

        .bottom-150px {
            bottom: 150px !important
        }

        .bottom-175px {
            bottom: 175px !important
        }

        .bottom-200px {
            bottom: 200px !important
        }

        .bottom-225px {
            bottom: 225px !important
        }

        .bottom-250px {
            bottom: 250px !important
        }

        .bottom-275px {
            bottom: 275px !important
        }

        .bottom-300px {
            bottom: 300px !important
        }

        .bottom-325px {
            bottom: 325px !important
        }

        .bottom-350px {
            bottom: 350px !important
        }

        .bottom-375px {
            bottom: 375px !important
        }

        .bottom-400px {
            bottom: 400px !important
        }

        .bottom-425px {
            bottom: 425px !important
        }

        .bottom-450px {
            bottom: 450px !important
        }

        .bottom-475px {
            bottom: 475px !important
        }

        .bottom-500px {
            bottom: 500px !important
        }

        .bottom-550px {
            bottom: 550px !important
        }

        .bottom-600px {
            bottom: 600px !important
        }

        .bottom-650px {
            bottom: 650px !important
        }

        .bottom-700px {
            bottom: 700px !important
        }

        .bottom-750px {
            bottom: 750px !important
        }

        .bottom-800px {
            bottom: 800px !important
        }

        .bottom-850px {
            bottom: 850px !important
        }

        .bottom-900px {
            bottom: 900px !important
        }

        .bottom-950px {
            bottom: 950px !important
        }

        .bottom-1000px {
            bottom: 1000px !important
        }

        .start-0 {
            left: 0 !important
        }

        .start-25 {
            left: 25% !important
        }

        .start-50 {
            left: 50% !important
        }

        .start-75 {
            left: 75% !important
        }

        .start-100 {
            left: 100% !important
        }

        .start-auto {
            left: auto !important
        }

        .start-1px {
            left: 1px !important
        }

        .start-2px {
            left: 2px !important
        }

        .start-3px {
            left: 3px !important
        }

        .start-4px {
            left: 4px !important
        }

        .start-5px {
            left: 5px !important
        }

        .start-6px {
            left: 6px !important
        }

        .start-7px {
            left: 7px !important
        }

        .start-8px {
            left: 8px !important
        }

        .start-9px {
            left: 9px !important
        }

        .start-10px {
            left: 10px !important
        }

        .start-15px {
            left: 15px !important
        }

        .start-20px {
            left: 20px !important
        }

        .start-25px {
            left: 25px !important
        }

        .start-30px {
            left: 30px !important
        }

        .start-35px {
            left: 35px !important
        }

        .start-40px {
            left: 40px !important
        }

        .start-45px {
            left: 45px !important
        }

        .start-50px {
            left: 50px !important
        }

        .start-55px {
            left: 55px !important
        }

        .start-60px {
            left: 60px !important
        }

        .start-65px {
            left: 65px !important
        }

        .start-70px {
            left: 70px !important
        }

        .start-75px {
            left: 75px !important
        }

        .start-80px {
            left: 80px !important
        }

        .start-85px {
            left: 85px !important
        }

        .start-90px {
            left: 90px !important
        }

        .start-95px {
            left: 95px !important
        }

        .start-100px {
            left: 100px !important
        }

        .start-125px {
            left: 125px !important
        }

        .start-150px {
            left: 150px !important
        }

        .start-175px {
            left: 175px !important
        }

        .start-200px {
            left: 200px !important
        }

        .start-225px {
            left: 225px !important
        }

        .start-250px {
            left: 250px !important
        }

        .start-275px {
            left: 275px !important
        }

        .start-300px {
            left: 300px !important
        }

        .start-325px {
            left: 325px !important
        }

        .start-350px {
            left: 350px !important
        }

        .start-375px {
            left: 375px !important
        }

        .start-400px {
            left: 400px !important
        }

        .start-425px {
            left: 425px !important
        }

        .start-450px {
            left: 450px !important
        }

        .start-475px {
            left: 475px !important
        }

        .start-500px {
            left: 500px !important
        }

        .start-550px {
            left: 550px !important
        }

        .start-600px {
            left: 600px !important
        }

        .start-650px {
            left: 650px !important
        }

        .start-700px {
            left: 700px !important
        }

        .start-750px {
            left: 750px !important
        }

        .start-800px {
            left: 800px !important
        }

        .start-850px {
            left: 850px !important
        }

        .start-900px {
            left: 900px !important
        }

        .start-950px {
            left: 950px !important
        }

        .start-1000px {
            left: 1000px !important
        }

        .end-0 {
            right: 0 !important
        }

        .end-25 {
            right: 25% !important
        }

        .end-50 {
            right: 50% !important
        }

        .end-75 {
            right: 75% !important
        }

        .end-100 {
            right: 100% !important
        }

        .end-auto {
            right: auto !important
        }

        .end-1px {
            right: 1px !important
        }

        .end-2px {
            right: 2px !important
        }

        .end-3px {
            right: 3px !important
        }

        .end-4px {
            right: 4px !important
        }

        .end-5px {
            right: 5px !important
        }

        .end-6px {
            right: 6px !important
        }

        .end-7px {
            right: 7px !important
        }

        .end-8px {
            right: 8px !important
        }

        .end-9px {
            right: 9px !important
        }

        .end-10px {
            right: 10px !important
        }

        .end-15px {
            right: 15px !important
        }

        .end-20px {
            right: 20px !important
        }

        .end-25px {
            right: 25px !important
        }

        .end-30px {
            right: 30px !important
        }

        .end-35px {
            right: 35px !important
        }

        .end-40px {
            right: 40px !important
        }

        .end-45px {
            right: 45px !important
        }

        .end-50px {
            right: 50px !important
        }

        .end-55px {
            right: 55px !important
        }

        .end-60px {
            right: 60px !important
        }

        .end-65px {
            right: 65px !important
        }

        .end-70px {
            right: 70px !important
        }

        .end-75px {
            right: 75px !important
        }

        .end-80px {
            right: 80px !important
        }

        .end-85px {
            right: 85px !important
        }

        .end-90px {
            right: 90px !important
        }

        .end-95px {
            right: 95px !important
        }

        .end-100px {
            right: 100px !important
        }

        .end-125px {
            right: 125px !important
        }

        .end-150px {
            right: 150px !important
        }

        .end-175px {
            right: 175px !important
        }

        .end-200px {
            right: 200px !important
        }

        .end-225px {
            right: 225px !important
        }

        .end-250px {
            right: 250px !important
        }

        .end-275px {
            right: 275px !important
        }

        .end-300px {
            right: 300px !important
        }

        .end-325px {
            right: 325px !important
        }

        .end-350px {
            right: 350px !important
        }

        .end-375px {
            right: 375px !important
        }

        .end-400px {
            right: 400px !important
        }

        .end-425px {
            right: 425px !important
        }

        .end-450px {
            right: 450px !important
        }

        .end-475px {
            right: 475px !important
        }

        .end-500px {
            right: 500px !important
        }

        .end-550px {
            right: 550px !important
        }

        .end-600px {
            right: 600px !important
        }

        .end-650px {
            right: 650px !important
        }

        .end-700px {
            right: 700px !important
        }

        .end-750px {
            right: 750px !important
        }

        .end-800px {
            right: 800px !important
        }

        .end-850px {
            right: 850px !important
        }

        .end-900px {
            right: 900px !important
        }

        .end-950px {
            right: 950px !important
        }

        .end-1000px {
            right: 1000px !important
        }

        .translate-middle {
            transform: translate(-50%, -50%) !important
        }

        .translate-middle-x {
            transform: translateX(-50%) !important
        }

        .translate-middle-y {
            transform: translateY(-50%) !important
        }

        .border {
            border: var(--bs-border-width) var(--bs-border-style) var(--bs-border-color) !important
        }

        .border-0 {
            border: 0 !important
        }

        .border-top {
            border-top: var(--bs-border-width) var(--bs-border-style) var(--bs-border-color) !important
        }

        .border-top-0 {
            border-top: 0 !important
        }

        .border-end {
            border-right: var(--bs-border-width) var(--bs-border-style) var(--bs-border-color) !important
        }

        .border-end-0 {
            border-right: 0 !important
        }

        .border-bottom {
            border-bottom: var(--bs-border-width) var(--bs-border-style) var(--bs-border-color) !important
        }

        .border-bottom-0 {
            border-bottom: 0 !important
        }

        .border-start {
            border-left: var(--bs-border-width) var(--bs-border-style) var(--bs-border-color) !important
        }

        .border-start-0 {
            border-left: 0 !important
        }

        .border-primary {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-primary-rgb), var(--bs-border-opacity)) !important
        }

        .border-secondary {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-secondary-rgb), var(--bs-border-opacity)) !important
        }

        .border-success {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-success-rgb), var(--bs-border-opacity)) !important
        }

        .border-info {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-info-rgb), var(--bs-border-opacity)) !important
        }

        .border-warning {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-warning-rgb), var(--bs-border-opacity)) !important
        }

        .border-danger {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-danger-rgb), var(--bs-border-opacity)) !important
        }

        .border-light {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-light-rgb), var(--bs-border-opacity)) !important
        }

        .border-dark {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-dark-rgb), var(--bs-border-opacity)) !important
        }

        .border-light-green {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-light-green-rgb), var(--bs-border-opacity)) !important
        }

        .border-white {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-white-rgb), var(--bs-border-opacity)) !important
        }

        .border-black {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-black-rgb), var(--bs-border-opacity)) !important
        }

        .border-blue {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-blue-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-100 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-100-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-200 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-200-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-300 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-300-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-400 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-400-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-500 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-500-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-600 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-600-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-700 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-700-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-800 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-800-rgb), var(--bs-border-opacity)) !important
        }

        .border-gray-900 {
            --bs-border-opacity: 1;
            border-color: rgba(var(--bs-gray-900-rgb), var(--bs-border-opacity)) !important
        }

        .border-1 {
            --bs-border-width: 1px
        }

        .border-2 {
            --bs-border-width: 2px
        }

        .border-3 {
            --bs-border-width: 3px
        }

        .border-4 {
            --bs-border-width: 4px
        }

        .border-5 {
            --bs-border-width: 5px
        }

        .border-opacity-10 {
            --bs-border-opacity: 0.1
        }

        .border-opacity-25 {
            --bs-border-opacity: 0.25
        }

        .border-opacity-50 {
            --bs-border-opacity: 0.5
        }

        .border-opacity-75 {
            --bs-border-opacity: 0.75
        }

        .border-opacity-100 {
            --bs-border-opacity: 1
        }

        .w-unset {
            width: unset !important
        }

        .w-25 {
            width: 25% !important
        }

        .w-50 {
            width: 50% !important
        }

        .w-75 {
            width: 75% !important
        }

        .w-100 {
            width: 100% !important
        }

        .w-auto {
            width: auto !important
        }

        .w-1px {
            width: 1px !important
        }

        .w-2px {
            width: 2px !important
        }

        .w-3px {
            width: 3px !important
        }

        .w-4px {
            width: 4px !important
        }

        .w-5px {
            width: 5px !important
        }

        .w-6px {
            width: 6px !important
        }

        .w-7px {
            width: 7px !important
        }

        .w-8px {
            width: 8px !important
        }

        .w-9px {
            width: 9px !important
        }

        .w-10px {
            width: 10px !important
        }

        .w-15px {
            width: 15px !important
        }

        .w-20px {
            width: 20px !important
        }

        .w-25px {
            width: 25px !important
        }

        .w-30px {
            width: 30px !important
        }

        .w-35px {
            width: 35px !important
        }

        .w-40px {
            width: 40px !important
        }

        .w-45px {
            width: 45px !important
        }

        .w-50px {
            width: 50px !important
        }

        .w-55px {
            width: 55px !important
        }

        .w-60px {
            width: 60px !important
        }

        .w-65px {
            width: 65px !important
        }

        .w-70px {
            width: 70px !important
        }

        .w-75px {
            width: 75px !important
        }

        .w-80px {
            width: 80px !important
        }

        .w-85px {
            width: 85px !important
        }

        .w-90px {
            width: 90px !important
        }

        .w-95px {
            width: 95px !important
        }

        .w-100px {
            width: 100px !important
        }

        .w-125px {
            width: 125px !important
        }

        .w-150px {
            width: 150px !important
        }

        .w-175px {
            width: 175px !important
        }

        .w-200px {
            width: 200px !important
        }

        .w-225px {
            width: 225px !important
        }

        .w-250px {
            width: 250px !important
        }

        .w-275px {
            width: 275px !important
        }

        .w-300px {
            width: 300px !important
        }

        .w-325px {
            width: 325px !important
        }

        .w-350px {
            width: 350px !important
        }

        .w-375px {
            width: 375px !important
        }

        .w-400px {
            width: 400px !important
        }

        .w-425px {
            width: 425px !important
        }

        .w-450px {
            width: 450px !important
        }

        .w-475px {
            width: 475px !important
        }

        .w-500px {
            width: 500px !important
        }

        .w-550px {
            width: 550px !important
        }

        .w-600px {
            width: 600px !important
        }

        .w-650px {
            width: 650px !important
        }

        .w-700px {
            width: 700px !important
        }

        .w-750px {
            width: 750px !important
        }

        .w-800px {
            width: 800px !important
        }

        .w-850px {
            width: 850px !important
        }

        .w-900px {
            width: 900px !important
        }

        .w-950px {
            width: 950px !important
        }

        .w-1000px {
            width: 1000px !important
        }

        .mw-unset {
            max-width: unset !important
        }

        .mw-25 {
            max-width: 25% !important
        }

        .mw-50 {
            max-width: 50% !important
        }

        .mw-75 {
            max-width: 75% !important
        }

        .mw-100 {
            max-width: 100% !important
        }

        .mw-auto {
            max-width: auto !important
        }

        .mw-1px {
            max-width: 1px !important
        }

        .mw-2px {
            max-width: 2px !important
        }

        .mw-3px {
            max-width: 3px !important
        }

        .mw-4px {
            max-width: 4px !important
        }

        .mw-5px {
            max-width: 5px !important
        }

        .mw-6px {
            max-width: 6px !important
        }

        .mw-7px {
            max-width: 7px !important
        }

        .mw-8px {
            max-width: 8px !important
        }

        .mw-9px {
            max-width: 9px !important
        }

        .mw-10px {
            max-width: 10px !important
        }

        .mw-15px {
            max-width: 15px !important
        }

        .mw-20px {
            max-width: 20px !important
        }

        .mw-25px {
            max-width: 25px !important
        }

        .mw-30px {
            max-width: 30px !important
        }

        .mw-35px {
            max-width: 35px !important
        }

        .mw-40px {
            max-width: 40px !important
        }

        .mw-45px {
            max-width: 45px !important
        }

        .mw-50px {
            max-width: 50px !important
        }

        .mw-55px {
            max-width: 55px !important
        }

        .mw-60px {
            max-width: 60px !important
        }

        .mw-65px {
            max-width: 65px !important
        }

        .mw-70px {
            max-width: 70px !important
        }

        .mw-75px {
            max-width: 75px !important
        }

        .mw-80px {
            max-width: 80px !important
        }

        .mw-85px {
            max-width: 85px !important
        }

        .mw-90px {
            max-width: 90px !important
        }

        .mw-95px {
            max-width: 95px !important
        }

        .mw-100px {
            max-width: 100px !important
        }

        .mw-125px {
            max-width: 125px !important
        }

        .mw-150px {
            max-width: 150px !important
        }

        .mw-175px {
            max-width: 175px !important
        }

        .mw-200px {
            max-width: 200px !important
        }

        .mw-225px {
            max-width: 225px !important
        }

        .mw-250px {
            max-width: 250px !important
        }

        .mw-275px {
            max-width: 275px !important
        }

        .mw-300px {
            max-width: 300px !important
        }

        .mw-325px {
            max-width: 325px !important
        }

        .mw-350px {
            max-width: 350px !important
        }

        .mw-375px {
            max-width: 375px !important
        }

        .mw-400px {
            max-width: 400px !important
        }

        .mw-425px {
            max-width: 425px !important
        }

        .mw-450px {
            max-width: 450px !important
        }

        .mw-475px {
            max-width: 475px !important
        }

        .mw-500px {
            max-width: 500px !important
        }

        .mw-550px {
            max-width: 550px !important
        }

        .mw-600px {
            max-width: 600px !important
        }

        .mw-650px {
            max-width: 650px !important
        }

        .mw-700px {
            max-width: 700px !important
        }

        .mw-750px {
            max-width: 750px !important
        }

        .mw-800px {
            max-width: 800px !important
        }

        .mw-850px {
            max-width: 850px !important
        }

        .mw-900px {
            max-width: 900px !important
        }

        .mw-950px {
            max-width: 950px !important
        }

        .mw-1000px {
            max-width: 1000px !important
        }

        .vw-25 {
            width: 25vw !important
        }

        .vw-50 {
            width: 50vw !important
        }

        .vw-75 {
            width: 75vw !important
        }

        .vw-100 {
            width: 100vw !important
        }

        .vw-auto {
            width: auto !important
        }

        .min-vw-25 {
            min-width: 25vw !important
        }

        .min-vw-50 {
            min-width: 50vw !important
        }

        .min-vw-75 {
            min-width: 75vw !important
        }

        .min-vw-100 {
            min-width: 100vw !important
        }

        .min-vw-auto {
            min-width: auto !important
        }

        .h-unset {
            height: unset !important
        }

        .h-25 {
            height: 25% !important
        }

        .h-50 {
            height: 50% !important
        }

        .h-75 {
            height: 75% !important
        }

        .h-100 {
            height: 100% !important
        }

        .h-auto {
            height: auto !important
        }

        .h-1px {
            height: 1px !important
        }

        .h-2px {
            height: 2px !important
        }

        .h-3px {
            height: 3px !important
        }

        .h-4px {
            height: 4px !important
        }

        .h-5px {
            height: 5px !important
        }

        .h-6px {
            height: 6px !important
        }

        .h-7px {
            height: 7px !important
        }

        .h-8px {
            height: 8px !important
        }

        .h-9px {
            height: 9px !important
        }

        .h-10px {
            height: 10px !important
        }

        .h-15px {
            height: 15px !important
        }

        .h-20px {
            height: 20px !important
        }

        .h-25px {
            height: 25px !important
        }

        .h-30px {
            height: 30px !important
        }

        .h-35px {
            height: 35px !important
        }

        .h-40px {
            height: 40px !important
        }

        .h-45px {
            height: 45px !important
        }

        .h-50px {
            height: 50px !important
        }

        .h-55px {
            height: 55px !important
        }

        .h-60px {
            height: 60px !important
        }

        .h-65px {
            height: 65px !important
        }

        .h-70px {
            height: 70px !important
        }

        .h-75px {
            height: 75px !important
        }

        .h-80px {
            height: 80px !important
        }

        .h-85px {
            height: 85px !important
        }

        .h-90px {
            height: 90px !important
        }

        .h-95px {
            height: 95px !important
        }

        .h-100px {
            height: 100px !important
        }

        .h-125px {
            height: 125px !important
        }

        .h-150px {
            height: 150px !important
        }

        .h-175px {
            height: 175px !important
        }

        .h-200px {
            height: 200px !important
        }

        .h-225px {
            height: 225px !important
        }

        .h-250px {
            height: 250px !important
        }

        .h-275px {
            height: 275px !important
        }

        .h-300px {
            height: 300px !important
        }

        .h-325px {
            height: 325px !important
        }

        .h-350px {
            height: 350px !important
        }

        .h-375px {
            height: 375px !important
        }

        .h-400px {
            height: 400px !important
        }

        .h-425px {
            height: 425px !important
        }

        .h-450px {
            height: 450px !important
        }

        .h-475px {
            height: 475px !important
        }

        .h-500px {
            height: 500px !important
        }

        .h-550px {
            height: 550px !important
        }

        .h-600px {
            height: 600px !important
        }

        .h-650px {
            height: 650px !important
        }

        .h-700px {
            height: 700px !important
        }

        .h-750px {
            height: 750px !important
        }

        .h-800px {
            height: 800px !important
        }

        .h-850px {
            height: 850px !important
        }

        .h-900px {
            height: 900px !important
        }

        .h-950px {
            height: 950px !important
        }

        .h-1000px {
            height: 1000px !important
        }

        .mh-unset {
            max-height: unset !important
        }

        .mh-25 {
            max-height: 25% !important
        }

        .mh-50 {
            max-height: 50% !important
        }

        .mh-75 {
            max-height: 75% !important
        }

        .mh-100 {
            max-height: 100% !important
        }

        .mh-auto {
            max-height: auto !important
        }

        .mh-1px {
            max-height: 1px !important
        }

        .mh-2px {
            max-height: 2px !important
        }

        .mh-3px {
            max-height: 3px !important
        }

        .mh-4px {
            max-height: 4px !important
        }

        .mh-5px {
            max-height: 5px !important
        }

        .mh-6px {
            max-height: 6px !important
        }

        .mh-7px {
            max-height: 7px !important
        }

        .mh-8px {
            max-height: 8px !important
        }

        .mh-9px {
            max-height: 9px !important
        }

        .mh-10px {
            max-height: 10px !important
        }

        .mh-15px {
            max-height: 15px !important
        }

        .mh-20px {
            max-height: 20px !important
        }

        .mh-25px {
            max-height: 25px !important
        }

        .mh-30px {
            max-height: 30px !important
        }

        .mh-35px {
            max-height: 35px !important
        }

        .mh-40px {
            max-height: 40px !important
        }

        .mh-45px {
            max-height: 45px !important
        }

        .mh-50px {
            max-height: 50px !important
        }

        .mh-55px {
            max-height: 55px !important
        }

        .mh-60px {
            max-height: 60px !important
        }

        .mh-65px {
            max-height: 65px !important
        }

        .mh-70px {
            max-height: 70px !important
        }

        .mh-75px {
            max-height: 75px !important
        }

        .mh-80px {
            max-height: 80px !important
        }

        .mh-85px {
            max-height: 85px !important
        }

        .mh-90px {
            max-height: 90px !important
        }

        .mh-95px {
            max-height: 95px !important
        }

        .mh-100px {
            max-height: 100px !important
        }

        .mh-125px {
            max-height: 125px !important
        }

        .mh-150px {
            max-height: 150px !important
        }

        .mh-175px {
            max-height: 175px !important
        }

        .mh-200px {
            max-height: 200px !important
        }

        .mh-225px {
            max-height: 225px !important
        }

        .mh-250px {
            max-height: 250px !important
        }

        .mh-275px {
            max-height: 275px !important
        }

        .mh-300px {
            max-height: 300px !important
        }

        .mh-325px {
            max-height: 325px !important
        }

        .mh-350px {
            max-height: 350px !important
        }

        .mh-375px {
            max-height: 375px !important
        }

        .mh-400px {
            max-height: 400px !important
        }

        .mh-425px {
            max-height: 425px !important
        }

        .mh-450px {
            max-height: 450px !important
        }

        .mh-475px {
            max-height: 475px !important
        }

        .mh-500px {
            max-height: 500px !important
        }

        .mh-550px {
            max-height: 550px !important
        }

        .mh-600px {
            max-height: 600px !important
        }

        .mh-650px {
            max-height: 650px !important
        }

        .mh-700px {
            max-height: 700px !important
        }

        .mh-750px {
            max-height: 750px !important
        }

        .mh-800px {
            max-height: 800px !important
        }

        .mh-850px {
            max-height: 850px !important
        }

        .mh-900px {
            max-height: 900px !important
        }

        .mh-950px {
            max-height: 950px !important
        }

        .mh-1000px {
            max-height: 1000px !important
        }

        .vh-25 {
            height: 25vh !important
        }

        .vh-50 {
            height: 50vh !important
        }

        .vh-75 {
            height: 75vh !important
        }

        .vh-100 {
            height: 100vh !important
        }

        .vh-auto {
            height: auto !important
        }

        .min-vh-25 {
            min-height: 25vh !important
        }

        .min-vh-50 {
            min-height: 50vh !important
        }

        .min-vh-75 {
            min-height: 75vh !important
        }

        .min-vh-100 {
            min-height: 100vh !important
        }

        .min-vh-auto {
            min-height: auto !important
        }

        .flex-fill {
            flex: 1 1 auto !important
        }

        .flex-row {
            flex-direction: row !important
        }

        .flex-column {
            flex-direction: column !important
        }

        .flex-row-reverse {
            flex-direction: row-reverse !important
        }

        .flex-column-reverse {
            flex-direction: column-reverse !important
        }

        .flex-grow-0 {
            flex-grow: 0 !important
        }

        .flex-grow-1 {
            flex-grow: 1 !important
        }

        .flex-shrink-0 {
            flex-shrink: 0 !important
        }

        .flex-shrink-1 {
            flex-shrink: 1 !important
        }

        .flex-wrap {
            flex-wrap: wrap !important
        }

        .flex-nowrap {
            flex-wrap: nowrap !important
        }

        .flex-wrap-reverse {
            flex-wrap: wrap-reverse !important
        }

        .justify-content-start {
            justify-content: flex-start !important
        }

        .justify-content-end {
            justify-content: flex-end !important
        }

        .justify-content-center {
            justify-content: center !important
        }

        .justify-content-between {
            justify-content: space-between !important
        }

        .justify-content-around {
            justify-content: space-around !important
        }

        .justify-content-evenly {
            justify-content: space-evenly !important
        }

        .align-items-start {
            align-items: flex-start !important
        }

        .align-items-end {
            align-items: flex-end !important
        }

        .align-items-center {
            align-items: center !important
        }

        .align-items-baseline {
            align-items: baseline !important
        }

        .align-items-stretch {
            align-items: stretch !important
        }

        .align-content-start {
            align-content: flex-start !important
        }

        .align-content-end {
            align-content: flex-end !important
        }

        .align-content-center {
            align-content: center !important
        }

        .align-content-between {
            align-content: space-between !important
        }

        .align-content-around {
            align-content: space-around !important
        }

        .align-content-stretch {
            align-content: stretch !important
        }

        .align-self-auto {
            align-self: auto !important
        }

        .align-self-start {
            align-self: flex-start !important
        }

        .align-self-end {
            align-self: flex-end !important
        }

        .align-self-center {
            align-self: center !important
        }

        .align-self-baseline {
            align-self: baseline !important
        }

        .align-self-stretch {
            align-self: stretch !important
        }

        .order-first {
            order: -1 !important
        }

        .order-0 {
            order: 0 !important
        }

        .order-1 {
            order: 1 !important
        }

        .order-2 {
            order: 2 !important
        }

        .order-3 {
            order: 3 !important
        }

        .order-4 {
            order: 4 !important
        }

        .order-5 {
            order: 5 !important
        }

        .order-last {
            order: 6 !important
        }

        .m-0 {
            margin: 0 !important
        }

        .m-1 {
            margin: .234375rem !important
        }

        .m-2 {
            margin: .46875rem !important
        }

        .m-3 {
            margin: .624999375rem !important
        }

        .m-4 {
            margin: .9375rem !important
        }

        .m-5 {
            margin: 1.2500000001rem !important
        }

        .m-6 {
            margin: 1.875rem !important
        }

        .m-7 {
            margin: 2.8125rem !important
        }

        .m-8 {
            margin: 3.75rem !important
        }

        .m-9 {
            margin: 5.625rem !important
        }

        .m-10 {
            margin: 8.4375rem !important
        }

        .m-auto {
            margin: auto !important
        }

        .mx-0 {
            margin-left: 0 !important;
            margin-right: 0 !important
        }

        .mx-1 {
            margin-left: .234375rem !important;
            margin-right: .234375rem !important
        }

        .mx-2 {
            margin-left: .46875rem !important;
            margin-right: .46875rem !important
        }

        .mx-3 {
            margin-left: .624999375rem !important;
            margin-right: .624999375rem !important
        }

        .mx-4 {
            margin-left: .9375rem !important;
            margin-right: .9375rem !important
        }

        .mx-5 {
            margin-left: 1.2500000001rem !important;
            margin-right: 1.2500000001rem !important
        }

        .mx-6 {
            margin-left: 1.875rem !important;
            margin-right: 1.875rem !important
        }

        .mx-7 {
            margin-left: 2.8125rem !important;
            margin-right: 2.8125rem !important
        }

        .mx-8 {
            margin-left: 3.75rem !important;
            margin-right: 3.75rem !important
        }

        .mx-9 {
            margin-left: 5.625rem !important;
            margin-right: 5.625rem !important
        }

        .mx-10 {
            margin-left: 8.4375rem !important;
            margin-right: 8.4375rem !important
        }

        .mx-auto {
            margin-left: auto !important;
            margin-right: auto !important
        }

        .my-0 {
            margin-bottom: 0 !important;
            margin-top: 0 !important
        }

        .my-1 {
            margin-bottom: .234375rem !important;
            margin-top: .234375rem !important
        }

        .my-2 {
            margin-bottom: .46875rem !important;
            margin-top: .46875rem !important
        }

        .my-3 {
            margin-bottom: .624999375rem !important;
            margin-top: .624999375rem !important
        }

        .my-4 {
            margin-bottom: .9375rem !important;
            margin-top: .9375rem !important
        }

        .my-5 {
            margin-bottom: 1.2500000001rem !important;
            margin-top: 1.2500000001rem !important
        }

        .my-6 {
            margin-bottom: 1.875rem !important;
            margin-top: 1.875rem !important
        }

        .my-7 {
            margin-bottom: 2.8125rem !important;
            margin-top: 2.8125rem !important
        }

        .my-8 {
            margin-bottom: 3.75rem !important;
            margin-top: 3.75rem !important
        }

        .my-9 {
            margin-bottom: 5.625rem !important;
            margin-top: 5.625rem !important
        }

        .my-10 {
            margin-bottom: 8.4375rem !important;
            margin-top: 8.4375rem !important
        }

        .my-auto {
            margin-bottom: auto !important;
            margin-top: auto !important
        }

        .mt-0 {
            margin-top: 0 !important
        }

        .mt-1 {
            margin-top: .234375rem !important
        }

        .mt-2 {
            margin-top: .46875rem !important
        }

        .mt-3 {
            margin-top: .624999375rem !important
        }

        .mt-4 {
            margin-top: .9375rem !important
        }

        .mt-5 {
            margin-top: 1.2500000001rem !important
        }

        .mt-6 {
            margin-top: 1.875rem !important
        }

        .mt-7 {
            margin-top: 2.8125rem !important
        }

        .mt-8 {
            margin-top: 3.75rem !important
        }

        .mt-9 {
            margin-top: 5.625rem !important
        }

        .mt-10 {
            margin-top: 8.4375rem !important
        }

        .mt-auto {
            margin-top: auto !important
        }

        .me-0 {
            margin-right: 0 !important
        }

        .me-1 {
            margin-right: .234375rem !important
        }

        .me-2 {
            margin-right: .46875rem !important
        }

        .me-3 {
            margin-right: .624999375rem !important
        }

        .me-4 {
            margin-right: .9375rem !important
        }

        .me-5 {
            margin-right: 1.2500000001rem !important
        }

        .me-6 {
            margin-right: 1.875rem !important
        }

        .me-7 {
            margin-right: 2.8125rem !important
        }

        .me-8 {
            margin-right: 3.75rem !important
        }

        .me-9 {
            margin-right: 5.625rem !important
        }

        .me-10 {
            margin-right: 8.4375rem !important
        }

        .me-auto {
            margin-right: auto !important
        }

        .mb-0 {
            margin-bottom: 0 !important
        }

        .mb-1 {
            margin-bottom: .234375rem !important
        }

        .mb-2 {
            margin-bottom: .46875rem !important
        }

        .mb-3 {
            margin-bottom: .624999375rem !important
        }

        .mb-4 {
            margin-bottom: .9375rem !important
        }

        .mb-5 {
            margin-bottom: 1.2500000001rem !important
        }

        .mb-6 {
            margin-bottom: 1.875rem !important
        }

        .mb-7 {
            margin-bottom: 2.8125rem !important
        }

        .mb-8 {
            margin-bottom: 3.75rem !important
        }

        .mb-9 {
            margin-bottom: 5.625rem !important
        }

        .mb-10 {
            margin-bottom: 8.4375rem !important
        }

        .mb-auto {
            margin-bottom: auto !important
        }

        .ms-0 {
            margin-left: 0 !important
        }

        .ms-1 {
            margin-left: .234375rem !important
        }

        .ms-2 {
            margin-left: .46875rem !important
        }

        .ms-3 {
            margin-left: .624999375rem !important
        }

        .ms-4 {
            margin-left: .9375rem !important
        }

        .ms-5 {
            margin-left: 1.2500000001rem !important
        }

        .ms-6 {
            margin-left: 1.875rem !important
        }

        .ms-7 {
            margin-left: 2.8125rem !important
        }

        .ms-8 {
            margin-left: 3.75rem !important
        }

        .ms-9 {
            margin-left: 5.625rem !important
        }

        .ms-10 {
            margin-left: 8.4375rem !important
        }

        .ms-auto {
            margin-left: auto !important
        }

        .m-n1 {
            margin: -.234375rem !important
        }

        .m-n2 {
            margin: -.46875rem !important
        }

        .m-n3 {
            margin: -.624999375rem !important
        }

        .m-n4 {
            margin: -.9375rem !important
        }

        .m-n5 {
            margin: -1.2500000001rem !important
        }

        .m-n6 {
            margin: -1.875rem !important
        }

        .m-n7 {
            margin: -2.8125rem !important
        }

        .m-n8 {
            margin: -3.75rem !important
        }

        .m-n9 {
            margin: -5.625rem !important
        }

        .m-n10 {
            margin: -8.4375rem !important
        }

        .mx-n1 {
            margin-left: -.234375rem !important;
            margin-right: -.234375rem !important
        }

        .mx-n2 {
            margin-left: -.46875rem !important;
            margin-right: -.46875rem !important
        }

        .mx-n3 {
            margin-left: -.624999375rem !important;
            margin-right: -.624999375rem !important
        }

        .mx-n4 {
            margin-left: -.9375rem !important;
            margin-right: -.9375rem !important
        }

        .mx-n5 {
            margin-left: -1.2500000001rem !important;
            margin-right: -1.2500000001rem !important
        }

        .mx-n6 {
            margin-left: -1.875rem !important;
            margin-right: -1.875rem !important
        }

        .mx-n7 {
            margin-left: -2.8125rem !important;
            margin-right: -2.8125rem !important
        }

        .mx-n8 {
            margin-left: -3.75rem !important;
            margin-right: -3.75rem !important
        }

        .mx-n9 {
            margin-left: -5.625rem !important;
            margin-right: -5.625rem !important
        }

        .mx-n10 {
            margin-left: -8.4375rem !important;
            margin-right: -8.4375rem !important
        }

        .my-n1 {
            margin-bottom: -.234375rem !important;
            margin-top: -.234375rem !important
        }

        .my-n2 {
            margin-bottom: -.46875rem !important;
            margin-top: -.46875rem !important
        }

        .my-n3 {
            margin-bottom: -.624999375rem !important;
            margin-top: -.624999375rem !important
        }

        .my-n4 {
            margin-bottom: -.9375rem !important;
            margin-top: -.9375rem !important
        }

        .my-n5 {
            margin-bottom: -1.2500000001rem !important;
            margin-top: -1.2500000001rem !important
        }

        .my-n6 {
            margin-bottom: -1.875rem !important;
            margin-top: -1.875rem !important
        }

        .my-n7 {
            margin-bottom: -2.8125rem !important;
            margin-top: -2.8125rem !important
        }

        .my-n8 {
            margin-bottom: -3.75rem !important;
            margin-top: -3.75rem !important
        }

        .my-n9 {
            margin-bottom: -5.625rem !important;
            margin-top: -5.625rem !important
        }

        .my-n10 {
            margin-bottom: -8.4375rem !important;
            margin-top: -8.4375rem !important
        }

        .mt-n1 {
            margin-top: -.234375rem !important
        }

        .mt-n2 {
            margin-top: -.46875rem !important
        }

        .mt-n3 {
            margin-top: -.624999375rem !important
        }

        .mt-n4 {
            margin-top: -.9375rem !important
        }

        .mt-n5 {
            margin-top: -1.2500000001rem !important
        }

        .mt-n6 {
            margin-top: -1.875rem !important
        }

        .mt-n7 {
            margin-top: -2.8125rem !important
        }

        .mt-n8 {
            margin-top: -3.75rem !important
        }

        .mt-n9 {
            margin-top: -5.625rem !important
        }

        .mt-n10 {
            margin-top: -8.4375rem !important
        }

        .me-n1 {
            margin-right: -.234375rem !important
        }

        .me-n2 {
            margin-right: -.46875rem !important
        }

        .me-n3 {
            margin-right: -.624999375rem !important
        }

        .me-n4 {
            margin-right: -.9375rem !important
        }

        .me-n5 {
            margin-right: -1.2500000001rem !important
        }

        .me-n6 {
            margin-right: -1.875rem !important
        }

        .me-n7 {
            margin-right: -2.8125rem !important
        }

        .me-n8 {
            margin-right: -3.75rem !important
        }

        .me-n9 {
            margin-right: -5.625rem !important
        }

        .me-n10 {
            margin-right: -8.4375rem !important
        }

        .mb-n1 {
            margin-bottom: -.234375rem !important
        }

        .mb-n2 {
            margin-bottom: -.46875rem !important
        }

        .mb-n3 {
            margin-bottom: -.624999375rem !important
        }

        .mb-n4 {
            margin-bottom: -.9375rem !important
        }

        .mb-n5 {
            margin-bottom: -1.2500000001rem !important
        }

        .mb-n6 {
            margin-bottom: -1.875rem !important
        }

        .mb-n7 {
            margin-bottom: -2.8125rem !important
        }

        .mb-n8 {
            margin-bottom: -3.75rem !important
        }

        .mb-n9 {
            margin-bottom: -5.625rem !important
        }

        .mb-n10 {
            margin-bottom: -8.4375rem !important
        }

        .ms-n1 {
            margin-left: -.234375rem !important
        }

        .ms-n2 {
            margin-left: -.46875rem !important
        }

        .ms-n3 {
            margin-left: -.624999375rem !important
        }

        .ms-n4 {
            margin-left: -.9375rem !important
        }

        .ms-n5 {
            margin-left: -1.2500000001rem !important
        }

        .ms-n6 {
            margin-left: -1.875rem !important
        }

        .ms-n7 {
            margin-left: -2.8125rem !important
        }

        .ms-n8 {
            margin-left: -3.75rem !important
        }

        .ms-n9 {
            margin-left: -5.625rem !important
        }

        .ms-n10 {
            margin-left: -8.4375rem !important
        }

        .p-0 {
            padding: 0 !important
        }

        .p-1 {
            padding: .234375rem !important
        }

        .p-2 {
            padding: .46875rem !important
        }

        .p-3 {
            padding: .624999375rem !important
        }

        .p-4 {
            padding: .9375rem !important
        }

        .p-5 {
            padding: 1.2500000001rem !important
        }

        .p-6 {
            padding: 1.875rem !important
        }

        .p-7 {
            padding: 2.8125rem !important
        }

        .p-8 {
            padding: 3.75rem !important
        }

        .p-9 {
            padding: 5.625rem !important
        }

        .p-10 {
            padding: 8.4375rem !important
        }

        .px-0 {
            padding-left: 0 !important;
            padding-right: 0 !important
        }

        .px-1 {
            padding-left: .234375rem !important;
            padding-right: .234375rem !important
        }

        .px-2 {
            padding-left: .46875rem !important;
            padding-right: .46875rem !important
        }

        .px-3 {
            padding-left: .624999375rem !important;
            padding-right: .624999375rem !important
        }

        .px-4 {
            padding-left: .9375rem !important;
            padding-right: .9375rem !important
        }

        .px-5 {
            padding-left: 1.2500000001rem !important;
            padding-right: 1.2500000001rem !important
        }

        .px-6 {
            padding-left: 1.875rem !important;
            padding-right: 1.875rem !important
        }

        .px-7 {
            padding-left: 2.8125rem !important;
            padding-right: 2.8125rem !important
        }

        .px-8 {
            padding-left: 3.75rem !important;
            padding-right: 3.75rem !important
        }

        .px-9 {
            padding-left: 5.625rem !important;
            padding-right: 5.625rem !important
        }

        .px-10 {
            padding-left: 8.4375rem !important;
            padding-right: 8.4375rem !important
        }

        .py-0 {
            padding-bottom: 0 !important;
            padding-top: 0 !important
        }

        .py-1 {
            padding-bottom: .234375rem !important;
            padding-top: .234375rem !important
        }

        .py-2 {
            padding-bottom: .46875rem !important;
            padding-top: .46875rem !important
        }

        .py-3 {
            padding-bottom: .624999375rem !important;
            padding-top: .624999375rem !important
        }

        .py-4 {
            padding-bottom: .9375rem !important;
            padding-top: .9375rem !important
        }

        .py-5 {
            padding-bottom: 1.2500000001rem !important;
            padding-top: 1.2500000001rem !important
        }

        .py-6 {
            padding-bottom: 1.875rem !important;
            padding-top: 1.875rem !important
        }

        .py-7 {
            padding-bottom: 2.8125rem !important;
            padding-top: 2.8125rem !important
        }

        .py-8 {
            padding-bottom: 3.75rem !important;
            padding-top: 3.75rem !important
        }

        .py-9 {
            padding-bottom: 5.625rem !important;
            padding-top: 5.625rem !important
        }

        .py-10 {
            padding-bottom: 8.4375rem !important;
            padding-top: 8.4375rem !important
        }

        .pt-0 {
            padding-top: 0 !important
        }

        .pt-1 {
            padding-top: .234375rem !important
        }

        .pt-2 {
            padding-top: .46875rem !important
        }

        .pt-3 {
            padding-top: .624999375rem !important
        }

        .pt-4 {
            padding-top: .9375rem !important
        }

        .pt-5 {
            padding-top: 1.2500000001rem !important
        }

        .pt-6 {
            padding-top: 1.875rem !important
        }

        .pt-7 {
            padding-top: 2.8125rem !important
        }

        .pt-8 {
            padding-top: 3.75rem !important
        }

        .pt-9 {
            padding-top: 5.625rem !important
        }

        .pt-10 {
            padding-top: 8.4375rem !important
        }

        .pe-0 {
            padding-right: 0 !important
        }

        .pe-1 {
            padding-right: .234375rem !important
        }

        .pe-2 {
            padding-right: .46875rem !important
        }

        .pe-3 {
            padding-right: .624999375rem !important
        }

        .pe-4 {
            padding-right: .9375rem !important
        }

        .pe-5 {
            padding-right: 1.2500000001rem !important
        }

        .pe-6 {
            padding-right: 1.875rem !important
        }

        .pe-7 {
            padding-right: 2.8125rem !important
        }

        .pe-8 {
            padding-right: 3.75rem !important
        }

        .pe-9 {
            padding-right: 5.625rem !important
        }

        .pe-10 {
            padding-right: 8.4375rem !important
        }

        .pb-0 {
            padding-bottom: 0 !important
        }

        .pb-1 {
            padding-bottom: .234375rem !important
        }

        .pb-2 {
            padding-bottom: .46875rem !important
        }

        .pb-3 {
            padding-bottom: .624999375rem !important
        }

        .pb-4 {
            padding-bottom: .9375rem !important
        }

        .pb-5 {
            padding-bottom: 1.2500000001rem !important
        }

        .pb-6 {
            padding-bottom: 1.875rem !important
        }

        .pb-7 {
            padding-bottom: 2.8125rem !important
        }

        .pb-8 {
            padding-bottom: 3.75rem !important
        }

        .pb-9 {
            padding-bottom: 5.625rem !important
        }

        .pb-10 {
            padding-bottom: 8.4375rem !important
        }

        .ps-0 {
            padding-left: 0 !important
        }

        .ps-1 {
            padding-left: .234375rem !important
        }

        .ps-2 {
            padding-left: .46875rem !important
        }

        .ps-3 {
            padding-left: .624999375rem !important
        }

        .ps-4 {
            padding-left: .9375rem !important
        }

        .ps-5 {
            padding-left: 1.2500000001rem !important
        }

        .ps-6 {
            padding-left: 1.875rem !important
        }

        .ps-7 {
            padding-left: 2.8125rem !important
        }

        .ps-8 {
            padding-left: 3.75rem !important
        }

        .ps-9 {
            padding-left: 5.625rem !important
        }

        .ps-10 {
            padding-left: 8.4375rem !important
        }

        .gap-0 {
            gap: 0 !important
        }

        .gap-1 {
            gap: .234375rem !important
        }

        .gap-2 {
            gap: .46875rem !important
        }

        .gap-3 {
            gap: .624999375rem !important
        }

        .gap-4 {
            gap: .9375rem !important
        }

        .gap-5 {
            gap: 1.2500000001rem !important
        }

        .gap-6 {
            gap: 1.875rem !important
        }

        .gap-7 {
            gap: 2.8125rem !important
        }

        .gap-8 {
            gap: 3.75rem !important
        }

        .gap-9 {
            gap: 5.625rem !important
        }

        .gap-10 {
            gap: 8.4375rem !important
        }

        .font-monospace {
            font-family: var(--bs-font-monospace) !important
        }

        .fs-1 {
            font-size: calc(1.275rem + .3vw) !important
        }

        .fs-2 {
            font-size: calc(1.2625rem + .15vw) !important
        }

        .fs-3 {
            font-size: 1.125rem !important
        }

        .fs-4 {
            font-size: .875rem !important
        }

        .fs-5 {
            font-size: .75rem !important
        }

        .fs-6 {
            font-size: .625rem !important
        }

        .fst-italic {
            font-style: italic !important
        }

        .fst-normal {
            font-style: normal !important
        }

        .fw-light,
        .fw-lighter {
            font-weight: 300 !important
        }

        .fw-normal {
            font-weight: 400 !important
        }

        .fw-bold {
            font-weight: 700 !important
        }

        .fw-semibold {
            font-weight: 600 !important
        }

        .fw-bolder {
            font-weight: 700 !important
        }

        .lh-1 {
            line-height: 1 !important
        }

        .lh-sm {
            line-height: 1.25 !important
        }

        .lh-base {
            line-height: 1.5 !important
        }

        .lh-lg {
            line-height: 2 !important
        }

        .text-start {
            text-align: left !important
        }

        .text-end {
            text-align: right !important
        }

        .text-center {
            text-align: center !important
        }

        .text-decoration-none {
            text-decoration: none !important
        }

        .text-decoration-underline {
            text-decoration: underline !important
        }

        .text-decoration-line-through {
            text-decoration: line-through !important
        }

        .text-lowercase {
            text-transform: lowercase !important
        }

        .text-uppercase {
            text-transform: uppercase !important
        }

        .text-capitalize {
            text-transform: capitalize !important
        }

        .text-wrap {
            white-space: normal !important
        }

        .text-nowrap {
            white-space: nowrap !important
        }

        .text-break {
            word-wrap: break-word !important;
            word-break: break-word !important
        }

        .text-primary {
            --bs-text-opacity: 1;
            color: {{ $settings->website_theme }} !important
        }

        .text-secondary {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-secondary-rgb), var(--bs-text-opacity)) !important
        }

        .text-success {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-success-rgb), var(--bs-text-opacity)) !important
        }

        .text-info {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-info-rgb), var(--bs-text-opacity)) !important
        }

        .text-warning {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-warning-rgb), var(--bs-text-opacity)) !important
        }

        .text-danger {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-danger-rgb), var(--bs-text-opacity)) !important
        }

        .text-light {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-light-rgb), var(--bs-text-opacity)) !important
        }

        .text-dark {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-dark-rgb), var(--bs-text-opacity)) !important
        }

        .text-light-green {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-light-green-rgb), var(--bs-text-opacity)) !important
        }

        .text-white {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-white-rgb), var(--bs-text-opacity)) !important
        }

        .text-black {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-black-rgb), var(--bs-text-opacity)) !important
        }

        .text-blue {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-blue-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-100 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-100-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-200 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-200-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-300 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-300-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-400 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-400-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-500 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-500-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-600 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-600-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-700 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-700-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-800 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-800-rgb), var(--bs-text-opacity)) !important
        }

        .text-gray-900 {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-gray-900-rgb), var(--bs-text-opacity)) !important
        }

        .text-body {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-body-color-rgb), var(--bs-text-opacity)) !important
        }

        .text-muted {
            --bs-text-opacity: 1;
            color: rgba(var(--bs-body-color-rgb), .3525) !important
        }

        .text-black-50 {
            --bs-text-opacity: 1;
            color: rgba(0, 0, 0, .5) !important
        }

        .text-white-50 {
            --bs-text-opacity: 1;
            color: hsla(0, 0%, 100%, .5) !important
        }

        .text-reset {
            --bs-text-opacity: 1;
            color: inherit !important
        }

        .text-opacity-25 {
            --bs-text-opacity: 0.25
        }

        .text-opacity-50 {
            --bs-text-opacity: 0.5
        }

        .text-opacity-75 {
            --bs-text-opacity: 0.75
        }

        .text-opacity-100 {
            --bs-text-opacity: 1
        }

        .bg-primary {
            --bs-bg-opacity: 1;
            background-color: {{ $settings->website_theme }} !important
        }

        .bg-secondary {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-secondary-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-success {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-success-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-info {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-info-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-warning {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-warning-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-danger {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-danger-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-light {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-light-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-dark {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-dark-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-light-green {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-light-green-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-white {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-black {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-black-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-blue {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-blue-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-100 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-100-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-200 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-200-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-300 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-300-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-400 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-400-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-500 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-500-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-600 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-600-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-700 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-700-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-800 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-800-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-gray-900 {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-gray-900-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-body {
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-body-bg-rgb), var(--bs-bg-opacity)) !important
        }

        .bg-transparent {
            --bs-bg-opacity: 1;
            background-color: transparent !important
        }

        .bg-opacity-10 {
            --bs-bg-opacity: 0.1
        }

        .bg-opacity-25 {
            --bs-bg-opacity: 0.25
        }

        .bg-opacity-50 {
            --bs-bg-opacity: 0.5
        }

        .bg-opacity-75 {
            --bs-bg-opacity: 0.75
        }

        .bg-opacity-100 {
            --bs-bg-opacity: 1
        }

        .bg-gradient {
            background-image: var(--bs-gradient) !important
        }

        .user-select-all {
            -webkit-user-select: all !important;
            -moz-user-select: all !important;
            user-select: all !important
        }

        .user-select-auto {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            user-select: auto !important
        }

        .user-select-none {
            -webkit-user-select: none !important;
            -moz-user-select: none !important;
            user-select: none !important
        }

        .pe-none {
            pointer-events: none !important
        }

        .pe-auto {
            pointer-events: auto !important
        }

        .rounded {
            border-radius: var(--bs-border-radius) !important
        }

        .rounded-0 {
            border-radius: 0 !important
        }

        .rounded-1 {
            border-radius: var(--bs-border-radius-sm) !important
        }

        .rounded-2 {
            border-radius: var(--bs-border-radius) !important
        }

        .rounded-3 {
            border-radius: var(--bs-border-radius-lg) !important
        }

        .rounded-4 {
            border-radius: var(--bs-border-radius-xl) !important
        }

        .rounded-5 {
            border-radius: var(--bs-border-radius-2xl) !important
        }

        .rounded-circle {
            border-radius: 50% !important
        }

        .rounded-pill {
            border-radius: var(--bs-border-radius-pill) !important
        }

        .rounded-top {
            border-top-left-radius: var(--bs-border-radius) !important;
            border-top-right-radius: var(--bs-border-radius) !important
        }

        .rounded-top-0 {
            border-top-left-radius: 0 !important;
            border-top-right-radius: 0 !important
        }

        .rounded-top-1 {
            border-top-left-radius: var(--bs-border-radius-sm) !important;
            border-top-right-radius: var(--bs-border-radius-sm) !important
        }

        .rounded-top-2 {
            border-top-left-radius: var(--bs-border-radius) !important;
            border-top-right-radius: var(--bs-border-radius) !important
        }

        .rounded-top-3 {
            border-top-left-radius: var(--bs-border-radius-lg) !important;
            border-top-right-radius: var(--bs-border-radius-lg) !important
        }

        .rounded-top-4 {
            border-top-left-radius: var(--bs-border-radius-xl) !important;
            border-top-right-radius: var(--bs-border-radius-xl) !important
        }

        .rounded-top-5 {
            border-top-left-radius: var(--bs-border-radius-2xl) !important;
            border-top-right-radius: var(--bs-border-radius-2xl) !important
        }

        .rounded-top-circle {
            border-top-left-radius: 50% !important;
            border-top-right-radius: 50% !important
        }

        .rounded-top-pill {
            border-top-left-radius: var(--bs-border-radius-pill) !important;
            border-top-right-radius: var(--bs-border-radius-pill) !important
        }

        .rounded-end {
            border-bottom-right-radius: var(--bs-border-radius) !important;
            border-top-right-radius: var(--bs-border-radius) !important
        }

        .rounded-end-0 {
            border-bottom-right-radius: 0 !important;
            border-top-right-radius: 0 !important
        }

        .rounded-end-1 {
            border-bottom-right-radius: var(--bs-border-radius-sm) !important;
            border-top-right-radius: var(--bs-border-radius-sm) !important
        }

        .rounded-end-2 {
            border-bottom-right-radius: var(--bs-border-radius) !important;
            border-top-right-radius: var(--bs-border-radius) !important
        }

        .rounded-end-3 {
            border-bottom-right-radius: var(--bs-border-radius-lg) !important;
            border-top-right-radius: var(--bs-border-radius-lg) !important
        }

        .rounded-end-4 {
            border-bottom-right-radius: var(--bs-border-radius-xl) !important;
            border-top-right-radius: var(--bs-border-radius-xl) !important
        }

        .rounded-end-5 {
            border-bottom-right-radius: var(--bs-border-radius-2xl) !important;
            border-top-right-radius: var(--bs-border-radius-2xl) !important
        }

        .rounded-end-circle {
            border-bottom-right-radius: 50% !important;
            border-top-right-radius: 50% !important
        }

        .rounded-end-pill {
            border-bottom-right-radius: var(--bs-border-radius-pill) !important;
            border-top-right-radius: var(--bs-border-radius-pill) !important
        }

        .rounded-bottom {
            border-bottom-left-radius: var(--bs-border-radius) !important;
            border-bottom-right-radius: var(--bs-border-radius) !important
        }

        .rounded-bottom-0 {
            border-bottom-left-radius: 0 !important;
            border-bottom-right-radius: 0 !important
        }

        .rounded-bottom-1 {
            border-bottom-left-radius: var(--bs-border-radius-sm) !important;
            border-bottom-right-radius: var(--bs-border-radius-sm) !important
        }

        .rounded-bottom-2 {
            border-bottom-left-radius: var(--bs-border-radius) !important;
            border-bottom-right-radius: var(--bs-border-radius) !important
        }

        .rounded-bottom-3 {
            border-bottom-left-radius: var(--bs-border-radius-lg) !important;
            border-bottom-right-radius: var(--bs-border-radius-lg) !important
        }

        .rounded-bottom-4 {
            border-bottom-left-radius: var(--bs-border-radius-xl) !important;
            border-bottom-right-radius: var(--bs-border-radius-xl) !important
        }

        .rounded-bottom-5 {
            border-bottom-left-radius: var(--bs-border-radius-2xl) !important;
            border-bottom-right-radius: var(--bs-border-radius-2xl) !important
        }

        .rounded-bottom-circle {
            border-bottom-left-radius: 50% !important;
            border-bottom-right-radius: 50% !important
        }

        .rounded-bottom-pill {
            border-bottom-left-radius: var(--bs-border-radius-pill) !important;
            border-bottom-right-radius: var(--bs-border-radius-pill) !important
        }

        .rounded-start {
            border-bottom-left-radius: var(--bs-border-radius) !important;
            border-top-left-radius: var(--bs-border-radius) !important
        }

        .rounded-start-0 {
            border-bottom-left-radius: 0 !important;
            border-top-left-radius: 0 !important
        }

        .rounded-start-1 {
            border-bottom-left-radius: var(--bs-border-radius-sm) !important;
            border-top-left-radius: var(--bs-border-radius-sm) !important
        }

        .rounded-start-2 {
            border-bottom-left-radius: var(--bs-border-radius) !important;
            border-top-left-radius: var(--bs-border-radius) !important
        }

        .rounded-start-3 {
            border-bottom-left-radius: var(--bs-border-radius-lg) !important;
            border-top-left-radius: var(--bs-border-radius-lg) !important
        }

        .rounded-start-4 {
            border-bottom-left-radius: var(--bs-border-radius-xl) !important;
            border-top-left-radius: var(--bs-border-radius-xl) !important
        }

        .rounded-start-5 {
            border-bottom-left-radius: var(--bs-border-radius-2xl) !important;
            border-top-left-radius: var(--bs-border-radius-2xl) !important
        }

        .rounded-start-circle {
            border-bottom-left-radius: 50% !important;
            border-top-left-radius: 50% !important
        }

        .rounded-start-pill {
            border-bottom-left-radius: var(--bs-border-radius-pill) !important;
            border-top-left-radius: var(--bs-border-radius-pill) !important
        }

        .visible {
            visibility: visible !important
        }

        .invisible {
            visibility: hidden !important
        }

        .min-w-unset {
            min-width: unset !important
        }

        .min-w-25 {
            min-width: 25% !important
        }

        .min-w-50 {
            min-width: 50% !important
        }

        .min-w-75 {
            min-width: 75% !important
        }

        .min-w-100 {
            min-width: 100% !important
        }

        .min-w-auto {
            min-width: auto !important
        }

        .min-w-1px {
            min-width: 1px !important
        }

        .min-w-2px {
            min-width: 2px !important
        }

        .min-w-3px {
            min-width: 3px !important
        }

        .min-w-4px {
            min-width: 4px !important
        }

        .min-w-5px {
            min-width: 5px !important
        }

        .min-w-6px {
            min-width: 6px !important
        }

        .min-w-7px {
            min-width: 7px !important
        }

        .min-w-8px {
            min-width: 8px !important
        }

        .min-w-9px {
            min-width: 9px !important
        }

        .min-w-10px {
            min-width: 10px !important
        }

        .min-w-15px {
            min-width: 15px !important
        }

        .min-w-20px {
            min-width: 20px !important
        }

        .min-w-25px {
            min-width: 25px !important
        }

        .min-w-30px {
            min-width: 30px !important
        }

        .min-w-35px {
            min-width: 35px !important
        }

        .min-w-40px {
            min-width: 40px !important
        }

        .min-w-45px {
            min-width: 45px !important
        }

        .min-w-50px {
            min-width: 50px !important
        }

        .min-w-55px {
            min-width: 55px !important
        }

        .min-w-60px {
            min-width: 60px !important
        }

        .min-w-65px {
            min-width: 65px !important
        }

        .min-w-70px {
            min-width: 70px !important
        }

        .min-w-75px {
            min-width: 75px !important
        }

        .min-w-80px {
            min-width: 80px !important
        }

        .min-w-85px {
            min-width: 85px !important
        }

        .min-w-90px {
            min-width: 90px !important
        }

        .min-w-95px {
            min-width: 95px !important
        }

        .min-w-100px {
            min-width: 100px !important
        }

        .min-w-125px {
            min-width: 125px !important
        }

        .min-w-150px {
            min-width: 150px !important
        }

        .min-w-175px {
            min-width: 175px !important
        }

        .min-w-200px {
            min-width: 200px !important
        }

        .min-w-225px {
            min-width: 225px !important
        }

        .min-w-250px {
            min-width: 250px !important
        }

        .min-w-275px {
            min-width: 275px !important
        }

        .min-w-300px {
            min-width: 300px !important
        }

        .min-w-325px {
            min-width: 325px !important
        }

        .min-w-350px {
            min-width: 350px !important
        }

        .min-w-375px {
            min-width: 375px !important
        }

        .min-w-400px {
            min-width: 400px !important
        }

        .min-w-425px {
            min-width: 425px !important
        }

        .min-w-450px {
            min-width: 450px !important
        }

        .min-w-475px {
            min-width: 475px !important
        }

        .min-w-500px {
            min-width: 500px !important
        }

        .min-w-550px {
            min-width: 550px !important
        }

        .min-w-600px {
            min-width: 600px !important
        }

        .min-w-650px {
            min-width: 650px !important
        }

        .min-w-700px {
            min-width: 700px !important
        }

        .min-w-750px {
            min-width: 750px !important
        }

        .min-w-800px {
            min-width: 800px !important
        }

        .min-w-850px {
            min-width: 850px !important
        }

        .min-w-900px {
            min-width: 900px !important
        }

        .min-w-950px {
            min-width: 950px !important
        }

        .min-w-1000px {
            min-width: 1000px !important
        }

        .min-h-unset {
            min-height: unset !important
        }

        .min-h-25 {
            min-height: 25% !important
        }

        .min-h-50 {
            min-height: 50% !important
        }

        .min-h-75 {
            min-height: 75% !important
        }

        .min-h-100 {
            min-height: 100% !important
        }

        .min-h-auto {
            min-height: auto !important
        }

        .min-h-1px {
            min-height: 1px !important
        }

        .min-h-2px {
            min-height: 2px !important
        }

        .min-h-3px {
            min-height: 3px !important
        }

        .min-h-4px {
            min-height: 4px !important
        }

        .min-h-5px {
            min-height: 5px !important
        }

        .min-h-6px {
            min-height: 6px !important
        }

        .min-h-7px {
            min-height: 7px !important
        }

        .min-h-8px {
            min-height: 8px !important
        }

        .min-h-9px {
            min-height: 9px !important
        }

        .min-h-10px {
            min-height: 10px !important
        }

        .min-h-15px {
            min-height: 15px !important
        }

        .min-h-20px {
            min-height: 20px !important
        }

        .min-h-25px {
            min-height: 25px !important
        }

        .min-h-30px {
            min-height: 30px !important
        }

        .min-h-35px {
            min-height: 35px !important
        }

        .min-h-40px {
            min-height: 40px !important
        }

        .min-h-45px {
            min-height: 45px !important
        }

        .min-h-50px {
            min-height: 50px !important
        }

        .min-h-55px {
            min-height: 55px !important
        }

        .min-h-60px {
            min-height: 60px !important
        }

        .min-h-65px {
            min-height: 65px !important
        }

        .min-h-70px {
            min-height: 70px !important
        }

        .min-h-75px {
            min-height: 75px !important
        }

        .min-h-80px {
            min-height: 80px !important
        }

        .min-h-85px {
            min-height: 85px !important
        }

        .min-h-90px {
            min-height: 90px !important
        }

        .min-h-95px {
            min-height: 95px !important
        }

        .min-h-100px {
            min-height: 100px !important
        }

        .min-h-125px {
            min-height: 125px !important
        }

        .min-h-150px {
            min-height: 150px !important
        }

        .min-h-175px {
            min-height: 175px !important
        }

        .min-h-200px {
            min-height: 200px !important
        }

        .min-h-225px {
            min-height: 225px !important
        }

        .min-h-250px {
            min-height: 250px !important
        }

        .min-h-275px {
            min-height: 275px !important
        }

        .min-h-300px {
            min-height: 300px !important
        }

        .min-h-325px {
            min-height: 325px !important
        }

        .min-h-350px {
            min-height: 350px !important
        }

        .min-h-375px {
            min-height: 375px !important
        }

        .min-h-400px {
            min-height: 400px !important
        }

        .min-h-425px {
            min-height: 425px !important
        }

        .min-h-450px {
            min-height: 450px !important
        }

        .min-h-475px {
            min-height: 475px !important
        }

        .min-h-500px {
            min-height: 500px !important
        }

        .min-h-550px {
            min-height: 550px !important
        }

        .min-h-600px {
            min-height: 600px !important
        }

        .min-h-650px {
            min-height: 650px !important
        }

        .min-h-700px {
            min-height: 700px !important
        }

        .min-h-750px {
            min-height: 750px !important
        }

        .min-h-800px {
            min-height: 800px !important
        }

        .min-h-850px {
            min-height: 850px !important
        }

        .min-h-900px {
            min-height: 900px !important
        }

        .min-h-950px {
            min-height: 950px !important
        }

        .min-h-1000px {
            min-height: 1000px !important
        }

        .scroll-m-0 {
            scroll-margin: 0 !important
        }

        .scroll-m-1 {
            scroll-margin: .234375rem !important
        }

        .scroll-m-2 {
            scroll-margin: .46875rem !important
        }

        .scroll-m-3 {
            scroll-margin: .624999375rem !important
        }

        .scroll-m-4 {
            scroll-margin: .9375rem !important
        }

        .scroll-m-5 {
            scroll-margin: 1.2500000001rem !important
        }

        .scroll-m-6 {
            scroll-margin: 1.875rem !important
        }

        .scroll-m-7 {
            scroll-margin: 2.8125rem !important
        }

        .scroll-m-8 {
            scroll-margin: 3.75rem !important
        }

        .scroll-m-9 {
            scroll-margin: 5.625rem !important
        }

        .scroll-m-10 {
            scroll-margin: 8.4375rem !important
        }

        .scroll-m-auto {
            scroll-margin: auto !important
        }

        .scroll-mx-0 {
            scroll-margin-left: 0 !important;
            scroll-margin-right: 0 !important
        }

        .scroll-mx-1 {
            scroll-margin-left: .234375rem !important;
            scroll-margin-right: .234375rem !important
        }

        .scroll-mx-2 {
            scroll-margin-left: .46875rem !important;
            scroll-margin-right: .46875rem !important
        }

        .scroll-mx-3 {
            scroll-margin-left: .624999375rem !important;
            scroll-margin-right: .624999375rem !important
        }

        .scroll-mx-4 {
            scroll-margin-left: .9375rem !important;
            scroll-margin-right: .9375rem !important
        }

        .scroll-mx-5 {
            scroll-margin-left: 1.2500000001rem !important;
            scroll-margin-right: 1.2500000001rem !important
        }

        .scroll-mx-6 {
            scroll-margin-left: 1.875rem !important;
            scroll-margin-right: 1.875rem !important
        }

        .scroll-mx-7 {
            scroll-margin-left: 2.8125rem !important;
            scroll-margin-right: 2.8125rem !important
        }

        .scroll-mx-8 {
            scroll-margin-left: 3.75rem !important;
            scroll-margin-right: 3.75rem !important
        }

        .scroll-mx-9 {
            scroll-margin-left: 5.625rem !important;
            scroll-margin-right: 5.625rem !important
        }

        .scroll-mx-10 {
            scroll-margin-left: 8.4375rem !important;
            scroll-margin-right: 8.4375rem !important
        }

        .scroll-mx-auto {
            scroll-margin-left: auto !important;
            scroll-margin-right: auto !important
        }

        .scroll-my-0 {
            scroll-margin-bottom: 0 !important;
            scroll-margin-top: 0 !important
        }

        .scroll-my-1 {
            scroll-margin-bottom: .234375rem !important;
            scroll-margin-top: .234375rem !important
        }

        .scroll-my-2 {
            scroll-margin-bottom: .46875rem !important;
            scroll-margin-top: .46875rem !important
        }

        .scroll-my-3 {
            scroll-margin-bottom: .624999375rem !important;
            scroll-margin-top: .624999375rem !important
        }

        .scroll-my-4 {
            scroll-margin-bottom: .9375rem !important;
            scroll-margin-top: .9375rem !important
        }

        .scroll-my-5 {
            scroll-margin-bottom: 1.2500000001rem !important;
            scroll-margin-top: 1.2500000001rem !important
        }

        .scroll-my-6 {
            scroll-margin-bottom: 1.875rem !important;
            scroll-margin-top: 1.875rem !important
        }

        .scroll-my-7 {
            scroll-margin-bottom: 2.8125rem !important;
            scroll-margin-top: 2.8125rem !important
        }

        .scroll-my-8 {
            scroll-margin-bottom: 3.75rem !important;
            scroll-margin-top: 3.75rem !important
        }

        .scroll-my-9 {
            scroll-margin-bottom: 5.625rem !important;
            scroll-margin-top: 5.625rem !important
        }

        .scroll-my-10 {
            scroll-margin-bottom: 8.4375rem !important;
            scroll-margin-top: 8.4375rem !important
        }

        .scroll-my-auto {
            scroll-margin-bottom: auto !important;
            scroll-margin-top: auto !important
        }

        .scroll-mt-0 {
            scroll-margin-top: 0 !important
        }

        .scroll-mt-1 {
            scroll-margin-top: .234375rem !important
        }

        .scroll-mt-2 {
            scroll-margin-top: .46875rem !important
        }

        .scroll-mt-3 {
            scroll-margin-top: .624999375rem !important
        }

        .scroll-mt-4 {
            scroll-margin-top: .9375rem !important
        }

        .scroll-mt-5 {
            scroll-margin-top: 1.2500000001rem !important
        }

        .scroll-mt-6 {
            scroll-margin-top: 1.875rem !important
        }

        .scroll-mt-7 {
            scroll-margin-top: 2.8125rem !important
        }

        .scroll-mt-8 {
            scroll-margin-top: 3.75rem !important
        }

        .scroll-mt-9 {
            scroll-margin-top: 5.625rem !important
        }

        .scroll-mt-10 {
            scroll-margin-top: 8.4375rem !important
        }

        .scroll-mt-auto {
            scroll-margin-top: auto !important
        }

        .scroll-me-0 {
            scroll-margin-right: 0 !important
        }

        .scroll-me-1 {
            scroll-margin-right: .234375rem !important
        }

        .scroll-me-2 {
            scroll-margin-right: .46875rem !important
        }

        .scroll-me-3 {
            scroll-margin-right: .624999375rem !important
        }

        .scroll-me-4 {
            scroll-margin-right: .9375rem !important
        }

        .scroll-me-5 {
            scroll-margin-right: 1.2500000001rem !important
        }

        .scroll-me-6 {
            scroll-margin-right: 1.875rem !important
        }

        .scroll-me-7 {
            scroll-margin-right: 2.8125rem !important
        }

        .scroll-me-8 {
            scroll-margin-right: 3.75rem !important
        }

        .scroll-me-9 {
            scroll-margin-right: 5.625rem !important
        }

        .scroll-me-10 {
            scroll-margin-right: 8.4375rem !important
        }

        .scroll-me-auto {
            scroll-margin-right: auto !important
        }

        .scroll-mb-0 {
            scroll-margin-bottom: 0 !important
        }

        .scroll-mb-1 {
            scroll-margin-bottom: .234375rem !important
        }

        .scroll-mb-2 {
            scroll-margin-bottom: .46875rem !important
        }

        .scroll-mb-3 {
            scroll-margin-bottom: .624999375rem !important
        }

        .scroll-mb-4 {
            scroll-margin-bottom: .9375rem !important
        }

        .scroll-mb-5 {
            scroll-margin-bottom: 1.2500000001rem !important
        }

        .scroll-mb-6 {
            scroll-margin-bottom: 1.875rem !important
        }

        .scroll-mb-7 {
            scroll-margin-bottom: 2.8125rem !important
        }

        .scroll-mb-8 {
            scroll-margin-bottom: 3.75rem !important
        }

        .scroll-mb-9 {
            scroll-margin-bottom: 5.625rem !important
        }

        .scroll-mb-10 {
            scroll-margin-bottom: 8.4375rem !important
        }

        .scroll-mb-auto {
            scroll-margin-bottom: auto !important
        }

        .scroll-ms-0 {
            scroll-margin-left: 0 !important
        }

        .scroll-ms-1 {
            scroll-margin-left: .234375rem !important
        }

        .scroll-ms-2 {
            scroll-margin-left: .46875rem !important
        }

        .scroll-ms-3 {
            scroll-margin-left: .624999375rem !important
        }

        .scroll-ms-4 {
            scroll-margin-left: .9375rem !important
        }

        .scroll-ms-5 {
            scroll-margin-left: 1.2500000001rem !important
        }

        .scroll-ms-6 {
            scroll-margin-left: 1.875rem !important
        }

        .scroll-ms-7 {
            scroll-margin-left: 2.8125rem !important
        }

        .scroll-ms-8 {
            scroll-margin-left: 3.75rem !important
        }

        .scroll-ms-9 {
            scroll-margin-left: 5.625rem !important
        }

        .scroll-ms-10 {
            scroll-margin-left: 8.4375rem !important
        }

        .scroll-ms-auto {
            scroll-margin-left: auto !important
        }

        .z-index-n1 {
            z-index: -1 !important
        }

        .z-index-0 {
            z-index: 0 !important
        }

        .z-index-10 {
            z-index: 10 !important
        }

        .z-index-100 {
            z-index: 100 !important
        }

        .z-index-1000 {
            z-index: 1000 !important
        }

        .z-index-10000 {
            z-index: 10000 !important
        }

        .bg-size-initial {
            background-size: initial !important
        }

        .bg-size-auto {
            background-size: auto !important
        }

        .bg-size-contain {
            background-size: contain !important
        }

        .bg-size-cover {
            background-size: cover !important
        }

        .bg-repeat-initial,
        .bg-repeat-repeat {
            background-repeat: repeat !important
        }

        .bg-repeat-no-repeat {
            background-repeat: no-repeat !important
        }

        .bg-repeat-repeat-x {
            background-repeat: repeat-x !important
        }

        .bg-repeat-repeat-y {
            background-repeat: repeat-y !important
        }

        .bg-position-top {
            background-position: top !important
        }

        .bg-position-right {
            background-position: 100% !important
        }

        .bg-position-bottom {
            background-position: bottom !important
        }

        .bg-position-left {
            background-position: 0 !important
        }

        .bg-position-center {
            background-position: 50% !important
        }

        .ft-blur-1px {
            filter: blur(1px) !important
        }

        .ft-blur-2px {
            filter: blur(2px) !important
        }

        .ft-blur-3px {
            filter: blur(3px) !important
        }

        .ft-blur-4px {
            filter: blur(4px) !important
        }

        .ft-blur-5px {
            filter: blur(5px) !important
        }

        .ft-grayscale-0 {
            filter: grayscale(0) !important
        }

        .ft-grayscale-25 {
            filter: grayscale(25%) !important
        }

        .ft-grayscale-50 {
            filter: grayscale(50%) !important
        }

        .ft-grayscale-75 {
            filter: grayscale(75%) !important
        }

        .ft-grayscale-100 {
            filter: grayscale(100%) !important
        }

        .ft-none {
            filter: none !important
        }

        .object-fit-contain {
            -o-object-fit: contain !important;
            object-fit: contain !important
        }

        .object-fit-cover {
            -o-object-fit: cover !important;
            object-fit: cover !important
        }

        .object-fit-fill {
            -o-object-fit: fill !important;
            object-fit: fill !important
        }

        .object-fit-scale {
            -o-object-fit: scale-down !important;
            object-fit: scale-down !important
        }

        .object-fit-none {
            -o-object-fit: none !important;
            object-fit: none !important
        }

        @media(min-width:576px) {
            .float-sm-start {
                float: left !important
            }

            .float-sm-end {
                float: right !important
            }

            .float-sm-none {
                float: none !important
            }

            .d-sm-inline {
                display: inline !important
            }

            .d-sm-inline-block {
                display: inline-block !important
            }

            .d-sm-block {
                display: block !important
            }

            .d-sm-grid {
                display: grid !important
            }

            .d-sm-table {
                display: table !important
            }

            .d-sm-table-row {
                display: table-row !important
            }

            .d-sm-table-cell {
                display: table-cell !important
            }

            .d-sm-flex {
                display: flex !important
            }

            .d-sm-inline-flex {
                display: inline-flex !important
            }

            .d-sm-none {
                display: none !important
            }

            .position-sm-static {
                position: static !important
            }

            .position-sm-relative {
                position: relative !important
            }

            .position-sm-absolute {
                position: absolute !important
            }

            .position-sm-fixed {
                position: fixed !important
            }

            .position-sm-sticky {
                position: -webkit-sticky !important;
                position: sticky !important
            }

            .w-sm-unset {
                width: unset !important
            }

            .w-sm-25 {
                width: 25% !important
            }

            .w-sm-50 {
                width: 50% !important
            }

            .w-sm-75 {
                width: 75% !important
            }

            .w-sm-100 {
                width: 100% !important
            }

            .w-sm-auto {
                width: auto !important
            }

            .w-sm-1px {
                width: 1px !important
            }

            .w-sm-2px {
                width: 2px !important
            }

            .w-sm-3px {
                width: 3px !important
            }

            .w-sm-4px {
                width: 4px !important
            }

            .w-sm-5px {
                width: 5px !important
            }

            .w-sm-6px {
                width: 6px !important
            }

            .w-sm-7px {
                width: 7px !important
            }

            .w-sm-8px {
                width: 8px !important
            }

            .w-sm-9px {
                width: 9px !important
            }

            .w-sm-10px {
                width: 10px !important
            }

            .w-sm-15px {
                width: 15px !important
            }

            .w-sm-20px {
                width: 20px !important
            }

            .w-sm-25px {
                width: 25px !important
            }

            .w-sm-30px {
                width: 30px !important
            }

            .w-sm-35px {
                width: 35px !important
            }

            .w-sm-40px {
                width: 40px !important
            }

            .w-sm-45px {
                width: 45px !important
            }

            .w-sm-50px {
                width: 50px !important
            }

            .w-sm-55px {
                width: 55px !important
            }

            .w-sm-60px {
                width: 60px !important
            }

            .w-sm-65px {
                width: 65px !important
            }

            .w-sm-70px {
                width: 70px !important
            }

            .w-sm-75px {
                width: 75px !important
            }

            .w-sm-80px {
                width: 80px !important
            }

            .w-sm-85px {
                width: 85px !important
            }

            .w-sm-90px {
                width: 90px !important
            }

            .w-sm-95px {
                width: 95px !important
            }

            .w-sm-100px {
                width: 100px !important
            }

            .w-sm-125px {
                width: 125px !important
            }

            .w-sm-150px {
                width: 150px !important
            }

            .w-sm-175px {
                width: 175px !important
            }

            .w-sm-200px {
                width: 200px !important
            }

            .w-sm-225px {
                width: 225px !important
            }

            .w-sm-250px {
                width: 250px !important
            }

            .w-sm-275px {
                width: 275px !important
            }

            .w-sm-300px {
                width: 300px !important
            }

            .w-sm-325px {
                width: 325px !important
            }

            .w-sm-350px {
                width: 350px !important
            }

            .w-sm-375px {
                width: 375px !important
            }

            .w-sm-400px {
                width: 400px !important
            }

            .w-sm-425px {
                width: 425px !important
            }

            .w-sm-450px {
                width: 450px !important
            }

            .w-sm-475px {
                width: 475px !important
            }

            .w-sm-500px {
                width: 500px !important
            }

            .w-sm-550px {
                width: 550px !important
            }

            .w-sm-600px {
                width: 600px !important
            }

            .w-sm-650px {
                width: 650px !important
            }

            .w-sm-700px {
                width: 700px !important
            }

            .w-sm-750px {
                width: 750px !important
            }

            .w-sm-800px {
                width: 800px !important
            }

            .w-sm-850px {
                width: 850px !important
            }

            .w-sm-900px {
                width: 900px !important
            }

            .w-sm-950px {
                width: 950px !important
            }

            .w-sm-1000px {
                width: 1000px !important
            }

            .mw-sm-unset {
                max-width: unset !important
            }

            .mw-sm-25 {
                max-width: 25% !important
            }

            .mw-sm-50 {
                max-width: 50% !important
            }

            .mw-sm-75 {
                max-width: 75% !important
            }

            .mw-sm-100 {
                max-width: 100% !important
            }

            .mw-sm-auto {
                max-width: auto !important
            }

            .mw-sm-1px {
                max-width: 1px !important
            }

            .mw-sm-2px {
                max-width: 2px !important
            }

            .mw-sm-3px {
                max-width: 3px !important
            }

            .mw-sm-4px {
                max-width: 4px !important
            }

            .mw-sm-5px {
                max-width: 5px !important
            }

            .mw-sm-6px {
                max-width: 6px !important
            }

            .mw-sm-7px {
                max-width: 7px !important
            }

            .mw-sm-8px {
                max-width: 8px !important
            }

            .mw-sm-9px {
                max-width: 9px !important
            }

            .mw-sm-10px {
                max-width: 10px !important
            }

            .mw-sm-15px {
                max-width: 15px !important
            }

            .mw-sm-20px {
                max-width: 20px !important
            }

            .mw-sm-25px {
                max-width: 25px !important
            }

            .mw-sm-30px {
                max-width: 30px !important
            }

            .mw-sm-35px {
                max-width: 35px !important
            }

            .mw-sm-40px {
                max-width: 40px !important
            }

            .mw-sm-45px {
                max-width: 45px !important
            }

            .mw-sm-50px {
                max-width: 50px !important
            }

            .mw-sm-55px {
                max-width: 55px !important
            }

            .mw-sm-60px {
                max-width: 60px !important
            }

            .mw-sm-65px {
                max-width: 65px !important
            }

            .mw-sm-70px {
                max-width: 70px !important
            }

            .mw-sm-75px {
                max-width: 75px !important
            }

            .mw-sm-80px {
                max-width: 80px !important
            }

            .mw-sm-85px {
                max-width: 85px !important
            }

            .mw-sm-90px {
                max-width: 90px !important
            }

            .mw-sm-95px {
                max-width: 95px !important
            }

            .mw-sm-100px {
                max-width: 100px !important
            }

            .mw-sm-125px {
                max-width: 125px !important
            }

            .mw-sm-150px {
                max-width: 150px !important
            }

            .mw-sm-175px {
                max-width: 175px !important
            }

            .mw-sm-200px {
                max-width: 200px !important
            }

            .mw-sm-225px {
                max-width: 225px !important
            }

            .mw-sm-250px {
                max-width: 250px !important
            }

            .mw-sm-275px {
                max-width: 275px !important
            }

            .mw-sm-300px {
                max-width: 300px !important
            }

            .mw-sm-325px {
                max-width: 325px !important
            }

            .mw-sm-350px {
                max-width: 350px !important
            }

            .mw-sm-375px {
                max-width: 375px !important
            }

            .mw-sm-400px {
                max-width: 400px !important
            }

            .mw-sm-425px {
                max-width: 425px !important
            }

            .mw-sm-450px {
                max-width: 450px !important
            }

            .mw-sm-475px {
                max-width: 475px !important
            }

            .mw-sm-500px {
                max-width: 500px !important
            }

            .mw-sm-550px {
                max-width: 550px !important
            }

            .mw-sm-600px {
                max-width: 600px !important
            }

            .mw-sm-650px {
                max-width: 650px !important
            }

            .mw-sm-700px {
                max-width: 700px !important
            }

            .mw-sm-750px {
                max-width: 750px !important
            }

            .mw-sm-800px {
                max-width: 800px !important
            }

            .mw-sm-850px {
                max-width: 850px !important
            }

            .mw-sm-900px {
                max-width: 900px !important
            }

            .mw-sm-950px {
                max-width: 950px !important
            }

            .mw-sm-1000px {
                max-width: 1000px !important
            }

            .vw-sm-25 {
                width: 25vw !important
            }

            .vw-sm-50 {
                width: 50vw !important
            }

            .vw-sm-75 {
                width: 75vw !important
            }

            .vw-sm-100 {
                width: 100vw !important
            }

            .vw-sm-auto {
                width: auto !important
            }

            .min-vw-sm-25 {
                min-width: 25vw !important
            }

            .min-vw-sm-50 {
                min-width: 50vw !important
            }

            .min-vw-sm-75 {
                min-width: 75vw !important
            }

            .min-vw-sm-100 {
                min-width: 100vw !important
            }

            .min-vw-sm-auto {
                min-width: auto !important
            }

            .h-sm-unset {
                height: unset !important
            }

            .h-sm-25 {
                height: 25% !important
            }

            .h-sm-50 {
                height: 50% !important
            }

            .h-sm-75 {
                height: 75% !important
            }

            .h-sm-100 {
                height: 100% !important
            }

            .h-sm-auto {
                height: auto !important
            }

            .h-sm-1px {
                height: 1px !important
            }

            .h-sm-2px {
                height: 2px !important
            }

            .h-sm-3px {
                height: 3px !important
            }

            .h-sm-4px {
                height: 4px !important
            }

            .h-sm-5px {
                height: 5px !important
            }

            .h-sm-6px {
                height: 6px !important
            }

            .h-sm-7px {
                height: 7px !important
            }

            .h-sm-8px {
                height: 8px !important
            }

            .h-sm-9px {
                height: 9px !important
            }

            .h-sm-10px {
                height: 10px !important
            }

            .h-sm-15px {
                height: 15px !important
            }

            .h-sm-20px {
                height: 20px !important
            }

            .h-sm-25px {
                height: 25px !important
            }

            .h-sm-30px {
                height: 30px !important
            }

            .h-sm-35px {
                height: 35px !important
            }

            .h-sm-40px {
                height: 40px !important
            }

            .h-sm-45px {
                height: 45px !important
            }

            .h-sm-50px {
                height: 50px !important
            }

            .h-sm-55px {
                height: 55px !important
            }

            .h-sm-60px {
                height: 60px !important
            }

            .h-sm-65px {
                height: 65px !important
            }

            .h-sm-70px {
                height: 70px !important
            }

            .h-sm-75px {
                height: 75px !important
            }

            .h-sm-80px {
                height: 80px !important
            }

            .h-sm-85px {
                height: 85px !important
            }

            .h-sm-90px {
                height: 90px !important
            }

            .h-sm-95px {
                height: 95px !important
            }

            .h-sm-100px {
                height: 100px !important
            }

            .h-sm-125px {
                height: 125px !important
            }

            .h-sm-150px {
                height: 150px !important
            }

            .h-sm-175px {
                height: 175px !important
            }

            .h-sm-200px {
                height: 200px !important
            }

            .h-sm-225px {
                height: 225px !important
            }

            .h-sm-250px {
                height: 250px !important
            }

            .h-sm-275px {
                height: 275px !important
            }

            .h-sm-300px {
                height: 300px !important
            }

            .h-sm-325px {
                height: 325px !important
            }

            .h-sm-350px {
                height: 350px !important
            }

            .h-sm-375px {
                height: 375px !important
            }

            .h-sm-400px {
                height: 400px !important
            }

            .h-sm-425px {
                height: 425px !important
            }

            .h-sm-450px {
                height: 450px !important
            }

            .h-sm-475px {
                height: 475px !important
            }

            .h-sm-500px {
                height: 500px !important
            }

            .h-sm-550px {
                height: 550px !important
            }

            .h-sm-600px {
                height: 600px !important
            }

            .h-sm-650px {
                height: 650px !important
            }

            .h-sm-700px {
                height: 700px !important
            }

            .h-sm-750px {
                height: 750px !important
            }

            .h-sm-800px {
                height: 800px !important
            }

            .h-sm-850px {
                height: 850px !important
            }

            .h-sm-900px {
                height: 900px !important
            }

            .h-sm-950px {
                height: 950px !important
            }

            .h-sm-1000px {
                height: 1000px !important
            }

            .mh-sm-unset {
                max-height: unset !important
            }

            .mh-sm-25 {
                max-height: 25% !important
            }

            .mh-sm-50 {
                max-height: 50% !important
            }

            .mh-sm-75 {
                max-height: 75% !important
            }

            .mh-sm-100 {
                max-height: 100% !important
            }

            .mh-sm-auto {
                max-height: auto !important
            }

            .mh-sm-1px {
                max-height: 1px !important
            }

            .mh-sm-2px {
                max-height: 2px !important
            }

            .mh-sm-3px {
                max-height: 3px !important
            }

            .mh-sm-4px {
                max-height: 4px !important
            }

            .mh-sm-5px {
                max-height: 5px !important
            }

            .mh-sm-6px {
                max-height: 6px !important
            }

            .mh-sm-7px {
                max-height: 7px !important
            }

            .mh-sm-8px {
                max-height: 8px !important
            }

            .mh-sm-9px {
                max-height: 9px !important
            }

            .mh-sm-10px {
                max-height: 10px !important
            }

            .mh-sm-15px {
                max-height: 15px !important
            }

            .mh-sm-20px {
                max-height: 20px !important
            }

            .mh-sm-25px {
                max-height: 25px !important
            }

            .mh-sm-30px {
                max-height: 30px !important
            }

            .mh-sm-35px {
                max-height: 35px !important
            }

            .mh-sm-40px {
                max-height: 40px !important
            }

            .mh-sm-45px {
                max-height: 45px !important
            }

            .mh-sm-50px {
                max-height: 50px !important
            }

            .mh-sm-55px {
                max-height: 55px !important
            }

            .mh-sm-60px {
                max-height: 60px !important
            }

            .mh-sm-65px {
                max-height: 65px !important
            }

            .mh-sm-70px {
                max-height: 70px !important
            }

            .mh-sm-75px {
                max-height: 75px !important
            }

            .mh-sm-80px {
                max-height: 80px !important
            }

            .mh-sm-85px {
                max-height: 85px !important
            }

            .mh-sm-90px {
                max-height: 90px !important
            }

            .mh-sm-95px {
                max-height: 95px !important
            }

            .mh-sm-100px {
                max-height: 100px !important
            }

            .mh-sm-125px {
                max-height: 125px !important
            }

            .mh-sm-150px {
                max-height: 150px !important
            }

            .mh-sm-175px {
                max-height: 175px !important
            }

            .mh-sm-200px {
                max-height: 200px !important
            }

            .mh-sm-225px {
                max-height: 225px !important
            }

            .mh-sm-250px {
                max-height: 250px !important
            }

            .mh-sm-275px {
                max-height: 275px !important
            }

            .mh-sm-300px {
                max-height: 300px !important
            }

            .mh-sm-325px {
                max-height: 325px !important
            }

            .mh-sm-350px {
                max-height: 350px !important
            }

            .mh-sm-375px {
                max-height: 375px !important
            }

            .mh-sm-400px {
                max-height: 400px !important
            }

            .mh-sm-425px {
                max-height: 425px !important
            }

            .mh-sm-450px {
                max-height: 450px !important
            }

            .mh-sm-475px {
                max-height: 475px !important
            }

            .mh-sm-500px {
                max-height: 500px !important
            }

            .mh-sm-550px {
                max-height: 550px !important
            }

            .mh-sm-600px {
                max-height: 600px !important
            }

            .mh-sm-650px {
                max-height: 650px !important
            }

            .mh-sm-700px {
                max-height: 700px !important
            }

            .mh-sm-750px {
                max-height: 750px !important
            }

            .mh-sm-800px {
                max-height: 800px !important
            }

            .mh-sm-850px {
                max-height: 850px !important
            }

            .mh-sm-900px {
                max-height: 900px !important
            }

            .mh-sm-950px {
                max-height: 950px !important
            }

            .mh-sm-1000px {
                max-height: 1000px !important
            }

            .vh-sm-25 {
                height: 25vh !important
            }

            .vh-sm-50 {
                height: 50vh !important
            }

            .vh-sm-75 {
                height: 75vh !important
            }

            .vh-sm-100 {
                height: 100vh !important
            }

            .vh-sm-auto {
                height: auto !important
            }

            .min-vh-sm-25 {
                min-height: 25vh !important
            }

            .min-vh-sm-50 {
                min-height: 50vh !important
            }

            .min-vh-sm-75 {
                min-height: 75vh !important
            }

            .min-vh-sm-100 {
                min-height: 100vh !important
            }

            .min-vh-sm-auto {
                min-height: auto !important
            }

            .flex-sm-fill {
                flex: 1 1 auto !important
            }

            .flex-sm-row {
                flex-direction: row !important
            }

            .flex-sm-column {
                flex-direction: column !important
            }

            .flex-sm-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-sm-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-sm-grow-0 {
                flex-grow: 0 !important
            }

            .flex-sm-grow-1 {
                flex-grow: 1 !important
            }

            .flex-sm-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-sm-shrink-1 {
                flex-shrink: 1 !important
            }

            .flex-sm-wrap {
                flex-wrap: wrap !important
            }

            .flex-sm-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-sm-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .justify-content-sm-start {
                justify-content: flex-start !important
            }

            .justify-content-sm-end {
                justify-content: flex-end !important
            }

            .justify-content-sm-center {
                justify-content: center !important
            }

            .justify-content-sm-between {
                justify-content: space-between !important
            }

            .justify-content-sm-around {
                justify-content: space-around !important
            }

            .justify-content-sm-evenly {
                justify-content: space-evenly !important
            }

            .align-items-sm-start {
                align-items: flex-start !important
            }

            .align-items-sm-end {
                align-items: flex-end !important
            }

            .align-items-sm-center {
                align-items: center !important
            }

            .align-items-sm-baseline {
                align-items: baseline !important
            }

            .align-items-sm-stretch {
                align-items: stretch !important
            }

            .align-content-sm-start {
                align-content: flex-start !important
            }

            .align-content-sm-end {
                align-content: flex-end !important
            }

            .align-content-sm-center {
                align-content: center !important
            }

            .align-content-sm-between {
                align-content: space-between !important
            }

            .align-content-sm-around {
                align-content: space-around !important
            }

            .align-content-sm-stretch {
                align-content: stretch !important
            }

            .align-self-sm-auto {
                align-self: auto !important
            }

            .align-self-sm-start {
                align-self: flex-start !important
            }

            .align-self-sm-end {
                align-self: flex-end !important
            }

            .align-self-sm-center {
                align-self: center !important
            }

            .align-self-sm-baseline {
                align-self: baseline !important
            }

            .align-self-sm-stretch {
                align-self: stretch !important
            }

            .order-sm-first {
                order: -1 !important
            }

            .order-sm-0 {
                order: 0 !important
            }

            .order-sm-1 {
                order: 1 !important
            }

            .order-sm-2 {
                order: 2 !important
            }

            .order-sm-3 {
                order: 3 !important
            }

            .order-sm-4 {
                order: 4 !important
            }

            .order-sm-5 {
                order: 5 !important
            }

            .order-sm-last {
                order: 6 !important
            }

            .m-sm-0 {
                margin: 0 !important
            }

            .m-sm-1 {
                margin: .234375rem !important
            }

            .m-sm-2 {
                margin: .46875rem !important
            }

            .m-sm-3 {
                margin: .624999375rem !important
            }

            .m-sm-4 {
                margin: .9375rem !important
            }

            .m-sm-5 {
                margin: 1.2500000001rem !important
            }

            .m-sm-6 {
                margin: 1.875rem !important
            }

            .m-sm-7 {
                margin: 2.8125rem !important
            }

            .m-sm-8 {
                margin: 3.75rem !important
            }

            .m-sm-9 {
                margin: 5.625rem !important
            }

            .m-sm-10 {
                margin: 8.4375rem !important
            }

            .m-sm-auto {
                margin: auto !important
            }

            .mx-sm-0 {
                margin-left: 0 !important;
                margin-right: 0 !important
            }

            .mx-sm-1 {
                margin-left: .234375rem !important;
                margin-right: .234375rem !important
            }

            .mx-sm-2 {
                margin-left: .46875rem !important;
                margin-right: .46875rem !important
            }

            .mx-sm-3 {
                margin-left: .624999375rem !important;
                margin-right: .624999375rem !important
            }

            .mx-sm-4 {
                margin-left: .9375rem !important;
                margin-right: .9375rem !important
            }

            .mx-sm-5 {
                margin-left: 1.2500000001rem !important;
                margin-right: 1.2500000001rem !important
            }

            .mx-sm-6 {
                margin-left: 1.875rem !important;
                margin-right: 1.875rem !important
            }

            .mx-sm-7 {
                margin-left: 2.8125rem !important;
                margin-right: 2.8125rem !important
            }

            .mx-sm-8 {
                margin-left: 3.75rem !important;
                margin-right: 3.75rem !important
            }

            .mx-sm-9 {
                margin-left: 5.625rem !important;
                margin-right: 5.625rem !important
            }

            .mx-sm-10 {
                margin-left: 8.4375rem !important;
                margin-right: 8.4375rem !important
            }

            .mx-sm-auto {
                margin-left: auto !important;
                margin-right: auto !important
            }

            .my-sm-0 {
                margin-bottom: 0 !important;
                margin-top: 0 !important
            }

            .my-sm-1 {
                margin-bottom: .234375rem !important;
                margin-top: .234375rem !important
            }

            .my-sm-2 {
                margin-bottom: .46875rem !important;
                margin-top: .46875rem !important
            }

            .my-sm-3 {
                margin-bottom: .624999375rem !important;
                margin-top: .624999375rem !important
            }

            .my-sm-4 {
                margin-bottom: .9375rem !important;
                margin-top: .9375rem !important
            }

            .my-sm-5 {
                margin-bottom: 1.2500000001rem !important;
                margin-top: 1.2500000001rem !important
            }

            .my-sm-6 {
                margin-bottom: 1.875rem !important;
                margin-top: 1.875rem !important
            }

            .my-sm-7 {
                margin-bottom: 2.8125rem !important;
                margin-top: 2.8125rem !important
            }

            .my-sm-8 {
                margin-bottom: 3.75rem !important;
                margin-top: 3.75rem !important
            }

            .my-sm-9 {
                margin-bottom: 5.625rem !important;
                margin-top: 5.625rem !important
            }

            .my-sm-10 {
                margin-bottom: 8.4375rem !important;
                margin-top: 8.4375rem !important
            }

            .my-sm-auto {
                margin-bottom: auto !important;
                margin-top: auto !important
            }

            .mt-sm-0 {
                margin-top: 0 !important
            }

            .mt-sm-1 {
                margin-top: .234375rem !important
            }

            .mt-sm-2 {
                margin-top: .46875rem !important
            }

            .mt-sm-3 {
                margin-top: .624999375rem !important
            }

            .mt-sm-4 {
                margin-top: .9375rem !important
            }

            .mt-sm-5 {
                margin-top: 1.2500000001rem !important
            }

            .mt-sm-6 {
                margin-top: 1.875rem !important
            }

            .mt-sm-7 {
                margin-top: 2.8125rem !important
            }

            .mt-sm-8 {
                margin-top: 3.75rem !important
            }

            .mt-sm-9 {
                margin-top: 5.625rem !important
            }

            .mt-sm-10 {
                margin-top: 8.4375rem !important
            }

            .mt-sm-auto {
                margin-top: auto !important
            }

            .me-sm-0 {
                margin-right: 0 !important
            }

            .me-sm-1 {
                margin-right: .234375rem !important
            }

            .me-sm-2 {
                margin-right: .46875rem !important
            }

            .me-sm-3 {
                margin-right: .624999375rem !important
            }

            .me-sm-4 {
                margin-right: .9375rem !important
            }

            .me-sm-5 {
                margin-right: 1.2500000001rem !important
            }

            .me-sm-6 {
                margin-right: 1.875rem !important
            }

            .me-sm-7 {
                margin-right: 2.8125rem !important
            }

            .me-sm-8 {
                margin-right: 3.75rem !important
            }

            .me-sm-9 {
                margin-right: 5.625rem !important
            }

            .me-sm-10 {
                margin-right: 8.4375rem !important
            }

            .me-sm-auto {
                margin-right: auto !important
            }

            .mb-sm-0 {
                margin-bottom: 0 !important
            }

            .mb-sm-1 {
                margin-bottom: .234375rem !important
            }

            .mb-sm-2 {
                margin-bottom: .46875rem !important
            }

            .mb-sm-3 {
                margin-bottom: .624999375rem !important
            }

            .mb-sm-4 {
                margin-bottom: .9375rem !important
            }

            .mb-sm-5 {
                margin-bottom: 1.2500000001rem !important
            }

            .mb-sm-6 {
                margin-bottom: 1.875rem !important
            }

            .mb-sm-7 {
                margin-bottom: 2.8125rem !important
            }

            .mb-sm-8 {
                margin-bottom: 3.75rem !important
            }

            .mb-sm-9 {
                margin-bottom: 5.625rem !important
            }

            .mb-sm-10 {
                margin-bottom: 8.4375rem !important
            }

            .mb-sm-auto {
                margin-bottom: auto !important
            }

            .ms-sm-0 {
                margin-left: 0 !important
            }

            .ms-sm-1 {
                margin-left: .234375rem !important
            }

            .ms-sm-2 {
                margin-left: .46875rem !important
            }

            .ms-sm-3 {
                margin-left: .624999375rem !important
            }

            .ms-sm-4 {
                margin-left: .9375rem !important
            }

            .ms-sm-5 {
                margin-left: 1.2500000001rem !important
            }

            .ms-sm-6 {
                margin-left: 1.875rem !important
            }

            .ms-sm-7 {
                margin-left: 2.8125rem !important
            }

            .ms-sm-8 {
                margin-left: 3.75rem !important
            }

            .ms-sm-9 {
                margin-left: 5.625rem !important
            }

            .ms-sm-10 {
                margin-left: 8.4375rem !important
            }

            .ms-sm-auto {
                margin-left: auto !important
            }

            .m-sm-n1 {
                margin: -.234375rem !important
            }

            .m-sm-n2 {
                margin: -.46875rem !important
            }

            .m-sm-n3 {
                margin: -.624999375rem !important
            }

            .m-sm-n4 {
                margin: -.9375rem !important
            }

            .m-sm-n5 {
                margin: -1.2500000001rem !important
            }

            .m-sm-n6 {
                margin: -1.875rem !important
            }

            .m-sm-n7 {
                margin: -2.8125rem !important
            }

            .m-sm-n8 {
                margin: -3.75rem !important
            }

            .m-sm-n9 {
                margin: -5.625rem !important
            }

            .m-sm-n10 {
                margin: -8.4375rem !important
            }

            .mx-sm-n1 {
                margin-left: -.234375rem !important;
                margin-right: -.234375rem !important
            }

            .mx-sm-n2 {
                margin-left: -.46875rem !important;
                margin-right: -.46875rem !important
            }

            .mx-sm-n3 {
                margin-left: -.624999375rem !important;
                margin-right: -.624999375rem !important
            }

            .mx-sm-n4 {
                margin-left: -.9375rem !important;
                margin-right: -.9375rem !important
            }

            .mx-sm-n5 {
                margin-left: -1.2500000001rem !important;
                margin-right: -1.2500000001rem !important
            }

            .mx-sm-n6 {
                margin-left: -1.875rem !important;
                margin-right: -1.875rem !important
            }

            .mx-sm-n7 {
                margin-left: -2.8125rem !important;
                margin-right: -2.8125rem !important
            }

            .mx-sm-n8 {
                margin-left: -3.75rem !important;
                margin-right: -3.75rem !important
            }

            .mx-sm-n9 {
                margin-left: -5.625rem !important;
                margin-right: -5.625rem !important
            }

            .mx-sm-n10 {
                margin-left: -8.4375rem !important;
                margin-right: -8.4375rem !important
            }

            .my-sm-n1 {
                margin-bottom: -.234375rem !important;
                margin-top: -.234375rem !important
            }

            .my-sm-n2 {
                margin-bottom: -.46875rem !important;
                margin-top: -.46875rem !important
            }

            .my-sm-n3 {
                margin-bottom: -.624999375rem !important;
                margin-top: -.624999375rem !important
            }

            .my-sm-n4 {
                margin-bottom: -.9375rem !important;
                margin-top: -.9375rem !important
            }

            .my-sm-n5 {
                margin-bottom: -1.2500000001rem !important;
                margin-top: -1.2500000001rem !important
            }

            .my-sm-n6 {
                margin-bottom: -1.875rem !important;
                margin-top: -1.875rem !important
            }

            .my-sm-n7 {
                margin-bottom: -2.8125rem !important;
                margin-top: -2.8125rem !important
            }

            .my-sm-n8 {
                margin-bottom: -3.75rem !important;
                margin-top: -3.75rem !important
            }

            .my-sm-n9 {
                margin-bottom: -5.625rem !important;
                margin-top: -5.625rem !important
            }

            .my-sm-n10 {
                margin-bottom: -8.4375rem !important;
                margin-top: -8.4375rem !important
            }

            .mt-sm-n1 {
                margin-top: -.234375rem !important
            }

            .mt-sm-n2 {
                margin-top: -.46875rem !important
            }

            .mt-sm-n3 {
                margin-top: -.624999375rem !important
            }

            .mt-sm-n4 {
                margin-top: -.9375rem !important
            }

            .mt-sm-n5 {
                margin-top: -1.2500000001rem !important
            }

            .mt-sm-n6 {
                margin-top: -1.875rem !important
            }

            .mt-sm-n7 {
                margin-top: -2.8125rem !important
            }

            .mt-sm-n8 {
                margin-top: -3.75rem !important
            }

            .mt-sm-n9 {
                margin-top: -5.625rem !important
            }

            .mt-sm-n10 {
                margin-top: -8.4375rem !important
            }

            .me-sm-n1 {
                margin-right: -.234375rem !important
            }

            .me-sm-n2 {
                margin-right: -.46875rem !important
            }

            .me-sm-n3 {
                margin-right: -.624999375rem !important
            }

            .me-sm-n4 {
                margin-right: -.9375rem !important
            }

            .me-sm-n5 {
                margin-right: -1.2500000001rem !important
            }

            .me-sm-n6 {
                margin-right: -1.875rem !important
            }

            .me-sm-n7 {
                margin-right: -2.8125rem !important
            }

            .me-sm-n8 {
                margin-right: -3.75rem !important
            }

            .me-sm-n9 {
                margin-right: -5.625rem !important
            }

            .me-sm-n10 {
                margin-right: -8.4375rem !important
            }

            .mb-sm-n1 {
                margin-bottom: -.234375rem !important
            }

            .mb-sm-n2 {
                margin-bottom: -.46875rem !important
            }

            .mb-sm-n3 {
                margin-bottom: -.624999375rem !important
            }

            .mb-sm-n4 {
                margin-bottom: -.9375rem !important
            }

            .mb-sm-n5 {
                margin-bottom: -1.2500000001rem !important
            }

            .mb-sm-n6 {
                margin-bottom: -1.875rem !important
            }

            .mb-sm-n7 {
                margin-bottom: -2.8125rem !important
            }

            .mb-sm-n8 {
                margin-bottom: -3.75rem !important
            }

            .mb-sm-n9 {
                margin-bottom: -5.625rem !important
            }

            .mb-sm-n10 {
                margin-bottom: -8.4375rem !important
            }

            .ms-sm-n1 {
                margin-left: -.234375rem !important
            }

            .ms-sm-n2 {
                margin-left: -.46875rem !important
            }

            .ms-sm-n3 {
                margin-left: -.624999375rem !important
            }

            .ms-sm-n4 {
                margin-left: -.9375rem !important
            }

            .ms-sm-n5 {
                margin-left: -1.2500000001rem !important
            }

            .ms-sm-n6 {
                margin-left: -1.875rem !important
            }

            .ms-sm-n7 {
                margin-left: -2.8125rem !important
            }

            .ms-sm-n8 {
                margin-left: -3.75rem !important
            }

            .ms-sm-n9 {
                margin-left: -5.625rem !important
            }

            .ms-sm-n10 {
                margin-left: -8.4375rem !important
            }

            .p-sm-0 {
                padding: 0 !important
            }

            .p-sm-1 {
                padding: .234375rem !important
            }

            .p-sm-2 {
                padding: .46875rem !important
            }

            .p-sm-3 {
                padding: .624999375rem !important
            }

            .p-sm-4 {
                padding: .9375rem !important
            }

            .p-sm-5 {
                padding: 1.2500000001rem !important
            }

            .p-sm-6 {
                padding: 1.875rem !important
            }

            .p-sm-7 {
                padding: 2.8125rem !important
            }

            .p-sm-8 {
                padding: 3.75rem !important
            }

            .p-sm-9 {
                padding: 5.625rem !important
            }

            .p-sm-10 {
                padding: 8.4375rem !important
            }

            .px-sm-0 {
                padding-left: 0 !important;
                padding-right: 0 !important
            }

            .px-sm-1 {
                padding-left: .234375rem !important;
                padding-right: .234375rem !important
            }

            .px-sm-2 {
                padding-left: .46875rem !important;
                padding-right: .46875rem !important
            }

            .px-sm-3 {
                padding-left: .624999375rem !important;
                padding-right: .624999375rem !important
            }

            .px-sm-4 {
                padding-left: .9375rem !important;
                padding-right: .9375rem !important
            }

            .px-sm-5 {
                padding-left: 1.2500000001rem !important;
                padding-right: 1.2500000001rem !important
            }

            .px-sm-6 {
                padding-left: 1.875rem !important;
                padding-right: 1.875rem !important
            }

            .px-sm-7 {
                padding-left: 2.8125rem !important;
                padding-right: 2.8125rem !important
            }

            .px-sm-8 {
                padding-left: 3.75rem !important;
                padding-right: 3.75rem !important
            }

            .px-sm-9 {
                padding-left: 5.625rem !important;
                padding-right: 5.625rem !important
            }

            .px-sm-10 {
                padding-left: 8.4375rem !important;
                padding-right: 8.4375rem !important
            }

            .py-sm-0 {
                padding-bottom: 0 !important;
                padding-top: 0 !important
            }

            .py-sm-1 {
                padding-bottom: .234375rem !important;
                padding-top: .234375rem !important
            }

            .py-sm-2 {
                padding-bottom: .46875rem !important;
                padding-top: .46875rem !important
            }

            .py-sm-3 {
                padding-bottom: .624999375rem !important;
                padding-top: .624999375rem !important
            }

            .py-sm-4 {
                padding-bottom: .9375rem !important;
                padding-top: .9375rem !important
            }

            .py-sm-5 {
                padding-bottom: 1.2500000001rem !important;
                padding-top: 1.2500000001rem !important
            }

            .py-sm-6 {
                padding-bottom: 1.875rem !important;
                padding-top: 1.875rem !important
            }

            .py-sm-7 {
                padding-bottom: 2.8125rem !important;
                padding-top: 2.8125rem !important
            }

            .py-sm-8 {
                padding-bottom: 3.75rem !important;
                padding-top: 3.75rem !important
            }

            .py-sm-9 {
                padding-bottom: 5.625rem !important;
                padding-top: 5.625rem !important
            }

            .py-sm-10 {
                padding-bottom: 8.4375rem !important;
                padding-top: 8.4375rem !important
            }

            .pt-sm-0 {
                padding-top: 0 !important
            }

            .pt-sm-1 {
                padding-top: .234375rem !important
            }

            .pt-sm-2 {
                padding-top: .46875rem !important
            }

            .pt-sm-3 {
                padding-top: .624999375rem !important
            }

            .pt-sm-4 {
                padding-top: .9375rem !important
            }

            .pt-sm-5 {
                padding-top: 1.2500000001rem !important
            }

            .pt-sm-6 {
                padding-top: 1.875rem !important
            }

            .pt-sm-7 {
                padding-top: 2.8125rem !important
            }

            .pt-sm-8 {
                padding-top: 3.75rem !important
            }

            .pt-sm-9 {
                padding-top: 5.625rem !important
            }

            .pt-sm-10 {
                padding-top: 8.4375rem !important
            }

            .pe-sm-0 {
                padding-right: 0 !important
            }

            .pe-sm-1 {
                padding-right: .234375rem !important
            }

            .pe-sm-2 {
                padding-right: .46875rem !important
            }

            .pe-sm-3 {
                padding-right: .624999375rem !important
            }

            .pe-sm-4 {
                padding-right: .9375rem !important
            }

            .pe-sm-5 {
                padding-right: 1.2500000001rem !important
            }

            .pe-sm-6 {
                padding-right: 1.875rem !important
            }

            .pe-sm-7 {
                padding-right: 2.8125rem !important
            }

            .pe-sm-8 {
                padding-right: 3.75rem !important
            }

            .pe-sm-9 {
                padding-right: 5.625rem !important
            }

            .pe-sm-10 {
                padding-right: 8.4375rem !important
            }

            .pb-sm-0 {
                padding-bottom: 0 !important
            }

            .pb-sm-1 {
                padding-bottom: .234375rem !important
            }

            .pb-sm-2 {
                padding-bottom: .46875rem !important
            }

            .pb-sm-3 {
                padding-bottom: .624999375rem !important
            }

            .pb-sm-4 {
                padding-bottom: .9375rem !important
            }

            .pb-sm-5 {
                padding-bottom: 1.2500000001rem !important
            }

            .pb-sm-6 {
                padding-bottom: 1.875rem !important
            }

            .pb-sm-7 {
                padding-bottom: 2.8125rem !important
            }

            .pb-sm-8 {
                padding-bottom: 3.75rem !important
            }

            .pb-sm-9 {
                padding-bottom: 5.625rem !important
            }

            .pb-sm-10 {
                padding-bottom: 8.4375rem !important
            }

            .ps-sm-0 {
                padding-left: 0 !important
            }

            .ps-sm-1 {
                padding-left: .234375rem !important
            }

            .ps-sm-2 {
                padding-left: .46875rem !important
            }

            .ps-sm-3 {
                padding-left: .624999375rem !important
            }

            .ps-sm-4 {
                padding-left: .9375rem !important
            }

            .ps-sm-5 {
                padding-left: 1.2500000001rem !important
            }

            .ps-sm-6 {
                padding-left: 1.875rem !important
            }

            .ps-sm-7 {
                padding-left: 2.8125rem !important
            }

            .ps-sm-8 {
                padding-left: 3.75rem !important
            }

            .ps-sm-9 {
                padding-left: 5.625rem !important
            }

            .ps-sm-10 {
                padding-left: 8.4375rem !important
            }

            .gap-sm-0 {
                gap: 0 !important
            }

            .gap-sm-1 {
                gap: .234375rem !important
            }

            .gap-sm-2 {
                gap: .46875rem !important
            }

            .gap-sm-3 {
                gap: .624999375rem !important
            }

            .gap-sm-4 {
                gap: .9375rem !important
            }

            .gap-sm-5 {
                gap: 1.2500000001rem !important
            }

            .gap-sm-6 {
                gap: 1.875rem !important
            }

            .gap-sm-7 {
                gap: 2.8125rem !important
            }

            .gap-sm-8 {
                gap: 3.75rem !important
            }

            .gap-sm-9 {
                gap: 5.625rem !important
            }

            .gap-sm-10 {
                gap: 8.4375rem !important
            }

            .text-sm-start {
                text-align: left !important
            }

            .text-sm-end {
                text-align: right !important
            }

            .text-sm-center {
                text-align: center !important
            }

            .min-w-sm-unset {
                min-width: unset !important
            }

            .min-w-sm-25 {
                min-width: 25% !important
            }

            .min-w-sm-50 {
                min-width: 50% !important
            }

            .min-w-sm-75 {
                min-width: 75% !important
            }

            .min-w-sm-100 {
                min-width: 100% !important
            }

            .min-w-sm-auto {
                min-width: auto !important
            }

            .min-w-sm-1px {
                min-width: 1px !important
            }

            .min-w-sm-2px {
                min-width: 2px !important
            }

            .min-w-sm-3px {
                min-width: 3px !important
            }

            .min-w-sm-4px {
                min-width: 4px !important
            }

            .min-w-sm-5px {
                min-width: 5px !important
            }

            .min-w-sm-6px {
                min-width: 6px !important
            }

            .min-w-sm-7px {
                min-width: 7px !important
            }

            .min-w-sm-8px {
                min-width: 8px !important
            }

            .min-w-sm-9px {
                min-width: 9px !important
            }

            .min-w-sm-10px {
                min-width: 10px !important
            }

            .min-w-sm-15px {
                min-width: 15px !important
            }

            .min-w-sm-20px {
                min-width: 20px !important
            }

            .min-w-sm-25px {
                min-width: 25px !important
            }

            .min-w-sm-30px {
                min-width: 30px !important
            }

            .min-w-sm-35px {
                min-width: 35px !important
            }

            .min-w-sm-40px {
                min-width: 40px !important
            }

            .min-w-sm-45px {
                min-width: 45px !important
            }

            .min-w-sm-50px {
                min-width: 50px !important
            }

            .min-w-sm-55px {
                min-width: 55px !important
            }

            .min-w-sm-60px {
                min-width: 60px !important
            }

            .min-w-sm-65px {
                min-width: 65px !important
            }

            .min-w-sm-70px {
                min-width: 70px !important
            }

            .min-w-sm-75px {
                min-width: 75px !important
            }

            .min-w-sm-80px {
                min-width: 80px !important
            }

            .min-w-sm-85px {
                min-width: 85px !important
            }

            .min-w-sm-90px {
                min-width: 90px !important
            }

            .min-w-sm-95px {
                min-width: 95px !important
            }

            .min-w-sm-100px {
                min-width: 100px !important
            }

            .min-w-sm-125px {
                min-width: 125px !important
            }

            .min-w-sm-150px {
                min-width: 150px !important
            }

            .min-w-sm-175px {
                min-width: 175px !important
            }

            .min-w-sm-200px {
                min-width: 200px !important
            }

            .min-w-sm-225px {
                min-width: 225px !important
            }

            .min-w-sm-250px {
                min-width: 250px !important
            }

            .min-w-sm-275px {
                min-width: 275px !important
            }

            .min-w-sm-300px {
                min-width: 300px !important
            }

            .min-w-sm-325px {
                min-width: 325px !important
            }

            .min-w-sm-350px {
                min-width: 350px !important
            }

            .min-w-sm-375px {
                min-width: 375px !important
            }

            .min-w-sm-400px {
                min-width: 400px !important
            }

            .min-w-sm-425px {
                min-width: 425px !important
            }

            .min-w-sm-450px {
                min-width: 450px !important
            }

            .min-w-sm-475px {
                min-width: 475px !important
            }

            .min-w-sm-500px {
                min-width: 500px !important
            }

            .min-w-sm-550px {
                min-width: 550px !important
            }

            .min-w-sm-600px {
                min-width: 600px !important
            }

            .min-w-sm-650px {
                min-width: 650px !important
            }

            .min-w-sm-700px {
                min-width: 700px !important
            }

            .min-w-sm-750px {
                min-width: 750px !important
            }

            .min-w-sm-800px {
                min-width: 800px !important
            }

            .min-w-sm-850px {
                min-width: 850px !important
            }

            .min-w-sm-900px {
                min-width: 900px !important
            }

            .min-w-sm-950px {
                min-width: 950px !important
            }

            .min-w-sm-1000px {
                min-width: 1000px !important
            }

            .min-h-sm-unset {
                min-height: unset !important
            }

            .min-h-sm-25 {
                min-height: 25% !important
            }

            .min-h-sm-50 {
                min-height: 50% !important
            }

            .min-h-sm-75 {
                min-height: 75% !important
            }

            .min-h-sm-100 {
                min-height: 100% !important
            }

            .min-h-sm-auto {
                min-height: auto !important
            }

            .min-h-sm-1px {
                min-height: 1px !important
            }

            .min-h-sm-2px {
                min-height: 2px !important
            }

            .min-h-sm-3px {
                min-height: 3px !important
            }

            .min-h-sm-4px {
                min-height: 4px !important
            }

            .min-h-sm-5px {
                min-height: 5px !important
            }

            .min-h-sm-6px {
                min-height: 6px !important
            }

            .min-h-sm-7px {
                min-height: 7px !important
            }

            .min-h-sm-8px {
                min-height: 8px !important
            }

            .min-h-sm-9px {
                min-height: 9px !important
            }

            .min-h-sm-10px {
                min-height: 10px !important
            }

            .min-h-sm-15px {
                min-height: 15px !important
            }

            .min-h-sm-20px {
                min-height: 20px !important
            }

            .min-h-sm-25px {
                min-height: 25px !important
            }

            .min-h-sm-30px {
                min-height: 30px !important
            }

            .min-h-sm-35px {
                min-height: 35px !important
            }

            .min-h-sm-40px {
                min-height: 40px !important
            }

            .min-h-sm-45px {
                min-height: 45px !important
            }

            .min-h-sm-50px {
                min-height: 50px !important
            }

            .min-h-sm-55px {
                min-height: 55px !important
            }

            .min-h-sm-60px {
                min-height: 60px !important
            }

            .min-h-sm-65px {
                min-height: 65px !important
            }

            .min-h-sm-70px {
                min-height: 70px !important
            }

            .min-h-sm-75px {
                min-height: 75px !important
            }

            .min-h-sm-80px {
                min-height: 80px !important
            }

            .min-h-sm-85px {
                min-height: 85px !important
            }

            .min-h-sm-90px {
                min-height: 90px !important
            }

            .min-h-sm-95px {
                min-height: 95px !important
            }

            .min-h-sm-100px {
                min-height: 100px !important
            }

            .min-h-sm-125px {
                min-height: 125px !important
            }

            .min-h-sm-150px {
                min-height: 150px !important
            }

            .min-h-sm-175px {
                min-height: 175px !important
            }

            .min-h-sm-200px {
                min-height: 200px !important
            }

            .min-h-sm-225px {
                min-height: 225px !important
            }

            .min-h-sm-250px {
                min-height: 250px !important
            }

            .min-h-sm-275px {
                min-height: 275px !important
            }

            .min-h-sm-300px {
                min-height: 300px !important
            }

            .min-h-sm-325px {
                min-height: 325px !important
            }

            .min-h-sm-350px {
                min-height: 350px !important
            }

            .min-h-sm-375px {
                min-height: 375px !important
            }

            .min-h-sm-400px {
                min-height: 400px !important
            }

            .min-h-sm-425px {
                min-height: 425px !important
            }

            .min-h-sm-450px {
                min-height: 450px !important
            }

            .min-h-sm-475px {
                min-height: 475px !important
            }

            .min-h-sm-500px {
                min-height: 500px !important
            }

            .min-h-sm-550px {
                min-height: 550px !important
            }

            .min-h-sm-600px {
                min-height: 600px !important
            }

            .min-h-sm-650px {
                min-height: 650px !important
            }

            .min-h-sm-700px {
                min-height: 700px !important
            }

            .min-h-sm-750px {
                min-height: 750px !important
            }

            .min-h-sm-800px {
                min-height: 800px !important
            }

            .min-h-sm-850px {
                min-height: 850px !important
            }

            .min-h-sm-900px {
                min-height: 900px !important
            }

            .min-h-sm-950px {
                min-height: 950px !important
            }

            .min-h-sm-1000px {
                min-height: 1000px !important
            }

            .scroll-m-sm-0 {
                scroll-margin: 0 !important
            }

            .scroll-m-sm-1 {
                scroll-margin: .234375rem !important
            }

            .scroll-m-sm-2 {
                scroll-margin: .46875rem !important
            }

            .scroll-m-sm-3 {
                scroll-margin: .624999375rem !important
            }

            .scroll-m-sm-4 {
                scroll-margin: .9375rem !important
            }

            .scroll-m-sm-5 {
                scroll-margin: 1.2500000001rem !important
            }

            .scroll-m-sm-6 {
                scroll-margin: 1.875rem !important
            }

            .scroll-m-sm-7 {
                scroll-margin: 2.8125rem !important
            }

            .scroll-m-sm-8 {
                scroll-margin: 3.75rem !important
            }

            .scroll-m-sm-9 {
                scroll-margin: 5.625rem !important
            }

            .scroll-m-sm-10 {
                scroll-margin: 8.4375rem !important
            }

            .scroll-m-sm-auto {
                scroll-margin: auto !important
            }

            .scroll-mx-sm-0 {
                scroll-margin-left: 0 !important;
                scroll-margin-right: 0 !important
            }

            .scroll-mx-sm-1 {
                scroll-margin-left: .234375rem !important;
                scroll-margin-right: .234375rem !important
            }

            .scroll-mx-sm-2 {
                scroll-margin-left: .46875rem !important;
                scroll-margin-right: .46875rem !important
            }

            .scroll-mx-sm-3 {
                scroll-margin-left: .624999375rem !important;
                scroll-margin-right: .624999375rem !important
            }

            .scroll-mx-sm-4 {
                scroll-margin-left: .9375rem !important;
                scroll-margin-right: .9375rem !important
            }

            .scroll-mx-sm-5 {
                scroll-margin-left: 1.2500000001rem !important;
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-mx-sm-6 {
                scroll-margin-left: 1.875rem !important;
                scroll-margin-right: 1.875rem !important
            }

            .scroll-mx-sm-7 {
                scroll-margin-left: 2.8125rem !important;
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-mx-sm-8 {
                scroll-margin-left: 3.75rem !important;
                scroll-margin-right: 3.75rem !important
            }

            .scroll-mx-sm-9 {
                scroll-margin-left: 5.625rem !important;
                scroll-margin-right: 5.625rem !important
            }

            .scroll-mx-sm-10 {
                scroll-margin-left: 8.4375rem !important;
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-mx-sm-auto {
                scroll-margin-left: auto !important;
                scroll-margin-right: auto !important
            }

            .scroll-my-sm-0 {
                scroll-margin-bottom: 0 !important;
                scroll-margin-top: 0 !important
            }

            .scroll-my-sm-1 {
                scroll-margin-bottom: .234375rem !important;
                scroll-margin-top: .234375rem !important
            }

            .scroll-my-sm-2 {
                scroll-margin-bottom: .46875rem !important;
                scroll-margin-top: .46875rem !important
            }

            .scroll-my-sm-3 {
                scroll-margin-bottom: .624999375rem !important;
                scroll-margin-top: .624999375rem !important
            }

            .scroll-my-sm-4 {
                scroll-margin-bottom: .9375rem !important;
                scroll-margin-top: .9375rem !important
            }

            .scroll-my-sm-5 {
                scroll-margin-bottom: 1.2500000001rem !important;
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-my-sm-6 {
                scroll-margin-bottom: 1.875rem !important;
                scroll-margin-top: 1.875rem !important
            }

            .scroll-my-sm-7 {
                scroll-margin-bottom: 2.8125rem !important;
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-my-sm-8 {
                scroll-margin-bottom: 3.75rem !important;
                scroll-margin-top: 3.75rem !important
            }

            .scroll-my-sm-9 {
                scroll-margin-bottom: 5.625rem !important;
                scroll-margin-top: 5.625rem !important
            }

            .scroll-my-sm-10 {
                scroll-margin-bottom: 8.4375rem !important;
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-my-sm-auto {
                scroll-margin-bottom: auto !important;
                scroll-margin-top: auto !important
            }

            .scroll-mt-sm-0 {
                scroll-margin-top: 0 !important
            }

            .scroll-mt-sm-1 {
                scroll-margin-top: .234375rem !important
            }

            .scroll-mt-sm-2 {
                scroll-margin-top: .46875rem !important
            }

            .scroll-mt-sm-3 {
                scroll-margin-top: .624999375rem !important
            }

            .scroll-mt-sm-4 {
                scroll-margin-top: .9375rem !important
            }

            .scroll-mt-sm-5 {
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-mt-sm-6 {
                scroll-margin-top: 1.875rem !important
            }

            .scroll-mt-sm-7 {
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-mt-sm-8 {
                scroll-margin-top: 3.75rem !important
            }

            .scroll-mt-sm-9 {
                scroll-margin-top: 5.625rem !important
            }

            .scroll-mt-sm-10 {
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-mt-sm-auto {
                scroll-margin-top: auto !important
            }

            .scroll-me-sm-0 {
                scroll-margin-right: 0 !important
            }

            .scroll-me-sm-1 {
                scroll-margin-right: .234375rem !important
            }

            .scroll-me-sm-2 {
                scroll-margin-right: .46875rem !important
            }

            .scroll-me-sm-3 {
                scroll-margin-right: .624999375rem !important
            }

            .scroll-me-sm-4 {
                scroll-margin-right: .9375rem !important
            }

            .scroll-me-sm-5 {
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-me-sm-6 {
                scroll-margin-right: 1.875rem !important
            }

            .scroll-me-sm-7 {
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-me-sm-8 {
                scroll-margin-right: 3.75rem !important
            }

            .scroll-me-sm-9 {
                scroll-margin-right: 5.625rem !important
            }

            .scroll-me-sm-10 {
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-me-sm-auto {
                scroll-margin-right: auto !important
            }

            .scroll-mb-sm-0 {
                scroll-margin-bottom: 0 !important
            }

            .scroll-mb-sm-1 {
                scroll-margin-bottom: .234375rem !important
            }

            .scroll-mb-sm-2 {
                scroll-margin-bottom: .46875rem !important
            }

            .scroll-mb-sm-3 {
                scroll-margin-bottom: .624999375rem !important
            }

            .scroll-mb-sm-4 {
                scroll-margin-bottom: .9375rem !important
            }

            .scroll-mb-sm-5 {
                scroll-margin-bottom: 1.2500000001rem !important
            }

            .scroll-mb-sm-6 {
                scroll-margin-bottom: 1.875rem !important
            }

            .scroll-mb-sm-7 {
                scroll-margin-bottom: 2.8125rem !important
            }

            .scroll-mb-sm-8 {
                scroll-margin-bottom: 3.75rem !important
            }

            .scroll-mb-sm-9 {
                scroll-margin-bottom: 5.625rem !important
            }

            .scroll-mb-sm-10 {
                scroll-margin-bottom: 8.4375rem !important
            }

            .scroll-mb-sm-auto {
                scroll-margin-bottom: auto !important
            }

            .scroll-ms-sm-0 {
                scroll-margin-left: 0 !important
            }

            .scroll-ms-sm-1 {
                scroll-margin-left: .234375rem !important
            }

            .scroll-ms-sm-2 {
                scroll-margin-left: .46875rem !important
            }

            .scroll-ms-sm-3 {
                scroll-margin-left: .624999375rem !important
            }

            .scroll-ms-sm-4 {
                scroll-margin-left: .9375rem !important
            }

            .scroll-ms-sm-5 {
                scroll-margin-left: 1.2500000001rem !important
            }

            .scroll-ms-sm-6 {
                scroll-margin-left: 1.875rem !important
            }

            .scroll-ms-sm-7 {
                scroll-margin-left: 2.8125rem !important
            }

            .scroll-ms-sm-8 {
                scroll-margin-left: 3.75rem !important
            }

            .scroll-ms-sm-9 {
                scroll-margin-left: 5.625rem !important
            }

            .scroll-ms-sm-10 {
                scroll-margin-left: 8.4375rem !important
            }

            .scroll-ms-sm-auto {
                scroll-margin-left: auto !important
            }

            .object-fit-sm-contain {
                -o-object-fit: contain !important;
                object-fit: contain !important
            }

            .object-fit-sm-cover {
                -o-object-fit: cover !important;
                object-fit: cover !important
            }

            .object-fit-sm-fill {
                -o-object-fit: fill !important;
                object-fit: fill !important
            }

            .object-fit-sm-scale {
                -o-object-fit: scale-down !important;
                object-fit: scale-down !important
            }

            .object-fit-sm-none {
                -o-object-fit: none !important;
                object-fit: none !important
            }
        }

        @media(min-width:768px) {
            .float-md-start {
                float: left !important
            }

            .float-md-end {
                float: right !important
            }

            .float-md-none {
                float: none !important
            }

            .d-md-inline {
                display: inline !important
            }

            .d-md-inline-block {
                display: inline-block !important
            }

            .d-md-block {
                display: block !important
            }

            .d-md-grid {
                display: grid !important
            }

            .d-md-table {
                display: table !important
            }

            .d-md-table-row {
                display: table-row !important
            }

            .d-md-table-cell {
                display: table-cell !important
            }

            .d-md-flex {
                display: flex !important
            }

            .d-md-inline-flex {
                display: inline-flex !important
            }

            .d-md-none {
                display: none !important
            }

            .position-md-static {
                position: static !important
            }

            .position-md-relative {
                position: relative !important
            }

            .position-md-absolute {
                position: absolute !important
            }

            .position-md-fixed {
                position: fixed !important
            }

            .position-md-sticky {
                position: -webkit-sticky !important;
                position: sticky !important
            }

            .w-md-unset {
                width: unset !important
            }

            .w-md-25 {
                width: 25% !important
            }

            .w-md-50 {
                width: 50% !important
            }

            .w-md-75 {
                width: 75% !important
            }

            .w-md-100 {
                width: 100% !important
            }

            .w-md-auto {
                width: auto !important
            }

            .w-md-1px {
                width: 1px !important
            }

            .w-md-2px {
                width: 2px !important
            }

            .w-md-3px {
                width: 3px !important
            }

            .w-md-4px {
                width: 4px !important
            }

            .w-md-5px {
                width: 5px !important
            }

            .w-md-6px {
                width: 6px !important
            }

            .w-md-7px {
                width: 7px !important
            }

            .w-md-8px {
                width: 8px !important
            }

            .w-md-9px {
                width: 9px !important
            }

            .w-md-10px {
                width: 10px !important
            }

            .w-md-15px {
                width: 15px !important
            }

            .w-md-20px {
                width: 20px !important
            }

            .w-md-25px {
                width: 25px !important
            }

            .w-md-30px {
                width: 30px !important
            }

            .w-md-35px {
                width: 35px !important
            }

            .w-md-40px {
                width: 40px !important
            }

            .w-md-45px {
                width: 45px !important
            }

            .w-md-50px {
                width: 50px !important
            }

            .w-md-55px {
                width: 55px !important
            }

            .w-md-60px {
                width: 60px !important
            }

            .w-md-65px {
                width: 65px !important
            }

            .w-md-70px {
                width: 70px !important
            }

            .w-md-75px {
                width: 75px !important
            }

            .w-md-80px {
                width: 80px !important
            }

            .w-md-85px {
                width: 85px !important
            }

            .w-md-90px {
                width: 90px !important
            }

            .w-md-95px {
                width: 95px !important
            }

            .w-md-100px {
                width: 100px !important
            }

            .w-md-125px {
                width: 125px !important
            }

            .w-md-150px {
                width: 150px !important
            }

            .w-md-175px {
                width: 175px !important
            }

            .w-md-200px {
                width: 200px !important
            }

            .w-md-225px {
                width: 225px !important
            }

            .w-md-250px {
                width: 250px !important
            }

            .w-md-275px {
                width: 275px !important
            }

            .w-md-300px {
                width: 300px !important
            }

            .w-md-325px {
                width: 325px !important
            }

            .w-md-350px {
                width: 350px !important
            }

            .w-md-375px {
                width: 375px !important
            }

            .w-md-400px {
                width: 400px !important
            }

            .w-md-425px {
                width: 425px !important
            }

            .w-md-450px {
                width: 450px !important
            }

            .w-md-475px {
                width: 475px !important
            }

            .w-md-500px {
                width: 500px !important
            }

            .w-md-550px {
                width: 550px !important
            }

            .w-md-600px {
                width: 600px !important
            }

            .w-md-650px {
                width: 650px !important
            }

            .w-md-700px {
                width: 700px !important
            }

            .w-md-750px {
                width: 750px !important
            }

            .w-md-800px {
                width: 800px !important
            }

            .w-md-850px {
                width: 850px !important
            }

            .w-md-900px {
                width: 900px !important
            }

            .w-md-950px {
                width: 950px !important
            }

            .w-md-1000px {
                width: 1000px !important
            }

            .mw-md-unset {
                max-width: unset !important
            }

            .mw-md-25 {
                max-width: 25% !important
            }

            .mw-md-50 {
                max-width: 50% !important
            }

            .mw-md-75 {
                max-width: 75% !important
            }

            .mw-md-100 {
                max-width: 100% !important
            }

            .mw-md-auto {
                max-width: auto !important
            }

            .mw-md-1px {
                max-width: 1px !important
            }

            .mw-md-2px {
                max-width: 2px !important
            }

            .mw-md-3px {
                max-width: 3px !important
            }

            .mw-md-4px {
                max-width: 4px !important
            }

            .mw-md-5px {
                max-width: 5px !important
            }

            .mw-md-6px {
                max-width: 6px !important
            }

            .mw-md-7px {
                max-width: 7px !important
            }

            .mw-md-8px {
                max-width: 8px !important
            }

            .mw-md-9px {
                max-width: 9px !important
            }

            .mw-md-10px {
                max-width: 10px !important
            }

            .mw-md-15px {
                max-width: 15px !important
            }

            .mw-md-20px {
                max-width: 20px !important
            }

            .mw-md-25px {
                max-width: 25px !important
            }

            .mw-md-30px {
                max-width: 30px !important
            }

            .mw-md-35px {
                max-width: 35px !important
            }

            .mw-md-40px {
                max-width: 40px !important
            }

            .mw-md-45px {
                max-width: 45px !important
            }

            .mw-md-50px {
                max-width: 50px !important
            }

            .mw-md-55px {
                max-width: 55px !important
            }

            .mw-md-60px {
                max-width: 60px !important
            }

            .mw-md-65px {
                max-width: 65px !important
            }

            .mw-md-70px {
                max-width: 70px !important
            }

            .mw-md-75px {
                max-width: 75px !important
            }

            .mw-md-80px {
                max-width: 80px !important
            }

            .mw-md-85px {
                max-width: 85px !important
            }

            .mw-md-90px {
                max-width: 90px !important
            }

            .mw-md-95px {
                max-width: 95px !important
            }

            .mw-md-100px {
                max-width: 100px !important
            }

            .mw-md-125px {
                max-width: 125px !important
            }

            .mw-md-150px {
                max-width: 150px !important
            }

            .mw-md-175px {
                max-width: 175px !important
            }

            .mw-md-200px {
                max-width: 200px !important
            }

            .mw-md-225px {
                max-width: 225px !important
            }

            .mw-md-250px {
                max-width: 250px !important
            }

            .mw-md-275px {
                max-width: 275px !important
            }

            .mw-md-300px {
                max-width: 300px !important
            }

            .mw-md-325px {
                max-width: 325px !important
            }

            .mw-md-350px {
                max-width: 350px !important
            }

            .mw-md-375px {
                max-width: 375px !important
            }

            .mw-md-400px {
                max-width: 400px !important
            }

            .mw-md-425px {
                max-width: 425px !important
            }

            .mw-md-450px {
                max-width: 450px !important
            }

            .mw-md-475px {
                max-width: 475px !important
            }

            .mw-md-500px {
                max-width: 500px !important
            }

            .mw-md-550px {
                max-width: 550px !important
            }

            .mw-md-600px {
                max-width: 600px !important
            }

            .mw-md-650px {
                max-width: 650px !important
            }

            .mw-md-700px {
                max-width: 700px !important
            }

            .mw-md-750px {
                max-width: 750px !important
            }

            .mw-md-800px {
                max-width: 800px !important
            }

            .mw-md-850px {
                max-width: 850px !important
            }

            .mw-md-900px {
                max-width: 900px !important
            }

            .mw-md-950px {
                max-width: 950px !important
            }

            .mw-md-1000px {
                max-width: 1000px !important
            }

            .vw-md-25 {
                width: 25vw !important
            }

            .vw-md-50 {
                width: 50vw !important
            }

            .vw-md-75 {
                width: 75vw !important
            }

            .vw-md-100 {
                width: 100vw !important
            }

            .vw-md-auto {
                width: auto !important
            }

            .min-vw-md-25 {
                min-width: 25vw !important
            }

            .min-vw-md-50 {
                min-width: 50vw !important
            }

            .min-vw-md-75 {
                min-width: 75vw !important
            }

            .min-vw-md-100 {
                min-width: 100vw !important
            }

            .min-vw-md-auto {
                min-width: auto !important
            }

            .h-md-unset {
                height: unset !important
            }

            .h-md-25 {
                height: 25% !important
            }

            .h-md-50 {
                height: 50% !important
            }

            .h-md-75 {
                height: 75% !important
            }

            .h-md-100 {
                height: 100% !important
            }

            .h-md-auto {
                height: auto !important
            }

            .h-md-1px {
                height: 1px !important
            }

            .h-md-2px {
                height: 2px !important
            }

            .h-md-3px {
                height: 3px !important
            }

            .h-md-4px {
                height: 4px !important
            }

            .h-md-5px {
                height: 5px !important
            }

            .h-md-6px {
                height: 6px !important
            }

            .h-md-7px {
                height: 7px !important
            }

            .h-md-8px {
                height: 8px !important
            }

            .h-md-9px {
                height: 9px !important
            }

            .h-md-10px {
                height: 10px !important
            }

            .h-md-15px {
                height: 15px !important
            }

            .h-md-20px {
                height: 20px !important
            }

            .h-md-25px {
                height: 25px !important
            }

            .h-md-30px {
                height: 30px !important
            }

            .h-md-35px {
                height: 35px !important
            }

            .h-md-40px {
                height: 40px !important
            }

            .h-md-45px {
                height: 45px !important
            }

            .h-md-50px {
                height: 50px !important
            }

            .h-md-55px {
                height: 55px !important
            }

            .h-md-60px {
                height: 60px !important
            }

            .h-md-65px {
                height: 65px !important
            }

            .h-md-70px {
                height: 70px !important
            }

            .h-md-75px {
                height: 75px !important
            }

            .h-md-80px {
                height: 80px !important
            }

            .h-md-85px {
                height: 85px !important
            }

            .h-md-90px {
                height: 90px !important
            }

            .h-md-95px {
                height: 95px !important
            }

            .h-md-100px {
                height: 100px !important
            }

            .h-md-125px {
                height: 125px !important
            }

            .h-md-150px {
                height: 150px !important
            }

            .h-md-175px {
                height: 175px !important
            }

            .h-md-200px {
                height: 200px !important
            }

            .h-md-225px {
                height: 225px !important
            }

            .h-md-250px {
                height: 250px !important
            }

            .h-md-275px {
                height: 275px !important
            }

            .h-md-300px {
                height: 300px !important
            }

            .h-md-325px {
                height: 325px !important
            }

            .h-md-350px {
                height: 350px !important
            }

            .h-md-375px {
                height: 375px !important
            }

            .h-md-400px {
                height: 400px !important
            }

            .h-md-425px {
                height: 425px !important
            }

            .h-md-450px {
                height: 450px !important
            }

            .h-md-475px {
                height: 475px !important
            }

            .h-md-500px {
                height: 500px !important
            }

            .h-md-550px {
                height: 550px !important
            }

            .h-md-600px {
                height: 600px !important
            }

            .h-md-650px {
                height: 650px !important
            }

            .h-md-700px {
                height: 700px !important
            }

            .h-md-750px {
                height: 750px !important
            }

            .h-md-800px {
                height: 800px !important
            }

            .h-md-850px {
                height: 850px !important
            }

            .h-md-900px {
                height: 900px !important
            }

            .h-md-950px {
                height: 950px !important
            }

            .h-md-1000px {
                height: 1000px !important
            }

            .mh-md-unset {
                max-height: unset !important
            }

            .mh-md-25 {
                max-height: 25% !important
            }

            .mh-md-50 {
                max-height: 50% !important
            }

            .mh-md-75 {
                max-height: 75% !important
            }

            .mh-md-100 {
                max-height: 100% !important
            }

            .mh-md-auto {
                max-height: auto !important
            }

            .mh-md-1px {
                max-height: 1px !important
            }

            .mh-md-2px {
                max-height: 2px !important
            }

            .mh-md-3px {
                max-height: 3px !important
            }

            .mh-md-4px {
                max-height: 4px !important
            }

            .mh-md-5px {
                max-height: 5px !important
            }

            .mh-md-6px {
                max-height: 6px !important
            }

            .mh-md-7px {
                max-height: 7px !important
            }

            .mh-md-8px {
                max-height: 8px !important
            }

            .mh-md-9px {
                max-height: 9px !important
            }

            .mh-md-10px {
                max-height: 10px !important
            }

            .mh-md-15px {
                max-height: 15px !important
            }

            .mh-md-20px {
                max-height: 20px !important
            }

            .mh-md-25px {
                max-height: 25px !important
            }

            .mh-md-30px {
                max-height: 30px !important
            }

            .mh-md-35px {
                max-height: 35px !important
            }

            .mh-md-40px {
                max-height: 40px !important
            }

            .mh-md-45px {
                max-height: 45px !important
            }

            .mh-md-50px {
                max-height: 50px !important
            }

            .mh-md-55px {
                max-height: 55px !important
            }

            .mh-md-60px {
                max-height: 60px !important
            }

            .mh-md-65px {
                max-height: 65px !important
            }

            .mh-md-70px {
                max-height: 70px !important
            }

            .mh-md-75px {
                max-height: 75px !important
            }

            .mh-md-80px {
                max-height: 80px !important
            }

            .mh-md-85px {
                max-height: 85px !important
            }

            .mh-md-90px {
                max-height: 90px !important
            }

            .mh-md-95px {
                max-height: 95px !important
            }

            .mh-md-100px {
                max-height: 100px !important
            }

            .mh-md-125px {
                max-height: 125px !important
            }

            .mh-md-150px {
                max-height: 150px !important
            }

            .mh-md-175px {
                max-height: 175px !important
            }

            .mh-md-200px {
                max-height: 200px !important
            }

            .mh-md-225px {
                max-height: 225px !important
            }

            .mh-md-250px {
                max-height: 250px !important
            }

            .mh-md-275px {
                max-height: 275px !important
            }

            .mh-md-300px {
                max-height: 300px !important
            }

            .mh-md-325px {
                max-height: 325px !important
            }

            .mh-md-350px {
                max-height: 350px !important
            }

            .mh-md-375px {
                max-height: 375px !important
            }

            .mh-md-400px {
                max-height: 400px !important
            }

            .mh-md-425px {
                max-height: 425px !important
            }

            .mh-md-450px {
                max-height: 450px !important
            }

            .mh-md-475px {
                max-height: 475px !important
            }

            .mh-md-500px {
                max-height: 500px !important
            }

            .mh-md-550px {
                max-height: 550px !important
            }

            .mh-md-600px {
                max-height: 600px !important
            }

            .mh-md-650px {
                max-height: 650px !important
            }

            .mh-md-700px {
                max-height: 700px !important
            }

            .mh-md-750px {
                max-height: 750px !important
            }

            .mh-md-800px {
                max-height: 800px !important
            }

            .mh-md-850px {
                max-height: 850px !important
            }

            .mh-md-900px {
                max-height: 900px !important
            }

            .mh-md-950px {
                max-height: 950px !important
            }

            .mh-md-1000px {
                max-height: 1000px !important
            }

            .vh-md-25 {
                height: 25vh !important
            }

            .vh-md-50 {
                height: 50vh !important
            }

            .vh-md-75 {
                height: 75vh !important
            }

            .vh-md-100 {
                height: 100vh !important
            }

            .vh-md-auto {
                height: auto !important
            }

            .min-vh-md-25 {
                min-height: 25vh !important
            }

            .min-vh-md-50 {
                min-height: 50vh !important
            }

            .min-vh-md-75 {
                min-height: 75vh !important
            }

            .min-vh-md-100 {
                min-height: 100vh !important
            }

            .min-vh-md-auto {
                min-height: auto !important
            }

            .flex-md-fill {
                flex: 1 1 auto !important
            }

            .flex-md-row {
                flex-direction: row !important
            }

            .flex-md-column {
                flex-direction: column !important
            }

            .flex-md-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-md-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-md-grow-0 {
                flex-grow: 0 !important
            }

            .flex-md-grow-1 {
                flex-grow: 1 !important
            }

            .flex-md-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-md-shrink-1 {
                flex-shrink: 1 !important
            }

            .flex-md-wrap {
                flex-wrap: wrap !important
            }

            .flex-md-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-md-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .justify-content-md-start {
                justify-content: flex-start !important
            }

            .justify-content-md-end {
                justify-content: flex-end !important
            }

            .justify-content-md-center {
                justify-content: center !important
            }

            .justify-content-md-between {
                justify-content: space-between !important
            }

            .justify-content-md-around {
                justify-content: space-around !important
            }

            .justify-content-md-evenly {
                justify-content: space-evenly !important
            }

            .align-items-md-start {
                align-items: flex-start !important
            }

            .align-items-md-end {
                align-items: flex-end !important
            }

            .align-items-md-center {
                align-items: center !important
            }

            .align-items-md-baseline {
                align-items: baseline !important
            }

            .align-items-md-stretch {
                align-items: stretch !important
            }

            .align-content-md-start {
                align-content: flex-start !important
            }

            .align-content-md-end {
                align-content: flex-end !important
            }

            .align-content-md-center {
                align-content: center !important
            }

            .align-content-md-between {
                align-content: space-between !important
            }

            .align-content-md-around {
                align-content: space-around !important
            }

            .align-content-md-stretch {
                align-content: stretch !important
            }

            .align-self-md-auto {
                align-self: auto !important
            }

            .align-self-md-start {
                align-self: flex-start !important
            }

            .align-self-md-end {
                align-self: flex-end !important
            }

            .align-self-md-center {
                align-self: center !important
            }

            .align-self-md-baseline {
                align-self: baseline !important
            }

            .align-self-md-stretch {
                align-self: stretch !important
            }

            .order-md-first {
                order: -1 !important
            }

            .order-md-0 {
                order: 0 !important
            }

            .order-md-1 {
                order: 1 !important
            }

            .order-md-2 {
                order: 2 !important
            }

            .order-md-3 {
                order: 3 !important
            }

            .order-md-4 {
                order: 4 !important
            }

            .order-md-5 {
                order: 5 !important
            }

            .order-md-last {
                order: 6 !important
            }

            .m-md-0 {
                margin: 0 !important
            }

            .m-md-1 {
                margin: .234375rem !important
            }

            .m-md-2 {
                margin: .46875rem !important
            }

            .m-md-3 {
                margin: .624999375rem !important
            }

            .m-md-4 {
                margin: .9375rem !important
            }

            .m-md-5 {
                margin: 1.2500000001rem !important
            }

            .m-md-6 {
                margin: 1.875rem !important
            }

            .m-md-7 {
                margin: 2.8125rem !important
            }

            .m-md-8 {
                margin: 3.75rem !important
            }

            .m-md-9 {
                margin: 5.625rem !important
            }

            .m-md-10 {
                margin: 8.4375rem !important
            }

            .m-md-auto {
                margin: auto !important
            }

            .mx-md-0 {
                margin-left: 0 !important;
                margin-right: 0 !important
            }

            .mx-md-1 {
                margin-left: .234375rem !important;
                margin-right: .234375rem !important
            }

            .mx-md-2 {
                margin-left: .46875rem !important;
                margin-right: .46875rem !important
            }

            .mx-md-3 {
                margin-left: .624999375rem !important;
                margin-right: .624999375rem !important
            }

            .mx-md-4 {
                margin-left: .9375rem !important;
                margin-right: .9375rem !important
            }

            .mx-md-5 {
                margin-left: 1.2500000001rem !important;
                margin-right: 1.2500000001rem !important
            }

            .mx-md-6 {
                margin-left: 1.875rem !important;
                margin-right: 1.875rem !important
            }

            .mx-md-7 {
                margin-left: 2.8125rem !important;
                margin-right: 2.8125rem !important
            }

            .mx-md-8 {
                margin-left: 3.75rem !important;
                margin-right: 3.75rem !important
            }

            .mx-md-9 {
                margin-left: 5.625rem !important;
                margin-right: 5.625rem !important
            }

            .mx-md-10 {
                margin-left: 8.4375rem !important;
                margin-right: 8.4375rem !important
            }

            .mx-md-auto {
                margin-left: auto !important;
                margin-right: auto !important
            }

            .my-md-0 {
                margin-bottom: 0 !important;
                margin-top: 0 !important
            }

            .my-md-1 {
                margin-bottom: .234375rem !important;
                margin-top: .234375rem !important
            }

            .my-md-2 {
                margin-bottom: .46875rem !important;
                margin-top: .46875rem !important
            }

            .my-md-3 {
                margin-bottom: .624999375rem !important;
                margin-top: .624999375rem !important
            }

            .my-md-4 {
                margin-bottom: .9375rem !important;
                margin-top: .9375rem !important
            }

            .my-md-5 {
                margin-bottom: 1.2500000001rem !important;
                margin-top: 1.2500000001rem !important
            }

            .my-md-6 {
                margin-bottom: 1.875rem !important;
                margin-top: 1.875rem !important
            }

            .my-md-7 {
                margin-bottom: 2.8125rem !important;
                margin-top: 2.8125rem !important
            }

            .my-md-8 {
                margin-bottom: 3.75rem !important;
                margin-top: 3.75rem !important
            }

            .my-md-9 {
                margin-bottom: 5.625rem !important;
                margin-top: 5.625rem !important
            }

            .my-md-10 {
                margin-bottom: 8.4375rem !important;
                margin-top: 8.4375rem !important
            }

            .my-md-auto {
                margin-bottom: auto !important;
                margin-top: auto !important
            }

            .mt-md-0 {
                margin-top: 0 !important
            }

            .mt-md-1 {
                margin-top: .234375rem !important
            }

            .mt-md-2 {
                margin-top: .46875rem !important
            }

            .mt-md-3 {
                margin-top: .624999375rem !important
            }

            .mt-md-4 {
                margin-top: .9375rem !important
            }

            .mt-md-5 {
                margin-top: 1.2500000001rem !important
            }

            .mt-md-6 {
                margin-top: 1.875rem !important
            }

            .mt-md-7 {
                margin-top: 2.8125rem !important
            }

            .mt-md-8 {
                margin-top: 3.75rem !important
            }

            .mt-md-9 {
                margin-top: 5.625rem !important
            }

            .mt-md-10 {
                margin-top: 8.4375rem !important
            }

            .mt-md-auto {
                margin-top: auto !important
            }

            .me-md-0 {
                margin-right: 0 !important
            }

            .me-md-1 {
                margin-right: .234375rem !important
            }

            .me-md-2 {
                margin-right: .46875rem !important
            }

            .me-md-3 {
                margin-right: .624999375rem !important
            }

            .me-md-4 {
                margin-right: .9375rem !important
            }

            .me-md-5 {
                margin-right: 1.2500000001rem !important
            }

            .me-md-6 {
                margin-right: 1.875rem !important
            }

            .me-md-7 {
                margin-right: 2.8125rem !important
            }

            .me-md-8 {
                margin-right: 3.75rem !important
            }

            .me-md-9 {
                margin-right: 5.625rem !important
            }

            .me-md-10 {
                margin-right: 8.4375rem !important
            }

            .me-md-auto {
                margin-right: auto !important
            }

            .mb-md-0 {
                margin-bottom: 0 !important
            }

            .mb-md-1 {
                margin-bottom: .234375rem !important
            }

            .mb-md-2 {
                margin-bottom: .46875rem !important
            }

            .mb-md-3 {
                margin-bottom: .624999375rem !important
            }

            .mb-md-4 {
                margin-bottom: .9375rem !important
            }

            .mb-md-5 {
                margin-bottom: 1.2500000001rem !important
            }

            .mb-md-6 {
                margin-bottom: 1.875rem !important
            }

            .mb-md-7 {
                margin-bottom: 2.8125rem !important
            }

            .mb-md-8 {
                margin-bottom: 3.75rem !important
            }

            .mb-md-9 {
                margin-bottom: 5.625rem !important
            }

            .mb-md-10 {
                margin-bottom: 8.4375rem !important
            }

            .mb-md-auto {
                margin-bottom: auto !important
            }

            .ms-md-0 {
                margin-left: 0 !important
            }

            .ms-md-1 {
                margin-left: .234375rem !important
            }

            .ms-md-2 {
                margin-left: .46875rem !important
            }

            .ms-md-3 {
                margin-left: .624999375rem !important
            }

            .ms-md-4 {
                margin-left: .9375rem !important
            }

            .ms-md-5 {
                margin-left: 1.2500000001rem !important
            }

            .ms-md-6 {
                margin-left: 1.875rem !important
            }

            .ms-md-7 {
                margin-left: 2.8125rem !important
            }

            .ms-md-8 {
                margin-left: 3.75rem !important
            }

            .ms-md-9 {
                margin-left: 5.625rem !important
            }

            .ms-md-10 {
                margin-left: 8.4375rem !important
            }

            .ms-md-auto {
                margin-left: auto !important
            }

            .m-md-n1 {
                margin: -.234375rem !important
            }

            .m-md-n2 {
                margin: -.46875rem !important
            }

            .m-md-n3 {
                margin: -.624999375rem !important
            }

            .m-md-n4 {
                margin: -.9375rem !important
            }

            .m-md-n5 {
                margin: -1.2500000001rem !important
            }

            .m-md-n6 {
                margin: -1.875rem !important
            }

            .m-md-n7 {
                margin: -2.8125rem !important
            }

            .m-md-n8 {
                margin: -3.75rem !important
            }

            .m-md-n9 {
                margin: -5.625rem !important
            }

            .m-md-n10 {
                margin: -8.4375rem !important
            }

            .mx-md-n1 {
                margin-left: -.234375rem !important;
                margin-right: -.234375rem !important
            }

            .mx-md-n2 {
                margin-left: -.46875rem !important;
                margin-right: -.46875rem !important
            }

            .mx-md-n3 {
                margin-left: -.624999375rem !important;
                margin-right: -.624999375rem !important
            }

            .mx-md-n4 {
                margin-left: -.9375rem !important;
                margin-right: -.9375rem !important
            }

            .mx-md-n5 {
                margin-left: -1.2500000001rem !important;
                margin-right: -1.2500000001rem !important
            }

            .mx-md-n6 {
                margin-left: -1.875rem !important;
                margin-right: -1.875rem !important
            }

            .mx-md-n7 {
                margin-left: -2.8125rem !important;
                margin-right: -2.8125rem !important
            }

            .mx-md-n8 {
                margin-left: -3.75rem !important;
                margin-right: -3.75rem !important
            }

            .mx-md-n9 {
                margin-left: -5.625rem !important;
                margin-right: -5.625rem !important
            }

            .mx-md-n10 {
                margin-left: -8.4375rem !important;
                margin-right: -8.4375rem !important
            }

            .my-md-n1 {
                margin-bottom: -.234375rem !important;
                margin-top: -.234375rem !important
            }

            .my-md-n2 {
                margin-bottom: -.46875rem !important;
                margin-top: -.46875rem !important
            }

            .my-md-n3 {
                margin-bottom: -.624999375rem !important;
                margin-top: -.624999375rem !important
            }

            .my-md-n4 {
                margin-bottom: -.9375rem !important;
                margin-top: -.9375rem !important
            }

            .my-md-n5 {
                margin-bottom: -1.2500000001rem !important;
                margin-top: -1.2500000001rem !important
            }

            .my-md-n6 {
                margin-bottom: -1.875rem !important;
                margin-top: -1.875rem !important
            }

            .my-md-n7 {
                margin-bottom: -2.8125rem !important;
                margin-top: -2.8125rem !important
            }

            .my-md-n8 {
                margin-bottom: -3.75rem !important;
                margin-top: -3.75rem !important
            }

            .my-md-n9 {
                margin-bottom: -5.625rem !important;
                margin-top: -5.625rem !important
            }

            .my-md-n10 {
                margin-bottom: -8.4375rem !important;
                margin-top: -8.4375rem !important
            }

            .mt-md-n1 {
                margin-top: -.234375rem !important
            }

            .mt-md-n2 {
                margin-top: -.46875rem !important
            }

            .mt-md-n3 {
                margin-top: -.624999375rem !important
            }

            .mt-md-n4 {
                margin-top: -.9375rem !important
            }

            .mt-md-n5 {
                margin-top: -1.2500000001rem !important
            }

            .mt-md-n6 {
                margin-top: -1.875rem !important
            }

            .mt-md-n7 {
                margin-top: -2.8125rem !important
            }

            .mt-md-n8 {
                margin-top: -3.75rem !important
            }

            .mt-md-n9 {
                margin-top: -5.625rem !important
            }

            .mt-md-n10 {
                margin-top: -8.4375rem !important
            }

            .me-md-n1 {
                margin-right: -.234375rem !important
            }

            .me-md-n2 {
                margin-right: -.46875rem !important
            }

            .me-md-n3 {
                margin-right: -.624999375rem !important
            }

            .me-md-n4 {
                margin-right: -.9375rem !important
            }

            .me-md-n5 {
                margin-right: -1.2500000001rem !important
            }

            .me-md-n6 {
                margin-right: -1.875rem !important
            }

            .me-md-n7 {
                margin-right: -2.8125rem !important
            }

            .me-md-n8 {
                margin-right: -3.75rem !important
            }

            .me-md-n9 {
                margin-right: -5.625rem !important
            }

            .me-md-n10 {
                margin-right: -8.4375rem !important
            }

            .mb-md-n1 {
                margin-bottom: -.234375rem !important
            }

            .mb-md-n2 {
                margin-bottom: -.46875rem !important
            }

            .mb-md-n3 {
                margin-bottom: -.624999375rem !important
            }

            .mb-md-n4 {
                margin-bottom: -.9375rem !important
            }

            .mb-md-n5 {
                margin-bottom: -1.2500000001rem !important
            }

            .mb-md-n6 {
                margin-bottom: -1.875rem !important
            }

            .mb-md-n7 {
                margin-bottom: -2.8125rem !important
            }

            .mb-md-n8 {
                margin-bottom: -3.75rem !important
            }

            .mb-md-n9 {
                margin-bottom: -5.625rem !important
            }

            .mb-md-n10 {
                margin-bottom: -8.4375rem !important
            }

            .ms-md-n1 {
                margin-left: -.234375rem !important
            }

            .ms-md-n2 {
                margin-left: -.46875rem !important
            }

            .ms-md-n3 {
                margin-left: -.624999375rem !important
            }

            .ms-md-n4 {
                margin-left: -.9375rem !important
            }

            .ms-md-n5 {
                margin-left: -1.2500000001rem !important
            }

            .ms-md-n6 {
                margin-left: -1.875rem !important
            }

            .ms-md-n7 {
                margin-left: -2.8125rem !important
            }

            .ms-md-n8 {
                margin-left: -3.75rem !important
            }

            .ms-md-n9 {
                margin-left: -5.625rem !important
            }

            .ms-md-n10 {
                margin-left: -8.4375rem !important
            }

            .p-md-0 {
                padding: 0 !important
            }

            .p-md-1 {
                padding: .234375rem !important
            }

            .p-md-2 {
                padding: .46875rem !important
            }

            .p-md-3 {
                padding: .624999375rem !important
            }

            .p-md-4 {
                padding: .9375rem !important
            }

            .p-md-5 {
                padding: 1.2500000001rem !important
            }

            .p-md-6 {
                padding: 1.875rem !important
            }

            .p-md-7 {
                padding: 2.8125rem !important
            }

            .p-md-8 {
                padding: 3.75rem !important
            }

            .p-md-9 {
                padding: 5.625rem !important
            }

            .p-md-10 {
                padding: 8.4375rem !important
            }

            .px-md-0 {
                padding-left: 0 !important;
                padding-right: 0 !important
            }

            .px-md-1 {
                padding-left: .234375rem !important;
                padding-right: .234375rem !important
            }

            .px-md-2 {
                padding-left: .46875rem !important;
                padding-right: .46875rem !important
            }

            .px-md-3 {
                padding-left: .624999375rem !important;
                padding-right: .624999375rem !important
            }

            .px-md-4 {
                padding-left: .9375rem !important;
                padding-right: .9375rem !important
            }

            .px-md-5 {
                padding-left: 1.2500000001rem !important;
                padding-right: 1.2500000001rem !important
            }

            .px-md-6 {
                padding-left: 1.875rem !important;
                padding-right: 1.875rem !important
            }

            .px-md-7 {
                padding-left: 2.8125rem !important;
                padding-right: 2.8125rem !important
            }

            .px-md-8 {
                padding-left: 3.75rem !important;
                padding-right: 3.75rem !important
            }

            .px-md-9 {
                padding-left: 5.625rem !important;
                padding-right: 5.625rem !important
            }

            .px-md-10 {
                padding-left: 8.4375rem !important;
                padding-right: 8.4375rem !important
            }

            .py-md-0 {
                padding-bottom: 0 !important;
                padding-top: 0 !important
            }

            .py-md-1 {
                padding-bottom: .234375rem !important;
                padding-top: .234375rem !important
            }

            .py-md-2 {
                padding-bottom: .46875rem !important;
                padding-top: .46875rem !important
            }

            .py-md-3 {
                padding-bottom: .624999375rem !important;
                padding-top: .624999375rem !important
            }

            .py-md-4 {
                padding-bottom: .9375rem !important;
                padding-top: .9375rem !important
            }

            .py-md-5 {
                padding-bottom: 1.2500000001rem !important;
                padding-top: 1.2500000001rem !important
            }

            .py-md-6 {
                padding-bottom: 1.875rem !important;
                padding-top: 1.875rem !important
            }

            .py-md-7 {
                padding-bottom: 2.8125rem !important;
                padding-top: 2.8125rem !important
            }

            .py-md-8 {
                padding-bottom: 3.75rem !important;
                padding-top: 3.75rem !important
            }

            .py-md-9 {
                padding-bottom: 5.625rem !important;
                padding-top: 5.625rem !important
            }

            .py-md-10 {
                padding-bottom: 8.4375rem !important;
                padding-top: 8.4375rem !important
            }

            .pt-md-0 {
                padding-top: 0 !important
            }

            .pt-md-1 {
                padding-top: .234375rem !important
            }

            .pt-md-2 {
                padding-top: .46875rem !important
            }

            .pt-md-3 {
                padding-top: .624999375rem !important
            }

            .pt-md-4 {
                padding-top: .9375rem !important
            }

            .pt-md-5 {
                padding-top: 1.2500000001rem !important
            }

            .pt-md-6 {
                padding-top: 1.875rem !important
            }

            .pt-md-7 {
                padding-top: 2.8125rem !important
            }

            .pt-md-8 {
                padding-top: 3.75rem !important
            }

            .pt-md-9 {
                padding-top: 5.625rem !important
            }

            .pt-md-10 {
                padding-top: 8.4375rem !important
            }

            .pe-md-0 {
                padding-right: 0 !important
            }

            .pe-md-1 {
                padding-right: .234375rem !important
            }

            .pe-md-2 {
                padding-right: .46875rem !important
            }

            .pe-md-3 {
                padding-right: .624999375rem !important
            }

            .pe-md-4 {
                padding-right: .9375rem !important
            }

            .pe-md-5 {
                padding-right: 1.2500000001rem !important
            }

            .pe-md-6 {
                padding-right: 1.875rem !important
            }

            .pe-md-7 {
                padding-right: 2.8125rem !important
            }

            .pe-md-8 {
                padding-right: 3.75rem !important
            }

            .pe-md-9 {
                padding-right: 5.625rem !important
            }

            .pe-md-10 {
                padding-right: 8.4375rem !important
            }

            .pb-md-0 {
                padding-bottom: 0 !important
            }

            .pb-md-1 {
                padding-bottom: .234375rem !important
            }

            .pb-md-2 {
                padding-bottom: .46875rem !important
            }

            .pb-md-3 {
                padding-bottom: .624999375rem !important
            }

            .pb-md-4 {
                padding-bottom: .9375rem !important
            }

            .pb-md-5 {
                padding-bottom: 1.2500000001rem !important
            }

            .pb-md-6 {
                padding-bottom: 1.875rem !important
            }

            .pb-md-7 {
                padding-bottom: 2.8125rem !important
            }

            .pb-md-8 {
                padding-bottom: 3.75rem !important
            }

            .pb-md-9 {
                padding-bottom: 5.625rem !important
            }

            .pb-md-10 {
                padding-bottom: 8.4375rem !important
            }

            .ps-md-0 {
                padding-left: 0 !important
            }

            .ps-md-1 {
                padding-left: .234375rem !important
            }

            .ps-md-2 {
                padding-left: .46875rem !important
            }

            .ps-md-3 {
                padding-left: .624999375rem !important
            }

            .ps-md-4 {
                padding-left: .9375rem !important
            }

            .ps-md-5 {
                padding-left: 1.2500000001rem !important
            }

            .ps-md-6 {
                padding-left: 1.875rem !important
            }

            .ps-md-7 {
                padding-left: 2.8125rem !important
            }

            .ps-md-8 {
                padding-left: 3.75rem !important
            }

            .ps-md-9 {
                padding-left: 5.625rem !important
            }

            .ps-md-10 {
                padding-left: 8.4375rem !important
            }

            .gap-md-0 {
                gap: 0 !important
            }

            .gap-md-1 {
                gap: .234375rem !important
            }

            .gap-md-2 {
                gap: .46875rem !important
            }

            .gap-md-3 {
                gap: .624999375rem !important
            }

            .gap-md-4 {
                gap: .9375rem !important
            }

            .gap-md-5 {
                gap: 1.2500000001rem !important
            }

            .gap-md-6 {
                gap: 1.875rem !important
            }

            .gap-md-7 {
                gap: 2.8125rem !important
            }

            .gap-md-8 {
                gap: 3.75rem !important
            }

            .gap-md-9 {
                gap: 5.625rem !important
            }

            .gap-md-10 {
                gap: 8.4375rem !important
            }

            .text-md-start {
                text-align: left !important
            }

            .text-md-end {
                text-align: right !important
            }

            .text-md-center {
                text-align: center !important
            }

            .min-w-md-unset {
                min-width: unset !important
            }

            .min-w-md-25 {
                min-width: 25% !important
            }

            .min-w-md-50 {
                min-width: 50% !important
            }

            .min-w-md-75 {
                min-width: 75% !important
            }

            .min-w-md-100 {
                min-width: 100% !important
            }

            .min-w-md-auto {
                min-width: auto !important
            }

            .min-w-md-1px {
                min-width: 1px !important
            }

            .min-w-md-2px {
                min-width: 2px !important
            }

            .min-w-md-3px {
                min-width: 3px !important
            }

            .min-w-md-4px {
                min-width: 4px !important
            }

            .min-w-md-5px {
                min-width: 5px !important
            }

            .min-w-md-6px {
                min-width: 6px !important
            }

            .min-w-md-7px {
                min-width: 7px !important
            }

            .min-w-md-8px {
                min-width: 8px !important
            }

            .min-w-md-9px {
                min-width: 9px !important
            }

            .min-w-md-10px {
                min-width: 10px !important
            }

            .min-w-md-15px {
                min-width: 15px !important
            }

            .min-w-md-20px {
                min-width: 20px !important
            }

            .min-w-md-25px {
                min-width: 25px !important
            }

            .min-w-md-30px {
                min-width: 30px !important
            }

            .min-w-md-35px {
                min-width: 35px !important
            }

            .min-w-md-40px {
                min-width: 40px !important
            }

            .min-w-md-45px {
                min-width: 45px !important
            }

            .min-w-md-50px {
                min-width: 50px !important
            }

            .min-w-md-55px {
                min-width: 55px !important
            }

            .min-w-md-60px {
                min-width: 60px !important
            }

            .min-w-md-65px {
                min-width: 65px !important
            }

            .min-w-md-70px {
                min-width: 70px !important
            }

            .min-w-md-75px {
                min-width: 75px !important
            }

            .min-w-md-80px {
                min-width: 80px !important
            }

            .min-w-md-85px {
                min-width: 85px !important
            }

            .min-w-md-90px {
                min-width: 90px !important
            }

            .min-w-md-95px {
                min-width: 95px !important
            }

            .min-w-md-100px {
                min-width: 100px !important
            }

            .min-w-md-125px {
                min-width: 125px !important
            }

            .min-w-md-150px {
                min-width: 150px !important
            }

            .min-w-md-175px {
                min-width: 175px !important
            }

            .min-w-md-200px {
                min-width: 200px !important
            }

            .min-w-md-225px {
                min-width: 225px !important
            }

            .min-w-md-250px {
                min-width: 250px !important
            }

            .min-w-md-275px {
                min-width: 275px !important
            }

            .min-w-md-300px {
                min-width: 300px !important
            }

            .min-w-md-325px {
                min-width: 325px !important
            }

            .min-w-md-350px {
                min-width: 350px !important
            }

            .min-w-md-375px {
                min-width: 375px !important
            }

            .min-w-md-400px {
                min-width: 400px !important
            }

            .min-w-md-425px {
                min-width: 425px !important
            }

            .min-w-md-450px {
                min-width: 450px !important
            }

            .min-w-md-475px {
                min-width: 475px !important
            }

            .min-w-md-500px {
                min-width: 500px !important
            }

            .min-w-md-550px {
                min-width: 550px !important
            }

            .min-w-md-600px {
                min-width: 600px !important
            }

            .min-w-md-650px {
                min-width: 650px !important
            }

            .min-w-md-700px {
                min-width: 700px !important
            }

            .min-w-md-750px {
                min-width: 750px !important
            }

            .min-w-md-800px {
                min-width: 800px !important
            }

            .min-w-md-850px {
                min-width: 850px !important
            }

            .min-w-md-900px {
                min-width: 900px !important
            }

            .min-w-md-950px {
                min-width: 950px !important
            }

            .min-w-md-1000px {
                min-width: 1000px !important
            }

            .min-h-md-unset {
                min-height: unset !important
            }

            .min-h-md-25 {
                min-height: 25% !important
            }

            .min-h-md-50 {
                min-height: 50% !important
            }

            .min-h-md-75 {
                min-height: 75% !important
            }

            .min-h-md-100 {
                min-height: 100% !important
            }

            .min-h-md-auto {
                min-height: auto !important
            }

            .min-h-md-1px {
                min-height: 1px !important
            }

            .min-h-md-2px {
                min-height: 2px !important
            }

            .min-h-md-3px {
                min-height: 3px !important
            }

            .min-h-md-4px {
                min-height: 4px !important
            }

            .min-h-md-5px {
                min-height: 5px !important
            }

            .min-h-md-6px {
                min-height: 6px !important
            }

            .min-h-md-7px {
                min-height: 7px !important
            }

            .min-h-md-8px {
                min-height: 8px !important
            }

            .min-h-md-9px {
                min-height: 9px !important
            }

            .min-h-md-10px {
                min-height: 10px !important
            }

            .min-h-md-15px {
                min-height: 15px !important
            }

            .min-h-md-20px {
                min-height: 20px !important
            }

            .min-h-md-25px {
                min-height: 25px !important
            }

            .min-h-md-30px {
                min-height: 30px !important
            }

            .min-h-md-35px {
                min-height: 35px !important
            }

            .min-h-md-40px {
                min-height: 40px !important
            }

            .min-h-md-45px {
                min-height: 45px !important
            }

            .min-h-md-50px {
                min-height: 50px !important
            }

            .min-h-md-55px {
                min-height: 55px !important
            }

            .min-h-md-60px {
                min-height: 60px !important
            }

            .min-h-md-65px {
                min-height: 65px !important
            }

            .min-h-md-70px {
                min-height: 70px !important
            }

            .min-h-md-75px {
                min-height: 75px !important
            }

            .min-h-md-80px {
                min-height: 80px !important
            }

            .min-h-md-85px {
                min-height: 85px !important
            }

            .min-h-md-90px {
                min-height: 90px !important
            }

            .min-h-md-95px {
                min-height: 95px !important
            }

            .min-h-md-100px {
                min-height: 100px !important
            }

            .min-h-md-125px {
                min-height: 125px !important
            }

            .min-h-md-150px {
                min-height: 150px !important
            }

            .min-h-md-175px {
                min-height: 175px !important
            }

            .min-h-md-200px {
                min-height: 200px !important
            }

            .min-h-md-225px {
                min-height: 225px !important
            }

            .min-h-md-250px {
                min-height: 250px !important
            }

            .min-h-md-275px {
                min-height: 275px !important
            }

            .min-h-md-300px {
                min-height: 300px !important
            }

            .min-h-md-325px {
                min-height: 325px !important
            }

            .min-h-md-350px {
                min-height: 350px !important
            }

            .min-h-md-375px {
                min-height: 375px !important
            }

            .min-h-md-400px {
                min-height: 400px !important
            }

            .min-h-md-425px {
                min-height: 425px !important
            }

            .min-h-md-450px {
                min-height: 450px !important
            }

            .min-h-md-475px {
                min-height: 475px !important
            }

            .min-h-md-500px {
                min-height: 500px !important
            }

            .min-h-md-550px {
                min-height: 550px !important
            }

            .min-h-md-600px {
                min-height: 600px !important
            }

            .min-h-md-650px {
                min-height: 650px !important
            }

            .min-h-md-700px {
                min-height: 700px !important
            }

            .min-h-md-750px {
                min-height: 750px !important
            }

            .min-h-md-800px {
                min-height: 800px !important
            }

            .min-h-md-850px {
                min-height: 850px !important
            }

            .min-h-md-900px {
                min-height: 900px !important
            }

            .min-h-md-950px {
                min-height: 950px !important
            }

            .min-h-md-1000px {
                min-height: 1000px !important
            }

            .scroll-m-md-0 {
                scroll-margin: 0 !important
            }

            .scroll-m-md-1 {
                scroll-margin: .234375rem !important
            }

            .scroll-m-md-2 {
                scroll-margin: .46875rem !important
            }

            .scroll-m-md-3 {
                scroll-margin: .624999375rem !important
            }

            .scroll-m-md-4 {
                scroll-margin: .9375rem !important
            }

            .scroll-m-md-5 {
                scroll-margin: 1.2500000001rem !important
            }

            .scroll-m-md-6 {
                scroll-margin: 1.875rem !important
            }

            .scroll-m-md-7 {
                scroll-margin: 2.8125rem !important
            }

            .scroll-m-md-8 {
                scroll-margin: 3.75rem !important
            }

            .scroll-m-md-9 {
                scroll-margin: 5.625rem !important
            }

            .scroll-m-md-10 {
                scroll-margin: 8.4375rem !important
            }

            .scroll-m-md-auto {
                scroll-margin: auto !important
            }

            .scroll-mx-md-0 {
                scroll-margin-left: 0 !important;
                scroll-margin-right: 0 !important
            }

            .scroll-mx-md-1 {
                scroll-margin-left: .234375rem !important;
                scroll-margin-right: .234375rem !important
            }

            .scroll-mx-md-2 {
                scroll-margin-left: .46875rem !important;
                scroll-margin-right: .46875rem !important
            }

            .scroll-mx-md-3 {
                scroll-margin-left: .624999375rem !important;
                scroll-margin-right: .624999375rem !important
            }

            .scroll-mx-md-4 {
                scroll-margin-left: .9375rem !important;
                scroll-margin-right: .9375rem !important
            }

            .scroll-mx-md-5 {
                scroll-margin-left: 1.2500000001rem !important;
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-mx-md-6 {
                scroll-margin-left: 1.875rem !important;
                scroll-margin-right: 1.875rem !important
            }

            .scroll-mx-md-7 {
                scroll-margin-left: 2.8125rem !important;
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-mx-md-8 {
                scroll-margin-left: 3.75rem !important;
                scroll-margin-right: 3.75rem !important
            }

            .scroll-mx-md-9 {
                scroll-margin-left: 5.625rem !important;
                scroll-margin-right: 5.625rem !important
            }

            .scroll-mx-md-10 {
                scroll-margin-left: 8.4375rem !important;
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-mx-md-auto {
                scroll-margin-left: auto !important;
                scroll-margin-right: auto !important
            }

            .scroll-my-md-0 {
                scroll-margin-bottom: 0 !important;
                scroll-margin-top: 0 !important
            }

            .scroll-my-md-1 {
                scroll-margin-bottom: .234375rem !important;
                scroll-margin-top: .234375rem !important
            }

            .scroll-my-md-2 {
                scroll-margin-bottom: .46875rem !important;
                scroll-margin-top: .46875rem !important
            }

            .scroll-my-md-3 {
                scroll-margin-bottom: .624999375rem !important;
                scroll-margin-top: .624999375rem !important
            }

            .scroll-my-md-4 {
                scroll-margin-bottom: .9375rem !important;
                scroll-margin-top: .9375rem !important
            }

            .scroll-my-md-5 {
                scroll-margin-bottom: 1.2500000001rem !important;
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-my-md-6 {
                scroll-margin-bottom: 1.875rem !important;
                scroll-margin-top: 1.875rem !important
            }

            .scroll-my-md-7 {
                scroll-margin-bottom: 2.8125rem !important;
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-my-md-8 {
                scroll-margin-bottom: 3.75rem !important;
                scroll-margin-top: 3.75rem !important
            }

            .scroll-my-md-9 {
                scroll-margin-bottom: 5.625rem !important;
                scroll-margin-top: 5.625rem !important
            }

            .scroll-my-md-10 {
                scroll-margin-bottom: 8.4375rem !important;
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-my-md-auto {
                scroll-margin-bottom: auto !important;
                scroll-margin-top: auto !important
            }

            .scroll-mt-md-0 {
                scroll-margin-top: 0 !important
            }

            .scroll-mt-md-1 {
                scroll-margin-top: .234375rem !important
            }

            .scroll-mt-md-2 {
                scroll-margin-top: .46875rem !important
            }

            .scroll-mt-md-3 {
                scroll-margin-top: .624999375rem !important
            }

            .scroll-mt-md-4 {
                scroll-margin-top: .9375rem !important
            }

            .scroll-mt-md-5 {
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-mt-md-6 {
                scroll-margin-top: 1.875rem !important
            }

            .scroll-mt-md-7 {
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-mt-md-8 {
                scroll-margin-top: 3.75rem !important
            }

            .scroll-mt-md-9 {
                scroll-margin-top: 5.625rem !important
            }

            .scroll-mt-md-10 {
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-mt-md-auto {
                scroll-margin-top: auto !important
            }

            .scroll-me-md-0 {
                scroll-margin-right: 0 !important
            }

            .scroll-me-md-1 {
                scroll-margin-right: .234375rem !important
            }

            .scroll-me-md-2 {
                scroll-margin-right: .46875rem !important
            }

            .scroll-me-md-3 {
                scroll-margin-right: .624999375rem !important
            }

            .scroll-me-md-4 {
                scroll-margin-right: .9375rem !important
            }

            .scroll-me-md-5 {
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-me-md-6 {
                scroll-margin-right: 1.875rem !important
            }

            .scroll-me-md-7 {
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-me-md-8 {
                scroll-margin-right: 3.75rem !important
            }

            .scroll-me-md-9 {
                scroll-margin-right: 5.625rem !important
            }

            .scroll-me-md-10 {
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-me-md-auto {
                scroll-margin-right: auto !important
            }

            .scroll-mb-md-0 {
                scroll-margin-bottom: 0 !important
            }

            .scroll-mb-md-1 {
                scroll-margin-bottom: .234375rem !important
            }

            .scroll-mb-md-2 {
                scroll-margin-bottom: .46875rem !important
            }

            .scroll-mb-md-3 {
                scroll-margin-bottom: .624999375rem !important
            }

            .scroll-mb-md-4 {
                scroll-margin-bottom: .9375rem !important
            }

            .scroll-mb-md-5 {
                scroll-margin-bottom: 1.2500000001rem !important
            }

            .scroll-mb-md-6 {
                scroll-margin-bottom: 1.875rem !important
            }

            .scroll-mb-md-7 {
                scroll-margin-bottom: 2.8125rem !important
            }

            .scroll-mb-md-8 {
                scroll-margin-bottom: 3.75rem !important
            }

            .scroll-mb-md-9 {
                scroll-margin-bottom: 5.625rem !important
            }

            .scroll-mb-md-10 {
                scroll-margin-bottom: 8.4375rem !important
            }

            .scroll-mb-md-auto {
                scroll-margin-bottom: auto !important
            }

            .scroll-ms-md-0 {
                scroll-margin-left: 0 !important
            }

            .scroll-ms-md-1 {
                scroll-margin-left: .234375rem !important
            }

            .scroll-ms-md-2 {
                scroll-margin-left: .46875rem !important
            }

            .scroll-ms-md-3 {
                scroll-margin-left: .624999375rem !important
            }

            .scroll-ms-md-4 {
                scroll-margin-left: .9375rem !important
            }

            .scroll-ms-md-5 {
                scroll-margin-left: 1.2500000001rem !important
            }

            .scroll-ms-md-6 {
                scroll-margin-left: 1.875rem !important
            }

            .scroll-ms-md-7 {
                scroll-margin-left: 2.8125rem !important
            }

            .scroll-ms-md-8 {
                scroll-margin-left: 3.75rem !important
            }

            .scroll-ms-md-9 {
                scroll-margin-left: 5.625rem !important
            }

            .scroll-ms-md-10 {
                scroll-margin-left: 8.4375rem !important
            }

            .scroll-ms-md-auto {
                scroll-margin-left: auto !important
            }

            .object-fit-md-contain {
                -o-object-fit: contain !important;
                object-fit: contain !important
            }

            .object-fit-md-cover {
                -o-object-fit: cover !important;
                object-fit: cover !important
            }

            .object-fit-md-fill {
                -o-object-fit: fill !important;
                object-fit: fill !important
            }

            .object-fit-md-scale {
                -o-object-fit: scale-down !important;
                object-fit: scale-down !important
            }

            .object-fit-md-none {
                -o-object-fit: none !important;
                object-fit: none !important
            }
        }

        @media(min-width:992px) {
            .float-lg-start {
                float: left !important
            }

            .float-lg-end {
                float: right !important
            }

            .float-lg-none {
                float: none !important
            }

            .d-lg-inline {
                display: inline !important
            }

            .d-lg-inline-block {
                display: inline-block !important
            }

            .d-lg-block {
                display: block !important
            }

            .d-lg-grid {
                display: grid !important
            }

            .d-lg-table {
                display: table !important
            }

            .d-lg-table-row {
                display: table-row !important
            }

            .d-lg-table-cell {
                display: table-cell !important
            }

            .d-lg-flex {
                display: flex !important
            }

            .d-lg-inline-flex {
                display: inline-flex !important
            }

            .d-lg-none {
                display: none !important
            }

            .position-lg-static {
                position: static !important
            }

            .position-lg-relative {
                position: relative !important
            }

            .position-lg-absolute {
                position: absolute !important
            }

            .position-lg-fixed {
                position: fixed !important
            }

            .position-lg-sticky {
                position: -webkit-sticky !important;
                position: sticky !important
            }

            .w-lg-unset {
                width: unset !important
            }

            .w-lg-25 {
                width: 25% !important
            }

            .w-lg-50 {
                width: 50% !important
            }

            .w-lg-75 {
                width: 75% !important
            }

            .w-lg-100 {
                width: 100% !important
            }

            .w-lg-auto {
                width: auto !important
            }

            .w-lg-1px {
                width: 1px !important
            }

            .w-lg-2px {
                width: 2px !important
            }

            .w-lg-3px {
                width: 3px !important
            }

            .w-lg-4px {
                width: 4px !important
            }

            .w-lg-5px {
                width: 5px !important
            }

            .w-lg-6px {
                width: 6px !important
            }

            .w-lg-7px {
                width: 7px !important
            }

            .w-lg-8px {
                width: 8px !important
            }

            .w-lg-9px {
                width: 9px !important
            }

            .w-lg-10px {
                width: 10px !important
            }

            .w-lg-15px {
                width: 15px !important
            }

            .w-lg-20px {
                width: 20px !important
            }

            .w-lg-25px {
                width: 25px !important
            }

            .w-lg-30px {
                width: 30px !important
            }

            .w-lg-35px {
                width: 35px !important
            }

            .w-lg-40px {
                width: 40px !important
            }

            .w-lg-45px {
                width: 45px !important
            }

            .w-lg-50px {
                width: 50px !important
            }

            .w-lg-55px {
                width: 55px !important
            }

            .w-lg-60px {
                width: 60px !important
            }

            .w-lg-65px {
                width: 65px !important
            }

            .w-lg-70px {
                width: 70px !important
            }

            .w-lg-75px {
                width: 75px !important
            }

            .w-lg-80px {
                width: 80px !important
            }

            .w-lg-85px {
                width: 85px !important
            }

            .w-lg-90px {
                width: 90px !important
            }

            .w-lg-95px {
                width: 95px !important
            }

            .w-lg-100px {
                width: 100px !important
            }

            .w-lg-125px {
                width: 125px !important
            }

            .w-lg-150px {
                width: 150px !important
            }

            .w-lg-175px {
                width: 175px !important
            }

            .w-lg-200px {
                width: 200px !important
            }

            .w-lg-225px {
                width: 225px !important
            }

            .w-lg-250px {
                width: 250px !important
            }

            .w-lg-275px {
                width: 275px !important
            }

            .w-lg-300px {
                width: 300px !important
            }

            .w-lg-325px {
                width: 325px !important
            }

            .w-lg-350px {
                width: 350px !important
            }

            .w-lg-375px {
                width: 375px !important
            }

            .w-lg-400px {
                width: 400px !important
            }

            .w-lg-425px {
                width: 425px !important
            }

            .w-lg-450px {
                width: 450px !important
            }

            .w-lg-475px {
                width: 475px !important
            }

            .w-lg-500px {
                width: 500px !important
            }

            .w-lg-550px {
                width: 550px !important
            }

            .w-lg-600px {
                width: 600px !important
            }

            .w-lg-650px {
                width: 650px !important
            }

            .w-lg-700px {
                width: 700px !important
            }

            .w-lg-750px {
                width: 750px !important
            }

            .w-lg-800px {
                width: 800px !important
            }

            .w-lg-850px {
                width: 850px !important
            }

            .w-lg-900px {
                width: 900px !important
            }

            .w-lg-950px {
                width: 950px !important
            }

            .w-lg-1000px {
                width: 1000px !important
            }

            .mw-lg-unset {
                max-width: unset !important
            }

            .mw-lg-25 {
                max-width: 25% !important
            }

            .mw-lg-50 {
                max-width: 50% !important
            }

            .mw-lg-75 {
                max-width: 75% !important
            }

            .mw-lg-100 {
                max-width: 100% !important
            }

            .mw-lg-auto {
                max-width: auto !important
            }

            .mw-lg-1px {
                max-width: 1px !important
            }

            .mw-lg-2px {
                max-width: 2px !important
            }

            .mw-lg-3px {
                max-width: 3px !important
            }

            .mw-lg-4px {
                max-width: 4px !important
            }

            .mw-lg-5px {
                max-width: 5px !important
            }

            .mw-lg-6px {
                max-width: 6px !important
            }

            .mw-lg-7px {
                max-width: 7px !important
            }

            .mw-lg-8px {
                max-width: 8px !important
            }

            .mw-lg-9px {
                max-width: 9px !important
            }

            .mw-lg-10px {
                max-width: 10px !important
            }

            .mw-lg-15px {
                max-width: 15px !important
            }

            .mw-lg-20px {
                max-width: 20px !important
            }

            .mw-lg-25px {
                max-width: 25px !important
            }

            .mw-lg-30px {
                max-width: 30px !important
            }

            .mw-lg-35px {
                max-width: 35px !important
            }

            .mw-lg-40px {
                max-width: 40px !important
            }

            .mw-lg-45px {
                max-width: 45px !important
            }

            .mw-lg-50px {
                max-width: 50px !important
            }

            .mw-lg-55px {
                max-width: 55px !important
            }

            .mw-lg-60px {
                max-width: 60px !important
            }

            .mw-lg-65px {
                max-width: 65px !important
            }

            .mw-lg-70px {
                max-width: 70px !important
            }

            .mw-lg-75px {
                max-width: 75px !important
            }

            .mw-lg-80px {
                max-width: 80px !important
            }

            .mw-lg-85px {
                max-width: 85px !important
            }

            .mw-lg-90px {
                max-width: 90px !important
            }

            .mw-lg-95px {
                max-width: 95px !important
            }

            .mw-lg-100px {
                max-width: 100px !important
            }

            .mw-lg-125px {
                max-width: 125px !important
            }

            .mw-lg-150px {
                max-width: 150px !important
            }

            .mw-lg-175px {
                max-width: 175px !important
            }

            .mw-lg-200px {
                max-width: 200px !important
            }

            .mw-lg-225px {
                max-width: 225px !important
            }

            .mw-lg-250px {
                max-width: 250px !important
            }

            .mw-lg-275px {
                max-width: 275px !important
            }

            .mw-lg-300px {
                max-width: 300px !important
            }

            .mw-lg-325px {
                max-width: 325px !important
            }

            .mw-lg-350px {
                max-width: 350px !important
            }

            .mw-lg-375px {
                max-width: 375px !important
            }

            .mw-lg-400px {
                max-width: 400px !important
            }

            .mw-lg-425px {
                max-width: 425px !important
            }

            .mw-lg-450px {
                max-width: 450px !important
            }

            .mw-lg-475px {
                max-width: 475px !important
            }

            .mw-lg-500px {
                max-width: 500px !important
            }

            .mw-lg-550px {
                max-width: 550px !important
            }

            .mw-lg-600px {
                max-width: 600px !important
            }

            .mw-lg-650px {
                max-width: 650px !important
            }

            .mw-lg-700px {
                max-width: 700px !important
            }

            .mw-lg-750px {
                max-width: 750px !important
            }

            .mw-lg-800px {
                max-width: 800px !important
            }

            .mw-lg-850px {
                max-width: 850px !important
            }

            .mw-lg-900px {
                max-width: 900px !important
            }

            .mw-lg-950px {
                max-width: 950px !important
            }

            .mw-lg-1000px {
                max-width: 1000px !important
            }

            .vw-lg-25 {
                width: 25vw !important
            }

            .vw-lg-50 {
                width: 50vw !important
            }

            .vw-lg-75 {
                width: 75vw !important
            }

            .vw-lg-100 {
                width: 100vw !important
            }

            .vw-lg-auto {
                width: auto !important
            }

            .min-vw-lg-25 {
                min-width: 25vw !important
            }

            .min-vw-lg-50 {
                min-width: 50vw !important
            }

            .min-vw-lg-75 {
                min-width: 75vw !important
            }

            .min-vw-lg-100 {
                min-width: 100vw !important
            }

            .min-vw-lg-auto {
                min-width: auto !important
            }

            .h-lg-unset {
                height: unset !important
            }

            .h-lg-25 {
                height: 25% !important
            }

            .h-lg-50 {
                height: 50% !important
            }

            .h-lg-75 {
                height: 75% !important
            }

            .h-lg-100 {
                height: 100% !important
            }

            .h-lg-auto {
                height: auto !important
            }

            .h-lg-1px {
                height: 1px !important
            }

            .h-lg-2px {
                height: 2px !important
            }

            .h-lg-3px {
                height: 3px !important
            }

            .h-lg-4px {
                height: 4px !important
            }

            .h-lg-5px {
                height: 5px !important
            }

            .h-lg-6px {
                height: 6px !important
            }

            .h-lg-7px {
                height: 7px !important
            }

            .h-lg-8px {
                height: 8px !important
            }

            .h-lg-9px {
                height: 9px !important
            }

            .h-lg-10px {
                height: 10px !important
            }

            .h-lg-15px {
                height: 15px !important
            }

            .h-lg-20px {
                height: 20px !important
            }

            .h-lg-25px {
                height: 25px !important
            }

            .h-lg-30px {
                height: 30px !important
            }

            .h-lg-35px {
                height: 35px !important
            }

            .h-lg-40px {
                height: 40px !important
            }

            .h-lg-45px {
                height: 45px !important
            }

            .h-lg-50px {
                height: 50px !important
            }

            .h-lg-55px {
                height: 55px !important
            }

            .h-lg-60px {
                height: 60px !important
            }

            .h-lg-65px {
                height: 65px !important
            }

            .h-lg-70px {
                height: 70px !important
            }

            .h-lg-75px {
                height: 75px !important
            }

            .h-lg-80px {
                height: 80px !important
            }

            .h-lg-85px {
                height: 85px !important
            }

            .h-lg-90px {
                height: 90px !important
            }

            .h-lg-95px {
                height: 95px !important
            }

            .h-lg-100px {
                height: 100px !important
            }

            .h-lg-125px {
                height: 125px !important
            }

            .h-lg-150px {
                height: 150px !important
            }

            .h-lg-175px {
                height: 175px !important
            }

            .h-lg-200px {
                height: 200px !important
            }

            .h-lg-225px {
                height: 225px !important
            }

            .h-lg-250px {
                height: 250px !important
            }

            .h-lg-275px {
                height: 275px !important
            }

            .h-lg-300px {
                height: 300px !important
            }

            .h-lg-325px {
                height: 325px !important
            }

            .h-lg-350px {
                height: 350px !important
            }

            .h-lg-375px {
                height: 375px !important
            }

            .h-lg-400px {
                height: 400px !important
            }

            .h-lg-425px {
                height: 425px !important
            }

            .h-lg-450px {
                height: 450px !important
            }

            .h-lg-475px {
                height: 475px !important
            }

            .h-lg-500px {
                height: 500px !important
            }

            .h-lg-550px {
                height: 550px !important
            }

            .h-lg-600px {
                height: 600px !important
            }

            .h-lg-650px {
                height: 650px !important
            }

            .h-lg-700px {
                height: 700px !important
            }

            .h-lg-750px {
                height: 750px !important
            }

            .h-lg-800px {
                height: 800px !important
            }

            .h-lg-850px {
                height: 850px !important
            }

            .h-lg-900px {
                height: 900px !important
            }

            .h-lg-950px {
                height: 950px !important
            }

            .h-lg-1000px {
                height: 1000px !important
            }

            .mh-lg-unset {
                max-height: unset !important
            }

            .mh-lg-25 {
                max-height: 25% !important
            }

            .mh-lg-50 {
                max-height: 50% !important
            }

            .mh-lg-75 {
                max-height: 75% !important
            }

            .mh-lg-100 {
                max-height: 100% !important
            }

            .mh-lg-auto {
                max-height: auto !important
            }

            .mh-lg-1px {
                max-height: 1px !important
            }

            .mh-lg-2px {
                max-height: 2px !important
            }

            .mh-lg-3px {
                max-height: 3px !important
            }

            .mh-lg-4px {
                max-height: 4px !important
            }

            .mh-lg-5px {
                max-height: 5px !important
            }

            .mh-lg-6px {
                max-height: 6px !important
            }

            .mh-lg-7px {
                max-height: 7px !important
            }

            .mh-lg-8px {
                max-height: 8px !important
            }

            .mh-lg-9px {
                max-height: 9px !important
            }

            .mh-lg-10px {
                max-height: 10px !important
            }

            .mh-lg-15px {
                max-height: 15px !important
            }

            .mh-lg-20px {
                max-height: 20px !important
            }

            .mh-lg-25px {
                max-height: 25px !important
            }

            .mh-lg-30px {
                max-height: 30px !important
            }

            .mh-lg-35px {
                max-height: 35px !important
            }

            .mh-lg-40px {
                max-height: 40px !important
            }

            .mh-lg-45px {
                max-height: 45px !important
            }

            .mh-lg-50px {
                max-height: 50px !important
            }

            .mh-lg-55px {
                max-height: 55px !important
            }

            .mh-lg-60px {
                max-height: 60px !important
            }

            .mh-lg-65px {
                max-height: 65px !important
            }

            .mh-lg-70px {
                max-height: 70px !important
            }

            .mh-lg-75px {
                max-height: 75px !important
            }

            .mh-lg-80px {
                max-height: 80px !important
            }

            .mh-lg-85px {
                max-height: 85px !important
            }

            .mh-lg-90px {
                max-height: 90px !important
            }

            .mh-lg-95px {
                max-height: 95px !important
            }

            .mh-lg-100px {
                max-height: 100px !important
            }

            .mh-lg-125px {
                max-height: 125px !important
            }

            .mh-lg-150px {
                max-height: 150px !important
            }

            .mh-lg-175px {
                max-height: 175px !important
            }

            .mh-lg-200px {
                max-height: 200px !important
            }

            .mh-lg-225px {
                max-height: 225px !important
            }

            .mh-lg-250px {
                max-height: 250px !important
            }

            .mh-lg-275px {
                max-height: 275px !important
            }

            .mh-lg-300px {
                max-height: 300px !important
            }

            .mh-lg-325px {
                max-height: 325px !important
            }

            .mh-lg-350px {
                max-height: 350px !important
            }

            .mh-lg-375px {
                max-height: 375px !important
            }

            .mh-lg-400px {
                max-height: 400px !important
            }

            .mh-lg-425px {
                max-height: 425px !important
            }

            .mh-lg-450px {
                max-height: 450px !important
            }

            .mh-lg-475px {
                max-height: 475px !important
            }

            .mh-lg-500px {
                max-height: 500px !important
            }

            .mh-lg-550px {
                max-height: 550px !important
            }

            .mh-lg-600px {
                max-height: 600px !important
            }

            .mh-lg-650px {
                max-height: 650px !important
            }

            .mh-lg-700px {
                max-height: 700px !important
            }

            .mh-lg-750px {
                max-height: 750px !important
            }

            .mh-lg-800px {
                max-height: 800px !important
            }

            .mh-lg-850px {
                max-height: 850px !important
            }

            .mh-lg-900px {
                max-height: 900px !important
            }

            .mh-lg-950px {
                max-height: 950px !important
            }

            .mh-lg-1000px {
                max-height: 1000px !important
            }

            .vh-lg-25 {
                height: 25vh !important
            }

            .vh-lg-50 {
                height: 50vh !important
            }

            .vh-lg-75 {
                height: 75vh !important
            }

            .vh-lg-100 {
                height: 100vh !important
            }

            .vh-lg-auto {
                height: auto !important
            }

            .min-vh-lg-25 {
                min-height: 25vh !important
            }

            .min-vh-lg-50 {
                min-height: 50vh !important
            }

            .min-vh-lg-75 {
                min-height: 75vh !important
            }

            .min-vh-lg-100 {
                min-height: 100vh !important
            }

            .min-vh-lg-auto {
                min-height: auto !important
            }

            .flex-lg-fill {
                flex: 1 1 auto !important
            }

            .flex-lg-row {
                flex-direction: row !important
            }

            .flex-lg-column {
                flex-direction: column !important
            }

            .flex-lg-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-lg-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-lg-grow-0 {
                flex-grow: 0 !important
            }

            .flex-lg-grow-1 {
                flex-grow: 1 !important
            }

            .flex-lg-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-lg-shrink-1 {
                flex-shrink: 1 !important
            }

            .flex-lg-wrap {
                flex-wrap: wrap !important
            }

            .flex-lg-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-lg-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .justify-content-lg-start {
                justify-content: flex-start !important
            }

            .justify-content-lg-end {
                justify-content: flex-end !important
            }

            .justify-content-lg-center {
                justify-content: center !important
            }

            .justify-content-lg-between {
                justify-content: space-between !important
            }

            .justify-content-lg-around {
                justify-content: space-around !important
            }

            .justify-content-lg-evenly {
                justify-content: space-evenly !important
            }

            .align-items-lg-start {
                align-items: flex-start !important
            }

            .align-items-lg-end {
                align-items: flex-end !important
            }

            .align-items-lg-center {
                align-items: center !important
            }

            .align-items-lg-baseline {
                align-items: baseline !important
            }

            .align-items-lg-stretch {
                align-items: stretch !important
            }

            .align-content-lg-start {
                align-content: flex-start !important
            }

            .align-content-lg-end {
                align-content: flex-end !important
            }

            .align-content-lg-center {
                align-content: center !important
            }

            .align-content-lg-between {
                align-content: space-between !important
            }

            .align-content-lg-around {
                align-content: space-around !important
            }

            .align-content-lg-stretch {
                align-content: stretch !important
            }

            .align-self-lg-auto {
                align-self: auto !important
            }

            .align-self-lg-start {
                align-self: flex-start !important
            }

            .align-self-lg-end {
                align-self: flex-end !important
            }

            .align-self-lg-center {
                align-self: center !important
            }

            .align-self-lg-baseline {
                align-self: baseline !important
            }

            .align-self-lg-stretch {
                align-self: stretch !important
            }

            .order-lg-first {
                order: -1 !important
            }

            .order-lg-0 {
                order: 0 !important
            }

            .order-lg-1 {
                order: 1 !important
            }

            .order-lg-2 {
                order: 2 !important
            }

            .order-lg-3 {
                order: 3 !important
            }

            .order-lg-4 {
                order: 4 !important
            }

            .order-lg-5 {
                order: 5 !important
            }

            .order-lg-last {
                order: 6 !important
            }

            .m-lg-0 {
                margin: 0 !important
            }

            .m-lg-1 {
                margin: .234375rem !important
            }

            .m-lg-2 {
                margin: .46875rem !important
            }

            .m-lg-3 {
                margin: .624999375rem !important
            }

            .m-lg-4 {
                margin: .9375rem !important
            }

            .m-lg-5 {
                margin: 1.2500000001rem !important
            }

            .m-lg-6 {
                margin: 1.875rem !important
            }

            .m-lg-7 {
                margin: 2.8125rem !important
            }

            .m-lg-8 {
                margin: 3.75rem !important
            }

            .m-lg-9 {
                margin: 5.625rem !important
            }

            .m-lg-10 {
                margin: 8.4375rem !important
            }

            .m-lg-auto {
                margin: auto !important
            }

            .mx-lg-0 {
                margin-left: 0 !important;
                margin-right: 0 !important
            }

            .mx-lg-1 {
                margin-left: .234375rem !important;
                margin-right: .234375rem !important
            }

            .mx-lg-2 {
                margin-left: .46875rem !important;
                margin-right: .46875rem !important
            }

            .mx-lg-3 {
                margin-left: .624999375rem !important;
                margin-right: .624999375rem !important
            }

            .mx-lg-4 {
                margin-left: .9375rem !important;
                margin-right: .9375rem !important
            }

            .mx-lg-5 {
                margin-left: 1.2500000001rem !important;
                margin-right: 1.2500000001rem !important
            }

            .mx-lg-6 {
                margin-left: 1.875rem !important;
                margin-right: 1.875rem !important
            }

            .mx-lg-7 {
                margin-left: 2.8125rem !important;
                margin-right: 2.8125rem !important
            }

            .mx-lg-8 {
                margin-left: 3.75rem !important;
                margin-right: 3.75rem !important
            }

            .mx-lg-9 {
                margin-left: 5.625rem !important;
                margin-right: 5.625rem !important
            }

            .mx-lg-10 {
                margin-left: 8.4375rem !important;
                margin-right: 8.4375rem !important
            }

            .mx-lg-auto {
                margin-left: auto !important;
                margin-right: auto !important
            }

            .my-lg-0 {
                margin-bottom: 0 !important;
                margin-top: 0 !important
            }

            .my-lg-1 {
                margin-bottom: .234375rem !important;
                margin-top: .234375rem !important
            }

            .my-lg-2 {
                margin-bottom: .46875rem !important;
                margin-top: .46875rem !important
            }

            .my-lg-3 {
                margin-bottom: .624999375rem !important;
                margin-top: .624999375rem !important
            }

            .my-lg-4 {
                margin-bottom: .9375rem !important;
                margin-top: .9375rem !important
            }

            .my-lg-5 {
                margin-bottom: 1.2500000001rem !important;
                margin-top: 1.2500000001rem !important
            }

            .my-lg-6 {
                margin-bottom: 1.875rem !important;
                margin-top: 1.875rem !important
            }

            .my-lg-7 {
                margin-bottom: 2.8125rem !important;
                margin-top: 2.8125rem !important
            }

            .my-lg-8 {
                margin-bottom: 3.75rem !important;
                margin-top: 3.75rem !important
            }

            .my-lg-9 {
                margin-bottom: 5.625rem !important;
                margin-top: 5.625rem !important
            }

            .my-lg-10 {
                margin-bottom: 8.4375rem !important;
                margin-top: 8.4375rem !important
            }

            .my-lg-auto {
                margin-bottom: auto !important;
                margin-top: auto !important
            }

            .mt-lg-0 {
                margin-top: 0 !important
            }

            .mt-lg-1 {
                margin-top: .234375rem !important
            }

            .mt-lg-2 {
                margin-top: .46875rem !important
            }

            .mt-lg-3 {
                margin-top: .624999375rem !important
            }

            .mt-lg-4 {
                margin-top: .9375rem !important
            }

            .mt-lg-5 {
                margin-top: 1.2500000001rem !important
            }

            .mt-lg-6 {
                margin-top: 1.875rem !important
            }

            .mt-lg-7 {
                margin-top: 2.8125rem !important
            }

            .mt-lg-8 {
                margin-top: 3.75rem !important
            }

            .mt-lg-9 {
                margin-top: 5.625rem !important
            }

            .mt-lg-10 {
                margin-top: 8.4375rem !important
            }

            .mt-lg-auto {
                margin-top: auto !important
            }

            .me-lg-0 {
                margin-right: 0 !important
            }

            .me-lg-1 {
                margin-right: .234375rem !important
            }

            .me-lg-2 {
                margin-right: .46875rem !important
            }

            .me-lg-3 {
                margin-right: .624999375rem !important
            }

            .me-lg-4 {
                margin-right: .9375rem !important
            }

            .me-lg-5 {
                margin-right: 1.2500000001rem !important
            }

            .me-lg-6 {
                margin-right: 1.875rem !important
            }

            .me-lg-7 {
                margin-right: 2.8125rem !important
            }

            .me-lg-8 {
                margin-right: 3.75rem !important
            }

            .me-lg-9 {
                margin-right: 5.625rem !important
            }

            .me-lg-10 {
                margin-right: 8.4375rem !important
            }

            .me-lg-auto {
                margin-right: auto !important
            }

            .mb-lg-0 {
                margin-bottom: 0 !important
            }

            .mb-lg-1 {
                margin-bottom: .234375rem !important
            }

            .mb-lg-2 {
                margin-bottom: .46875rem !important
            }

            .mb-lg-3 {
                margin-bottom: .624999375rem !important
            }

            .mb-lg-4 {
                margin-bottom: .9375rem !important
            }

            .mb-lg-5 {
                margin-bottom: 1.2500000001rem !important
            }

            .mb-lg-6 {
                margin-bottom: 1.875rem !important
            }

            .mb-lg-7 {
                margin-bottom: 2.8125rem !important
            }

            .mb-lg-8 {
                margin-bottom: 3.75rem !important
            }

            .mb-lg-9 {
                margin-bottom: 5.625rem !important
            }

            .mb-lg-10 {
                margin-bottom: 8.4375rem !important
            }

            .mb-lg-auto {
                margin-bottom: auto !important
            }

            .ms-lg-0 {
                margin-left: 0 !important
            }

            .ms-lg-1 {
                margin-left: .234375rem !important
            }

            .ms-lg-2 {
                margin-left: .46875rem !important
            }

            .ms-lg-3 {
                margin-left: .624999375rem !important
            }

            .ms-lg-4 {
                margin-left: .9375rem !important
            }

            .ms-lg-5 {
                margin-left: 1.2500000001rem !important
            }

            .ms-lg-6 {
                margin-left: 1.875rem !important
            }

            .ms-lg-7 {
                margin-left: 2.8125rem !important
            }

            .ms-lg-8 {
                margin-left: 3.75rem !important
            }

            .ms-lg-9 {
                margin-left: 5.625rem !important
            }

            .ms-lg-10 {
                margin-left: 8.4375rem !important
            }

            .ms-lg-auto {
                margin-left: auto !important
            }

            .m-lg-n1 {
                margin: -.234375rem !important
            }

            .m-lg-n2 {
                margin: -.46875rem !important
            }

            .m-lg-n3 {
                margin: -.624999375rem !important
            }

            .m-lg-n4 {
                margin: -.9375rem !important
            }

            .m-lg-n5 {
                margin: -1.2500000001rem !important
            }

            .m-lg-n6 {
                margin: -1.875rem !important
            }

            .m-lg-n7 {
                margin: -2.8125rem !important
            }

            .m-lg-n8 {
                margin: -3.75rem !important
            }

            .m-lg-n9 {
                margin: -5.625rem !important
            }

            .m-lg-n10 {
                margin: -8.4375rem !important
            }

            .mx-lg-n1 {
                margin-left: -.234375rem !important;
                margin-right: -.234375rem !important
            }

            .mx-lg-n2 {
                margin-left: -.46875rem !important;
                margin-right: -.46875rem !important
            }

            .mx-lg-n3 {
                margin-left: -.624999375rem !important;
                margin-right: -.624999375rem !important
            }

            .mx-lg-n4 {
                margin-left: -.9375rem !important;
                margin-right: -.9375rem !important
            }

            .mx-lg-n5 {
                margin-left: -1.2500000001rem !important;
                margin-right: -1.2500000001rem !important
            }

            .mx-lg-n6 {
                margin-left: -1.875rem !important;
                margin-right: -1.875rem !important
            }

            .mx-lg-n7 {
                margin-left: -2.8125rem !important;
                margin-right: -2.8125rem !important
            }

            .mx-lg-n8 {
                margin-left: -3.75rem !important;
                margin-right: -3.75rem !important
            }

            .mx-lg-n9 {
                margin-left: -5.625rem !important;
                margin-right: -5.625rem !important
            }

            .mx-lg-n10 {
                margin-left: -8.4375rem !important;
                margin-right: -8.4375rem !important
            }

            .my-lg-n1 {
                margin-bottom: -.234375rem !important;
                margin-top: -.234375rem !important
            }

            .my-lg-n2 {
                margin-bottom: -.46875rem !important;
                margin-top: -.46875rem !important
            }

            .my-lg-n3 {
                margin-bottom: -.624999375rem !important;
                margin-top: -.624999375rem !important
            }

            .my-lg-n4 {
                margin-bottom: -.9375rem !important;
                margin-top: -.9375rem !important
            }

            .my-lg-n5 {
                margin-bottom: -1.2500000001rem !important;
                margin-top: -1.2500000001rem !important
            }

            .my-lg-n6 {
                margin-bottom: -1.875rem !important;
                margin-top: -1.875rem !important
            }

            .my-lg-n7 {
                margin-bottom: -2.8125rem !important;
                margin-top: -2.8125rem !important
            }

            .my-lg-n8 {
                margin-bottom: -3.75rem !important;
                margin-top: -3.75rem !important
            }

            .my-lg-n9 {
                margin-bottom: -5.625rem !important;
                margin-top: -5.625rem !important
            }

            .my-lg-n10 {
                margin-bottom: -8.4375rem !important;
                margin-top: -8.4375rem !important
            }

            .mt-lg-n1 {
                margin-top: -.234375rem !important
            }

            .mt-lg-n2 {
                margin-top: -.46875rem !important
            }

            .mt-lg-n3 {
                margin-top: -.624999375rem !important
            }

            .mt-lg-n4 {
                margin-top: -.9375rem !important
            }

            .mt-lg-n5 {
                margin-top: -1.2500000001rem !important
            }

            .mt-lg-n6 {
                margin-top: -1.875rem !important
            }

            .mt-lg-n7 {
                margin-top: -2.8125rem !important
            }

            .mt-lg-n8 {
                margin-top: -3.75rem !important
            }

            .mt-lg-n9 {
                margin-top: -5.625rem !important
            }

            .mt-lg-n10 {
                margin-top: -8.4375rem !important
            }

            .me-lg-n1 {
                margin-right: -.234375rem !important
            }

            .me-lg-n2 {
                margin-right: -.46875rem !important
            }

            .me-lg-n3 {
                margin-right: -.624999375rem !important
            }

            .me-lg-n4 {
                margin-right: -.9375rem !important
            }

            .me-lg-n5 {
                margin-right: -1.2500000001rem !important
            }

            .me-lg-n6 {
                margin-right: -1.875rem !important
            }

            .me-lg-n7 {
                margin-right: -2.8125rem !important
            }

            .me-lg-n8 {
                margin-right: -3.75rem !important
            }

            .me-lg-n9 {
                margin-right: -5.625rem !important
            }

            .me-lg-n10 {
                margin-right: -8.4375rem !important
            }

            .mb-lg-n1 {
                margin-bottom: -.234375rem !important
            }

            .mb-lg-n2 {
                margin-bottom: -.46875rem !important
            }

            .mb-lg-n3 {
                margin-bottom: -.624999375rem !important
            }

            .mb-lg-n4 {
                margin-bottom: -.9375rem !important
            }

            .mb-lg-n5 {
                margin-bottom: -1.2500000001rem !important
            }

            .mb-lg-n6 {
                margin-bottom: -1.875rem !important
            }

            .mb-lg-n7 {
                margin-bottom: -2.8125rem !important
            }

            .mb-lg-n8 {
                margin-bottom: -3.75rem !important
            }

            .mb-lg-n9 {
                margin-bottom: -5.625rem !important
            }

            .mb-lg-n10 {
                margin-bottom: -8.4375rem !important
            }

            .ms-lg-n1 {
                margin-left: -.234375rem !important
            }

            .ms-lg-n2 {
                margin-left: -.46875rem !important
            }

            .ms-lg-n3 {
                margin-left: -.624999375rem !important
            }

            .ms-lg-n4 {
                margin-left: -.9375rem !important
            }

            .ms-lg-n5 {
                margin-left: -1.2500000001rem !important
            }

            .ms-lg-n6 {
                margin-left: -1.875rem !important
            }

            .ms-lg-n7 {
                margin-left: -2.8125rem !important
            }

            .ms-lg-n8 {
                margin-left: -3.75rem !important
            }

            .ms-lg-n9 {
                margin-left: -5.625rem !important
            }

            .ms-lg-n10 {
                margin-left: -8.4375rem !important
            }

            .p-lg-0 {
                padding: 0 !important
            }

            .p-lg-1 {
                padding: .234375rem !important
            }

            .p-lg-2 {
                padding: .46875rem !important
            }

            .p-lg-3 {
                padding: .624999375rem !important
            }

            .p-lg-4 {
                padding: .9375rem !important
            }

            .p-lg-5 {
                padding: 1.2500000001rem !important
            }

            .p-lg-6 {
                padding: 1.875rem !important
            }

            .p-lg-7 {
                padding: 2.8125rem !important
            }

            .p-lg-8 {
                padding: 3.75rem !important
            }

            .p-lg-9 {
                padding: 5.625rem !important
            }

            .p-lg-10 {
                padding: 8.4375rem !important
            }

            .px-lg-0 {
                padding-left: 0 !important;
                padding-right: 0 !important
            }

            .px-lg-1 {
                padding-left: .234375rem !important;
                padding-right: .234375rem !important
            }

            .px-lg-2 {
                padding-left: .46875rem !important;
                padding-right: .46875rem !important
            }

            .px-lg-3 {
                padding-left: .624999375rem !important;
                padding-right: .624999375rem !important
            }

            .px-lg-4 {
                padding-left: .9375rem !important;
                padding-right: .9375rem !important
            }

            .px-lg-5 {
                padding-left: 1.2500000001rem !important;
                padding-right: 1.2500000001rem !important
            }

            .px-lg-6 {
                padding-left: 1.875rem !important;
                padding-right: 1.875rem !important
            }

            .px-lg-7 {
                padding-left: 2.8125rem !important;
                padding-right: 2.8125rem !important
            }

            .px-lg-8 {
                padding-left: 3.75rem !important;
                padding-right: 3.75rem !important
            }

            .px-lg-9 {
                padding-left: 5.625rem !important;
                padding-right: 5.625rem !important
            }

            .px-lg-10 {
                padding-left: 8.4375rem !important;
                padding-right: 8.4375rem !important
            }

            .py-lg-0 {
                padding-bottom: 0 !important;
                padding-top: 0 !important
            }

            .py-lg-1 {
                padding-bottom: .234375rem !important;
                padding-top: .234375rem !important
            }

            .py-lg-2 {
                padding-bottom: .46875rem !important;
                padding-top: .46875rem !important
            }

            .py-lg-3 {
                padding-bottom: .624999375rem !important;
                padding-top: .624999375rem !important
            }

            .py-lg-4 {
                padding-bottom: .9375rem !important;
                padding-top: .9375rem !important
            }

            .py-lg-5 {
                padding-bottom: 1.2500000001rem !important;
                padding-top: 1.2500000001rem !important
            }

            .py-lg-6 {
                padding-bottom: 1.875rem !important;
                padding-top: 1.875rem !important
            }

            .py-lg-7 {
                padding-bottom: 2.8125rem !important;
                padding-top: 2.8125rem !important
            }

            .py-lg-8 {
                padding-bottom: 3.75rem !important;
                padding-top: 3.75rem !important
            }

            .py-lg-9 {
                padding-bottom: 5.625rem !important;
                padding-top: 5.625rem !important
            }

            .py-lg-10 {
                padding-bottom: 8.4375rem !important;
                padding-top: 8.4375rem !important
            }

            .pt-lg-0 {
                padding-top: 0 !important
            }

            .pt-lg-1 {
                padding-top: .234375rem !important
            }

            .pt-lg-2 {
                padding-top: .46875rem !important
            }

            .pt-lg-3 {
                padding-top: .624999375rem !important
            }

            .pt-lg-4 {
                padding-top: .9375rem !important
            }

            .pt-lg-5 {
                padding-top: 1.2500000001rem !important
            }

            .pt-lg-6 {
                padding-top: 1.875rem !important
            }

            .pt-lg-7 {
                padding-top: 2.8125rem !important
            }

            .pt-lg-8 {
                padding-top: 3.75rem !important
            }

            .pt-lg-9 {
                padding-top: 5.625rem !important
            }

            .pt-lg-10 {
                padding-top: 8.4375rem !important
            }

            .pe-lg-0 {
                padding-right: 0 !important
            }

            .pe-lg-1 {
                padding-right: .234375rem !important
            }

            .pe-lg-2 {
                padding-right: .46875rem !important
            }

            .pe-lg-3 {
                padding-right: .624999375rem !important
            }

            .pe-lg-4 {
                padding-right: .9375rem !important
            }

            .pe-lg-5 {
                padding-right: 1.2500000001rem !important
            }

            .pe-lg-6 {
                padding-right: 1.875rem !important
            }

            .pe-lg-7 {
                padding-right: 2.8125rem !important
            }

            .pe-lg-8 {
                padding-right: 3.75rem !important
            }

            .pe-lg-9 {
                padding-right: 5.625rem !important
            }

            .pe-lg-10 {
                padding-right: 8.4375rem !important
            }

            .pb-lg-0 {
                padding-bottom: 0 !important
            }

            .pb-lg-1 {
                padding-bottom: .234375rem !important
            }

            .pb-lg-2 {
                padding-bottom: .46875rem !important
            }

            .pb-lg-3 {
                padding-bottom: .624999375rem !important
            }

            .pb-lg-4 {
                padding-bottom: .9375rem !important
            }

            .pb-lg-5 {
                padding-bottom: 1.2500000001rem !important
            }

            .pb-lg-6 {
                padding-bottom: 1.875rem !important
            }

            .pb-lg-7 {
                padding-bottom: 2.8125rem !important
            }

            .pb-lg-8 {
                padding-bottom: 3.75rem !important
            }

            .pb-lg-9 {
                padding-bottom: 5.625rem !important
            }

            .pb-lg-10 {
                padding-bottom: 8.4375rem !important
            }

            .ps-lg-0 {
                padding-left: 0 !important
            }

            .ps-lg-1 {
                padding-left: .234375rem !important
            }

            .ps-lg-2 {
                padding-left: .46875rem !important
            }

            .ps-lg-3 {
                padding-left: .624999375rem !important
            }

            .ps-lg-4 {
                padding-left: .9375rem !important
            }

            .ps-lg-5 {
                padding-left: 1.2500000001rem !important
            }

            .ps-lg-6 {
                padding-left: 1.875rem !important
            }

            .ps-lg-7 {
                padding-left: 2.8125rem !important
            }

            .ps-lg-8 {
                padding-left: 3.75rem !important
            }

            .ps-lg-9 {
                padding-left: 5.625rem !important
            }

            .ps-lg-10 {
                padding-left: 8.4375rem !important
            }

            .gap-lg-0 {
                gap: 0 !important
            }

            .gap-lg-1 {
                gap: .234375rem !important
            }

            .gap-lg-2 {
                gap: .46875rem !important
            }

            .gap-lg-3 {
                gap: .624999375rem !important
            }

            .gap-lg-4 {
                gap: .9375rem !important
            }

            .gap-lg-5 {
                gap: 1.2500000001rem !important
            }

            .gap-lg-6 {
                gap: 1.875rem !important
            }

            .gap-lg-7 {
                gap: 2.8125rem !important
            }

            .gap-lg-8 {
                gap: 3.75rem !important
            }

            .gap-lg-9 {
                gap: 5.625rem !important
            }

            .gap-lg-10 {
                gap: 8.4375rem !important
            }

            .text-lg-start {
                text-align: left !important
            }

            .text-lg-end {
                text-align: right !important
            }

            .text-lg-center {
                text-align: center !important
            }

            .min-w-lg-unset {
                min-width: unset !important
            }

            .min-w-lg-25 {
                min-width: 25% !important
            }

            .min-w-lg-50 {
                min-width: 50% !important
            }

            .min-w-lg-75 {
                min-width: 75% !important
            }

            .min-w-lg-100 {
                min-width: 100% !important
            }

            .min-w-lg-auto {
                min-width: auto !important
            }

            .min-w-lg-1px {
                min-width: 1px !important
            }

            .min-w-lg-2px {
                min-width: 2px !important
            }

            .min-w-lg-3px {
                min-width: 3px !important
            }

            .min-w-lg-4px {
                min-width: 4px !important
            }

            .min-w-lg-5px {
                min-width: 5px !important
            }

            .min-w-lg-6px {
                min-width: 6px !important
            }

            .min-w-lg-7px {
                min-width: 7px !important
            }

            .min-w-lg-8px {
                min-width: 8px !important
            }

            .min-w-lg-9px {
                min-width: 9px !important
            }

            .min-w-lg-10px {
                min-width: 10px !important
            }

            .min-w-lg-15px {
                min-width: 15px !important
            }

            .min-w-lg-20px {
                min-width: 20px !important
            }

            .min-w-lg-25px {
                min-width: 25px !important
            }

            .min-w-lg-30px {
                min-width: 30px !important
            }

            .min-w-lg-35px {
                min-width: 35px !important
            }

            .min-w-lg-40px {
                min-width: 40px !important
            }

            .min-w-lg-45px {
                min-width: 45px !important
            }

            .min-w-lg-50px {
                min-width: 50px !important
            }

            .min-w-lg-55px {
                min-width: 55px !important
            }

            .min-w-lg-60px {
                min-width: 60px !important
            }

            .min-w-lg-65px {
                min-width: 65px !important
            }

            .min-w-lg-70px {
                min-width: 70px !important
            }

            .min-w-lg-75px {
                min-width: 75px !important
            }

            .min-w-lg-80px {
                min-width: 80px !important
            }

            .min-w-lg-85px {
                min-width: 85px !important
            }

            .min-w-lg-90px {
                min-width: 90px !important
            }

            .min-w-lg-95px {
                min-width: 95px !important
            }

            .min-w-lg-100px {
                min-width: 100px !important
            }

            .min-w-lg-125px {
                min-width: 125px !important
            }

            .min-w-lg-150px {
                min-width: 150px !important
            }

            .min-w-lg-175px {
                min-width: 175px !important
            }

            .min-w-lg-200px {
                min-width: 200px !important
            }

            .min-w-lg-225px {
                min-width: 225px !important
            }

            .min-w-lg-250px {
                min-width: 250px !important
            }

            .min-w-lg-275px {
                min-width: 275px !important
            }

            .min-w-lg-300px {
                min-width: 300px !important
            }

            .min-w-lg-325px {
                min-width: 325px !important
            }

            .min-w-lg-350px {
                min-width: 350px !important
            }

            .min-w-lg-375px {
                min-width: 375px !important
            }

            .min-w-lg-400px {
                min-width: 400px !important
            }

            .min-w-lg-425px {
                min-width: 425px !important
            }

            .min-w-lg-450px {
                min-width: 450px !important
            }

            .min-w-lg-475px {
                min-width: 475px !important
            }

            .min-w-lg-500px {
                min-width: 500px !important
            }

            .min-w-lg-550px {
                min-width: 550px !important
            }

            .min-w-lg-600px {
                min-width: 600px !important
            }

            .min-w-lg-650px {
                min-width: 650px !important
            }

            .min-w-lg-700px {
                min-width: 700px !important
            }

            .min-w-lg-750px {
                min-width: 750px !important
            }

            .min-w-lg-800px {
                min-width: 800px !important
            }

            .min-w-lg-850px {
                min-width: 850px !important
            }

            .min-w-lg-900px {
                min-width: 900px !important
            }

            .min-w-lg-950px {
                min-width: 950px !important
            }

            .min-w-lg-1000px {
                min-width: 1000px !important
            }

            .min-h-lg-unset {
                min-height: unset !important
            }

            .min-h-lg-25 {
                min-height: 25% !important
            }

            .min-h-lg-50 {
                min-height: 50% !important
            }

            .min-h-lg-75 {
                min-height: 75% !important
            }

            .min-h-lg-100 {
                min-height: 100% !important
            }

            .min-h-lg-auto {
                min-height: auto !important
            }

            .min-h-lg-1px {
                min-height: 1px !important
            }

            .min-h-lg-2px {
                min-height: 2px !important
            }

            .min-h-lg-3px {
                min-height: 3px !important
            }

            .min-h-lg-4px {
                min-height: 4px !important
            }

            .min-h-lg-5px {
                min-height: 5px !important
            }

            .min-h-lg-6px {
                min-height: 6px !important
            }

            .min-h-lg-7px {
                min-height: 7px !important
            }

            .min-h-lg-8px {
                min-height: 8px !important
            }

            .min-h-lg-9px {
                min-height: 9px !important
            }

            .min-h-lg-10px {
                min-height: 10px !important
            }

            .min-h-lg-15px {
                min-height: 15px !important
            }

            .min-h-lg-20px {
                min-height: 20px !important
            }

            .min-h-lg-25px {
                min-height: 25px !important
            }

            .min-h-lg-30px {
                min-height: 30px !important
            }

            .min-h-lg-35px {
                min-height: 35px !important
            }

            .min-h-lg-40px {
                min-height: 40px !important
            }

            .min-h-lg-45px {
                min-height: 45px !important
            }

            .min-h-lg-50px {
                min-height: 50px !important
            }

            .min-h-lg-55px {
                min-height: 55px !important
            }

            .min-h-lg-60px {
                min-height: 60px !important
            }

            .min-h-lg-65px {
                min-height: 65px !important
            }

            .min-h-lg-70px {
                min-height: 70px !important
            }

            .min-h-lg-75px {
                min-height: 75px !important
            }

            .min-h-lg-80px {
                min-height: 80px !important
            }

            .min-h-lg-85px {
                min-height: 85px !important
            }

            .min-h-lg-90px {
                min-height: 90px !important
            }

            .min-h-lg-95px {
                min-height: 95px !important
            }

            .min-h-lg-100px {
                min-height: 100px !important
            }

            .min-h-lg-125px {
                min-height: 125px !important
            }

            .min-h-lg-150px {
                min-height: 150px !important
            }

            .min-h-lg-175px {
                min-height: 175px !important
            }

            .min-h-lg-200px {
                min-height: 200px !important
            }

            .min-h-lg-225px {
                min-height: 225px !important
            }

            .min-h-lg-250px {
                min-height: 250px !important
            }

            .min-h-lg-275px {
                min-height: 275px !important
            }

            .min-h-lg-300px {
                min-height: 300px !important
            }

            .min-h-lg-325px {
                min-height: 325px !important
            }

            .min-h-lg-350px {
                min-height: 350px !important
            }

            .min-h-lg-375px {
                min-height: 375px !important
            }

            .min-h-lg-400px {
                min-height: 400px !important
            }

            .min-h-lg-425px {
                min-height: 425px !important
            }

            .min-h-lg-450px {
                min-height: 450px !important
            }

            .min-h-lg-475px {
                min-height: 475px !important
            }

            .min-h-lg-500px {
                min-height: 500px !important
            }

            .min-h-lg-550px {
                min-height: 550px !important
            }

            .min-h-lg-600px {
                min-height: 600px !important
            }

            .min-h-lg-650px {
                min-height: 650px !important
            }

            .min-h-lg-700px {
                min-height: 700px !important
            }

            .min-h-lg-750px {
                min-height: 750px !important
            }

            .min-h-lg-800px {
                min-height: 800px !important
            }

            .min-h-lg-850px {
                min-height: 850px !important
            }

            .min-h-lg-900px {
                min-height: 900px !important
            }

            .min-h-lg-950px {
                min-height: 950px !important
            }

            .min-h-lg-1000px {
                min-height: 1000px !important
            }

            .scroll-m-lg-0 {
                scroll-margin: 0 !important
            }

            .scroll-m-lg-1 {
                scroll-margin: .234375rem !important
            }

            .scroll-m-lg-2 {
                scroll-margin: .46875rem !important
            }

            .scroll-m-lg-3 {
                scroll-margin: .624999375rem !important
            }

            .scroll-m-lg-4 {
                scroll-margin: .9375rem !important
            }

            .scroll-m-lg-5 {
                scroll-margin: 1.2500000001rem !important
            }

            .scroll-m-lg-6 {
                scroll-margin: 1.875rem !important
            }

            .scroll-m-lg-7 {
                scroll-margin: 2.8125rem !important
            }

            .scroll-m-lg-8 {
                scroll-margin: 3.75rem !important
            }

            .scroll-m-lg-9 {
                scroll-margin: 5.625rem !important
            }

            .scroll-m-lg-10 {
                scroll-margin: 8.4375rem !important
            }

            .scroll-m-lg-auto {
                scroll-margin: auto !important
            }

            .scroll-mx-lg-0 {
                scroll-margin-left: 0 !important;
                scroll-margin-right: 0 !important
            }

            .scroll-mx-lg-1 {
                scroll-margin-left: .234375rem !important;
                scroll-margin-right: .234375rem !important
            }

            .scroll-mx-lg-2 {
                scroll-margin-left: .46875rem !important;
                scroll-margin-right: .46875rem !important
            }

            .scroll-mx-lg-3 {
                scroll-margin-left: .624999375rem !important;
                scroll-margin-right: .624999375rem !important
            }

            .scroll-mx-lg-4 {
                scroll-margin-left: .9375rem !important;
                scroll-margin-right: .9375rem !important
            }

            .scroll-mx-lg-5 {
                scroll-margin-left: 1.2500000001rem !important;
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-mx-lg-6 {
                scroll-margin-left: 1.875rem !important;
                scroll-margin-right: 1.875rem !important
            }

            .scroll-mx-lg-7 {
                scroll-margin-left: 2.8125rem !important;
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-mx-lg-8 {
                scroll-margin-left: 3.75rem !important;
                scroll-margin-right: 3.75rem !important
            }

            .scroll-mx-lg-9 {
                scroll-margin-left: 5.625rem !important;
                scroll-margin-right: 5.625rem !important
            }

            .scroll-mx-lg-10 {
                scroll-margin-left: 8.4375rem !important;
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-mx-lg-auto {
                scroll-margin-left: auto !important;
                scroll-margin-right: auto !important
            }

            .scroll-my-lg-0 {
                scroll-margin-bottom: 0 !important;
                scroll-margin-top: 0 !important
            }

            .scroll-my-lg-1 {
                scroll-margin-bottom: .234375rem !important;
                scroll-margin-top: .234375rem !important
            }

            .scroll-my-lg-2 {
                scroll-margin-bottom: .46875rem !important;
                scroll-margin-top: .46875rem !important
            }

            .scroll-my-lg-3 {
                scroll-margin-bottom: .624999375rem !important;
                scroll-margin-top: .624999375rem !important
            }

            .scroll-my-lg-4 {
                scroll-margin-bottom: .9375rem !important;
                scroll-margin-top: .9375rem !important
            }

            .scroll-my-lg-5 {
                scroll-margin-bottom: 1.2500000001rem !important;
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-my-lg-6 {
                scroll-margin-bottom: 1.875rem !important;
                scroll-margin-top: 1.875rem !important
            }

            .scroll-my-lg-7 {
                scroll-margin-bottom: 2.8125rem !important;
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-my-lg-8 {
                scroll-margin-bottom: 3.75rem !important;
                scroll-margin-top: 3.75rem !important
            }

            .scroll-my-lg-9 {
                scroll-margin-bottom: 5.625rem !important;
                scroll-margin-top: 5.625rem !important
            }

            .scroll-my-lg-10 {
                scroll-margin-bottom: 8.4375rem !important;
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-my-lg-auto {
                scroll-margin-bottom: auto !important;
                scroll-margin-top: auto !important
            }

            .scroll-mt-lg-0 {
                scroll-margin-top: 0 !important
            }

            .scroll-mt-lg-1 {
                scroll-margin-top: .234375rem !important
            }

            .scroll-mt-lg-2 {
                scroll-margin-top: .46875rem !important
            }

            .scroll-mt-lg-3 {
                scroll-margin-top: .624999375rem !important
            }

            .scroll-mt-lg-4 {
                scroll-margin-top: .9375rem !important
            }

            .scroll-mt-lg-5 {
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-mt-lg-6 {
                scroll-margin-top: 1.875rem !important
            }

            .scroll-mt-lg-7 {
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-mt-lg-8 {
                scroll-margin-top: 3.75rem !important
            }

            .scroll-mt-lg-9 {
                scroll-margin-top: 5.625rem !important
            }

            .scroll-mt-lg-10 {
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-mt-lg-auto {
                scroll-margin-top: auto !important
            }

            .scroll-me-lg-0 {
                scroll-margin-right: 0 !important
            }

            .scroll-me-lg-1 {
                scroll-margin-right: .234375rem !important
            }

            .scroll-me-lg-2 {
                scroll-margin-right: .46875rem !important
            }

            .scroll-me-lg-3 {
                scroll-margin-right: .624999375rem !important
            }

            .scroll-me-lg-4 {
                scroll-margin-right: .9375rem !important
            }

            .scroll-me-lg-5 {
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-me-lg-6 {
                scroll-margin-right: 1.875rem !important
            }

            .scroll-me-lg-7 {
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-me-lg-8 {
                scroll-margin-right: 3.75rem !important
            }

            .scroll-me-lg-9 {
                scroll-margin-right: 5.625rem !important
            }

            .scroll-me-lg-10 {
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-me-lg-auto {
                scroll-margin-right: auto !important
            }

            .scroll-mb-lg-0 {
                scroll-margin-bottom: 0 !important
            }

            .scroll-mb-lg-1 {
                scroll-margin-bottom: .234375rem !important
            }

            .scroll-mb-lg-2 {
                scroll-margin-bottom: .46875rem !important
            }

            .scroll-mb-lg-3 {
                scroll-margin-bottom: .624999375rem !important
            }

            .scroll-mb-lg-4 {
                scroll-margin-bottom: .9375rem !important
            }

            .scroll-mb-lg-5 {
                scroll-margin-bottom: 1.2500000001rem !important
            }

            .scroll-mb-lg-6 {
                scroll-margin-bottom: 1.875rem !important
            }

            .scroll-mb-lg-7 {
                scroll-margin-bottom: 2.8125rem !important
            }

            .scroll-mb-lg-8 {
                scroll-margin-bottom: 3.75rem !important
            }

            .scroll-mb-lg-9 {
                scroll-margin-bottom: 5.625rem !important
            }

            .scroll-mb-lg-10 {
                scroll-margin-bottom: 8.4375rem !important
            }

            .scroll-mb-lg-auto {
                scroll-margin-bottom: auto !important
            }

            .scroll-ms-lg-0 {
                scroll-margin-left: 0 !important
            }

            .scroll-ms-lg-1 {
                scroll-margin-left: .234375rem !important
            }

            .scroll-ms-lg-2 {
                scroll-margin-left: .46875rem !important
            }

            .scroll-ms-lg-3 {
                scroll-margin-left: .624999375rem !important
            }

            .scroll-ms-lg-4 {
                scroll-margin-left: .9375rem !important
            }

            .scroll-ms-lg-5 {
                scroll-margin-left: 1.2500000001rem !important
            }

            .scroll-ms-lg-6 {
                scroll-margin-left: 1.875rem !important
            }

            .scroll-ms-lg-7 {
                scroll-margin-left: 2.8125rem !important
            }

            .scroll-ms-lg-8 {
                scroll-margin-left: 3.75rem !important
            }

            .scroll-ms-lg-9 {
                scroll-margin-left: 5.625rem !important
            }

            .scroll-ms-lg-10 {
                scroll-margin-left: 8.4375rem !important
            }

            .scroll-ms-lg-auto {
                scroll-margin-left: auto !important
            }

            .object-fit-lg-contain {
                -o-object-fit: contain !important;
                object-fit: contain !important
            }

            .object-fit-lg-cover {
                -o-object-fit: cover !important;
                object-fit: cover !important
            }

            .object-fit-lg-fill {
                -o-object-fit: fill !important;
                object-fit: fill !important
            }

            .object-fit-lg-scale {
                -o-object-fit: scale-down !important;
                object-fit: scale-down !important
            }

            .object-fit-lg-none {
                -o-object-fit: none !important;
                object-fit: none !important
            }
        }

        @media(min-width:1200px) {
            .float-xl-start {
                float: left !important
            }

            .float-xl-end {
                float: right !important
            }

            .float-xl-none {
                float: none !important
            }

            .d-xl-inline {
                display: inline !important
            }

            .d-xl-inline-block {
                display: inline-block !important
            }

            .d-xl-block {
                display: block !important
            }

            .d-xl-grid {
                display: grid !important
            }

            .d-xl-table {
                display: table !important
            }

            .d-xl-table-row {
                display: table-row !important
            }

            .d-xl-table-cell {
                display: table-cell !important
            }

            .d-xl-flex {
                display: flex !important
            }

            .d-xl-inline-flex {
                display: inline-flex !important
            }

            .d-xl-none {
                display: none !important
            }

            .position-xl-static {
                position: static !important
            }

            .position-xl-relative {
                position: relative !important
            }

            .position-xl-absolute {
                position: absolute !important
            }

            .position-xl-fixed {
                position: fixed !important
            }

            .position-xl-sticky {
                position: -webkit-sticky !important;
                position: sticky !important
            }

            .w-xl-unset {
                width: unset !important
            }

            .w-xl-25 {
                width: 25% !important
            }

            .w-xl-50 {
                width: 50% !important
            }

            .w-xl-75 {
                width: 75% !important
            }

            .w-xl-100 {
                width: 100% !important
            }

            .w-xl-auto {
                width: auto !important
            }

            .w-xl-1px {
                width: 1px !important
            }

            .w-xl-2px {
                width: 2px !important
            }

            .w-xl-3px {
                width: 3px !important
            }

            .w-xl-4px {
                width: 4px !important
            }

            .w-xl-5px {
                width: 5px !important
            }

            .w-xl-6px {
                width: 6px !important
            }

            .w-xl-7px {
                width: 7px !important
            }

            .w-xl-8px {
                width: 8px !important
            }

            .w-xl-9px {
                width: 9px !important
            }

            .w-xl-10px {
                width: 10px !important
            }

            .w-xl-15px {
                width: 15px !important
            }

            .w-xl-20px {
                width: 20px !important
            }

            .w-xl-25px {
                width: 25px !important
            }

            .w-xl-30px {
                width: 30px !important
            }

            .w-xl-35px {
                width: 35px !important
            }

            .w-xl-40px {
                width: 40px !important
            }

            .w-xl-45px {
                width: 45px !important
            }

            .w-xl-50px {
                width: 50px !important
            }

            .w-xl-55px {
                width: 55px !important
            }

            .w-xl-60px {
                width: 60px !important
            }

            .w-xl-65px {
                width: 65px !important
            }

            .w-xl-70px {
                width: 70px !important
            }

            .w-xl-75px {
                width: 75px !important
            }

            .w-xl-80px {
                width: 80px !important
            }

            .w-xl-85px {
                width: 85px !important
            }

            .w-xl-90px {
                width: 90px !important
            }

            .w-xl-95px {
                width: 95px !important
            }

            .w-xl-100px {
                width: 100px !important
            }

            .w-xl-125px {
                width: 125px !important
            }

            .w-xl-150px {
                width: 150px !important
            }

            .w-xl-175px {
                width: 175px !important
            }

            .w-xl-200px {
                width: 200px !important
            }

            .w-xl-225px {
                width: 225px !important
            }

            .w-xl-250px {
                width: 250px !important
            }

            .w-xl-275px {
                width: 275px !important
            }

            .w-xl-300px {
                width: 300px !important
            }

            .w-xl-325px {
                width: 325px !important
            }

            .w-xl-350px {
                width: 350px !important
            }

            .w-xl-375px {
                width: 375px !important
            }

            .w-xl-400px {
                width: 400px !important
            }

            .w-xl-425px {
                width: 425px !important
            }

            .w-xl-450px {
                width: 450px !important
            }

            .w-xl-475px {
                width: 475px !important
            }

            .w-xl-500px {
                width: 500px !important
            }

            .w-xl-550px {
                width: 550px !important
            }

            .w-xl-600px {
                width: 600px !important
            }

            .w-xl-650px {
                width: 650px !important
            }

            .w-xl-700px {
                width: 700px !important
            }

            .w-xl-750px {
                width: 750px !important
            }

            .w-xl-800px {
                width: 800px !important
            }

            .w-xl-850px {
                width: 850px !important
            }

            .w-xl-900px {
                width: 900px !important
            }

            .w-xl-950px {
                width: 950px !important
            }

            .w-xl-1000px {
                width: 1000px !important
            }

            .mw-xl-unset {
                max-width: unset !important
            }

            .mw-xl-25 {
                max-width: 25% !important
            }

            .mw-xl-50 {
                max-width: 50% !important
            }

            .mw-xl-75 {
                max-width: 75% !important
            }

            .mw-xl-100 {
                max-width: 100% !important
            }

            .mw-xl-auto {
                max-width: auto !important
            }

            .mw-xl-1px {
                max-width: 1px !important
            }

            .mw-xl-2px {
                max-width: 2px !important
            }

            .mw-xl-3px {
                max-width: 3px !important
            }

            .mw-xl-4px {
                max-width: 4px !important
            }

            .mw-xl-5px {
                max-width: 5px !important
            }

            .mw-xl-6px {
                max-width: 6px !important
            }

            .mw-xl-7px {
                max-width: 7px !important
            }

            .mw-xl-8px {
                max-width: 8px !important
            }

            .mw-xl-9px {
                max-width: 9px !important
            }

            .mw-xl-10px {
                max-width: 10px !important
            }

            .mw-xl-15px {
                max-width: 15px !important
            }

            .mw-xl-20px {
                max-width: 20px !important
            }

            .mw-xl-25px {
                max-width: 25px !important
            }

            .mw-xl-30px {
                max-width: 30px !important
            }

            .mw-xl-35px {
                max-width: 35px !important
            }

            .mw-xl-40px {
                max-width: 40px !important
            }

            .mw-xl-45px {
                max-width: 45px !important
            }

            .mw-xl-50px {
                max-width: 50px !important
            }

            .mw-xl-55px {
                max-width: 55px !important
            }

            .mw-xl-60px {
                max-width: 60px !important
            }

            .mw-xl-65px {
                max-width: 65px !important
            }

            .mw-xl-70px {
                max-width: 70px !important
            }

            .mw-xl-75px {
                max-width: 75px !important
            }

            .mw-xl-80px {
                max-width: 80px !important
            }

            .mw-xl-85px {
                max-width: 85px !important
            }

            .mw-xl-90px {
                max-width: 90px !important
            }

            .mw-xl-95px {
                max-width: 95px !important
            }

            .mw-xl-100px {
                max-width: 100px !important
            }

            .mw-xl-125px {
                max-width: 125px !important
            }

            .mw-xl-150px {
                max-width: 150px !important
            }

            .mw-xl-175px {
                max-width: 175px !important
            }

            .mw-xl-200px {
                max-width: 200px !important
            }

            .mw-xl-225px {
                max-width: 225px !important
            }

            .mw-xl-250px {
                max-width: 250px !important
            }

            .mw-xl-275px {
                max-width: 275px !important
            }

            .mw-xl-300px {
                max-width: 300px !important
            }

            .mw-xl-325px {
                max-width: 325px !important
            }

            .mw-xl-350px {
                max-width: 350px !important
            }

            .mw-xl-375px {
                max-width: 375px !important
            }

            .mw-xl-400px {
                max-width: 400px !important
            }

            .mw-xl-425px {
                max-width: 425px !important
            }

            .mw-xl-450px {
                max-width: 450px !important
            }

            .mw-xl-475px {
                max-width: 475px !important
            }

            .mw-xl-500px {
                max-width: 500px !important
            }

            .mw-xl-550px {
                max-width: 550px !important
            }

            .mw-xl-600px {
                max-width: 600px !important
            }

            .mw-xl-650px {
                max-width: 650px !important
            }

            .mw-xl-700px {
                max-width: 700px !important
            }

            .mw-xl-750px {
                max-width: 750px !important
            }

            .mw-xl-800px {
                max-width: 800px !important
            }

            .mw-xl-850px {
                max-width: 850px !important
            }

            .mw-xl-900px {
                max-width: 900px !important
            }

            .mw-xl-950px {
                max-width: 950px !important
            }

            .mw-xl-1000px {
                max-width: 1000px !important
            }

            .vw-xl-25 {
                width: 25vw !important
            }

            .vw-xl-50 {
                width: 50vw !important
            }

            .vw-xl-75 {
                width: 75vw !important
            }

            .vw-xl-100 {
                width: 100vw !important
            }

            .vw-xl-auto {
                width: auto !important
            }

            .min-vw-xl-25 {
                min-width: 25vw !important
            }

            .min-vw-xl-50 {
                min-width: 50vw !important
            }

            .min-vw-xl-75 {
                min-width: 75vw !important
            }

            .min-vw-xl-100 {
                min-width: 100vw !important
            }

            .min-vw-xl-auto {
                min-width: auto !important
            }

            .h-xl-unset {
                height: unset !important
            }

            .h-xl-25 {
                height: 25% !important
            }

            .h-xl-50 {
                height: 50% !important
            }

            .h-xl-75 {
                height: 75% !important
            }

            .h-xl-100 {
                height: 100% !important
            }

            .h-xl-auto {
                height: auto !important
            }

            .h-xl-1px {
                height: 1px !important
            }

            .h-xl-2px {
                height: 2px !important
            }

            .h-xl-3px {
                height: 3px !important
            }

            .h-xl-4px {
                height: 4px !important
            }

            .h-xl-5px {
                height: 5px !important
            }

            .h-xl-6px {
                height: 6px !important
            }

            .h-xl-7px {
                height: 7px !important
            }

            .h-xl-8px {
                height: 8px !important
            }

            .h-xl-9px {
                height: 9px !important
            }

            .h-xl-10px {
                height: 10px !important
            }

            .h-xl-15px {
                height: 15px !important
            }

            .h-xl-20px {
                height: 20px !important
            }

            .h-xl-25px {
                height: 25px !important
            }

            .h-xl-30px {
                height: 30px !important
            }

            .h-xl-35px {
                height: 35px !important
            }

            .h-xl-40px {
                height: 40px !important
            }

            .h-xl-45px {
                height: 45px !important
            }

            .h-xl-50px {
                height: 50px !important
            }

            .h-xl-55px {
                height: 55px !important
            }

            .h-xl-60px {
                height: 60px !important
            }

            .h-xl-65px {
                height: 65px !important
            }

            .h-xl-70px {
                height: 70px !important
            }

            .h-xl-75px {
                height: 75px !important
            }

            .h-xl-80px {
                height: 80px !important
            }

            .h-xl-85px {
                height: 85px !important
            }

            .h-xl-90px {
                height: 90px !important
            }

            .h-xl-95px {
                height: 95px !important
            }

            .h-xl-100px {
                height: 100px !important
            }

            .h-xl-125px {
                height: 125px !important
            }

            .h-xl-150px {
                height: 150px !important
            }

            .h-xl-175px {
                height: 175px !important
            }

            .h-xl-200px {
                height: 200px !important
            }

            .h-xl-225px {
                height: 225px !important
            }

            .h-xl-250px {
                height: 250px !important
            }

            .h-xl-275px {
                height: 275px !important
            }

            .h-xl-300px {
                height: 300px !important
            }

            .h-xl-325px {
                height: 325px !important
            }

            .h-xl-350px {
                height: 350px !important
            }

            .h-xl-375px {
                height: 375px !important
            }

            .h-xl-400px {
                height: 400px !important
            }

            .h-xl-425px {
                height: 425px !important
            }

            .h-xl-450px {
                height: 450px !important
            }

            .h-xl-475px {
                height: 475px !important
            }

            .h-xl-500px {
                height: 500px !important
            }

            .h-xl-550px {
                height: 550px !important
            }

            .h-xl-600px {
                height: 600px !important
            }

            .h-xl-650px {
                height: 650px !important
            }

            .h-xl-700px {
                height: 700px !important
            }

            .h-xl-750px {
                height: 750px !important
            }

            .h-xl-800px {
                height: 800px !important
            }

            .h-xl-850px {
                height: 850px !important
            }

            .h-xl-900px {
                height: 900px !important
            }

            .h-xl-950px {
                height: 950px !important
            }

            .h-xl-1000px {
                height: 1000px !important
            }

            .mh-xl-unset {
                max-height: unset !important
            }

            .mh-xl-25 {
                max-height: 25% !important
            }

            .mh-xl-50 {
                max-height: 50% !important
            }

            .mh-xl-75 {
                max-height: 75% !important
            }

            .mh-xl-100 {
                max-height: 100% !important
            }

            .mh-xl-auto {
                max-height: auto !important
            }

            .mh-xl-1px {
                max-height: 1px !important
            }

            .mh-xl-2px {
                max-height: 2px !important
            }

            .mh-xl-3px {
                max-height: 3px !important
            }

            .mh-xl-4px {
                max-height: 4px !important
            }

            .mh-xl-5px {
                max-height: 5px !important
            }

            .mh-xl-6px {
                max-height: 6px !important
            }

            .mh-xl-7px {
                max-height: 7px !important
            }

            .mh-xl-8px {
                max-height: 8px !important
            }

            .mh-xl-9px {
                max-height: 9px !important
            }

            .mh-xl-10px {
                max-height: 10px !important
            }

            .mh-xl-15px {
                max-height: 15px !important
            }

            .mh-xl-20px {
                max-height: 20px !important
            }

            .mh-xl-25px {
                max-height: 25px !important
            }

            .mh-xl-30px {
                max-height: 30px !important
            }

            .mh-xl-35px {
                max-height: 35px !important
            }

            .mh-xl-40px {
                max-height: 40px !important
            }

            .mh-xl-45px {
                max-height: 45px !important
            }

            .mh-xl-50px {
                max-height: 50px !important
            }

            .mh-xl-55px {
                max-height: 55px !important
            }

            .mh-xl-60px {
                max-height: 60px !important
            }

            .mh-xl-65px {
                max-height: 65px !important
            }

            .mh-xl-70px {
                max-height: 70px !important
            }

            .mh-xl-75px {
                max-height: 75px !important
            }

            .mh-xl-80px {
                max-height: 80px !important
            }

            .mh-xl-85px {
                max-height: 85px !important
            }

            .mh-xl-90px {
                max-height: 90px !important
            }

            .mh-xl-95px {
                max-height: 95px !important
            }

            .mh-xl-100px {
                max-height: 100px !important
            }

            .mh-xl-125px {
                max-height: 125px !important
            }

            .mh-xl-150px {
                max-height: 150px !important
            }

            .mh-xl-175px {
                max-height: 175px !important
            }

            .mh-xl-200px {
                max-height: 200px !important
            }

            .mh-xl-225px {
                max-height: 225px !important
            }

            .mh-xl-250px {
                max-height: 250px !important
            }

            .mh-xl-275px {
                max-height: 275px !important
            }

            .mh-xl-300px {
                max-height: 300px !important
            }

            .mh-xl-325px {
                max-height: 325px !important
            }

            .mh-xl-350px {
                max-height: 350px !important
            }

            .mh-xl-375px {
                max-height: 375px !important
            }

            .mh-xl-400px {
                max-height: 400px !important
            }

            .mh-xl-425px {
                max-height: 425px !important
            }

            .mh-xl-450px {
                max-height: 450px !important
            }

            .mh-xl-475px {
                max-height: 475px !important
            }

            .mh-xl-500px {
                max-height: 500px !important
            }

            .mh-xl-550px {
                max-height: 550px !important
            }

            .mh-xl-600px {
                max-height: 600px !important
            }

            .mh-xl-650px {
                max-height: 650px !important
            }

            .mh-xl-700px {
                max-height: 700px !important
            }

            .mh-xl-750px {
                max-height: 750px !important
            }

            .mh-xl-800px {
                max-height: 800px !important
            }

            .mh-xl-850px {
                max-height: 850px !important
            }

            .mh-xl-900px {
                max-height: 900px !important
            }

            .mh-xl-950px {
                max-height: 950px !important
            }

            .mh-xl-1000px {
                max-height: 1000px !important
            }

            .vh-xl-25 {
                height: 25vh !important
            }

            .vh-xl-50 {
                height: 50vh !important
            }

            .vh-xl-75 {
                height: 75vh !important
            }

            .vh-xl-100 {
                height: 100vh !important
            }

            .vh-xl-auto {
                height: auto !important
            }

            .min-vh-xl-25 {
                min-height: 25vh !important
            }

            .min-vh-xl-50 {
                min-height: 50vh !important
            }

            .min-vh-xl-75 {
                min-height: 75vh !important
            }

            .min-vh-xl-100 {
                min-height: 100vh !important
            }

            .min-vh-xl-auto {
                min-height: auto !important
            }

            .flex-xl-fill {
                flex: 1 1 auto !important
            }

            .flex-xl-row {
                flex-direction: row !important
            }

            .flex-xl-column {
                flex-direction: column !important
            }

            .flex-xl-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-xl-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-xl-grow-0 {
                flex-grow: 0 !important
            }

            .flex-xl-grow-1 {
                flex-grow: 1 !important
            }

            .flex-xl-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-xl-shrink-1 {
                flex-shrink: 1 !important
            }

            .flex-xl-wrap {
                flex-wrap: wrap !important
            }

            .flex-xl-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-xl-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .justify-content-xl-start {
                justify-content: flex-start !important
            }

            .justify-content-xl-end {
                justify-content: flex-end !important
            }

            .justify-content-xl-center {
                justify-content: center !important
            }

            .justify-content-xl-between {
                justify-content: space-between !important
            }

            .justify-content-xl-around {
                justify-content: space-around !important
            }

            .justify-content-xl-evenly {
                justify-content: space-evenly !important
            }

            .align-items-xl-start {
                align-items: flex-start !important
            }

            .align-items-xl-end {
                align-items: flex-end !important
            }

            .align-items-xl-center {
                align-items: center !important
            }

            .align-items-xl-baseline {
                align-items: baseline !important
            }

            .align-items-xl-stretch {
                align-items: stretch !important
            }

            .align-content-xl-start {
                align-content: flex-start !important
            }

            .align-content-xl-end {
                align-content: flex-end !important
            }

            .align-content-xl-center {
                align-content: center !important
            }

            .align-content-xl-between {
                align-content: space-between !important
            }

            .align-content-xl-around {
                align-content: space-around !important
            }

            .align-content-xl-stretch {
                align-content: stretch !important
            }

            .align-self-xl-auto {
                align-self: auto !important
            }

            .align-self-xl-start {
                align-self: flex-start !important
            }

            .align-self-xl-end {
                align-self: flex-end !important
            }

            .align-self-xl-center {
                align-self: center !important
            }

            .align-self-xl-baseline {
                align-self: baseline !important
            }

            .align-self-xl-stretch {
                align-self: stretch !important
            }

            .order-xl-first {
                order: -1 !important
            }

            .order-xl-0 {
                order: 0 !important
            }

            .order-xl-1 {
                order: 1 !important
            }

            .order-xl-2 {
                order: 2 !important
            }

            .order-xl-3 {
                order: 3 !important
            }

            .order-xl-4 {
                order: 4 !important
            }

            .order-xl-5 {
                order: 5 !important
            }

            .order-xl-last {
                order: 6 !important
            }

            .m-xl-0 {
                margin: 0 !important
            }

            .m-xl-1 {
                margin: .234375rem !important
            }

            .m-xl-2 {
                margin: .46875rem !important
            }

            .m-xl-3 {
                margin: .624999375rem !important
            }

            .m-xl-4 {
                margin: .9375rem !important
            }

            .m-xl-5 {
                margin: 1.2500000001rem !important
            }

            .m-xl-6 {
                margin: 1.875rem !important
            }

            .m-xl-7 {
                margin: 2.8125rem !important
            }

            .m-xl-8 {
                margin: 3.75rem !important
            }

            .m-xl-9 {
                margin: 5.625rem !important
            }

            .m-xl-10 {
                margin: 8.4375rem !important
            }

            .m-xl-auto {
                margin: auto !important
            }

            .mx-xl-0 {
                margin-left: 0 !important;
                margin-right: 0 !important
            }

            .mx-xl-1 {
                margin-left: .234375rem !important;
                margin-right: .234375rem !important
            }

            .mx-xl-2 {
                margin-left: .46875rem !important;
                margin-right: .46875rem !important
            }

            .mx-xl-3 {
                margin-left: .624999375rem !important;
                margin-right: .624999375rem !important
            }

            .mx-xl-4 {
                margin-left: .9375rem !important;
                margin-right: .9375rem !important
            }

            .mx-xl-5 {
                margin-left: 1.2500000001rem !important;
                margin-right: 1.2500000001rem !important
            }

            .mx-xl-6 {
                margin-left: 1.875rem !important;
                margin-right: 1.875rem !important
            }

            .mx-xl-7 {
                margin-left: 2.8125rem !important;
                margin-right: 2.8125rem !important
            }

            .mx-xl-8 {
                margin-left: 3.75rem !important;
                margin-right: 3.75rem !important
            }

            .mx-xl-9 {
                margin-left: 5.625rem !important;
                margin-right: 5.625rem !important
            }

            .mx-xl-10 {
                margin-left: 8.4375rem !important;
                margin-right: 8.4375rem !important
            }

            .mx-xl-auto {
                margin-left: auto !important;
                margin-right: auto !important
            }

            .my-xl-0 {
                margin-bottom: 0 !important;
                margin-top: 0 !important
            }

            .my-xl-1 {
                margin-bottom: .234375rem !important;
                margin-top: .234375rem !important
            }

            .my-xl-2 {
                margin-bottom: .46875rem !important;
                margin-top: .46875rem !important
            }

            .my-xl-3 {
                margin-bottom: .624999375rem !important;
                margin-top: .624999375rem !important
            }

            .my-xl-4 {
                margin-bottom: .9375rem !important;
                margin-top: .9375rem !important
            }

            .my-xl-5 {
                margin-bottom: 1.2500000001rem !important;
                margin-top: 1.2500000001rem !important
            }

            .my-xl-6 {
                margin-bottom: 1.875rem !important;
                margin-top: 1.875rem !important
            }

            .my-xl-7 {
                margin-bottom: 2.8125rem !important;
                margin-top: 2.8125rem !important
            }

            .my-xl-8 {
                margin-bottom: 3.75rem !important;
                margin-top: 3.75rem !important
            }

            .my-xl-9 {
                margin-bottom: 5.625rem !important;
                margin-top: 5.625rem !important
            }

            .my-xl-10 {
                margin-bottom: 8.4375rem !important;
                margin-top: 8.4375rem !important
            }

            .my-xl-auto {
                margin-bottom: auto !important;
                margin-top: auto !important
            }

            .mt-xl-0 {
                margin-top: 0 !important
            }

            .mt-xl-1 {
                margin-top: .234375rem !important
            }

            .mt-xl-2 {
                margin-top: .46875rem !important
            }

            .mt-xl-3 {
                margin-top: .624999375rem !important
            }

            .mt-xl-4 {
                margin-top: .9375rem !important
            }

            .mt-xl-5 {
                margin-top: 1.2500000001rem !important
            }

            .mt-xl-6 {
                margin-top: 1.875rem !important
            }

            .mt-xl-7 {
                margin-top: 2.8125rem !important
            }

            .mt-xl-8 {
                margin-top: 3.75rem !important
            }

            .mt-xl-9 {
                margin-top: 5.625rem !important
            }

            .mt-xl-10 {
                margin-top: 8.4375rem !important
            }

            .mt-xl-auto {
                margin-top: auto !important
            }

            .me-xl-0 {
                margin-right: 0 !important
            }

            .me-xl-1 {
                margin-right: .234375rem !important
            }

            .me-xl-2 {
                margin-right: .46875rem !important
            }

            .me-xl-3 {
                margin-right: .624999375rem !important
            }

            .me-xl-4 {
                margin-right: .9375rem !important
            }

            .me-xl-5 {
                margin-right: 1.2500000001rem !important
            }

            .me-xl-6 {
                margin-right: 1.875rem !important
            }

            .me-xl-7 {
                margin-right: 2.8125rem !important
            }

            .me-xl-8 {
                margin-right: 3.75rem !important
            }

            .me-xl-9 {
                margin-right: 5.625rem !important
            }

            .me-xl-10 {
                margin-right: 8.4375rem !important
            }

            .me-xl-auto {
                margin-right: auto !important
            }

            .mb-xl-0 {
                margin-bottom: 0 !important
            }

            .mb-xl-1 {
                margin-bottom: .234375rem !important
            }

            .mb-xl-2 {
                margin-bottom: .46875rem !important
            }

            .mb-xl-3 {
                margin-bottom: .624999375rem !important
            }

            .mb-xl-4 {
                margin-bottom: .9375rem !important
            }

            .mb-xl-5 {
                margin-bottom: 1.2500000001rem !important
            }

            .mb-xl-6 {
                margin-bottom: 1.875rem !important
            }

            .mb-xl-7 {
                margin-bottom: 2.8125rem !important
            }

            .mb-xl-8 {
                margin-bottom: 3.75rem !important
            }

            .mb-xl-9 {
                margin-bottom: 5.625rem !important
            }

            .mb-xl-10 {
                margin-bottom: 8.4375rem !important
            }

            .mb-xl-auto {
                margin-bottom: auto !important
            }

            .ms-xl-0 {
                margin-left: 0 !important
            }

            .ms-xl-1 {
                margin-left: .234375rem !important
            }

            .ms-xl-2 {
                margin-left: .46875rem !important
            }

            .ms-xl-3 {
                margin-left: .624999375rem !important
            }

            .ms-xl-4 {
                margin-left: .9375rem !important
            }

            .ms-xl-5 {
                margin-left: 1.2500000001rem !important
            }

            .ms-xl-6 {
                margin-left: 1.875rem !important
            }

            .ms-xl-7 {
                margin-left: 2.8125rem !important
            }

            .ms-xl-8 {
                margin-left: 3.75rem !important
            }

            .ms-xl-9 {
                margin-left: 5.625rem !important
            }

            .ms-xl-10 {
                margin-left: 8.4375rem !important
            }

            .ms-xl-auto {
                margin-left: auto !important
            }

            .m-xl-n1 {
                margin: -.234375rem !important
            }

            .m-xl-n2 {
                margin: -.46875rem !important
            }

            .m-xl-n3 {
                margin: -.624999375rem !important
            }

            .m-xl-n4 {
                margin: -.9375rem !important
            }

            .m-xl-n5 {
                margin: -1.2500000001rem !important
            }

            .m-xl-n6 {
                margin: -1.875rem !important
            }

            .m-xl-n7 {
                margin: -2.8125rem !important
            }

            .m-xl-n8 {
                margin: -3.75rem !important
            }

            .m-xl-n9 {
                margin: -5.625rem !important
            }

            .m-xl-n10 {
                margin: -8.4375rem !important
            }

            .mx-xl-n1 {
                margin-left: -.234375rem !important;
                margin-right: -.234375rem !important
            }

            .mx-xl-n2 {
                margin-left: -.46875rem !important;
                margin-right: -.46875rem !important
            }

            .mx-xl-n3 {
                margin-left: -.624999375rem !important;
                margin-right: -.624999375rem !important
            }

            .mx-xl-n4 {
                margin-left: -.9375rem !important;
                margin-right: -.9375rem !important
            }

            .mx-xl-n5 {
                margin-left: -1.2500000001rem !important;
                margin-right: -1.2500000001rem !important
            }

            .mx-xl-n6 {
                margin-left: -1.875rem !important;
                margin-right: -1.875rem !important
            }

            .mx-xl-n7 {
                margin-left: -2.8125rem !important;
                margin-right: -2.8125rem !important
            }

            .mx-xl-n8 {
                margin-left: -3.75rem !important;
                margin-right: -3.75rem !important
            }

            .mx-xl-n9 {
                margin-left: -5.625rem !important;
                margin-right: -5.625rem !important
            }

            .mx-xl-n10 {
                margin-left: -8.4375rem !important;
                margin-right: -8.4375rem !important
            }

            .my-xl-n1 {
                margin-bottom: -.234375rem !important;
                margin-top: -.234375rem !important
            }

            .my-xl-n2 {
                margin-bottom: -.46875rem !important;
                margin-top: -.46875rem !important
            }

            .my-xl-n3 {
                margin-bottom: -.624999375rem !important;
                margin-top: -.624999375rem !important
            }

            .my-xl-n4 {
                margin-bottom: -.9375rem !important;
                margin-top: -.9375rem !important
            }

            .my-xl-n5 {
                margin-bottom: -1.2500000001rem !important;
                margin-top: -1.2500000001rem !important
            }

            .my-xl-n6 {
                margin-bottom: -1.875rem !important;
                margin-top: -1.875rem !important
            }

            .my-xl-n7 {
                margin-bottom: -2.8125rem !important;
                margin-top: -2.8125rem !important
            }

            .my-xl-n8 {
                margin-bottom: -3.75rem !important;
                margin-top: -3.75rem !important
            }

            .my-xl-n9 {
                margin-bottom: -5.625rem !important;
                margin-top: -5.625rem !important
            }

            .my-xl-n10 {
                margin-bottom: -8.4375rem !important;
                margin-top: -8.4375rem !important
            }

            .mt-xl-n1 {
                margin-top: -.234375rem !important
            }

            .mt-xl-n2 {
                margin-top: -.46875rem !important
            }

            .mt-xl-n3 {
                margin-top: -.624999375rem !important
            }

            .mt-xl-n4 {
                margin-top: -.9375rem !important
            }

            .mt-xl-n5 {
                margin-top: -1.2500000001rem !important
            }

            .mt-xl-n6 {
                margin-top: -1.875rem !important
            }

            .mt-xl-n7 {
                margin-top: -2.8125rem !important
            }

            .mt-xl-n8 {
                margin-top: -3.75rem !important
            }

            .mt-xl-n9 {
                margin-top: -5.625rem !important
            }

            .mt-xl-n10 {
                margin-top: -8.4375rem !important
            }

            .me-xl-n1 {
                margin-right: -.234375rem !important
            }

            .me-xl-n2 {
                margin-right: -.46875rem !important
            }

            .me-xl-n3 {
                margin-right: -.624999375rem !important
            }

            .me-xl-n4 {
                margin-right: -.9375rem !important
            }

            .me-xl-n5 {
                margin-right: -1.2500000001rem !important
            }

            .me-xl-n6 {
                margin-right: -1.875rem !important
            }

            .me-xl-n7 {
                margin-right: -2.8125rem !important
            }

            .me-xl-n8 {
                margin-right: -3.75rem !important
            }

            .me-xl-n9 {
                margin-right: -5.625rem !important
            }

            .me-xl-n10 {
                margin-right: -8.4375rem !important
            }

            .mb-xl-n1 {
                margin-bottom: -.234375rem !important
            }

            .mb-xl-n2 {
                margin-bottom: -.46875rem !important
            }

            .mb-xl-n3 {
                margin-bottom: -.624999375rem !important
            }

            .mb-xl-n4 {
                margin-bottom: -.9375rem !important
            }

            .mb-xl-n5 {
                margin-bottom: -1.2500000001rem !important
            }

            .mb-xl-n6 {
                margin-bottom: -1.875rem !important
            }

            .mb-xl-n7 {
                margin-bottom: -2.8125rem !important
            }

            .mb-xl-n8 {
                margin-bottom: -3.75rem !important
            }

            .mb-xl-n9 {
                margin-bottom: -5.625rem !important
            }

            .mb-xl-n10 {
                margin-bottom: -8.4375rem !important
            }

            .ms-xl-n1 {
                margin-left: -.234375rem !important
            }

            .ms-xl-n2 {
                margin-left: -.46875rem !important
            }

            .ms-xl-n3 {
                margin-left: -.624999375rem !important
            }

            .ms-xl-n4 {
                margin-left: -.9375rem !important
            }

            .ms-xl-n5 {
                margin-left: -1.2500000001rem !important
            }

            .ms-xl-n6 {
                margin-left: -1.875rem !important
            }

            .ms-xl-n7 {
                margin-left: -2.8125rem !important
            }

            .ms-xl-n8 {
                margin-left: -3.75rem !important
            }

            .ms-xl-n9 {
                margin-left: -5.625rem !important
            }

            .ms-xl-n10 {
                margin-left: -8.4375rem !important
            }

            .p-xl-0 {
                padding: 0 !important
            }

            .p-xl-1 {
                padding: .234375rem !important
            }

            .p-xl-2 {
                padding: .46875rem !important
            }

            .p-xl-3 {
                padding: .624999375rem !important
            }

            .p-xl-4 {
                padding: .9375rem !important
            }

            .p-xl-5 {
                padding: 1.2500000001rem !important
            }

            .p-xl-6 {
                padding: 1.875rem !important
            }

            .p-xl-7 {
                padding: 2.8125rem !important
            }

            .p-xl-8 {
                padding: 3.75rem !important
            }

            .p-xl-9 {
                padding: 5.625rem !important
            }

            .p-xl-10 {
                padding: 8.4375rem !important
            }

            .px-xl-0 {
                padding-left: 0 !important;
                padding-right: 0 !important
            }

            .px-xl-1 {
                padding-left: .234375rem !important;
                padding-right: .234375rem !important
            }

            .px-xl-2 {
                padding-left: .46875rem !important;
                padding-right: .46875rem !important
            }

            .px-xl-3 {
                padding-left: .624999375rem !important;
                padding-right: .624999375rem !important
            }

            .px-xl-4 {
                padding-left: .9375rem !important;
                padding-right: .9375rem !important
            }

            .px-xl-5 {
                padding-left: 1.2500000001rem !important;
                padding-right: 1.2500000001rem !important
            }

            .px-xl-6 {
                padding-left: 1.875rem !important;
                padding-right: 1.875rem !important
            }

            .px-xl-7 {
                padding-left: 2.8125rem !important;
                padding-right: 2.8125rem !important
            }

            .px-xl-8 {
                padding-left: 3.75rem !important;
                padding-right: 3.75rem !important
            }

            .px-xl-9 {
                padding-left: 5.625rem !important;
                padding-right: 5.625rem !important
            }

            .px-xl-10 {
                padding-left: 8.4375rem !important;
                padding-right: 8.4375rem !important
            }

            .py-xl-0 {
                padding-bottom: 0 !important;
                padding-top: 0 !important
            }

            .py-xl-1 {
                padding-bottom: .234375rem !important;
                padding-top: .234375rem !important
            }

            .py-xl-2 {
                padding-bottom: .46875rem !important;
                padding-top: .46875rem !important
            }

            .py-xl-3 {
                padding-bottom: .624999375rem !important;
                padding-top: .624999375rem !important
            }

            .py-xl-4 {
                padding-bottom: .9375rem !important;
                padding-top: .9375rem !important
            }

            .py-xl-5 {
                padding-bottom: 1.2500000001rem !important;
                padding-top: 1.2500000001rem !important
            }

            .py-xl-6 {
                padding-bottom: 1.875rem !important;
                padding-top: 1.875rem !important
            }

            .py-xl-7 {
                padding-bottom: 2.8125rem !important;
                padding-top: 2.8125rem !important
            }

            .py-xl-8 {
                padding-bottom: 3.75rem !important;
                padding-top: 3.75rem !important
            }

            .py-xl-9 {
                padding-bottom: 5.625rem !important;
                padding-top: 5.625rem !important
            }

            .py-xl-10 {
                padding-bottom: 8.4375rem !important;
                padding-top: 8.4375rem !important
            }

            .pt-xl-0 {
                padding-top: 0 !important
            }

            .pt-xl-1 {
                padding-top: .234375rem !important
            }

            .pt-xl-2 {
                padding-top: .46875rem !important
            }

            .pt-xl-3 {
                padding-top: .624999375rem !important
            }

            .pt-xl-4 {
                padding-top: .9375rem !important
            }

            .pt-xl-5 {
                padding-top: 1.2500000001rem !important
            }

            .pt-xl-6 {
                padding-top: 1.875rem !important
            }

            .pt-xl-7 {
                padding-top: 2.8125rem !important
            }

            .pt-xl-8 {
                padding-top: 3.75rem !important
            }

            .pt-xl-9 {
                padding-top: 5.625rem !important
            }

            .pt-xl-10 {
                padding-top: 8.4375rem !important
            }

            .pe-xl-0 {
                padding-right: 0 !important
            }

            .pe-xl-1 {
                padding-right: .234375rem !important
            }

            .pe-xl-2 {
                padding-right: .46875rem !important
            }

            .pe-xl-3 {
                padding-right: .624999375rem !important
            }

            .pe-xl-4 {
                padding-right: .9375rem !important
            }

            .pe-xl-5 {
                padding-right: 1.2500000001rem !important
            }

            .pe-xl-6 {
                padding-right: 1.875rem !important
            }

            .pe-xl-7 {
                padding-right: 2.8125rem !important
            }

            .pe-xl-8 {
                padding-right: 3.75rem !important
            }

            .pe-xl-9 {
                padding-right: 5.625rem !important
            }

            .pe-xl-10 {
                padding-right: 8.4375rem !important
            }

            .pb-xl-0 {
                padding-bottom: 0 !important
            }

            .pb-xl-1 {
                padding-bottom: .234375rem !important
            }

            .pb-xl-2 {
                padding-bottom: .46875rem !important
            }

            .pb-xl-3 {
                padding-bottom: .624999375rem !important
            }

            .pb-xl-4 {
                padding-bottom: .9375rem !important
            }

            .pb-xl-5 {
                padding-bottom: 1.2500000001rem !important
            }

            .pb-xl-6 {
                padding-bottom: 1.875rem !important
            }

            .pb-xl-7 {
                padding-bottom: 2.8125rem !important
            }

            .pb-xl-8 {
                padding-bottom: 3.75rem !important
            }

            .pb-xl-9 {
                padding-bottom: 5.625rem !important
            }

            .pb-xl-10 {
                padding-bottom: 8.4375rem !important
            }

            .ps-xl-0 {
                padding-left: 0 !important
            }

            .ps-xl-1 {
                padding-left: .234375rem !important
            }

            .ps-xl-2 {
                padding-left: .46875rem !important
            }

            .ps-xl-3 {
                padding-left: .624999375rem !important
            }

            .ps-xl-4 {
                padding-left: .9375rem !important
            }

            .ps-xl-5 {
                padding-left: 1.2500000001rem !important
            }

            .ps-xl-6 {
                padding-left: 1.875rem !important
            }

            .ps-xl-7 {
                padding-left: 2.8125rem !important
            }

            .ps-xl-8 {
                padding-left: 3.75rem !important
            }

            .ps-xl-9 {
                padding-left: 5.625rem !important
            }

            .ps-xl-10 {
                padding-left: 8.4375rem !important
            }

            .gap-xl-0 {
                gap: 0 !important
            }

            .gap-xl-1 {
                gap: .234375rem !important
            }

            .gap-xl-2 {
                gap: .46875rem !important
            }

            .gap-xl-3 {
                gap: .624999375rem !important
            }

            .gap-xl-4 {
                gap: .9375rem !important
            }

            .gap-xl-5 {
                gap: 1.2500000001rem !important
            }

            .gap-xl-6 {
                gap: 1.875rem !important
            }

            .gap-xl-7 {
                gap: 2.8125rem !important
            }

            .gap-xl-8 {
                gap: 3.75rem !important
            }

            .gap-xl-9 {
                gap: 5.625rem !important
            }

            .gap-xl-10 {
                gap: 8.4375rem !important
            }

            .text-xl-start {
                text-align: left !important
            }

            .text-xl-end {
                text-align: right !important
            }

            .text-xl-center {
                text-align: center !important
            }

            .min-w-xl-unset {
                min-width: unset !important
            }

            .min-w-xl-25 {
                min-width: 25% !important
            }

            .min-w-xl-50 {
                min-width: 50% !important
            }

            .min-w-xl-75 {
                min-width: 75% !important
            }

            .min-w-xl-100 {
                min-width: 100% !important
            }

            .min-w-xl-auto {
                min-width: auto !important
            }

            .min-w-xl-1px {
                min-width: 1px !important
            }

            .min-w-xl-2px {
                min-width: 2px !important
            }

            .min-w-xl-3px {
                min-width: 3px !important
            }

            .min-w-xl-4px {
                min-width: 4px !important
            }

            .min-w-xl-5px {
                min-width: 5px !important
            }

            .min-w-xl-6px {
                min-width: 6px !important
            }

            .min-w-xl-7px {
                min-width: 7px !important
            }

            .min-w-xl-8px {
                min-width: 8px !important
            }

            .min-w-xl-9px {
                min-width: 9px !important
            }

            .min-w-xl-10px {
                min-width: 10px !important
            }

            .min-w-xl-15px {
                min-width: 15px !important
            }

            .min-w-xl-20px {
                min-width: 20px !important
            }

            .min-w-xl-25px {
                min-width: 25px !important
            }

            .min-w-xl-30px {
                min-width: 30px !important
            }

            .min-w-xl-35px {
                min-width: 35px !important
            }

            .min-w-xl-40px {
                min-width: 40px !important
            }

            .min-w-xl-45px {
                min-width: 45px !important
            }

            .min-w-xl-50px {
                min-width: 50px !important
            }

            .min-w-xl-55px {
                min-width: 55px !important
            }

            .min-w-xl-60px {
                min-width: 60px !important
            }

            .min-w-xl-65px {
                min-width: 65px !important
            }

            .min-w-xl-70px {
                min-width: 70px !important
            }

            .min-w-xl-75px {
                min-width: 75px !important
            }

            .min-w-xl-80px {
                min-width: 80px !important
            }

            .min-w-xl-85px {
                min-width: 85px !important
            }

            .min-w-xl-90px {
                min-width: 90px !important
            }

            .min-w-xl-95px {
                min-width: 95px !important
            }

            .min-w-xl-100px {
                min-width: 100px !important
            }

            .min-w-xl-125px {
                min-width: 125px !important
            }

            .min-w-xl-150px {
                min-width: 150px !important
            }

            .min-w-xl-175px {
                min-width: 175px !important
            }

            .min-w-xl-200px {
                min-width: 200px !important
            }

            .min-w-xl-225px {
                min-width: 225px !important
            }

            .min-w-xl-250px {
                min-width: 250px !important
            }

            .min-w-xl-275px {
                min-width: 275px !important
            }

            .min-w-xl-300px {
                min-width: 300px !important
            }

            .min-w-xl-325px {
                min-width: 325px !important
            }

            .min-w-xl-350px {
                min-width: 350px !important
            }

            .min-w-xl-375px {
                min-width: 375px !important
            }

            .min-w-xl-400px {
                min-width: 400px !important
            }

            .min-w-xl-425px {
                min-width: 425px !important
            }

            .min-w-xl-450px {
                min-width: 450px !important
            }

            .min-w-xl-475px {
                min-width: 475px !important
            }

            .min-w-xl-500px {
                min-width: 500px !important
            }

            .min-w-xl-550px {
                min-width: 550px !important
            }

            .min-w-xl-600px {
                min-width: 600px !important
            }

            .min-w-xl-650px {
                min-width: 650px !important
            }

            .min-w-xl-700px {
                min-width: 700px !important
            }

            .min-w-xl-750px {
                min-width: 750px !important
            }

            .min-w-xl-800px {
                min-width: 800px !important
            }

            .min-w-xl-850px {
                min-width: 850px !important
            }

            .min-w-xl-900px {
                min-width: 900px !important
            }

            .min-w-xl-950px {
                min-width: 950px !important
            }

            .min-w-xl-1000px {
                min-width: 1000px !important
            }

            .min-h-xl-unset {
                min-height: unset !important
            }

            .min-h-xl-25 {
                min-height: 25% !important
            }

            .min-h-xl-50 {
                min-height: 50% !important
            }

            .min-h-xl-75 {
                min-height: 75% !important
            }

            .min-h-xl-100 {
                min-height: 100% !important
            }

            .min-h-xl-auto {
                min-height: auto !important
            }

            .min-h-xl-1px {
                min-height: 1px !important
            }

            .min-h-xl-2px {
                min-height: 2px !important
            }

            .min-h-xl-3px {
                min-height: 3px !important
            }

            .min-h-xl-4px {
                min-height: 4px !important
            }

            .min-h-xl-5px {
                min-height: 5px !important
            }

            .min-h-xl-6px {
                min-height: 6px !important
            }

            .min-h-xl-7px {
                min-height: 7px !important
            }

            .min-h-xl-8px {
                min-height: 8px !important
            }

            .min-h-xl-9px {
                min-height: 9px !important
            }

            .min-h-xl-10px {
                min-height: 10px !important
            }

            .min-h-xl-15px {
                min-height: 15px !important
            }

            .min-h-xl-20px {
                min-height: 20px !important
            }

            .min-h-xl-25px {
                min-height: 25px !important
            }

            .min-h-xl-30px {
                min-height: 30px !important
            }

            .min-h-xl-35px {
                min-height: 35px !important
            }

            .min-h-xl-40px {
                min-height: 40px !important
            }

            .min-h-xl-45px {
                min-height: 45px !important
            }

            .min-h-xl-50px {
                min-height: 50px !important
            }

            .min-h-xl-55px {
                min-height: 55px !important
            }

            .min-h-xl-60px {
                min-height: 60px !important
            }

            .min-h-xl-65px {
                min-height: 65px !important
            }

            .min-h-xl-70px {
                min-height: 70px !important
            }

            .min-h-xl-75px {
                min-height: 75px !important
            }

            .min-h-xl-80px {
                min-height: 80px !important
            }

            .min-h-xl-85px {
                min-height: 85px !important
            }

            .min-h-xl-90px {
                min-height: 90px !important
            }

            .min-h-xl-95px {
                min-height: 95px !important
            }

            .min-h-xl-100px {
                min-height: 100px !important
            }

            .min-h-xl-125px {
                min-height: 125px !important
            }

            .min-h-xl-150px {
                min-height: 150px !important
            }

            .min-h-xl-175px {
                min-height: 175px !important
            }

            .min-h-xl-200px {
                min-height: 200px !important
            }

            .min-h-xl-225px {
                min-height: 225px !important
            }

            .min-h-xl-250px {
                min-height: 250px !important
            }

            .min-h-xl-275px {
                min-height: 275px !important
            }

            .min-h-xl-300px {
                min-height: 300px !important
            }

            .min-h-xl-325px {
                min-height: 325px !important
            }

            .min-h-xl-350px {
                min-height: 350px !important
            }

            .min-h-xl-375px {
                min-height: 375px !important
            }

            .min-h-xl-400px {
                min-height: 400px !important
            }

            .min-h-xl-425px {
                min-height: 425px !important
            }

            .min-h-xl-450px {
                min-height: 450px !important
            }

            .min-h-xl-475px {
                min-height: 475px !important
            }

            .min-h-xl-500px {
                min-height: 500px !important
            }

            .min-h-xl-550px {
                min-height: 550px !important
            }

            .min-h-xl-600px {
                min-height: 600px !important
            }

            .min-h-xl-650px {
                min-height: 650px !important
            }

            .min-h-xl-700px {
                min-height: 700px !important
            }

            .min-h-xl-750px {
                min-height: 750px !important
            }

            .min-h-xl-800px {
                min-height: 800px !important
            }

            .min-h-xl-850px {
                min-height: 850px !important
            }

            .min-h-xl-900px {
                min-height: 900px !important
            }

            .min-h-xl-950px {
                min-height: 950px !important
            }

            .min-h-xl-1000px {
                min-height: 1000px !important
            }

            .scroll-m-xl-0 {
                scroll-margin: 0 !important
            }

            .scroll-m-xl-1 {
                scroll-margin: .234375rem !important
            }

            .scroll-m-xl-2 {
                scroll-margin: .46875rem !important
            }

            .scroll-m-xl-3 {
                scroll-margin: .624999375rem !important
            }

            .scroll-m-xl-4 {
                scroll-margin: .9375rem !important
            }

            .scroll-m-xl-5 {
                scroll-margin: 1.2500000001rem !important
            }

            .scroll-m-xl-6 {
                scroll-margin: 1.875rem !important
            }

            .scroll-m-xl-7 {
                scroll-margin: 2.8125rem !important
            }

            .scroll-m-xl-8 {
                scroll-margin: 3.75rem !important
            }

            .scroll-m-xl-9 {
                scroll-margin: 5.625rem !important
            }

            .scroll-m-xl-10 {
                scroll-margin: 8.4375rem !important
            }

            .scroll-m-xl-auto {
                scroll-margin: auto !important
            }

            .scroll-mx-xl-0 {
                scroll-margin-left: 0 !important;
                scroll-margin-right: 0 !important
            }

            .scroll-mx-xl-1 {
                scroll-margin-left: .234375rem !important;
                scroll-margin-right: .234375rem !important
            }

            .scroll-mx-xl-2 {
                scroll-margin-left: .46875rem !important;
                scroll-margin-right: .46875rem !important
            }

            .scroll-mx-xl-3 {
                scroll-margin-left: .624999375rem !important;
                scroll-margin-right: .624999375rem !important
            }

            .scroll-mx-xl-4 {
                scroll-margin-left: .9375rem !important;
                scroll-margin-right: .9375rem !important
            }

            .scroll-mx-xl-5 {
                scroll-margin-left: 1.2500000001rem !important;
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-mx-xl-6 {
                scroll-margin-left: 1.875rem !important;
                scroll-margin-right: 1.875rem !important
            }

            .scroll-mx-xl-7 {
                scroll-margin-left: 2.8125rem !important;
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-mx-xl-8 {
                scroll-margin-left: 3.75rem !important;
                scroll-margin-right: 3.75rem !important
            }

            .scroll-mx-xl-9 {
                scroll-margin-left: 5.625rem !important;
                scroll-margin-right: 5.625rem !important
            }

            .scroll-mx-xl-10 {
                scroll-margin-left: 8.4375rem !important;
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-mx-xl-auto {
                scroll-margin-left: auto !important;
                scroll-margin-right: auto !important
            }

            .scroll-my-xl-0 {
                scroll-margin-bottom: 0 !important;
                scroll-margin-top: 0 !important
            }

            .scroll-my-xl-1 {
                scroll-margin-bottom: .234375rem !important;
                scroll-margin-top: .234375rem !important
            }

            .scroll-my-xl-2 {
                scroll-margin-bottom: .46875rem !important;
                scroll-margin-top: .46875rem !important
            }

            .scroll-my-xl-3 {
                scroll-margin-bottom: .624999375rem !important;
                scroll-margin-top: .624999375rem !important
            }

            .scroll-my-xl-4 {
                scroll-margin-bottom: .9375rem !important;
                scroll-margin-top: .9375rem !important
            }

            .scroll-my-xl-5 {
                scroll-margin-bottom: 1.2500000001rem !important;
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-my-xl-6 {
                scroll-margin-bottom: 1.875rem !important;
                scroll-margin-top: 1.875rem !important
            }

            .scroll-my-xl-7 {
                scroll-margin-bottom: 2.8125rem !important;
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-my-xl-8 {
                scroll-margin-bottom: 3.75rem !important;
                scroll-margin-top: 3.75rem !important
            }

            .scroll-my-xl-9 {
                scroll-margin-bottom: 5.625rem !important;
                scroll-margin-top: 5.625rem !important
            }

            .scroll-my-xl-10 {
                scroll-margin-bottom: 8.4375rem !important;
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-my-xl-auto {
                scroll-margin-bottom: auto !important;
                scroll-margin-top: auto !important
            }

            .scroll-mt-xl-0 {
                scroll-margin-top: 0 !important
            }

            .scroll-mt-xl-1 {
                scroll-margin-top: .234375rem !important
            }

            .scroll-mt-xl-2 {
                scroll-margin-top: .46875rem !important
            }

            .scroll-mt-xl-3 {
                scroll-margin-top: .624999375rem !important
            }

            .scroll-mt-xl-4 {
                scroll-margin-top: .9375rem !important
            }

            .scroll-mt-xl-5 {
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-mt-xl-6 {
                scroll-margin-top: 1.875rem !important
            }

            .scroll-mt-xl-7 {
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-mt-xl-8 {
                scroll-margin-top: 3.75rem !important
            }

            .scroll-mt-xl-9 {
                scroll-margin-top: 5.625rem !important
            }

            .scroll-mt-xl-10 {
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-mt-xl-auto {
                scroll-margin-top: auto !important
            }

            .scroll-me-xl-0 {
                scroll-margin-right: 0 !important
            }

            .scroll-me-xl-1 {
                scroll-margin-right: .234375rem !important
            }

            .scroll-me-xl-2 {
                scroll-margin-right: .46875rem !important
            }

            .scroll-me-xl-3 {
                scroll-margin-right: .624999375rem !important
            }

            .scroll-me-xl-4 {
                scroll-margin-right: .9375rem !important
            }

            .scroll-me-xl-5 {
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-me-xl-6 {
                scroll-margin-right: 1.875rem !important
            }

            .scroll-me-xl-7 {
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-me-xl-8 {
                scroll-margin-right: 3.75rem !important
            }

            .scroll-me-xl-9 {
                scroll-margin-right: 5.625rem !important
            }

            .scroll-me-xl-10 {
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-me-xl-auto {
                scroll-margin-right: auto !important
            }

            .scroll-mb-xl-0 {
                scroll-margin-bottom: 0 !important
            }

            .scroll-mb-xl-1 {
                scroll-margin-bottom: .234375rem !important
            }

            .scroll-mb-xl-2 {
                scroll-margin-bottom: .46875rem !important
            }

            .scroll-mb-xl-3 {
                scroll-margin-bottom: .624999375rem !important
            }

            .scroll-mb-xl-4 {
                scroll-margin-bottom: .9375rem !important
            }

            .scroll-mb-xl-5 {
                scroll-margin-bottom: 1.2500000001rem !important
            }

            .scroll-mb-xl-6 {
                scroll-margin-bottom: 1.875rem !important
            }

            .scroll-mb-xl-7 {
                scroll-margin-bottom: 2.8125rem !important
            }

            .scroll-mb-xl-8 {
                scroll-margin-bottom: 3.75rem !important
            }

            .scroll-mb-xl-9 {
                scroll-margin-bottom: 5.625rem !important
            }

            .scroll-mb-xl-10 {
                scroll-margin-bottom: 8.4375rem !important
            }

            .scroll-mb-xl-auto {
                scroll-margin-bottom: auto !important
            }

            .scroll-ms-xl-0 {
                scroll-margin-left: 0 !important
            }

            .scroll-ms-xl-1 {
                scroll-margin-left: .234375rem !important
            }

            .scroll-ms-xl-2 {
                scroll-margin-left: .46875rem !important
            }

            .scroll-ms-xl-3 {
                scroll-margin-left: .624999375rem !important
            }

            .scroll-ms-xl-4 {
                scroll-margin-left: .9375rem !important
            }

            .scroll-ms-xl-5 {
                scroll-margin-left: 1.2500000001rem !important
            }

            .scroll-ms-xl-6 {
                scroll-margin-left: 1.875rem !important
            }

            .scroll-ms-xl-7 {
                scroll-margin-left: 2.8125rem !important
            }

            .scroll-ms-xl-8 {
                scroll-margin-left: 3.75rem !important
            }

            .scroll-ms-xl-9 {
                scroll-margin-left: 5.625rem !important
            }

            .scroll-ms-xl-10 {
                scroll-margin-left: 8.4375rem !important
            }

            .scroll-ms-xl-auto {
                scroll-margin-left: auto !important
            }

            .object-fit-xl-contain {
                -o-object-fit: contain !important;
                object-fit: contain !important
            }

            .object-fit-xl-cover {
                -o-object-fit: cover !important;
                object-fit: cover !important
            }

            .object-fit-xl-fill {
                -o-object-fit: fill !important;
                object-fit: fill !important
            }

            .object-fit-xl-scale {
                -o-object-fit: scale-down !important;
                object-fit: scale-down !important
            }

            .object-fit-xl-none {
                -o-object-fit: none !important;
                object-fit: none !important
            }
        }

        @media(min-width:1400px) {
            .float-xxl-start {
                float: left !important
            }

            .float-xxl-end {
                float: right !important
            }

            .float-xxl-none {
                float: none !important
            }

            .d-xxl-inline {
                display: inline !important
            }

            .d-xxl-inline-block {
                display: inline-block !important
            }

            .d-xxl-block {
                display: block !important
            }

            .d-xxl-grid {
                display: grid !important
            }

            .d-xxl-table {
                display: table !important
            }

            .d-xxl-table-row {
                display: table-row !important
            }

            .d-xxl-table-cell {
                display: table-cell !important
            }

            .d-xxl-flex {
                display: flex !important
            }

            .d-xxl-inline-flex {
                display: inline-flex !important
            }

            .d-xxl-none {
                display: none !important
            }

            .position-xxl-static {
                position: static !important
            }

            .position-xxl-relative {
                position: relative !important
            }

            .position-xxl-absolute {
                position: absolute !important
            }

            .position-xxl-fixed {
                position: fixed !important
            }

            .position-xxl-sticky {
                position: -webkit-sticky !important;
                position: sticky !important
            }

            .w-xxl-unset {
                width: unset !important
            }

            .w-xxl-25 {
                width: 25% !important
            }

            .w-xxl-50 {
                width: 50% !important
            }

            .w-xxl-75 {
                width: 75% !important
            }

            .w-xxl-100 {
                width: 100% !important
            }

            .w-xxl-auto {
                width: auto !important
            }

            .w-xxl-1px {
                width: 1px !important
            }

            .w-xxl-2px {
                width: 2px !important
            }

            .w-xxl-3px {
                width: 3px !important
            }

            .w-xxl-4px {
                width: 4px !important
            }

            .w-xxl-5px {
                width: 5px !important
            }

            .w-xxl-6px {
                width: 6px !important
            }

            .w-xxl-7px {
                width: 7px !important
            }

            .w-xxl-8px {
                width: 8px !important
            }

            .w-xxl-9px {
                width: 9px !important
            }

            .w-xxl-10px {
                width: 10px !important
            }

            .w-xxl-15px {
                width: 15px !important
            }

            .w-xxl-20px {
                width: 20px !important
            }

            .w-xxl-25px {
                width: 25px !important
            }

            .w-xxl-30px {
                width: 30px !important
            }

            .w-xxl-35px {
                width: 35px !important
            }

            .w-xxl-40px {
                width: 40px !important
            }

            .w-xxl-45px {
                width: 45px !important
            }

            .w-xxl-50px {
                width: 50px !important
            }

            .w-xxl-55px {
                width: 55px !important
            }

            .w-xxl-60px {
                width: 60px !important
            }

            .w-xxl-65px {
                width: 65px !important
            }

            .w-xxl-70px {
                width: 70px !important
            }

            .w-xxl-75px {
                width: 75px !important
            }

            .w-xxl-80px {
                width: 80px !important
            }

            .w-xxl-85px {
                width: 85px !important
            }

            .w-xxl-90px {
                width: 90px !important
            }

            .w-xxl-95px {
                width: 95px !important
            }

            .w-xxl-100px {
                width: 100px !important
            }

            .w-xxl-125px {
                width: 125px !important
            }

            .w-xxl-150px {
                width: 150px !important
            }

            .w-xxl-175px {
                width: 175px !important
            }

            .w-xxl-200px {
                width: 200px !important
            }

            .w-xxl-225px {
                width: 225px !important
            }

            .w-xxl-250px {
                width: 250px !important
            }

            .w-xxl-275px {
                width: 275px !important
            }

            .w-xxl-300px {
                width: 300px !important
            }

            .w-xxl-325px {
                width: 325px !important
            }

            .w-xxl-350px {
                width: 350px !important
            }

            .w-xxl-375px {
                width: 375px !important
            }

            .w-xxl-400px {
                width: 400px !important
            }

            .w-xxl-425px {
                width: 425px !important
            }

            .w-xxl-450px {
                width: 450px !important
            }

            .w-xxl-475px {
                width: 475px !important
            }

            .w-xxl-500px {
                width: 500px !important
            }

            .w-xxl-550px {
                width: 550px !important
            }

            .w-xxl-600px {
                width: 600px !important
            }

            .w-xxl-650px {
                width: 650px !important
            }

            .w-xxl-700px {
                width: 700px !important
            }

            .w-xxl-750px {
                width: 750px !important
            }

            .w-xxl-800px {
                width: 800px !important
            }

            .w-xxl-850px {
                width: 850px !important
            }

            .w-xxl-900px {
                width: 900px !important
            }

            .w-xxl-950px {
                width: 950px !important
            }

            .w-xxl-1000px {
                width: 1000px !important
            }

            .mw-xxl-unset {
                max-width: unset !important
            }

            .mw-xxl-25 {
                max-width: 25% !important
            }

            .mw-xxl-50 {
                max-width: 50% !important
            }

            .mw-xxl-75 {
                max-width: 75% !important
            }

            .mw-xxl-100 {
                max-width: 100% !important
            }

            .mw-xxl-auto {
                max-width: auto !important
            }

            .mw-xxl-1px {
                max-width: 1px !important
            }

            .mw-xxl-2px {
                max-width: 2px !important
            }

            .mw-xxl-3px {
                max-width: 3px !important
            }

            .mw-xxl-4px {
                max-width: 4px !important
            }

            .mw-xxl-5px {
                max-width: 5px !important
            }

            .mw-xxl-6px {
                max-width: 6px !important
            }

            .mw-xxl-7px {
                max-width: 7px !important
            }

            .mw-xxl-8px {
                max-width: 8px !important
            }

            .mw-xxl-9px {
                max-width: 9px !important
            }

            .mw-xxl-10px {
                max-width: 10px !important
            }

            .mw-xxl-15px {
                max-width: 15px !important
            }

            .mw-xxl-20px {
                max-width: 20px !important
            }

            .mw-xxl-25px {
                max-width: 25px !important
            }

            .mw-xxl-30px {
                max-width: 30px !important
            }

            .mw-xxl-35px {
                max-width: 35px !important
            }

            .mw-xxl-40px {
                max-width: 40px !important
            }

            .mw-xxl-45px {
                max-width: 45px !important
            }

            .mw-xxl-50px {
                max-width: 50px !important
            }

            .mw-xxl-55px {
                max-width: 55px !important
            }

            .mw-xxl-60px {
                max-width: 60px !important
            }

            .mw-xxl-65px {
                max-width: 65px !important
            }

            .mw-xxl-70px {
                max-width: 70px !important
            }

            .mw-xxl-75px {
                max-width: 75px !important
            }

            .mw-xxl-80px {
                max-width: 80px !important
            }

            .mw-xxl-85px {
                max-width: 85px !important
            }

            .mw-xxl-90px {
                max-width: 90px !important
            }

            .mw-xxl-95px {
                max-width: 95px !important
            }

            .mw-xxl-100px {
                max-width: 100px !important
            }

            .mw-xxl-125px {
                max-width: 125px !important
            }

            .mw-xxl-150px {
                max-width: 150px !important
            }

            .mw-xxl-175px {
                max-width: 175px !important
            }

            .mw-xxl-200px {
                max-width: 200px !important
            }

            .mw-xxl-225px {
                max-width: 225px !important
            }

            .mw-xxl-250px {
                max-width: 250px !important
            }

            .mw-xxl-275px {
                max-width: 275px !important
            }

            .mw-xxl-300px {
                max-width: 300px !important
            }

            .mw-xxl-325px {
                max-width: 325px !important
            }

            .mw-xxl-350px {
                max-width: 350px !important
            }

            .mw-xxl-375px {
                max-width: 375px !important
            }

            .mw-xxl-400px {
                max-width: 400px !important
            }

            .mw-xxl-425px {
                max-width: 425px !important
            }

            .mw-xxl-450px {
                max-width: 450px !important
            }

            .mw-xxl-475px {
                max-width: 475px !important
            }

            .mw-xxl-500px {
                max-width: 500px !important
            }

            .mw-xxl-550px {
                max-width: 550px !important
            }

            .mw-xxl-600px {
                max-width: 600px !important
            }

            .mw-xxl-650px {
                max-width: 650px !important
            }

            .mw-xxl-700px {
                max-width: 700px !important
            }

            .mw-xxl-750px {
                max-width: 750px !important
            }

            .mw-xxl-800px {
                max-width: 800px !important
            }

            .mw-xxl-850px {
                max-width: 850px !important
            }

            .mw-xxl-900px {
                max-width: 900px !important
            }

            .mw-xxl-950px {
                max-width: 950px !important
            }

            .mw-xxl-1000px {
                max-width: 1000px !important
            }

            .vw-xxl-25 {
                width: 25vw !important
            }

            .vw-xxl-50 {
                width: 50vw !important
            }

            .vw-xxl-75 {
                width: 75vw !important
            }

            .vw-xxl-100 {
                width: 100vw !important
            }

            .vw-xxl-auto {
                width: auto !important
            }

            .min-vw-xxl-25 {
                min-width: 25vw !important
            }

            .min-vw-xxl-50 {
                min-width: 50vw !important
            }

            .min-vw-xxl-75 {
                min-width: 75vw !important
            }

            .min-vw-xxl-100 {
                min-width: 100vw !important
            }

            .min-vw-xxl-auto {
                min-width: auto !important
            }

            .h-xxl-unset {
                height: unset !important
            }

            .h-xxl-25 {
                height: 25% !important
            }

            .h-xxl-50 {
                height: 50% !important
            }

            .h-xxl-75 {
                height: 75% !important
            }

            .h-xxl-100 {
                height: 100% !important
            }

            .h-xxl-auto {
                height: auto !important
            }

            .h-xxl-1px {
                height: 1px !important
            }

            .h-xxl-2px {
                height: 2px !important
            }

            .h-xxl-3px {
                height: 3px !important
            }

            .h-xxl-4px {
                height: 4px !important
            }

            .h-xxl-5px {
                height: 5px !important
            }

            .h-xxl-6px {
                height: 6px !important
            }

            .h-xxl-7px {
                height: 7px !important
            }

            .h-xxl-8px {
                height: 8px !important
            }

            .h-xxl-9px {
                height: 9px !important
            }

            .h-xxl-10px {
                height: 10px !important
            }

            .h-xxl-15px {
                height: 15px !important
            }

            .h-xxl-20px {
                height: 20px !important
            }

            .h-xxl-25px {
                height: 25px !important
            }

            .h-xxl-30px {
                height: 30px !important
            }

            .h-xxl-35px {
                height: 35px !important
            }

            .h-xxl-40px {
                height: 40px !important
            }

            .h-xxl-45px {
                height: 45px !important
            }

            .h-xxl-50px {
                height: 50px !important
            }

            .h-xxl-55px {
                height: 55px !important
            }

            .h-xxl-60px {
                height: 60px !important
            }

            .h-xxl-65px {
                height: 65px !important
            }

            .h-xxl-70px {
                height: 70px !important
            }

            .h-xxl-75px {
                height: 75px !important
            }

            .h-xxl-80px {
                height: 80px !important
            }

            .h-xxl-85px {
                height: 85px !important
            }

            .h-xxl-90px {
                height: 90px !important
            }

            .h-xxl-95px {
                height: 95px !important
            }

            .h-xxl-100px {
                height: 100px !important
            }

            .h-xxl-125px {
                height: 125px !important
            }

            .h-xxl-150px {
                height: 150px !important
            }

            .h-xxl-175px {
                height: 175px !important
            }

            .h-xxl-200px {
                height: 200px !important
            }

            .h-xxl-225px {
                height: 225px !important
            }

            .h-xxl-250px {
                height: 250px !important
            }

            .h-xxl-275px {
                height: 275px !important
            }

            .h-xxl-300px {
                height: 300px !important
            }

            .h-xxl-325px {
                height: 325px !important
            }

            .h-xxl-350px {
                height: 350px !important
            }

            .h-xxl-375px {
                height: 375px !important
            }

            .h-xxl-400px {
                height: 400px !important
            }

            .h-xxl-425px {
                height: 425px !important
            }

            .h-xxl-450px {
                height: 450px !important
            }

            .h-xxl-475px {
                height: 475px !important
            }

            .h-xxl-500px {
                height: 500px !important
            }

            .h-xxl-550px {
                height: 550px !important
            }

            .h-xxl-600px {
                height: 600px !important
            }

            .h-xxl-650px {
                height: 650px !important
            }

            .h-xxl-700px {
                height: 700px !important
            }

            .h-xxl-750px {
                height: 750px !important
            }

            .h-xxl-800px {
                height: 800px !important
            }

            .h-xxl-850px {
                height: 850px !important
            }

            .h-xxl-900px {
                height: 900px !important
            }

            .h-xxl-950px {
                height: 950px !important
            }

            .h-xxl-1000px {
                height: 1000px !important
            }

            .mh-xxl-unset {
                max-height: unset !important
            }

            .mh-xxl-25 {
                max-height: 25% !important
            }

            .mh-xxl-50 {
                max-height: 50% !important
            }

            .mh-xxl-75 {
                max-height: 75% !important
            }

            .mh-xxl-100 {
                max-height: 100% !important
            }

            .mh-xxl-auto {
                max-height: auto !important
            }

            .mh-xxl-1px {
                max-height: 1px !important
            }

            .mh-xxl-2px {
                max-height: 2px !important
            }

            .mh-xxl-3px {
                max-height: 3px !important
            }

            .mh-xxl-4px {
                max-height: 4px !important
            }

            .mh-xxl-5px {
                max-height: 5px !important
            }

            .mh-xxl-6px {
                max-height: 6px !important
            }

            .mh-xxl-7px {
                max-height: 7px !important
            }

            .mh-xxl-8px {
                max-height: 8px !important
            }

            .mh-xxl-9px {
                max-height: 9px !important
            }

            .mh-xxl-10px {
                max-height: 10px !important
            }

            .mh-xxl-15px {
                max-height: 15px !important
            }

            .mh-xxl-20px {
                max-height: 20px !important
            }

            .mh-xxl-25px {
                max-height: 25px !important
            }

            .mh-xxl-30px {
                max-height: 30px !important
            }

            .mh-xxl-35px {
                max-height: 35px !important
            }

            .mh-xxl-40px {
                max-height: 40px !important
            }

            .mh-xxl-45px {
                max-height: 45px !important
            }

            .mh-xxl-50px {
                max-height: 50px !important
            }

            .mh-xxl-55px {
                max-height: 55px !important
            }

            .mh-xxl-60px {
                max-height: 60px !important
            }

            .mh-xxl-65px {
                max-height: 65px !important
            }

            .mh-xxl-70px {
                max-height: 70px !important
            }

            .mh-xxl-75px {
                max-height: 75px !important
            }

            .mh-xxl-80px {
                max-height: 80px !important
            }

            .mh-xxl-85px {
                max-height: 85px !important
            }

            .mh-xxl-90px {
                max-height: 90px !important
            }

            .mh-xxl-95px {
                max-height: 95px !important
            }

            .mh-xxl-100px {
                max-height: 100px !important
            }

            .mh-xxl-125px {
                max-height: 125px !important
            }

            .mh-xxl-150px {
                max-height: 150px !important
            }

            .mh-xxl-175px {
                max-height: 175px !important
            }

            .mh-xxl-200px {
                max-height: 200px !important
            }

            .mh-xxl-225px {
                max-height: 225px !important
            }

            .mh-xxl-250px {
                max-height: 250px !important
            }

            .mh-xxl-275px {
                max-height: 275px !important
            }

            .mh-xxl-300px {
                max-height: 300px !important
            }

            .mh-xxl-325px {
                max-height: 325px !important
            }

            .mh-xxl-350px {
                max-height: 350px !important
            }

            .mh-xxl-375px {
                max-height: 375px !important
            }

            .mh-xxl-400px {
                max-height: 400px !important
            }

            .mh-xxl-425px {
                max-height: 425px !important
            }

            .mh-xxl-450px {
                max-height: 450px !important
            }

            .mh-xxl-475px {
                max-height: 475px !important
            }

            .mh-xxl-500px {
                max-height: 500px !important
            }

            .mh-xxl-550px {
                max-height: 550px !important
            }

            .mh-xxl-600px {
                max-height: 600px !important
            }

            .mh-xxl-650px {
                max-height: 650px !important
            }

            .mh-xxl-700px {
                max-height: 700px !important
            }

            .mh-xxl-750px {
                max-height: 750px !important
            }

            .mh-xxl-800px {
                max-height: 800px !important
            }

            .mh-xxl-850px {
                max-height: 850px !important
            }

            .mh-xxl-900px {
                max-height: 900px !important
            }

            .mh-xxl-950px {
                max-height: 950px !important
            }

            .mh-xxl-1000px {
                max-height: 1000px !important
            }

            .vh-xxl-25 {
                height: 25vh !important
            }

            .vh-xxl-50 {
                height: 50vh !important
            }

            .vh-xxl-75 {
                height: 75vh !important
            }

            .vh-xxl-100 {
                height: 100vh !important
            }

            .vh-xxl-auto {
                height: auto !important
            }

            .min-vh-xxl-25 {
                min-height: 25vh !important
            }

            .min-vh-xxl-50 {
                min-height: 50vh !important
            }

            .min-vh-xxl-75 {
                min-height: 75vh !important
            }

            .min-vh-xxl-100 {
                min-height: 100vh !important
            }

            .min-vh-xxl-auto {
                min-height: auto !important
            }

            .flex-xxl-fill {
                flex: 1 1 auto !important
            }

            .flex-xxl-row {
                flex-direction: row !important
            }

            .flex-xxl-column {
                flex-direction: column !important
            }

            .flex-xxl-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-xxl-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-xxl-grow-0 {
                flex-grow: 0 !important
            }

            .flex-xxl-grow-1 {
                flex-grow: 1 !important
            }

            .flex-xxl-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-xxl-shrink-1 {
                flex-shrink: 1 !important
            }

            .flex-xxl-wrap {
                flex-wrap: wrap !important
            }

            .flex-xxl-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-xxl-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .justify-content-xxl-start {
                justify-content: flex-start !important
            }

            .justify-content-xxl-end {
                justify-content: flex-end !important
            }

            .justify-content-xxl-center {
                justify-content: center !important
            }

            .justify-content-xxl-between {
                justify-content: space-between !important
            }

            .justify-content-xxl-around {
                justify-content: space-around !important
            }

            .justify-content-xxl-evenly {
                justify-content: space-evenly !important
            }

            .align-items-xxl-start {
                align-items: flex-start !important
            }

            .align-items-xxl-end {
                align-items: flex-end !important
            }

            .align-items-xxl-center {
                align-items: center !important
            }

            .align-items-xxl-baseline {
                align-items: baseline !important
            }

            .align-items-xxl-stretch {
                align-items: stretch !important
            }

            .align-content-xxl-start {
                align-content: flex-start !important
            }

            .align-content-xxl-end {
                align-content: flex-end !important
            }

            .align-content-xxl-center {
                align-content: center !important
            }

            .align-content-xxl-between {
                align-content: space-between !important
            }

            .align-content-xxl-around {
                align-content: space-around !important
            }

            .align-content-xxl-stretch {
                align-content: stretch !important
            }

            .align-self-xxl-auto {
                align-self: auto !important
            }

            .align-self-xxl-start {
                align-self: flex-start !important
            }

            .align-self-xxl-end {
                align-self: flex-end !important
            }

            .align-self-xxl-center {
                align-self: center !important
            }

            .align-self-xxl-baseline {
                align-self: baseline !important
            }

            .align-self-xxl-stretch {
                align-self: stretch !important
            }

            .order-xxl-first {
                order: -1 !important
            }

            .order-xxl-0 {
                order: 0 !important
            }

            .order-xxl-1 {
                order: 1 !important
            }

            .order-xxl-2 {
                order: 2 !important
            }

            .order-xxl-3 {
                order: 3 !important
            }

            .order-xxl-4 {
                order: 4 !important
            }

            .order-xxl-5 {
                order: 5 !important
            }

            .order-xxl-last {
                order: 6 !important
            }

            .m-xxl-0 {
                margin: 0 !important
            }

            .m-xxl-1 {
                margin: .234375rem !important
            }

            .m-xxl-2 {
                margin: .46875rem !important
            }

            .m-xxl-3 {
                margin: .624999375rem !important
            }

            .m-xxl-4 {
                margin: .9375rem !important
            }

            .m-xxl-5 {
                margin: 1.2500000001rem !important
            }

            .m-xxl-6 {
                margin: 1.875rem !important
            }

            .m-xxl-7 {
                margin: 2.8125rem !important
            }

            .m-xxl-8 {
                margin: 3.75rem !important
            }

            .m-xxl-9 {
                margin: 5.625rem !important
            }

            .m-xxl-10 {
                margin: 8.4375rem !important
            }

            .m-xxl-auto {
                margin: auto !important
            }

            .mx-xxl-0 {
                margin-left: 0 !important;
                margin-right: 0 !important
            }

            .mx-xxl-1 {
                margin-left: .234375rem !important;
                margin-right: .234375rem !important
            }

            .mx-xxl-2 {
                margin-left: .46875rem !important;
                margin-right: .46875rem !important
            }

            .mx-xxl-3 {
                margin-left: .624999375rem !important;
                margin-right: .624999375rem !important
            }

            .mx-xxl-4 {
                margin-left: .9375rem !important;
                margin-right: .9375rem !important
            }

            .mx-xxl-5 {
                margin-left: 1.2500000001rem !important;
                margin-right: 1.2500000001rem !important
            }

            .mx-xxl-6 {
                margin-left: 1.875rem !important;
                margin-right: 1.875rem !important
            }

            .mx-xxl-7 {
                margin-left: 2.8125rem !important;
                margin-right: 2.8125rem !important
            }

            .mx-xxl-8 {
                margin-left: 3.75rem !important;
                margin-right: 3.75rem !important
            }

            .mx-xxl-9 {
                margin-left: 5.625rem !important;
                margin-right: 5.625rem !important
            }

            .mx-xxl-10 {
                margin-left: 8.4375rem !important;
                margin-right: 8.4375rem !important
            }

            .mx-xxl-auto {
                margin-left: auto !important;
                margin-right: auto !important
            }

            .my-xxl-0 {
                margin-bottom: 0 !important;
                margin-top: 0 !important
            }

            .my-xxl-1 {
                margin-bottom: .234375rem !important;
                margin-top: .234375rem !important
            }

            .my-xxl-2 {
                margin-bottom: .46875rem !important;
                margin-top: .46875rem !important
            }

            .my-xxl-3 {
                margin-bottom: .624999375rem !important;
                margin-top: .624999375rem !important
            }

            .my-xxl-4 {
                margin-bottom: .9375rem !important;
                margin-top: .9375rem !important
            }

            .my-xxl-5 {
                margin-bottom: 1.2500000001rem !important;
                margin-top: 1.2500000001rem !important
            }

            .my-xxl-6 {
                margin-bottom: 1.875rem !important;
                margin-top: 1.875rem !important
            }

            .my-xxl-7 {
                margin-bottom: 2.8125rem !important;
                margin-top: 2.8125rem !important
            }

            .my-xxl-8 {
                margin-bottom: 3.75rem !important;
                margin-top: 3.75rem !important
            }

            .my-xxl-9 {
                margin-bottom: 5.625rem !important;
                margin-top: 5.625rem !important
            }

            .my-xxl-10 {
                margin-bottom: 8.4375rem !important;
                margin-top: 8.4375rem !important
            }

            .my-xxl-auto {
                margin-bottom: auto !important;
                margin-top: auto !important
            }

            .mt-xxl-0 {
                margin-top: 0 !important
            }

            .mt-xxl-1 {
                margin-top: .234375rem !important
            }

            .mt-xxl-2 {
                margin-top: .46875rem !important
            }

            .mt-xxl-3 {
                margin-top: .624999375rem !important
            }

            .mt-xxl-4 {
                margin-top: .9375rem !important
            }

            .mt-xxl-5 {
                margin-top: 1.2500000001rem !important
            }

            .mt-xxl-6 {
                margin-top: 1.875rem !important
            }

            .mt-xxl-7 {
                margin-top: 2.8125rem !important
            }

            .mt-xxl-8 {
                margin-top: 3.75rem !important
            }

            .mt-xxl-9 {
                margin-top: 5.625rem !important
            }

            .mt-xxl-10 {
                margin-top: 8.4375rem !important
            }

            .mt-xxl-auto {
                margin-top: auto !important
            }

            .me-xxl-0 {
                margin-right: 0 !important
            }

            .me-xxl-1 {
                margin-right: .234375rem !important
            }

            .me-xxl-2 {
                margin-right: .46875rem !important
            }

            .me-xxl-3 {
                margin-right: .624999375rem !important
            }

            .me-xxl-4 {
                margin-right: .9375rem !important
            }

            .me-xxl-5 {
                margin-right: 1.2500000001rem !important
            }

            .me-xxl-6 {
                margin-right: 1.875rem !important
            }

            .me-xxl-7 {
                margin-right: 2.8125rem !important
            }

            .me-xxl-8 {
                margin-right: 3.75rem !important
            }

            .me-xxl-9 {
                margin-right: 5.625rem !important
            }

            .me-xxl-10 {
                margin-right: 8.4375rem !important
            }

            .me-xxl-auto {
                margin-right: auto !important
            }

            .mb-xxl-0 {
                margin-bottom: 0 !important
            }

            .mb-xxl-1 {
                margin-bottom: .234375rem !important
            }

            .mb-xxl-2 {
                margin-bottom: .46875rem !important
            }

            .mb-xxl-3 {
                margin-bottom: .624999375rem !important
            }

            .mb-xxl-4 {
                margin-bottom: .9375rem !important
            }

            .mb-xxl-5 {
                margin-bottom: 1.2500000001rem !important
            }

            .mb-xxl-6 {
                margin-bottom: 1.875rem !important
            }

            .mb-xxl-7 {
                margin-bottom: 2.8125rem !important
            }

            .mb-xxl-8 {
                margin-bottom: 3.75rem !important
            }

            .mb-xxl-9 {
                margin-bottom: 5.625rem !important
            }

            .mb-xxl-10 {
                margin-bottom: 8.4375rem !important
            }

            .mb-xxl-auto {
                margin-bottom: auto !important
            }

            .ms-xxl-0 {
                margin-left: 0 !important
            }

            .ms-xxl-1 {
                margin-left: .234375rem !important
            }

            .ms-xxl-2 {
                margin-left: .46875rem !important
            }

            .ms-xxl-3 {
                margin-left: .624999375rem !important
            }

            .ms-xxl-4 {
                margin-left: .9375rem !important
            }

            .ms-xxl-5 {
                margin-left: 1.2500000001rem !important
            }

            .ms-xxl-6 {
                margin-left: 1.875rem !important
            }

            .ms-xxl-7 {
                margin-left: 2.8125rem !important
            }

            .ms-xxl-8 {
                margin-left: 3.75rem !important
            }

            .ms-xxl-9 {
                margin-left: 5.625rem !important
            }

            .ms-xxl-10 {
                margin-left: 8.4375rem !important
            }

            .ms-xxl-auto {
                margin-left: auto !important
            }

            .m-xxl-n1 {
                margin: -.234375rem !important
            }

            .m-xxl-n2 {
                margin: -.46875rem !important
            }

            .m-xxl-n3 {
                margin: -.624999375rem !important
            }

            .m-xxl-n4 {
                margin: -.9375rem !important
            }

            .m-xxl-n5 {
                margin: -1.2500000001rem !important
            }

            .m-xxl-n6 {
                margin: -1.875rem !important
            }

            .m-xxl-n7 {
                margin: -2.8125rem !important
            }

            .m-xxl-n8 {
                margin: -3.75rem !important
            }

            .m-xxl-n9 {
                margin: -5.625rem !important
            }

            .m-xxl-n10 {
                margin: -8.4375rem !important
            }

            .mx-xxl-n1 {
                margin-left: -.234375rem !important;
                margin-right: -.234375rem !important
            }

            .mx-xxl-n2 {
                margin-left: -.46875rem !important;
                margin-right: -.46875rem !important
            }

            .mx-xxl-n3 {
                margin-left: -.624999375rem !important;
                margin-right: -.624999375rem !important
            }

            .mx-xxl-n4 {
                margin-left: -.9375rem !important;
                margin-right: -.9375rem !important
            }

            .mx-xxl-n5 {
                margin-left: -1.2500000001rem !important;
                margin-right: -1.2500000001rem !important
            }

            .mx-xxl-n6 {
                margin-left: -1.875rem !important;
                margin-right: -1.875rem !important
            }

            .mx-xxl-n7 {
                margin-left: -2.8125rem !important;
                margin-right: -2.8125rem !important
            }

            .mx-xxl-n8 {
                margin-left: -3.75rem !important;
                margin-right: -3.75rem !important
            }

            .mx-xxl-n9 {
                margin-left: -5.625rem !important;
                margin-right: -5.625rem !important
            }

            .mx-xxl-n10 {
                margin-left: -8.4375rem !important;
                margin-right: -8.4375rem !important
            }

            .my-xxl-n1 {
                margin-bottom: -.234375rem !important;
                margin-top: -.234375rem !important
            }

            .my-xxl-n2 {
                margin-bottom: -.46875rem !important;
                margin-top: -.46875rem !important
            }

            .my-xxl-n3 {
                margin-bottom: -.624999375rem !important;
                margin-top: -.624999375rem !important
            }

            .my-xxl-n4 {
                margin-bottom: -.9375rem !important;
                margin-top: -.9375rem !important
            }

            .my-xxl-n5 {
                margin-bottom: -1.2500000001rem !important;
                margin-top: -1.2500000001rem !important
            }

            .my-xxl-n6 {
                margin-bottom: -1.875rem !important;
                margin-top: -1.875rem !important
            }

            .my-xxl-n7 {
                margin-bottom: -2.8125rem !important;
                margin-top: -2.8125rem !important
            }

            .my-xxl-n8 {
                margin-bottom: -3.75rem !important;
                margin-top: -3.75rem !important
            }

            .my-xxl-n9 {
                margin-bottom: -5.625rem !important;
                margin-top: -5.625rem !important
            }

            .my-xxl-n10 {
                margin-bottom: -8.4375rem !important;
                margin-top: -8.4375rem !important
            }

            .mt-xxl-n1 {
                margin-top: -.234375rem !important
            }

            .mt-xxl-n2 {
                margin-top: -.46875rem !important
            }

            .mt-xxl-n3 {
                margin-top: -.624999375rem !important
            }

            .mt-xxl-n4 {
                margin-top: -.9375rem !important
            }

            .mt-xxl-n5 {
                margin-top: -1.2500000001rem !important
            }

            .mt-xxl-n6 {
                margin-top: -1.875rem !important
            }

            .mt-xxl-n7 {
                margin-top: -2.8125rem !important
            }

            .mt-xxl-n8 {
                margin-top: -3.75rem !important
            }

            .mt-xxl-n9 {
                margin-top: -5.625rem !important
            }

            .mt-xxl-n10 {
                margin-top: -8.4375rem !important
            }

            .me-xxl-n1 {
                margin-right: -.234375rem !important
            }

            .me-xxl-n2 {
                margin-right: -.46875rem !important
            }

            .me-xxl-n3 {
                margin-right: -.624999375rem !important
            }

            .me-xxl-n4 {
                margin-right: -.9375rem !important
            }

            .me-xxl-n5 {
                margin-right: -1.2500000001rem !important
            }

            .me-xxl-n6 {
                margin-right: -1.875rem !important
            }

            .me-xxl-n7 {
                margin-right: -2.8125rem !important
            }

            .me-xxl-n8 {
                margin-right: -3.75rem !important
            }

            .me-xxl-n9 {
                margin-right: -5.625rem !important
            }

            .me-xxl-n10 {
                margin-right: -8.4375rem !important
            }

            .mb-xxl-n1 {
                margin-bottom: -.234375rem !important
            }

            .mb-xxl-n2 {
                margin-bottom: -.46875rem !important
            }

            .mb-xxl-n3 {
                margin-bottom: -.624999375rem !important
            }

            .mb-xxl-n4 {
                margin-bottom: -.9375rem !important
            }

            .mb-xxl-n5 {
                margin-bottom: -1.2500000001rem !important
            }

            .mb-xxl-n6 {
                margin-bottom: -1.875rem !important
            }

            .mb-xxl-n7 {
                margin-bottom: -2.8125rem !important
            }

            .mb-xxl-n8 {
                margin-bottom: -3.75rem !important
            }

            .mb-xxl-n9 {
                margin-bottom: -5.625rem !important
            }

            .mb-xxl-n10 {
                margin-bottom: -8.4375rem !important
            }

            .ms-xxl-n1 {
                margin-left: -.234375rem !important
            }

            .ms-xxl-n2 {
                margin-left: -.46875rem !important
            }

            .ms-xxl-n3 {
                margin-left: -.624999375rem !important
            }

            .ms-xxl-n4 {
                margin-left: -.9375rem !important
            }

            .ms-xxl-n5 {
                margin-left: -1.2500000001rem !important
            }

            .ms-xxl-n6 {
                margin-left: -1.875rem !important
            }

            .ms-xxl-n7 {
                margin-left: -2.8125rem !important
            }

            .ms-xxl-n8 {
                margin-left: -3.75rem !important
            }

            .ms-xxl-n9 {
                margin-left: -5.625rem !important
            }

            .ms-xxl-n10 {
                margin-left: -8.4375rem !important
            }

            .p-xxl-0 {
                padding: 0 !important
            }

            .p-xxl-1 {
                padding: .234375rem !important
            }

            .p-xxl-2 {
                padding: .46875rem !important
            }

            .p-xxl-3 {
                padding: .624999375rem !important
            }

            .p-xxl-4 {
                padding: .9375rem !important
            }

            .p-xxl-5 {
                padding: 1.2500000001rem !important
            }

            .p-xxl-6 {
                padding: 1.875rem !important
            }

            .p-xxl-7 {
                padding: 2.8125rem !important
            }

            .p-xxl-8 {
                padding: 3.75rem !important
            }

            .p-xxl-9 {
                padding: 5.625rem !important
            }

            .p-xxl-10 {
                padding: 8.4375rem !important
            }

            .px-xxl-0 {
                padding-left: 0 !important;
                padding-right: 0 !important
            }

            .px-xxl-1 {
                padding-left: .234375rem !important;
                padding-right: .234375rem !important
            }

            .px-xxl-2 {
                padding-left: .46875rem !important;
                padding-right: .46875rem !important
            }

            .px-xxl-3 {
                padding-left: .624999375rem !important;
                padding-right: .624999375rem !important
            }

            .px-xxl-4 {
                padding-left: .9375rem !important;
                padding-right: .9375rem !important
            }

            .px-xxl-5 {
                padding-left: 1.2500000001rem !important;
                padding-right: 1.2500000001rem !important
            }

            .px-xxl-6 {
                padding-left: 1.875rem !important;
                padding-right: 1.875rem !important
            }

            .px-xxl-7 {
                padding-left: 2.8125rem !important;
                padding-right: 2.8125rem !important
            }

            .px-xxl-8 {
                padding-left: 3.75rem !important;
                padding-right: 3.75rem !important
            }

            .px-xxl-9 {
                padding-left: 5.625rem !important;
                padding-right: 5.625rem !important
            }

            .px-xxl-10 {
                padding-left: 8.4375rem !important;
                padding-right: 8.4375rem !important
            }

            .py-xxl-0 {
                padding-bottom: 0 !important;
                padding-top: 0 !important
            }

            .py-xxl-1 {
                padding-bottom: .234375rem !important;
                padding-top: .234375rem !important
            }

            .py-xxl-2 {
                padding-bottom: .46875rem !important;
                padding-top: .46875rem !important
            }

            .py-xxl-3 {
                padding-bottom: .624999375rem !important;
                padding-top: .624999375rem !important
            }

            .py-xxl-4 {
                padding-bottom: .9375rem !important;
                padding-top: .9375rem !important
            }

            .py-xxl-5 {
                padding-bottom: 1.2500000001rem !important;
                padding-top: 1.2500000001rem !important
            }

            .py-xxl-6 {
                padding-bottom: 1.875rem !important;
                padding-top: 1.875rem !important
            }

            .py-xxl-7 {
                padding-bottom: 2.8125rem !important;
                padding-top: 2.8125rem !important
            }

            .py-xxl-8 {
                padding-bottom: 3.75rem !important;
                padding-top: 3.75rem !important
            }

            .py-xxl-9 {
                padding-bottom: 5.625rem !important;
                padding-top: 5.625rem !important
            }

            .py-xxl-10 {
                padding-bottom: 8.4375rem !important;
                padding-top: 8.4375rem !important
            }

            .pt-xxl-0 {
                padding-top: 0 !important
            }

            .pt-xxl-1 {
                padding-top: .234375rem !important
            }

            .pt-xxl-2 {
                padding-top: .46875rem !important
            }

            .pt-xxl-3 {
                padding-top: .624999375rem !important
            }

            .pt-xxl-4 {
                padding-top: .9375rem !important
            }

            .pt-xxl-5 {
                padding-top: 1.2500000001rem !important
            }

            .pt-xxl-6 {
                padding-top: 1.875rem !important
            }

            .pt-xxl-7 {
                padding-top: 2.8125rem !important
            }

            .pt-xxl-8 {
                padding-top: 3.75rem !important
            }

            .pt-xxl-9 {
                padding-top: 5.625rem !important
            }

            .pt-xxl-10 {
                padding-top: 8.4375rem !important
            }

            .pe-xxl-0 {
                padding-right: 0 !important
            }

            .pe-xxl-1 {
                padding-right: .234375rem !important
            }

            .pe-xxl-2 {
                padding-right: .46875rem !important
            }

            .pe-xxl-3 {
                padding-right: .624999375rem !important
            }

            .pe-xxl-4 {
                padding-right: .9375rem !important
            }

            .pe-xxl-5 {
                padding-right: 1.2500000001rem !important
            }

            .pe-xxl-6 {
                padding-right: 1.875rem !important
            }

            .pe-xxl-7 {
                padding-right: 2.8125rem !important
            }

            .pe-xxl-8 {
                padding-right: 3.75rem !important
            }

            .pe-xxl-9 {
                padding-right: 5.625rem !important
            }

            .pe-xxl-10 {
                padding-right: 8.4375rem !important
            }

            .pb-xxl-0 {
                padding-bottom: 0 !important
            }

            .pb-xxl-1 {
                padding-bottom: .234375rem !important
            }

            .pb-xxl-2 {
                padding-bottom: .46875rem !important
            }

            .pb-xxl-3 {
                padding-bottom: .624999375rem !important
            }

            .pb-xxl-4 {
                padding-bottom: .9375rem !important
            }

            .pb-xxl-5 {
                padding-bottom: 1.2500000001rem !important
            }

            .pb-xxl-6 {
                padding-bottom: 1.875rem !important
            }

            .pb-xxl-7 {
                padding-bottom: 2.8125rem !important
            }

            .pb-xxl-8 {
                padding-bottom: 3.75rem !important
            }

            .pb-xxl-9 {
                padding-bottom: 5.625rem !important
            }

            .pb-xxl-10 {
                padding-bottom: 8.4375rem !important
            }

            .ps-xxl-0 {
                padding-left: 0 !important
            }

            .ps-xxl-1 {
                padding-left: .234375rem !important
            }

            .ps-xxl-2 {
                padding-left: .46875rem !important
            }

            .ps-xxl-3 {
                padding-left: .624999375rem !important
            }

            .ps-xxl-4 {
                padding-left: .9375rem !important
            }

            .ps-xxl-5 {
                padding-left: 1.2500000001rem !important
            }

            .ps-xxl-6 {
                padding-left: 1.875rem !important
            }

            .ps-xxl-7 {
                padding-left: 2.8125rem !important
            }

            .ps-xxl-8 {
                padding-left: 3.75rem !important
            }

            .ps-xxl-9 {
                padding-left: 5.625rem !important
            }

            .ps-xxl-10 {
                padding-left: 8.4375rem !important
            }

            .gap-xxl-0 {
                gap: 0 !important
            }

            .gap-xxl-1 {
                gap: .234375rem !important
            }

            .gap-xxl-2 {
                gap: .46875rem !important
            }

            .gap-xxl-3 {
                gap: .624999375rem !important
            }

            .gap-xxl-4 {
                gap: .9375rem !important
            }

            .gap-xxl-5 {
                gap: 1.2500000001rem !important
            }

            .gap-xxl-6 {
                gap: 1.875rem !important
            }

            .gap-xxl-7 {
                gap: 2.8125rem !important
            }

            .gap-xxl-8 {
                gap: 3.75rem !important
            }

            .gap-xxl-9 {
                gap: 5.625rem !important
            }

            .gap-xxl-10 {
                gap: 8.4375rem !important
            }

            .text-xxl-start {
                text-align: left !important
            }

            .text-xxl-end {
                text-align: right !important
            }

            .text-xxl-center {
                text-align: center !important
            }

            .min-w-xxl-unset {
                min-width: unset !important
            }

            .min-w-xxl-25 {
                min-width: 25% !important
            }

            .min-w-xxl-50 {
                min-width: 50% !important
            }

            .min-w-xxl-75 {
                min-width: 75% !important
            }

            .min-w-xxl-100 {
                min-width: 100% !important
            }

            .min-w-xxl-auto {
                min-width: auto !important
            }

            .min-w-xxl-1px {
                min-width: 1px !important
            }

            .min-w-xxl-2px {
                min-width: 2px !important
            }

            .min-w-xxl-3px {
                min-width: 3px !important
            }

            .min-w-xxl-4px {
                min-width: 4px !important
            }

            .min-w-xxl-5px {
                min-width: 5px !important
            }

            .min-w-xxl-6px {
                min-width: 6px !important
            }

            .min-w-xxl-7px {
                min-width: 7px !important
            }

            .min-w-xxl-8px {
                min-width: 8px !important
            }

            .min-w-xxl-9px {
                min-width: 9px !important
            }

            .min-w-xxl-10px {
                min-width: 10px !important
            }

            .min-w-xxl-15px {
                min-width: 15px !important
            }

            .min-w-xxl-20px {
                min-width: 20px !important
            }

            .min-w-xxl-25px {
                min-width: 25px !important
            }

            .min-w-xxl-30px {
                min-width: 30px !important
            }

            .min-w-xxl-35px {
                min-width: 35px !important
            }

            .min-w-xxl-40px {
                min-width: 40px !important
            }

            .min-w-xxl-45px {
                min-width: 45px !important
            }

            .min-w-xxl-50px {
                min-width: 50px !important
            }

            .min-w-xxl-55px {
                min-width: 55px !important
            }

            .min-w-xxl-60px {
                min-width: 60px !important
            }

            .min-w-xxl-65px {
                min-width: 65px !important
            }

            .min-w-xxl-70px {
                min-width: 70px !important
            }

            .min-w-xxl-75px {
                min-width: 75px !important
            }

            .min-w-xxl-80px {
                min-width: 80px !important
            }

            .min-w-xxl-85px {
                min-width: 85px !important
            }

            .min-w-xxl-90px {
                min-width: 90px !important
            }

            .min-w-xxl-95px {
                min-width: 95px !important
            }

            .min-w-xxl-100px {
                min-width: 100px !important
            }

            .min-w-xxl-125px {
                min-width: 125px !important
            }

            .min-w-xxl-150px {
                min-width: 150px !important
            }

            .min-w-xxl-175px {
                min-width: 175px !important
            }

            .min-w-xxl-200px {
                min-width: 200px !important
            }

            .min-w-xxl-225px {
                min-width: 225px !important
            }

            .min-w-xxl-250px {
                min-width: 250px !important
            }

            .min-w-xxl-275px {
                min-width: 275px !important
            }

            .min-w-xxl-300px {
                min-width: 300px !important
            }

            .min-w-xxl-325px {
                min-width: 325px !important
            }

            .min-w-xxl-350px {
                min-width: 350px !important
            }

            .min-w-xxl-375px {
                min-width: 375px !important
            }

            .min-w-xxl-400px {
                min-width: 400px !important
            }

            .min-w-xxl-425px {
                min-width: 425px !important
            }

            .min-w-xxl-450px {
                min-width: 450px !important
            }

            .min-w-xxl-475px {
                min-width: 475px !important
            }

            .min-w-xxl-500px {
                min-width: 500px !important
            }

            .min-w-xxl-550px {
                min-width: 550px !important
            }

            .min-w-xxl-600px {
                min-width: 600px !important
            }

            .min-w-xxl-650px {
                min-width: 650px !important
            }

            .min-w-xxl-700px {
                min-width: 700px !important
            }

            .min-w-xxl-750px {
                min-width: 750px !important
            }

            .min-w-xxl-800px {
                min-width: 800px !important
            }

            .min-w-xxl-850px {
                min-width: 850px !important
            }

            .min-w-xxl-900px {
                min-width: 900px !important
            }

            .min-w-xxl-950px {
                min-width: 950px !important
            }

            .min-w-xxl-1000px {
                min-width: 1000px !important
            }

            .min-h-xxl-unset {
                min-height: unset !important
            }

            .min-h-xxl-25 {
                min-height: 25% !important
            }

            .min-h-xxl-50 {
                min-height: 50% !important
            }

            .min-h-xxl-75 {
                min-height: 75% !important
            }

            .min-h-xxl-100 {
                min-height: 100% !important
            }

            .min-h-xxl-auto {
                min-height: auto !important
            }

            .min-h-xxl-1px {
                min-height: 1px !important
            }

            .min-h-xxl-2px {
                min-height: 2px !important
            }

            .min-h-xxl-3px {
                min-height: 3px !important
            }

            .min-h-xxl-4px {
                min-height: 4px !important
            }

            .min-h-xxl-5px {
                min-height: 5px !important
            }

            .min-h-xxl-6px {
                min-height: 6px !important
            }

            .min-h-xxl-7px {
                min-height: 7px !important
            }

            .min-h-xxl-8px {
                min-height: 8px !important
            }

            .min-h-xxl-9px {
                min-height: 9px !important
            }

            .min-h-xxl-10px {
                min-height: 10px !important
            }

            .min-h-xxl-15px {
                min-height: 15px !important
            }

            .min-h-xxl-20px {
                min-height: 20px !important
            }

            .min-h-xxl-25px {
                min-height: 25px !important
            }

            .min-h-xxl-30px {
                min-height: 30px !important
            }

            .min-h-xxl-35px {
                min-height: 35px !important
            }

            .min-h-xxl-40px {
                min-height: 40px !important
            }

            .min-h-xxl-45px {
                min-height: 45px !important
            }

            .min-h-xxl-50px {
                min-height: 50px !important
            }

            .min-h-xxl-55px {
                min-height: 55px !important
            }

            .min-h-xxl-60px {
                min-height: 60px !important
            }

            .min-h-xxl-65px {
                min-height: 65px !important
            }

            .min-h-xxl-70px {
                min-height: 70px !important
            }

            .min-h-xxl-75px {
                min-height: 75px !important
            }

            .min-h-xxl-80px {
                min-height: 80px !important
            }

            .min-h-xxl-85px {
                min-height: 85px !important
            }

            .min-h-xxl-90px {
                min-height: 90px !important
            }

            .min-h-xxl-95px {
                min-height: 95px !important
            }

            .min-h-xxl-100px {
                min-height: 100px !important
            }

            .min-h-xxl-125px {
                min-height: 125px !important
            }

            .min-h-xxl-150px {
                min-height: 150px !important
            }

            .min-h-xxl-175px {
                min-height: 175px !important
            }

            .min-h-xxl-200px {
                min-height: 200px !important
            }

            .min-h-xxl-225px {
                min-height: 225px !important
            }

            .min-h-xxl-250px {
                min-height: 250px !important
            }

            .min-h-xxl-275px {
                min-height: 275px !important
            }

            .min-h-xxl-300px {
                min-height: 300px !important
            }

            .min-h-xxl-325px {
                min-height: 325px !important
            }

            .min-h-xxl-350px {
                min-height: 350px !important
            }

            .min-h-xxl-375px {
                min-height: 375px !important
            }

            .min-h-xxl-400px {
                min-height: 400px !important
            }

            .min-h-xxl-425px {
                min-height: 425px !important
            }

            .min-h-xxl-450px {
                min-height: 450px !important
            }

            .min-h-xxl-475px {
                min-height: 475px !important
            }

            .min-h-xxl-500px {
                min-height: 500px !important
            }

            .min-h-xxl-550px {
                min-height: 550px !important
            }

            .min-h-xxl-600px {
                min-height: 600px !important
            }

            .min-h-xxl-650px {
                min-height: 650px !important
            }

            .min-h-xxl-700px {
                min-height: 700px !important
            }

            .min-h-xxl-750px {
                min-height: 750px !important
            }

            .min-h-xxl-800px {
                min-height: 800px !important
            }

            .min-h-xxl-850px {
                min-height: 850px !important
            }

            .min-h-xxl-900px {
                min-height: 900px !important
            }

            .min-h-xxl-950px {
                min-height: 950px !important
            }

            .min-h-xxl-1000px {
                min-height: 1000px !important
            }

            .scroll-m-xxl-0 {
                scroll-margin: 0 !important
            }

            .scroll-m-xxl-1 {
                scroll-margin: .234375rem !important
            }

            .scroll-m-xxl-2 {
                scroll-margin: .46875rem !important
            }

            .scroll-m-xxl-3 {
                scroll-margin: .624999375rem !important
            }

            .scroll-m-xxl-4 {
                scroll-margin: .9375rem !important
            }

            .scroll-m-xxl-5 {
                scroll-margin: 1.2500000001rem !important
            }

            .scroll-m-xxl-6 {
                scroll-margin: 1.875rem !important
            }

            .scroll-m-xxl-7 {
                scroll-margin: 2.8125rem !important
            }

            .scroll-m-xxl-8 {
                scroll-margin: 3.75rem !important
            }

            .scroll-m-xxl-9 {
                scroll-margin: 5.625rem !important
            }

            .scroll-m-xxl-10 {
                scroll-margin: 8.4375rem !important
            }

            .scroll-m-xxl-auto {
                scroll-margin: auto !important
            }

            .scroll-mx-xxl-0 {
                scroll-margin-left: 0 !important;
                scroll-margin-right: 0 !important
            }

            .scroll-mx-xxl-1 {
                scroll-margin-left: .234375rem !important;
                scroll-margin-right: .234375rem !important
            }

            .scroll-mx-xxl-2 {
                scroll-margin-left: .46875rem !important;
                scroll-margin-right: .46875rem !important
            }

            .scroll-mx-xxl-3 {
                scroll-margin-left: .624999375rem !important;
                scroll-margin-right: .624999375rem !important
            }

            .scroll-mx-xxl-4 {
                scroll-margin-left: .9375rem !important;
                scroll-margin-right: .9375rem !important
            }

            .scroll-mx-xxl-5 {
                scroll-margin-left: 1.2500000001rem !important;
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-mx-xxl-6 {
                scroll-margin-left: 1.875rem !important;
                scroll-margin-right: 1.875rem !important
            }

            .scroll-mx-xxl-7 {
                scroll-margin-left: 2.8125rem !important;
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-mx-xxl-8 {
                scroll-margin-left: 3.75rem !important;
                scroll-margin-right: 3.75rem !important
            }

            .scroll-mx-xxl-9 {
                scroll-margin-left: 5.625rem !important;
                scroll-margin-right: 5.625rem !important
            }

            .scroll-mx-xxl-10 {
                scroll-margin-left: 8.4375rem !important;
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-mx-xxl-auto {
                scroll-margin-left: auto !important;
                scroll-margin-right: auto !important
            }

            .scroll-my-xxl-0 {
                scroll-margin-bottom: 0 !important;
                scroll-margin-top: 0 !important
            }

            .scroll-my-xxl-1 {
                scroll-margin-bottom: .234375rem !important;
                scroll-margin-top: .234375rem !important
            }

            .scroll-my-xxl-2 {
                scroll-margin-bottom: .46875rem !important;
                scroll-margin-top: .46875rem !important
            }

            .scroll-my-xxl-3 {
                scroll-margin-bottom: .624999375rem !important;
                scroll-margin-top: .624999375rem !important
            }

            .scroll-my-xxl-4 {
                scroll-margin-bottom: .9375rem !important;
                scroll-margin-top: .9375rem !important
            }

            .scroll-my-xxl-5 {
                scroll-margin-bottom: 1.2500000001rem !important;
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-my-xxl-6 {
                scroll-margin-bottom: 1.875rem !important;
                scroll-margin-top: 1.875rem !important
            }

            .scroll-my-xxl-7 {
                scroll-margin-bottom: 2.8125rem !important;
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-my-xxl-8 {
                scroll-margin-bottom: 3.75rem !important;
                scroll-margin-top: 3.75rem !important
            }

            .scroll-my-xxl-9 {
                scroll-margin-bottom: 5.625rem !important;
                scroll-margin-top: 5.625rem !important
            }

            .scroll-my-xxl-10 {
                scroll-margin-bottom: 8.4375rem !important;
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-my-xxl-auto {
                scroll-margin-bottom: auto !important;
                scroll-margin-top: auto !important
            }

            .scroll-mt-xxl-0 {
                scroll-margin-top: 0 !important
            }

            .scroll-mt-xxl-1 {
                scroll-margin-top: .234375rem !important
            }

            .scroll-mt-xxl-2 {
                scroll-margin-top: .46875rem !important
            }

            .scroll-mt-xxl-3 {
                scroll-margin-top: .624999375rem !important
            }

            .scroll-mt-xxl-4 {
                scroll-margin-top: .9375rem !important
            }

            .scroll-mt-xxl-5 {
                scroll-margin-top: 1.2500000001rem !important
            }

            .scroll-mt-xxl-6 {
                scroll-margin-top: 1.875rem !important
            }

            .scroll-mt-xxl-7 {
                scroll-margin-top: 2.8125rem !important
            }

            .scroll-mt-xxl-8 {
                scroll-margin-top: 3.75rem !important
            }

            .scroll-mt-xxl-9 {
                scroll-margin-top: 5.625rem !important
            }

            .scroll-mt-xxl-10 {
                scroll-margin-top: 8.4375rem !important
            }

            .scroll-mt-xxl-auto {
                scroll-margin-top: auto !important
            }

            .scroll-me-xxl-0 {
                scroll-margin-right: 0 !important
            }

            .scroll-me-xxl-1 {
                scroll-margin-right: .234375rem !important
            }

            .scroll-me-xxl-2 {
                scroll-margin-right: .46875rem !important
            }

            .scroll-me-xxl-3 {
                scroll-margin-right: .624999375rem !important
            }

            .scroll-me-xxl-4 {
                scroll-margin-right: .9375rem !important
            }

            .scroll-me-xxl-5 {
                scroll-margin-right: 1.2500000001rem !important
            }

            .scroll-me-xxl-6 {
                scroll-margin-right: 1.875rem !important
            }

            .scroll-me-xxl-7 {
                scroll-margin-right: 2.8125rem !important
            }

            .scroll-me-xxl-8 {
                scroll-margin-right: 3.75rem !important
            }

            .scroll-me-xxl-9 {
                scroll-margin-right: 5.625rem !important
            }

            .scroll-me-xxl-10 {
                scroll-margin-right: 8.4375rem !important
            }

            .scroll-me-xxl-auto {
                scroll-margin-right: auto !important
            }

            .scroll-mb-xxl-0 {
                scroll-margin-bottom: 0 !important
            }

            .scroll-mb-xxl-1 {
                scroll-margin-bottom: .234375rem !important
            }

            .scroll-mb-xxl-2 {
                scroll-margin-bottom: .46875rem !important
            }

            .scroll-mb-xxl-3 {
                scroll-margin-bottom: .624999375rem !important
            }

            .scroll-mb-xxl-4 {
                scroll-margin-bottom: .9375rem !important
            }

            .scroll-mb-xxl-5 {
                scroll-margin-bottom: 1.2500000001rem !important
            }

            .scroll-mb-xxl-6 {
                scroll-margin-bottom: 1.875rem !important
            }

            .scroll-mb-xxl-7 {
                scroll-margin-bottom: 2.8125rem !important
            }

            .scroll-mb-xxl-8 {
                scroll-margin-bottom: 3.75rem !important
            }

            .scroll-mb-xxl-9 {
                scroll-margin-bottom: 5.625rem !important
            }

            .scroll-mb-xxl-10 {
                scroll-margin-bottom: 8.4375rem !important
            }

            .scroll-mb-xxl-auto {
                scroll-margin-bottom: auto !important
            }

            .scroll-ms-xxl-0 {
                scroll-margin-left: 0 !important
            }

            .scroll-ms-xxl-1 {
                scroll-margin-left: .234375rem !important
            }

            .scroll-ms-xxl-2 {
                scroll-margin-left: .46875rem !important
            }

            .scroll-ms-xxl-3 {
                scroll-margin-left: .624999375rem !important
            }

            .scroll-ms-xxl-4 {
                scroll-margin-left: .9375rem !important
            }

            .scroll-ms-xxl-5 {
                scroll-margin-left: 1.2500000001rem !important
            }

            .scroll-ms-xxl-6 {
                scroll-margin-left: 1.875rem !important
            }

            .scroll-ms-xxl-7 {
                scroll-margin-left: 2.8125rem !important
            }

            .scroll-ms-xxl-8 {
                scroll-margin-left: 3.75rem !important
            }

            .scroll-ms-xxl-9 {
                scroll-margin-left: 5.625rem !important
            }

            .scroll-ms-xxl-10 {
                scroll-margin-left: 8.4375rem !important
            }

            .scroll-ms-xxl-auto {
                scroll-margin-left: auto !important
            }

            .object-fit-xxl-contain {
                -o-object-fit: contain !important;
                object-fit: contain !important
            }

            .object-fit-xxl-cover {
                -o-object-fit: cover !important;
                object-fit: cover !important
            }

            .object-fit-xxl-fill {
                -o-object-fit: fill !important;
                object-fit: fill !important
            }

            .object-fit-xxl-scale {
                -o-object-fit: scale-down !important;
                object-fit: scale-down !important
            }

            .object-fit-xxl-none {
                -o-object-fit: none !important;
                object-fit: none !important
            }
        }

        @media(min-width:1200px) {
            .fs-1 {
                font-size: 1.5rem !important
            }

            .fs-2 {
                font-size: 1.375rem !important
            }
        }

        @media print {
            .d-print-inline {
                display: inline !important
            }

            .d-print-inline-block {
                display: inline-block !important
            }

            .d-print-block {
                display: block !important
            }

            .d-print-grid {
                display: grid !important
            }

            .d-print-table {
                display: table !important
            }

            .d-print-table-row {
                display: table-row !important
            }

            .d-print-table-cell {
                display: table-cell !important
            }

            .d-print-flex {
                display: flex !important
            }

            .d-print-inline-flex {
                display: inline-flex !important
            }

            .d-print-none {
                display: none !important
            }
        }

        html {
            min-height: 100%;
            position: relative
        }

        body {
            overflow-x: hidden
        }

        dt {
            color: #9ea9b4;
            font-weight: 400
        }

        main {
            height: 100%
        }

        a,
        button {
            outline: 0 !important
        }

        ::-moz-selection {
            background-color: rgba(0, 186, 199, .75);
            color: #fff
        }

        ::selection {
            background-color: rgba(0, 186, 199, .75);
            color: #fff
        }

        .alert-primary {
            --bs-alert-link-color: #f0fbfc
        }

        .alert-primary .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-secondary {
            --bs-alert-link-color: #f9fafb
        }

        .alert-secondary .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-success {
            --bs-alert-link-color: #f3fcf7
        }

        .alert-success .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-info {
            --bs-alert-link-color: #f2fafc
        }

        .alert-info .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-warning {
            --bs-alert-link-color: #fefcf4
        }

        .alert-warning .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-danger {
            --bs-alert-link-color: #fdf2f5
        }

        .alert-danger .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-light {
            --bs-alert-link-color: #0f0f0f
        }

        .alert-light .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-dark {
            --bs-alert-link-color: #f1f2f3
        }

        .alert-dark .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-light-green {
            --bs-alert-link-color: #0e0f0f
        }

        .alert-light-green .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-white {
            --bs-alert-link-color: #0f0f0f
        }

        .alert-white .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-black {
            --bs-alert-link-color: #f0f0f0
        }

        .alert-black .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-blue {
            --bs-alert-link-color: #f0f7fc
        }

        .alert-blue .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-100 {
            --bs-alert-link-color: #0f0f0f
        }

        .alert-gray-100 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-200 {
            --bs-alert-link-color: #0f0f0f
        }

        .alert-gray-200 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-300 {
            --bs-alert-link-color: #0e0e0e
        }

        .alert-gray-300 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-400 {
            --bs-alert-link-color: #0d0d0e
        }

        .alert-gray-400 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-500 {
            --bs-alert-link-color: #fafafa
        }

        .alert-gray-500 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-600 {
            --bs-alert-link-color: #f9f9fa
        }

        .alert-gray-600 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-700 {
            --bs-alert-link-color: #f6f6f6
        }

        .alert-gray-700 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-800 {
            --bs-alert-link-color: #f3f3f4
        }

        .alert-gray-800 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .alert-gray-900 {
            --bs-alert-link-color: #f2f2f2
        }

        .alert-gray-900 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-primary {
            --bs-alert-link-color: #f0fbfc
        }

        [data-theme=dark] .alert-primary .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-secondary {
            --bs-alert-link-color: #f9fafb
        }

        [data-theme=dark] .alert-secondary .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-success {
            --bs-alert-link-color: #f3fcf7
        }

        [data-theme=dark] .alert-success .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-info {
            --bs-alert-link-color: #f2fafc
        }

        [data-theme=dark] .alert-info .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-warning {
            --bs-alert-link-color: #fefcf4
        }

        [data-theme=dark] .alert-warning .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-danger {
            --bs-alert-link-color: #fdf2f5
        }

        [data-theme=dark] .alert-danger .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-light {
            --bs-alert-link-color: #f3f3f3
        }

        [data-theme=dark] .alert-light .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-dark {
            --bs-alert-link-color: #f5f5f5
        }

        [data-theme=dark] .alert-dark .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-light-green {
            --bs-alert-link-color: #f1f1f2
        }

        [data-theme=dark] .alert-light-green .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-white {
            --bs-alert-link-color: #f2f2f2
        }

        [data-theme=dark] .alert-white .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-black {
            --bs-alert-link-color: #0f0f0f
        }

        [data-theme=dark] .alert-black .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-100 {
            --bs-alert-link-color: #f2f2f2
        }

        [data-theme=dark] .alert-gray-100 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-200 {
            --bs-alert-link-color: #f2f2f2
        }

        [data-theme=dark] .alert-gray-200 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-300 {
            --bs-alert-link-color: #f2f2f2
        }

        [data-theme=dark] .alert-gray-300 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-400 {
            --bs-alert-link-color: #f1f1f1
        }

        [data-theme=dark] .alert-gray-400 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-500 {
            --bs-alert-link-color: #fbfbfb
        }

        [data-theme=dark] .alert-gray-500 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-600 {
            --bs-alert-link-color: #fafbfb
        }

        [data-theme=dark] .alert-gray-600 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-700 {
            --bs-alert-link-color: #f9f9f9
        }

        [data-theme=dark] .alert-gray-700 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-800 {
            --bs-alert-link-color: #f8f8f8
        }

        [data-theme=dark] .alert-gray-800 .alert-link {
            color: var(--bs-alert-link-color)
        }

        [data-theme=dark] .alert-gray-900 {
            --bs-alert-link-color: #f8f8f9
        }

        [data-theme=dark] .alert-gray-900 .alert-link {
            color: var(--bs-alert-link-color)
        }

        .avatar {
            --bs-avatar-bg: var(--bs-gray-300);
            --bs-avatar-color: var(--bs-gray-500);
            --bs-avatar-border-radius: 0.625rem;
            flex-shrink: 0;
            font-size: 1.0909090909rem;
            height: 3rem;
            position: relative;
            width: 3rem
        }

        .avatar,
        .avatar-img {
            border-radius: var(--bs-avatar-border-radius);
            display: inline-block
        }

        .avatar-img {
            height: 100%;
            max-width: 100%;
            -o-object-fit: cover;
            object-fit: cover;
            pointer-events: none
        }

        .avatar-circle .avatar-img {
            border-radius: 50%
        }

        .avatar-title {
            align-items: center;
            background-color: var(--bs-avatar-bg);
            color: var(--bs-avatar-color);
            display: flex;
            font-weight: 700;
            height: 100%;
            justify-content: center;
            line-height: 0;
            pointer-events: none;
            text-transform: uppercase;
            width: 100%
        }

        .avatar-circle .avatar-title {
            border-radius: 50%
        }

        .avatar-xxs {
            font-size: .4090909091rem;
            height: 1.125rem;
            width: 1.125rem
        }

        .avatar-xs {
            font-size: .6818181818rem;
            height: 1.875rem;
            width: 1.875rem
        }

        .avatar-sm {
            font-size: .9090909091rem;
            height: 2.5rem;
            width: 2.5rem
        }

        .avatar-lg {
            font-size: 1.4545454545rem;
            height: 4rem;
            width: 4rem
        }

        .avatar-xl,
        .avatar-xxl {
            font-size: 1.8636363636rem;
            height: 5.125rem;
            width: 5.125rem
        }

        @media(min-width:768px) {
            .avatar-xxl {
                font-size: 2.5454545455rem;
                height: 7rem;
                width: 7rem
            }
        }

        .avatar-away:before,
        .avatar-busy:before,
        .avatar-offline:before,
        .avatar-online:before {
            border: 1px solid #fff;
            border-radius: 50%;
            bottom: 0;
            content: "";
            height: 30%;
            position: absolute;
            right: 0;
            width: 30%
        }

        .avatar-away.avatar-lg:before,
        .avatar-away.avatar-xl:before,
        .avatar-busy.avatar-lg:before,
        .avatar-busy.avatar-xl:before,
        .avatar-offline.avatar-lg:before,
        .avatar-offline.avatar-xl:before,
        .avatar-online.avatar-lg:before,
        .avatar-online.avatar-xl:before {
            border-width: 1.5px
        }

        .avatar-away.avatar-xxl:before,
        .avatar-busy.avatar-xxl:before,
        .avatar-offline.avatar-xxl:before,
        .avatar-online.avatar-xxl:before {
            border-width: 2px
        }

        .avatar-away.avatar-circle .avatar-img,
        .avatar-busy.avatar-circle .avatar-img,
        .avatar-offline.avatar-circle .avatar-img,
        .avatar-online.avatar-circle .avatar-img {
            -webkit-mask-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100' height='100'%3E%3Cdefs%3E%3Cmask id='a'%3E%3Cpath fill='%23fff' d='M0 0h100v100H0z'/%3E%3Ccircle cx='85' cy='85' r='15'/%3E%3C/mask%3E%3C/defs%3E%3Cpath fill='green' d='M0 0h100v100H0z' mask='url(%23a)'/%3E%3C/svg%3E");
            mask-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100' height='100'%3E%3Cdefs%3E%3Cmask id='a'%3E%3Cpath fill='%23fff' d='M0 0h100v100H0z'/%3E%3Ccircle cx='85' cy='85' r='15'/%3E%3C/mask%3E%3C/defs%3E%3Cpath fill='green' d='M0 0h100v100H0z' mask='url(%23a)'/%3E%3C/svg%3E");
            -webkit-mask-size: 100% 100%;
            mask-size: 100% 100%
        }

        [dir=rtl] .avatar-away.avatar-circle .avatar-img,
        [dir=rtl] .avatar-busy.avatar-circle .avatar-img,
        [dir=rtl] .avatar-offline.avatar-circle .avatar-img,
        [dir=rtl] .avatar-online.avatar-circle .avatar-img {
            transform: rotateY(180deg)
        }

        .avatar-online:before {
            background-color: var(--bs-success)
        }

        .avatar-busy:before {
            background-color: var(--bs-danger)
        }

        .avatar-away:before {
            background-color: var(--bs-warning)
        }

        .avatar-offline:before {
            background-color: var(--bs-gray-500)
        }

        .avatar-group {
            align-items: center;
            display: inline-flex;
            z-index: 2
        }

        .avatar-group .avatar:hover {
            z-index: 2
        }

        .avatar-group .avatar+.avatar {
            margin-left: -1em
        }

        .badge-circle {
            align-items: center;
            border-radius: 50%;
            display: inline-flex;
            height: 1.75em;
            justify-content: center;
            min-width: unset;
            padding: 0;
            width: 1.75em
        }

        .board {
            display: block;
            overflow-x: auto;
            white-space: nowrap
        }

        .tasks {
            display: inline-block;
            vertical-align: top;
            white-space: normal;
            width: 20rem
        }

        .tasks:not(:last-child) {
            margin-right: 1.875rem
        }

        .tasks:not(:first-child) {
            margin-left: -.25rem
        }

        .tasks .card:last-child {
            margin-bottom: 0 !important
        }

        .breadcrumb {
            --bs-breadcrumb-link-color: #9ea9b4
        }

        .breadcrumb-item {
            font-weight: 600
        }

        .breadcrumb-item a {
            color: var(--bs-breadcrumb-link-color)
        }

        .btn-group {
            border-radius: var(--bs-btn-border-radius)
        }

        .btn-group-lg {
            border-radius: var(--bs-btn-border-radius-lg)
        }

        .btn-group-sm {
            border-radius: var(--bs-btn-border-radius) -sm
        }

        .dropdown-toggle-split:after,
        .dropend .dropdown-toggle-split:after,
        .dropup .dropdown-toggle-split:after {
            padding-left: 0
        }

        .dropstart .dropdown-toggle-split:before {
            padding-right: 0
        }

        .btn {
            --bs-btn-focus-box-shadow: 0 4px 12px rgba(var(--bs-btn-focus-shadow-rgb), 0.35)
        }

        [data-theme=dark] .btn-primary {
            --bs-btn-color: #fff;
            --bs-btn-bg: {{ $settings->website_theme }};
            --bs-btn-border-color: {{ $settings->website_theme }};
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #242424;
            --bs-btn-hover-border-color: {{ $settings->website_theme }};
            --bs-btn-focus-shadow-rgb: 38, 196, 207;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: {{ $settings->website_theme }};
            --bs-btn-active-border-color: #008c95;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: {{ $settings->website_theme }};
            --bs-btn-disabled-border-color: {{ $settings->website_theme }}
        }

        [data-theme=dark] .btn-secondary {
            --bs-btn-color: #fff;
            --bs-btn-bg: #9ea9b4;
            --bs-btn-border-color: #9ea9b4;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #869099;
            --bs-btn-hover-border-color: #7e8790;
            --bs-btn-focus-shadow-rgb: 173, 182, 191;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #7e8790;
            --bs-btn-active-border-color: #777f87;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #9ea9b4;
            --bs-btn-disabled-border-color: #9ea9b4
        }

        [data-theme=dark] .btn-success {
            --bs-btn-color: #fff;
            --bs-btn-bg: #31cf80;
            --bs-btn-border-color: #31cf80;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2ab06d;
            --bs-btn-hover-border-color: #27a666;
            --bs-btn-focus-shadow-rgb: 80, 214, 147;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #27a666;
            --bs-btn-active-border-color: #259b60;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #31cf80;
            --bs-btn-disabled-border-color: #31cf80
        }

        [data-theme=dark] .btn-info {
            --bs-btn-color: #fff;
            --bs-btn-bg: #2dadcf;
            --bs-btn-border-color: #2dadcf;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2693b0;
            --bs-btn-hover-border-color: #248aa6;
            --bs-btn-focus-shadow-rgb: 77, 185, 214;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #248aa6;
            --bs-btn-active-border-color: #22829b;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #2dadcf;
            --bs-btn-disabled-border-color: #2dadcf
        }

        [data-theme=dark] .btn-warning {
            --bs-btn-color: #fff;
            --bs-btn-bg: #ebcf4f;
            --bs-btn-border-color: #ebcf4f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #c8b043;
            --bs-btn-hover-border-color: #bca63f;
            --bs-btn-focus-shadow-rgb: 238, 214, 105;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #bca63f;
            --bs-btn-active-border-color: #b09b3b;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #ebcf4f;
            --bs-btn-disabled-border-color: #ebcf4f
        }

        [data-theme=dark] .btn-danger {
            --bs-btn-color: #fff;
            --bs-btn-bg: #d82c5b;
            --bs-btn-border-color: #d82c5b;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #b8254d;
            --bs-btn-hover-border-color: #ad2349;
            --bs-btn-focus-shadow-rgb: 222, 76, 116;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #ad2349;
            --bs-btn-active-border-color: #a22144;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #d82c5b;
            --bs-btn-disabled-border-color: #d82c5b
        }

        [data-theme=dark] .btn-light {
            --bs-btn-color: #fff;
            --bs-btn-bg: #363637;
            --bs-btn-border-color: #363637;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2e2e2f;
            --bs-btn-hover-border-color: #2b2b2c;
            --bs-btn-focus-shadow-rgb: 84, 84, 85;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #2b2b2c;
            --bs-btn-active-border-color: #292929;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #363637;
            --bs-btn-disabled-border-color: #363637
        }

        [data-theme=dark] .btn-dark {
            --bs-btn-color: #fff;
            --bs-btn-bg: #595c5f;
            --bs-btn-border-color: #595c5f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #4c4e51;
            --bs-btn-hover-border-color: #474a4c;
            --bs-btn-focus-shadow-rgb: 114, 116, 119;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #474a4c;
            --bs-btn-active-border-color: #434547;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #595c5f;
            --bs-btn-disabled-border-color: #595c5f
        }

        [data-theme=dark] .btn-light-green {
            --bs-btn-color: #fff;
            --bs-btn-bg: #1d1d1e;
            --bs-btn-border-color: #1d1d1e;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #19191a;
            --bs-btn-hover-border-color: #171718;
            --bs-btn-focus-shadow-rgb: 63, 63, 64;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #171718;
            --bs-btn-active-border-color: #161617;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #1d1d1e;
            --bs-btn-disabled-border-color: #1d1d1e
        }

        [data-theme=dark] .btn-white {
            --bs-btn-color: #fff;
            --bs-btn-bg: #2d2d2d;
            --bs-btn-border-color: #2d2d2d;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #262626;
            --bs-btn-hover-border-color: #242424;
            --bs-btn-focus-shadow-rgb: 77, 77, 77;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #242424;
            --bs-btn-active-border-color: #222;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #2d2d2d;
            --bs-btn-disabled-border-color: #2d2d2d
        }

        [data-theme=dark] .btn-black {
            --bs-btn-color: #000;
            --bs-btn-bg: #fff;
            --bs-btn-border-color: #fff;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #fff;
            --bs-btn-hover-border-color: #fff;
            --bs-btn-focus-shadow-rgb: 217, 217, 217;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #fff;
            --bs-btn-active-border-color: #fff;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #000;
            --bs-btn-disabled-bg: #fff;
            --bs-btn-disabled-border-color: #fff
        }

        [data-theme=dark] .btn-gray-100,
        [data-theme=dark] .btn-gray-200 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #1f1f1f;
            --bs-btn-border-color: #1f1f1f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #1a1a1a;
            --bs-btn-hover-border-color: #191919;
            --bs-btn-focus-shadow-rgb: 65, 65, 65;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #191919;
            --bs-btn-active-border-color: #171717;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #1f1f1f;
            --bs-btn-disabled-border-color: #1f1f1f
        }

        [data-theme=dark] .btn-gray-300 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #1e1e1e;
            --bs-btn-border-color: #1e1e1e;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #1a1a1a;
            --bs-btn-hover-border-color: #181818;
            --bs-btn-focus-shadow-rgb: 64, 64, 64;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #181818;
            --bs-btn-active-border-color: #171717;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #1e1e1e;
            --bs-btn-disabled-border-color: #1e1e1e
        }

        [data-theme=dark] .btn-gray-400 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #1b1b1c;
            --bs-btn-border-color: #1b1b1c;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #171718;
            --bs-btn-hover-border-color: #161616;
            --bs-btn-focus-shadow-rgb: 61, 61, 62;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #161616;
            --bs-btn-active-border-color: #141415;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #1b1b1c;
            --bs-btn-disabled-border-color: #1b1b1c
        }

        [data-theme=dark] .btn-gray-500 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #b7bcc2;
            --bs-btn-border-color: #b7bcc2;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #9ca0a5;
            --bs-btn-hover-border-color: #92969b;
            --bs-btn-focus-shadow-rgb: 194, 198, 203;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #92969b;
            --bs-btn-active-border-color: #898d92;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #b7bcc2;
            --bs-btn-disabled-border-color: #b7bcc2
        }

        [data-theme=dark] .btn-gray-600 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #b2b6bc;
            --bs-btn-border-color: #b2b6bc;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #979ba0;
            --bs-btn-hover-border-color: #8e9296;
            --bs-btn-focus-shadow-rgb: 190, 193, 198;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #8e9296;
            --bs-btn-active-border-color: #86898d;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #b2b6bc;
            --bs-btn-disabled-border-color: #b2b6bc
        }

        [data-theme=dark] .btn-gray-700 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #9b9b9b;
            --bs-btn-border-color: #9b9b9b;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #848484;
            --bs-btn-hover-border-color: #7c7c7c;
            --bs-btn-focus-shadow-rgb: 170, 170, 170;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #7c7c7c;
            --bs-btn-active-border-color: #747474;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #9b9b9b;
            --bs-btn-disabled-border-color: #9b9b9b
        }

        [data-theme=dark] .btn-gray-800 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #85898c;
            --bs-btn-border-color: #85898c;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #717477;
            --bs-btn-hover-border-color: #6a6e70;
            --bs-btn-focus-shadow-rgb: 151, 155, 157;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #6a6e70;
            --bs-btn-active-border-color: #646769;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #85898c;
            --bs-btn-disabled-border-color: #85898c
        }

        [data-theme=dark] .btn-gray-900 {
            --bs-btn-color: #fff;
            --bs-btn-bg: #909294;
            --bs-btn-border-color: #909294;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #7a7c7e;
            --bs-btn-hover-border-color: #737576;
            --bs-btn-focus-shadow-rgb: 161, 162, 164;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #737576;
            --bs-btn-active-border-color: #6c6e6f;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: #909294;
            --bs-btn-disabled-border-color: #909294
        }

        [data-theme=dark] .btn-outline-primary {
            --bs-btn-color: {{ $settings->website_theme }};
            --bs-btn-border-color: {{ $settings->website_theme }};
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: {{ $settings->website_theme }};
            --bs-btn-hover-border-color: {{ $settings->website_theme }};
            --bs-btn-focus-shadow-rgb: 0, 186, 199;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: {{ $settings->website_theme }};
            --bs-btn-active-border-color: {{ $settings->website_theme }};
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: {{ $settings->website_theme }};
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: {{ $settings->website_theme }};
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-secondary {
            --bs-btn-color: #9ea9b4;
            --bs-btn-border-color: #9ea9b4;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #9ea9b4;
            --bs-btn-hover-border-color: #9ea9b4;
            --bs-btn-focus-shadow-rgb: 158, 169, 180;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #9ea9b4;
            --bs-btn-active-border-color: #9ea9b4;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #9ea9b4;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #9ea9b4;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-success {
            --bs-btn-color: #31cf80;
            --bs-btn-border-color: #31cf80;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #31cf80;
            --bs-btn-hover-border-color: #31cf80;
            --bs-btn-focus-shadow-rgb: 49, 207, 128;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #31cf80;
            --bs-btn-active-border-color: #31cf80;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #31cf80;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #31cf80;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-info {
            --bs-btn-color: #2dadcf;
            --bs-btn-border-color: #2dadcf;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2dadcf;
            --bs-btn-hover-border-color: #2dadcf;
            --bs-btn-focus-shadow-rgb: 45, 173, 207;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #2dadcf;
            --bs-btn-active-border-color: #2dadcf;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #2dadcf;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #2dadcf;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-warning {
            --bs-btn-color: #ebcf4f;
            --bs-btn-border-color: #ebcf4f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #ebcf4f;
            --bs-btn-hover-border-color: #ebcf4f;
            --bs-btn-focus-shadow-rgb: 235, 207, 79;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #ebcf4f;
            --bs-btn-active-border-color: #ebcf4f;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #ebcf4f;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #ebcf4f;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-danger {
            --bs-btn-color: #d82c5b;
            --bs-btn-border-color: #d82c5b;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #d82c5b;
            --bs-btn-hover-border-color: #d82c5b;
            --bs-btn-focus-shadow-rgb: 216, 44, 91;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #d82c5b;
            --bs-btn-active-border-color: #d82c5b;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #d82c5b;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #d82c5b;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-light {
            --bs-btn-color: #363637;
            --bs-btn-border-color: #363637;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #363637;
            --bs-btn-hover-border-color: #363637;
            --bs-btn-focus-shadow-rgb: 54, 54, 55;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #363637;
            --bs-btn-active-border-color: #363637;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #363637;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #363637;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-dark {
            --bs-btn-color: #595c5f;
            --bs-btn-border-color: #595c5f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #595c5f;
            --bs-btn-hover-border-color: #595c5f;
            --bs-btn-focus-shadow-rgb: 89, 92, 95;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #595c5f;
            --bs-btn-active-border-color: #595c5f;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #595c5f;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #595c5f;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-light-green {
            --bs-btn-color: #1d1d1e;
            --bs-btn-border-color: #1d1d1e;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #1d1d1e;
            --bs-btn-hover-border-color: #1d1d1e;
            --bs-btn-focus-shadow-rgb: 29, 29, 30;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #1d1d1e;
            --bs-btn-active-border-color: #1d1d1e;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #1d1d1e;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #1d1d1e;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-white {
            --bs-btn-color: #2d2d2d;
            --bs-btn-border-color: #2d2d2d;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #2d2d2d;
            --bs-btn-hover-border-color: #2d2d2d;
            --bs-btn-focus-shadow-rgb: 45, 45, 45;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #2d2d2d;
            --bs-btn-active-border-color: #2d2d2d;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #2d2d2d;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #2d2d2d;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-black {
            --bs-btn-color: #fff;
            --bs-btn-border-color: #fff;
            --bs-btn-hover-color: #000;
            --bs-btn-hover-bg: #fff;
            --bs-btn-hover-border-color: #fff;
            --bs-btn-focus-shadow-rgb: 255, 255, 255;
            --bs-btn-active-color: #000;
            --bs-btn-active-bg: #fff;
            --bs-btn-active-border-color: #fff;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #fff;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #fff;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-100,
        [data-theme=dark] .btn-outline-gray-200 {
            --bs-btn-color: #1f1f1f;
            --bs-btn-border-color: #1f1f1f;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #1f1f1f;
            --bs-btn-hover-border-color: #1f1f1f;
            --bs-btn-focus-shadow-rgb: 31, 31, 31;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #1f1f1f;
            --bs-btn-active-border-color: #1f1f1f;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #1f1f1f;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #1f1f1f;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-300 {
            --bs-btn-color: #1e1e1e;
            --bs-btn-border-color: #1e1e1e;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #1e1e1e;
            --bs-btn-hover-border-color: #1e1e1e;
            --bs-btn-focus-shadow-rgb: 30, 30, 30;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #1e1e1e;
            --bs-btn-active-border-color: #1e1e1e;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #1e1e1e;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #1e1e1e;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-400 {
            --bs-btn-color: #1b1b1c;
            --bs-btn-border-color: #1b1b1c;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #1b1b1c;
            --bs-btn-hover-border-color: #1b1b1c;
            --bs-btn-focus-shadow-rgb: 27, 27, 28;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #1b1b1c;
            --bs-btn-active-border-color: #1b1b1c;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #1b1b1c;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #1b1b1c;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-500 {
            --bs-btn-color: #b7bcc2;
            --bs-btn-border-color: #b7bcc2;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #b7bcc2;
            --bs-btn-hover-border-color: #b7bcc2;
            --bs-btn-focus-shadow-rgb: 183, 188, 194;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #b7bcc2;
            --bs-btn-active-border-color: #b7bcc2;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #b7bcc2;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #b7bcc2;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-600 {
            --bs-btn-color: #b2b6bc;
            --bs-btn-border-color: #b2b6bc;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #b2b6bc;
            --bs-btn-hover-border-color: #b2b6bc;
            --bs-btn-focus-shadow-rgb: 178, 182, 188;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #b2b6bc;
            --bs-btn-active-border-color: #b2b6bc;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #b2b6bc;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #b2b6bc;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-700 {
            --bs-btn-color: #9b9b9b;
            --bs-btn-border-color: #9b9b9b;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #9b9b9b;
            --bs-btn-hover-border-color: #9b9b9b;
            --bs-btn-focus-shadow-rgb: 155, 155, 155;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #9b9b9b;
            --bs-btn-active-border-color: #9b9b9b;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #9b9b9b;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #9b9b9b;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-800 {
            --bs-btn-color: #85898c;
            --bs-btn-border-color: #85898c;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #85898c;
            --bs-btn-hover-border-color: #85898c;
            --bs-btn-focus-shadow-rgb: 133, 137, 140;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #85898c;
            --bs-btn-active-border-color: #85898c;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #85898c;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #85898c;
            --bs-gradient: none
        }

        [data-theme=dark] .btn-outline-gray-900 {
            --bs-btn-color: #909294;
            --bs-btn-border-color: #909294;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #909294;
            --bs-btn-hover-border-color: #909294;
            --bs-btn-focus-shadow-rgb: 144, 146, 148;
            --bs-btn-active-color: #fff;
            --bs-btn-active-bg: #909294;
            --bs-btn-active-border-color: #909294;
            --bs-btn-active-shadow: 0 0 transparent;
            --bs-btn-disabled-color: #909294;
            --bs-btn-disabled-bg: transparent;
            --bs-btn-disabled-border-color: #909294;
            --bs-gradient: none
        }

        .card {
            box-shadow: var(--bs-card-box-shadow);
            margin-bottom: 1.875rem
        }

        .card-header-space-between {
            align-items: center;
            display: flex;
            flex-direction: row;
            justify-content: space-between
        }

        .card-header-space-between>:first-child {
            flex-grow: 1
        }

        .card-header-title {
            margin-bottom: 0
        }

        [data-theme=dark] .card {
            --bs-card-bg: #2d2d2d
        }

        .card-h-100 {
            height: calc(100% - 1.875rem)
        }

        .typing:after,
        .typing:before {
            animation: scaling 2.5s ease-in-out infinite;
            background-color: currentColor;
            border-radius: 50%;
            content: "";
            display: inline-block;
            height: 5px;
            margin-left: 1px;
            margin-right: 1px;
            transform: scale(0);
            width: 5px
        }

        .typing:after {
            animation-delay: .5s
        }

        @keyframes scaling {

            0%,
            to {
                transform: scale(.4)
            }

            40% {
                transform: scale(1)
            }

            50% {
                transform: scale(1)
            }
        }

        [data-theme=dark] .btn-close {
            filter: invert(1) grayscale(100%) brightness(200%)
        }

        .cursor-pointer {
            cursor: pointer
        }

        .cursor-none {
            cursor: none
        }

        .cursor-not-allowed {
            cursor: not-allowed
        }

        .cursor-text {
            cursor: text
        }

        .cursor-default {
            cursor: default
        }

        .cursor-help {
            cursor: help
        }

        .cursor-move {
            cursor: move
        }

        .cursor-copy {
            cursor: copy
        }

        .cursor-wait {
            cursor: wait
        }

        .dropdown-menu {
            --bs-slidein-margin: calc(var(--bs-dropdown-spacer)*2);
            animation-duration: .2s;
            animation-fill-mode: both;
            animation-name: slideIn
        }

        .dropdown-item {
            align-items: center;
            display: flex
        }

        .dropdown-header {
            font-weight: 700
        }

        .dropdown-toggle {
            align-items: center;
            display: inline-flex
        }

        .dropdown-toggle:after {
            background-color: currentColor;
            border-width: 0 !important;
            content: "";
            display: inline-block;
            height: .75em;
            margin-left: 0;
            -webkit-mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            -webkit-mask-position: center right;
            mask-position: center right;
            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
            -webkit-mask-size: .75em;
            mask-size: .75em;
            padding-left: 0;
            vertical-align: 0;
            width: .75em
        }

        .dropdown .dropdown-toggle:after {
            padding-left: 1.3125em
        }

        .dropdown-toggle:not(.dropdown-toggle-split):after {
            margin-left: 1.3125em
        }

        .dropdown-toggle:empty:after {
            padding-left: 0
        }

        .dropdown-toggle.no-arrow:after,
        .dropdown-toggle.no-arrow:before {
            display: none !important
        }

        .dropup .dropdown-toggle:after {
            background-color: currentColor;
            border-width: 0 !important;
            content: "";
            display: inline-block;
            height: .75em;
            margin-left: 0;
            -webkit-mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            -webkit-mask-position: center right;
            mask-position: center right;
            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
            -webkit-mask-size: .75em;
            mask-size: .75em;
            padding-left: 0;
            transform: rotateX(180deg);
            vertical-align: 0;
            width: .75em
        }

        .dropdown .dropup .dropdown-toggle:after {
            padding-left: 1.3125em
        }

        .dropup .dropdown-toggle:not(.dropdown-toggle-split):after {
            margin-left: 1.3125em
        }

        .dropup .dropdown-toggle:empty:after {
            padding-left: 0
        }

        .dropend .dropdown-toggle:after {
            background-color: currentColor;
            border-width: 0 !important;
            content: "";
            display: inline-block;
            height: .75em;
            margin-left: 0;
            -webkit-mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            -webkit-mask-position: center right;
            mask-position: center right;
            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
            -webkit-mask-size: .75em;
            mask-size: .75em;
            padding-left: 0;
            transform: rotate(-90deg) translateY(-100%);
            transform-origin: right top;
            vertical-align: 0;
            width: .75em
        }

        .dropdown .dropend .dropdown-toggle:after {
            padding-left: 1.3125em
        }

        .dropend .dropdown-toggle:not(.dropdown-toggle-split):after {
            margin-left: 1.3125em
        }

        .dropend .dropdown-toggle:empty:after {
            padding-left: 0
        }

        .dropstart .dropdown-toggle:after {
            background-color: currentColor;
            border-width: 0 !important;
            content: "";
            display: inline-block;
            height: .75em;
            margin-left: 0;
            -webkit-mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            mask-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 19.5a2.3 2.3 0 0 1-1.729-.78L.46 7.568a1.847 1.847 0 0 1 2.773-2.439l8.579 9.752a.25.25 0 0 0 .376 0l8.579-9.752a1.847 1.847 0 1 1 2.773 2.439l-9.808 11.148A2.31 2.31 0 0 1 12 19.5Z"/></svg>');
            -webkit-mask-position: center right;
            mask-position: center right;
            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
            -webkit-mask-size: .75em;
            mask-size: .75em;
            padding-left: 0;
            vertical-align: 0;
            width: .75em
        }

        .dropdown .dropstart .dropdown-toggle:after {
            padding-left: 1.3125em
        }

        .dropstart .dropdown-toggle:not(.dropdown-toggle-split):after {
            margin-left: 1.3125em
        }

        .dropstart .dropdown-toggle:after {
            transform: rotate(90deg)
        }

        .dropstart .dropdown-toggle:before {
            display: none
        }

        .dropstart .dropdown-toggle:empty:after {
            padding-left: 0
        }

        @keyframes slideIn {
            to {
                margin-top: var(--bs-dropdown-spacer);
                opacity: 1
            }

            0% {
                margin-top: var(--bs-slidein-margin);
                opacity: 0
            }
        }

        .dropdown-menu.dropdown-menu-dark,
        [data-theme=dark] .dropdown-menu {
            --bs-dropdown-color: #f6f7f8;
            --bs-dropdown-bg: #323232;
            --bs-dropdown-border-color: var(--bs-border-color);
            --bs-dropdown-box-shadow: 0 1rem 3rem rgba(14, 34, 56, .1);
            --bs-dropdown-link-color: #f6f7f8;
            --bs-dropdown-link-hover-color: #fff;
            --bs-dropdown-divider-bg: hsla(220, 9%, 94%, .1);
            --bs-dropdown-link-hover-bg: #3e3e3e;
            --bs-dropdown-link-active-color: #fff;
            --bs-dropdown-link-active-bg: #3e3e3e;
            --bs-dropdown-link-disabled-color: #a5abb3;
            --bs-dropdown-header-color: #a5abb3
        }

        .col-form-label {
            font-size: .75rem
        }

        .form-control {
            font-family: Open Sans, Segoe UI Emoji, Segoe UI Symbol, Segoe UI, Apple Color Emoji, Twemoji Mozilla, Noto Color Emoji, EmojiOne Color, Android Emoji, sans-serif, system-ui, -apple-system
        }

        .form-control[readonly] {
            background-color: var(--bs-form-control-bg) !important
        }

        .form-control:disabled {
            background-color: #edeef0 !important;
            cursor: not-allowed
        }

        .form-select {
            --bs-form-select-bg: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3E%3Cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3E%3C/svg%3E");
            background-color: var(--bs-form-control-bg);
            background-image: var(--bs-form-select-bg)
        }

        [data-theme=dark] .form-select {
            --bs-form-select-bg: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3E%3Cpath fill='none' stroke='%23bcc0c6' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3E%3C/svg%3E")
        }

        .form-check-input {
            margin-top: calc(.75em - .5rem)
        }

        .form-check-label {
            font-size: .75rem;
            font-weight: 600
        }

        .form-switch {
            height: 1.5em
        }

        .form-switch .form-check-input {
            background-color: var(--bs-form-control-bg);
            border-color: var(--bs-gray-300);
            height: 1.5em;
            margin-top: 0
        }

        .form-switch .form-check-input:checked {
            background-color: {{ $settings->website_theme }};
            border-color: {{ $settings->website_theme }}
        }

        .form-switch .form-check-label {
            margin-top: 0
        }

        .form-state-switch {
            display: inline-block;
            margin-bottom: 0;
            padding-left: 0
        }

        .form-state-switch .form-state-input {
            display: none
        }

        .form-state-switch .form-state-input~.form-state-label .form-state-default {
            display: block
        }

        .form-state-switch .form-state-input:checked~.form-state-label .form-state-default,
        .form-state-switch .form-state-input~.form-state-label .form-state-active {
            display: none
        }

        .form-state-switch .form-state-input:checked~.form-state-label .form-state-active {
            display: block
        }

        .form-state-switch .form-state-label {
            cursor: pointer
        }

        .input-group>.form-control:focus,
        .input-group>.form-control:focus~.btn,
        .input-group>.form-select:focus,
        .input-group>.form-select:focus~.btn {
            z-index: 3
        }

        .input-group-merge {
            flex-wrap: nowrap
        }

        .input-group-merge>.form-control:first-child {
            border-right-width: 0
        }

        .input-group-merge>.form-control:last-child {
            border-left-width: 0
        }

        .input-group-merge>.form-control:not(:first-child):not(:last-child) {
            border-left-width: 0;
            border-right-width: 0
        }

        .input-group-merge>.form-control:focus {
            box-shadow: none
        }

        .input-group-merge>.input-group-text {
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out
        }

        .input-group-merge>.input-group-text:first-child {
            border-right-width: 0
        }

        .input-group-merge>.input-group-text:last-child,
        .input-group-merge>.input-group-text:not(:first-child):not(:last-child) {
            border-left-width: 0
        }

        @media(prefers-reduced-motion:reduce) {
            .input-group-merge>.input-group-text {
                transition: none
            }
        }

        .input-group-merge:focus-within>.form-control,
        .input-group-merge:focus-within>.input-group-text {
            border-color: {{ $settings->website_theme }}
        }

        .form-control-single-number {
            font-size: 2rem;
            font-weight: 700;
            text-align: center
        }

        main {
            --bs-main-content-bg: var(--bs-light-green)
        }

        .navbar-vertical~main {
            display: flex;
            flex-direction: column;
            height: 100%;
            min-height: 100vh
        }

        @media(min-width:992px) {
            .navbar-vertical~main:before {
                background-color: var(--bs-main-content-bg);
                bottom: 0;
                content: "";
                left: 0;
                position: absolute;
                right: 0;
                top: 13.625rem;
                z-index: -1
            }
        }

        @media(min-width:1200px) {

            .navbar-vertical~main .container,
            .navbar-vertical~main .container-fluid,
            .navbar-vertical~main .container-lg,
            .navbar-vertical~main .container-md,
            .navbar-vertical~main .container-sm,
            .navbar-vertical~main .container-xl,
            .navbar-vertical~main .container-xxl {
                padding-left: 2.8125rem !important;
                padding-right: 2.8125rem !important
            }
        }

        @media(min-width:992px) {
            .navbar-vertical.navbar-expand-xs~main {
                margin-left: 16.25rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical.navbar-expand-xs~main {
                margin-left: 4.125rem
            }

            .navbar-vertical.navbar-expand-sm~main {
                margin-left: 16.25rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical.navbar-expand-sm~main {
                margin-left: 4.125rem
            }

            .navbar-vertical.navbar-expand-md~main {
                margin-left: 16.25rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical.navbar-expand-md~main {
                margin-left: 4.125rem
            }

            .navbar-vertical.navbar-expand-lg~main {
                margin-left: 16.25rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical.navbar-expand-lg~main {
                margin-left: 4.125rem
            }

            .navbar-vertical.navbar-expand-xl~main {
                margin-left: 16.25rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical.navbar-expand-xl~main {
                margin-left: 4.125rem
            }

            .navbar-vertical.navbar-expand-xxl~main {
                margin-left: 16.25rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical.navbar-expand-xxl~main {
                margin-left: 4.125rem
            }
        }

        @media(min-width:992px)and (min-width:576px) {
            html[data-is-fluid=false] body {
                margin-left: auto;
                margin-right: auto;
                max-width: 540px;
                padding-left: calc(var(--bs-gutter-x)*.5);
                padding-right: calc(var(--bs-gutter-x)*.5);
                width: 100%
            }
        }

        @media(min-width:992px)and (min-width:768px) {
            html[data-is-fluid=false] body {
                margin-left: auto;
                margin-right: auto;
                max-width: 720px;
                padding-left: calc(var(--bs-gutter-x)*.5);
                padding-right: calc(var(--bs-gutter-x)*.5);
                width: 100%
            }
        }

        @media(min-width:992px)and (min-width:992px) {
            html[data-is-fluid=false] body {
                margin-left: auto;
                margin-right: auto;
                max-width: 960px;
                padding-left: calc(var(--bs-gutter-x)*.5);
                padding-right: calc(var(--bs-gutter-x)*.5);
                width: 100%
            }
        }

        @media(min-width:992px)and (min-width:1200px) {
            html[data-is-fluid=false] body {
                margin-left: auto;
                margin-right: auto;
                max-width: 1320px;
                padding-left: calc(var(--bs-gutter-x)*.5);
                padding-right: calc(var(--bs-gutter-x)*.5);
                width: 100%
            }
        }

        @media(min-width:992px)and (min-width:1400px) {
            html[data-is-fluid=false] body {
                margin-left: auto;
                margin-right: auto;
                max-width: 1480px;
                padding-left: calc(var(--bs-gutter-x)*.5);
                padding-right: calc(var(--bs-gutter-x)*.5);
                width: 100%
            }
        }

        [data-theme=dark] main {
            --bs-main-content-bg: #1f1f1f
        }

        .legend-circle {
            height: .4375rem;
            margin-right: .375rem;
            width: .4375rem
        }

        .legend-circle,
        .legend-circle-sm {
            background-color: var(--bs-secondary);
            border-radius: 50%;
            display: inline-block
        }

        .legend-circle-sm {
            height: .3125rem;
            margin-right: .25rem;
            width: .3125rem
        }

        .legend-circle-lg {
            background-color: var(--bs-secondary);
            border-radius: 50%;
            display: inline-block;
            height: .5625rem;
            margin-right: .5rem;
            width: .5625rem
        }

        .list-group-active-border>.list-group-item {
            border-left: 3px solid transparent
        }

        .list-group-active-border>.list-group-item.active {
            background-color: transparent;
            border-color: var(--bs-link-color);
            color: var(--bs-link-color) r
        }

        .list-group-flush-all>.list-group-item {
            border-bottom: 0;
            border-top: 0
        }

        .list-group-flush-all>.list-group-item.active {
            border-top-width: 0;
            margin-top: 0
        }

        [data-theme=dark] .modal-backdrop {
            --bs-backdrop-zindex: 1050;
            --bs-backdrop-bg: #000;
            --bs-backdrop-opacity: 0.4;
            background-color: var(--bs-backdrop-bg);
            height: 100vh;
            left: 0;
            position: fixed;
            top: 0;
            width: 100vw;
            z-index: var(--bs-backdrop-zindex)
        }

        [data-theme=dark] .modal-backdrop.fade {
            opacity: 0
        }

        [data-theme=dark] .modal-backdrop.show {
            opacity: var(--bs-backdrop-opacity)
        }

        .nav-tabs .nav-item {
            margin: 0 .75rem
        }

        .nav-tabs .nav-item:first-child {
            margin-left: 0
        }

        .nav-tabs .nav-item:last-child {
            margin-right: 0
        }

        .nav-tabs .nav-link {
            border-width: 0 0 2px;
            color: var(--bs-body-color);
            font-weight: 600;
            padding: .625rem 0
        }

        .navbar {
            --bs-navbar-active-bg: rgba(0, 186, 199, .06);
            --bs-navbar-collapse-icon: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12'%3E%3Cpath fill='none' stroke='%239EA9B4' stroke-linecap='round' stroke-linejoin='round' stroke-width='1' d='m11.625 3.655-5.36 5.36a.374.374 0 0 1-.53 0l-5.36-5.36'/%3E%3C/svg%3E");
            --bs-navbar-collapse-icon-hover: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12'%3E%3Cpath fill='none' stroke='%2300BAC7' stroke-linecap='round' stroke-linejoin='round' stroke-width='1' d='m11.625 3.655-5.36 5.36a.374.374 0 0 1-.53 0l-5.36-5.36'/%3E%3C/svg%3E");
            --bs-navbar-collapse-icon-active: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12'%3E%3Cpath fill='none' stroke='%2300BAC7' stroke-linecap='round' stroke-linejoin='round' stroke-width='1' d='m11.625 3.655-5.36 5.36a.374.374 0 0 1-.53 0l-5.36-5.36'/%3E%3C/svg%3E");
            --bs-navbar-active-color-sub: var(--bs-body-color);
            --bs-navbar-vertical-border-color: hsla(214, 8%, 67%, .1);
            --bs-dropdown-color: var(--bs-body-color);
            --bs-dropdown-bg: #fff;
            --bs-dropdown-border-color: var(--bs-border-color);
            --bs-dropdown-border-radius: 0.625rem;
            --bs-dropdown-border-width: 0;
            --bs-dropdown-box-shadow: 0 1rem 3rem rgba(14, 34, 56, .1);
            --bs-dropdown-link-hover-bg: var(--bs-gray-100);
            --bs-dropdown-link-active-bg: var(--bs-gray-100)
        }

        .navbar-nav .nav .nav-item .nav-link {
            color: var(--bs-navbar-color)
        }

        .navbar-nav .nav .nav-item .nav-link.active,
        .navbar-nav .nav .nav-item .nav-link:focus,
        .navbar-nav .nav .nav-item .nav-link:hover,
        .navbar-nav .nav .nav-item .show>.nav-link {
            color: var(--bs-navbar-active-color-sub)
        }

        .navbar-vertical.navbar-expand-xs {
            border-right: 1px solid var(--bs-navbar-vertical-border-color);
            bottom: 0;
            display: block;
            max-width: 16.25rem;
            overflow-y: auto;
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1000
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link {
            align-items: center;
            border-bottom-right-radius: 1.875rem;
            border-top-right-radius: 1.875rem;
            display: flex;
            font-weight: 600;
            margin-right: 1.875rem;
            padding-right: 1.25rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon);
            display: block;
            margin-left: auto;
            transition: transform .2s
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link:focus[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link:hover[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-hover)
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link[aria-expanded=true]:after {
            transform: rotate(-180deg)
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link .nav-link-icon {
            flex-shrink: 0;
            margin-right: .625rem;
            width: 1.125rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link.active,
        .navbar-vertical.navbar-expand-xs .navbar-nav .show>.nav-link {
            background-color: var(--bs-navbar-active-bg)
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link.active[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-xs .navbar-nav .show>.nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-active)
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav {
            margin-bottom: .625rem;
            margin-top: .625rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-item {
            position: relative
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-item:after {
            background-color: var(--bs-navbar-color);
            content: "";
            height: .625rem;
            left: 2.375rem;
            opacity: .3;
            position: absolute;
            top: 0;
            transform: translateY(-50%);
            width: .0625rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-item:first-child:after {
            height: .3125rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-link {
            font-size: .75rem;
            padding-bottom: .3625rem;
            padding-left: 3.625rem;
            padding-top: .3625rem;
            position: relative
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-link:before {
            background-color: var(--bs-navbar-color);
            border-radius: .375rem;
            content: "";
            height: .375rem;
            left: 2.25rem;
            opacity: .3;
            position: absolute;
            top: var(--bs-nav-link-padding-y)-.1875rem0.03125rem;
            width: .375rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-link.show:before {
            background-color: var(--bs-navbar-active-color);
            opacity: 1
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav-link.active,
        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .show>.nav-link {
            background-color: transparent
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav {
            margin-top: .3125rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav .nav-item:after {
            left: 3.75rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav .nav-item:focus,
        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav .nav-item:hover {
            color: var(--bs-navbar-color)
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav .nav-link {
            padding-left: 4.75rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav .nav-link:before {
            background-color: transparent;
            border: 1px solid var(--bs-navbar-color);
            left: 3.625rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-xs .navbar-nav .nav .nav .show>.nav-link:before {
            border-color: var(--bs-navbar-active-color)
        }

        .navbar-vertical.navbar-expand-xs>[class*=container] {
            align-items: stretch;
            flex-direction: column;
            min-height: 100%;
            padding-left: 0;
            padding-right: 0
        }

        .navbar-vertical.navbar-expand-xs .navbar-collapse {
            align-items: stretch;
            display: flex;
            flex: 1;
            flex-direction: column
        }

        .navbar-vertical.navbar-expand-xs .navbar-brand {
            margin-bottom: 2.375rem
        }

        .navbar-vertical.navbar-expand-xs .navbar-nav {
            flex-direction: column;
            margin-left: calc(var(--bs-navbar-padding-x)*-1);
            margin-right: calc(var(--bs-navbar-padding-x)*-1)
        }

        @media(max-width:991.98px) {
            .navbar-vertical.navbar-expand-xs {
                padding-bottom: calc(var(--bs-navbar-padding-y)/1.75);
                padding-left: 0;
                padding-right: 0;
                padding-top: calc(var(--bs-navbar-padding-y)/1.75)
            }

            .navbar-vertical.navbar-expand-xs .navbar-collapse {
                margin-left: calc(var(--bs-navbar-padding-x)*-1/2);
                margin-right: calc(var(--bs-navbar-padding-x)*-1/2)
            }

            .navbar-vertical.navbar-expand-xs .navbar-nav {
                padding-bottom: var(--bs-navbar-padding-y);
                padding-top: var(--bs-navbar-padding-y)
            }

            .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link {
                margin-right: calc(var(--bs-navbar-padding-x)/2);
                padding-left: calc(var(--bs-navbar-padding-x)/2)
            }
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link {
            align-items: center;
            border-bottom-right-radius: 1.875rem;
            border-top-right-radius: 1.875rem;
            display: flex;
            font-weight: 600;
            margin-right: 1.875rem;
            padding-right: 1.25rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon);
            display: block;
            margin-left: auto;
            transition: transform .2s
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link:focus[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link:hover[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-hover)
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link[aria-expanded=true]:after {
            transform: rotate(-180deg)
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link .nav-link-icon {
            flex-shrink: 0;
            margin-right: .625rem;
            width: 1.125rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link.active,
        .navbar-vertical.navbar-expand-sm .navbar-nav .show>.nav-link {
            background-color: var(--bs-navbar-active-bg)
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link.active[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-sm .navbar-nav .show>.nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-active)
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav {
            margin-bottom: .625rem;
            margin-top: .625rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-item {
            position: relative
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-item:after {
            background-color: var(--bs-navbar-color);
            content: "";
            height: .625rem;
            left: 2.375rem;
            opacity: .3;
            position: absolute;
            top: 0;
            transform: translateY(-50%);
            width: .0625rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-item:first-child:after {
            height: .3125rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-link {
            font-size: .75rem;
            padding-bottom: .3625rem;
            padding-left: 3.625rem;
            padding-top: .3625rem;
            position: relative
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-link:before {
            background-color: var(--bs-navbar-color);
            border-radius: .375rem;
            content: "";
            height: .375rem;
            left: 2.25rem;
            opacity: .3;
            position: absolute;
            top: var(--bs-nav-link-padding-y)-.1875rem0.03125rem;
            width: .375rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-link.show:before {
            background-color: var(--bs-navbar-active-color);
            opacity: 1
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav-link.active,
        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .show>.nav-link {
            background-color: transparent
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav {
            margin-top: .3125rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav .nav-item:after {
            left: 3.75rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav .nav-item:focus,
        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav .nav-item:hover {
            color: var(--bs-navbar-color)
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav .nav-link {
            padding-left: 4.75rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav .nav-link:before {
            background-color: transparent;
            border: 1px solid var(--bs-navbar-color);
            left: 3.625rem
        }

        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-sm .navbar-nav .nav .nav .show>.nav-link:before {
            border-color: var(--bs-navbar-active-color)
        }

        @media(min-width:576px) {
            .navbar-vertical.navbar-expand-sm {
                border-right: 1px solid var(--bs-navbar-vertical-border-color);
                bottom: 0;
                display: block;
                max-width: 16.25rem;
                overflow-y: auto;
                position: fixed;
                top: 0;
                width: 100%;
                z-index: 1000
            }

            .navbar-vertical.navbar-expand-sm>[class*=container] {
                align-items: stretch;
                flex-direction: column;
                min-height: 100%;
                padding-left: 0;
                padding-right: 0
            }

            .navbar-vertical.navbar-expand-sm .navbar-collapse {
                align-items: stretch;
                display: flex;
                flex: 1;
                flex-direction: column
            }

            .navbar-vertical.navbar-expand-sm .navbar-brand {
                margin-bottom: 2.375rem
            }

            .navbar-vertical.navbar-expand-sm .navbar-nav {
                flex-direction: column;
                margin-left: calc(var(--bs-navbar-padding-x)*-1);
                margin-right: calc(var(--bs-navbar-padding-x)*-1)
            }
        }

        @media(max-width:991.98px) {
            .navbar-vertical.navbar-expand-sm {
                padding-bottom: calc(var(--bs-navbar-padding-y)/1.75);
                padding-left: 0;
                padding-right: 0;
                padding-top: calc(var(--bs-navbar-padding-y)/1.75)
            }

            .navbar-vertical.navbar-expand-sm .navbar-collapse {
                margin-left: calc(var(--bs-navbar-padding-x)*-1/2);
                margin-right: calc(var(--bs-navbar-padding-x)*-1/2)
            }

            .navbar-vertical.navbar-expand-sm .navbar-nav {
                padding-bottom: var(--bs-navbar-padding-y);
                padding-top: var(--bs-navbar-padding-y)
            }

            .navbar-vertical.navbar-expand-sm .navbar-nav .nav-link {
                margin-right: calc(var(--bs-navbar-padding-x)/2);
                padding-left: calc(var(--bs-navbar-padding-x)/2)
            }
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link {
            align-items: center;
            border-bottom-right-radius: 1.875rem;
            border-top-right-radius: 1.875rem;
            display: flex;
            font-weight: 600;
            margin-right: 1.875rem;
            padding-right: 1.25rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon);
            display: block;
            margin-left: auto;
            transition: transform .2s
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link:focus[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link:hover[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-hover)
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link[aria-expanded=true]:after {
            transform: rotate(-180deg)
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link .nav-link-icon {
            flex-shrink: 0;
            margin-right: .625rem;
            width: 1.125rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link.active,
        .navbar-vertical.navbar-expand-md .navbar-nav .show>.nav-link {
            background-color: var(--bs-navbar-active-bg)
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav-link.active[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-md .navbar-nav .show>.nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-active)
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav {
            margin-bottom: .625rem;
            margin-top: .625rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-item {
            position: relative
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-item:after {
            background-color: var(--bs-navbar-color);
            content: "";
            height: .625rem;
            left: 2.375rem;
            opacity: .3;
            position: absolute;
            top: 0;
            transform: translateY(-50%);
            width: .0625rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-item:first-child:after {
            height: .3125rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-link {
            font-size: .75rem;
            padding-bottom: .3625rem;
            padding-left: 3.625rem;
            padding-top: .3625rem;
            position: relative
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-link:before {
            background-color: var(--bs-navbar-color);
            border-radius: .375rem;
            content: "";
            height: .375rem;
            left: 2.25rem;
            opacity: .3;
            position: absolute;
            top: var(--bs-nav-link-padding-y)-.1875rem0.03125rem;
            width: .375rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-link.show:before {
            background-color: var(--bs-navbar-active-color);
            opacity: 1
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav-link.active,
        .navbar-vertical.navbar-expand-md .navbar-nav .nav .show>.nav-link {
            background-color: transparent
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav {
            margin-top: .3125rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav .nav-item:after {
            left: 3.75rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav .nav-item:focus,
        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav .nav-item:hover {
            color: var(--bs-navbar-color)
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav .nav-link {
            padding-left: 4.75rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav .nav-link:before {
            background-color: transparent;
            border: 1px solid var(--bs-navbar-color);
            left: 3.625rem
        }

        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-md .navbar-nav .nav .nav .show>.nav-link:before {
            border-color: var(--bs-navbar-active-color)
        }

        @media(min-width:768px) {
            .navbar-vertical.navbar-expand-md {
                border-right: 1px solid var(--bs-navbar-vertical-border-color);
                bottom: 0;
                display: block;
                max-width: 16.25rem;
                overflow-y: auto;
                position: fixed;
                top: 0;
                width: 100%;
                z-index: 1000
            }

            .navbar-vertical.navbar-expand-md>[class*=container] {
                align-items: stretch;
                flex-direction: column;
                min-height: 100%;
                padding-left: 0;
                padding-right: 0
            }

            .navbar-vertical.navbar-expand-md .navbar-collapse {
                align-items: stretch;
                display: flex;
                flex: 1;
                flex-direction: column
            }

            .navbar-vertical.navbar-expand-md .navbar-brand {
                margin-bottom: 2.375rem
            }

            .navbar-vertical.navbar-expand-md .navbar-nav {
                flex-direction: column;
                margin-left: calc(var(--bs-navbar-padding-x)*-1);
                margin-right: calc(var(--bs-navbar-padding-x)*-1)
            }
        }

        @media(max-width:991.98px) {
            .navbar-vertical.navbar-expand-md {
                padding-bottom: calc(var(--bs-navbar-padding-y)/1.75);
                padding-left: 0;
                padding-right: 0;
                padding-top: calc(var(--bs-navbar-padding-y)/1.75)
            }

            .navbar-vertical.navbar-expand-md .navbar-collapse {
                margin-left: calc(var(--bs-navbar-padding-x)*-1/2);
                margin-right: calc(var(--bs-navbar-padding-x)*-1/2)
            }

            .navbar-vertical.navbar-expand-md .navbar-nav {
                padding-bottom: var(--bs-navbar-padding-y);
                padding-top: var(--bs-navbar-padding-y)
            }

            .navbar-vertical.navbar-expand-md .navbar-nav .nav-link {
                margin-right: calc(var(--bs-navbar-padding-x)/2);
                padding-left: calc(var(--bs-navbar-padding-x)/2)
            }
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link {
            align-items: center;
            border-bottom-right-radius: 1.875rem;
            border-top-right-radius: 1.875rem;
            display: flex;
            font-weight: 600;
            margin-right: 1.875rem;
            padding-right: 1.25rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon);
            display: block;
            margin-left: auto;
            transition: transform .2s
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link:focus[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link:hover[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-hover)
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link[aria-expanded=true]:after {
            transform: rotate(-180deg)
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link .nav-link-icon {
            flex-shrink: 0;
            margin-right: .625rem;
            width: 1.125rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link.active,
        .navbar-vertical.navbar-expand-lg .navbar-nav .show>.nav-link {
            background-color: var(--bs-navbar-active-bg)
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link.active[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-lg .navbar-nav .show>.nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-active)
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav {
            margin-bottom: .625rem;
            margin-top: .625rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-item {
            position: relative
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-item:after {
            background-color: var(--bs-navbar-color);
            content: "";
            height: .625rem;
            left: 2.375rem;
            opacity: .3;
            position: absolute;
            top: 0;
            transform: translateY(-50%);
            width: .0625rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-item:first-child:after {
            height: .3125rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-link {
            font-size: .75rem;
            padding-bottom: .3625rem;
            padding-left: 3.625rem;
            padding-top: .3625rem;
            position: relative
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-link:before {
            background-color: var(--bs-navbar-color);
            border-radius: .375rem;
            content: "";
            height: .375rem;
            left: 2.25rem;
            opacity: .3;
            position: absolute;
            top: var(--bs-nav-link-padding-y)-.1875rem0.03125rem;
            width: .375rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-link.show:before {
            background-color: var(--bs-navbar-active-color);
            opacity: 1
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav-link.active,
        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .show>.nav-link {
            background-color: transparent
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav {
            margin-top: .3125rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav .nav-item:after {
            left: 3.75rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav .nav-item:focus,
        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav .nav-item:hover {
            color: var(--bs-navbar-color)
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav .nav-link {
            padding-left: 4.75rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav .nav-link:before {
            background-color: transparent;
            border: 1px solid var(--bs-navbar-color);
            left: 3.625rem
        }

        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-lg .navbar-nav .nav .nav .show>.nav-link:before {
            border-color: var(--bs-navbar-active-color)
        }

        @media(min-width:992px) {
            .navbar-vertical.navbar-expand-lg {
                border-right: 1px solid var(--bs-navbar-vertical-border-color);
                bottom: 0;
                display: block;
                max-width: 16.25rem;
                overflow-y: auto;
                position: fixed;
                top: 0;
                width: 100%;
                z-index: 1000
            }

            .navbar-vertical.navbar-expand-lg>[class*=container] {
                align-items: stretch;
                flex-direction: column;
                min-height: 100%;
                padding-left: 0;
                padding-right: 0
            }

            .navbar-vertical.navbar-expand-lg .navbar-collapse {
                align-items: stretch;
                display: flex;
                flex: 1;
                flex-direction: column
            }

            .navbar-vertical.navbar-expand-lg .navbar-brand {
                margin-bottom: 2.375rem
            }

            .navbar-vertical.navbar-expand-lg .navbar-nav {
                flex-direction: column;
                margin-left: calc(var(--bs-navbar-padding-x)*-1);
                margin-right: calc(var(--bs-navbar-padding-x)*-1)
            }
        }

        @media(max-width:991.98px) {
            .navbar-vertical.navbar-expand-lg {
                padding-bottom: calc(var(--bs-navbar-padding-y)/1.75);
                padding-left: 0;
                padding-right: 0;
                padding-top: calc(var(--bs-navbar-padding-y)/1.75)
            }

            .navbar-vertical.navbar-expand-lg .navbar-collapse {
                margin-left: calc(var(--bs-navbar-padding-x)*-1/2);
                margin-right: calc(var(--bs-navbar-padding-x)*-1/2)
            }

            .navbar-vertical.navbar-expand-lg .navbar-nav {
                padding-bottom: var(--bs-navbar-padding-y);
                padding-top: var(--bs-navbar-padding-y)
            }

            .navbar-vertical.navbar-expand-lg .navbar-nav .nav-link {
                margin-right: calc(var(--bs-navbar-padding-x)/2);
                padding-left: calc(var(--bs-navbar-padding-x)/2)
            }
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link {
            align-items: center;
            border-bottom-right-radius: 1.875rem;
            border-top-right-radius: 1.875rem;
            display: flex;
            font-weight: 600;
            margin-right: 1.875rem;
            padding-right: 1.25rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon);
            display: block;
            margin-left: auto;
            transition: transform .2s
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link:focus[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link:hover[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-hover)
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link[aria-expanded=true]:after {
            transform: rotate(-180deg)
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link .nav-link-icon {
            flex-shrink: 0;
            margin-right: .625rem;
            width: 1.125rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link.active,
        .navbar-vertical.navbar-expand-xl .navbar-nav .show>.nav-link {
            background-color: var(--bs-navbar-active-bg)
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link.active[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-xl .navbar-nav .show>.nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-active)
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav {
            margin-bottom: .625rem;
            margin-top: .625rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-item {
            position: relative
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-item:after {
            background-color: var(--bs-navbar-color);
            content: "";
            height: .625rem;
            left: 2.375rem;
            opacity: .3;
            position: absolute;
            top: 0;
            transform: translateY(-50%);
            width: .0625rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-item:first-child:after {
            height: .3125rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-link {
            font-size: .75rem;
            padding-bottom: .3625rem;
            padding-left: 3.625rem;
            padding-top: .3625rem;
            position: relative
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-link:before {
            background-color: var(--bs-navbar-color);
            border-radius: .375rem;
            content: "";
            height: .375rem;
            left: 2.25rem;
            opacity: .3;
            position: absolute;
            top: var(--bs-nav-link-padding-y)-.1875rem0.03125rem;
            width: .375rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-link.show:before {
            background-color: var(--bs-navbar-active-color);
            opacity: 1
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav-link.active,
        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .show>.nav-link {
            background-color: transparent
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav {
            margin-top: .3125rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav .nav-item:after {
            left: 3.75rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav .nav-item:focus,
        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav .nav-item:hover {
            color: var(--bs-navbar-color)
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav .nav-link {
            padding-left: 4.75rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav .nav-link:before {
            background-color: transparent;
            border: 1px solid var(--bs-navbar-color);
            left: 3.625rem
        }

        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-xl .navbar-nav .nav .nav .show>.nav-link:before {
            border-color: var(--bs-navbar-active-color)
        }

        @media(min-width:1200px) {
            .navbar-vertical.navbar-expand-xl {
                border-right: 1px solid var(--bs-navbar-vertical-border-color);
                bottom: 0;
                display: block;
                max-width: 16.25rem;
                overflow-y: auto;
                position: fixed;
                top: 0;
                width: 100%;
                z-index: 1000
            }

            .navbar-vertical.navbar-expand-xl>[class*=container] {
                align-items: stretch;
                flex-direction: column;
                min-height: 100%;
                padding-left: 0;
                padding-right: 0
            }

            .navbar-vertical.navbar-expand-xl .navbar-collapse {
                align-items: stretch;
                display: flex;
                flex: 1;
                flex-direction: column
            }

            .navbar-vertical.navbar-expand-xl .navbar-brand {
                margin-bottom: 2.375rem
            }

            .navbar-vertical.navbar-expand-xl .navbar-nav {
                flex-direction: column;
                margin-left: calc(var(--bs-navbar-padding-x)*-1);
                margin-right: calc(var(--bs-navbar-padding-x)*-1)
            }
        }

        @media(max-width:991.98px) {
            .navbar-vertical.navbar-expand-xl {
                padding-bottom: calc(var(--bs-navbar-padding-y)/1.75);
                padding-left: 0;
                padding-right: 0;
                padding-top: calc(var(--bs-navbar-padding-y)/1.75)
            }

            .navbar-vertical.navbar-expand-xl .navbar-collapse {
                margin-left: calc(var(--bs-navbar-padding-x)*-1/2);
                margin-right: calc(var(--bs-navbar-padding-x)*-1/2)
            }

            .navbar-vertical.navbar-expand-xl .navbar-nav {
                padding-bottom: var(--bs-navbar-padding-y);
                padding-top: var(--bs-navbar-padding-y)
            }

            .navbar-vertical.navbar-expand-xl .navbar-nav .nav-link {
                margin-right: calc(var(--bs-navbar-padding-x)/2);
                padding-left: calc(var(--bs-navbar-padding-x)/2)
            }
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link {
            align-items: center;
            border-bottom-right-radius: 1.875rem;
            border-top-right-radius: 1.875rem;
            display: flex;
            font-weight: 600;
            margin-right: 1.875rem;
            padding-right: 1.25rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon);
            display: block;
            margin-left: auto;
            transition: transform .2s
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link:focus[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link:hover[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-hover)
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link[aria-expanded=true]:after {
            transform: rotate(-180deg)
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link .nav-link-icon {
            flex-shrink: 0;
            margin-right: .625rem;
            width: 1.125rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link.active,
        .navbar-vertical.navbar-expand-xxl .navbar-nav .show>.nav-link {
            background-color: var(--bs-navbar-active-bg)
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link.active[data-bs-toggle=collapse]:after,
        .navbar-vertical.navbar-expand-xxl .navbar-nav .show>.nav-link[data-bs-toggle=collapse]:after {
            content: var(--bs-navbar-collapse-icon-active)
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav {
            margin-bottom: .625rem;
            margin-top: .625rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-item {
            position: relative
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-item:after {
            background-color: var(--bs-navbar-color);
            content: "";
            height: .625rem;
            left: 2.375rem;
            opacity: .3;
            position: absolute;
            top: 0;
            transform: translateY(-50%);
            width: .0625rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-item:first-child:after {
            height: .3125rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-link {
            font-size: .75rem;
            padding-bottom: .3625rem;
            padding-left: 3.625rem;
            padding-top: .3625rem;
            position: relative
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-link:before {
            background-color: var(--bs-navbar-color);
            border-radius: .375rem;
            content: "";
            height: .375rem;
            left: 2.25rem;
            opacity: .3;
            position: absolute;
            top: var(--bs-nav-link-padding-y)-.1875rem0.03125rem;
            width: .375rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-link.show:before {
            background-color: var(--bs-navbar-active-color);
            opacity: 1
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav-link.active,
        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .show>.nav-link {
            background-color: transparent
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav {
            margin-top: .3125rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav .nav-item:after {
            left: 3.75rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav .nav-item:focus,
        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav .nav-item:hover {
            color: var(--bs-navbar-color)
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav .nav-link {
            padding-left: 4.75rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav .nav-link:before {
            background-color: transparent;
            border: 1px solid var(--bs-navbar-color);
            left: 3.625rem
        }

        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav .nav-link.active:before,
        .navbar-vertical.navbar-expand-xxl .navbar-nav .nav .nav .show>.nav-link:before {
            border-color: var(--bs-navbar-active-color)
        }

        @media(min-width:1400px) {
            .navbar-vertical.navbar-expand-xxl {
                border-right: 1px solid var(--bs-navbar-vertical-border-color);
                bottom: 0;
                display: block;
                max-width: 16.25rem;
                overflow-y: auto;
                position: fixed;
                top: 0;
                width: 100%;
                z-index: 1000
            }

            .navbar-vertical.navbar-expand-xxl>[class*=container] {
                align-items: stretch;
                flex-direction: column;
                min-height: 100%;
                padding-left: 0;
                padding-right: 0
            }

            .navbar-vertical.navbar-expand-xxl .navbar-collapse {
                align-items: stretch;
                display: flex;
                flex: 1;
                flex-direction: column
            }

            .navbar-vertical.navbar-expand-xxl .navbar-brand {
                margin-bottom: 2.375rem
            }

            .navbar-vertical.navbar-expand-xxl .navbar-nav {
                flex-direction: column;
                margin-left: calc(var(--bs-navbar-padding-x)*-1);
                margin-right: calc(var(--bs-navbar-padding-x)*-1)
            }
        }

        @media(max-width:991.98px) {
            .navbar-vertical.navbar-expand-xxl {
                padding-bottom: calc(var(--bs-navbar-padding-y)/1.75);
                padding-left: 0;
                padding-right: 0;
                padding-top: calc(var(--bs-navbar-padding-y)/1.75)
            }

            .navbar-vertical.navbar-expand-xxl .navbar-collapse {
                margin-left: calc(var(--bs-navbar-padding-x)*-1/2);
                margin-right: calc(var(--bs-navbar-padding-x)*-1/2)
            }

            .navbar-vertical.navbar-expand-xxl .navbar-nav {
                padding-bottom: var(--bs-navbar-padding-y);
                padding-top: var(--bs-navbar-padding-y)
            }

            .navbar-vertical.navbar-expand-xxl .navbar-nav .nav-link {
                margin-right: calc(var(--bs-navbar-padding-x)/2);
                padding-left: calc(var(--bs-navbar-padding-x)/2)
            }
        }

        @media(min-width:992px) {
            [data-sidebar-behaviour=condensed] .navbar-vertical {
                max-width: 4.125rem;
                overflow-y: visible;
                position: absolute
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-brand {
                margin-left: calc(var(--bs-navbar-padding-x)*-1);
                margin-right: calc(var(--bs-navbar-padding-x)*-1);
                text-align: center
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-collapse {
                padding-left: 0;
                padding-right: 0
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav {
                align-items: center
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav-item {
                margin-right: calc(-1.8125rem - var(--bs-nav-link-padding-y)*-1);
                padding-right: calc(1.8125rem - var(--bs-nav-link-padding-y));
                position: relative
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav-item:hover>.collapse {
                display: block
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav-item:hover>.collapse>.nav {
                display: block !important
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav-item .nav-item {
                margin-right: -.094rem;
                padding-right: .094rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav>.nav-item>.nav-link>span {
                display: none
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav>.nav-item>.nav-link[data-bs-toggle=collapse]:before {
                background-color: currentColor;
                border-radius: 50%;
                content: "";
                height: .25rem;
                left: .375rem;
                position: absolute;
                top: 50%;
                transform: translateY(-50%);
                width: .25rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav>.nav-item:hover>.nav-link {
                color: var(--bs-link-color)
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav-link {
                align-items: center;
                border-radius: 100%;
                display: flex;
                margin-right: 0;
                padding: var(--bs-nav-link-padding-y)
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav-link[data-bs-toggle=collapse]:after {
                display: none
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav-link .nav-link-icon {
                margin-right: 0
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav {
                background-color: var(--bs-dropdown-bg);
                border: var(--bs-dropdown-border-width) solid var(--bs-dropdown-border-color);
                border-radius: var(--bs-dropdown-border-radius);
                box-shadow: 1rem 1rem 3rem rgba(14, 34, 56, .1);
                color: var(--bs-dropdown-color);
                display: none;
                left: 100%;
                min-width: 10rem;
                padding: .375rem 0;
                position: absolute;
                top: -.453125rem;
                z-index: 1
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-item:after {
                display: none
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-item:focus>.nav-link,
            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-item:hover>.nav-link {
                background-color: var(--bs-dropdown-link-hover-bg)
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-link {
                border-radius: 0;
                padding: .46875rem .9375rem
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-link:focus,
            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-link:hover {
                background-color: var(--bs-dropdown-link-hover-bg)
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-link.active,
            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-link:active {
                background-color: var(--bs-dropdown-link-active-bg)
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav-link:before {
                display: none
            }

            [data-sidebar-behaviour=condensed] .navbar-vertical .navbar-nav .nav .nav {
                top: -.640625rem
            }

            [data-sidebar-behaviour=condensed] .help-box {
                display: none
            }

            [data-sidebar-behaviour=scrollable] .navbar-vertical {
                position: absolute
            }
        }

        .help-box {
            background-color: rgba(0, 186, 199, .1);
            color: #a5abb3;
            display: none
        }

        @media(min-width:992px) {
            .help-box {
                display: block
            }
        }

        .help-box .emphasize {
            color: var(--bs-body-color)
        }

        .navbar-dark .help-box,
        [data-theme=dark] .help-box {
            background-color: rgba(0, 186, 199, .2)
        }

        .navbar-dark .help-box .emphasize,
        [data-theme=dark] .help-box .emphasize {
            color: #fff
        }

        .navbar-brand-img.logo-dark,
        .navbar-brand-img.logo-large,
        .navbar-brand-img.logo-light,
        .navbar-brand-img.logo-small {
            display: none
        }

        html:not([data-theme=dark]):not([data-navigation-color=inverted]):not([data-sidebar-behaviour=condensed]) .navbar-brand-img.logo-large.logo-light,
        html:not([data-theme=dark]):not([data-navigation-color=inverted])[data-sidebar-behaviour=condensed] .navbar-brand-img.logo-small.logo-light,
        html:not([data-theme=dark])[data-navigation-color=inverted]:not([data-sidebar-behaviour=condensed]) .navbar-brand-img.logo-large.logo-dark,
        html:not([data-theme=dark])[data-navigation-color=inverted][data-sidebar-behaviour=condensed] .navbar-brand-img.logo-small.logo-dark,
        html[data-theme=dark]:not([data-sidebar-behaviour=condensed]) .navbar-brand-img.logo-large.logo-dark,
        html[data-theme=dark][data-sidebar-behaviour=condensed] .navbar-brand-img.logo-small.logo-dark {
            display: inline
        }

        .navbar.navbar-dark {
            --bs-dropdown-border-color: var(--bs-border-color);
            --bs-dropdown-box-shadow: 0 1rem 3rem rgba(14, 34, 56, .1)
        }

        .navbar.navbar-dark,
        [data-theme=dark] .navbar {
            --bs-navbar-active-bg: rgba(0, 186, 199, .12);
            --bs-navbar-collapse-icon: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12'%3E%3Cpath fill='none' stroke='%239EA9B4' stroke-linecap='round' stroke-linejoin='round' stroke-width='1' d='m11.625 3.655-5.36 5.36a.374.374 0 0 1-.53 0l-5.36-5.36'/%3E%3C/svg%3E");
            --bs-navbar-collapse-icon-hover: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12'%3E%3Cpath fill='none' stroke='%2300BAC7' stroke-linecap='round' stroke-linejoin='round' stroke-width='1' d='m11.625 3.655-5.36 5.36a.374.374 0 0 1-.53 0l-5.36-5.36'/%3E%3C/svg%3E");
            --bs-navbar-collapse-icon-active: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12'%3E%3Cpath fill='none' stroke='%2300BAC7' stroke-linecap='round' stroke-linejoin='round' stroke-width='1' d='m11.625 3.655-5.36 5.36a.374.374 0 0 1-.53 0l-5.36-5.36'/%3E%3C/svg%3E");
            --bs-navbar-vertical-border-color: #1f1f1f
        }

        [data-theme=dark] .navbar {
            --bs-dropdown-color: #f6f7f8;
            --bs-dropdown-bg: #323232;
            --bs-dropdown-border-color: var(--bs-border-color);
            --bs-dropdown-box-shadow: 0 1rem 3rem rgba(14, 34, 56, .1);
            --bs-dropdown-link-hover-bg: #3e3e3e;
            --bs-dropdown-link-active-bg: #3e3e3e
        }

        [data-theme=dark] .navbar.bg-dark {
            background-color: rgba(var(--bs-gray-400-rgb), var(--bs-bg-opacity)) !important
        }

        html:not([data-sidebar-behaviour=condensed]) .navbar.navbar-dark {
            --bs-navbar-active-color-sub: #fff;
            --bs-dropdown-color: #f6f7f8;
            --bs-dropdown-bg: #323232;
            --bs-dropdown-link-hover-bg: #3e3e3e;
            --bs-dropdown-link-active-bg: #3e3e3e
        }

        .offcanvas-header {
            border-bottom: var(--bs-border-width) solid var(--bs-border-color)
        }

        [data-theme=dark] .offcanvas-backdrop {
            background-color: #000;
            height: 100vh;
            left: 0;
            position: fixed;
            top: 0;
            width: 100vw;
            z-index: 1040
        }

        [data-theme=dark] .offcanvas-backdrop.fade {
            opacity: 0
        }

        [data-theme=dark] .offcanvas-backdrop.show {
            opacity: .4
        }

        .progress {
            box-shadow: none
        }

        .scroll-shadow:before {
            box-shadow: inset 0 .125rem .125rem 0 rgba(14, 34, 56, .07);
            position: -webkit-sticky;
            position: sticky;
            z-index: 0
        }

        .scroll-shadow:after,
        .scroll-shadow:before {
            content: "";
            display: block;
            height: .1875rem;
            top: 0
        }

        .scroll-shadow:after {
            background: var(--bs-white);
            position: absolute;
            width: 100%
        }

        .scrollbar {
            -webkit-overflow-scrolling: touch;
            -ms-overflow-style: -ms-autohiding-scrollbar;
            overscroll-behavior: contain;
            scrollbar-color: #989ea6 transparent;
            scrollbar-gutter: stable;
            scrollbar-width: thin
        }

        .scrollbar::-webkit-scrollbar {
            -webkit-appearance: none;
            background-color: transparent;
            height: .375rem;
            visibility: hidden;
            width: .375rem
        }

        .scrollbar::-webkit-scrollbar-thumb {
            background-color: hsla(214, 7%, 62%, .4);
            border-radius: 3px;
            visibility: hidden
        }

        .scrollbar::-webkit-scrollbar-thumb:active,
        .scrollbar::-webkit-scrollbar-thumb:hover {
            background-color: hsla(214, 7%, 62%, .7)
        }

        .scrollbar::-webkit-scrollbar-thumb:vertical {
            min-height: 1.5rem
        }

        .scrollbar::-webkit-scrollbar-thumb:horizontal {
            min-width: 1.5rem
        }

        .scrollbar:hover::-webkit-scrollbar,
        .scrollbar:hover::-webkit-scrollbar-thumb,
        .scrollbar:hover:focus::-webkit-scrollbar,
        .scrollbar:hover:focus::-webkit-scrollbar-thumb {
            visibility: visible
        }

        .scrollbar::-webkit-scrollbar-button,
        .scrollbar::-webkit-scrollbar-corner {
            display: none
        }

        .steps {
            justify-content: space-between;
            overflow-x: clip
        }

        .steps .nav-item {
            display: flex;
            height: 2.5rem;
            position: relative;
            width: 2.5rem
        }

        .steps .nav-item:before {
            left: 0;
            z-index: 1
        }

        .steps .nav-item:after,
        .steps .nav-item:before {
            background-color: var(--bs-gray-300);
            content: "";
            height: 3px;
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 10000px
        }

        .steps .nav-item:after {
            right: 0
        }

        .steps .nav-item .nav-text {
            position: absolute
        }

        .steps .nav-link {
            align-items: center;
            background-color: var(--bs-gray-300);
            border-radius: 50rem;
            color: var(--bs-body-color);
            display: flex;
            font-size: 1.125rem;
            font-weight: 700;
            height: 2.5rem;
            justify-content: center;
            width: 2.5rem;
            z-index: 1
        }

        .steps .nav-item.visited .nav-link {
            background-color: {{ $settings->website_theme }};
            color: var(--bs-nav-pills-link-active-color);
            padding: 0;
            text-indent: -999em
        }

        .steps .nav-item.visited .nav-link:after {
            background-color: var(--bs-nav-pills-link-active-color);
            content: "";
            height: 1rem;
            -webkit-mask: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="1rem" height="1rem" viewBox="0 0 24 24"><path d="M23.374.287a1.5 1.5 0 0 0-2.093.345L7.246 20.2l-4.685-4.689a1.5 1.5 0 1 0-2.122 2.121l5.935 5.934a1.525 1.525 0 0 0 2.279-.186l15.066-21a1.5 1.5 0 0 0-.345-2.093Z"/></svg>') no-repeat center;
            mask: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="1rem" height="1rem" viewBox="0 0 24 24"><path d="M23.374.287a1.5 1.5 0 0 0-2.093.345L7.246 20.2l-4.685-4.689a1.5 1.5 0 1 0-2.122 2.121l5.935 5.934a1.525 1.525 0 0 0 2.279-.186l15.066-21a1.5 1.5 0 0 0-.345-2.093Z"/></svg>') no-repeat center;
            -webkit-mask-size: cover;
            mask-size: cover;
            text-indent: 0;
            width: 1rem
        }

        .steps .nav-item.visited:before {
            background-color: {{ $settings->website_theme }};
            z-index: 1
        }

        .steps.steps-vertical {
            flex-direction: column;
            overflow-x: visible;
            overflow-y: clip
        }

        .steps.steps-vertical .nav-item:before {
            height: 10000px;
            left: 50%;
            top: 0;
            transform: translateX(-50%);
            width: 3px;
            z-index: 1
        }

        .steps.steps-vertical .nav-item:after {
            bottom: 0;
            height: 10000px;
            left: 50%;
            transform: translateX(-50%);
            width: 3px
        }

        .steps.steps-vertical .nav-item .nav-text {
            height: 100%;
            left: calc(100% + 1rem);
            position: absolute;
            width: -webkit-max-content;
            width: -moz-max-content;
            width: max-content
        }

        .table {
            --bs-table-border-color: var(--bs-border-color)
        }

        .table>thead th {
            border-bottom-width: 0;
            color: rgba(var(--bs-body-color-rgb), .3525);
            font-size: .75rem;
            padding: .5rem 1.25rem
        }

        .table.table-edge:not(.table-borderless)>:last-child>:last-child>* {
            border-bottom-color: transparent
        }

        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) td:first-child,
        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) td:last-child,
        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) th:first-child,
        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) th:last-child {
            border-bottom-color: transparent;
            position: relative
        }

        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) td:first-child:before,
        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) td:last-child:before,
        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) th:first-child:before,
        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) th:last-child:before {
            background-color: var(--bs-table-border-color);
            bottom: calc(var(--bs-border-width)*-1);
            content: "";
            height: var(--bs-border-width);
            position: absolute;
            right: 0;
            width: calc(100% - 1.25rem)
        }

        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) td:last-child:before,
        .table.table-edge:not(.table-borderless) tbody tr:not(:last-child) th:last-child:before {
            left: 0;
            right: auto
        }

        .table-sm>thead th {
            padding: .5rem 1.25rem
        }

        .table-fixed {
            table-layout: fixed
        }

        .table-nowrap td,
        .table-nowrap th {
            white-space: nowrap
        }

        [data-theme=dark] .table {
            --bs-table-hover-bg: rgba(0, 186, 199, .2)
        }

        .thead-light {
            background-color: rgba(var(--bs-gray-600-rgb), .1)
        }

        .tooltip-inner {
            box-shadow: 0 .1875rem .1875rem 0 rgba(14, 34, 56, .07)
        }

        [data-theme=dark] .tooltip {
            --bs-tooltip-color: #f6f7f8
        }

        .chart-container {
            height: 19.375rem;
            position: relative
        }

        .ds-chartjs-tooltip-wrap {
            position: absolute;
            transition: opacity .2s ease-in-out, left .2s ease, top .2s ease;
            z-index: 3
        }

        .ds-chartjs-tooltip-wrap .ds-chartjs-tooltip {
            background-color: var(--bs-dark);
            border-radius: .25rem;
            box-shadow: 0 .1875rem .1875rem 0 rgba(14, 34, 56, .07);
            font-size: .625rem;
            padding: .375rem .5rem;
            position: relative;
            transition: opacity .2s ease-in-out, left .2s ease, top .2s ease, top 0s
        }

        .ds-chartjs-tooltip-wrap .ds-chartjs-tooltip:before {
            background-color: var(--bs-dark);
            bottom: -.4375rem;
            content: "";
            height: .5rem;
            left: calc(50% - .5rem);
            -webkit-mask-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='1rem' height='0.5rem' viewBox='0 0 50 22.49'%3E%3Cpath fill='%23132144' d='M0 0h50L31.87 19.65c-3.45 3.73-9.33 3.79-12.85.13L0 0z'/%3E%3C/svg%3E");
            mask-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='1rem' height='0.5rem' viewBox='0 0 50 22.49'%3E%3Cpath fill='%23132144' d='M0 0h50L31.87 19.65c-3.45 3.73-9.33 3.79-12.85.13L0 0z'/%3E%3C/svg%3E");
            -webkit-mask-position: center center;
            mask-position: center center;
            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
            -webkit-mask-size: 1rem .5rem;
            mask-size: 1rem .5rem;
            position: absolute;
            width: 1rem
        }

        .ds-chartjs-tooltip-wrap .ds-chartjs-tooltip .ds-chartjs-tooltip-header {
            color: hsla(0, 0%, 100%, .7);
            font-weight: 600;
            white-space: nowrap
        }

        .ds-chartjs-tooltip-wrap .ds-chartjs-tooltip .ds-chartjs-tooltip-body {
            color: #fff
        }

        .chart-legend {
            align-items: center;
            color: #9ea9b4;
            display: flex;
            font-size: .75rem;
            font-weight: 600;
            margin: 0 .9375rem 0 0;
            padding: 0;
            text-transform: uppercase
        }

        .chart-legend.active,
        .chart-legend:focus,
        .chart-legend:hover {
            color: #7e8790
        }

        .fi,
        .fib {
            background-position: 50%;
            background-repeat: no-repeat;
            background-size: contain
        }

        .fi {
            display: inline-block;
            line-height: 1em;
            position: relative;
            width: 1.333333em
        }

        .fi:before {
            content: " "
        }

        .fi.fis {
            width: 1em
        }

        .fi-xx {
            background-image: url(../images/flags/4x3/xx.svg)
        }

        .fi-xx.fis {
            background-image: url(../images/flags/1x1/xx.svg)
        }

        .fi-ad {
            background-image: url(../images/flags/4x3/ad.svg)
        }

        .fi-ad.fis {
            background-image: url(../images/flags/1x1/ad.svg)
        }

        .fi-ae {
            background-image: url(../images/flags/4x3/ae.svg)
        }

        .fi-ae.fis {
            background-image: url(../images/flags/1x1/ae.svg)
        }

        .fi-af {
            background-image: url(../images/flags/4x3/af.svg)
        }

        .fi-af.fis {
            background-image: url(../images/flags/1x1/af.svg)
        }

        .fi-ag {
            background-image: url(../images/flags/4x3/ag.svg)
        }

        .fi-ag.fis {
            background-image: url(../images/flags/1x1/ag.svg)
        }

        .fi-ai {
            background-image: url(../images/flags/4x3/ai.svg)
        }

        .fi-ai.fis {
            background-image: url(../images/flags/1x1/ai.svg)
        }

        .fi-al {
            background-image: url(../images/flags/4x3/al.svg)
        }

        .fi-al.fis {
            background-image: url(../images/flags/1x1/al.svg)
        }

        .fi-am {
            background-image: url(../images/flags/4x3/am.svg)
        }

        .fi-am.fis {
            background-image: url(../images/flags/1x1/am.svg)
        }

        .fi-ao {
            background-image: url(../images/flags/4x3/ao.svg)
        }

        .fi-ao.fis {
            background-image: url(../images/flags/1x1/ao.svg)
        }

        .fi-aq {
            background-image: url(../images/flags/4x3/aq.svg)
        }

        .fi-aq.fis {
            background-image: url(../images/flags/1x1/aq.svg)
        }

        .fi-ar {
            background-image: url(../images/flags/4x3/ar.svg)
        }

        .fi-ar.fis {
            background-image: url(../images/flags/1x1/ar.svg)
        }

        .fi-as {
            background-image: url(../images/flags/4x3/as.svg)
        }

        .fi-as.fis {
            background-image: url(../images/flags/1x1/as.svg)
        }

        .fi-at {
            background-image: url(../images/flags/4x3/at.svg)
        }

        .fi-at.fis {
            background-image: url(../images/flags/1x1/at.svg)
        }

        .fi-au {
            background-image: url(../images/flags/4x3/au.svg)
        }

        .fi-au.fis {
            background-image: url(../images/flags/1x1/au.svg)
        }

        .fi-aw {
            background-image: url(../images/flags/4x3/aw.svg)
        }

        .fi-aw.fis {
            background-image: url(../images/flags/1x1/aw.svg)
        }

        .fi-ax {
            background-image: url(../images/flags/4x3/ax.svg)
        }

        .fi-ax.fis {
            background-image: url(../images/flags/1x1/ax.svg)
        }

        .fi-az {
            background-image: url(../images/flags/4x3/az.svg)
        }

        .fi-az.fis {
            background-image: url(../images/flags/1x1/az.svg)
        }

        .fi-ba {
            background-image: url(../images/flags/4x3/ba.svg)
        }

        .fi-ba.fis {
            background-image: url(../images/flags/1x1/ba.svg)
        }

        .fi-bb {
            background-image: url(../images/flags/4x3/bb.svg)
        }

        .fi-bb.fis {
            background-image: url(../images/flags/1x1/bb.svg)
        }

        .fi-bd {
            background-image: url(../images/flags/4x3/bd.svg)
        }

        .fi-bd.fis {
            background-image: url(../images/flags/1x1/bd.svg)
        }

        .fi-be {
            background-image: url(../images/flags/4x3/be.svg)
        }

        .fi-be.fis {
            background-image: url(../images/flags/1x1/be.svg)
        }

        .fi-bf {
            background-image: url(../images/flags/4x3/bf.svg)
        }

        .fi-bf.fis {
            background-image: url(../images/flags/1x1/bf.svg)
        }

        .fi-bg {
            background-image: url(../images/flags/4x3/bg.svg)
        }

        .fi-bg.fis {
            background-image: url(../images/flags/1x1/bg.svg)
        }

        .fi-bh {
            background-image: url(../images/flags/4x3/bh.svg)
        }

        .fi-bh.fis {
            background-image: url(../images/flags/1x1/bh.svg)
        }

        .fi-bi {
            background-image: url(../images/flags/4x3/bi.svg)
        }

        .fi-bi.fis {
            background-image: url(../images/flags/1x1/bi.svg)
        }

        .fi-bj {
            background-image: url(../images/flags/4x3/bj.svg)
        }

        .fi-bj.fis {
            background-image: url(../images/flags/1x1/bj.svg)
        }

        .fi-bl {
            background-image: url(../images/flags/4x3/bl.svg)
        }

        .fi-bl.fis {
            background-image: url(../images/flags/1x1/bl.svg)
        }

        .fi-bm {
            background-image: url(../images/flags/4x3/bm.svg)
        }

        .fi-bm.fis {
            background-image: url(../images/flags/1x1/bm.svg)
        }

        .fi-bn {
            background-image: url(../images/flags/4x3/bn.svg)
        }

        .fi-bn.fis {
            background-image: url(../images/flags/1x1/bn.svg)
        }

        .fi-bo {
            background-image: url(../images/flags/4x3/bo.svg)
        }

        .fi-bo.fis {
            background-image: url(../images/flags/1x1/bo.svg)
        }

        .fi-bq {
            background-image: url(../images/flags/4x3/bq.svg)
        }

        .fi-bq.fis {
            background-image: url(../images/flags/1x1/bq.svg)
        }

        .fi-br {
            background-image: url(../images/flags/4x3/br.svg)
        }

        .fi-br.fis {
            background-image: url(../images/flags/1x1/br.svg)
        }

        .fi-bs {
            background-image: url(../images/flags/4x3/bs.svg)
        }

        .fi-bs.fis {
            background-image: url(../images/flags/1x1/bs.svg)
        }

        .fi-bt {
            background-image: url(../images/flags/4x3/bt.svg)
        }

        .fi-bt.fis {
            background-image: url(../images/flags/1x1/bt.svg)
        }

        .fi-bv {
            background-image: url(../images/flags/4x3/bv.svg)
        }

        .fi-bv.fis {
            background-image: url(../images/flags/1x1/bv.svg)
        }

        .fi-bw {
            background-image: url(../images/flags/4x3/bw.svg)
        }

        .fi-bw.fis {
            background-image: url(../images/flags/1x1/bw.svg)
        }

        .fi-by {
            background-image: url(../images/flags/4x3/by.svg)
        }

        .fi-by.fis {
            background-image: url(../images/flags/1x1/by.svg)
        }

        .fi-bz {
            background-image: url(../images/flags/4x3/bz.svg)
        }

        .fi-bz.fis {
            background-image: url(../images/flags/1x1/bz.svg)
        }

        .fi-ca {
            background-image: url(../images/flags/4x3/ca.svg)
        }

        .fi-ca.fis {
            background-image: url(../images/flags/1x1/ca.svg)
        }

        .fi-cc {
            background-image: url(../images/flags/4x3/cc.svg)
        }

        .fi-cc.fis {
            background-image: url(../images/flags/1x1/cc.svg)
        }

        .fi-cd {
            background-image: url(../images/flags/4x3/cd.svg)
        }

        .fi-cd.fis {
            background-image: url(../images/flags/1x1/cd.svg)
        }

        .fi-cf {
            background-image: url(../images/flags/4x3/cf.svg)
        }

        .fi-cf.fis {
            background-image: url(../images/flags/1x1/cf.svg)
        }

        .fi-cg {
            background-image: url(../images/flags/4x3/cg.svg)
        }

        .fi-cg.fis {
            background-image: url(../images/flags/1x1/cg.svg)
        }

        .fi-ch {
            background-image: url(../images/flags/4x3/ch.svg)
        }

        .fi-ch.fis {
            background-image: url(../images/flags/1x1/ch.svg)
        }

        .fi-ci {
            background-image: url(../images/flags/4x3/ci.svg)
        }

        .fi-ci.fis {
            background-image: url(../images/flags/1x1/ci.svg)
        }

        .fi-ck {
            background-image: url(../images/flags/4x3/ck.svg)
        }

        .fi-ck.fis {
            background-image: url(../images/flags/1x1/ck.svg)
        }

        .fi-cl {
            background-image: url(../images/flags/4x3/cl.svg)
        }

        .fi-cl.fis {
            background-image: url(../images/flags/1x1/cl.svg)
        }

        .fi-cm {
            background-image: url(../images/flags/4x3/cm.svg)
        }

        .fi-cm.fis {
            background-image: url(../images/flags/1x1/cm.svg)
        }

        .fi-cn {
            background-image: url(../images/flags/4x3/cn.svg)
        }

        .fi-cn.fis {
            background-image: url(../images/flags/1x1/cn.svg)
        }

        .fi-co {
            background-image: url(../images/flags/4x3/co.svg)
        }

        .fi-co.fis {
            background-image: url(../images/flags/1x1/co.svg)
        }

        .fi-cr {
            background-image: url(../images/flags/4x3/cr.svg)
        }

        .fi-cr.fis {
            background-image: url(../images/flags/1x1/cr.svg)
        }

        .fi-cu {
            background-image: url(../images/flags/4x3/cu.svg)
        }

        .fi-cu.fis {
            background-image: url(../images/flags/1x1/cu.svg)
        }

        .fi-cv {
            background-image: url(../images/flags/4x3/cv.svg)
        }

        .fi-cv.fis {
            background-image: url(../images/flags/1x1/cv.svg)
        }

        .fi-cw {
            background-image: url(../images/flags/4x3/cw.svg)
        }

        .fi-cw.fis {
            background-image: url(../images/flags/1x1/cw.svg)
        }

        .fi-cx {
            background-image: url(../images/flags/4x3/cx.svg)
        }

        .fi-cx.fis {
            background-image: url(../images/flags/1x1/cx.svg)
        }

        .fi-cy {
            background-image: url(../images/flags/4x3/cy.svg)
        }

        .fi-cy.fis {
            background-image: url(../images/flags/1x1/cy.svg)
        }

        .fi-cz {
            background-image: url(../images/flags/4x3/cz.svg)
        }

        .fi-cz.fis {
            background-image: url(../images/flags/1x1/cz.svg)
        }

        .fi-de {
            background-image: url(../images/flags/4x3/de.svg)
        }

        .fi-de.fis {
            background-image: url(../images/flags/1x1/de.svg)
        }

        .fi-dj {
            background-image: url(../images/flags/4x3/dj.svg)
        }

        .fi-dj.fis {
            background-image: url(../images/flags/1x1/dj.svg)
        }

        .fi-dk {
            background-image: url(../images/flags/4x3/dk.svg)
        }

        .fi-dk.fis {
            background-image: url(../images/flags/1x1/dk.svg)
        }

        .fi-dm {
            background-image: url(../images/flags/4x3/dm.svg)
        }

        .fi-dm.fis {
            background-image: url(../images/flags/1x1/dm.svg)
        }

        .fi-do {
            background-image: url(../images/flags/4x3/do.svg)
        }

        .fi-do.fis {
            background-image: url(../images/flags/1x1/do.svg)
        }

        .fi-dz {
            background-image: url(../images/flags/4x3/dz.svg)
        }

        .fi-dz.fis {
            background-image: url(../images/flags/1x1/dz.svg)
        }

        .fi-ec {
            background-image: url(../images/flags/4x3/ec.svg)
        }

        .fi-ec.fis {
            background-image: url(../images/flags/1x1/ec.svg)
        }

        .fi-ee {
            background-image: url(../images/flags/4x3/ee.svg)
        }

        .fi-ee.fis {
            background-image: url(../images/flags/1x1/ee.svg)
        }

        .fi-eg {
            background-image: url(../images/flags/4x3/eg.svg)
        }

        .fi-eg.fis {
            background-image: url(../images/flags/1x1/eg.svg)
        }

        .fi-eh {
            background-image: url(../images/flags/4x3/eh.svg)
        }

        .fi-eh.fis {
            background-image: url(../images/flags/1x1/eh.svg)
        }

        .fi-er {
            background-image: url(../images/flags/4x3/er.svg)
        }

        .fi-er.fis {
            background-image: url(../images/flags/1x1/er.svg)
        }

        .fi-es {
            background-image: url(../images/flags/4x3/es.svg)
        }

        .fi-es.fis {
            background-image: url(../images/flags/1x1/es.svg)
        }

        .fi-et {
            background-image: url(../images/flags/4x3/et.svg)
        }

        .fi-et.fis {
            background-image: url(../images/flags/1x1/et.svg)
        }

        .fi-fi {
            background-image: url(../images/flags/4x3/fi.svg)
        }

        .fi-fi.fis {
            background-image: url(../images/flags/1x1/fi.svg)
        }

        .fi-fj {
            background-image: url(../images/flags/4x3/fj.svg)
        }

        .fi-fj.fis {
            background-image: url(../images/flags/1x1/fj.svg)
        }

        .fi-fk {
            background-image: url(../images/flags/4x3/fk.svg)
        }

        .fi-fk.fis {
            background-image: url(../images/flags/1x1/fk.svg)
        }

        .fi-fm {
            background-image: url(../images/flags/4x3/fm.svg)
        }

        .fi-fm.fis {
            background-image: url(../images/flags/1x1/fm.svg)
        }

        .fi-fo {
            background-image: url(../images/flags/4x3/fo.svg)
        }

        .fi-fo.fis {
            background-image: url(../images/flags/1x1/fo.svg)
        }

        .fi-fr {
            background-image: url(../images/flags/4x3/fr.svg)
        }

        .fi-fr.fis {
            background-image: url(../images/flags/1x1/fr.svg)
        }

        .fi-ga {
            background-image: url(../images/flags/4x3/ga.svg)
        }

        .fi-ga.fis {
            background-image: url(../images/flags/1x1/ga.svg)
        }

        .fi-gb {
            background-image: url(../images/flags/4x3/gb.svg)
        }

        .fi-gb.fis {
            background-image: url(../images/flags/1x1/gb.svg)
        }

        .fi-gd {
            background-image: url(../images/flags/4x3/gd.svg)
        }

        .fi-gd.fis {
            background-image: url(../images/flags/1x1/gd.svg)
        }

        .fi-ge {
            background-image: url(../images/flags/4x3/ge.svg)
        }

        .fi-ge.fis {
            background-image: url(../images/flags/1x1/ge.svg)
        }

        .fi-gf {
            background-image: url(../images/flags/4x3/gf.svg)
        }

        .fi-gf.fis {
            background-image: url(../images/flags/1x1/gf.svg)
        }

        .fi-gg {
            background-image: url(../images/flags/4x3/gg.svg)
        }

        .fi-gg.fis {
            background-image: url(../images/flags/1x1/gg.svg)
        }

        .fi-gh {
            background-image: url(../images/flags/4x3/gh.svg)
        }

        .fi-gh.fis {
            background-image: url(../images/flags/1x1/gh.svg)
        }

        .fi-gi {
            background-image: url(../images/flags/4x3/gi.svg)
        }

        .fi-gi.fis {
            background-image: url(../images/flags/1x1/gi.svg)
        }

        .fi-gl {
            background-image: url(../images/flags/4x3/gl.svg)
        }

        .fi-gl.fis {
            background-image: url(../images/flags/1x1/gl.svg)
        }

        .fi-gm {
            background-image: url(../images/flags/4x3/gm.svg)
        }

        .fi-gm.fis {
            background-image: url(../images/flags/1x1/gm.svg)
        }

        .fi-gn {
            background-image: url(../images/flags/4x3/gn.svg)
        }

        .fi-gn.fis {
            background-image: url(../images/flags/1x1/gn.svg)
        }

        .fi-gp {
            background-image: url(../images/flags/4x3/gp.svg)
        }

        .fi-gp.fis {
            background-image: url(../images/flags/1x1/gp.svg)
        }

        .fi-gq {
            background-image: url(../images/flags/4x3/gq.svg)
        }

        .fi-gq.fis {
            background-image: url(../images/flags/1x1/gq.svg)
        }

        .fi-gr {
            background-image: url(../images/flags/4x3/gr.svg)
        }

        .fi-gr.fis {
            background-image: url(../images/flags/1x1/gr.svg)
        }

        .fi-gs {
            background-image: url(../images/flags/4x3/gs.svg)
        }

        .fi-gs.fis {
            background-image: url(../images/flags/1x1/gs.svg)
        }

        .fi-gt {
            background-image: url(../images/flags/4x3/gt.svg)
        }

        .fi-gt.fis {
            background-image: url(../images/flags/1x1/gt.svg)
        }

        .fi-gu {
            background-image: url(../images/flags/4x3/gu.svg)
        }

        .fi-gu.fis {
            background-image: url(../images/flags/1x1/gu.svg)
        }

        .fi-gw {
            background-image: url(../images/flags/4x3/gw.svg)
        }

        .fi-gw.fis {
            background-image: url(../images/flags/1x1/gw.svg)
        }

        .fi-gy {
            background-image: url(../images/flags/4x3/gy.svg)
        }

        .fi-gy.fis {
            background-image: url(../images/flags/1x1/gy.svg)
        }

        .fi-hk {
            background-image: url(../images/flags/4x3/hk.svg)
        }

        .fi-hk.fis {
            background-image: url(../images/flags/1x1/hk.svg)
        }

        .fi-hm {
            background-image: url(../images/flags/4x3/hm.svg)
        }

        .fi-hm.fis {
            background-image: url(../images/flags/1x1/hm.svg)
        }

        .fi-hn {
            background-image: url(../images/flags/4x3/hn.svg)
        }

        .fi-hn.fis {
            background-image: url(../images/flags/1x1/hn.svg)
        }

        .fi-hr {
            background-image: url(../images/flags/4x3/hr.svg)
        }

        .fi-hr.fis {
            background-image: url(../images/flags/1x1/hr.svg)
        }

        .fi-ht {
            background-image: url(../images/flags/4x3/ht.svg)
        }

        .fi-ht.fis {
            background-image: url(../images/flags/1x1/ht.svg)
        }

        .fi-hu {
            background-image: url(../images/flags/4x3/hu.svg)
        }

        .fi-hu.fis {
            background-image: url(../images/flags/1x1/hu.svg)
        }

        .fi-id {
            background-image: url(../images/flags/4x3/id.svg)
        }

        .fi-id.fis {
            background-image: url(../images/flags/1x1/id.svg)
        }

        .fi-ie {
            background-image: url(../images/flags/4x3/ie.svg)
        }

        .fi-ie.fis {
            background-image: url(../images/flags/1x1/ie.svg)
        }

        .fi-il {
            background-image: url(../images/flags/4x3/il.svg)
        }

        .fi-il.fis {
            background-image: url(../images/flags/1x1/il.svg)
        }

        .fi-im {
            background-image: url(../images/flags/4x3/im.svg)
        }

        .fi-im.fis {
            background-image: url(../images/flags/1x1/im.svg)
        }

        .fi-in {
            background-image: url(../images/flags/4x3/in.svg)
        }

        .fi-in.fis {
            background-image: url(../images/flags/1x1/in.svg)
        }

        .fi-io {
            background-image: url(../images/flags/4x3/io.svg)
        }

        .fi-io.fis {
            background-image: url(../images/flags/1x1/io.svg)
        }

        .fi-iq {
            background-image: url(../images/flags/4x3/iq.svg)
        }

        .fi-iq.fis {
            background-image: url(../images/flags/1x1/iq.svg)
        }

        .fi-ir {
            background-image: url(../images/flags/4x3/ir.svg)
        }

        .fi-ir.fis {
            background-image: url(../images/flags/1x1/ir.svg)
        }

        .fi-is {
            background-image: url(../images/flags/4x3/is.svg)
        }

        .fi-is.fis {
            background-image: url(../images/flags/1x1/is.svg)
        }

        .fi-it {
            background-image: url(../images/flags/4x3/it.svg)
        }

        .fi-it.fis {
            background-image: url(../images/flags/1x1/it.svg)
        }

        .fi-je {
            background-image: url(../images/flags/4x3/je.svg)
        }

        .fi-je.fis {
            background-image: url(../images/flags/1x1/je.svg)
        }

        .fi-jm {
            background-image: url(../images/flags/4x3/jm.svg)
        }

        .fi-jm.fis {
            background-image: url(../images/flags/1x1/jm.svg)
        }

        .fi-jo {
            background-image: url(../images/flags/4x3/jo.svg)
        }

        .fi-jo.fis {
            background-image: url(../images/flags/1x1/jo.svg)
        }

        .fi-jp {
            background-image: url(../images/flags/4x3/jp.svg)
        }

        .fi-jp.fis {
            background-image: url(../images/flags/1x1/jp.svg)
        }

        .fi-ke {
            background-image: url(../images/flags/4x3/ke.svg)
        }

        .fi-ke.fis {
            background-image: url(../images/flags/1x1/ke.svg)
        }

        .fi-kg {
            background-image: url(../images/flags/4x3/kg.svg)
        }

        .fi-kg.fis {
            background-image: url(../images/flags/1x1/kg.svg)
        }

        .fi-kh {
            background-image: url(../images/flags/4x3/kh.svg)
        }

        .fi-kh.fis {
            background-image: url(../images/flags/1x1/kh.svg)
        }

        .fi-ki {
            background-image: url(../images/flags/4x3/ki.svg)
        }

        .fi-ki.fis {
            background-image: url(../images/flags/1x1/ki.svg)
        }

        .fi-km {
            background-image: url(../images/flags/4x3/km.svg)
        }

        .fi-km.fis {
            background-image: url(../images/flags/1x1/km.svg)
        }

        .fi-kn {
            background-image: url(../images/flags/4x3/kn.svg)
        }

        .fi-kn.fis {
            background-image: url(../images/flags/1x1/kn.svg)
        }

        .fi-kp {
            background-image: url(../images/flags/4x3/kp.svg)
        }

        .fi-kp.fis {
            background-image: url(../images/flags/1x1/kp.svg)
        }

        .fi-kr {
            background-image: url(../images/flags/4x3/kr.svg)
        }

        .fi-kr.fis {
            background-image: url(../images/flags/1x1/kr.svg)
        }

        .fi-kw {
            background-image: url(../images/flags/4x3/kw.svg)
        }

        .fi-kw.fis {
            background-image: url(../images/flags/1x1/kw.svg)
        }

        .fi-ky {
            background-image: url(../images/flags/4x3/ky.svg)
        }

        .fi-ky.fis {
            background-image: url(../images/flags/1x1/ky.svg)
        }

        .fi-kz {
            background-image: url(../images/flags/4x3/kz.svg)
        }

        .fi-kz.fis {
            background-image: url(../images/flags/1x1/kz.svg)
        }

        .fi-la {
            background-image: url(../images/flags/4x3/la.svg)
        }

        .fi-la.fis {
            background-image: url(../images/flags/1x1/la.svg)
        }

        .fi-lb {
            background-image: url(../images/flags/4x3/lb.svg)
        }

        .fi-lb.fis {
            background-image: url(../images/flags/1x1/lb.svg)
        }

        .fi-lc {
            background-image: url(../images/flags/4x3/lc.svg)
        }

        .fi-lc.fis {
            background-image: url(../images/flags/1x1/lc.svg)
        }

        .fi-li {
            background-image: url(../images/flags/4x3/li.svg)
        }

        .fi-li.fis {
            background-image: url(../images/flags/1x1/li.svg)
        }

        .fi-lk {
            background-image: url(../images/flags/4x3/lk.svg)
        }

        .fi-lk.fis {
            background-image: url(../images/flags/1x1/lk.svg)
        }

        .fi-lr {
            background-image: url(../images/flags/4x3/lr.svg)
        }

        .fi-lr.fis {
            background-image: url(../images/flags/1x1/lr.svg)
        }

        .fi-ls {
            background-image: url(../images/flags/4x3/ls.svg)
        }

        .fi-ls.fis {
            background-image: url(../images/flags/1x1/ls.svg)
        }

        .fi-lt {
            background-image: url(../images/flags/4x3/lt.svg)
        }

        .fi-lt.fis {
            background-image: url(../images/flags/1x1/lt.svg)
        }

        .fi-lu {
            background-image: url(../images/flags/4x3/lu.svg)
        }

        .fi-lu.fis {
            background-image: url(../images/flags/1x1/lu.svg)
        }

        .fi-lv {
            background-image: url(../images/flags/4x3/lv.svg)
        }

        .fi-lv.fis {
            background-image: url(../images/flags/1x1/lv.svg)
        }

        .fi-ly {
            background-image: url(../images/flags/4x3/ly.svg)
        }

        .fi-ly.fis {
            background-image: url(../images/flags/1x1/ly.svg)
        }

        .fi-ma {
            background-image: url(../images/flags/4x3/ma.svg)
        }

        .fi-ma.fis {
            background-image: url(../images/flags/1x1/ma.svg)
        }

        .fi-mc {
            background-image: url(../images/flags/4x3/mc.svg)
        }

        .fi-mc.fis {
            background-image: url(../images/flags/1x1/mc.svg)
        }

        .fi-md {
            background-image: url(../images/flags/4x3/md.svg)
        }

        .fi-md.fis {
            background-image: url(../images/flags/1x1/md.svg)
        }

        .fi-me {
            background-image: url(../images/flags/4x3/me.svg)
        }

        .fi-me.fis {
            background-image: url(../images/flags/1x1/me.svg)
        }

        .fi-mf {
            background-image: url(../images/flags/4x3/mf.svg)
        }

        .fi-mf.fis {
            background-image: url(../images/flags/1x1/mf.svg)
        }

        .fi-mg {
            background-image: url(../images/flags/4x3/mg.svg)
        }

        .fi-mg.fis {
            background-image: url(../images/flags/1x1/mg.svg)
        }

        .fi-mh {
            background-image: url(../images/flags/4x3/mh.svg)
        }

        .fi-mh.fis {
            background-image: url(../images/flags/1x1/mh.svg)
        }

        .fi-mk {
            background-image: url(../images/flags/4x3/mk.svg)
        }

        .fi-mk.fis {
            background-image: url(../images/flags/1x1/mk.svg)
        }

        .fi-ml {
            background-image: url(../images/flags/4x3/ml.svg)
        }

        .fi-ml.fis {
            background-image: url(../images/flags/1x1/ml.svg)
        }

        .fi-mm {
            background-image: url(../images/flags/4x3/mm.svg)
        }

        .fi-mm.fis {
            background-image: url(../images/flags/1x1/mm.svg)
        }

        .fi-mn {
            background-image: url(../images/flags/4x3/mn.svg)
        }

        .fi-mn.fis {
            background-image: url(../images/flags/1x1/mn.svg)
        }

        .fi-mo {
            background-image: url(../images/flags/4x3/mo.svg)
        }

        .fi-mo.fis {
            background-image: url(../images/flags/1x1/mo.svg)
        }

        .fi-mp {
            background-image: url(../images/flags/4x3/mp.svg)
        }

        .fi-mp.fis {
            background-image: url(../images/flags/1x1/mp.svg)
        }

        .fi-mq {
            background-image: url(../images/flags/4x3/mq.svg)
        }

        .fi-mq.fis {
            background-image: url(../images/flags/1x1/mq.svg)
        }

        .fi-mr {
            background-image: url(../images/flags/4x3/mr.svg)
        }

        .fi-mr.fis {
            background-image: url(../images/flags/1x1/mr.svg)
        }

        .fi-ms {
            background-image: url(../images/flags/4x3/ms.svg)
        }

        .fi-ms.fis {
            background-image: url(../images/flags/1x1/ms.svg)
        }

        .fi-mt {
            background-image: url(../images/flags/4x3/mt.svg)
        }

        .fi-mt.fis {
            background-image: url(../images/flags/1x1/mt.svg)
        }

        .fi-mu {
            background-image: url(../images/flags/4x3/mu.svg)
        }

        .fi-mu.fis {
            background-image: url(../images/flags/1x1/mu.svg)
        }

        .fi-mv {
            background-image: url(../images/flags/4x3/mv.svg)
        }

        .fi-mv.fis {
            background-image: url(../images/flags/1x1/mv.svg)
        }

        .fi-mw {
            background-image: url(../images/flags/4x3/mw.svg)
        }

        .fi-mw.fis {
            background-image: url(../images/flags/1x1/mw.svg)
        }

        .fi-mx {
            background-image: url(../images/flags/4x3/mx.svg)
        }

        .fi-mx.fis {
            background-image: url(../images/flags/1x1/mx.svg)
        }

        .fi-my {
            background-image: url(../images/flags/4x3/my.svg)
        }

        .fi-my.fis {
            background-image: url(../images/flags/1x1/my.svg)
        }

        .fi-mz {
            background-image: url(../images/flags/4x3/mz.svg)
        }

        .fi-mz.fis {
            background-image: url(../images/flags/1x1/mz.svg)
        }

        .fi-na {
            background-image: url(../images/flags/4x3/na.svg)
        }

        .fi-na.fis {
            background-image: url(../images/flags/1x1/na.svg)
        }

        .fi-nc {
            background-image: url(../images/flags/4x3/nc.svg)
        }

        .fi-nc.fis {
            background-image: url(../images/flags/1x1/nc.svg)
        }

        .fi-ne {
            background-image: url(../images/flags/4x3/ne.svg)
        }

        .fi-ne.fis {
            background-image: url(../images/flags/1x1/ne.svg)
        }

        .fi-nf {
            background-image: url(../images/flags/4x3/nf.svg)
        }

        .fi-nf.fis {
            background-image: url(../images/flags/1x1/nf.svg)
        }

        .fi-ng {
            background-image: url(../images/flags/4x3/ng.svg)
        }

        .fi-ng.fis {
            background-image: url(../images/flags/1x1/ng.svg)
        }

        .fi-ni {
            background-image: url(../images/flags/4x3/ni.svg)
        }

        .fi-ni.fis {
            background-image: url(../images/flags/1x1/ni.svg)
        }

        .fi-nl {
            background-image: url(../images/flags/4x3/nl.svg)
        }

        .fi-nl.fis {
            background-image: url(../images/flags/1x1/nl.svg)
        }

        .fi-no {
            background-image: url(../images/flags/4x3/no.svg)
        }

        .fi-no.fis {
            background-image: url(../images/flags/1x1/no.svg)
        }

        .fi-np {
            background-image: url(../images/flags/4x3/np.svg)
        }

        .fi-np.fis {
            background-image: url(../images/flags/1x1/np.svg)
        }

        .fi-nr {
            background-image: url(../images/flags/4x3/nr.svg)
        }

        .fi-nr.fis {
            background-image: url(../images/flags/1x1/nr.svg)
        }

        .fi-nu {
            background-image: url(../images/flags/4x3/nu.svg)
        }

        .fi-nu.fis {
            background-image: url(../images/flags/1x1/nu.svg)
        }

        .fi-nz {
            background-image: url(../images/flags/4x3/nz.svg)
        }

        .fi-nz.fis {
            background-image: url(../images/flags/1x1/nz.svg)
        }

        .fi-om {
            background-image: url(../images/flags/4x3/om.svg)
        }

        .fi-om.fis {
            background-image: url(../images/flags/1x1/om.svg)
        }

        .fi-pa {
            background-image: url(../images/flags/4x3/pa.svg)
        }

        .fi-pa.fis {
            background-image: url(../images/flags/1x1/pa.svg)
        }

        .fi-pe {
            background-image: url(../images/flags/4x3/pe.svg)
        }

        .fi-pe.fis {
            background-image: url(../images/flags/1x1/pe.svg)
        }

        .fi-pf {
            background-image: url(../images/flags/4x3/pf.svg)
        }

        .fi-pf.fis {
            background-image: url(../images/flags/1x1/pf.svg)
        }

        .fi-pg {
            background-image: url(../images/flags/4x3/pg.svg)
        }

        .fi-pg.fis {
            background-image: url(../images/flags/1x1/pg.svg)
        }

        .fi-ph {
            background-image: url(../images/flags/4x3/ph.svg)
        }

        .fi-ph.fis {
            background-image: url(../images/flags/1x1/ph.svg)
        }

        .fi-pk {
            background-image: url(../images/flags/4x3/pk.svg)
        }

        .fi-pk.fis {
            background-image: url(../images/flags/1x1/pk.svg)
        }

        .fi-pl {
            background-image: url(../images/flags/4x3/pl.svg)
        }

        .fi-pl.fis {
            background-image: url(../images/flags/1x1/pl.svg)
        }

        .fi-pm {
            background-image: url(../images/flags/4x3/pm.svg)
        }

        .fi-pm.fis {
            background-image: url(../images/flags/1x1/pm.svg)
        }

        .fi-pn {
            background-image: url(../images/flags/4x3/pn.svg)
        }

        .fi-pn.fis {
            background-image: url(../images/flags/1x1/pn.svg)
        }

        .fi-pr {
            background-image: url(../images/flags/4x3/pr.svg)
        }

        .fi-pr.fis {
            background-image: url(../images/flags/1x1/pr.svg)
        }

        .fi-ps {
            background-image: url(../images/flags/4x3/ps.svg)
        }

        .fi-ps.fis {
            background-image: url(../images/flags/1x1/ps.svg)
        }

        .fi-pt {
            background-image: url(../images/flags/4x3/pt.svg)
        }

        .fi-pt.fis {
            background-image: url(../images/flags/1x1/pt.svg)
        }

        .fi-pw {
            background-image: url(../images/flags/4x3/pw.svg)
        }

        .fi-pw.fis {
            background-image: url(../images/flags/1x1/pw.svg)
        }

        .fi-py {
            background-image: url(../images/flags/4x3/py.svg)
        }

        .fi-py.fis {
            background-image: url(../images/flags/1x1/py.svg)
        }

        .fi-qa {
            background-image: url(../images/flags/4x3/qa.svg)
        }

        .fi-qa.fis {
            background-image: url(../images/flags/1x1/qa.svg)
        }

        .fi-re {
            background-image: url(../images/flags/4x3/re.svg)
        }

        .fi-re.fis {
            background-image: url(../images/flags/1x1/re.svg)
        }

        .fi-ro {
            background-image: url(../images/flags/4x3/ro.svg)
        }

        .fi-ro.fis {
            background-image: url(../images/flags/1x1/ro.svg)
        }

        .fi-rs {
            background-image: url(../images/flags/4x3/rs.svg)
        }

        .fi-rs.fis {
            background-image: url(../images/flags/1x1/rs.svg)
        }

        .fi-ru {
            background-image: url(../images/flags/4x3/ru.svg)
        }

        .fi-ru.fis {
            background-image: url(../images