<header class="w-full flex items-center justify-between p-4 bg-theme-secondary border-b border-gray-800/50">
    {{-- Logo Section --}}
    <div class="flex items-center gap-4">
        <img src="{{ asset($settings->logo) }}" alt="{{ $settings->site_name }}" class="h-8">
    </div>

    {{-- Actions Section --}}
    <div class="flex items-center gap-2">
        {{-- Language Selector --}}
<div class="relative" id="languageDropdown">
    <button class="flex items-center gap-2 bg-theme-tertiary rounded-xl px-3 py-2 text-sm text-gray-400 hover:text-gray-300 transition-colors">
        @php
            $currentLocale = app()->getLocale();
            $flags = [
                'en' => '&#x1F1FA;&#x1F1F8;', 
                'es' => '&#x1F1EA;&#x1F1F8;', 
                'fr' => '&#x1F1EB;&#x1F1F7;', 
                'de' => '&#x1F1E9;&#x1F1EA;', 
                'ar' => '&#x1F1F8;&#x1F1E6;', 
                'pt' => '&#x1F1F5;&#x1F1F9;', 
                'fa' => '&#x1F1EE;&#x1F1F7;', 
                'zh' => '&#x1F1E8;&#x1F1F3;',
                'hi' => '&#x1F1EE;&#x1F1F3;',
                'ru' => '&#x1F1F7;&#x1F1FA;' 
            ];
        @endphp
        <span class="mr-1">{!! $flags[$currentLocale] ?? $flags['en'] !!}</span>
        {{ strtoupper($currentLocale) }}
        <i class="fas fa-chevron-down w-4 h-4"></i>
    </button>
    <div id="languageMenu" 
        class="absolute right-0 mt-2 w-48 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
        @foreach(config('app.available_locales') as $locale => $name)
            <a href="{{ route('language.switch', $locale) }}" 
                class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:bg-theme-quaternary hover:text-gray-300 transition-colors">
                <span>{!! $flags[$locale] ?? $flags['en'] !!}</span>
                {{ $name }}
            </a>
        @endforeach
    </div>
</div>

        {{-- Annual Reports --}}
        <div class="relative" id="reportsDropdown">
            <button class="p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-theme-tertiary">
                <i class="fas fa-file-alt w-5 h-5"></i>
            </button>
            <div id="reportsMenu" 
                class="absolute right-0 mt-2 w-64 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4">
                    <h3 class="text-sm font-medium text-gray-300 mb-2">{{ __('t.annual_r') }}</h3>
                    <div class="space-y-1">
                        @forelse(\App\Models\AnnualReport::where('is_active', true)->orderBy('report_year', 'desc')->get() as $report)
                            <a href="{{ Storage::url($report->file_path) }}" 
                                target="_blank"
                                class="flex items-center gap-3 px-3 py-2 text-sm text-gray-400 hover:text-gray-300 hover:bg-theme-quaternary rounded-lg transition-colors">
                                <i class="fas fa-download w-4 h-4"></i>
                                {{ $report->name }}
                            </a>
                        @empty
                            <p class="text-sm text-gray-400 px-3 py-2">{{ __('t.no_reports') }}</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        {{-- Notifications --}}
        <div class="relative" id="notificationDropdown">
            <button class="relative p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-theme-tertiary">
                <i class="fas fa-bell w-5 h-5"></i>
                <livewire:user.notifications-count />
            </button>
            <div id="notificationMenu" 
                class="absolute right-0 mt-2 w-80 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4">
                    <div class="space-y-4">
                        @forelse(auth()->user()->notifications()->latest()->take(3)->get() as $notification)
                            <div class="flex items-start gap-3 pb-4 border-b border-gray-800/50 last:border-0 last:pb-0">
                                {{-- Notification Icon --}}
                                <div class="w-8 h-8 flex-shrink-0 bg-theme-primary/10 rounded-xl flex items-center justify-center">
                                    @switch($notification->data['type'] ?? 'default')
                                        @case('deposit')
                                            <i class="fas fa-arrow-down text-theme-primary w-4 h-4"></i>
                                            @break
                                        @case('withdrawal')
                                            <i class="fas fa-arrow-up text-theme-primary w-4 h-4"></i>
                                            @break
                                        @case('investment')
                                            <i class="fas fa-chart-line text-theme-primary w-4 h-4"></i>
                                            @break
                                        @case('roi')
                                            <i class="fas fa-piggy-bank text-theme-primary w-4 h-4"></i>
                                            @break
                                        @default
                                            <i class="fas fa-bell text-theme-primary w-4 h-4"></i>
                                    @endswitch
                                </div>
                                
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm text-gray-300">{{ $notification->data['message'] }}</p>
                                    <span class="text-xs text-gray-500">{{ $notification->created_at->diffForHumans() }}</span>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-6">
                                <div class="w-12 h-12 mx-auto mb-3 bg-gray-800/50 rounded-xl flex items-center justify-center">
                                    <i class="fas fa-bell-slash text-gray-400 w-6 h-6"></i>
                                </div>
                                <p class="text-sm text-gray-400">{{ __('t.no_notify') }}</p>
                            </div>
                        @endforelse
                    </div>

                    {{-- View All Link --}}
                    @if(auth()->user()->notifications()->count() > 0)
                        <div class="mt-4 pt-4 border-t border-gray-800/50">
                            <a href="{{ route('user.notifications') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                class="block w-full bg-theme-tertiary text-theme-primary text-center text-sm font-medium px-4 py-2.5 rounded-xl hover:bg-theme-quaternary transition-colors">
                                {{ __('t.view_notify') }}
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- User Profile --}}
        <div class="relative" id="userDropdown">
            <button class="p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-theme-tertiary">
                <i class="fas fa-user w-5 h-5"></i>
            </button>
            <div id="userMenu" 
                class="absolute right-0 mt-2 w-64 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4 border-b border-gray-800/50">
                    <h3 class="font-medium truncate">{{ auth()->user()->name }}</h3>
                    <p class="text-sm text-gray-400 truncate">{{ auth()->user()->email }}</p>
                </div>
                
                {{-- Account Status Section --}}
                @if($settings->enable_kyc)
                <div class="p-4 border-b border-gray-800/50 bg-theme-quaternary/50">
                    <div class="flex items-center justify-between gap-2">
                        <span class="text-sm text-gray-400">{{ __('t.acc_status') }}</span>
                        @if(Auth::user()->account_verify == 'verified')
                            <span class="text-xs font-medium px-2 py-1 bg-theme-primary/10 text-theme-primary rounded-lg">{{ __('t.verify') }}</span>
                        @else
                            <a href="{{ route('user.kyc.start') }}"
                                @if($settings->spa_mode) wire:navigate @endif 
                                class="text-xs font-medium px-2 py-1 bg-theme-primary/10 text-theme-primary rounded-lg hover:bg-theme-primary/20 transition-colors">
                                {{ __('t.verify_now') }}
                            </a>
                        @endif
                    </div>
                </div>
                @endif

                <div class="p-2">
                    <a href="{{ route('user.profile.show') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:text-gray-300 rounded-lg hover:bg-theme-quaternary transition-colors">
                        <i class="fas fa-cog w-4 h-4"></i>
                        {{ __('t.set') }}
                    </a>
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button type="submit" 
                            class="w-full flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:text-gray-300 rounded-lg hover:bg-theme-quaternary transition-colors">
                            <i class="fas fa-sign-out-alt w-4 h-4"></i>
                            {{ __('t.logout') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
    // Dropdown toggles
    function setupDropdown(triggerId, menuId) {
        const trigger = document.getElementById(triggerId);
        const menu = document.getElementById(menuId);
        
        if (trigger && menu) {
            trigger.addEventListener('click', (e) => {
                e.stopPropagation();
                menu.classList.toggle('hidden');
            });

            document.addEventListener('click', () => {
                menu.classList.add('hidden');
            });
        }
    }

    // Setup all dropdowns
    document.addEventListener('DOMContentLoaded', function() {
        setupDropdown('reportsDropdown', 'reportsMenu');
    });
    
</script>





