 <div class="space-y-4">
<label class="block text-sm text-gray-400">{{ __('t.select_payment') }}</label>
<div class="grid gap-4 sm:grid-cols-2">
    @forelse($methods as $method)
        <button type="button" 
            wire:click="methodSelected('{{ $method->name }}')"
            class="group relative"
            wire:key="method-{{ $method->id }}"
        >
            <div class="bg-theme-tertiary rounded-xl border-2 transition-all duration-300 overflow-hidden"
                :class="{ 
                    'border-theme-primary shadow-lg shadow-[#2563EB]/10 scale-[1.02]': @js($selectedMethod) === '{{ $method->name }}',
                    'border-transparent group-hover:border-theme-primary/30 group-hover:scale-[1.01]': @js($selectedMethod) !== '{{ $method->name }}'
                }"
            >
                {{-- Top Section with Icon and Name --}}
                <div class="p-5 relative">
                    <div class="flex items-center gap-4">
                        {{-- Icon Container with Glow Effect --}}
                        <div class="relative">
                            <div class="absolute inset-0 bg-theme-primary/20 blur-xl rounded-full transition-opacity"
                                :class="{ 
                                    'opacity-100': @js($selectedMethod) === '{{ $method->name }}',
                                    'opacity-0 group-hover:opacity-50': @js($selectedMethod) !== '{{ $method->name }}'
                                }"></div>
                            <div class="w-12 h-12 flex items-center justify-center bg-gray-800/50 rounded-xl relative">
                                @if(!empty($method->img_url))
                                    <img src="{{ $method->img_url }}" alt="" class="w-8 h-8">
                                @endif
                            </div>
                        </div>
                        
                        {{-- Method Name and Processing Info --}}
                        <div class="flex-1 text-left">
                            <p class="font-medium text-lg">{{ $method->name }}</p>
                            <div class="flex items-center gap-2 text-sm text-gray-400">
                                <i data-lucide="zap" class="w-4 h-4"></i>
                                {{ __('t.instant_processing') }}
                            </div>
                        </div>

                        {{-- Selection Indicator with Animation --}}
                        <div class="w-6 h-6 rounded-full border-2 transition-all duration-300 flex items-center justify-center"
                            :class="{ 
                                'border-theme-primary bg-theme-primary/10 rotate-180': @js($selectedMethod) === '{{ $method->name }}',
                                'border-gray-700': @js($selectedMethod) !== '{{ $method->name }}'
                            }">
                            <div class="w-3 h-3 rounded-full transition-transform duration-300"
                                :class="{ 
                                    'bg-theme-primary scale-100': @js($selectedMethod) === '{{ $method->name }}',
                                    'scale-0': @js($selectedMethod) !== '{{ $method->name }}'
                                }">
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Bottom Section with Exchange Rate --}}
                <div class="border-t border-gray-800/50 p-4 bg-gradient-to-r"
                    :class="{ 
                        'from-theme-primary/5 to-transparent': @js($selectedMethod) === '{{ $method->name }}',
                        'from-gray-800/20 to-transparent': @js($selectedMethod) !== '{{ $method->name }}'
                    }">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <i data-lucide="repeat" class="w-4 h-4 text-gray-400"></i>
                            <span class="text-sm text-gray-400">1 USD ≈</span>
                        </div>
                        <div class="text-right">
                            @if($loading)
                                <div class="flex items-center gap-2">
                                    <i data-lucide="loader" class="w-4 h-4 animate-spin text-gray-400"></i>
                                    <span class="text-sm text-gray-400">{{ __('t.loading_rates') }}</span>
                                </div>
                            @elseif($error)
                                <span class="text-sm text-red-400">{{ __('t.error_loading_rate') }}</span>
                            @else
                                <span class="font-mono text-sm"
                                    :class="{ 
                                        'text-theme-primary': @js($selectedMethod) === '{{ $method->name }}',
                                        'text-gray-400': @js($selectedMethod) !== '{{ $method->name }}'
                                    }">
                                    {{ number_format($cryptoRates[$method->name] ?? 0, 8) }} {{ $method->name }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- Animated Border Gradient --}}
                <div class="absolute inset-0 bg-gradient-to-r from-theme-primary/50 via-transparent to-theme-primary/50 opacity-0 transition-opacity duration-300"
                    :class="{ 
                        'opacity-10': @js($selectedMethod) === '{{ $method->name }}',
                        'group-hover:opacity-5': @js($selectedMethod) !== '{{ $method->name }}'
                    }"
                    style="background-size: 200% 100%; animation: shine 3s infinite linear;">
                </div>
            </div>
        </button>
    @empty
        <div class="sm:col-span-2 bg-theme-tertiary p-8 rounded-xl text-center">
            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-gray-800/50 flex items-center justify-center">
                <i data-lucide="alert-circle" class="w-8 h-8 text-gray-400"></i>
            </div>
            <h3 class="text-lg font-medium mb-2">{{ __('t.no_payment_methods') }}</h3>
            <p class="text-gray-400">{{ __('t.payment_methods_later') }}</p>
        </div>
    @endforelse
</div>
</div>





