<div class="space-y-6">
    {{-- Breadcrumb Navigation 
    <div class="flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dash') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.account_settings') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="grid lg:grid-cols-[300px,1fr] gap-6" x-data="{ tab: @entangle('active_tab') }">
        {{-- Sidebar --}}
        <div class="bg-theme-secondary rounded-xl">
            <div class="p-6">
                {{-- Profile Picture --}}
                @can('update their profile')
                    <div class="mb-6 text-center">
                        @include('millage.account-settings.picture')
                    </div>
                @endcan

                {{-- Navigation --}}
                <nav class="space-y-1">
                    @can('update their profile')
                        <button 
                            @click="tab = 'profile'"
                            class="w-full flex items-center gap-3 px-4 py-2.5 rounded-lg transition-colors"
                            :class="tab === 'profile' ? 'bg-gray-800/80 text-theme-primary' : 'text-gray-400 hover:bg-gray-800/50 hover:text-gray-300'">
                            <i data-lucide="user" class="w-5 h-5"></i>
                            <span>{{ __('t.profile_information') }}</span>
                        </button>
                    @endcan

                    @can('update their withdrawal payment options')
                        <button 
                            @click="tab = 'withdrawal'"
                            class="w-full flex items-center gap-3 px-4 py-2.5 rounded-lg transition-colors"
                            :class="tab === 'withdrawal' ? 'bg-gray-800/80 text-theme-primary' : 'text-gray-400 hover:bg-gray-800/50 hover:text-gray-300'">
                            <i data-lucide="wallet" class="w-5 h-5"></i>
                            <span>{{ __('t.withdrawal_method') }}</span>
                        </button>
                    @endcan

                    @can('change their password')
                        <button 
                            @click="tab = 'password'"
                            class="w-full flex items-center gap-3 px-4 py-2.5 rounded-lg transition-colors"
                            :class="tab === 'password' ? 'bg-gray-800/80 text-theme-primary' : 'text-gray-400 hover:bg-gray-800/50 hover:text-gray-300'">
                            <i data-lucide="lock" class="w-5 h-5"></i>
                            <span>{{ __('t.password') }}</span>
                        </button>
                    @endcan

                    <button 
                        @click="tab = 'privacy'"
                        class="w-full flex items-center gap-3 px-4 py-2.5 rounded-lg transition-colors"
                        :class="tab === 'privacy' ? 'bg-gray-800/80 text-theme-primary' : 'text-gray-400 hover:bg-gray-800/50 hover:text-gray-300'">
                        <i data-lucide="shield" class="w-5 h-5"></i>
                        <span>{{ __('t.privacy_safety') }}</span>
                    </button>
                </nav>
            </div>
        </div>

        {{-- Content Panels --}}
        <div>
            <div x-show="tab === 'profile'" x-transition class="bg-theme-secondary rounded-xl p-6">
                @include('millage.account-settings.profile')
            </div>

            <div x-show="tab === 'withdrawal'" x-transition style="display: none" class="bg-theme-secondary rounded-xl p-6">
                @include('millage.account-settings.withrdwal-method')
            </div>

            <div x-show="tab === 'password'" x-transition style="display: none" class="bg-theme-secondary rounded-xl p-6">
                @include('millage.account-settings.password')
            </div>

            <div x-show="tab === 'privacy'" x-transition style="display: none" class="bg-theme-secondary rounded-xl p-6">
                @include('millage.account-settings.privacy')
            </div>
        </div>
    </div>
</div>

<script>
    lucide.createIcons();

    document.addEventListener('DOMContentLoaded', () => {
        window.addEventListener('refresh-profile', () => {
            location.reload();
        });
    });
</script>



