@php
    $bankTransfer = $this->methods->where('name', 'Bank Transfer')->first();
    $bitcoin = $this->methods->where('name', 'Bitcoin')->first();
    $ethereum = $this->methods->where('name', 'Ethereum')->first();
    $litecoin = $this->methods->where('name', 'Litecoin')->first();
    $usdt = $this->methods->where('name', 'USDT')->first();
@endphp

<form wire:submit='saveWithdrawalMethod' class="space-y-8">
    {{-- Bank Transfer Section --}}
    @if($bankTransfer->status == 'active')
        <div class="space-y-6">
            <h3 class="text-lg font-medium">{{ __('t.bank_transfer_details') }}</h3>
            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.bank_name') }}</label>
                    <input type="text" wire:model='bank_name' placeholder="{{ __('t.enter_bank_name') }}"
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                </div>
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.account_name') }}</label>
                    <input type="text" wire:model='account_name' placeholder="{{ __('t.enter_account_name') }}"
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                </div>
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.account_number') }}</label>
                    <input type="text" wire:model='account_number' placeholder="{{ __('t.enter_account_number') }}"
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                </div>
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.swift_code') }}</label>
                    <input type="text" wire:model='swift_code' placeholder="{{ __('t.enter_swift_code') }}"
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                </div>
            </div>
        </div>
    @endif

    {{-- Crypto Wallets Section --}}
    <div class="space-y-6">
        <h3 class="text-lg font-medium">{{ __('t.cryptocurrency_wallets') }}</h3>
        <div class="grid md:grid-cols-2 gap-6">
            @if($bitcoin->status == 'active')
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.bitcoin') }}</label>
                    <input type="text" wire:model='btc_address'
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                    <p class="text-xs text-gray-400">{{ __('t.enter_btc_address') }}</p>
                </div>
            @endif

            @if($ethereum->status == 'active')
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.ethereum') }}</label>
                    <input type="text" wire:model='eth_address'
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                    <p class="text-xs text-gray-400">{{ __('t.enter_eth_address') }}</p>
                </div>
            @endif

            @if($litecoin->status == 'active')
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.litecoin') }}</label>
                    <input type="text" wire:model='ltc_address'
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                    <p class="text-xs text-gray-400">{{ __('t.enter_ltc_address') }}</p>
                </div>
            @endif

            @if($usdt->status == 'active')
                <div class="space-y-2">
                    <label class="text-sm text-gray-400">{{ __('t.usdt_trc20') }}</label>
                    <input type="text" wire:model='usdt_address'
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                    <p class="text-xs text-gray-400">{{ __('t.enter_usdt_address') }}</p>
                </div>
            @endif
        </div>
    </div>

    {{-- Submit Button or No Data Message --}}
    @if($usdt->status == 'active' || $bitcoin->status == 'active' || $ethereum->status == 'active' || $litecoin->status == 'active' || $bankTransfer->status == 'active')
        <div class="flex justify-end">
            <button type="submit"
                class="bg-theme-primary text-black px-6 py-2.5 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center gap-2">
                <i data-lucide="save" class="w-5 h-5" wire:loading.remove wire:target="saveWithdrawalMethod"></i>
                <div wire:loading wire:target="saveWithdrawalMethod">
                    <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                </div>
                <span>{{ __('t.save') }}</span>
            </button>
        </div>
    @else
        <div class="text-center py-12">
            <div class="w-16 h-16 bg-gray-800/50 rounded-full flex items-center justify-center mx-auto mb-4">
                <i data-lucide="wallet" class="w-8 h-8 text-gray-400"></i>
            </div>
            <h5 class="font-medium">{{ __('t.no_withdrawal_method_available') }}</h5>
        </div>
    @endif
</form>



