<div class="w-full p-2 mb-5 md:mb-1">
    <x-danger-alert />
    <x-success-alert />
    
    {{-- Header Card --}}
    <div class="bg-theme-secondary rounded-2xl mb-6">
        <div class="p-6 border-b border-[#1A1428]">
            <div class="flex flex-col sm:flex-row justify-between items-start gap-4">
                {{-- Plan Info --}}
                <div class="space-y-4">
                    <div class="flex items-center gap-3">
                        <div class="bg-theme-tertiary p-3 rounded-xl">
                            <i data-lucide="trending-up" class="w-6 h-6 text-theme-primary"></i>
                        </div>
                        <div>
                            <h2 class="text-xl font-medium">{{ $plan->plan->name }}</h2>
                            <div class="text-sm text-gray-400">{{ $roiInfo }} {{ __('t.for') }} {{ $plan->plan->duration }}</div>
                        </div>
                    </div>
                    @if ($plan->status == 'active')
                        <div class="flex items-center gap-2 px-3 py-1.5 rounded-xl bg-theme-primary/10 text-theme-primary w-fit">
                            <i data-lucide="activity" class="w-4 h-4"></i>
                            <span>{{ __('t.active_plan') }}</span>
                        </div>
                    @elseif($plan->status == 'expired')
                        <div class="flex items-center gap-2 px-3 py-1.5 rounded-xl bg-red-400/10 text-red-400 w-fit">
                            <i data-lucide="clock" class="w-4 h-4"></i>
                            <span>{{ __('t.expired') }}</span>
                        </div>
                    @else
                        <div class="flex items-center gap-2 px-3 py-1.5 rounded-xl bg-red-400/10 text-red-400 w-fit">
                            <i data-lucide="x-circle" class="w-4 h-4"></i>
                            <span>{{ __('t.inactive') }}</span>
                        </div>
                    @endif
                </div>

                {{-- Cancel Button --}}
                @if ($settings->should_cancel_plan && $plan->status == 'active')
                    <button 
                        wire:click='cancelPlan'
                        wire:loading.attr="disabled"
                        class="group bg-theme-tertiary hover:bg-red-500/10 text-red-500 px-4 py-2 rounded-xl transition-colors">
                        <div wire:loading wire:target="cancelPlan">
                            <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                        </div>
                        <div class="flex items-center gap-2" wire:loading.remove wire:target="cancelPlan">
                            <i data-lucide="x-circle" class="w-5 h-5"></i>
                            <span>{{ __('t.cancel_plan') }}</span>
                        </div>
                    </button>
                @endif
            </div>
        </div>

        {{-- Investment Stats --}}
        <div class="grid md:grid-cols-3 divide-y md:divide-y-0 md:divide-x divide-[#1A1428]">
            <div class="p-6 text-center">
                <div class="mb-1 text-sm text-gray-400">{{ __('t.invested_amount') }}</div>
                <div class="text-2xl font-medium">{{ Number::currency($plan->amount, $settings->s_currency) }}</div>
            </div>
            <div class="p-6 text-center">
                <div class="mb-1 text-sm text-gray-400">{{ __('t.profit_earned') }}</div>
                <div class="text-2xl font-medium text-theme-primary">{{ Number::currency($plan->profit_earned, $settings->s_currency) }}</div>
            </div>
            <div class="p-6 text-center">
                <div class="mb-1 text-sm text-gray-400">{{ __('t.total_return') }}</div>
                <div class="text-2xl font-medium text-theme-primary">
                    @if ($settings->return_capital)
                        {{ Number::currency($plan->amount + $plan->profit_earned, $settings->s_currency) }}
                    @else
                        {{ Number::currency($plan->profit_earned, $settings->s_currency) }}
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- Details Grid --}}
    <div class="grid md:grid-cols-2 gap-6 mb-6">
        <div class="bg-theme-secondary rounded-2xl p-6">
            <h3 class="text-lg font-medium mb-4">{{ __('t.plan_information') }}</h3>
            <div class="space-y-4">
                <div class="flex items-center gap-3">
                    <div class="bg-theme-tertiary p-2 rounded-lg">
                        <i data-lucide="calendar" class="w-4 h-4 text-theme-primary"></i>
                    </div>
                    <div>
                        <div class="text-sm text-gray-400">{{ __('t.duration') }}</div>
                        <div class="font-medium">{{ $plan->plan->duration }}</div>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <div class="bg-theme-tertiary p-2 rounded-lg">
                        <i data-lucide="percent" class="w-4 h-4 text-theme-primary"></i>
                    </div>
                    <div>
                        <div class="text-sm text-gray-400">{{ __('t.roi_range') }}</div>
                        <div class="font-medium">{{ $plan->plan->min_return }}% - {{ $plan->plan->max_return }}%</div>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <div class="bg-theme-tertiary p-2 rounded-lg">
                        <i data-lucide="refresh-cw" class="w-4 h-4 text-theme-primary"></i>
                    </div>
                    <div>
                        <div class="text-sm text-gray-400">{{ __('t.roi_interval') }}</div>
                        <div class="font-medium">{{ $plan->plan->increment_interval }}</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-theme-secondary rounded-2xl p-6">
            <h3 class="text-lg font-medium mb-4">{{ __('t.timeline') }}</h3>
            <div class="space-y-4">
                <div class="flex items-center gap-3">
                    <div class="bg-theme-tertiary p-2 rounded-lg">
                        <i data-lucide="play" class="w-4 h-4 text-theme-primary"></i>
                    </div>
                    <div>
                        <div class="text-sm text-gray-400">{{ __('t.started') }}</div>
                        <div class="font-medium">{{ $plan->created_at->format('M d, Y h:i A') }}</div>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <div class="bg-theme-tertiary p-2 rounded-lg">
                        <i data-lucide="flag" class="w-4 h-4 text-theme-primary"></i>
                    </div>
                    <div>
                        <div class="text-sm text-gray-400">{{ __('t.ends') }}</div>
                        <div class="font-medium">{{ $plan->expire_date->format('M d, Y h:i A') }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- ROI History --}}
    @can('see profit history')
    <div class="bg-theme-secondary rounded-2xl">
        <div class="p-6 border-b border-[#1A1428]">
            <h3 class="text-lg font-medium">{{ __('t.roi_history') }}</h3>
        </div>
        <div class="p-6">
            <div class="relative overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-left text-sm text-gray-400 border-b border-[#1A1428]">
                            <th class="pb-3 font-medium">{{ __('t.amount') }}</th>
                            <th class="pb-3 font-medium text-right">{{ __('t.date') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#1A1428]">
                        @forelse($roiHistory as $history)
                            <tr>
                                <td class="py-4">
                                    <div class="flex items-center gap-2">
                                        <i data-lucide="plus-circle" class="w-4 h-4 text-theme-primary"></i>
                                        <span>{{ Number::currency($history->amount, $settings->s_currency) }}</span>
                                    </div>
                                </td>
                                <td class="py-4 text-right text-gray-400">{{ $history->created_at->format('M d, Y h:i A') }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="2" class="py-8 text-center text-gray-400">
                                    <i data-lucide="inbox" class="w-8 h-8 mx-auto mb-2 opacity-50"></i>
                                    <p>{{ __('t.no_roi_records_yet') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $roiHistory->links() }}
            </div>
        </div>
    </div>
    @endcan
</div>



