<div x-data="{ privacy: 'twofactor' }" class="space-y-6">
    
    <nav class="flex justify-center border-b border-gray-800">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('use two-factor authentication')): ?>
            <button 
                @click="privacy = 'twofactor'"
                class="px-6 py-3 transition-colors"
                :class="privacy === 'twofactor' ? 'text-theme-primary border-b-2 border-theme-primary' : 'text-gray-400 hover:text-gray-300'">
                <?php echo e(__('t.2fa')); ?>

            </button>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage browser sessions')): ?>
            <button 
                @click="privacy = 'browser_sessions'"
                class="px-6 py-3 transition-colors"
                :class="privacy === 'browser_sessions' ? 'text-theme-primary border-b-2 border-theme-primary' : 'text-gray-400 hover:text-gray-300'">
                <?php echo e(__('t.browser')); ?>

            </button>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete their account')): ?>
            <button 
                @click="privacy = 'delete_account'"
                class="px-6 py-3 transition-colors"
                :class="privacy === 'delete_account' ? 'text-theme-primary border-b-2 border-theme-primary' : 'text-gray-400 hover:text-gray-300'">
               <?php echo e(__('t.delete_acc')); ?>

            </button>
        <?php endif; ?>
    </nav>

    
    <div class="pt-4">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('use two-factor authentication')): ?>
            <div x-show="privacy === 'twofactor'" x-transition>
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('profile.two-factor-authentication-form');

$__html = app('livewire')->mount($__name, $__params, 'lw-2481320672-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        <?php endif; ?>

        <div x-show="privacy === 'browser_sessions'" x-transition style="display: none">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('profile.logout-other-browser-sessions-form');

$__html = app('livewire')->mount($__name, $__params, 'lw-2481320672-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>

        <div x-show="privacy === 'delete_account'" x-transition style="display: none">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('profile.delete-user-form');

$__html = app('livewire')->mount($__name, $__params, 'lw-2481320672-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    </div>
</div>



<?php /**PATH /home/ooqnzyma/diversifymarkets.com/resources/views/millage/account-settings/privacy.blade.php ENDPATH**/ ?>