<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
   <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
   <link rel="shortcut icon" href="<?php echo e(asset($settings->favicon)); ?>" />
   <title><?php echo e($settings->site_name); ?> - <?php echo e($title); ?></title>
   <meta name="description" content="<?php echo e($settings->description); ?>" />
   <meta name="keywords" content="<?php echo e($settings->keywords); ?>" />
   
   
   <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
   
   
   <link rel="stylesheet" href="<?php echo e(route('theme-colors-css')); ?>" />
   
   
   <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
   
   
   <script src="https://unpkg.com/lucide@latest"></script>
   <script src="https://cdn.tailwindcss.com"></script>
   
   
   <?php if (isset($component)) { $__componentOriginal0da7fdd230d9910d3b064fc625b672b8 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0da7fdd230d9910d3b064fc625b672b8 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.theme-colors','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('theme-colors'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0da7fdd230d9910d3b064fc625b672b8)): ?>
<?php $attributes = $__attributesOriginal0da7fdd230d9910d3b064fc625b672b8; ?>
<?php unset($__attributesOriginal0da7fdd230d9910d3b064fc625b672b8); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0da7fdd230d9910d3b064fc625b672b8)): ?>
<?php $component = $__componentOriginal0da7fdd230d9910d3b064fc625b672b8; ?>
<?php unset($__componentOriginal0da7fdd230d9910d3b064fc625b672b8); ?>
<?php endif; ?>
           theme: {
               extend: {
                   fontFamily: {
                       sans: ['Inter', 'sans-serif'],
                   },
                   colors: {
                       background: '#0A0714',
                   }
               }
           }
       }
   </script>
   <style>
       @keyframes floatCard1 {
           0%, 100% { transform: translate(-50%, -50%) rotate(-5deg) translateY(-20px); }
           50% { transform: translate(-50%, -50%) rotate(-5deg) translateY(0px); }
       }

       @keyframes floatCard2 {
           0%, 100% { transform: translate(-50%, -50%) rotate(5deg) translateY(0px); }
           50% { transform: translate(-50%, -50%) rotate(5deg) translateY(-20px); }
       }

       @keyframes floatCard3 {
           0%, 100% { transform: translate(-50%, -50%) rotate(-8deg) translateY(0px); }
           50% { transform: translate(-50%, -50%) rotate(-8deg) translateY(-20px); }
       }

       @keyframes float {
           0%, 100% { transform: translateY(0px); }
           50% { transform: translateY(-10px); }
       }

       @keyframes fadeIn {
           from { opacity: 0; transform: translateY(20px); }
           to { opacity: 1; transform: translateY(0); }
       }

       @keyframes pulse {
           0%, 100% { opacity: 1; }
           50% { opacity: 0.5; }
       }

       .perspective-1000 {
           perspective: 1000px;
       }

       .animate-float-card-1 {
           animation: floatCard1 4s ease-in-out infinite;
       }

       .animate-float-card-2 {
           animation: floatCard2 4s ease-in-out infinite;
       }

       .animate-float-card-3 {
           animation: floatCard3 4s ease-in-out infinite;
       }

       .animate-float {
           animation: float 3s ease-in-out infinite;
       }

       .animate-fade-in {
           animation: fadeIn 1s ease-out forwards;
       }

       .animate-pulse-slow {
           animation: pulse 2s ease-in-out infinite;
       }
   </style>
   <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>
<body class="bg-background text-gray-100 antialiased">
   <div class="min-h-screen">
       <div class="flex min-h-screen">
           
           <div class="hidden lg:flex lg:w-1/2 relative bg-theme-secondary">
               <div class="absolute inset-0 bg-gradient-to-b from-theme-primary/5 to-transparent"></div>
               
               <div class="relative w-full flex flex-col items-center justify-between p-12">
                   
                   <div class="relative z-10 w-full">
                       <img 
                           alt="Logo" 
                           src="<?php echo e(asset($settings->logo)); ?>"
                           class="w-40 h-auto"
                       />
                   </div>

                   
                   <div class="text-center relative perspective-1000 min-h-[400px] w-full">
                       
                       <div class="absolute top-1/2 left-[30%] -translate-x-1/2 -translate-y-1/2 transform-gpu animate-float-card-1">
                           <div class="bg-theme-tertiary/80 backdrop-blur-lg rounded-2xl p-6 border border-theme-primary/20 shadow-xl">
                               <div class="w-16 h-16 mx-auto bg-theme-primary/10 rounded-xl flex items-center justify-center mb-4">
                                   <i class="fas fa-chart-line text-theme-primary text-2xl"></i>
                               </div>
                               <h3 class="text-xl font-medium text-theme-primary">Smart Trading</h3>
                           </div>
                       </div>

                       
                       <div class="absolute top-1/2 left-[70%] -translate-x-1/2 -translate-y-1/2 transform-gpu animate-float-card-2">
                           <div class="bg-theme-tertiary/80 backdrop-blur-lg rounded-2xl p-6 border border-theme-primary/20 shadow-xl">
                               <div class="w-16 h-16 mx-auto bg-theme-primary/10 rounded-xl flex items-center justify-center mb-4">
                                   <i class="fas fa-wallet text-theme-primary text-2xl"></i>
                               </div>
                               <h3 class="text-xl font-medium text-theme-primary">Secure Wallet</h3>
                           </div>
                       </div>

                       
                       <div class="absolute top-[30%] left-1/2 -translate-x-1/2 -translate-y-1/2 transform-gpu animate-float-card-3">
                           <div class="bg-theme-tertiary/80 backdrop-blur-lg rounded-2xl p-6 border border-theme-primary/20 shadow-xl">
                               <div class="w-16 h-16 mx-auto bg-theme-primary/10 rounded-xl flex items-center justify-center mb-4">
                                   <i class="fas fa-signal text-theme-primary text-2xl"></i>
                               </div>
                               <h3 class="text-xl font-medium text-theme-primary">Real-time Analytics</h3>
                           </div>
                       </div>

                       <div class="relative z-10 space-y-8">
                           <div class="space-y-4 animate-fade-in">
                               
                               <div class="flex justify-center gap-8 mt-8">
                                   <div class="text-center animate-pulse-slow">
                                       <div class="text-2xl font-bold text-theme-primary">24/7</div>
                                       <div class="text-sm text-gray-400">Support</div>
                                   </div>
                                   <div class="text-center animate-pulse-slow" style="animation-delay: 0.2s">
                                       <div class="text-2xl font-bold text-theme-primary">100+</div>
                                       <div class="text-sm text-gray-400">Markets</div>
                                   </div>
                                   <div class="text-center animate-pulse-slow" style="animation-delay: 0.4s">
                                       <div class="text-2xl font-bold text-theme-primary">0.1%</div>
                                       <div class="text-sm text-gray-400">Trading Fee</div>
                                   </div>
                               </div>
                           </div>
                       </div>
                   </div>

                   
                   <div class="grid grid-cols-3 gap-4 w-full">
                       <div class="bg-theme-tertiary rounded-xl p-4 flex items-center justify-center">
                           <i class="fas fa-shield-alt text-theme-primary text-xl"></i>
                       </div>
                       <div class="bg-theme-tertiary rounded-xl p-4 flex items-center justify-center">
                           <i class="fas fa-lock text-theme-primary text-xl"></i>
                       </div>
                       <div class="bg-theme-tertiary rounded-xl p-4 flex items-center justify-center">
                           <i class="fas fa-fingerprint text-theme-primary text-xl"></i>
                       </div>
                   </div>
               </div>
           </div>

           
           <div class="w-full lg:w-1/2 flex items-center justify-center p-6">
               <div class="w-full max-w-md">
                   <?php echo e($slot); ?>

               </div>
           </div>
       </div>
   </div>
   <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

   <script>
     document.addEventListener('DOMContentLoaded', () => {
            lucide.createIcons();

            window.locale = '<?php echo e(app()->getLocale()); ?>';
            window.translations = <?php echo json_encode(__('investment'), 15, 512) ?>;
        });
   </script>
</body>
</html>




<?php /**PATH C:\xampp\htdocs\6figstrade\resources\views/layouts/guest.blade.php ENDPATH**/ ?>