import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';
import typography from '@tailwindcss/typography';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './vendor/laravel/jetstream/**/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                // Primary theme colors using CSS variables
                'primary': {
                    50: 'rgb(var(--color-primary-50) / <alpha-value>)',
                    100: 'rgb(var(--color-primary-100) / <alpha-value>)',
                    200: 'rgb(var(--color-primary-200) / <alpha-value>)',
                    300: 'rgb(var(--color-primary-300) / <alpha-value>)',
                    400: 'rgb(var(--color-primary-400) / <alpha-value>)',
                    500: 'rgb(var(--color-primary-500) / <alpha-value>)',
                    600: 'rgb(var(--color-primary-600) / <alpha-value>)',
                    700: 'rgb(var(--color-primary-700) / <alpha-value>)',
                    800: 'rgb(var(--color-primary-800) / <alpha-value>)',
                    900: 'rgb(var(--color-primary-900) / <alpha-value>)',
                    DEFAULT: 'var(--color-primary)',
                },
                // Background colors
                'background': {
                    DEFAULT: 'var(--color-background)',
                    secondary: 'var(--color-background-secondary)',
                    tertiary: 'var(--color-background-tertiary)',
                    quaternary: 'var(--color-background-quaternary)',
                },
                // Text colors
                'text': {
                    primary: 'var(--color-text-primary)',
                    secondary: 'var(--color-text-secondary)',
                    muted: 'var(--color-text-muted)',
                    disabled: 'var(--color-text-disabled)',
                },
                // Border colors
                'border': {
                    primary: 'var(--color-border-primary)',
                    secondary: 'var(--color-border-secondary)',
                    muted: 'var(--color-border-muted)',
                },
                // Status colors
                'success': {
                    DEFAULT: 'var(--color-success)',
                    light: 'var(--color-success-light)',
                    dark: 'var(--color-success-dark)',
                },
                'warning': {
                    DEFAULT: 'var(--color-warning)',
                    light: 'var(--color-warning-light)',
                    dark: 'var(--color-warning-dark)',
                },
                'error': {
                    DEFAULT: 'var(--color-error)',
                    light: 'var(--color-error-light)',
                    dark: 'var(--color-error-dark)',
                },
                'info': {
                    DEFAULT: 'var(--color-info)',
                    light: 'var(--color-info-light)',
                    dark: 'var(--color-info-dark)',
                },
            },
            backgroundColor: {
                'primary-5': 'var(--color-primary-5)',
                'primary-10': 'var(--color-primary-10)',
                'primary-20': 'var(--color-primary-20)',
                'primary-30': 'var(--color-primary-30)',
                'primary-80': 'var(--color-primary-80)',
            },
            backgroundImage: {
                'gradient-primary': 'var(--gradient-primary)',
                'gradient-background': 'var(--gradient-background)',
            },
            boxShadow: {
                'primary': 'var(--shadow-primary)',
                'secondary': 'var(--shadow-secondary)',
            },
        },
    },

    plugins: [forms, typography],
};
