<header class="w-full flex items-center justify-between p-4 bg-white dark:bg-[#0F0A1F] border-b border-gray-100/50 dark:border-gray-800/50">
    {{-- Logo Section --}}
    <div class="flex items-center gap-4">
        <img src="{{ asset('storage/' . $settings->logo) }}" alt="{{ $settings->site_name }}" class="h-8">
    </div>

    {{-- Actions Section --}}
    <div class="flex items-center gap-2">
        {{-- Language Selector --}}
        <div class="relative" id="languageDropdown">
            <button class="flex items-center gap-2 bg-gray-100 dark:bg-[#1A1428] rounded-xl px-3 py-2 text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-300 transition-colors">
                @php
                    $currentLocale = app()->getLocale();
                    $flags = [
                        'en' => '&#x1F1FA;&#x1F1F8;',
                        'es' => '&#x1F1EA;&#x1F1F8;',
                        'fr' => '&#x1F1EB;&#x1F1F7;'
                    ];
                @endphp
                <span class="mr-1">{!! $flags[$currentLocale] ?? $flags['en'] !!}</span>
                {{ strtoupper($currentLocale) }}
                <i class="fas fa-chevron-down w-4 h-4"></i>
            </button>
            <div id="languageMenu" 
                class="absolute right-0 mt-2 w-48 bg-white dark:bg-[#1A1428] rounded-xl border border-gray-100/50 dark:border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                @foreach(config('app.available_locales') as $locale => $name)
                    <a href="{{ route('language.switch', $locale) }}" 
                        class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#2A243B] hover:text-gray-900 dark:hover:text-gray-300 transition-colors">
                        <span>{!! $flags[$locale] ?? $flags['en'] !!}</span>
                        {{ $name }}
                    </a>
                @endforeach
            </div>
        </div>
         {{-- Notifications --}}
<div class="relative" id="notificationDropdown">
   <button class="relative p-2 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-300 transition-colors rounded-xl hover:bg-gray-100 dark:hover:bg-[#1A1428]">
       <i class="fas fa-bell w-5 h-5"></i>
       <livewire:user.notifications-count />
   </button>
   <div id="notificationMenu" 
       class="absolute right-0 mt-2 w-80 bg-white dark:bg-[#1A1428] rounded-xl border border-gray-100/50 dark:border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
       <div class="p-4">
           <div class="space-y-4">
               @forelse(auth()->user()->notifications()->latest()->take(3)->get() as $notification)
                   <div class="flex items-start gap-3 pb-4 border-b border-gray-100/50 dark:border-gray-800/50 last:border-0 last:pb-0">
                       {{-- Notification Icon --}}
                       <div class="w-8 h-8 flex-shrink-0 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 rounded-xl flex items-center justify-center">
                           @switch($notification->data['type'] ?? 'default')
                               @case('deposit')
                                   <i class="fas fa-arrow-down text-cyan-500 dark:text-[#2FE6DE] w-4 h-4"></i>
                                   @break
                               @case('withdrawal')
                                   <i class="fas fa-arrow-up text-cyan-500 dark:text-[#2FE6DE] w-4 h-4"></i>
                                   @break
                               @case('investment')
                                   <i class="fas fa-chart-line text-cyan-500 dark:text-[#2FE6DE] w-4 h-4"></i>
                                   @break
                               @case('roi')
                                   <i class="fas fa-piggy-bank text-cyan-500 dark:text-[#2FE6DE] w-4 h-4"></i>
                                   @break
                               @default
                                   <i class="fas fa-bell text-cyan-500 dark:text-[#2FE6DE] w-4 h-4"></i>
                           @endswitch
                       </div>
                       
                       <div class="flex-1 min-w-0">
                           <p class="text-sm text-gray-900 dark:text-gray-300">{{ $notification->data['message'] }}</p>
                           <span class="text-xs text-gray-500">{{ $notification->created_at->diffForHumans() }}</span>
                       </div>
                   </div>
               @empty
                   <div class="text-center py-6">
                       <div class="w-12 h-12 mx-auto mb-3 bg-gray-100/50 dark:bg-gray-800/50 rounded-xl flex items-center justify-center">
                           <i class="fas fa-bell-slash text-gray-400 w-6 h-6"></i>
                       </div>
                       <p class="text-sm text-gray-600 dark:text-gray-400">No new notifications</p>
                   </div>
               @endforelse
           </div>

           {{-- View All Link --}}
           @if(auth()->user()->notifications()->count() > 0)
               <div class="mt-4 pt-4 border-t border-gray-100/50 dark:border-gray-800/50">
                   <a href="{{ route('user.notifications') }}" 
                       @if($settings->spa_mode) wire:navigate @endif
                       class="block w-full bg-gray-100 dark:bg-[#1A1428] text-cyan-500 dark:text-[#2FE6DE] text-center text-sm font-medium px-4 py-2.5 rounded-xl hover:bg-gray-200 dark:hover:bg-[#2A243B] transition-colors">
                       View All Notifications
                   </a>
               </div>
           @endif
       </div>
   </div>
</div>

        {{-- Annual Reports --}}
        <div class="relative" id="reportsDropdown">
            <button class="p-2 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-300 transition-colors rounded-xl hover:bg-gray-100 dark:hover:bg-[#1A1428]">
                <i class="fas fa-file-alt w-5 h-5"></i>
            </button>
            <div id="reportsMenu" 
                class="absolute right-0 mt-2 w-64 bg-white dark:bg-[#1A1428] rounded-xl border border-gray-100/50 dark:border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4">
                    <h3 class="text-sm font-medium text-gray-900 dark:text-gray-300 mb-2">Annual Reports</h3>
                    <div class="space-y-1">
                        @forelse(\App\Models\AnnualReport::where('is_active', true)->orderBy('report_year', 'desc')->get() as $report)
                            <a href="{{ Storage::url($report->file_path) }}" 
                                target="_blank"
                                class="flex items-center gap-3 px-3 py-2 text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-300 hover:bg-gray-100 dark:hover:bg-[#2A243B] rounded-lg transition-colors">
                                <i class="fas fa-download w-4 h-4"></i>
                                {{ $report->name }}
                            </a>
                        @empty
                            <p class="text-sm text-gray-600 dark:text-gray-400 px-3 py-2">No reports available</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        {{-- User Profile --}}
        <div class="relative" id="userDropdown">
            <button class="p-2 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-300 transition-colors rounded-xl hover:bg-gray-100 dark:hover:bg-[#1A1428]">
                <i class="fas fa-user w-5 h-5"></i>
            </button>
            <div id="userMenu" 
                class="absolute right-0 mt-2 w-64 bg-white dark:bg-[#1A1428] rounded-xl border border-gray-100/50 dark:border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4 border-b border-gray-100/50 dark:border-gray-800/50">
                    <h3 class="font-medium text-gray-900 dark:text-white truncate">{{ auth()->user()->name }}</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 truncate">{{ auth()->user()->email }}</p>
                </div>

                 {{-- Account Status Section --}}
              @if($settings->enable_kyc)
<div class="p-4 border-b border-gray-100/50 dark:border-gray-800/50 bg-gray-50/50 dark:bg-[#2A243B]/50">
   <div class="flex items-center justify-between gap-2">
       <span class="text-sm text-gray-600 dark:text-gray-400">Account Status</span>
       @if(Auth::user()->account_verify == 'verified')
           <span class="text-xs font-medium px-2 py-1 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 text-cyan-500 dark:text-[#2FE6DE] rounded-lg">Verified</span>
       @else
           <a href="{{ route('user.kyc.start') }}"
               @if($settings->spa_mode) wire:navigate @endif 
               class="text-xs font-medium px-2 py-1 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 text-cyan-500 dark:text-[#2FE6DE] rounded-lg hover:bg-cyan-500/20 dark:hover:bg-[#2FE6DE]/20 transition-colors">
               Verify Now
           </a>
       @endif
   </div>
</div>
@endif
<div class="p-2">
   <a href="{{ route('user.profile.show') }}" 
       @if($settings->spa_mode) wire:navigate @endif
       class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-300 rounded-lg hover:bg-gray-100 dark:hover:bg-[#2A243B] transition-colors">
       <i class="fas fa-cog w-4 h-4"></i>
       Settings
   </a>
   <form action="{{ route('logout') }}" method="POST">
       @csrf
       <button type="submit" 
           class="w-full flex items-center gap-3 px-4 py-2.5 text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-300 rounded-lg hover:bg-gray-100 dark:hover:bg-[#2A243B] transition-colors">
           <i class="fas fa-sign-out-alt w-4 h-4"></i>
           Logout
       </button>
   </form>
</div>
            </div>
        </div>
    </div>
</header>
<script>
    // Dropdown toggles
    function setupDropdown(triggerId, menuId) {
        const trigger = document.getElementById(triggerId);
        const menu = document.getElementById(menuId);
        
        if (trigger && menu) {
            trigger.addEventListener('click', (e) => {
                e.stopPropagation();
                menu.classList.toggle('hidden');
            });

            document.addEventListener('click', () => {
                menu.classList.add('hidden');
            });
        }
    }

    // Setup all dropdowns
    document.addEventListener('DOMContentLoaded', function() {
        setupDropdown('reportsDropdown', 'reportsMenu');
    });
</script>